#ifndef GTK_GUI_H__INCLUDED
#define GTK_GUI_H__INCLUDED

#ifdef HAVE_CONFIG_H
#   include "config.h"
#endif

#ifdef INCLUDE_XLOCALE
#   include <X11/Xlocale.h>
#endif

#define XLFD_MAX_FIELD_LEN 64

#ifdef USE_GNOME
#   include <gnome.h>
#   include <libgnomeui/gnome-window-icon.h>
#else
#   include <gtk/gtk.h>
#endif

#ifdef USE_PSPELL
    #define USE_ORIGINAL_MANAGER_FUNCS
    #include <pspell/pspell.h>
#endif

#include <glib.h>

#include "licq_constants.h"
#include "licq_events.h"
#include "licq_icq.h"
#include "licq_icqd.h"
#include "licq_user.h"
#include "licq_utility.h"               

#include "support.h"
#include "messagedlg.h"
#include "init.h"
#include "callbacks.h"
#include "gtk_licq_buttons.h"

#define VERSION_NAME        _("Millenium Edition")
#define GTK_GUI_STATUS      _("running")
#define GTK_GUI_DESCRIPTION _("Snaggen and Pele's GTK+ GUI for Licq")
#define GTK_GUI_USAGE       _("duh")
#define GTK_GUI_CONFIG_FILE "licq_gtk-gui.conf"

#define MODE_SEND       0
#define MODE_VIEW       1
#define MODE_UNSPEC     -1

#define SEND_MESSAGE    0
#define SEND_URL        1
#define SEND_CHAT       2 
#define SEND_FILE       3
#define SEND_CONTACTS   4

#define DCLICK_DELAY 250000
#define FIRST_COLUMN_WIDTH 15

#define GET_USER_OR_OWNER(UIN,MODE) ((UIN)==0||(UIN)==gUserManager.OwnerUin()?gUserManager.FetchOwner(MODE):gUserManager.FetchUser(UIN,MODE))

#ifdef LICQGTK_DEBUG
#define gbug(x, args...) { fprintf(stderr,"%-9s:%4d\t",__FILE__,__LINE__); \
        fprintf(stderr, x, ##args);}
#else
#define gbug(args...) ;
#endif /* LICQGTK_DEBUG */

#define ICQBACK_TO_GDK_COLOR(a,b)   (b).red=(a)->BackRed()<<8; \
                                    (b).green=(a)->BackGreen()<<8; \
                                    (b).blue=(a)->BackBlue()<<8;
#define ICQFORE_TO_GDK_COLOR(a,b)   (b).red=(a)->ForeRed()<<8; \
                                    (b).green=(a)->ForeGreen()<<8; \
                                    (b).blue=(a)->ForeBlue()<<8;
        
typedef struct GdkPixMask {
    GdkPixmap   *pix;
    GdkBitmap   *mask;
} GdkPixMask_t;

typedef struct {
    GtkWidget       *toplevel_sender;
    unsigned long   tag;
} send_eventdata_t;

typedef struct {
    unsigned long   uin;
    GtkWidget       *view_event_window;
    GtkWidget       *send_event_window;
    GtkWidget       *history_dialog;
    GtkWidget       *info_dialog;
    GList           *send_events;
    GdkPixMask_t    *status_icon;
    gchar           *last_away_mess;
#ifdef USE_PSPELL
    int             spell_enabled;
    int             spell_start_position;
    PspellManager   *spellmanager;
#endif
    GtkWidget       *floating_window;
} userdata_t;

    /*  Global darn variables */
    /*  init.cpp */
#ifdef USE_PSPELL
extern GList *dicts;
#endif
extern GdkPixMask_t    status_pixmap_away;
extern GdkPixMask_t    status_pixmap_chat;
extern GdkPixMask_t    status_pixmap_dnd;
extern GdkPixMask_t    status_pixmap_ffc;
extern GdkPixMask_t    status_pixmap_file;
extern GdkPixMask_t    status_pixmap_message;
extern GdkPixMask_t    status_pixmap_na;
extern GdkPixMask_t    status_pixmap_occupied;
extern GdkPixMask_t    status_pixmap_offline;
extern GdkPixMask_t    status_pixmap_online;
extern GdkPixMask_t    status_pixmap_private;
extern GdkPixMask_t    status_pixmap_url;
extern GdkPixMask_t    status_pixmap_contacts;
extern GdkPixMask_t    status_pixmap_authorize;
extern GdkPixMask_t    arrow_pixmap;
extern GdkPixMask_t    not_secure_on_pixmap;
extern GdkPixMask_t    secure_on_pixmap;
extern GdkPixMask_t    secure_off_pixmap;
extern GdkPixMask_t    close_pixmap;
extern GdkPixMask_t    info_pixmap;
extern GdkPixMask_t    history_pixmap;
extern GdkPixMask_t    select_foreground_pixmap;
extern GdkPixMask_t    select_background_pixmap;
extern GdkColor        statuscolor_online, statuscolor_offline, 
                       statuscolor_new, statuscolor_other, 
                       contactlist_background, historycolor_sent,
                       historycolor_received;
extern CIniFile        gui_confobject;
extern configuration_t configuration;
extern int             nopanel;
    /*  gkt-gui.cpp */ 
extern GtkWidget       *main_window;
extern CICQDaemon      *licq_daemon;
static int             noplacement=0;
    /*  contactlist.cpp */
extern int              contactlist_current_group;
    /*  src/callbacks.cpp */
extern GtkWidget       *groups_dialog;
extern unsigned long   current_uin;
    /*  src/autoresponse.cpp */
extern GtkWidget       *dialog_autoresponse;
    /*  src/search_dialog.cpp */
extern GtkWidget       *search_dialog;
    /*  src/passwd_dialog.cpp */
extern GtkWidget       *passwd_dialog;
    /*  src/plugin_dialog.cpp */
extern GtkWidget       *plugin_dialog;
    /*  src/options_dialog.cpp */
extern GtkWidget       *options_window;
    /*  src/network_dialog.cpp */
extern GtkWidget       *network_dialog;
    /*  src/randomchat_dialog.cpp */
extern GtkWidget       *random_chat_dialog;
    /*  src/registration_wizard.cpp */
extern GtkWidget   *registration_wizard_window;
    /* src/multiuser_chat.cpp */
extern GList *chat_sessions;

extern GdkFont *global_editor_font;

#ifdef USE_PANEL
    /* src/gnomedock.cpp */
extern GtkWidget       *panel_dockapp;
#endif

    /* Magic doubleclick on statusbar */
extern unsigned short  last_status;
    
    /* Autoback */
extern long screensaver_original_status;
#endif /* GTK-GUI_H__INCLUDED */
