#include "gtk-gui.h"
#include "gtk_licq_buttons.h"

GtkWidget *
gtk_licq_button                        (char        *label) 
{
    return(gtk_button_new_with_label(label));
}

void 
get_pixmap_and_label                   (button_type type, 
                                        GtkWidget   **widget, 
                                        char        **label)
{
    char *icon = NULL;
    GtkWidget *pixmap = NULL;
    button_type r_type;

    r_type = type & 0x7F;
    
    switch (r_type) {
        case GTK_LICQ_BUTTON_SEND:
#ifdef USE_GNOME
            icon = g_strdup(GNOME_STOCK_PIXMAP_MAIL_SND);
#endif
            *label = g_strdup(_("Send"));
            break;

        case GTK_LICQ_BUTTON_DETAILS:
#ifdef USE_GNOME
            //FIXME: suboptimal icon.
            icon = g_strdup(GNOME_STOCK_PIXMAP_PROPERTIES);
#endif
            *label = g_strdup(_("Details"));
            break;

        case GTK_LICQ_BUTTON_OK:
#ifdef USE_GNOME
            pixmap = gnome_stock_pixmap_widget(NULL, GNOME_STOCK_BUTTON_OK);
#endif
            *label = g_strdup(_("OK"));
            break;

        case GTK_LICQ_BUTTON_CANCEL:
#ifdef USE_GNOME
            pixmap = gnome_stock_pixmap_widget(NULL, GNOME_STOCK_BUTTON_CANCEL);
#endif
            *label = g_strdup(_("Cancel"));
            break;

        case GTK_LICQ_BUTTON_YES:
#ifdef USE_GNOME
            pixmap = gnome_stock_pixmap_widget(NULL, GNOME_STOCK_BUTTON_YES);
#endif
            *label = g_strdup(_("Yes"));
            break;

        case GTK_LICQ_BUTTON_NO:
#ifdef USE_GNOME
            pixmap = gnome_stock_pixmap_widget(NULL, GNOME_STOCK_BUTTON_NO);
#endif
            *label = g_strdup(_("No"));
            break;

        case GTK_LICQ_BUTTON_DONE:
#ifdef USE_GNOME
            icon = g_strdup(GNOME_STOCK_PIXMAP_CLOSE);
#endif
            *label = g_strdup(_("Done"));
            break;

        case GTK_LICQ_BUTTON_SEARCH:
#ifdef USE_GNOME
            icon = g_strdup(GNOME_STOCK_PIXMAP_SEARCH);
#endif
            *label = g_strdup(_("Search"));
            break;

        case GTK_LICQ_BUTTON_CLEAR:
#ifdef USE_GNOME
            icon = g_strdup(GNOME_STOCK_PIXMAP_CLEAR);
#endif
            *label = g_strdup(_("Clear"));
            break;

        case GTK_LICQ_BUTTON_APPLY:
#ifdef USE_GNOME
            pixmap = gnome_stock_pixmap_widget(NULL, GNOME_STOCK_BUTTON_APPLY);
#endif
            *label = g_strdup(_("Apply"));
            break;

        case GTK_LICQ_BUTTON_UPDATE:
#ifdef USE_GNOME
            icon = g_strdup(GNOME_STOCK_PIXMAP_REFRESH);
#endif
            *label = g_strdup(_("Update"));
            break;

        case GTK_LICQ_BUTTON_SET:
#ifdef USE_GNOME
            //FIXME: Get an icon.
            icon = NULL;
#endif
            *label = g_strdup(_("Set"));
            break;

        case GTK_LICQ_BUTTON_SAVE:
#ifdef USE_GNOME
            icon = g_strdup(GNOME_STOCK_PIXMAP_SAVE);
#endif
            *label = g_strdup(_("Save"));
            break;

        case GTK_LICQ_BUTTON_BROWSE:
#ifdef USE_GNOME
            //FIXME: Suboptimal icon
            icon = g_strdup(GNOME_STOCK_PIXMAP_OPEN);
#endif
            *label = g_strdup(_("Browse"));
            break;

        case GTK_LICQ_BUTTON_CLOSE:
#ifdef USE_GNOME
            icon = g_strdup(GNOME_STOCK_PIXMAP_CLOSE);
#endif
            *label = g_strdup(_("Close"));
            break;

        case GTK_LICQ_BUTTON_NEXT:
#ifdef USE_GNOME
            pixmap = gnome_stock_pixmap_widget(NULL, GNOME_STOCK_BUTTON_NEXT);
#endif
            *label = g_strdup(_("Next"));
            break;

        case GTK_LICQ_BUTTON_PREV:
#ifdef USE_GNOME
            pixmap = gnome_stock_pixmap_widget(NULL, GNOME_STOCK_BUTTON_PREV);
#endif
            *label = g_strdup(_("Prev"));
            break;

        case GTK_LICQ_BUTTON_FINISH:
#ifdef USE_GNOME
            //FIXME: Suboptimal icon
            pixmap = gnome_stock_pixmap_widget(NULL, GNOME_STOCK_BUTTON_APPLY);
#endif
            *label = g_strdup(_("Finish"));
            break;

        case GTK_LICQ_BUTTON_REFUSE:
#ifdef USE_GNOME
            icon = NULL;
#endif
            *label = g_strdup(_("Refuse"));
            break;

        case GTK_LICQ_BUTTON_ACCEPT:
#ifdef USE_GNOME
            icon = NULL;
#endif
            *label = g_strdup(_("Accept"));
            break;

        case GTK_LICQ_BUTTON_ENABLE:
#ifdef USE_GNOME
            icon = NULL;
#endif
            *label = g_strdup(_("Enable"));
            break;

        case GTK_LICQ_BUTTON_DISABLE:
#ifdef USE_GNOME
            icon = NULL;
#endif
            *label = g_strdup(_("Disable"));
            break;

        case GTK_LICQ_BUTTON_LOAD:
#ifdef USE_GNOME
            icon = NULL;
#endif
            *label = g_strdup(_("Load"));
            break;

        case GTK_LICQ_BUTTON_UNLOAD:
#ifdef USE_GNOME
            icon = NULL;
#endif
            *label = g_strdup(_("Unload"));
            break;

        case GTK_LICQ_BUTTON_REFRESH:
#ifdef USE_GNOME
            icon = g_strdup(GNOME_STOCK_PIXMAP_REFRESH);
#endif
            *label = g_strdup(_("Refresh"));
            break;
            
        case GTK_LICQ_BUTTON_ADD:
#ifdef USE_GNOME
            icon = g_strdup(GNOME_STOCK_PIXMAP_ADD);
#endif
            *label = g_strdup(_("Add"));
            break;
            
        case GTK_LICQ_BUTTON_REMOVE:
#ifdef USE_GNOME
            icon = g_strdup(GNOME_STOCK_PIXMAP_REMOVE);
#endif
            *label = g_strdup(_("Remove"));
            break;
            
        case GTK_LICQ_BUTTON_SHIFTUP:
#ifdef USE_GNOME
            icon = g_strdup(GNOME_STOCK_PIXMAP_UP);
#endif
            *label = g_strdup(_("Shift up"));
            break;
            
        case GTK_LICQ_BUTTON_SHIFTDOWN:
#ifdef USE_GNOME
            icon = g_strdup(GNOME_STOCK_PIXMAP_DOWN);
#endif
            *label = g_strdup(_("Shift down"));
            break;
        
        case GTK_LICQ_BUTTON_ADDUSER:
#ifdef USE_GNOME
            icon = g_strdup(GNOME_STOCK_PIXMAP_ADD);
#endif
            *label = g_strdup(_("Add user"));
            break;
            
        case GTK_LICQ_BUTTON_REPLY:
#ifdef USE_GNOME
            icon = g_strdup(GNOME_STOCK_PIXMAP_MAIL_RPL);
#endif
            *label = g_strdup(_("Reply"));
            break;
            
        case GTK_LICQ_BUTTON_QUOTEREPLY:
#ifdef USE_GNOME
            icon = g_strdup(GNOME_STOCK_PIXMAP_MAIL_RPL);
            *label = g_strdup(_("Quote"));
#else
            *label = g_strdup(_("Quote reply"));
#endif
            break;

        case GTK_LICQ_BUTTON_HOMEPAGE:
#ifdef USE_GNOME
            icon = g_strdup(GNOME_STOCK_PIXMAP_HOME);
            *label = g_strdup(_("View"));
#else
            *label = g_strdup(_("View"));
#endif
            break;

        case GTK_LICQ_BUTTON_FORWARD:
#ifdef USE_GNOME
            icon = g_strdup(GNOME_STOCK_PIXMAP_MAIL_FWD);
            *label = g_strdup(_("Forward"));
#else
            *label = g_strdup(_("Forward"));
#endif
            break;
            
        case GTK_LICQ_BUTTON_RETRY:
#ifdef USE_GNOME
            icon = g_strdup(GNOME_STOCK_PIXMAP_MAIL_FWD);
            *label = g_strdup(_("Retry"));
#else
            *label = g_strdup(_("Retry"));
#endif
            break;
            
            
        default:
            icon = NULL;
            *label = NULL;
            break;
    }
#ifdef USE_GNOME
    if ((icon != NULL) && (pixmap == NULL)){
        pixmap = gnome_stock_pixmap_widget(NULL , icon);
        g_free(icon);
    } else if (icon != NULL) {
        g_free(icon);
    }
#endif
    *widget = pixmap;
}

void 
gtk_licq_remove_button_container       (GtkButton   *button)
{
    GList *l;
    int len;
    int i;
    l = gtk_container_children(GTK_CONTAINER(button));
    
    len = g_list_length(l);
    for(i=0; i < len; i++) {
        gtk_container_remove(GTK_CONTAINER(button), GTK_WIDGET(l->data));
        l = g_list_next(l);
    }
}


GtkWidget *
gtk_licq_button                        (button_type type) 
{
    char *label = NULL;
    GtkWidget *pixmap;
    GtkWidget *button;
    
    button = gtk_button_new();
    gtk_licq_button_set(GTK_BUTTON(button),type);
/*    get_pixmap_and_label(type, &pixmap, &label);
    
#ifdef USE_GNOME
    if ((pixmap != NULL) && (label != NULL)) {
        button = gnome_pixmap_button(pixmap,label);
        g_free(label); 
        return(button);
    } else if (label != NULL) {
        button = gtk_button_new_with_label(label);
        g_free(label);
        return(button);   
    } else {
        return(NULL);
    }
#else
    if (label != NULL) {
        button = gtk_button_new_with_label(label);
        g_free(label);
        return(button); 
    } else {
        return(NULL);
    }
#endif
*/
    return(button);
}


void 
gtk_licq_button_set                    (GtkButton   *button, 
                                        char        *label)
{
    GtkWidget *label_widget;

    if (label != NULL) {
        gtk_licq_remove_button_container(button);
        label_widget = gtk_label_new(label);
        gtk_widget_show(label_widget);
        gtk_container_add(GTK_CONTAINER(button), label_widget);
    }
}


void 
gtk_licq_button_set                    (GtkButton   *button, 
                                        button_type type)
{
    char *label = NULL;
    GtkWidget *label_widget;
    GtkWidget *pixmap = NULL;
    GtkWidget *hbox;
    GtkWidget *w;

    get_pixmap_and_label(type, &pixmap, &label);
    
#ifdef USE_GNOME
    if ((label != NULL) && (pixmap != NULL)) {
        gtk_licq_remove_button_container(button);
        //If the autnors of gnome-libs think this looks familiar I can say that
        //you are right! Most of it is stolen :)

        hbox = gtk_hbox_new(FALSE, 0);
        gtk_widget_show(hbox);

        gtk_container_add(GTK_CONTAINER(button), hbox);

        w = hbox;
        hbox = gtk_hbox_new(FALSE, 0);
        gtk_widget_show(hbox);
        if (type & 0x80) {
            gtk_box_pack_start(GTK_BOX(w), hbox, TRUE, TRUE,
                    GNOME_STOCK_BUTTON_PADDING);
        } else {
            gtk_box_pack_start(GTK_BOX(w), hbox, TRUE, FALSE,
                    GNOME_STOCK_BUTTON_PADDING);
        }
        if (label != NULL) {
            label_widget = gtk_label_new(label);
            gtk_widget_show(label_widget);
            if (type & 0x80) {
                gtk_box_pack_end(GTK_BOX(hbox), label_widget, TRUE, TRUE,
                        GNOME_STOCK_BUTTON_PADDING);
            } else {
                gtk_box_pack_end(GTK_BOX(hbox), label_widget, FALSE, FALSE,
                        GNOME_STOCK_BUTTON_PADDING);
            }
        }


        gtk_widget_show(pixmap);
        gtk_box_pack_start(GTK_BOX(hbox), pixmap,
                FALSE, FALSE, 0);
   
    } else if (label != NULL){
        gtk_licq_remove_button_container(button);

        label_widget = gtk_label_new(label);
        gtk_widget_show(label_widget);

        gtk_container_add(GTK_CONTAINER(button), label_widget);

    }

#else
    
    if (label != NULL) {
        gtk_licq_remove_button_container(button);
        label_widget = gtk_label_new(label);
        gtk_widget_show(label_widget);
        gtk_container_add(GTK_CONTAINER(button), label_widget);
    }
    
#endif
    if (label != NULL) {
        g_free(label);
    }
}

