#include "gtk_licq_screensaver.h"
#include "functions.h"

#ifdef USE_SCRNSAVER
#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <X11/extensions/scrnsaver.h>
#include<gdk/gdkx.h>
#endif


long screensaver_original_status = -1;
/* A lot of this is stolen from the QT gui, ehhh... I mean reused. */
/* And totaly rewritten as usual :) */
gboolean auto_away(gpointer data) 
{
#ifdef USE_SCRNSAVER
#undef Status
    static XScreenSaverInfo *mit_info = NULL;
    
    ICQOwner *o = gUserManager.FetchOwner(LOCK_R);
    unsigned short status = o->Status();
    gUserManager.DropOwner();
    unsigned long idle = 0; 
    unsigned short newstatus;
    unsigned long tmptime;
    unsigned int timescale = 60000; /* Should be 60000 to work correct*/
    
    if ((!configuration.autoaway && 
                !configuration.autona && 
                !configuration.autooffline)) {
        return(TRUE);
    }
    
    if (mit_info == NULL) {
        int event_base, error_base;
        if(XScreenSaverQueryExtension(GDK_DISPLAY(), &event_base, &error_base)) {
            mit_info = XScreenSaverAllocInfo ();
        } else { 
            gbug("No XScreenSaver extension found on current XServer, disabling auto-away.\n");
            return(FALSE);
        }
    }

    if (!XScreenSaverQueryInfo(GDK_DISPLAY(), GDK_ROOT_WINDOW(), mit_info)) {
        gbug("XScreenSaverQueryInfo failed, disabling auto-away.\n");
        return(FALSE);
    }
    
    idle = mit_info->idle;

    newstatus = status;
    tmptime = 0;

    if (configuration.autoaway && 
            ((configuration.autoaway * timescale) <= idle) &&
            (status == ICQ_STATUS_ONLINE)) {
        tmptime = configuration.autoaway;
        newstatus = ICQ_STATUS_AWAY;
    }

    if (configuration.autona &&
            ((configuration.autona * timescale) <= idle) && 
            (tmptime <= configuration.autona ) &&
            ((status == ICQ_STATUS_ONLINE) || (status == ICQ_STATUS_AWAY))){
        tmptime = configuration.autona;
        newstatus = ICQ_STATUS_NA;
    }

    if (configuration.autooffline &&
            ((configuration.autooffline * timescale) <= idle) && 
            (tmptime <= configuration.autooffline )) {
        tmptime = configuration.autooffline;
        newstatus = ICQ_STATUS_OFFLINE;
    }

    if ((newstatus != status) && (tmptime > 0)) {
        if (screensaver_original_status == -1) {
            screensaver_original_status = status;
        }
        set_status(newstatus);
    } else if ((tmptime == 0) && (idle <= 30000)){
        if ((screensaver_original_status != -1) && (configuration.autoback)){
            set_status(screensaver_original_status);
        }
        screensaver_original_status = -1;
    }
    
#endif
    return(TRUE);
}
