#include "gtk-gui.h"
#include <gdk/gdkkeysyms.h>
#include <string.h>

#include "history_dialog.h"
#include "interface.h"
#include "functions.h"

static GTimer *timer = NULL;
#define HISTORY_DELAY 0.75

gboolean
on_history_dialog_delete_event         (GtkWidget       *widget,
                                        GdkEvent        *event,
                                        gpointer         user_data)
{
    shutdown_history_dialog(widget);
    return FALSE;
}


gboolean
on_history_filter_entry_key_press_event
                                        (GtkWidget       *widget,
                                        GdkEventKey     *event,
                                        gpointer         user_data)
{
    int     i;

    if(event->keyval==GDK_Return) {
        refresh_history_lists(gtk_widget_get_toplevel(widget));
    }
    return FALSE;
}


void
on_history_filter_set_button_clicked   (GtkButton       *button,
                                        gpointer         user_data)
{
    refresh_history_lists(gtk_widget_get_toplevel(GTK_WIDGET(button)));
}

void
on_history_close_button_clicked        (GtkButton       *button,
                                        gpointer         user_data)
{
    shutdown_history_dialog(gtk_widget_get_toplevel(GTK_WIDGET(button)));
}

void
shutdown_history_dialog                (GtkWidget       *toplevel)
{
    userdata_t      *udata;
    unsigned long   uin;

    uin=gtk_widget_get_active_uin(toplevel);
    udata=find_user_data(uin,NULL);
    udata->history_dialog=NULL;
    gtk_widget_destroy(toplevel);
}

int
strcasesubstr(const char *needle, const char *haystack,int len) 
{
    while(*haystack) {
#ifdef HAVE_STRCASECMP
        if(!strncasecmp(needle,haystack,len)) {
#else
#warning History search will be case sensitive!
        if(!strncmp(needle,haystack,len)) {
#endif
            return 0;
        }
        haystack++;
    }
    return 1;
}

void
refresh_history_lists                  (GtkWidget       *toplevel)
{
    ICQUser         *user;
    HistoryList     history;
    HistoryListIter history_iter;
    unsigned long   uin;
    int             increment;
    unsigned int    ndx,count=0;
    GtkWidget       *history_newest_first_checkbutton=lookup_widget(
            toplevel,"history_newest_first_checkbutton");
    GtkWidget       *number_of_entries_spinbutton=lookup_widget(
            toplevel,"number_of_entries_spinbutton");
    GtkWidget       *history_incoming_text=lookup_widget(
            toplevel,"history_incoming_text");
    GtkWidget       *history_outgoing_text=lookup_widget(
            toplevel,"history_outgoing_text");
    GtkWidget       *history_dialog_text=lookup_widget(
            toplevel,"history_dialog_text");
    GtkWidget       *history_search_progressbar=lookup_widget(
            toplevel,"history_search_progressbar");
    GtkWidget       *history_filter_entry=lookup_widget(
            toplevel,"history_filter_entry");
    time_t          timep;
    char            tmp_time[40], line[256],*searchtext=NULL;
    GdkColor        *color;
    GtkWidget       *dir_text;
    int             needlelen=0;

    gtk_widget_set_sensitive(number_of_entries_spinbutton,FALSE);
    uin=gtk_widget_get_active_uin(toplevel);
    user=GET_USER_OR_OWNER(uin,LOCK_R);
    if(user&&user->GetHistory(history)) {
        if(gtk_toggle_button_get_active(
                    GTK_TOGGLE_BUTTON(history_newest_first_checkbutton))) 
        {
            history_iter=history.end();
            increment=-1;
        }else {
            history_iter=history.begin();
            increment=1;
        }
        gtk_text_freeze(GTK_TEXT(history_incoming_text));
        gtk_text_freeze(GTK_TEXT(history_outgoing_text));
        gtk_text_freeze(GTK_TEXT(history_dialog_text));
        gtk_text_set_point(GTK_TEXT(history_incoming_text),0);
        gtk_text_set_point(GTK_TEXT(history_outgoing_text),0);
        gtk_text_set_point(GTK_TEXT(history_dialog_text),0);
        gtk_text_forward_delete(GTK_TEXT(history_incoming_text),gtk_text_get_length(GTK_TEXT(history_incoming_text)));
        gtk_text_forward_delete(GTK_TEXT(history_outgoing_text),gtk_text_get_length(GTK_TEXT(history_outgoing_text)));
        gtk_text_forward_delete(GTK_TEXT(history_dialog_text),gtk_text_get_length(GTK_TEXT(history_dialog_text)));
        
        //gtk_editable_delete_text(GTK_EDITABLE(history_incoming_text),0,-1);
        //gtk_editable_delete_text(GTK_EDITABLE(history_outgoing_text),0,-1);
        //gtk_editable_delete_text(GTK_EDITABLE(history_dialog_text),0,-1);

        count=gtk_spin_button_get_value_as_int(
                GTK_SPIN_BUTTON(number_of_entries_spinbutton));
        gtk_progress_configure(GTK_PROGRESS(history_search_progressbar),
                0.0,0.0,count);
        searchtext=gtk_editable_get_chars(GTK_EDITABLE(history_filter_entry)
                ,0,-1);
        if(searchtext&&*searchtext) {
            needlelen=strlen(searchtext);
        }

        for(ndx=1;ndx<history.size()&&count;ndx++,count--) {
            gtk_progress_set_value(GTK_PROGRESS(history_search_progressbar),ndx);

            increment>0?history_iter++:history_iter--;
            if(needlelen&&
                    strcasesubstr(searchtext,(*history_iter)->Text(),needlelen)) {
                continue ;
            }
            memset(tmp_time,0,20);
            timep = (*history_iter)->Time();
            strftime(tmp_time,40,"%a %b %d %Y  %H:%M:%S",localtime(&timep));
            if ((*history_iter)->Direction() == D_RECEIVER){
                color = &historycolor_received;
                dir_text=history_incoming_text;
            } else {
                color = &historycolor_sent;
                dir_text=history_outgoing_text;
            }
            sprintf(line,"---\n%s [%c%c%c%c%c]\n\n",tmp_time,
                    ((*history_iter)->IsDirect())?'D':'-',
                    ((*history_iter)->IsUrgent())?'U':'-',
                    ((*history_iter)->IsMultiRec())?'M':'-',
                    ((*history_iter)->IsEncrypted())?'E':'-',
                    ((*history_iter)->IsLicq())?'L':'-');
            gtk_text_insert(GTK_TEXT(history_dialog_text),
                    global_editor_font,color,NULL, line,strlen(line));
            gtk_text_insert(GTK_TEXT(history_dialog_text),
                    global_editor_font,color,NULL,
                    (*history_iter)->Text(),strlen((*history_iter)->Text()));
            gtk_text_insert(GTK_TEXT(history_dialog_text),
                    global_editor_font,color,NULL, "\n",1);
            gtk_text_insert(GTK_TEXT(dir_text),global_editor_font,color,NULL,
                    line,strlen(line));
            gtk_text_insert(GTK_TEXT(dir_text),global_editor_font,color,NULL,
                    (*history_iter)->Text(),strlen((*history_iter)->Text()));
            gtk_text_insert(GTK_TEXT(dir_text),global_editor_font,color,NULL,
                    "\n",1);
        }
        gtk_progress_set_percentage(GTK_PROGRESS(history_search_progressbar),1.0);
        
        gtk_text_thaw(GTK_TEXT(history_incoming_text));
        gtk_text_thaw(GTK_TEXT(history_outgoing_text));
        gtk_text_thaw(GTK_TEXT(history_dialog_text));
    }else {
        if(!user||user->HistoryFile()) {
            showokdialog(_("History error"),_("Cannot load user history"));
        }else {
            showokdialog(_("History error"),_("History is disabled for this person"));
        }
    }
    if(user) {
        gUserManager.DropUser(user);
    }
    gtk_widget_set_sensitive(number_of_entries_spinbutton,TRUE);
}

GtkWidget *
show_history_dialog_for_user           (unsigned long uin)
{
    userdata_t      *udata;
    GtkWidget       *history_dialog;
    ICQUser         *user;
    HistoryList     history;
    GtkWidget       *number_of_entries_spinbutton;
    GtkObject       *adj;

    udata=find_user_data(uin,NULL);
    if(!udata->history_dialog) {
        history_dialog=create_history_dialog();
        udata->history_dialog=history_dialog;
        gtk_widget_set_active_uin(history_dialog,uin);
        user=GET_USER_OR_OWNER(uin,LOCK_R);
        if(user->GetHistory(history)) {
            number_of_entries_spinbutton=lookup_widget(history_dialog,
                    "number_of_entries_spinbutton");
            adj=gtk_adjustment_new(history.size(),1,history.size(),1,10,10);
            gtk_spin_button_set_adjustment(
                    GTK_SPIN_BUTTON(number_of_entries_spinbutton),
                    GTK_ADJUSTMENT(adj));
            gtk_spin_button_set_value(
                    GTK_SPIN_BUTTON(number_of_entries_spinbutton),
                    history.size());
        }
        gUserManager.DropUser(user);
        refresh_history_lists(history_dialog);
        gtk_widget_show(history_dialog);
    }else {
        history_dialog=udata->history_dialog;
        gdk_window_raise(history_dialog->window);
    }

    return history_dialog;
}


void
on_history_newest_first_checkbutton_toggled
                                        (GtkToggleButton *togglebutton,
                                        gpointer         user_data)
{
    refresh_history_lists(gtk_widget_get_toplevel(GTK_WIDGET(togglebutton)));
}


gint
history_timeout_callback (GtkEditable     *editable)
{
    GtkWidget       *number_of_entries_spinbutton;
    gchar *tmp;
    
    if (timer == NULL) return FALSE;
    if (g_timer_elapsed (timer, NULL) >= HISTORY_DELAY) {
        g_timer_destroy (timer);
        timer = NULL;
        
        number_of_entries_spinbutton=lookup_widget(
                GTK_WIDGET(editable) ,"number_of_entries_spinbutton"); 
        tmp = gtk_editable_get_chars(GTK_EDITABLE(number_of_entries_spinbutton),0,-1);
        if(GTK_WIDGET_REALIZED(editable) && (strlen(tmp) > 0)) {
            refresh_history_lists(gtk_widget_get_toplevel(GTK_WIDGET(editable)));
        }
        g_free(tmp);
        return FALSE;
    }
    return TRUE;
}

void
on_number_of_entries_spinbutton_changed
                                        (GtkEditable     *editable,
                                        gpointer         user_data)
{
    if (timer != NULL) g_timer_destroy (timer);
    timer = g_timer_new();
    g_timer_start (timer);
    g_timeout_add (50, (GSourceFunc) history_timeout_callback, editable);
}

