#include "gtk-gui.h"

#include <gdk/gdkkeysyms.h>

#include <signal.h>
#include <sys/stat.h>
#include <unistd.h>
#include <sys/types.h>
#include <fcntl.h>
#ifdef HAVE_ERRNO_H
#include <errno.h>
#endif
#ifdef USE_PANEL
#include <applet-widget.h>
#endif

#include "licq_log.h"

#include "signalhandler.h"
#include "contactlist.h"
#include "functions.h"
#include "gnomedock.h"
#include "send_event_window.h"
#include "spell.h"

    /*  Icons */
#include "icons/away.xpm"
#include "icons/dnd.xpm"
#include "icons/na.xpm"
#include "icons/occupied.xpm"
#include "icons/offline.xpm"
#include "icons/online.xpm"
#include "icons/private.xpm"
#include "icons/message.xpm"
#include "icons/file.xpm"
#include "icons/url.xpm"
#include "icons/chat.xpm"
#include "icons/ffc.xpm"
#include "icons/authorize.xpm"
#include "icons/contacts.xpm"
#include "icons/selectforeground.xpm"
#include "icons/selectbackground.xpm"
#include "pixmaps/arrow.xpm"
#include "pixmaps/not_secure_on.xpm"
#include "pixmaps/secure_on.xpm"
#include "pixmaps/secure_off.xpm"
#include "pixmaps/close.xpm"
#include "pixmaps/info.xpm"
#include "pixmaps/history.xpm"


    /*  Globals */
GdkPixMask_t    status_pixmap_away={NULL,NULL};
GdkPixMask_t    status_pixmap_chat={NULL,NULL};
GdkPixMask_t    status_pixmap_dnd={NULL,NULL};
GdkPixMask_t    status_pixmap_ffc={NULL,NULL};
GdkPixMask_t    status_pixmap_file={NULL,NULL};
GdkPixMask_t    status_pixmap_message={NULL,NULL};
GdkPixMask_t    status_pixmap_na={NULL,NULL};
GdkPixMask_t    status_pixmap_occupied={NULL,NULL};
GdkPixMask_t    status_pixmap_offline={NULL,NULL};
GdkPixMask_t    status_pixmap_online={NULL,NULL};
GdkPixMask_t    status_pixmap_private={NULL,NULL};
GdkPixMask_t    status_pixmap_url={NULL,NULL};
GdkPixMask_t    status_pixmap_contacts={NULL,NULL};
GdkPixMask_t    status_pixmap_authorize={NULL,NULL};
GdkPixMask_t    arrow_pixmap={NULL,NULL};
GdkPixMask_t    not_secure_on_pixmap={NULL,NULL};
GdkPixMask_t    secure_on_pixmap={NULL,NULL};
GdkPixMask_t    secure_off_pixmap={NULL,NULL};
GdkPixMask_t    close_pixmap={NULL,NULL};
GdkPixMask_t    info_pixmap={NULL,NULL};
GdkPixMask_t    history_pixmap={NULL,NULL};
GdkPixMask_t    select_foreground_pixmap={NULL,NULL};
GdkPixMask_t    select_background_pixmap={NULL,NULL};

GdkColor        statuscolor_online, statuscolor_offline, 
                statuscolor_new, statuscolor_other, contactlist_background,
                historycolor_sent,historycolor_received;
CIniFile        gui_confobject(INI_FxALLOWxCREATE | INI_FxWARN);
configuration_t configuration;
GSList          *initial_floaties=NULL;
                

    /*  Externals */
extern gint contactlist_sort(GtkCList *clist,
            GtkCListRow  *ptr1,
            GtkCListRow  *ptr2);
extern bool contactlist_signal_callback(CICQSignal *signal, gpointer data);
extern void utilty_activate(GtkWidget *menuitem,gpointer data);

bool        blinkfunctionactive=FALSE,statustimerfunctionactive=FALSE;

int
load_pixmap                            (gchar       *pathname,
                                        gchar       *filename,
                                        gchar       **backup,
                                        GdkPixMask_t
                                                    *pixmap,
                                        GtkStyle    *style)
{
    gchar       *fullname=NULL;

    if(*configuration.iconset) {
        if(pathname&&filename) {
            fullname=g_strdup_printf("%s/%s",pathname,filename);
        }else if (filename) {
            fullname=g_strdup(filename);
        }
    }
    
    if(pixmap->pix) {
        gdk_pixmap_unref(pixmap->pix);
        pixmap->pix=NULL;
    }
    if(pixmap->mask) {
        gdk_pixmap_unref(pixmap->mask);
        pixmap->mask=NULL;
    }
    if( !fullname||
            !*configuration.iconset||
            !(pixmap->pix=gdk_pixmap_create_from_xpm(main_window->window,
                &pixmap->mask,
                &style->bg[GTK_STATE_NORMAL],
                fullname))) {
        gbug("load_pixmap: failed '%s'\n",fullname);
        pixmap->pix=gdk_pixmap_create_from_xpm_d(main_window->window,
                &pixmap->mask,
                &style->bg[GTK_STATE_NORMAL],
                backup);
    }
    if(fullname) {
        g_free(fullname);
    }
    return pixmap->pix!=0;
}

int
load_pixmaps()
{
    GtkStyle        *style;
    CIniFile        skinsfile(INI_FxWARN|INI_ExIOREAD);
    gchar           *skinsfilename,iconfilename[PATH_MAX],*pathname=NULL;

    style=gtk_widget_get_style(main_window);
    if (strcmp(configuration.iconset,_("Default icons"))) { //ignore Default
        if(!strchr(configuration.iconset,'/')) {
            skinsfilename=g_strdup_printf("%s/icons.%s/%s.icons",
                    GTKGUI_DIR,configuration.iconset,
                    configuration.iconset);
            pathname=g_strdup_printf("%s/icons.%s",GTKGUI_DIR,configuration.iconset);
            strcpy(configuration.iconset,skinsfilename);
            g_free(skinsfilename);
            //save_configuration();
        }else {
            pathname=g_strdup(configuration.iconset);
            if(strrchr(pathname,'/')) {
                *strrchr(pathname,'/')='\0';
            }
        }
    }

    if(*configuration.iconset && 
            strcmp(configuration.iconset,_("Default icons")) &&
            skinsfile.LoadFile(configuration.iconset)) {
        skinsfile.SetSection("icons");

        skinsfile.ReadStr("Online",iconfilename,"online.xpm");
        load_pixmap(pathname,iconfilename,pixdata_online_xpm,
                &status_pixmap_online,style);
        skinsfile.ReadStr("Offline",iconfilename,"offline.xpm");
        load_pixmap(pathname,iconfilename,pixdata_offline_xpm,
                &status_pixmap_offline, style);
        skinsfile.ReadStr("FFC",iconfilename,"ffc.xpm");
        load_pixmap(pathname,iconfilename,pixdata_ffc_xpm,
                &status_pixmap_ffc,style);
        skinsfile.ReadStr("Away",iconfilename,"away.xpm");
        load_pixmap(pathname,iconfilename,pixdata_away_xpm,
                &status_pixmap_away,style);
        skinsfile.ReadStr("NA",iconfilename,"na.xpm");
        load_pixmap(pathname,iconfilename,pixdata_na_xpm,
                &status_pixmap_na,style);
        skinsfile.ReadStr("Occupied",iconfilename,"occupied.xpm");
        load_pixmap(pathname,iconfilename,pixdata_occupied_xpm,
                &status_pixmap_occupied, style);
        skinsfile.ReadStr("DND",iconfilename,"dnd.xpm");
        load_pixmap(pathname,iconfilename,pixdata_dnd_xpm,
                &status_pixmap_dnd,style);
        skinsfile.ReadStr("Private",iconfilename,"private.xpm");
        load_pixmap(pathname,iconfilename,pixdata_private_xpm,
                &status_pixmap_private, style);
        skinsfile.ReadStr("Message",iconfilename,"message.xpm");
        load_pixmap(pathname,iconfilename,pixdata_message_xpm,
                &status_pixmap_message, style);
        skinsfile.ReadStr("Url",iconfilename,"url.xpm");
        load_pixmap(pathname,iconfilename,pixdata_url_xpm,
                &status_pixmap_url,style);
        skinsfile.ReadStr("Chat",iconfilename,"chat.xpm");
        load_pixmap(pathname,iconfilename,pixdata_chat_xpm,
                &status_pixmap_chat,style);
        skinsfile.ReadStr("File",iconfilename,"file.xpm");
        load_pixmap(pathname,iconfilename,pixdata_file_xpm,
                &status_pixmap_file,style);
        skinsfile.ReadStr("Contacts",iconfilename,"contacts.xpm");
        load_pixmap(pathname,iconfilename,pixdata_contacts_xpm,
                &status_pixmap_contacts, style);
        skinsfile.ReadStr("Authorize",iconfilename,"authorize.xpm");
        load_pixmap(pathname,iconfilename,pixdata_authorize_xpm,
                &status_pixmap_authorize, style);

        skinsfile.CloseFile();
    } else {
        load_pixmap(NULL,NULL,pixdata_online_xpm,&status_pixmap_online,style);
        load_pixmap(NULL,NULL,pixdata_offline_xpm,&status_pixmap_offline,style);
        load_pixmap(NULL,NULL,pixdata_ffc_xpm,&status_pixmap_ffc,style);
        load_pixmap(NULL,NULL,pixdata_away_xpm,&status_pixmap_away,style);
        load_pixmap(NULL,NULL,pixdata_na_xpm,&status_pixmap_na,style);
        load_pixmap(NULL,NULL,pixdata_occupied_xpm,&status_pixmap_occupied,
                style);
        load_pixmap(NULL,NULL,pixdata_dnd_xpm,&status_pixmap_dnd,style);
        load_pixmap(NULL,NULL,pixdata_private_xpm,&status_pixmap_private,
                style);
        load_pixmap(NULL,NULL,pixdata_message_xpm,&status_pixmap_message,style);
        load_pixmap(NULL,NULL,pixdata_url_xpm,&status_pixmap_url,style);
        load_pixmap(NULL,NULL,pixdata_chat_xpm,&status_pixmap_chat,style);
        load_pixmap(NULL,NULL,pixdata_file_xpm,&status_pixmap_file,style);
        load_pixmap(NULL,NULL,pixdata_contacts_xpm,&status_pixmap_contacts,style);
        load_pixmap(NULL,NULL,pixdata_authorize_xpm,&status_pixmap_authorize,
                style);

    }
    load_pixmap(NULL,NULL,pixdata_arrow_xpm,&arrow_pixmap,style);
    load_pixmap(NULL,NULL,pixdata_not_secure_on_xpm,&not_secure_on_pixmap,style);
    load_pixmap(NULL,NULL,pixdata_secure_on_xpm,&secure_on_pixmap,style);
    load_pixmap(NULL,NULL,pixdata_secure_off_xpm,&secure_off_pixmap,style);
    load_pixmap(NULL,NULL,pixdata_close_xpm,&close_pixmap,style);
    load_pixmap(NULL,NULL,pixdata_history_xpm,&history_pixmap,style);
    load_pixmap(NULL,NULL,pixdata_info_xpm,&info_pixmap,style);
    load_pixmap(NULL,NULL,pixdata_selectforeground_xpm,
            &select_foreground_pixmap,style);
    load_pixmap(NULL,NULL,pixdata_selectbackground_xpm,
            &select_background_pixmap,style);
   
    return 0;
}

int
load_colors()
{
    GdkColormap     *main_window_colormap;

    main_window_colormap=gtk_widget_get_colormap(main_window);
    statuscolor_online.red=(gushort)(configuration.color_online.r*0xffff);
    statuscolor_online.green=(gushort)(configuration.color_online.g*0xffff);
    statuscolor_online.blue=(gushort)(configuration.color_online.b*0xffff);
    
    statuscolor_offline.red=(gushort)(configuration.color_offline.r*0xffff);
    statuscolor_offline.green=(gushort)(configuration.color_offline.g*0xffff);
    statuscolor_offline.blue=(gushort)(configuration.color_offline.b*0xffff);

    statuscolor_new.red=(gushort)(configuration.color_new.r*0xffff);
    statuscolor_new.green=(gushort)(configuration.color_new.g*0xffff);
    statuscolor_new.blue=(gushort)(configuration.color_new.b*0xffff);

    statuscolor_other.red=(gushort)(configuration.color_other.r*0xffff);
    statuscolor_other.green=(gushort)(configuration.color_other.g*0xffff);
    statuscolor_other.blue=(gushort)(configuration.color_other.b*0xffff);

    contactlist_background.red=0xa000;
    contactlist_background.green=0xa000;
    contactlist_background.blue=0xa000;
    
    historycolor_sent.red=(gushort)(configuration.color_sent.r*0xffff);
    historycolor_sent.green=(gushort)(configuration.color_sent.g*0xffff);
    historycolor_sent.blue=(gushort)(configuration.color_sent.b*0xffff);
    
    historycolor_received.red=(gushort)(configuration.color_rcvd.r*0xffff);
    historycolor_received.green=(gushort)(configuration.color_rcvd.g*0xffff);
    historycolor_received.blue=(gushort)(configuration.color_rcvd.b*0xffff);

    gdk_colormap_alloc_color(main_window_colormap,&statuscolor_online,TRUE,TRUE);
    gdk_colormap_alloc_color(main_window_colormap,&statuscolor_offline,TRUE,TRUE);
    gdk_colormap_alloc_color(main_window_colormap,&statuscolor_new,TRUE,TRUE);
    gdk_colormap_alloc_color(main_window_colormap,&statuscolor_other,TRUE,TRUE);
    gdk_colormap_alloc_color(main_window_colormap,&contactlist_background,TRUE,
            TRUE);
    gdk_colormap_alloc_color(main_window_colormap,&historycolor_sent,TRUE,TRUE);
    gdk_colormap_alloc_color(main_window_colormap,&historycolor_received,TRUE,
            TRUE);
    return 0;
}

void
gtk_plugin_terminate()
{
    gint        width,height,x,y,depth;
    GtkWidget   *alias_clist=lookup_widget(main_window,"alias_clist");
    GtkWidget   *w;
    gchar       wrow[MAX_CONFIG_STRLEN],fname[20];
    GList       *rows;
    gushort     fnum=0;

    gbug("gtk_plugin_terminate\n");
    remove_all_handlers();
    gui_confobject.SetSection("other");
    if(main_window&&main_window->window) {
       // gdk_window_get_position(main_window->window,&x,&y);
        gdk_window_get_root_origin (main_window->window,&x,&y);
        gdk_window_get_size(main_window->window,
                                &width, &height);
        configuration.defaultwidth=width;
        configuration.defaultheight=height;
        configuration.default_x=x;
        configuration.default_y=y;
    }
    gui_confobject.WriteNum("windowwidth",configuration.defaultwidth);
    gui_confobject.WriteNum("windowheight",configuration.defaultheight);
    gui_confobject.WriteNum("windowposx",configuration.default_x);
    gui_confobject.WriteNum("windowposy",configuration.default_y);

    gui_confobject.SetSection("floaties");
    rows=GTK_CLIST(alias_clist)->row_list;
    while(rows) {
        if(rows->data&&((GtkCListRow*)(rows->data))->data&&
                (w=((userdata_t*)(((GtkCListRow*)(rows->data))->data))->floating_window)) {
            if(w->window) {
                gdk_window_get_position(w->window,&x,&y);
            }else {
                x=0;
                y=0;
            }
            sprintf(wrow,"%ld %d %d",gtk_widget_get_active_uin(w),x,y);
            sprintf(fname,"f%d",fnum++);
            gui_confobject.WriteStr(fname,wrow);
            ((userdata_t*)(((GtkCListRow*)(rows->data))->data))->floating_window=NULL;
            gtk_widget_destroy(w);
        }
        rows=g_list_next(rows);
    }
    gui_confobject.WriteNum("num_floaties",fnum);

    gui_confobject.FlushFile();
    gui_confobject.CloseFile();
    
#ifdef USE_PANEL
    if (panel_dockapp) {
        remove_dock_applet(); 
    } else {
        gtk_main_quit(); 
    }
#else
    gtk_main_quit(); 
#endif
    
    licq_daemon->UnregisterPlugin();
}

int
setup_widgets()
{
    ICQOwner        *owner = NULL; 
    GtkWidget       *status_info=lookup_widget(main_window, "status_info1");
    GtkWidget       *unknown_packets=lookup_widget(main_window,
            "unknown_packets1");
    GtkWidget       *errors=lookup_widget(main_window,"errors1");
    GtkWidget       *warnings=lookup_widget(main_window,"warnings1");
    GtkWidget       *packets=lookup_widget(main_window,"packets1");
    GtkWidget       *show_offline_users1=lookup_widget(main_window,
            "show_offline_users1");
    GtkWidget       *use_mini_mode1=lookup_widget(main_window,
            "use_mini_mode1");
    GtkWidget       *status_pixmap,*status_label;
    GtkTooltips     *main_window_tooltips;
    GtkWidget       *status_hbox=lookup_widget(main_window,"status_hbox");
    userdata_t      *userdata;

    /* Set the mainwindow userdata */
    userdata = (userdata_t *) malloc(sizeof(userdata_t));
    if (userdata != NULL) {
        userdata->uin = 0;
        userdata->send_event_window=NULL;
        userdata->view_event_window=NULL;
        userdata->history_dialog=NULL;
        userdata->info_dialog=NULL;
        userdata->send_events=NULL;
#ifdef USE_PSPELL
        userdata->spellmanager=NULL;
#endif
    }
    gtk_object_set_data(GTK_OBJECT(main_window),"owner_userdata",userdata);
    
    contactlist_current_group=gUserManager.DefaultGroup();
    register_signalcallback(sound_signal_callback,
            NULL); 
    register_signalcallback(contactlist_signal_callback,
            NULL); 

    gtk_object_set_user_data(GTK_OBJECT(status_info),GINT_TO_POINTER(L_INFO));
    gtk_object_set_user_data(GTK_OBJECT(unknown_packets),
            GINT_TO_POINTER(L_UNKNOWN));
    gtk_object_set_user_data(GTK_OBJECT(errors),GINT_TO_POINTER(L_ERROR));
    gtk_object_set_user_data(GTK_OBJECT(warnings),GINT_TO_POINTER(L_WARN));
    gtk_object_set_user_data(GTK_OBJECT(packets),GINT_TO_POINTER(L_PACKET));

    gtk_check_menu_item_set_show_toggle(GTK_CHECK_MENU_ITEM(status_info),TRUE);
    gtk_check_menu_item_set_show_toggle(GTK_CHECK_MENU_ITEM(unknown_packets),
            TRUE);
    gtk_check_menu_item_set_show_toggle(GTK_CHECK_MENU_ITEM(errors),TRUE);
    gtk_check_menu_item_set_show_toggle(GTK_CHECK_MENU_ITEM(warnings),TRUE);
    gtk_check_menu_item_set_show_toggle(GTK_CHECK_MENU_ITEM(packets),TRUE);
    gtk_check_menu_item_set_active(GTK_CHECK_MENU_ITEM(show_offline_users1),
            configuration.showofflineusers);
    gtk_signal_connect (GTK_OBJECT (show_offline_users1), "activate",
            GTK_SIGNAL_FUNC (on_show_offline_users1_activate),
            NULL);
    gtk_check_menu_item_set_show_toggle(GTK_CHECK_MENU_ITEM(show_offline_users1),
            TRUE);
    gtk_check_menu_item_set_show_toggle(GTK_CHECK_MENU_ITEM(use_mini_mode1),
            TRUE);

    gtk_signal_connect(GTK_OBJECT(status_info), "toggled",
            GTK_SIGNAL_FUNC(on_debughandlers_toggled), NULL);
    gtk_signal_connect(GTK_OBJECT(unknown_packets), "toggled",
            GTK_SIGNAL_FUNC(on_debughandlers_toggled), NULL);
    gtk_signal_connect(GTK_OBJECT(errors), "toggled",
            GTK_SIGNAL_FUNC(on_debughandlers_toggled), NULL);
    gtk_signal_connect(GTK_OBJECT(warnings), "toggled",
            GTK_SIGNAL_FUNC(on_debughandlers_toggled), NULL);
    gtk_signal_connect(GTK_OBJECT(packets), "toggled",
            GTK_SIGNAL_FUNC(on_debughandlers_toggled), NULL);
    
    /* Load editor font */
    global_editor_font = gdk_font_load(configuration.editorfont);
  
   /* Quick search keypress */
    gtk_signal_connect (GTK_OBJECT (main_window), "key_press_event",
          GTK_SIGNAL_FUNC (on_main_window_key_press_event),
          NULL);

#ifdef USE_SCRNSAVER
    /* Should be 60000 to work properly */
    g_timeout_add(30000, (GSourceFunc) auto_away,NULL);    
#endif

#ifdef USE_PSPELL
    init_spellchecker();
#endif

    status_pixmap=gtk_pixmap_new(status_pixmap_offline.pix,
            status_pixmap_offline.mask);
    gtk_widget_ref(status_pixmap);
    gtk_object_set_data_full(GTK_OBJECT(main_window),"status_pixmap",
            status_pixmap,(GtkDestroyNotify)gtk_widget_unref);
    gtk_widget_show(status_pixmap);
    gtk_box_pack_start(GTK_BOX(status_hbox),status_pixmap,FALSE,TRUE,3);
   
    if(configuration.showstatustimer) {
        status_label=gtk_label_new("[0:00]");
    }else {
        status_label=gtk_label_new(_("Offline"));
    }
    gtk_widget_ref(status_label);
    gtk_object_set_data_full(GTK_OBJECT(main_window),"status_label",
            status_label,(GtkDestroyNotify)gtk_widget_unref);
    gtk_widget_show(status_label);
    gtk_box_pack_start(GTK_BOX(status_hbox),status_label,FALSE,TRUE,3);

    main_window_tooltips=gtk_tooltips_new();
    gtk_object_set_data(GTK_OBJECT(main_window),"main_window_tooltips",
            main_window_tooltips);

    sys_msgbar_set();
    
    return 0;
}

int
load_configuration()
{
    struct stat statbuf;
    gchar       *filename;
    gchar       alignstr[MAX_CONFIG_STRLEN];
        /*  WATCHOUT for the % macros!!! */
    char        *default_configuration=
        "\n[status]\n"
            "autologon = 0\n"
            "invisible = 0\n"
            "autoaway = 0\n"
            "autona = 0\n"
            "autooffline = 0\n"
            "autoback = 0\n"
            "showstatustimer = 1\n"
        "\n[icons]\n"
            "iconset = %s\n"
            "usericondir = %s/.licq/icons\n"
        "\n[columns]\n"
            "showtitles = 1\n"
            "col0_title = Alias\n"
            "col0_format = %%a\n"
            "col0_width = 50\n"
            "col0_align = left\n"
            "col1_active = 0\n"
            "col1_title = \n"
            "col1_format = \n"
            "col1_width = \n"
            "col1_align = left\n"
            "col2_active = 0\n"
            "col2_title = \n"
            "col2_format = \n"
            "col2_width = \n"
            "col2_align = left\n"
            "col3_active = 0\n"
            "col3_title = \n"
            "col3_format = \n"
            "col3_width = \n"
            "col3_align = left\n"
            "quick_search_col = 1\n"
        "\n[fonts]\n"
            "editorfont = \n"
            "contactlistfont = \n"
        "\n[other]\n"
            "showofflineusers = 1\n"
            "historylines = 500\n"
            "windowwidth = 150\n"
            "windowheight= 320\n"
            "windowposx = -1\n"
            "windowposy = -1\n"
            "wm_placement = 0\n"
#ifdef USE_GNOME
            "use_gnomeurlviewer = 1\n"
#endif
            "sortcontactlist1 = 1\n"
            "sortcontactlist2 = 3\n"
            "sortcontactlist3 = 0\n"
            "showgroupmenu = 1\n"
            "markactiveuser = 0\n"
            "autopopupmessages = 0\n"
            "onlyautopopupwhenonline = 1\n"
            "singleclick = 0\n"
            "quotewidth = 40\n"
            "autoraise = 1\n"
            "blinkicons = 0\n"
            "autosendthroughserver = 1\n"
#ifdef USE_PANEL
            "launch_applet = 1\n"
            "start_hidden = 1\n"
#endif
        "\n[colors]\n"
            "user_online_red = 0\n"
            "user_online_green = 0\n"
            "user_online_blue = 63\n"
            "user_offline_red = 63\n"
            "user_offline_green = 0\n"
            "user_offline_blue = 0\n"
            "user_other_red = 0\n"
            "user_other_green = 63\n"
            "user_other_blue = 0\n"
            "user_new_red = 75\n"
            "user_new_green = 75\n"
            "user_new_blue = 0\n"
            "history_sent_red = 100\n"
            "history_sent_green = 0\n"
            "history_sent_blue = 0\n"
            "history_rcvd_red = 0\n"
            "history_rcvd_green = 0\n"
            "history_rcvd_blue = 100\n"
            "ignore_incoming_colors = 0\n"
        "\n[onevent]\n"
            "use_onevents = 0\n"
            "beep_onevent = 0\n"
        "\n[chat]\n"
            "audio = 1\n"
            "show_style_toolbar = 1\n"
            "show_font_toolbar = 1\n"
            "use_own_font = 0\n"
            "use_own_color = 0\n"
            "single_chat_mode = 0\n"
            "default_font = courier\n"
            "default_font_size = 12\n"
            "fg_color = 14\n"
            "bg_color = 14\n"
            "toolbar_style = 0\n"
#ifdef USE_PSPELL
        "\n[spell]\n"
            "errorfont = \n"
            "default_dict = \n"
            "spell_mode = 0\n"
#endif
        "\n[file]\n"
            "directory = \n"
            "autoclose = 0\n"
        "\n[security]\n"
            "auto_autosecure = 1\n"
        "\n[floaties]\n"
            "num_floaties = 0\n";
    
    FILE        *file;
    gushort     dummy_ushort;
    gchar       fname[20];
    floatiedata_t   *fs;
    gint        x,y,i;
    gushort     numfloaties;
    unsigned long   uin;

    memset(&configuration,sizeof(configuration_t),0);
    filename=g_strdup_printf("%s/licq_gtk-gui.conf",BASE_DIR);

    if(!filename) {
        gLog.Warn("%sRunning low on memory, load configuration failed\n",
                L_WARNxSTR);
        return -1;
    }
    if(stat(filename,&statbuf)) {
        if((file=fopen(filename,"w"))) {
            fprintf(file,default_configuration,
                    _("Default icons"),   /* iconset */
                    g_get_home_dir()    /* usericondir */
                    );
            fclose(file);
        }else {
            gLog.Error("%s%s: %s\n",L_ERRORxSTR,filename,strerror(errno));
            g_free(filename);
            return -1;
        }
    }
    if(!gui_confobject.LoadFile(filename)) {
        return -1;
    }
    g_free(filename);

    gui_confobject.SetSection("status");
    gui_confobject.ReadNum("autologon",configuration.autologon,0);
    gui_confobject.ReadBool("invisible",configuration.invisible,FALSE);
    gui_confobject.ReadNum("autoaway",configuration.autoaway,0);
    gui_confobject.ReadNum("autona",configuration.autona,0);
    gui_confobject.ReadNum("autooffline",configuration.autooffline,0);
    gui_confobject.ReadBool("autoback",configuration.autoback,TRUE);
    gui_confobject.ReadBool("showstatustimer",configuration.showstatustimer,TRUE);

    gui_confobject.SetSection("icons");
    gui_confobject.ReadStr("iconset",configuration.iconset,_("Default icons"));
    gui_confobject.ReadStr("usericondir",configuration.usericondir,"");

    gui_confobject.SetSection("columns");
    gui_confobject.ReadBool("showtitles",configuration.showcoltitles,TRUE);
    gui_confobject.ReadStr("col0_title",configuration.columns[0].title,"Alias");
    gui_confobject.ReadStr("col0_format",configuration.columns[0].format,"%a");
    gui_confobject.ReadNum("col0_width",configuration.columns[0].width,50);
    gui_confobject.ReadStr("col0_align",alignstr,"left");
    configuration.columns[0].align=get_justification(alignstr);
    gui_confobject.ReadBool("col1_active",configuration.columns[1].active,FALSE);
    gui_confobject.ReadStr("col1_title",configuration.columns[1].title,"");
    gui_confobject.ReadStr("col1_format",configuration.columns[1].format,"");
    gui_confobject.ReadNum("col1_width",configuration.columns[1].width,0);
    gui_confobject.ReadStr("col1_align",alignstr,"left");
    configuration.columns[1].align=get_justification(alignstr);
    gui_confobject.ReadBool("col2_active",configuration.columns[2].active,FALSE);
    gui_confobject.ReadStr("col2_title",configuration.columns[2].title,"");
    gui_confobject.ReadStr("col2_format",configuration.columns[2].format,"");
    gui_confobject.ReadNum("col2_width",configuration.columns[2].width,0);
    gui_confobject.ReadStr("col2_align",alignstr,"left");
    configuration.columns[2].align=get_justification(alignstr);
    gui_confobject.ReadBool("col3_active",configuration.columns[3].active,FALSE);
    gui_confobject.ReadStr("col3_title",configuration.columns[3].title,"");
    gui_confobject.ReadStr("col3_format",configuration.columns[3].format,"");
    gui_confobject.ReadNum("col3_width",configuration.columns[3].width,0);
    gui_confobject.ReadStr("col3_align",alignstr,"left");
    configuration.columns[5].align=get_justification(alignstr);
    gui_confobject.ReadNum("quick_search_col",configuration.quicksearchcol,1);

    gui_confobject.SetSection("fonts");
    gui_confobject.ReadStr("editorfont",configuration.editorfont,"");
    gui_confobject.ReadStr("contactlistfont",configuration.contactfont,"");
    
    gui_confobject.SetSection("other");
    gui_confobject.ReadBool("showofflineusers",configuration.showofflineusers,
            TRUE);
    gui_confobject.ReadNum("historylines",configuration.historylines,500);
    gui_confobject.ReadNum("windowwidth",configuration.defaultwidth,150);
    gui_confobject.ReadNum("windowheight",configuration.defaultheight,320);
    gui_confobject.ReadNum("windowposx",configuration.default_x,-1);
    gui_confobject.ReadNum("windowposy",configuration.default_y,-1);
    gui_confobject.ReadBool("wm_placement",configuration.wm_placement,FALSE);
#ifdef USE_GNOME
    gui_confobject.ReadBool("use_gnomeurlviewer",
            configuration.use_gnomeurlviewer,TRUE);
#endif
    gui_confobject.ReadNum("sortcontactlist1",configuration.sortlist[0],1);
    gui_confobject.ReadNum("sortcontactlist2",configuration.sortlist[1],3);
    gui_confobject.ReadNum("sortcontactlist3",configuration.sortlist[2],0);
    gui_confobject.ReadBool("showgroupmenu",configuration.showgroupmenu,TRUE);
    gui_confobject.ReadBool("markactiveuser",configuration.showactiveuser,FALSE);
    gui_confobject.ReadBool("autopopupmessages",configuration.autopopupmessages,
            FALSE);
    gui_confobject.ReadBool("onlyautopopupwhenonline",configuration.onlyautopopupwhenonline,TRUE);
    gui_confobject.ReadBool("singleclick",configuration.singleclick,
            FALSE);
    gui_confobject.ReadNum("quotewidth",configuration.quotewidth,40);
    gui_confobject.ReadBool("autoraise",configuration.autoraise,
            TRUE);
    gui_confobject.ReadBool("blinkicons",configuration.blinkicons,TRUE);
    gui_confobject.ReadBool("autosendthroughserver",
            configuration.autosendthroughserver,TRUE);
#ifdef USE_PANEL
    gui_confobject.ReadBool("launch_applet",configuration.launchpanel,TRUE);
    gui_confobject.ReadBool("start_hidden",configuration.starthidden,TRUE);
#endif

    gui_confobject.SetSection("colors");
    gui_confobject.ReadNum("user_online_red",dummy_ushort,0);
    configuration.color_online.r=(double)dummy_ushort/100;
    gui_confobject.ReadNum("user_online_green",dummy_ushort,0);
    configuration.color_online.g=(double)dummy_ushort/100;
    gui_confobject.ReadNum("user_online_blue",dummy_ushort,63);
    configuration.color_online.b=(double)dummy_ushort/100;
    gui_confobject.ReadNum("user_offline_red",dummy_ushort,63);
    configuration.color_offline.r=(double)dummy_ushort/100;
    gui_confobject.ReadNum("user_offline_green",dummy_ushort,0);
    configuration.color_offline.g=(double)dummy_ushort/100;
    gui_confobject.ReadNum("user_offline_blue",dummy_ushort,0);
    configuration.color_offline.b=(double)dummy_ushort/100;
    gui_confobject.ReadNum("user_other_red",dummy_ushort,0);
    configuration.color_other.r=(double)dummy_ushort/100;
    gui_confobject.ReadNum("user_other_green",dummy_ushort,63);
    configuration.color_other.g=(double)dummy_ushort/100;
    gui_confobject.ReadNum("user_other_blue",dummy_ushort,0);
    configuration.color_other.b=(double)dummy_ushort/100;
    gui_confobject.ReadNum("user_new_red",dummy_ushort,75);
    configuration.color_new.r=(double)dummy_ushort/100;
    gui_confobject.ReadNum("user_new_green",dummy_ushort,75);
    configuration.color_new.g=(double)dummy_ushort/100;
    gui_confobject.ReadNum("user_new_blue",dummy_ushort,0);
    configuration.color_new.b=(double)dummy_ushort/100;
    gui_confobject.ReadNum("history_sent_red",dummy_ushort,100);
    configuration.color_sent.r=(double)dummy_ushort/100;
    gui_confobject.ReadNum("history_sent_green",dummy_ushort,0);
    configuration.color_sent.g=(double)dummy_ushort/100;
    gui_confobject.ReadNum("history_sent_blue",dummy_ushort,0);
    configuration.color_sent.b=(double)dummy_ushort/100;
    gui_confobject.ReadNum("history_rcvd_red",dummy_ushort,0);
    configuration.color_rcvd.r=(double)dummy_ushort/100;
    gui_confobject.ReadNum("history_rcvd_green",dummy_ushort,0);
    configuration.color_rcvd.g=(double)dummy_ushort/100;
    gui_confobject.ReadNum("history_rcvd_blue",dummy_ushort,100);
    configuration.color_rcvd.b=(double)dummy_ushort/100;
    gui_confobject.ReadBool("ignore_incoming_colors",
            configuration.ignoremsgcolors,FALSE);
    
    gui_confobject.SetSection("onevent");
    gui_confobject.ReadBool("use_onevents",configuration.use_onevents,
                            FALSE);
    gui_confobject.ReadBool("beep_onevent",configuration.beep_onevent,
                            FALSE);
    gui_confobject.SetSection("chat");
    gui_confobject.ReadBool("audio",configuration.audio_on,
                            TRUE);
    gui_confobject.ReadBool("show_font_toolbar",configuration.show_font_toolbar,
                            TRUE);
    gui_confobject.ReadBool("show_style_toolbar",configuration.show_style_toolbar,
                            TRUE);
    gui_confobject.ReadBool("use_own_font",configuration.use_own_font,
                            FALSE);
    gui_confobject.ReadBool("use_own_color",configuration.use_own_color,
                            FALSE);
    gui_confobject.ReadNum("single_chat_mode",configuration.chat_mode,
                            0);
    gui_confobject.ReadStr("default_font",configuration.chat_font,"courier");
    gui_confobject.ReadNum("default_font_size",configuration.chat_font_size,12);
    gui_confobject.ReadNum("fg_color",configuration.chat_fg_color,14);
    gui_confobject.ReadNum("bg_color",configuration.chat_bg_color,14);
    gui_confobject.ReadNum("toolbar_style",configuration.toolbar_style,0);
#ifdef USE_PSPELL
    gui_confobject.SetSection("spell");
    gui_confobject.ReadStr("errorfont",configuration.spell_errorfont,"");
    gui_confobject.ReadStr("default_dict",configuration.defaut_dict,"");
    gui_confobject.ReadNum("spell_mode",configuration.spelling_mode,0);
#endif
    gui_confobject.SetSection("file");
    gui_confobject.ReadStr("directory",configuration.file_dir,getenv("HOME"));
    gui_confobject.ReadBool("autoclose",configuration.auto_close_file_win,
                            FALSE);
    gui_confobject.SetSection("security");
    gui_confobject.ReadBool("auto_autosecure",configuration.auto_autosecure,
                            TRUE);

    if(gui_confobject.SetSection("floaties")) {
        gui_confobject.ReadNum("num_floaties",numfloaties,0);
        for(i=0;i<numfloaties;i++) {
            sprintf(fname,"f%d",i);
            if(gui_confobject.ReadStr(fname,alignstr)) {
                if(sscanf(alignstr,"%ld %d %d",&uin,&x,&y)==3&&uin>0) {
                    fs=FLOATIEDATA(malloc(sizeof(floatiedata_t)));
                    fs->uin=uin;
                    fs->x=x;
                    fs->y=y;
                    initial_floaties=g_slist_append(initial_floaties,fs);
                }else {
                    gbug("flotie %s parse error\n",fname);
                }
            }else {
                break;
            }
        }

    }
    return 0;
}

int
save_configuration()
{
    char        *alignstr[3]={"left","right","center"};
    gint        width,height;

    gui_confobject.SetSection("status");
    gui_confobject.WriteNum("autologon",configuration.autologon);
    gui_confobject.WriteBool("invisible",configuration.invisible);
    gui_confobject.WriteNum("autoaway",configuration.autoaway);
    gui_confobject.WriteNum("autona",configuration.autona);
    gui_confobject.WriteNum("autooffline",configuration.autooffline);
    gui_confobject.WriteBool("autoback",configuration.autoback);
    gui_confobject.WriteBool("showstatustimer",configuration.showstatustimer);

    gui_confobject.SetSection("icons");
    gui_confobject.WriteStr("iconset",configuration.iconset);
    gui_confobject.WriteStr("usericondir",configuration.usericondir);

    gui_confobject.SetSection("columns");
    gui_confobject.WriteBool("showtitles",configuration.showcoltitles);
    gui_confobject.WriteStr("col0_title",configuration.columns[0].title);
    gui_confobject.WriteStr("col0_format",configuration.columns[0].format);
    gui_confobject.WriteNum("col0_width",configuration.columns[0].width);
    gui_confobject.WriteStr("col0_align",
            alignstr[configuration.columns[0].align]);
    gui_confobject.WriteBool("col1_active",configuration.columns[1].active);
    gui_confobject.WriteStr("col1_title",configuration.columns[1].title);
    gui_confobject.WriteStr("col1_format",configuration.columns[1].format);
    gui_confobject.WriteNum("col1_width",configuration.columns[1].width);
    gui_confobject.WriteStr("col1_align",
            alignstr[configuration.columns[1].align]);
    gui_confobject.WriteBool("col2_active",configuration.columns[2].active);
    gui_confobject.WriteStr("col2_title",configuration.columns[2].title);
    gui_confobject.WriteStr("col2_format",configuration.columns[2].format);
    gui_confobject.WriteNum("col2_width",configuration.columns[2].width);
    gui_confobject.WriteStr("col2_align",
            alignstr[configuration.columns[2].align]);
    gui_confobject.WriteBool("col3_active",configuration.columns[3].active);
    gui_confobject.WriteStr("col3_title",configuration.columns[3].title);
    gui_confobject.WriteStr("col3_format",configuration.columns[3].format);
    gui_confobject.WriteNum("col3_width",configuration.columns[3].width);
    gui_confobject.WriteStr("col3_align",
            alignstr[configuration.columns[3].align]);
    gui_confobject.WriteNum("quick_search_col",configuration.quicksearchcol);

    gui_confobject.SetSection("fonts");
    gui_confobject.WriteStr("editorfont",configuration.editorfont);
    gui_confobject.WriteStr("contactlistfont",configuration.contactfont);

    gui_confobject.SetSection("other");
    gui_confobject.WriteBool("showofflineusers",configuration.showofflineusers);
    gui_confobject.WriteNum("historylines",configuration.historylines);
    if(main_window&&main_window->window) {
        gdk_window_get_size(main_window->window,
                &width, &height);
        configuration.defaultwidth=width;
        configuration.defaultheight=height;
    }
    gui_confobject.WriteNum("windowwidth",configuration.defaultwidth);
    gui_confobject.WriteNum("windowheight",configuration.defaultheight);
    gui_confobject.WriteNum("windowposx",configuration.default_x);
    gui_confobject.WriteNum("windowposy",configuration.default_y);
    gui_confobject.WriteBool("wm_placement",configuration.wm_placement);
#ifdef USE_GNOME
    gui_confobject.WriteBool("use_gnomeurlviewer",
            configuration.use_gnomeurlviewer);
#endif
    gui_confobject.WriteNum("sortcontactlist1",configuration.sortlist[0]);
    gui_confobject.WriteNum("sortcontactlist2",configuration.sortlist[1]);
    gui_confobject.WriteNum("sortcontactlist3",configuration.sortlist[2]);
    gui_confobject.WriteBool("showgroupmenu",configuration.showgroupmenu);
    gui_confobject.WriteBool("markactiveuser",configuration.showactiveuser);
    gui_confobject.WriteBool("autopopupmessages",configuration.autopopupmessages);
    gui_confobject.WriteBool("onlyautopopupwhenonline",configuration.onlyautopopupwhenonline);
    gui_confobject.WriteBool("singleclick",configuration.singleclick);
    gui_confobject.WriteNum("quotewidth",configuration.quotewidth);
    gui_confobject.WriteBool("autoraise",configuration.autoraise);
    gui_confobject.WriteBool("blinkicons",configuration.blinkicons);
    gui_confobject.WriteBool("autosendthroughserver",
            configuration.autosendthroughserver);
#ifdef USE_PANEL
    gui_confobject.WriteBool("launch_applet",configuration.launchpanel);
    gui_confobject.WriteBool("start_hidden",configuration.starthidden);
#endif

    gui_confobject.SetSection("colors");
    gui_confobject.WriteNum("user_online_red",
            (short unsigned int)(100*configuration.color_online.r));
    gui_confobject.WriteNum("user_online_green",
            (short unsigned int)(100*configuration.color_online.g));
    gui_confobject.WriteNum("user_online_blue",
            (short unsigned int)(100*configuration.color_online.b));
    gui_confobject.WriteNum("user_offline_red",
            (short unsigned int)(100*configuration.color_offline.r));
    gui_confobject.WriteNum("user_offline_green",
            (short unsigned int)(100*configuration.color_offline.g));
    gui_confobject.WriteNum("user_offline_blue",
            (short unsigned int)(100*configuration.color_offline.b));
    gui_confobject.WriteNum("user_other_red",
            (short unsigned int)(100*configuration.color_other.r));
    gui_confobject.WriteNum("user_other_green",
            (short unsigned int)(100*configuration.color_other.g));
    gui_confobject.WriteNum("user_other_blue",
            (short unsigned int)(100*configuration.color_other.b));
    gui_confobject.WriteNum("user_new_red",
            (short unsigned int)(100*configuration.color_new.r));
    gui_confobject.WriteNum("user_new_green",
            (short unsigned int)(100*configuration.color_new.g));
    gui_confobject.WriteNum("user_new_blue",
            (short unsigned int)(100*configuration.color_new.b));
    gui_confobject.WriteNum("history_sent_red",
            (short unsigned int)(100*configuration.color_sent.r));
    gui_confobject.WriteNum("history_sent_green",
            (short unsigned int)(100*configuration.color_sent.g));
    gui_confobject.WriteNum("history_sent_blue",
            (short unsigned int)(100*configuration.color_sent.b));
    gui_confobject.WriteNum("history_rcvd_red",
            (short unsigned int)(100*configuration.color_rcvd.r));
    gui_confobject.WriteNum("history_rcvd_green",
            (short unsigned int)(100*configuration.color_rcvd.g));
    gui_confobject.WriteNum("history_rcvd_blue",
            (short unsigned int)(100*configuration.color_rcvd.b));
    gui_confobject.WriteBool("ignore_incoming_colors",
            configuration.ignoremsgcolors);
    gui_confobject.SetSection("onevent");
    gui_confobject.WriteBool("use_onevents",configuration.use_onevents);
    gui_confobject.WriteBool("beep_onevent",configuration.beep_onevent);
    gui_confobject.SetSection("chat");
    gui_confobject.WriteBool("audio",configuration.audio_on);
    gui_confobject.WriteBool("show_font_toolbar",
            configuration.show_font_toolbar);
    gui_confobject.WriteBool("show_style_toolbar",
            configuration.show_style_toolbar);
    gui_confobject.WriteBool("use_own_font",configuration.use_own_font);
    gui_confobject.WriteBool("use_own_color",configuration.use_own_font);
    gui_confobject.WriteNum("single_chat_mode",configuration.chat_mode);
    gui_confobject.WriteStr("default_font",configuration.chat_font);
    gui_confobject.WriteNum("default_font_size",configuration.chat_font_size);
    gui_confobject.WriteNum("fg_color",configuration.chat_fg_color);
    gui_confobject.WriteNum("bg_color",configuration.chat_bg_color);
    gui_confobject.WriteNum("toolbar_style",configuration.toolbar_style);
#ifdef USE_PSPELL
    gui_confobject.SetSection("spell");
    gui_confobject.WriteStr("errorfont",configuration.spell_errorfont);
    gui_confobject.WriteStr("default_dict",configuration.defaut_dict);
    gui_confobject.WriteNum("spell_mode",configuration.spelling_mode);
#endif
    gui_confobject.SetSection("file");
    gui_confobject.WriteStr("directory",configuration.file_dir);
    gui_confobject.WriteBool("autoclose",configuration.auto_close_file_win);
    gui_confobject.SetSection("security");
    gui_confobject.WriteBool("auto_autosecure",configuration.auto_autosecure);
    gui_confobject.FlushFile();

    return 0;
}

void
apply_options                          (int         reload_pixmaps)
{
    GtkWidget       *status1=lookup_widget(main_window,"status1");
    GtkWidget       *group_menu=lookup_widget(main_window,"group_menu");
    GtkWidget       *alias_clist=lookup_widget(main_window,"alias_clist");
    GtkWidget       *use_mini_mode1=lookup_widget(main_window,"use_mini_mode1");
    GdkPixMask_t    *ustatus;
    gboolean        minimode=FALSE;

    if (reload_pixmaps) {
        load_pixmaps();
    }
    rebuild_all_floating_windows();
    init_main_contactlist();
    alias_clist=lookup_widget(main_window,"alias_clist");
    minimode=GTK_CHECK_MENU_ITEM(use_mini_mode1)->active;
    real_refresh_contactlist(contactlist_current_group,
            alias_clist,TRUE,NULL);
    init_eventwindows_contactlists();

    load_colors();
    gtk_menu_item_set_submenu(GTK_MENU_ITEM(status1),
            create_status_menu(
                GTK_SIGNAL_FUNC(on_set_status_with_message_activate),
                GTK_SIGNAL_FUNC(on_set_status_with_no_message_activate),
                TRUE,TRUE,TRUE));

    if(minimode) {
        if(GTK_WIDGET_VISIBLE(alias_clist)) {
            gtk_widget_hide(alias_clist);
        }
    }
    if(minimode||!configuration.showgroupmenu) {
        if(GTK_WIDGET_VISIBLE(group_menu)) {
            gtk_widget_hide(group_menu);
        }
        contactlist_current_group=0;
    }else {
        if(!GTK_WIDGET_VISIBLE(group_menu)) {
            gtk_widget_show(group_menu);
        }
    }
#ifdef USE_PANEL
    if(configuration.launchpanel&&!nopanel) {
        if(!panel_dockapp) {
            create_dock_widget();
        }
    }
#endif
    if(!blinkfunctionactive&&configuration.blinkicons) {
        blinkfunctionactive=TRUE;
        g_timeout_add(300,icon_blink_function,NULL);
    }
    if(!statustimerfunctionactive&&configuration.showstatustimer) {
        statustimerfunctionactive=TRUE;
        g_timeout_add(60000,update_status_timer,NULL);
    }
    update_status_timer(NULL);
    
    update_status_display();
}

int
init_main_contactlist()
{
    GtkWidget           *scrolledwindow_contactlist=lookup_widget(
            main_window,"scrolledwindow_contactlist");
    GtkWidget           *newlist, *alias_clist;

    alias_clist=lookup_widget(main_window,"alias_clist");
    if(alias_clist) {
        gtk_widget_destroy(alias_clist); 
    }
    if(!(alias_clist=create_contactlist(scrolledwindow_contactlist,TRUE))) {
        showokdialog(_("Failure"),_("Failed to create a contactlist"));
        return -1;
    }
    return 0;
}

void
init_eventwindows_contactlists()
{
    GtkWidget   *alias_clist,*multimess_scrolledwindow,*contacts_to_send_clist,
                *contacts_to_select_clist,*event_window;
    GtkWidget   *contactlist=lookup_widget(main_window,"alias_clist");
    GtkWidget   *newlist;
    GList       *rows,*selection;
    GtkStyle    *style;

    if(!contactlist) {
        return ;
    }
    rows=GTK_CLIST(contactlist)->row_list;
    while(rows) {
        if(rows->data&&((GtkCListRow*)(rows->data))->data&&
                ((userdata_t*)(((GtkCListRow*)(rows->data))->data))->send_event_window) {
            event_window=((userdata_t*)(((GtkCListRow*)(rows->data))->data))->send_event_window;
            alias_clist=lookup_widget(event_window, "alias_clist");
            if(alias_clist) {
                selection=get_contactlist_selected_uin(alias_clist);
                multimess_scrolledwindow=lookup_widget(
                        alias_clist,"multimess_scrolledwindow");
                gtk_widget_destroy(alias_clist);
                if(!create_contactlist(multimess_scrolledwindow,FALSE)) {
                    showokdialog(_("Failure"),_("Failed to create a contactlist"));
                    g_list_foreach(selection,g_list_foreach_destroy,NULL);
                    g_list_free(selection);
                }else {
                    alias_clist=lookup_widget(multimess_scrolledwindow,
                            "alias_clist");
                    real_refresh_contactlist(0,alias_clist,FALSE,selection);
                }
            }
            if(*configuration.contactfont&&
                    (style=gtk_widget_get_style(contactlist))) {
                contacts_to_send_clist=lookup_widget(event_window,
                        "contacts_to_send_clist");
                contacts_to_select_clist=lookup_widget(event_window,
                        "contacts_to_select_clist");
                gtk_style_ref(style);
                gtk_widget_ensure_style(contacts_to_send_clist);
                gtk_widget_ensure_style(contacts_to_select_clist);
                gtk_widget_set_style(contacts_to_send_clist,style);
                gtk_widget_set_style(contacts_to_select_clist,style);
            }
        }
        rows=g_list_next(rows);
    }
}

GtkWidget *
create_contactlist                     (GtkWidget   *scrolledwindow,
                                        gboolean    ismainlist)
{
    GtkWidget           *alias_clist, *label;
    int                 colcount=1,i,colndx;
    GdkGC               *contactgc;
    GtkStyle            *clist_style;
    GdkFont             *font;
    GtkWidget           *toplevel=gtk_widget_get_toplevel(
            GTK_WIDGET(scrolledwindow));

    for(i=1;i<4;i++) {
        if(configuration.columns[i].active&&configuration.columns[i].width) {
            colcount++;
        }
    }
    alias_clist = gtk_clist_new (colcount+1);
    gtk_widget_ref (alias_clist);
    gtk_container_add(GTK_CONTAINER(scrolledwindow),
            alias_clist);
    gtk_object_set_data_full(GTK_OBJECT(toplevel),
            "alias_clist", 
            alias_clist, (GtkDestroyNotify) gtk_widget_unref);
    gtk_widget_show (alias_clist);

    GTK_WIDGET_UNSET_FLAGS (alias_clist, GTK_CAN_FOCUS);
    gtk_clist_set_column_width (GTK_CLIST (alias_clist), 0, FIRST_COLUMN_WIDTH);

    label=gtk_label_new("S");
    gtk_widget_ref(label);
    gtk_object_set_data_full(GTK_OBJECT(toplevel),"dummy",
            label,(GtkDestroyNotify) gtk_widget_unref);
    gtk_widget_show(label);
    gtk_clist_set_column_widget(GTK_CLIST (alias_clist), 0, label);
    gtk_clist_set_column_justification(GTK_CLIST(alias_clist),0,
            GTK_JUSTIFY_CENTER);
    gtk_misc_set_alignment(GTK_MISC(label), 0, 1.0);
    gtk_label_set_justify(GTK_LABEL(label), GTK_JUSTIFY_CENTER);

    colndx=1;
    for(i=0;i<4;i++) {
        if(!i||(configuration.columns[i].active&&
                    configuration.columns[i].width)) {
            gtk_clist_set_column_width(GTK_CLIST (alias_clist),colndx,
                    configuration.columns[i].width);
            label=gtk_label_new(configuration.columns[i].title);
            gtk_widget_ref(label);
            gtk_object_set_data_full(GTK_OBJECT(toplevel),"dummy",
                    label,(GtkDestroyNotify) gtk_widget_unref);
            gtk_widget_show(label);
            gtk_clist_set_column_widget(GTK_CLIST (alias_clist), colndx, label);

            switch(configuration.columns[i].align) {
                case GTK_JUSTIFY_RIGHT:
                    gtk_misc_set_alignment(GTK_MISC(label), 0, 1.0);
                    break;
                case GTK_JUSTIFY_CENTER:
                    gtk_misc_set_alignment(GTK_MISC(label), 0, 0.5);
                    break;
                case GTK_JUSTIFY_LEFT:
                default:
                    gtk_misc_set_alignment(GTK_MISC(label), 0, 0);
                    break;
            }
            gtk_label_set_justify(GTK_LABEL(label),
                    configuration.columns[i].align);
            gtk_clist_set_column_justification(GTK_CLIST(alias_clist),colndx,
                    configuration.columns[i].align);

            colndx++;
        }
    }
    gtk_clist_set_shadow_type (GTK_CLIST (alias_clist), GTK_SHADOW_ETCHED_OUT);

    if(ismainlist) {
        gtk_signal_connect (GTK_OBJECT (alias_clist), "button_press_event",
                GTK_SIGNAL_FUNC (on_alias_clist_button_press_event),
                NULL);
        gtk_signal_connect (GTK_OBJECT (alias_clist), "resize-column",
                GTK_SIGNAL_FUNC (on_alias_clist_column_resize_event),
                NULL);
        gtk_clist_set_button_actions(GTK_CLIST(alias_clist), 0, 
                    GTK_BUTTON_IGNORED);
    }else {
        gtk_signal_connect(GTK_OBJECT(alias_clist),
                "select-row",
                GTK_SIGNAL_FUNC(on_event_alias_clist_row_select),
                NULL);
        gtk_signal_connect(GTK_OBJECT(alias_clist),
                "unselect-row",
                GTK_SIGNAL_FUNC(on_event_alias_clist_row_select),
                NULL);
        gtk_clist_set_selection_mode(GTK_CLIST(alias_clist),
                GTK_SELECTION_MULTIPLE);
    }
    if(configuration.sortlist[0]) {
        gtk_clist_set_compare_func(GTK_CLIST(alias_clist),
                (GtkCListCompareFunc)contactlist_sort);
    }

    gtk_widget_ensure_style(alias_clist);
    clist_style=gtk_style_copy(gtk_widget_get_style(alias_clist));
    
    if(*configuration.contactfont) {
        if((font=gdk_font_load(configuration.contactfont))) {
            gdk_font_unref(clist_style->font);
            clist_style->font=font;
            gdk_font_ref(clist_style->font);
        }
    }
    gtk_widget_set_style(alias_clist,clist_style);
    gtk_clist_column_titles_passive (GTK_CLIST(alias_clist));
    if(configuration.showcoltitles) {
        gtk_clist_column_titles_show(GTK_CLIST(alias_clist));
    }else {
        gtk_clist_column_titles_hide(GTK_CLIST(alias_clist));
    }
    if(GTK_CLIST(alias_clist)->row_height<16) {
        gtk_clist_set_row_height(GTK_CLIST(alias_clist),16);
    }
   
    gtk_drag_dest_set (alias_clist,
            GTK_DEST_DEFAULT_ALL,
            target_table, 3 ,
            (GdkDragAction)(GDK_ACTION_COPY | GDK_ACTION_MOVE));

    gtk_signal_connect (GTK_OBJECT (alias_clist), "drag_data_received",
            GTK_SIGNAL_FUNC (on_alias_clist_drag_data_received), NULL);

    gtk_signal_connect (GTK_OBJECT (alias_clist), "drag_motion",
            GTK_SIGNAL_FUNC (on_alias_clist_drag_motion), NULL);

    if(configuration.showactiveuser||!ismainlist) {
        gtk_drag_source_set(alias_clist,
                GDK_BUTTON1_MASK,target_table,1,
                (GdkDragAction)(GDK_ACTION_COPY | GDK_ACTION_MOVE));
        gtk_drag_source_set_icon(alias_clist,
                gtk_widget_get_colormap(main_window),status_pixmap_contacts.pix,
            status_pixmap_contacts.mask);

        gtk_signal_connect(GTK_OBJECT(alias_clist),
                "drag_data_get",
                GTK_SIGNAL_FUNC(on_contacts_list_drag_data_get),NULL);
    }
    
    return alias_clist;
}

void
autoconnect()
{
    unsigned short status = 0;
    switch(configuration.autologon) {
        case 0: /*  Offline     */
            last_status = ICQ_STATUS_ONLINE;
            return;
        case 1: /*  Online      */
            status=(ICQ_STATUS_ONLINE);
            last_status = ICQ_STATUS_AWAY;
            break;
        case 2: /*  Away        */
            status=(ICQ_STATUS_AWAY);
            last_status = ICQ_STATUS_ONLINE;
            break;
        case 3: /*  Not Avail   */
            status=(ICQ_STATUS_NA);
            last_status = ICQ_STATUS_ONLINE;
            break;
        case 4: /*  Do Not ..   */
            status=(ICQ_STATUS_DND);
            last_status = ICQ_STATUS_ONLINE;
            break;
        case 5: /*  Occupied    */
            status=(ICQ_STATUS_OCCUPIED);
            last_status = ICQ_STATUS_ONLINE;
            break;
        case 6: /*  FFC         */
            status=(ICQ_STATUS_FREEFORCHAT);
            last_status = ICQ_STATUS_ONLINE;
            break;
    }
    if(configuration.invisible) {
        status |= ICQ_STATUS_FxPRIVATE;
    }
    licq_daemon->icqLogon(status);
    gbug("autoconnect: %x\n",status);
}

GtkWidget*
create_status_menu                     (GtkSignalFunc 
                                                    msgfunc,
                                        GtkSignalFunc 
                                                    nomsgfunc,
                                        gboolean    createinvisible,
                                        gboolean    addaccell,
                                        gboolean    addonandoffline)
{
    GtkWidget *status_menu;
    GtkAccelGroup *status_menu_accels;
    GtkAccelGroup *keyaccels;
    GtkWidget *online2=NULL;
    GtkWidget *offline2=NULL;
    GtkWidget *away2;
    GtkWidget *not_available2;
    GtkWidget *do_not_disturb2;
    GtkWidget *occupied2;
    GtkWidget *free_for_chat2;
    GtkWidget *separator11;
    GtkWidget *invisible2=NULL;


    status_menu = gtk_menu_new ();
    gtk_object_set_data (GTK_OBJECT (status_menu), "status_menu", status_menu);
    if(addaccell) {
        status_menu_accels = gtk_menu_ensure_uline_accel_group (
                GTK_MENU (status_menu));
    }
    if(addonandoffline) {
        online2 = gtk_menu_item_new_with_label_color_and_pixmap (_("Online"),
                &statuscolor_online,&status_pixmap_online);
        gtk_widget_ref (online2);
        gtk_object_set_data_full (GTK_OBJECT (status_menu), "online2", online2,
                (GtkDestroyNotify) gtk_widget_unref);
        gtk_widget_show (online2);
        gtk_container_add (GTK_CONTAINER (status_menu), online2);

        offline2 = gtk_menu_item_new_with_label_color_and_pixmap (_("Offline"),
                &statuscolor_offline,&status_pixmap_offline);
        gtk_widget_ref (offline2);
        gtk_object_set_data_full (GTK_OBJECT (status_menu), "offline2", offline2,
                (GtkDestroyNotify) gtk_widget_unref);
        gtk_widget_show (offline2);
        gtk_container_add (GTK_CONTAINER (status_menu), offline2);
    }

    away2 = gtk_menu_item_new_with_label_color_and_pixmap (_("Away"),
            &statuscolor_other,&status_pixmap_away);
    gtk_widget_ref (away2);
    gtk_object_set_data_full (GTK_OBJECT (status_menu), "away2", away2,
            (GtkDestroyNotify) gtk_widget_unref);
    gtk_widget_show (away2);
    gtk_container_add (GTK_CONTAINER (status_menu), away2);

    not_available2 = gtk_menu_item_new_with_label_color_and_pixmap (
            _("Not Available"),&statuscolor_other,&status_pixmap_na);
    gtk_widget_ref (not_available2);
    gtk_object_set_data_full (GTK_OBJECT (status_menu), "not_available2", 
            not_available2, (GtkDestroyNotify) gtk_widget_unref);
    gtk_widget_show (not_available2);
    gtk_container_add (GTK_CONTAINER (status_menu), not_available2);

    do_not_disturb2 = gtk_menu_item_new_with_label_color_and_pixmap (
            _("Do Not Disturb"),&statuscolor_other,&status_pixmap_dnd);
    gtk_widget_ref (do_not_disturb2);
    gtk_object_set_data_full (GTK_OBJECT (status_menu), "do_not_disturb2", 
            do_not_disturb2, (GtkDestroyNotify) gtk_widget_unref);
    gtk_widget_show (do_not_disturb2);
    gtk_container_add (GTK_CONTAINER (status_menu), do_not_disturb2);

    occupied2 = gtk_menu_item_new_with_label_color_and_pixmap (
            _("Occupied"),&statuscolor_other,&status_pixmap_occupied);
    gtk_widget_ref (occupied2);
    gtk_object_set_data_full (GTK_OBJECT (status_menu), "occupied2", occupied2,
            (GtkDestroyNotify) gtk_widget_unref);
    gtk_widget_show (occupied2);
    gtk_container_add (GTK_CONTAINER (status_menu), occupied2);

    free_for_chat2 = gtk_menu_item_new_with_label_color_and_pixmap (
            _("Free for Chat"),&statuscolor_online,&status_pixmap_ffc);
    gtk_widget_ref (free_for_chat2);
    gtk_object_set_data_full (GTK_OBJECT (status_menu), "free_for_chat2", 
            free_for_chat2, (GtkDestroyNotify) gtk_widget_unref);
    gtk_widget_show (free_for_chat2);
    gtk_container_add (GTK_CONTAINER (status_menu), free_for_chat2);
    
    if(createinvisible) {
        separator11 = gtk_menu_item_new ();
        gtk_widget_ref (separator11);
        gtk_object_set_data_full (GTK_OBJECT (status_menu), "separator11", 
                separator11, (GtkDestroyNotify) gtk_widget_unref);
        gtk_widget_show (separator11);
        gtk_container_add (GTK_CONTAINER (status_menu), separator11);
        gtk_widget_set_sensitive (separator11, FALSE);

        invisible2 = gtk_menu_item_new_with_label_color_and_pixmap (
                _("Invisible"),&statuscolor_offline,&status_pixmap_private);
        gtk_widget_ref (invisible2);
        gtk_object_set_data_full (GTK_OBJECT (status_menu), "invisible2", 
                invisible2, (GtkDestroyNotify) gtk_widget_unref);
        gtk_widget_show (invisible2);
        gtk_container_add (GTK_CONTAINER (status_menu), invisible2);
    }

    gtk_signal_connect (GTK_OBJECT (status_menu), "show",
            GTK_SIGNAL_FUNC(on_status_menu_show), 
            NULL);
    if(addonandoffline) {
        gtk_signal_connect (GTK_OBJECT (online2), "activate",
                GTK_SIGNAL_FUNC (nomsgfunc),
                GINT_TO_POINTER(ICQ_STATUS_ONLINE));
        gtk_signal_connect (GTK_OBJECT (offline2), "activate",
                GTK_SIGNAL_FUNC (nomsgfunc),
                GINT_TO_POINTER(ICQ_STATUS_OFFLINE));
    }
    gtk_signal_connect (GTK_OBJECT (away2), "activate",
            GTK_SIGNAL_FUNC (msgfunc),
            GINT_TO_POINTER(ICQ_STATUS_AWAY));
    gtk_signal_connect (GTK_OBJECT (not_available2), "activate",
            GTK_SIGNAL_FUNC (msgfunc),
            GINT_TO_POINTER(ICQ_STATUS_NA));
    gtk_signal_connect (GTK_OBJECT (do_not_disturb2), "activate",
            GTK_SIGNAL_FUNC (msgfunc),
            GINT_TO_POINTER(ICQ_STATUS_DND));
    gtk_signal_connect (GTK_OBJECT (occupied2), "activate",
            GTK_SIGNAL_FUNC (msgfunc),
            GINT_TO_POINTER(ICQ_STATUS_OCCUPIED));
    gtk_signal_connect (GTK_OBJECT (free_for_chat2), "activate",
            GTK_SIGNAL_FUNC (msgfunc),
            GINT_TO_POINTER(ICQ_STATUS_FREEFORCHAT));
    if(createinvisible) {
        gtk_signal_connect (GTK_OBJECT (invisible2), "activate",
                GTK_SIGNAL_FUNC (on_set_status_invisible_activate),
                NULL);
    }

    if(addaccell) {
        keyaccels = gtk_accel_group_new();
        if(addonandoffline) {
            gtk_accel_group_add(keyaccels,GDK_O,GDK_MOD1_MASK,GTK_ACCEL_VISIBLE,
                    GTK_OBJECT(online2),
                    "activate");

            gtk_accel_group_add(keyaccels,GDK_A,GDK_MOD1_MASK,GTK_ACCEL_VISIBLE,
                    GTK_OBJECT(away2),
                    "activate");
        }

        gtk_accel_group_add(keyaccels,GDK_N,GDK_MOD1_MASK,GTK_ACCEL_VISIBLE,
                GTK_OBJECT(not_available2),
                "activate");

        gtk_accel_group_add(keyaccels,GDK_C,GDK_MOD1_MASK,GTK_ACCEL_VISIBLE,
                GTK_OBJECT(occupied2),
                "activate");

        gtk_accel_group_add(keyaccels,GDK_D,GDK_MOD1_MASK,GTK_ACCEL_VISIBLE,
                GTK_OBJECT(do_not_disturb2),
                "activate");

        gtk_accel_group_add(keyaccels,GDK_H,GDK_MOD1_MASK,GTK_ACCEL_VISIBLE,
                GTK_OBJECT(offline2),
                "activate");

        gtk_accel_group_add(keyaccels,GDK_F,GDK_MOD1_MASK,GTK_ACCEL_VISIBLE,
                GTK_OBJECT(free_for_chat2),
                "activate");
        if(createinvisible) {
            gtk_accel_group_add(keyaccels,GDK_I,GDK_MOD1_MASK,GTK_ACCEL_VISIBLE,
                    GTK_OBJECT(invisible2),
                    "activate");
        }
        gtk_window_add_accel_group(GTK_WINDOW(main_window),keyaccels);
    }

    return status_menu;
}

GtkWidget *
create_send_menu                       (GtkWidget   *user_popup,
                                        ICQUser     *user)
{
    GtkWidget *send1_menu;
    GtkAccelGroup *send1_menu_accels;
    GtkWidget *send_message1;
    GtkWidget *send_url1;
    GtkWidget *send_chat_request1;
    GtkWidget *send_file_transfer1;
    GtkWidget *send_autorization1;
    GtkWidget *send_contacts1;

    send1_menu = gtk_menu_new ();
    gtk_widget_ref (send1_menu);
    gtk_object_set_data_full (GTK_OBJECT (user_popup), "send1_menu", send1_menu,
            (GtkDestroyNotify) gtk_widget_unref);
    send1_menu_accels = gtk_menu_ensure_uline_accel_group(GTK_MENU(send1_menu));

    send_message1 = gtk_menu_item_new_with_label_color_and_pixmap(
            _("Send Message"),NULL,&status_pixmap_message);
    gtk_widget_ref (send_message1);
    gtk_object_set_data_full (GTK_OBJECT (user_popup), "send_message1", 
            send_message1, (GtkDestroyNotify) gtk_widget_unref);
    gtk_widget_show (send_message1);
    gtk_container_add (GTK_CONTAINER (send1_menu), send_message1);

    send_url1 = gtk_menu_item_new_with_label_color_and_pixmap (
            _("Send Url"),NULL,&status_pixmap_url);
    gtk_widget_ref (send_url1);
    gtk_object_set_data_full (GTK_OBJECT (user_popup), "send_url1", send_url1,
            (GtkDestroyNotify) gtk_widget_unref);
    gtk_widget_show (send_url1);
    gtk_container_add (GTK_CONTAINER (send1_menu), send_url1);

    send_chat_request1 = gtk_menu_item_new_with_label_color_and_pixmap (
            _("Send Chat Request"),NULL,&status_pixmap_chat);
    gtk_widget_ref (send_chat_request1);
    gtk_object_set_data_full (GTK_OBJECT (user_popup), "send_chat_request1", 
            send_chat_request1, (GtkDestroyNotify) gtk_widget_unref);
    gtk_widget_show (send_chat_request1);
    gtk_container_add (GTK_CONTAINER (send1_menu), send_chat_request1);

    send_file_transfer1 = gtk_menu_item_new_with_label_color_and_pixmap (
            _("Send File Transfer"),NULL,&status_pixmap_file);
    gtk_widget_ref (send_file_transfer1);
    gtk_object_set_data_full (GTK_OBJECT (user_popup), "send_file_transfer1", 
            send_file_transfer1, (GtkDestroyNotify) gtk_widget_unref);
    gtk_widget_show (send_file_transfer1);
    gtk_container_add (GTK_CONTAINER (send1_menu), send_file_transfer1);
    send_contacts1 = gtk_menu_item_new_with_label_color_and_pixmap (
            _("Send Contacts"),NULL,&status_pixmap_contacts);
    gtk_widget_ref (send_contacts1);
    gtk_object_set_data_full (GTK_OBJECT (user_popup), "send_contacts1", 
            send_contacts1, (GtkDestroyNotify) gtk_widget_unref);
    gtk_widget_show (send_contacts1);
    gtk_container_add (GTK_CONTAINER (send1_menu), send_contacts1);

    send_autorization1 = gtk_menu_item_new_with_label_color_and_pixmap (
            _("Send Authorization"),NULL,&status_pixmap_authorize);
    gtk_widget_ref (send_autorization1);
    gtk_object_set_data_full (GTK_OBJECT (user_popup), "send_autorization1", 
            send_autorization1, (GtkDestroyNotify) gtk_widget_unref);
    gtk_widget_show (send_autorization1);
    gtk_container_add (GTK_CONTAINER (send1_menu), send_autorization1);

    gtk_signal_connect (GTK_OBJECT (send_message1), "activate",
            GTK_SIGNAL_FUNC (on_send_message1_activate),
            NULL);
    gtk_signal_connect (GTK_OBJECT (send_url1), "activate",
            GTK_SIGNAL_FUNC (on_send_url1_activate),
            NULL);
    gtk_signal_connect (GTK_OBJECT (send_chat_request1), "activate",
            GTK_SIGNAL_FUNC (on_send_chat_request1_activate),
            NULL);
    gtk_signal_connect (GTK_OBJECT (send_file_transfer1), "activate",
            GTK_SIGNAL_FUNC (on_send_file_transfer1_activate),
            NULL);
    gtk_signal_connect (GTK_OBJECT (send_autorization1), "activate",
            GTK_SIGNAL_FUNC (on_send_autorization1_activate),
            NULL);
    gtk_signal_connect (GTK_OBJECT (send_contacts1), "activate",
            GTK_SIGNAL_FUNC (on_send_contacts1_activate),
            NULL);
    if(user->Status()==ICQ_STATUS_OFFLINE) {
        gtk_widget_set_sensitive(send_chat_request1,FALSE);
        gtk_widget_set_sensitive(send_file_transfer1,FALSE);
    }

    return send1_menu;
}

GtkWidget *
create_utilities_menu                  (GtkWidget   *parent_menu) 
{
    CUtility    *util;
    gint        cnt,i;
    GtkWidget   *menu,*menuitem;

    menu=gtk_menu_new();
    gtk_widget_ref(menu);
    gtk_object_set_data_full(GTK_OBJECT(parent_menu), "dummy_menu",menu,
            (GtkDestroyNotify)gtk_widget_unref);
    cnt=gUtilityManager.NumUtilities();
    for(i=0;i<cnt;i++) {
        util=gUtilityManager.Utility(i);
        menuitem=gtk_menu_item_new_with_label(util->Name());
        gtk_widget_ref(menuitem);
        gtk_object_set_data_full(GTK_OBJECT(menu), "dummy",
                menuitem,(GtkDestroyNotify) gtk_widget_unref);
        gtk_signal_connect(GTK_OBJECT(menuitem),"activate",
                GTK_SIGNAL_FUNC(utilty_activate),
                GINT_TO_POINTER(i));
        gtk_menu_append(GTK_MENU(menu),menuitem);
    }
    gtk_widget_show_all(menu);
    return menu;
}

void
rebuild_initial_floaties()
{
    GSList      *f;
    GtkWidget   *w;
    userdata_t  *udata;

    for(f=initial_floaties;f;f=g_slist_next(f)) {
        if(!(udata=find_user_data(FLOATIEDATA(f->data)->uin,NULL))) {
            continue ;
        }

        if((w=create_user_floating_window(FLOATIEDATA(f->data)->uin))) {
            gtk_widget_set_uposition(w,FLOATIEDATA(f->data)->x,
                    FLOATIEDATA(f->data)->y);
            gbug("created floatie for %ld\n",FLOATIEDATA(f->data)->uin);
            free(f->data);
            udata->floating_window=w;
        }
    }
    g_slist_free(initial_floaties);
    initial_floaties=NULL;
    rebuild_all_floating_windows();
}
