#include "gtk-gui.h"


void
messagedlg_shutdown_run(GtkWidget   *dialog,
        messagedlgruninfo_t *runinfo)
{
    int     i;

    if (!runinfo->destroyed) {
        gtk_signal_disconnect(GTK_OBJECT(dialog),
                runinfo->close_id);
        gtk_signal_disconnect(GTK_OBJECT(dialog),
                runinfo->destroy_id);
        runinfo->close_id = runinfo->destroy_id = 0;
        for(i=0;i<MESSAGEDLG_MAX_BUTTON_COUNT;i++) {
            if(runinfo->btnconnects[i]>0) {
                gtk_signal_disconnect(GTK_OBJECT(runinfo->buttons[i]),
                        runinfo->btnconnects[i]);
                runinfo->btnconnects[i]=0;
            }
        }
    }
    if(runinfo->modal) {
        gtk_main_quit();
    }else {
        if(!runinfo->destroyed) {
            runinfo->destroyed=TRUE;
            gtk_widget_destroy(dialog);
        }
    }
}

void
messagedlg_buttonpress  (GtkWidget  *button,
        messagedlgruninfo_t *runinfo)
{
    runinfo->button_number=GPOINTER_TO_INT(
            gtk_object_get_user_data(GTK_OBJECT(button)));
    messagedlg_shutdown_run(runinfo->dialog,runinfo);
}

gboolean
messagedlg_destroyed(GtkWidget *widget,
        GdkEvent *event,
        messagedlgruninfo_t *runinfo)
{
    if(!runinfo->destroyed) {
        runinfo->destroyed=TRUE;
        messagedlg_shutdown_run(runinfo->dialog,runinfo); 
    }
    if(!runinfo->modal) {
        free(runinfo);
    }
    return FALSE; 
}

void
messagedlg_hidden  (GtkWidget  *dialog,
        messagedlgruninfo_t *runinfo)
{
    messagedlg_shutdown_run(runinfo->dialog,runinfo);
}

int
addbuttontocontainer(   GtkButtonBox        *container,
                        gchar               *title,
                        gint                returnvalue,
                        messagedlgruninfo_t *runinfo,
                        gint                index)
{
    GtkWidget       *button;

    button=gtk_button_new_with_label(title); 
    runinfo->buttons[index]=button;
    runinfo->btnconnects[index]=gtk_signal_connect(GTK_OBJECT(button), 
            "clicked", GTK_SIGNAL_FUNC(messagedlg_buttonpress), runinfo);
    gtk_object_set_user_data(GTK_OBJECT(button),GINT_TO_POINTER(returnvalue));
    gtk_container_add(GTK_CONTAINER(container), button);
    
    return 0;
}

int
adddlgbuttontocontainer(    GtkButtonBox        *container,
                            gint                buttons,
                            messagedlgruninfo_t *runinfo,
                            gint                index)
{
    GtkWidget       *button;

    switch(buttons) {
        case DLGBUTTON_OK:
            button=gtk_licq_button(GTK_LICQ_BUTTON_OK);
            break;
        case DLGBUTTON_YES:
            button=gtk_licq_button(GTK_LICQ_BUTTON_YES);
            break;
        case DLGBUTTON_NO:
            button=gtk_licq_button(GTK_LICQ_BUTTON_NO);
            break;
        case DLGBUTTON_CANCEL:
            button=gtk_licq_button(GTK_LICQ_BUTTON_CANCEL);
            break;
        case DLGBUTTON_ABORT:
            button=gtk_button_new_with_label(_("Abort"));
            break;
        default:
            button=NULL;
    }
    if(!button) {
        return -1;
    }

    runinfo->buttons[index]=button;
    runinfo->btnconnects[index]=gtk_signal_connect(GTK_OBJECT(button), 
            "clicked", GTK_SIGNAL_FUNC(messagedlg_buttonpress), runinfo);
    gtk_object_set_user_data(GTK_OBJECT(button),GINT_TO_POINTER(buttons));
    gtk_container_add(GTK_CONTAINER(container), button);

    return 0;
}

int
showdialog(     gchar               *title,
                messagedlgruninfo_t *runinfo,
                GtkButtonBox        *buttonbox,
                GtkWidget           *topwidget)
{
    GtkWidget       *dialog;

    if(!runinfo||!buttonbox) {
        return -1;
    }

    runinfo->destroyed=FALSE;

    dialog=gtk_dialog_new();
    if(title) {
        gtk_window_set_title(GTK_WINDOW(dialog), title);
    }

    runinfo->modal=(g_list_length(gtk_container_children(
                    GTK_CONTAINER(buttonbox)))>1);

    if(!gtk_container_children(GTK_CONTAINER(buttonbox))) {
        adddlgbuttontocontainer(buttonbox,DLGBUTTON_OK,runinfo,0);
    }
    runinfo->dialog=dialog;   
    runinfo->destroy_id=gtk_signal_connect(GTK_OBJECT(dialog), "destroy", 
            GTK_SIGNAL_FUNC(messagedlg_destroyed), (gpointer)runinfo); 
    runinfo->close_id=gtk_signal_connect(GTK_OBJECT(dialog), "hide", 
            GTK_SIGNAL_FUNC(messagedlg_hidden), (gpointer)runinfo); 

    gtk_container_add(GTK_CONTAINER(GTK_DIALOG(dialog)->vbox),
            topwidget);
    gtk_container_add(GTK_CONTAINER(GTK_DIALOG(dialog)->action_area),
            GTK_WIDGET(buttonbox));
    gtk_window_set_position(GTK_WINDOW(dialog), GTK_WIN_POS_MOUSE);
    if(runinfo->modal) {
        gtk_window_set_modal(GTK_WINDOW(dialog), TRUE);
        gtk_widget_show_all(dialog);
        gtk_main();
        if(!runinfo->destroyed) {
            if(GTK_WIDGET_VISIBLE(dialog)) {
                gtk_widget_hide(dialog);
            }
            gtk_widget_destroy(dialog);
            return runinfo->button_number;
        }
        free(runinfo);
    }else {
        gtk_widget_show_all(dialog);
    }
    return 0; 
}


int 
showbasicdialog(gchar           *title,
                gint            buttons,
                GtkWidget       *topwidget)
{
    GtkWidget       *buttonbox;
    gint            buttonarr[MESSAGEDLG_MAX_BUTTON_COUNT]={DLGBUTTON_OK,
        DLGBUTTON_YES,DLGBUTTON_NO, DLGBUTTON_CANCEL,DLGBUTTON_ABORT};
    int             i;
    messagedlgruninfo_t     *runinfo;

    if(!buttons||!(runinfo=(messagedlgruninfo_t*)malloc(
                    sizeof(messagedlgruninfo_t)))) {
        return -1;
    }
    for(i=0;i<MESSAGEDLG_MAX_BUTTON_COUNT;i++) {
        runinfo->btnconnects[i]=0;
    }
    buttonbox=gtk_hbutton_box_new();
    gtk_button_box_set_layout(GTK_BUTTON_BOX(buttonbox),
            GTK_BUTTONBOX_SPREAD);
    for(i=0;i<MESSAGEDLG_MAX_BUTTON_COUNT;i++) {
        if(buttons&buttonarr[i]) {
            adddlgbuttontocontainer(GTK_BUTTON_BOX(buttonbox), 
                    buttonarr[i], runinfo,i);
        }
    }
    return showdialog(title,runinfo,GTK_BUTTON_BOX(buttonbox),topwidget);
}


int
showtextdialogcustom(   gchar           *title,
                        gchar           *message,
                        gchar           *buttons[])
{
    GtkWidget               *label;
    GtkWidget               *buttonbox;
    int                     i;
    messagedlgruninfo_t     *runinfo;

    label=gtk_label_new(message);
    gtk_label_set_justify (GTK_LABEL (label),GTK_JUSTIFY_LEFT);
    gtk_misc_set_padding(GTK_MISC(label),20,30);

    if(!buttons||!(runinfo=(messagedlgruninfo_t*)malloc(
                    sizeof(messagedlgruninfo_t)))) {
        return -1;
    }

    for(i=0;i<MESSAGEDLG_MAX_BUTTON_COUNT;i++) {
        runinfo->btnconnects[i]=0;
    }

    buttonbox=gtk_hbutton_box_new();
    gtk_button_box_set_layout(GTK_BUTTON_BOX(buttonbox),
            GTK_BUTTONBOX_SPREAD);
    for(i=0;i<MESSAGEDLG_MAX_BUTTON_COUNT&&buttons[i];i++) {
        addbuttontocontainer(GTK_BUTTON_BOX(buttonbox),buttons[i],
               i,runinfo,i); 
    }

    return showdialog(title,runinfo,GTK_BUTTON_BOX(buttonbox),label);
}

int
showtextdialog( gchar           *title,
                gchar           *message,
                gint            buttons)
{
    GtkWidget       *label;

    label=gtk_label_new(message);
    gtk_label_set_justify (GTK_LABEL (label),GTK_JUSTIFY_LEFT);
    gtk_misc_set_padding(GTK_MISC(label),20,30);
    return showbasicdialog(title, buttons, label);
}


int
showokdialog(   gchar           *title,
                gchar           *message)
{
    return showtextdialog(title, message, DLGBUTTON_OK);
}

