#ifndef MESSAGEDLG_H_INCLUDED
#define MESSAGEDLG_H_INCLUDED

#define DLGBUTTON_OK        0x0001
#define DLGBUTTON_YES       0x0002
#define DLGBUTTON_NO        0x0004
#define DLGBUTTON_CANCEL    0x0008
#define DLGBUTTON_ABORT     0x0010
#define MESSAGEDLG_MAX_BUTTON_COUNT 5

typedef struct {
    guint       btnconnects[MESSAGEDLG_MAX_BUTTON_COUNT];
    GtkWidget   *buttons[MESSAGEDLG_MAX_BUTTON_COUNT];
    guint       close_id,destroy_id;
    gboolean    destroyed;
    gboolean    modal;
    gint        button_number;
    GtkWidget   *dialog;
} messagedlgruninfo_t;


int
showdialog(     gchar               *title,
                messagedlgruninfo_t *runinfo,
                GtkButtonBox        *buttonbox,
                GtkWidget           *topwidget);

int
showbasicdialog(gchar           *title, 
                gint            buttons, 
                GtkWidget       *topwidget);

int
showtextdialogcustom(   gchar           *title,
                        gchar           *message,
                        gchar           *buttons[]);
int
showtextdialog( gchar           *title,
                gchar           *message,
                gint            buttons);

int
showokdialog(   gchar           *title, 
                gchar           *message);

#endif /*   MESSAGEDLG_H_INCLUDED */
