#include "licq_chat.h"
#include "gtk-gui.h"

#include <gdk/gdkkeysyms.h> 
#include <X11/Xlib.h>
#include <gdk/gdkx.h>

#include "messagedlg.h"
#include "send_event_window.h"
#include "multiuser_chat.h"
#include "functions.h"


GList *available_fonts = NULL;
GList *chat_sessions = NULL;
GdkColor **chat_colors;

#define FONT_SIZES_LEN 21

/* STOLEN FROM GTK!!! Yes we know this might be stupid!
If this will cause a problem just remove this stolen stuff and the two lines
with draw_cursor  and undraw_cursor in the key press event.
*/

typedef struct _TextProperty          TextProperty;

typedef enum {
    PROPERTY_FONT =       1 << 0,
    PROPERTY_FOREGROUND = 1 << 1,
    PROPERTY_BACKGROUND = 1 << 2
} TextPropertyFlags;

struct _GtkTextFont
{
      /* The actual font. */
      GdkFont *gdk_font;
        guint ref_count;

          gint16 char_widths[256];
};

struct _TextProperty
{
    /* Font. */
    GtkTextFont* font;

    /* Background Color. */
    GdkColor back_color;

    /* Foreground Color. */
    GdkColor fore_color;

    /* Show which properties are set */
    TextPropertyFlags flags;

    /* Length of this property. */
    guint length;
};


#define MARK_CURRENT_PROPERTY(mark) ((TextProperty*)(mark)->property->data)
#define MARK_CURRENT_FONT(text, mark) \
    ((MARK_CURRENT_PROPERTY(mark)->flags & PROPERTY_FONT) ? \
    MARK_CURRENT_PROPERTY(mark)->font->gdk_font : \
    GTK_WIDGET (text)->style->font)

#define MARK_CURRENT_FORE(text, mark) \
    ((MARK_CURRENT_PROPERTY(mark)->flags & PROPERTY_FOREGROUND) ? \
     &MARK_CURRENT_PROPERTY(mark)->fore_color : \
     &((GtkWidget *)text)->style->text[((GtkWidget *)text)->state])
#define MARK_CURRENT_BACK(text, mark) \
      ((MARK_CURRENT_PROPERTY(mark)->flags & PROPERTY_BACKGROUND) ? \
       &MARK_CURRENT_PROPERTY(mark)->back_color : \
       &((GtkWidget *)text)->style->base[((GtkWidget *)text)->state])
   
static void
clear_area                             (GtkText     *text, 
                                        GdkRectangle 
                                                    *area)
{
  GtkWidget *widget = GTK_WIDGET (text);

  if (text->bg_gc)
    {
      gint width, height;

      gdk_window_get_size (widget->style->bg_pixmap[GTK_STATE_NORMAL], &width, &height);

      gdk_gc_set_ts_origin (text->bg_gc,
                (- (gint)text->first_onscreen_hor_pixel) % width,
                (- (gint)text->first_onscreen_ver_pixel) % height);

      gdk_draw_rectangle (text->text_area, text->bg_gc, TRUE,
              area->x, area->y, area->width, area->height);
    }
  else
    gdk_window_clear_area (text->text_area, area->x, area->y, area->width, area->height);
}

static void
draw_bg_rect                           (GtkText*    text, 
                                        GtkPropertyMark
                                                    *mark,
                                        gint        x, 
                                        gint        y, 
                                        gint        width, 
                                        gint        height,
                                        gboolean    already_cleared)
{
  GtkEditable *editable = GTK_EDITABLE(text);

  if ((mark->index >= MIN(editable->selection_start_pos, editable->selection_end_pos) &&
       mark->index < MAX(editable->selection_start_pos, editable->selection_end_pos)))
    {
      gtk_paint_flat_box(GTK_WIDGET(text)->style, text->text_area,
             editable->has_selection ?
                GTK_STATE_SELECTED : GTK_STATE_ACTIVE,
             GTK_SHADOW_NONE,
             NULL, GTK_WIDGET(text), "text",
             x, y, width, height);
    }
  else if (!gdk_color_equal(MARK_CURRENT_BACK (text, mark),
                &GTK_WIDGET(text)->style->base[GTK_WIDGET_STATE (text)]))
    {
      gdk_gc_set_foreground (text->gc, MARK_CURRENT_BACK (text, mark));

      gdk_draw_rectangle (text->text_area,
              text->gc,
              TRUE, x, y, width, height);
    }
  else if (GTK_WIDGET (text)->style->bg_pixmap[GTK_STATE_NORMAL])
    {
      GdkRectangle rect;
      
      rect.x = x;
      rect.y = y;
      rect.width = width;
      rect.height = height;

      clear_area (text, &rect);
    }
  else if (!already_cleared)
    gdk_window_clear_area (text->text_area, x, y, width, height);
}

static void
draw_cursor                            (GtkText*    text, 
                                        gint        absolute)
{
  GtkEditable *editable = (GtkEditable *)text;

  if (absolute)
    text->cursor_drawn_level = 1;

  if ((--text->cursor_drawn_level == 0) &&
      (editable->selection_start_pos == editable->selection_end_pos) &&
      GTK_WIDGET_DRAWABLE (text) && text->line_start_cache)
    {
      GdkFont* font;

      g_assert (text->cursor_mark.property);

      font = MARK_CURRENT_FONT (text, &text->cursor_mark);

      gdk_gc_set_foreground (text->gc, &GTK_WIDGET (text)->style->text[GTK_STATE_NORMAL]);

      gdk_draw_line (text->text_area, text->gc, text->cursor_pos_x,
             text->cursor_pos_y - text->cursor_char_offset,
             text->cursor_pos_x,
             text->cursor_pos_y - text->cursor_char_offset - font->ascent);
    }
}

static void
undraw_cursor                          (GtkText*    text, 
                                        gint        absolute)
{
  GtkEditable *editable = (GtkEditable *)text;

  if (absolute)
    text->cursor_drawn_level = 0;

  if ((text->cursor_drawn_level ++ == 0) &&
      (editable->selection_start_pos == editable->selection_end_pos) &&
      GTK_WIDGET_DRAWABLE (text) && text->line_start_cache)
    {
      GdkFont* font;

      g_assert(text->cursor_mark.property);

      font = MARK_CURRENT_FONT(text, &text->cursor_mark);

      draw_bg_rect (text, &text->cursor_mark,
            text->cursor_pos_x,
            text->cursor_pos_y - text->cursor_char_offset - font->ascent,
            1, font->ascent + 1, FALSE);

      if (text->cursor_char)
    {
      if (font->type == GDK_FONT_FONT)
        gdk_gc_set_font (text->gc, font);

      gdk_gc_set_foreground (text->gc, MARK_CURRENT_FORE (text, &text->cursor_mark));

      gdk_draw_text_wc (text->text_area, font,
             text->gc,
             text->cursor_pos_x,
             text->cursor_pos_y - text->cursor_char_offset,
             &text->cursor_char,
             1);
    }
    }
}

/* END STOLEN STUFF */

static const guint16 font_sizes[] = {
      8, 9, 10, 11, 12, 13, 14, 16, 18, 20, 22, 24, 26, 28,
        32, 36, 40, 48, 56, 64, 72
};


int 
update_event_window()
{
    GtkWidget *chat_session_optionmenu;

    GtkWidget   *contactlist=lookup_widget(main_window,"alias_clist");
    GList       *rows;
    
    if(!contactlist) {
        return -1;
    }
    rows=GTK_CLIST(contactlist)->row_list;
    while(rows) {
        if(rows->data&&((GtkCListRow*)(rows->data))->data&&
                ((userdata_t*)(((GtkCListRow*)(rows->data))->data))->send_event_window) {
            chat_session_optionmenu = lookup_widget(
                    ((userdata_t*)(((GtkCListRow*)(rows->data))->data))->send_event_window,
                    "chat_session_optionmenu");
            if(chat_session_optionmenu) {
                configure_chat_session_optionmenu(GTK_OPTION_MENU(chat_session_optionmenu));
            }
        }
        rows=g_list_next(rows);
    }
    return(0);
}

chat_content *
find_chatsession                       (GtkWidget   *dialog) 
{
    int i,len;
    GList *tmp_list = NULL;
    chat_content *c;
    
    len = g_list_length(chat_sessions);
    
    tmp_list = g_list_first(chat_sessions);
    for(i=0; (i < len) && (dialog != ((chat_content *) tmp_list->data)->chat_dialog); i++) {
        tmp_list = g_list_next(tmp_list);
    }
    
    if (tmp_list == NULL) {
        chat_msg(dialog,_("Cant find the current chatsession"));
        return NULL;
    }

    return((chat_content *) tmp_list->data);
}

int 
cmpint                                 (gconstpointer a, 
                                        gconstpointer b) 
{
    if (GPOINTER_TO_INT(a) == GPOINTER_TO_INT(b)) {
        return(0);
    } else if (GPOINTER_TO_INT(a) < GPOINTER_TO_INT(b)) {
        return(-1);
    }
    return(1);
}


void
real_chat_bg_change                    (GtkWidget   *dialog, 
                                        int         index, 
                                        bool        send_to_others) 
{
    GtkWidget *irc_textbox = lookup_widget(GTK_WIDGET(dialog),
                 "irc_textbox");
    GtkWidget *chat_local_textbox = lookup_widget(GTK_WIDGET(dialog),
            "chat_local_textbox");
    GtkWidget *chat_remote_textbox = lookup_widget(GTK_WIDGET(dialog),
            "chat_remote_textbox");
    GtkStyle  *style;
    chat_content *c;
    c = find_chatsession(dialog);
    if (c!= NULL) {
        c->local_bg_color_index = index;
        if (c->local_bg_color_index != NUM_COLORS) {
            style = gtk_style_copy(
                    gtk_widget_get_style(GTK_WIDGET(chat_local_textbox))); 
            style->base[GTK_STATE_NORMAL] = *chat_colors[c->local_bg_color_index];
            if (c->use_own_color) {
                gtk_widget_set_style(GTK_WIDGET(chat_remote_textbox),style);
            }
            gtk_widget_set_style(GTK_WIDGET(irc_textbox),style);
            gtk_widget_set_style(GTK_WIDGET(chat_local_textbox),style);
            if (send_to_others) {
                c->chatman->ChangeColorBg(col_array[c->local_bg_color_index*3],
                        col_array[c->local_bg_color_index*3+1],
                        col_array[c->local_bg_color_index*3+2]);
            }
        } else {
            c->local_bg_color = NULL;
            if (c->backup_bg_color != NULL) {
                if (send_to_others) {
                    c->chatman->ChangeColorBg(c->backup_bg_color->red/0x101,
                            c->backup_bg_color->green/0x101,
                            c->backup_bg_color->blue/0x101);
                }
            }
            style = gtk_style_copy(
                    gtk_widget_get_style(GTK_WIDGET(chat_local_textbox))); 
            style->base[GTK_STATE_NORMAL] = *c->backup_bg_color;
            if (c->use_own_color) {
                gtk_widget_set_style(GTK_WIDGET(chat_remote_textbox),style);
            }
            gtk_widget_set_style(GTK_WIDGET(chat_local_textbox),style);
        }
    }
}

void
chat_bg_change                         (GtkMenuItem *menuitem,
                                        gpointer    user_data)
{
    GtkWidget *dialog = lookup_widget(GTK_WIDGET(menuitem), "multichat_window");
    int index = GPOINTER_TO_INT(user_data);

    real_chat_bg_change(dialog, index, true);
}

void
chat_fg_change                         (GtkMenuItem *menuitem,
                                        gpointer    user_data)
{
    GtkWidget *dialog = lookup_widget(GTK_WIDGET(menuitem), "multichat_window");
    chat_content *c;
    c = find_chatsession(dialog);

    if (c!= NULL) {
        c->local_fg_color_index = GPOINTER_TO_INT(user_data);
        if (c->local_fg_color_index != NUM_COLORS) {
            c->local_fg_color = chat_colors[c->local_fg_color_index];
            c->chatman->ChangeColorFg(col_array[c->local_fg_color_index*3],
                    col_array[c->local_fg_color_index*3+1],
                    col_array[c->local_fg_color_index*3+2]);
        } else {
            if (c->backup_fg_color != NULL) {
                c->chatman->ChangeColorFg((c->backup_fg_color->red/0x101),
                        c->backup_fg_color->green/0x101,
                        c->backup_fg_color->blue/0x101);
                c->local_fg_color = c->backup_fg_color;
            } else {
                c->local_fg_color = NULL;
            }
        }
    }
}

void
popup_color_menu                       (GtkButton   *button,  
                                        GdkEventButton          
                                                    *event, 
                                        gpointer    menu) 
{
    if (event->button == 1) {
        gtk_menu_popup(GTK_MENU(menu),NULL, NULL, NULL, NULL,1,event->time);
    }
}

void
create_fg_color_menu                   (GtkWidget   *widget)
{
    GtkWidget *chat_fg_button = lookup_widget(widget,"chat_fg_button");
    GtkWidget *menu = gtk_menu_new();
    GtkWidget *item;
    GtkWidget *da;
    GdkGC     *newgc;
    GList *children;
    int i,j,len;
    
    for(i = 0; i <= NUM_COLORS;i++) {
        da = gtk_drawing_area_new();
        gtk_widget_ref(da);
        gtk_drawing_area_size (GTK_DRAWING_AREA(da),30,15);
        gtk_widget_show(da);

        item = gtk_menu_item_new();
        children = gtk_container_children(GTK_CONTAINER(item)); 
        len = g_list_length(children);
        for(j=0;j < len; j++) {
            gtk_container_remove(GTK_CONTAINER(item),GTK_WIDGET(children->data));
            children = g_list_next(children);
        }
        gtk_container_add(GTK_CONTAINER(item),da);
        if (i != NUM_COLORS) {
            gtk_object_set_user_data(GTK_OBJECT(da),chat_colors[i]);
        }
        gtk_signal_connect (GTK_OBJECT (da),"expose_event",GTK_SIGNAL_FUNC(on_options_color_drawingarea_expose_event),NULL);
        gtk_menu_append(GTK_MENU(menu),item);
        gtk_signal_connect(GTK_OBJECT(item),"activate",GTK_SIGNAL_FUNC(chat_fg_change),GINT_TO_POINTER(i));
    }

    gtk_widget_show_all(menu);
    gtk_object_set_data (GTK_OBJECT (menu), "multichat_window", widget);
    gtk_signal_connect (GTK_OBJECT (chat_fg_button), "button_press_event", GTK_SIGNAL_FUNC (popup_color_menu),menu);
}

void
create_bg_color_menu                   (GtkWidget   *widget)
{
    GtkWidget *chat_bg_button = lookup_widget(widget,"chat_bg_button");
    GtkWidget *menu = gtk_menu_new();
    GtkWidget *item;
    GtkWidget *da;
    GdkGC     *newgc;
    GList *children;
    int i,j,len;
    
    for(i = 0; i <= NUM_COLORS;i++) {
        da = gtk_drawing_area_new();
        gtk_widget_ref(da);
        gtk_drawing_area_size (GTK_DRAWING_AREA(da),30,15);
        gtk_widget_show(da);

        item = gtk_menu_item_new();
        children = gtk_container_children(GTK_CONTAINER(item)); 
        len = g_list_length(children);
        for(j=0;j < len; j++) {
            gtk_container_remove(GTK_CONTAINER(item),GTK_WIDGET(children->data));
            children = g_list_next(children);
        }
        gtk_container_add(GTK_CONTAINER(item),da);
        if (i != NUM_COLORS) {
            gtk_object_set_user_data(GTK_OBJECT(da),chat_colors[i]);
        }
        gtk_signal_connect (GTK_OBJECT (da),"expose_event",GTK_SIGNAL_FUNC(on_options_color_drawingarea_expose_event),NULL);
        gtk_menu_append(GTK_MENU(menu),item);
        gtk_signal_connect(GTK_OBJECT(item),"activate",GTK_SIGNAL_FUNC(chat_bg_change),GINT_TO_POINTER(i));
    }

    gtk_widget_show_all(menu);
    gtk_object_set_data (GTK_OBJECT (menu), "multichat_window", widget);
    gtk_signal_connect (GTK_OBJECT (chat_bg_button), "button_press_event", GTK_SIGNAL_FUNC (popup_color_menu),menu);

}

int 
change_local_font                      (GtkWidget   *dialog, 
                                        const char  *family, 
                                        const char  *weight, 
                                        const char  slant, 
                                        int     size) 
{
    char *tmp;
    GdkFont *tmpfont;
    chat_content *c;
       
    c = find_chatsession(dialog);
    if (c == NULL) {
        return(-1);
    }
    
    tmp = g_strdup_printf("-*-%s-%s-%c-*-*-%d-*-*-*-*-*-*-*",
            family,
            weight,
            slant,
            size);

    tmpfont = c->local_font;
    if((c->local_font=gdk_font_load(tmp))){
        if (tmpfont != NULL) {
            gdk_font_unref(tmpfont);
        }
        gdk_font_ref(c->local_font);
        chat_msg(dialog,"");
    } else {
        chat_msg(dialog,_("Error loading the requested font."));
    }
    free(tmp);
    return(0);
}

void 
insert_pixelsize_to_menu               (GtkOptionMenu 
                                                    *opt_menu, 
                                        char        *fontname)
{
    GtkWidget *dialog = lookup_widget(GTK_WIDGET(opt_menu),"multichat_window");
    GtkWidget *menu = gtk_menu_new();
    GtkWidget *menuitem;
    gchar **xfontnames;
    gint num_fonts;
    gchar field_buffer[XLFD_MAX_FIELD_LEN];
    gchar pix_size[XLFD_MAX_FIELD_LEN];
    gchar pnt_size[XLFD_MAX_FIELD_LEN];
    int size;
    int a=-1,b=-2;
    int len;

    GList *size_list = NULL;
    GList *tmp_list = NULL; 
    int i,j,index = 0, cnt = 0;
    chat_content *c;
    char *p_size;
    int pixels, points;
    
    c = find_chatsession(dialog);

                    
    xfontnames = XListFonts (GDK_DISPLAY(), "-*", MAX_FONTS, &num_fonts);
    
    if (num_fonts == MAX_FONTS) {
        gbug("MAX_FONTS exceeded. Some fonts may be missing.\n");
    }

    gtk_option_menu_remove_menu(opt_menu);
    gtk_option_menu_set_menu(opt_menu,menu);
    for(i=0; i < num_fonts; i++) {
        ripped_gtk_font_selection_get_xlfd_field(xfontnames[i],XLFD_FAMILY,field_buffer);
        if(!strcmp(fontname,field_buffer)){
            ripped_gtk_font_selection_get_xlfd_field(xfontnames[i],XLFD_PIXELS,pix_size);
            ripped_gtk_font_selection_get_xlfd_field(xfontnames[i],XLFD_PIXELS,pnt_size);
            pixels = atoi(pix_size);
            points = atoi(pnt_size);
            gbug("fond fonts: %s\n",xfontnames[i]);
            if (pixels == 0 && points == 0) {
                for(j = 0; j < FONT_SIZES_LEN; j++) {
                    size_list = g_list_append(size_list,GINT_TO_POINTER(font_sizes[j]));
                }
                break;
            } else if (pixels > 2){
                size_list = g_list_append(size_list,GINT_TO_POINTER(pixels));
            }
        }
    }
    size_list = g_list_sort(size_list,cmpint);

    len = g_list_length(size_list);
    if (len > 0) {
        tmp_list = g_list_first(size_list);
        for(i = 0; i < len; i++) {
            a = GPOINTER_TO_INT(tmp_list->data);
            if (a != b) {
                p_size = g_strdup_printf("%d",a);
                menuitem = gtk_menu_item_new_with_label(p_size);
                free(p_size);
                gtk_signal_connect (GTK_OBJECT (menuitem), "activate", GTK_SIGNAL_FUNC (on_chat_font_size_selected),GINT_TO_POINTER(a));
                gtk_menu_append(GTK_MENU(menu),menuitem);
                if((c != NULL) && (c->chat_font_size == a))
                {
                    index = cnt;
                }
                cnt++;
                b = a;
            }
            tmp_list = g_list_next(tmp_list);
        }

        gtk_option_menu_set_history(GTK_OPTION_MENU(opt_menu),index);
        gtk_widget_show_all(menu);
        gtk_widget_set_sensitive(GTK_WIDGET(opt_menu),true);
    } else {
        gtk_widget_set_sensitive(GTK_WIDGET(opt_menu),false);
    }
}

gint 
g_list_strcmp                          (gconstpointer a,
                                        gconstpointer b)
{
    return(strcmp((char *) a, (char *) b));
}

int 
getfonts() 
{
    gchar **xfontnames;
    gint num_fonts;
    gchar field_buffer[XLFD_MAX_FIELD_LEN];
    int i,j, len,IN_LIST = 0;
    GList *tmp_list;
    
    xfontnames = XListFonts (GDK_DISPLAY(), "-*", MAX_FONTS, &num_fonts);
    if (num_fonts == MAX_FONTS) {
        gbug("MAX_FONTS exceeded. Some fonts may be missing.\n");
    }

    for(i=0;i < num_fonts; i++) {
        ripped_gtk_font_selection_get_xlfd_field(xfontnames[i],XLFD_FAMILY,field_buffer);
        len = g_list_length(available_fonts);
        tmp_list = g_list_first(available_fonts);
        IN_LIST = 0;
        for(j=0; j < len; j++) { 
            if (!strcmp(((char *) tmp_list->data),field_buffer)){
                IN_LIST = 1;
                break;
            }
            tmp_list = g_list_next(tmp_list);
        }
        if (!IN_LIST && strcmp("(nil)",field_buffer)) {
            available_fonts = g_list_append(available_fonts,strdup(field_buffer));
        }
    }
    available_fonts = g_list_sort(available_fonts,g_list_strcmp);

    len = g_list_length(available_fonts);
    tmp_list = g_list_first(available_fonts);
    for(j=0; j < len; j++) {
         tmp_list = g_list_next(tmp_list);
    }
    return(0); 
}

int 
add_user_to_list                       (unsigned long   
                                                    uin,
                                        GtkWidget   *chat_dialog) 
{
    GtkWidget *list = lookup_widget(chat_dialog,"irc_aliaslist");
    char *tmp[1];

    ICQUser *user = gUserManager.FetchUser(uin,LOCK_R);
    if(!user) {
        return 0;
    }
    
    tmp[0] = strdup(user->GetAlias());
            
    gUserManager.DropUser(user);
    gtk_clist_append(GTK_CLIST(list),tmp);
    free(tmp[0]);
    
    return(0);
}

int 
remove_user_from_list                  (unsigned long 
                                                    uin,
                                        GtkWidget   *chat_dialog) 
{
    GtkWidget *list = lookup_widget(chat_dialog,"irc_aliaslist");
    int i,len;
    char *tmp;
    char *alias;
    ICQUser *user = gUserManager.FetchUser(uin,LOCK_R);

    if(!user) {
        return 0;
    }
    alias = strdup(user->GetAlias());
    gUserManager.DropUser(user);

    len = gtk_clist_get_length(GTK_CLIST(list));
    for(i=0; i < len; i++) {
        gtk_clist_get_text(GTK_CLIST(list),i,0,&tmp);
        if (!strcmp(alias,tmp)) {
            gtk_clist_remove(GTK_CLIST(list),i);
            break;
        }
    }
    
    free(alias);
    return(0);
}


int 
chat_msg                               (GtkWidget   *chat_dialog, 
                                        char        *msg) 
{
    GtkWidget *statusbar = lookup_widget(GTK_WIDGET(chat_dialog),
            "chat_statusbar");

    gtk_statusbar_pop(GTK_STATUSBAR(statusbar),1);
    gtk_statusbar_push(GTK_STATUSBAR(statusbar),1,msg);
    return(0);
}

void 
chatSendBeep()
{
}

void 
changeForeColor()
{
}

void 
changeBackColor()
{
}

void 
setBackground                          (GtkWidget   *widget, 
                                        const int   r, 
                                        const int   g, 
                                        const int   b)
{       
    GtkWidget *chat_remote_textbox = lookup_widget(GTK_WIDGET(widget),
                 "chat_remote_textbox");
    GdkColormap *cmap;
    chat_content *c;
    GtkStyle  *style; 
    GdkColor tmp_color;
    
    c = find_chatsession(widget); 
    if (c == NULL) {
        return;
    }
    cmap = gtk_widget_get_colormap(main_window);
    if (cmap != NULL) {
        if (c->remote_bg_color != NULL) {
            tmp_color.red = r;
            tmp_color.green = g;
            tmp_color.blue = b;
            gdk_colormap_alloc_color(cmap,&tmp_color,TRUE,TRUE);
            memcpy(c->remote_bg_color, &tmp_color,sizeof(GdkColor));
            if (!c->use_own_color) {
                style = gtk_style_copy(
                        gtk_widget_get_style(GTK_WIDGET(chat_remote_textbox)));
                style->base[GTK_STATE_NORMAL] = tmp_color;
                gtk_widget_set_style(GTK_WIDGET(chat_remote_textbox),style);
            }
        }
    }
}

void 
setForeground                          (GtkWidget   *widget, 
                                        const int   r, 
                                        const int   g, 
                                        const int   b)
{
    GdkColormap *cmap;
    chat_content *c;
    GdkColor tmp_color;

    c = find_chatsession(widget); 
    if (c == NULL) {
        return;
    }
    cmap = gtk_widget_get_colormap(main_window);
    if (cmap != NULL) {
        if (c->remote_fg_color != NULL) {
            tmp_color.red = r;
            tmp_color.green = g;
            tmp_color.blue = b;
            gdk_colormap_alloc_color(cmap,&tmp_color,TRUE,TRUE);
            memcpy(c->remote_fg_color, &tmp_color,sizeof(GdkColor));
         /*  
            c->remote_fg_color->red = r;
            c->remote_fg_color->green = g;
            c->remote_fg_color->blue = b;
            gdk_colormap_alloc_color(cmap,c->remote_fg_color,TRUE,TRUE);
            */
        }
    }
} 

int 
chat_StartAsServer                     (GtkWidget   *dialog)
{
    chat_content *c;
    
    if(!GTK_WIDGET_VISIBLE(dialog)){
        gtk_widget_show(dialog);
    }
    c = find_chatsession(dialog);
    
    
    if (c == NULL) {
        showokdialog(_("Error"),_("Cant find the current chatsession\nChat canceled"));
        return -1;
    }


    c->chatman = new CChatManager(licq_daemon,gUserManager.OwnerUin(), c->chat_font, c->chat_font_size, false, false,false);
     if (!c->chatman->StartAsServer()){ 
         showokdialog(_("Error"),_("Error starting chat server.\nChat canceled"));
         return -1;
     }
    
     
    if((c->chat_handler = gtk_input_add_full(c->chatman->Pipe(),GDK_INPUT_READ,slot_chat,NULL,dialog,NULL)) == 0) {
        showokdialog(_("Error"),_("Signal chat_handler error\nChat canceled"));
        return -1;                  
    }

    chat_msg(dialog,_("Waiting for joiners..."));
    /* set remote text Remote - Waiting for joiners...
     * gLog.Info("%sChat: Waiting for joiners.\n", L_TCPxSTR);
     */
    
    update_event_window();

    return(c->chatman->LocalPort());
}

int 
chat_StartAsClient                     (unsigned short 
                                                    port, 
                                        unsigned long 
                                                    uin, 
                                        char        *name, 
                                        GtkWidget   *dialog)
{
    chat_content *c;
    
    if(!GTK_WIDGET_VISIBLE(dialog)){
        gtk_widget_show(dialog);
    }
    c = find_chatsession(dialog);
    
    if (c == NULL) {
        showokdialog(_("Error"),_("Cant find the current chatsession\nChat canceled"));
        return -1;
    }

    
    c->chatman = new CChatManager(licq_daemon,uin, c->chat_font, c->chat_font_size, false, false,false);
    if (!c->chatman->StartAsClient(port)) { 
        showokdialog(_("Error"),_("Error starting chat client.\nChat canceled"));
        return (-1);
    }
    

    if((c->chat_handler = gtk_input_add_full(c->chatman->Pipe(),GDK_INPUT_READ,slot_chat,NULL,dialog,NULL)) == 0) {
        showokdialog(_("Error"),_("Signal chat_handler error\nChat canceled"));
        return (-1);                  
    }
    
    update_event_window();
    
    return (c->chatman->LocalPort());
}

void 
slot_chat                              (void        *v, 
                                        int         iii, 
                                        GdkInputCondition 
                                                    g)
{
    GtkWidget *dialog = (GtkWidget *) v;
    GtkWidget *pane_mode1 = lookup_widget(dialog,"pane_mode1");
    GtkWidget *irc_mode1 = lookup_widget(dialog,"irc_mode1");
    GtkWidget *irc_textbox = lookup_widget(dialog,"irc_textbox");
    GtkWidget *chat_remote_textbox = lookup_widget(dialog,"chat_remote_textbox");
    GtkWidget *irc_entry = lookup_widget(dialog,"irc_entry");
    GtkWidget *chat_local_textbox = lookup_widget(dialog,"chat_local_textbox");
    int i,len;
    GList *tmp_list = NULL;
    chat_content *c;
    
    char buf[32];
    char *tmp;

    GdkFont  *font = NULL;
   
    CChatEvent *e = NULL;
    
    c = find_chatsession(dialog);
    if (c == NULL) {
        return;
    }
    
    read(c->chatman->Pipe(), buf, 32);

    while ((e = c->chatman->PopChatEvent()) != NULL)
    {
        CChatUser *u = e->Client();
        
        switch(e->Command())
        {
            case CHAT_DISCONNECTION:
                {
                    if (c->chatman->ConnectedUsers() == 0) {
                        gtk_widget_set_sensitive(GTK_WIDGET(chat_local_textbox),false);
                        gtk_widget_set_sensitive(GTK_WIDGET(irc_entry),false);
                    }
                    
                    remove_user_from_list(u->Uin(),dialog);
                    tmp = g_strdup_printf(_("%s closed connection."),u->Name());
                    chat_msg(dialog ,tmp);
                    free(tmp);
                    break;
                }

            case CHAT_CONNECTION:
                {
                    tmp = g_strdup_printf(_("%s joined chat."),u->Name());
                    chat_msg(dialog ,tmp);
                    free(tmp);

                    if (c->chatman->ConnectedUsers() == 1) {
                        gtk_widget_set_sensitive(GTK_WIDGET(chat_local_textbox),true);
                        gtk_widget_set_sensitive(GTK_WIDGET(irc_entry),true);
                    }

                    add_user_to_list(u->Uin(),dialog);
                    if (c->chatUser == NULL){
                        GtkWidget *frame = lookup_widget(dialog,"chat_remote_frame");
                        tmp = g_strdup_printf(_("Remote - %s"),u->Name());
                        gtk_frame_set_label(GTK_FRAME(frame),tmp);
                        free(tmp);
                        c->chatUser = u;
                    /* Set remote colors */
    /*                    setForeground(dialog,RGB_CONV( u->ColorFg()[0],
                                    u->ColorFg()[1], u->ColorFg()[2]));
                        setBackground(dialog, RGB_CONV(u->ColorBg()[0],
                                    u->ColorBg()[1], u->ColorBg()[2]));
                                    */
                    } else if (GTK_CHECK_MENU_ITEM(pane_mode1)->active) {

                        gtk_check_menu_item_set_active(GTK_CHECK_MENU_ITEM(irc_mode1),true); 
                        gtk_widget_set_sensitive(pane_mode1,false);
                    }
                    break;
                }

            case CHAT_NEWLINE:
                {
                    tmp = g_strdup_printf("<%s> %s\n",u->Name(),e->Data());
                    gtk_text_insert(GTK_TEXT(irc_textbox),
                            c->local_font,c->local_fg_color,
                            NULL,tmp,strlen(tmp));
                    free(tmp);
                    if (u == c->chatUser) {
                        gtk_text_insert(GTK_TEXT(chat_remote_textbox),
                                c->use_own_font?c->local_font:c->remote_font,
                                c->use_own_color?c->local_fg_color:c->remote_fg_color, 
                                NULL,
                                "\n" ,1);
                    }
                    break;
                }

            case CHAT_BEEP:  // beep
                {
                   if (c->audio_on) {
                       gdk_beep();
                   } else {
                        tmp = g_strdup_printf(_("<%s> <--BEEP-->\n"),u->Name());
                        gtk_text_insert(GTK_TEXT(irc_textbox),c->local_font,
                                c->local_fg_color,
                                NULL,
                                tmp,strlen(tmp));
                        free(tmp);
                        if (u == c->chatUser) {
                            gtk_text_insert(GTK_TEXT(chat_remote_textbox),
                                    c->use_own_font?c->local_font:c->remote_font,
                                    c->use_own_color?c->local_fg_color:c->remote_fg_color, 
                                    NULL,
                                    _(" <--BEEP--> "),12);
                        }

                    }
                    break;
                }

            case CHAT_BACKSPACE:   // backspace
                {
                    if (u == c->chatUser) {
                        gtk_text_backward_delete (GTK_TEXT(chat_remote_textbox),1);
                    }
                    break;
                }

            case CHAT_COLORxFG: // change foreground color
                {
                    setForeground(dialog,RGB_CONV( u->ColorFg()[0],
                            u->ColorFg()[1], u->ColorFg()[2]));
                    break;
                }

            case CHAT_COLORxBG:  // change background color
                {
                    setBackground(dialog, RGB_CONV(u->ColorBg()[0],
                            u->ColorBg()[1], u->ColorBg()[2]));
                    break;
                }
            
            case CHAT_FONTxSIZE:
            case CHAT_FONTxFAMILY: // change font type
            case CHAT_FONTxFACE:
                {
                   
                    tmp = g_strdup_printf("-*-%s-%s-%c-*-*-%d-*-*-*-*-*-*-*",u->FontFamily(),(u->FontBold())?"bold":"medium",(u->FontItalic())?'i':'r',u->FontSize());
                    font = c->remote_font;
                    if((c->remote_font=gdk_font_load(tmp))){
                        if (font != NULL) {
                            gdk_font_unref(font);
                        }
                        gdk_font_ref(c->remote_font);
                    }
                    free(tmp);
                    break;
                }

            case CHAT_CHARACTER:
                {

                    if (u == c->chatUser){
                        gtk_text_insert(GTK_TEXT(chat_remote_textbox),
                                c->use_own_font?c->local_font:c->remote_font,
                                c->use_own_color?c->local_fg_color:c->remote_fg_color, 
                                NULL,
                                e->Data(),strlen(e->Data()));
                    }
                    break;
                }

            default:
                {   
                    // Internal Error: invalid command from chat manager
                    gbug("Internal Error: invalid command from chat manager (%d).\n",e->Command());
                    break;
                }
        }
        delete e;
    }
}

gboolean
on_chat_local_textbox_focus_in_event   (GtkWidget       *widget,
                                        GdkEventFocus   *event,
                                        gpointer         user_data)
{
    draw_cursor (GTK_TEXT(widget), TRUE);
    return FALSE;
}



gboolean
on_chat_local_textbox_key_press_event  (GtkWidget       *widget,
                                        GdkEventKey     *event,
                                        gpointer         user_data)
{
    GtkWidget *dialog = (GtkWidget *) user_data;
    GtkWidget *irc_textbox = lookup_widget(GTK_WIDGET(dialog),"irc_textbox");
    GtkWidget *chat_local_textbox = lookup_widget(GTK_WIDGET(dialog),
            "chat_local_textbox");
    ICQOwner *owner = NULL;
    char *tmp;
    chat_content *c;

    c = find_chatsession(dialog);

    if (c == NULL) {
        return FALSE;
    }

    
    undraw_cursor (GTK_TEXT(chat_local_textbox), FALSE);
    switch (event->keyval) {
        case GDK_Return:
        case GDK_KP_Enter:
            {
                c->chatman->SendNewline();
                if (GTK_IS_ENTRY(widget)) {
                    owner = gUserManager.FetchOwner(LOCK_R);
                    tmp = g_strdup_printf("<%s> %s\n",owner->GetAlias(),gtk_entry_get_text(GTK_ENTRY(widget)));
                    gtk_text_insert(GTK_TEXT(irc_textbox),
                            c->local_font
                            ,c->local_fg_color,
                            NULL,
                            tmp,strlen(tmp));
                    free(tmp);
                    gUserManager.DropOwner();

                    gtk_editable_delete_text(GTK_EDITABLE(widget),0,-1);
                } else {
                    if (c->buf_cnt < LINEBUF_LEN-1){
                        c->linebuf[c->buf_cnt] = '\0';
                    }
                    
                    owner = gUserManager.FetchOwner(LOCK_R);
                    tmp = g_strdup_printf("<%s> %s\n",owner->GetAlias(),c->linebuf);
                    gUserManager.DropOwner();
                    gtk_text_insert(GTK_TEXT(irc_textbox),
                            c->local_font
                            ,c->local_fg_color,
                            NULL,
                            tmp,strlen(tmp));
                    free(tmp);
                    c->buf_cnt = 0;
                }
                gtk_text_insert(GTK_TEXT(chat_local_textbox),
                        c->local_font
                        ,c->local_fg_color,
                        NULL,
                        "\n",1);
                break;
            }

        case GDK_BackSpace:
            {
                c->chatman->SendBackspace();
                if (c->buf_cnt > 0) {
                    c->buf_cnt--;
                }
                gtk_text_backward_delete (GTK_TEXT(chat_local_textbox), 1);
                break;
            }

        case GDK_Delete:
            break;

        case GDK_Tab:
        case GDK_3270_BackTab:
            break;

        default:
            {
                if ((event->keyval >= 32) && (event->length)){
                    
                    c->chatman->SendCharacter(event->keyval);
                    if (c->buf_cnt < LINEBUF_LEN) {
                        c->linebuf[c->buf_cnt] = event->keyval;
                        c->buf_cnt++;
                    } 
                    tmp = g_strdup_printf("%c",event->keyval);
                    gtk_text_insert(GTK_TEXT(chat_local_textbox),
                            c->local_font
                            ,c->local_fg_color,
                            NULL,
                            tmp,strlen(tmp));
/*                    if (GTK_IS_ENTRY(widget)) {
                        gtk_entry_append_text(GTK_ENTRY(widget),tmp);
                    } */
                    free(tmp);
                }
                break;
            }
    }
    draw_cursor (GTK_TEXT(chat_local_textbox), FALSE);
  return FALSE;
}

void
on_chat_close_button_clicked           (GtkButton       *button,
                                        gpointer         user_data)
{
    GtkWidget *dialog = lookup_widget(GTK_WIDGET(button), "multichat_window");
#if 0
    int len,i,j;
    GList *tmp_list;
    chat_content *c;

    c = find_chatsession(dialog);
    
    if (c != NULL) {
        c->chatUser = NULL;
        c->chatman->CloseChat();
        gtk_input_remove(c->chat_handler);
        if (c->remote_fg_color != NULL) {
            free(c->remote_fg_color);
        }
        if (c->remote_bg_color != NULL){
            free(c->remote_bg_color);
        }
    }
   
    unregister_signalcallback(chat_dialog_signalhandler,dialog);
    
    if (g_list_length(chat_sessions) == 1){
        len = g_list_length(available_fonts);
        tmp_list = g_list_first(available_fonts);
        for(j=0; j < len; j++) {
            free (tmp_list->data);
            tmp_list = g_list_next(tmp_list);
        }
        g_list_free(available_fonts);
        available_fonts = NULL;
        for(i=0; i < NUM_COLORS; i++) {
            free(chat_colors[i]);
        }
    }
    
    len = g_list_length(chat_sessions);
    tmp_list = g_list_first(chat_sessions);
    for(j=0; j < len; j++) {
        if (dialog == ((chat_content *) tmp_list->data)->chat_dialog )  {
            free(tmp_list->data);
            chat_sessions = g_list_remove_link(chat_sessions,tmp_list);
            break;
        }
        tmp_list = g_list_next(tmp_list);
    }
#endif
    gtk_widget_destroy(GTK_WIDGET(dialog));
}


void
on_audio1_activate                     (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
    GtkWidget *dialog = lookup_widget(GTK_WIDGET(menuitem),"multichat_window");

    chat_content *c;

    c = find_chatsession(dialog);
    if (c == NULL) {
        return;
    }
    
    c->audio_on = GTK_CHECK_MENU_ITEM(menuitem)->active;
}


void
on_save_file_ok_button_clicked            (GtkButton    *button,
                                           gpointer     user_data)
{
    GtkWidget *irc_textbox;
    GtkWidget *selector = GTK_WIDGET(user_data);
    char *buf = NULL;
    gchar *selected_filename = NULL;
    FILE *fd;
    
   
    if (!GTK_IS_FILE_SELECTION(selector)) {
        return;
    }
    
    irc_textbox = lookup_widget(GTK_WIDGET(selector),"irc_textbox");

    if ((irc_textbox != NULL) && (GTK_IS_TEXT(irc_textbox))) {
        buf = gtk_editable_get_chars(GTK_EDITABLE(irc_textbox),0,-1);
        selected_filename = gtk_file_selection_get_filename (GTK_FILE_SELECTION(selector));
        if ((fd = fopen(selected_filename,"w")) == NULL) {
            gbug("Error opening file %s for writing\n",selected_filename);
            free(buf);
            return;
        }

        if (fputs(buf,fd) == EOF) {
            gbug("Error writing to file %s\n",selected_filename);
        }

        fclose(fd);
    }
    gtk_widget_destroy(selector);
}

void
on_save_chat1_activate                 (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
   
    GtkWidget *irc_textbox = lookup_widget(GTK_WIDGET(menuitem),"irc_textbox");
    GtkWidget *file_selector;
    
    file_selector = gtk_file_selection_new("Please select a file for editing.");
    gtk_object_set_data(GTK_OBJECT(file_selector), "irc_textbox", irc_textbox);   
    gtk_signal_connect (GTK_OBJECT (GTK_FILE_SELECTION(file_selector)->ok_button),
            "clicked", GTK_SIGNAL_FUNC(on_save_file_ok_button_clicked), (gpointer) file_selector);

    /* Ensure that the dialog box is destroyed when the user clicks a button. */

    gtk_signal_connect_object (GTK_OBJECT (GTK_FILE_SELECTION(file_selector)->cancel_button),
            "clicked", GTK_SIGNAL_FUNC (gtk_widget_destroy),
            GTK_OBJECT(file_selector));

    /* Display that dialog */

    gtk_widget_show (file_selector);
}


void
on_close_chat1_activate                (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
    GtkWidget *dialog = lookup_widget(GTK_WIDGET(menuitem),"multichat_window");
    gtk_widget_destroy(dialog);
}


void
on_pane_mode1_activate                 (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
    GtkWidget *chat_local_textbox = lookup_widget(GTK_WIDGET(menuitem),"chat_local_textbox");
    GtkWidget *chat_notebook = lookup_widget(GTK_WIDGET(menuitem),"chat_notebook");
    GtkWidget *dialog = lookup_widget(GTK_WIDGET(menuitem),"multichat_window");
    GtkWidget *irc_vbox = lookup_widget(GTK_WIDGET(menuitem),"irc_vbox");
    
     chat_content *c;

     if (GTK_CHECK_MENU_ITEM(menuitem)->active) {

         c = find_chatsession(dialog);
         if (c != NULL) {
             c->chat_mode = PANE_CHAT;
         }
         gtk_notebook_set_page(GTK_NOTEBOOK(chat_notebook),PANE_CHAT);
         gtk_widget_hide(irc_vbox);
     }
}


void
on_irc_mode1_activate                  (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
     GtkWidget *irc_entry = lookup_widget(GTK_WIDGET(menuitem), "irc_entry");
    GtkWidget *chat_notebook = lookup_widget(GTK_WIDGET(menuitem),"chat_notebook");
    GtkWidget *dialog = lookup_widget(GTK_WIDGET(menuitem),"multichat_window");
    GtkWidget *irc_vbox = lookup_widget(GTK_WIDGET(menuitem),"irc_vbox");
    chat_content *c;
    
    if (GTK_CHECK_MENU_ITEM(menuitem)->active) {
        c = find_chatsession(dialog);
        if (c != NULL) {
            c->chat_mode = IRC_CHAT;
        }
        gtk_widget_show(irc_vbox);
        gtk_notebook_set_page(GTK_NOTEBOOK(chat_notebook),IRC_CHAT);
    }
}


void
on_chat_font_change                    (GtkToggleButton *togglebutton,
                                        gpointer         user_data)
{
    GtkWidget *dialog = lookup_widget(GTK_WIDGET(togglebutton),"multichat_window");
    GtkWidget *bold = lookup_widget(GTK_WIDGET(togglebutton),"chat_bold_button");
    GtkWidget *italic = lookup_widget(GTK_WIDGET(togglebutton),"chat_italic_button");
    GtkWidget *underline = lookup_widget(GTK_WIDGET(togglebutton),"chat_underline_button");

    char *tmp;
    GdkFont *tmpfont;
    chat_content *c;
    bool isbold, isitalic,isunderline;
       
    c = find_chatsession(dialog);
    if (c == NULL) {
        return;
    }
    
    isbold = gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(bold));
    isitalic = gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(italic));
    isunderline = gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(underline));
    
    change_local_font(dialog,c->chat_font,
            isbold?"bold":"medium",
            isitalic?'i':'r',
            c->chat_font_size);
    
    c->chatman->ChangeFontFace(isbold, isitalic, isunderline);
}


void
on_caht_beep_button_clicked            (GtkButton       *button,
                                        gpointer         user_data)
{
    GtkWidget *dialog = lookup_widget(GTK_WIDGET(button),"multichat_window");
    chat_content *c;

    c = find_chatsession(dialog);

    if (c == NULL) {
        return;
    }
    
    c->chatman->SendBeep();
    if (c->audio_on) {
        gdk_beep();
    }
}

void
create_contactlist_menu                (GtkOptionMenu 
                                                    *option_menu) 
{
    unsigned long *tmp_uin;
    GtkWidget *menuitem;
    GtkWidget *contact_menu = gtk_menu_new();

    gtk_option_menu_remove_menu(option_menu);
    gtk_option_menu_set_menu(option_menu,contact_menu);
    menuitem = gtk_menu_item_new_with_label("none");
    gtk_menu_append(GTK_MENU(contact_menu),menuitem);
       
    FOR_EACH_USER_START(LOCK_R);
    if (!pUser->StatusOffline()) {
        if ((tmp_uin = (unsigned long *) malloc(sizeof(unsigned long))) != NULL) {
            *tmp_uin = pUser->Uin();
            menuitem = gtk_menu_item_new_with_label(pUser->GetAlias());
            gtk_object_set_user_data(GTK_OBJECT(menuitem),tmp_uin);

            gtk_signal_connect(GTK_OBJECT(menuitem),"destroy",
                    GTK_SIGNAL_FUNC(destroy_notify_free_userdata),NULL);

            gtk_menu_append(GTK_MENU(contact_menu),menuitem);
        }
    }
    FOR_EACH_USER_END;
    gtk_widget_show_all(contact_menu);
    gtk_option_menu_set_history(option_menu,0);
}

bool
chat_dialog_signalhandler              (CICQSignal  *signal,    
                                        gpointer    data)
{
    GtkWidget *contacts_optionmenu = lookup_widget(GTK_WIDGET(data),
            "contacts_optionmenu");
       
    gbug("chat_dialog_signalhandler: enter\n"); 
    if (signal && signal->Signal()==SIGNAL_UPDATExUSER) {
        create_contactlist_menu(GTK_OPTION_MENU(contacts_optionmenu));
    }
    return FALSE;
}

void
on_multichat_window_show               (GtkWidget       *widget,
                                        gpointer         user_data)
{
    GtkWidget *chat_fontsize_optionmenu = lookup_widget(widget,
                        "chat_fontsize_optionmenu");
    GtkWidget *irc_entry = lookup_widget(GTK_WIDGET(widget),
            "irc_entry");
    GtkWidget *frame = lookup_widget(widget,"chat_local_frame");
    GtkWidget *chat_font_combo = lookup_widget(widget,"chat_font_combo");
    GtkWidget *chat_combo_entry = lookup_widget(widget,"chat_combo_entry");
    GtkWidget *show_style_toolbar1 = lookup_widget(widget,"show_style_toolbar1");
    GtkWidget *show_font_toolbar1 = lookup_widget(widget,"show_font_toolbar1");
    GtkWidget *use_own_font_and_style1 = lookup_widget(widget,"use_own_font_and_style1");
    GtkWidget *use_own_color1 = lookup_widget(widget,"use_own_colors1");
    GtkWidget *pane_mode1 = lookup_widget(widget,"pane_mode1");
    GtkWidget *audio1 = lookup_widget(widget,"audio1");
    GtkWidget *chat_notebook = lookup_widget(widget,"chat_notebook");
    GtkWidget *irc_vbox = lookup_widget(widget,"irc_vbox");
    GtkWidget *chat_local_textbox = lookup_widget(widget,"chat_local_textbox");
    GtkWidget *contacts_optionmenu = lookup_widget(widget,"contacts_optionmenu"); 
    GtkWidget *chat_style_toolbar = lookup_widget(widget,"chat_style_toolbar");
    GtkWidget *toolbars_as_text_and_pics1 = lookup_widget(widget,"toolbars_as_text_and_pics1");
    GtkWidget *toolbars_as_text1 = lookup_widget(widget,"toolbars_as_text1");
    GtkWidget *toolbars_as_pics1 = lookup_widget(widget,"toolbars_as_pics1");
    GdkColormap *cmap;
    GtkWidget *menuitem;
    ICQOwner *owner = NULL;
    char *tmp;
    unsigned long uin;
    unsigned long *tmp_uin;
    chat_content *c;
    int i,len,index = 0;
    GList *tmp_list;
    GtkStyle *tmp_style;
    int signal = gtk_signal_lookup("button_press",GTK_TYPE_TEXT); 
    /* Prevent mulitiple chat windows to the same session */
    c = find_chatsession(widget);

    if (c != NULL) {
        return;
    }
    
    gtk_editable_set_editable (GTK_EDITABLE( chat_local_textbox),FALSE);
    /* Create content fr this session */
    if (( c = (chat_content *) malloc(sizeof(chat_content))) == NULL){
        gbug("malloc error when creating chat content.\n");
        return;     
    }
    c->buf_cnt = 0;
    c->local_font = NULL;
    c->remote_font = NULL;
    c->chatman = NULL;
    c->chatUser = NULL;
    c->chat_handler = -1;
    c->chat_dialog = widget;
    c->audio_on = configuration.audio_on;
    c->show_font_toolbar = configuration.show_font_toolbar;
    c->show_style_toolbar = configuration.show_style_toolbar;
    c->use_own_font = configuration.use_own_font;
    c->use_own_color = configuration.use_own_color;
    c->chat_mode = configuration.chat_mode;
    c->chat_font_size = configuration.chat_font_size;
    c->toolbar_style = configuration.toolbar_style;
    strcpy(c->chat_font,configuration.chat_font);
    
    chat_sessions = g_list_append(chat_sessions,c);
    
    /* Set fonts */
  
    if (available_fonts == NULL){
        getfonts();
    }
    gtk_combo_set_popdown_strings(GTK_COMBO(chat_font_combo),available_fonts);

    tmp_list = g_list_first(available_fonts);
    len = g_list_length(available_fonts);
    for(i=0; i < len; i++) {
        if (!strcmp(configuration.chat_font,((char *) tmp_list->data))) {
            gtk_entry_set_text(GTK_ENTRY(GTK_COMBO(chat_font_combo)->entry),
                    configuration.chat_font);
            break;
        }
        tmp_list = g_list_next(tmp_list);
    }
    
    gtk_combo_set_value_in_list(GTK_COMBO(chat_font_combo),TRUE,FALSE); 
    gtk_signal_connect(GTK_OBJECT(chat_combo_entry),"changed",GTK_SIGNAL_FUNC(on_chat_combo_entry_changed),NULL); 
    
    insert_pixelsize_to_menu(GTK_OPTION_MENU(chat_fontsize_optionmenu), configuration.chat_font);  

    change_local_font(widget,c->chat_font,"medium",'r',c->chat_font_size);

    /* chat_colors */
    cmap = gtk_widget_get_colormap(main_window);
    if ((chat_colors = (GdkColor **) malloc(sizeof(GdkColor *)*NUM_COLORS)) !=NULL ) {
        for(i=0; i < NUM_COLORS;i++ ){
            if ((chat_colors[i] = (GdkColor *) malloc(sizeof(GdkColor))) != NULL) {
                chat_colors[i]->red=COLOR_CONV(col_array[i*3]);         
                chat_colors[i]->green=COLOR_CONV(col_array[i*3+1]);         
                chat_colors[i]->blue=COLOR_CONV(col_array[i*3+2]);         
                gdk_colormap_alloc_color(cmap,chat_colors[i],TRUE,TRUE);
            }
        }
    }

    if (configuration.chat_fg_color >= NUM_COLORS) {
        c->local_fg_color = NULL;
    } else {
        c->local_fg_color = chat_colors[configuration.chat_fg_color];
    }
    
    if (configuration.chat_bg_color >= NUM_COLORS) {
        c->local_bg_color = NULL;
    } else {
        c->local_bg_color = chat_colors[configuration.chat_bg_color];
    }
    
    c->remote_bg_color = (GdkColor *) malloc(sizeof(GdkColor));
    c->remote_fg_color = (GdkColor *) malloc(sizeof(GdkColor));
   
    c->local_fg_color_index = configuration.chat_fg_color;
    c->local_bg_color_index = configuration.chat_bg_color;   

    tmp_style = gtk_widget_get_style(chat_local_textbox);

    c->backup_fg_color = gdk_color_copy(&tmp_style->text[GTK_STATE_NORMAL]);
    c->backup_bg_color = gdk_color_copy(&tmp_style->base[GTK_STATE_NORMAL]);
    
    memcpy(c->remote_bg_color, c->backup_bg_color,sizeof(GdkColor));
    memcpy(c->remote_fg_color, c->backup_fg_color,sizeof(GdkColor));

    real_chat_bg_change(widget,c->local_bg_color_index,false); 
    
    create_fg_color_menu(widget);
    create_bg_color_menu(widget);
    /* set contactlist menu */
    create_contactlist_menu(GTK_OPTION_MENU(contacts_optionmenu));
   
    /* Set the style of the check_menu_items */
    gtk_check_menu_item_set_show_toggle(
            GTK_CHECK_MENU_ITEM(show_style_toolbar1), TRUE);
    gtk_check_menu_item_set_show_toggle(
            GTK_CHECK_MENU_ITEM(show_font_toolbar1), TRUE);
    gtk_check_menu_item_set_show_toggle(
            GTK_CHECK_MENU_ITEM(use_own_font_and_style1), TRUE);
    gtk_check_menu_item_set_show_toggle(
            GTK_CHECK_MENU_ITEM(use_own_color1), TRUE);
    gtk_check_menu_item_set_show_toggle(
            GTK_CHECK_MENU_ITEM(pane_mode1), TRUE);
    gtk_check_menu_item_set_show_toggle(
            GTK_CHECK_MENU_ITEM(audio1), TRUE);
    
    /* Set menu configuration */
    gtk_check_menu_item_set_active(GTK_CHECK_MENU_ITEM(show_style_toolbar1),
            c->show_style_toolbar);
    gtk_check_menu_item_set_active(GTK_CHECK_MENU_ITEM(show_font_toolbar1),
            c->show_font_toolbar);
    gtk_check_menu_item_set_active(GTK_CHECK_MENU_ITEM(use_own_font_and_style1),
            c->use_own_font);
    gtk_check_menu_item_set_active(GTK_CHECK_MENU_ITEM(use_own_color1),
            c->use_own_color);
    gtk_check_menu_item_set_active(GTK_CHECK_MENU_ITEM(pane_mode1),
            (c->chat_mode==PANE_CHAT));
    gtk_check_menu_item_set_active(GTK_CHECK_MENU_ITEM(audio1),
                        c->audio_on);
    
    if(c->toolbar_style == PICS_ONLY){
        gtk_check_menu_item_set_active(GTK_CHECK_MENU_ITEM(toolbars_as_pics1),
                true);
        gtk_toolbar_set_style(GTK_TOOLBAR(chat_style_toolbar),GTK_TOOLBAR_ICONS);
    } else if (c->toolbar_style == TEXT_ONLY){
        gtk_check_menu_item_set_active(GTK_CHECK_MENU_ITEM(toolbars_as_text1),
                true);
        gtk_toolbar_set_style(GTK_TOOLBAR(chat_style_toolbar),GTK_TOOLBAR_TEXT);

    } else {
        gtk_check_menu_item_set_active(
                GTK_CHECK_MENU_ITEM(toolbars_as_text_and_pics1),
                true);
        gtk_toolbar_set_style(GTK_TOOLBAR(chat_style_toolbar),GTK_TOOLBAR_BOTH);
    }
    
    /* Set frame text */
    owner = gUserManager.FetchOwner(LOCK_R);

    tmp = g_strdup_printf(_("Local - %s"),owner->GetAlias());
    gtk_frame_set_label(GTK_FRAME(frame),tmp);
    free(tmp);
    uin = owner->Uin();
    gUserManager.DropOwner();
    add_user_to_list(uin,widget);
    register_signalcallback(chat_dialog_signalhandler,widget);
    
    
}


void
on_show_style_toolbar1_activate        (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
    GtkWidget *dialog = lookup_widget(GTK_WIDGET(menuitem),"multichat_window");
    GtkWidget *style_handlebox = lookup_widget(GTK_WIDGET(menuitem),"chat_style_handlebox");
    chat_content *c;
    
    c = find_chatsession(dialog);


    if (c != NULL) {
        c->show_style_toolbar = GTK_CHECK_MENU_ITEM(menuitem)->active;
    }

    if(GTK_CHECK_MENU_ITEM(menuitem)->active) {
        gtk_widget_show(style_handlebox);
    } else {
        gtk_widget_hide(style_handlebox);
    }
}


void
on_show_font_toolbar1_activate         (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
    GtkWidget *dialog = lookup_widget(GTK_WIDGET(menuitem),"multichat_window");
    GtkWidget *font_handlebox = lookup_widget(GTK_WIDGET(menuitem),"chat_font_handlebox");
    chat_content *c;

    c = find_chatsession(dialog);


    if (c != NULL) {
        c->show_font_toolbar = GTK_CHECK_MENU_ITEM(menuitem)->active;
    }
    
    if(GTK_CHECK_MENU_ITEM(menuitem)->active) {
        gtk_widget_show(font_handlebox);
    } else {
        gtk_widget_hide(font_handlebox);
    }

}

void
on_redraw_remote_text1_activate        (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{

    GtkWidget *dialog = lookup_widget(GTK_WIDGET(menuitem),"multichat_window");
    GtkWidget *chat_remote_textbox = lookup_widget(GTK_WIDGET(menuitem),"chat_remote_textbox");
    chat_content *c;
    char *tmp_text;
    
    c = find_chatsession(dialog);

    if (c != NULL) {

        /* Convert all text to your local font, simply by remove and insert */
        gtk_text_freeze(GTK_TEXT(chat_remote_textbox));
        tmp_text = gtk_editable_get_chars(GTK_EDITABLE(chat_remote_textbox),0,-1);
        gtk_editable_delete_text(GTK_EDITABLE(chat_remote_textbox),0,-1);
        gtk_text_insert(GTK_TEXT(chat_remote_textbox),
                c->use_own_font?c->local_font:c->remote_font,
                c->use_own_color?c->local_fg_color:c->remote_fg_color,
                NULL,
                tmp_text,strlen(tmp_text));
        gtk_text_thaw(GTK_TEXT(chat_remote_textbox));
        g_free(tmp_text);
    }
}

void
on_use_own_font_and_style1_activate    (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
    GtkWidget *dialog = lookup_widget(GTK_WIDGET(menuitem),"multichat_window");
    chat_content *c;
    
    c = find_chatsession(dialog);

    if (c != NULL) {
        c->use_own_font = GTK_CHECK_MENU_ITEM(menuitem)->active;
    }

}


void
on_chat_invite_button_clicked          (GtkButton       *button,
                                        gpointer         user_data)
{
    GList           *menuitem_list = NULL; 
    GtkWidget       *chatsession_optionmenu;
    GtkWidget       *contacts_optionmenu = lookup_widget(GTK_WIDGET(button),
            "contacts_optionmenu"); 
    GtkWidget       *dialog = lookup_widget(GTK_WIDGET(button),
            "multichat_window"); 
    GtkWidget       *menu_item = GTK_OPTION_MENU(contacts_optionmenu)->menu_item; 
    GtkMenuItem     *tmp_item;
    chat_content    *c;
    int             i,len;
    unsigned long   uin=0;
    gpointer        ud = gtk_object_get_user_data(GTK_OBJECT(menu_item));

    if ((ud != NULL) && (*((unsigned long *) ud) > 0)) {
        uin = *((unsigned long *) ud);
    } else {
        return;
    }

    GtkWidget *event_window = popup_user_event_window(uin,MODE_SEND,SEND_CHAT);
    if (event_window != NULL) {
         c = find_chatsession(dialog);
         if (c != NULL) { 
             chatsession_optionmenu = lookup_widget(event_window,
                     "chatsession_optionmenu");
             menuitem_list = gtk_container_children(GTK_CONTAINER(
                         gtk_option_menu_get_menu(GTK_OPTION_MENU(
                                    chatsession_optionmenu))));
             len = g_list_length(menuitem_list);
             for(i=0; i < len;i++) {
                 if (GTK_IS_MENU_ITEM(menuitem_list->data)) {
                     tmp_item = GTK_MENU_ITEM(menuitem_list->data);
                     if (c->chatman == (CChatManager *) gtk_object_get_user_data(
                                 GTK_OBJECT(tmp_item))) {
                         break;
                     }
                 }
                 menuitem_list = g_list_next(menuitem_list);
             }

             if (i < len) {
                 gtk_option_menu_set_history(GTK_OPTION_MENU(
                             chatsession_optionmenu),i);
             }

         } 
    }

}

void
on_chat_combo_entry_changed            (GtkEditable     *editable,
                                        gpointer         user_data)
{
    GtkWidget *dialog = lookup_widget(GTK_WIDGET(editable),"multichat_window");
    GtkWidget *pane_mode1 = lookup_widget(GTK_WIDGET(editable),"pane_mode1");
    GtkWidget *chat_local_textbox = lookup_widget(GTK_WIDGET(editable),
            "chat_local_textbox");
    GtkWidget *irc_entry = lookup_widget(GTK_WIDGET(editable),
            "irc_entry");
    GtkWidget *bold = lookup_widget(GTK_WIDGET(editable),"chat_bold_button");
    GtkWidget *italic = lookup_widget(GTK_WIDGET(editable),"chat_italic_button");
    GtkWidget *chat_fontsize_optionmenu = lookup_widget(GTK_WIDGET(editable),
            "chat_fontsize_optionmenu");
    char *fontname = gtk_editable_get_chars(editable,0,-1);
    insert_pixelsize_to_menu(GTK_OPTION_MENU(chat_fontsize_optionmenu), 
            fontname);

    chat_content *c;
       
    c = find_chatsession(dialog);
    if (c == NULL) {
        return;
    }

    strcpy(c->chat_font, fontname);
    
    free(fontname);
    
    change_local_font(dialog,c->chat_font,
            gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(bold))?"bold":"medium",
            gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(italic))?'i':'r',
            c->chat_font_size);
            
    
    c->chatman->ChangeFontFamily(c->chat_font);
}

void
on_chat_font_size_selected             (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
    
    GtkWidget *dialog = lookup_widget(GTK_WIDGET(menuitem),"multichat_window");
    GtkWidget *bold = lookup_widget(GTK_WIDGET(menuitem),"chat_bold_button");
    GtkWidget *italic = lookup_widget(GTK_WIDGET(menuitem),"chat_italic_button");
    GtkWidget *chat_fontsize_optionmenu = lookup_widget(GTK_WIDGET(menuitem),
            "chat_fontsize_optionmenu");

    char *tmp;
    GdkFont *tmpfont;
    chat_content *c;
       
    c = find_chatsession(dialog);
    if (c == NULL) {
        return;
    }
    
    c->chat_font_size = GPOINTER_TO_INT(user_data);
    
    change_local_font(dialog,c->chat_font,
            gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(bold))?"bold":"medium",
            gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(italic))?'i':'r',
            c->chat_font_size);
    
    c->chatman->ChangeFontSize(c->chat_font_size);

}

#if 0
void
on_chat_local_textbox_insert_text_event
                                        (GtkEditable     *editable,
                                        gchar           *new_text,
                                        gint             new_text_length,
                                        gint            *position,
                                        gpointer         user_data)
{
    static int leker = 0;
    chat_content *c;
        
    if (leker == 0) {
        leker = 1;
        
        GtkWidget *dialog = lookup_widget(GTK_WIDGET(editable),"multichat_window");
        c = find_chatsession(dialog);
        if (c == NULL) { 
            return;
        }   
        
        gtk_signal_emit_stop_by_name    (GTK_OBJECT(editable), "insert_text");

        GtkWidget *chat_local_textbox = lookup_widget(dialog,"chat_local_textbox");
        gtk_text_set_point (GTK_TEXT(chat_local_textbox),gtk_text_get_length (GTK_TEXT(chat_local_textbox)));
        gtk_text_insert(GTK_TEXT(chat_local_textbox),c->local_font,
                c->local_fg_color,
                NULL,
                new_text,new_text_length);
        leker = 0;
    }
}
#endif
 

void
on_save_chat_options1_activate         (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
    GtkWidget *dialog = lookup_widget(GTK_WIDGET(menuitem),"multichat_window");
    chat_content *c;

    c = find_chatsession(dialog);
    if (c == NULL) { 
        return;
    }   
    
       chat_msg(dialog,_("Saving options."));
       configuration.audio_on = c->audio_on;
       configuration.show_font_toolbar = c->show_font_toolbar;
       configuration.show_style_toolbar = c->show_style_toolbar;
       configuration.use_own_font = c->use_own_font;
       configuration.chat_mode = c->chat_mode;
       strcpy(configuration.chat_font,c->chat_font);
       configuration.chat_font_size = c->chat_font_size;
       configuration.toolbar_style = c->toolbar_style;
       configuration.use_own_color = c->use_own_color;
       configuration.chat_fg_color = c->local_fg_color_index;
       configuration.chat_bg_color = c->local_bg_color_index;
       save_configuration();
       chat_msg(dialog,"");
}

void 
on_contact_selected                    (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
}


void
on_toolbars_as_text1_activate          (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
    GtkWidget *dialog  = lookup_widget(GTK_WIDGET(menuitem),
            "multichat_window");

    GtkWidget *chat_style_toolbar = lookup_widget(GTK_WIDGET(menuitem),
            "chat_style_toolbar");
    chat_content *c;

    c = find_chatsession(dialog);
    if (c != NULL) { 
        if (GTK_CHECK_MENU_ITEM(menuitem)->active) {
            c->toolbar_style = TEXT_ONLY;
            gtk_toolbar_set_style(GTK_TOOLBAR(chat_style_toolbar),GTK_TOOLBAR_TEXT);
        }
    }   

}

void
on_toolbars_as_pics1_activate          (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
    GtkWidget *dialog  = lookup_widget(GTK_WIDGET(menuitem),
            "multichat_window");

    GtkWidget *chat_style_toolbar = lookup_widget(GTK_WIDGET(menuitem),
            "chat_style_toolbar");
    chat_content *c;

    c = find_chatsession(dialog);
    if (c != NULL) { 
        if (GTK_CHECK_MENU_ITEM(menuitem)->active) {
            gtk_toolbar_set_style(GTK_TOOLBAR(chat_style_toolbar),GTK_TOOLBAR_ICONS);
            c->toolbar_style = PICS_ONLY;
        }
    }   

}

void
on_toolbars_as_text_and_pics1_activate (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
    GtkWidget *dialog  = lookup_widget(GTK_WIDGET(menuitem),
            "multichat_window");
    GtkWidget *chat_style_toolbar = lookup_widget(GTK_WIDGET(menuitem),
            "chat_style_toolbar");
    chat_content *c;

    c = find_chatsession(dialog);
    if (c != NULL) { 
        if (GTK_CHECK_MENU_ITEM(menuitem)->active) {
            c->toolbar_style = TEXT_AND_PICS;
            gtk_toolbar_set_style(GTK_TOOLBAR(chat_style_toolbar),GTK_TOOLBAR_BOTH);
        }
    }   
}


void
on_use_own_colors1_activate            (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
    GtkWidget *dialog  = lookup_widget(GTK_WIDGET(menuitem),
            "multichat_window");
    GtkWidget *chat_local_textbox = lookup_widget(GTK_WIDGET(dialog),
            "chat_local_textbox");
    GtkWidget *chat_remote_textbox = lookup_widget(GTK_WIDGET(dialog),
            "chat_remote_textbox");

    chat_content *c;
    char *tmp_text;
    GtkStyle *style;
    
    
    c = find_chatsession(dialog);
    if (c != NULL) { 
        c->use_own_color = GTK_CHECK_MENU_ITEM(menuitem)->active;
    }   
    
    if (GTK_CHECK_MENU_ITEM(menuitem)->active) {
        style = gtk_style_copy(
                gtk_widget_get_style(GTK_WIDGET(chat_local_textbox)));
        gtk_widget_set_style(GTK_WIDGET(chat_remote_textbox),style);

    } else {
        if (c != NULL){
            style = gtk_style_copy(
                    gtk_widget_get_style(GTK_WIDGET(chat_remote_textbox)));
            style->base[GTK_STATE_NORMAL] = *c->remote_bg_color;
            gtk_widget_set_style(GTK_WIDGET(chat_remote_textbox),style);
        }
    }
}

void
on_multichat_window_destroy            (GtkObject       *object,
                                        gpointer         user_data)
{
    GtkWidget *dialog = (GtkWidget *) object;
    int len,i,j;
    GList *tmp_list;
    chat_content *c;

    gbug("removing chatsession!\n");
    c = find_chatsession(dialog);
    
    if (c != NULL) {
        c->chatUser = NULL;
        c->chatman->CloseChat();
        gtk_input_remove(c->chat_handler);
        if (c->remote_fg_color != NULL) {
            free(c->remote_fg_color);
        }
        if (c->remote_bg_color != NULL){
            free(c->remote_bg_color);
        }
    }
   
    unregister_signalcallback(chat_dialog_signalhandler,dialog);
    
    if (g_list_length(chat_sessions) == 1){
        len = g_list_length(available_fonts);
        tmp_list = g_list_first(available_fonts);
        for(j=0; j < len; j++) {
            free (tmp_list->data);
            tmp_list = g_list_next(tmp_list);
        }
        g_list_free(available_fonts);
        available_fonts = NULL;
        for(i=0; i < NUM_COLORS; i++) {
            free(chat_colors[i]);
        }
    }
    
    len = g_list_length(chat_sessions);
    tmp_list = g_list_first(chat_sessions);
    for(j=0; j < len; j++) {
        if (dialog == ((chat_content *) tmp_list->data)->chat_dialog )  {
            free(tmp_list->data);
            chat_sessions = g_list_remove_link(chat_sessions,tmp_list);
            break;
        }
        tmp_list = g_list_next(tmp_list);
    }
    gbug("removed chatsession done!\n");
}


