#ifndef _CHAT_H_
#define _CHAT_H_ 1

#include "gtk-gui.h"
#include "licq_chat.h"

#define NUM_COLORS 14
#define MAX_FONTS 32767

#define PANE_CHAT 0
#define IRC_CHAT 1

#define LINEBUF_LEN 512

#define TEXT_AND_PICS 0
#define TEXT_ONLY 1
#define PICS_ONLY 2

#define RGB_CONV(x,y,z) ((x)*0x101),((y)*0x101),((z)*0x101)
#define COLOR_CONV(x)   ((x)*0x101)



typedef enum
{
    XLFD_FOUNDRY      = 0,
    XLFD_FAMILY       = 1,
    XLFD_WEIGHT       = 2,
    XLFD_SLANT        = 3,
    XLFD_SET_WIDTH    = 4,
    XLFD_ADD_STYLE    = 5,
    XLFD_PIXELS       = 6,
    XLFD_POINTS       = 7,
    XLFD_RESOLUTION_X = 8,
    XLFD_RESOLUTION_Y = 9,
    XLFD_SPACING      = 10,
    XLFD_AVERAGE_WIDTH    = 11,
    XLFD_CHARSET      = 12
} FontField;

typedef struct {
    CChatManager *chatman;
    int chat_handler;
    GtkWidget *chat_dialog;
    CChatUser *chatUser;
    char                linebuf[LINEBUF_LEN];
    int                 buf_cnt;
    GdkFont             *local_font;
    GdkFont             *remote_font;
    bool                audio_on;
    bool                show_font_toolbar;
    bool                show_style_toolbar;
    bool                use_own_font;
    bool                use_own_color;
    gushort             chat_mode;
    gchar               chat_font[XLFD_MAX_FIELD_LEN];
    gushort             chat_font_size;
    GdkColor            *remote_fg_color;
    GdkColor            *remote_bg_color;
    GdkColor            *local_fg_color;
    GdkColor            *local_bg_color;
    GdkColor            *backup_fg_color;
    GdkColor            *backup_bg_color;
    gushort             local_fg_color_index;
    gushort             local_bg_color_index;
    gushort             toolbar_style;
} chat_content;

static const int col_array[] =
{
    0xFF, 0xFF, 0xFF,
    0x00, 0x00, 0x00,
    0x7F, 0x00, 0x00,
    0x00, 0x80, 0x00,
    0x80, 0x80, 0x00,
    0x00, 0x00, 0x80,
    0x80, 0x00, 0x80,
    0x80, 0x80, 0x80,
    0xC0, 0xC0, 0xC0,
    0xFF, 0x00, 0x00,
    0xFF, 0xFF, 0x00,
    0x00, 0xFF, 0x00,
    0x00, 0xFF, 0xFF,
    0x00, 0x00, 0xFF
};


int chat_msg(GtkWidget *dialog, char *msg);
void chatSendBeep();
void changeForeColor();
void changeBackColor();
void setBackground(GtkWidget *widget, bool update_local,
                const int r, const int g, const int b);
void setForeground(GtkWidget *widget, bool update_local,
                const int r, const int g, const int b);
int chat_StartAsServer(GtkWidget *dialog);
int chat_StartAsClient(unsigned short port, unsigned long uin, char *name, GtkWidget *dialog);
void slot_chat(void *v, int i, GdkInputCondition g);
bool chat_dialog_signalhandler(CICQSignal *signal, gpointer data);

#endif
