#include "gtk-gui.h"

#include <sys/time.h>
#include <stdio.h>
#include <strings.h>
#ifdef HAVE_ERRNO_H
#include <errno.h>
#endif
#include <unistd.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>

#include "licq_log.h"

#include "interface.h"
#include "contactlist.h"
#include "autoresponse.h"

    /*  Globals */
GtkWidget   *network_dialog=NULL;
CPluginLog  *pluglog;
gint        network_input_handle;
gulong      numberoflines=0;

void
network_window_read_notify  (gpointer data,
        gint source,
        GdkInputCondition condition)
{
    char        buf[4];
    char        *message;
    gint        pos,length;
    GtkWidget   *log_text=lookup_widget(network_dialog,
            "log_text");
    read(source, buf, 1);

    message=pluglog->NextLogMsg();
    pos=gtk_text_get_length(GTK_TEXT(log_text));
    gtk_text_freeze(GTK_TEXT(log_text));
    gtk_editable_insert_text(GTK_EDITABLE(log_text),message,
            strlen(message),&pos);

    if (pluglog->NextLogType()==L_ERROR) {
        showokdialog(_("Error"),message);
    }

    numberoflines++;
    while(numberoflines>configuration.historylines) {
        length=gtk_text_get_length(GTK_TEXT(log_text));
        for(pos=0;pos<length&&
                GTK_TEXT_INDEX(GTK_TEXT(log_text),(guint)pos)!='\n';
                pos++) ; 
        gtk_editable_delete_text(GTK_EDITABLE(log_text),0,
                (pos+1<length?pos+1:-1));
        numberoflines--;
    }
    
    gtk_text_thaw(GTK_TEXT(log_text));
    gtk_editable_set_position (GTK_EDITABLE(log_text), gtk_text_get_length (GTK_TEXT(log_text))-1);
    pluglog->ClearLog();
}

void
setup_networkwindow()
{
    pluglog=new CPluginLog();
    network_dialog=create_network_dialog();
    gtk_window_set_default_size(GTK_WINDOW(network_dialog),340,270);
    if(!pluglog || !(network_input_handle=gdk_input_add(  pluglog->Pipe(),
            GDK_INPUT_READ,
            network_window_read_notify,
            NULL))) {
        gbug("setup_networkwindow: failed to add gdkinput\n");
    }
    if (pluglog != NULL) {
        gLog.AddService(new CLogService_Plugin(pluglog, 
                    L_INFO|L_WARN|L_ERROR|L_UNKNOWN));
    }
}


void
show_network_window()
{
    if(!network_dialog) {
        setup_networkwindow();
    }

    if (network_dialog) {
        gtk_widget_show(network_dialog);
        gtk_widget_grab_focus(network_dialog);
    }
}

void
on_network_dialog_destroy              (GtkObject       *object,
                                        gpointer         user_data)
{
    delete pluglog;
    gdk_input_remove(network_input_handle);
    network_dialog=NULL;
    numberoflines=0;
}

void 
network_on_save_ok  (GtkFileSelection *selector, 
        gpointer user_data) 
{
    GtkWidget       *log_text=lookup_widget(network_dialog,"log_text");
    int             file;
    gchar           *filename, *msg;

    filename = gtk_file_selection_get_filename(
            GTK_FILE_SELECTION(user_data));
    if(!filename||!*filename) {
        return;
    }
    if((file=open(filename,O_CREAT|O_EXCL|O_WRONLY,S_IREAD|S_IWRITE|S_IRGRP))<0) {
        if(errno==EEXIST) {
            msg=g_strdup_printf(_("The file '%s' already exist, overwrite?"),
                    filename);
            if(showtextdialog(_("File exists"),msg,
                    DLGBUTTON_YES|DLGBUTTON_NO)==DLGBUTTON_YES) {
                g_free(msg);
                file=open(filename,O_CREAT|O_TRUNC|O_WRONLY,
                        S_IREAD|S_IWRITE|S_IRGRP); 
            }else {
                g_free(msg);
                return ;
            }
        }
    }
    if(file>0) {
        msg=gtk_editable_get_chars(GTK_EDITABLE(log_text),0,-1);
        write(file,msg,strlen(msg));
        close(file);
    }else {
        msg=g_strdup_printf(_("Create failed.\n\n'%s':%s"),
                filename,strerror(errno));
        showokdialog("File error", msg);
        g_free(msg);
    }
    gtk_widget_destroy(GTK_WIDGET(user_data));
}

void
on_save_button_clicked                 (GtkButton       *button,
                                        gpointer         user_data)
{
    GtkWidget       *selector;
    
    selector=gtk_file_selection_new(_("Select output filename"));
    
    gtk_signal_connect (GTK_OBJECT(GTK_FILE_SELECTION(selector)->ok_button),
            "clicked", GTK_SIGNAL_FUNC(network_on_save_ok), 
            (gpointer)selector);
                            
    gtk_signal_connect_object(GTK_OBJECT(
                GTK_FILE_SELECTION(selector)->cancel_button),
            "clicked", GTK_SIGNAL_FUNC(gtk_widget_destroy),
            GTK_OBJECT(selector));
    
    gtk_widget_show(selector);
}


void
on_clear_button_clicked                (GtkButton       *button,
                                        gpointer         user_data)
{
    GtkWidget   *log_text=lookup_widget(network_dialog,
            "log_text");

    gtk_editable_delete_text(GTK_EDITABLE(log_text),0,-1);
    numberoflines=0;
}


void
on_close_button_clicked                (GtkButton       *button,
                                        gpointer         user_data)
{
    if(GTK_WIDGET_VISIBLE(network_dialog)) {
        gtk_widget_hide(network_dialog);
    }
}

gboolean
on_network_dialog_delete_event         (GtkWidget       *widget,
                                        GdkEvent        *event,
                                        gpointer         user_data)
{
    if(GTK_WIDGET_VISIBLE(network_dialog)) {
        gtk_widget_hide(network_dialog);
    }
    return FALSE;
}


