#include "gtk-gui.h"

#include <ctype.h>
#include <dirent.h>
#include <stdio.h>
#include <sys/time.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>

#include "licq_sar.h"
#include "licq_translate.h"

#include "interface.h"
#include "contactlist.h"
#include "functions.h"
#include "options_dialog.h"

#ifdef USE_PSPELL
#include "spell.h"
#endif


/*  Globals */
GtkWidget   *options_window=NULL;
GdkFont     *global_editor_font=NULL;
int     nuber_of_cols = 0;

void
on_use_own_url_radio_toggled           (GtkToggleButton *togglebutton,
                                    gpointer         user_data)
{
    GtkWidget       *options_url_viewer_entry=lookup_widget(
            GTK_WIDGET(togglebutton),"options_url_viewer_entry");

    gtk_widget_set_sensitive(options_url_viewer_entry,gtk_toggle_button_get_active(togglebutton));
}

void
options_set_column_row_data            (gboolean   save,
                                        gint       column,
                                        gboolean   *newwidth)
{
    GtkWidget       *options_col_checkbutton=NULL;
    GtkWidget       *options_col_title_entry;
    GtkWidget       *options_col_format_entry;
    GtkWidget       *options_col_width_spinbutton;
    GtkWidget       *options_col_align_optionmenu;
    gchar           *temp;

    if(column) {
        temp = g_strdup_printf("options_col%d_checkbutton",column);
        options_col_checkbutton=lookup_widget(options_window,temp);
        g_free(temp);
    }
    temp = g_strdup_printf("options_col%d_title_entry",column);
    options_col_title_entry=lookup_widget(options_window,temp);
    g_free(temp);
    temp = g_strdup_printf("options_col%d_format_entry",column);
    options_col_format_entry=lookup_widget(options_window,temp);
    g_free(temp);
    temp = g_strdup_printf("options_col%d_width_spinbutton",column);
    options_col_width_spinbutton=lookup_widget(options_window,temp);
    g_free(temp);
    temp = g_strdup_printf("options_col%d_align_optionmenu",column);
    options_col_align_optionmenu=lookup_widget(options_window,temp);
    g_free(temp);

    if(!save) {
        if(column) {
            gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(
                        options_col_checkbutton),
                    configuration.columns[column].active);
        }
        gtk_entry_set_text(GTK_ENTRY(options_col_title_entry),
                configuration.columns[column].title);
        gtk_entry_set_text(GTK_ENTRY(options_col_format_entry),
                configuration.columns[column].format);
        gtk_spin_button_set_value(GTK_SPIN_BUTTON(options_col_width_spinbutton),
                configuration.columns[column].width);
        gtk_option_menu_set_history(GTK_OPTION_MENU(options_col_align_optionmenu),
                (int)configuration.columns[column].align);
    }else {
        if(column) {
            configuration.columns[column].active=gtk_toggle_button_get_active(
                    GTK_TOGGLE_BUTTON(options_col_checkbutton));
        }
        temp=gtk_editable_get_chars(GTK_EDITABLE(options_col_title_entry),0,-1);
        strcpy(configuration.columns[column].title,temp);
        g_free(temp);
        temp=gtk_editable_get_chars(GTK_EDITABLE(options_col_format_entry),0,-1);
        strcpy(configuration.columns[column].format,temp);
        g_free(temp);
        if(newwidth&&configuration.columns[column].width!=
                gtk_spin_button_get_value_as_int(
                    GTK_SPIN_BUTTON(options_col_width_spinbutton))) {
            *newwidth=TRUE;
        }

        configuration.columns[column].width=gtk_spin_button_get_value_as_int(
                GTK_SPIN_BUTTON(options_col_width_spinbutton));
        gtk_label_get(GTK_LABEL(gtk_container_children(
                        GTK_CONTAINER(options_col_align_optionmenu))->data),&temp);
        configuration.columns[column].align=get_justification(temp);
    }
}

void
options_sar_preset_clicked  (GtkMenuItem *mitem,
    gpointer user_data)
{
    GtkWidget       *options_sar_text=lookup_widget(options_window,
            "options_sar_text");
    GtkWidget       *options_sar_title_entry=lookup_widget(options_window,
            "options_sar_title_entry");
    SARList         sarlist;
    SARListIter     sariter;
    gint            pos=0,ndx=0;
    gchar           *label;

    sarlist=gSARManager.Fetch(GPOINTER_TO_INT(user_data));
    gtk_text_freeze(GTK_TEXT(options_sar_text));
    gtk_editable_delete_text(GTK_EDITABLE(options_sar_text),0,-1);
    sariter=sarlist.begin()+GPOINTER_TO_INT(gtk_object_get_user_data(
                GTK_OBJECT(mitem)));
    gtk_editable_insert_text(GTK_EDITABLE(options_sar_text),
            (*sariter)->AutoResponse(),
            strlen((*sariter)->AutoResponse()),&pos);
    gtk_text_thaw(GTK_TEXT(options_sar_text));
    gtk_entry_set_text(GTK_ENTRY(options_sar_title_entry),(*sariter)->Name());

    gSARManager.Drop();
}


void
options_sar_status_clicked             (GtkMenuItem *mitem,
                                        gpointer user_data)
{
    GtkWidget       *options_sar_preset_optionmenu=lookup_widget(
            options_window,"options_sar_preset_optionmenu");
    GtkWidget       *options_sar_status_optionmenu=lookup_widget(
            options_window,"options_sar_status_optionmenu");
    SARList         sarlist;
    SARListIter     sariter;
    GtkWidget       *menu,*menuitem;
    gint            ndx=0, thisndx=0, currentpresetndx=0;
    static gint     lastndx=0;
    gchar           *btntext;

    currentpresetndx=gtk_option_menu_get_history(
            GTK_OPTION_MENU(options_sar_preset_optionmenu));
    sarlist=gSARManager.Fetch(GPOINTER_TO_INT(user_data));
    menu=gtk_menu_new();
    gtk_widget_ref(menu);
    for(sariter=sarlist.begin();sariter!=sarlist.end();sariter++,ndx++) {
        if(strlen((*sariter)->Name())>25) {
            btntext=g_strdup_printf("%.22s...",(*sariter)->Name());
            menuitem=gtk_menu_item_new_with_label(btntext);
            g_free(btntext);
        }else {
            menuitem=gtk_menu_item_new_with_label((*sariter)->Name());
        }
        gtk_object_set_user_data(GTK_OBJECT(menuitem),GINT_TO_POINTER(ndx));
        gtk_signal_connect(GTK_OBJECT(menuitem),"activate",
                GTK_SIGNAL_FUNC(options_sar_preset_clicked),user_data);
        gtk_menu_append(GTK_MENU(menu),menuitem);
    }
    gtk_widget_show_all(menu);
    gtk_option_menu_set_menu(GTK_OPTION_MENU(options_sar_preset_optionmenu),
            menu);
    thisndx=gtk_option_menu_get_history(
            GTK_OPTION_MENU(options_sar_status_optionmenu));
    if(lastndx==thisndx) {
        gtk_option_menu_set_history(
                GTK_OPTION_MENU(options_sar_preset_optionmenu),
                currentpresetndx);

    }
    gSARManager.Drop();
    lastndx=thisndx;

    options_sar_preset_clicked(GTK_MENU_ITEM(
                gtk_container_children(GTK_CONTAINER(menu))->data),user_data);

}

void
refresh_server_list()
{
    GtkWidget       *options_server_clist=lookup_widget(
            options_window,"options_server_clist");
    gchar           *columns[3];
    gint            i,selection;

    gtk_clist_freeze(GTK_CLIST(options_server_clist));
    gtk_clist_clear(GTK_CLIST(options_server_clist));
    columns[2]=NULL;
    for (i=0;i<licq_daemon->icqServers.numServers();i++) {
        columns[0]=licq_daemon->icqServers.servers[i]->name();
        columns[1]=g_strdup_printf("%d",
                licq_daemon->icqServers.servers[i]->port());
        selection=gtk_clist_append(GTK_CLIST(options_server_clist),columns);
        gtk_clist_set_row_data(GTK_CLIST(options_server_clist),selection,
                GINT_TO_POINTER(i));
        g_free(columns[1]);
    }
    gtk_clist_thaw(GTK_CLIST(options_server_clist));
}

GSList * 
read_icons_from_dir                 (GSList       *list,
                                 gchar        *dirname)
{
    DIR             *dir;
    struct dirent   *direntry,*next_direntry;
    gchar           *fullname;

    if((dir=opendir(dirname))&&(direntry=(struct dirent*)malloc(
                    sizeof(struct dirent)+pathconf(dirname,_PC_NAME_MAX)))) {
        while(!readdir_r(dir,direntry,&next_direntry)&&next_direntry) {
            if(strstr(direntry->d_name,"icons.")==direntry->d_name) {
                fullname=g_strdup_printf("%s/%s/%s.icons",dirname,direntry->d_name,direntry->d_name+6);
                list=g_slist_append(list,fullname);
            }
        }
        closedir(dir);
    }

    return list;
}

void
refresh_iconlist()
{
    GSList          *iconlist=NULL,*iconfloat;
    gchar           *nptr;
    GtkWidget       *menu,*menuitem;
    int             i,selection=0;
    GtkWidget       *options_iconset_optionmenu=lookup_widget(
            options_window,"options_iconset_optionmenu");
    GtkWidget       *options_user_icondir_entry=lookup_widget(
            options_window,"options_user_icondir_entry");

    menu=gtk_menu_new();

    iconlist=read_icons_from_dir(iconlist,GTKGUI_DIR);
    nptr=gtk_editable_get_chars(GTK_EDITABLE(options_user_icondir_entry),0,-1);
    if(nptr&&*nptr) {
        iconlist=read_icons_from_dir(iconlist,nptr);
    }

    iconlist=g_slist_sort(iconlist,just_filename_compare_func);
    iconlist=g_slist_prepend(iconlist,g_strdup(_("Default icons")));
    for(iconfloat=iconlist,i=selection=0;iconfloat;
            i++,iconfloat=g_slist_next(iconfloat)) {
        nptr=(gchar*)strrchr((const char*)iconfloat->data,'/');
        if(!nptr) {
            nptr=(gchar*)iconfloat->data;
        }else {
            nptr++;
        }
        nptr=g_strdup(nptr);
        if(strstr(nptr,".icons")) {
            *strstr(nptr,".icons")='\0';
        }
        *nptr=toupper(*nptr);
        menuitem=gtk_menu_item_new_with_label(nptr);
        g_free(nptr);
        gtk_menu_append(GTK_MENU(menu),menuitem);
        gtk_object_set_data_full(GTK_OBJECT(menuitem),
                "filename",(gpointer)iconfloat->data,
                destroy_notify_free);
        if(!strcmp(configuration.iconset,(const char*)iconfloat->data)) {
            selection=i;
        }
    }
    g_slist_free(iconlist);
    gtk_widget_show_all(menu);
    gtk_option_menu_set_menu(GTK_OPTION_MENU(options_iconset_optionmenu),menu);
    gtk_option_menu_set_history(
            GTK_OPTION_MENU(options_iconset_optionmenu),selection);
    gtk_widget_set_sensitive(options_iconset_optionmenu,
            gtk_container_children(GTK_CONTAINER(
                    options_iconset_optionmenu))!=NULL);
}

void
on_options_window_show                 (GtkWidget       *widget,
                                    gpointer         user_data)
{
    /*  Main */ 
    GtkWidget       *options_page_ctree=lookup_widget(
            options_window,"options_page_ctree");

    /*  LICQ_SECURITY_PAGE */
    GtkWidget       *options_ignorenewusers_checkbutton=lookup_widget(
            options_window,"options_ignorenewusers_checkbutton");
    GtkWidget       *options_ignoremassmessages_checkbutton=lookup_widget(
            options_window,"options_ignoremassmessages_checkbutton");
    GtkWidget       *options_ignorewebpanel_checkbutton=lookup_widget(
            options_window,"options_ignorewebpanel_checkbutton");
    GtkWidget       *options_ignoreemailpager_checkbutton=lookup_widget(
            options_window,"options_ignoreemailpager_checkbutton");
    GtkWidget       *options_authorization_required_checkbutton=lookup_widget(
            options_window,"options_authorization_required_checkbutton");
    GtkWidget       *options_webpresence_checkbutton=lookup_widget(
            options_window,"options_webpresence_checkbutton");
    GtkWidget       *options_hide_ip_checkbutton=lookup_widget(
            options_window,"options_hide_ip_checkbutton");
    GtkWidget       *options_autsecure_checkbutton=lookup_widget(
            options_window,"options_autsecure_checkbutton");

    /*  LICQ_FIREWALL_PAGE */
    GtkWidget       *options_directconn_checkbutton=lookup_widget(
            options_window,"options_directconn_checkbutton");
    GtkWidget       *options_portfrom_spinbutton=lookup_widget(
            options_window,"options_portfrom_spinbutton");
    GtkWidget       *options_portto_spinbutton=lookup_widget(
            options_window,"options_portto_spinbutton");
    GtkWidget       *options_serverport_spinbutton=lookup_widget(
            options_window,"options_serverport_spinbutton");
    GtkWidget       *options_socks5_button=lookup_widget(
            options_window,"options_socks5_button");
    /*  LAYOUT_MAINWINDOW_PAGE */
    GtkWidget       *options_gnome_panel_checkbutton=lookup_widget(
            options_window,"options_gnome_panel_checkbutton");
    GtkWidget       *use_gnome_url_radio=lookup_widget(
            options_window,"use_gnome_url_radio");
    GtkWidget       *use_own_url_radio=lookup_widget(
            options_window,"use_own_url_radio");
    GtkWidget       *options_url_viewer_entry=lookup_widget(
            options_window,"options_url_viewer_entry");
    GtkWidget       *options_terminal_entry=lookup_widget(
            options_window,"options_terminal_entry");
    GtkWidget       *options_starthidden_checkbutton=lookup_widget(
            options_window,"options_starthidden_checkbutton");
    GtkWidget       *options_wm_checkbutton=lookup_widget(
            options_window,"options_wm_checkbutton");
    GtkWidget       *options_blink_checkbutton=lookup_widget(
            options_window,"options_blink_checkbutton");
    GtkWidget       *options_networklines_spinbutton=lookup_widget(
            options_window,"options_networklines_spinbutton");
    GtkWidget       *options_statustimer_checkbutton=lookup_widget(
            options_window,"options_statustimer_checkbutton");
    /*  OnEvent tab */
    COnEventManager *opt;
    GtkWidget       *options_onevent_checkbutton=lookup_widget(
            options_window,"options_onevent_checkbutton");
    GtkWidget       *options_beep_checkbutton=lookup_widget(
            options_window,"options_beep_checkbutton");
    GtkWidget       *options_onevent_command_entry=lookup_widget(
            options_window,"options_onevent_command_entry");
    GtkWidget       *options_onevent_message_entry=lookup_widget(
            options_window,"options_onevent_message_entry");
    GtkWidget       *options_onevent_url_entry=lookup_widget(
            options_window,"options_onevent_url_entry");
    GtkWidget       *options_onevent_chat_entry=lookup_widget(
            options_window,"options_onevent_chat_entry");
    GtkWidget       *options_onevent_file_entry=lookup_widget(
            options_window,"options_onevent_file_entry");
    GtkWidget       *options_onevent_notify_entry=lookup_widget(
            options_window,"options_onevent_notify_entry");
    GtkWidget       *options_onevent_system_entry=lookup_widget(
            options_window,"options_onevent_system_entry");
    GtkWidget       *options_onevent_away_checkbutton=lookup_widget(
            options_window,"options_onevent_away_checkbutton");
    GtkWidget       *options_onevent_na_checkbutton=lookup_widget(
            options_window,"options_onevent_na_checkbutton");
    GtkWidget       *options_onevent_occupied_checkbutton=lookup_widget(
            options_window,"options_onevent_occupied_checkbutton");
    GtkWidget       *options_onevent_dnd_checkbutton=lookup_widget(
            options_window,"options_onevent_dnd_checkbutton");
    GtkWidget       *options_online_onlogin_checkbutton=lookup_widget(
            options_window,"options_online_onlogin_checkbutton");
    /*  LAYOUT_FONTSANDICONS_PAGE */
    GtkWidget       *options_contactlistfont_entry=lookup_widget(
            options_window,"options_contactlistfont_entry");
    GtkWidget       *options_editforfont_entry=lookup_widget(
            options_window,"options_editforfont_entry");
    GtkWidget       *options_user_icondir_entry=lookup_widget(
            options_window,"options_user_icondir_entry");

    /*  Status tab */
    GtkWidget       *options_autologon_optionmenu=lookup_widget(
            options_window,"options_autologon_optionmenu");
    GtkWidget       *option_invisible_checkbutton=lookup_widget(
            options_window,"option_invisible_checkbutton");
    GtkWidget       *options_autoaway_spinbutton=lookup_widget(
            options_window,"options_autoaway_spinbutton");
    GtkWidget       *options_autona_spinbutton=lookup_widget(
            options_window,"options_autona_spinbutton");
    GtkWidget       *options_autooffline_spinbutton=lookup_widget(
            options_window,"options_autooffline_spinbutton");
    GtkWidget       *option_autoback_checkbutton=lookup_widget(
            options_window,"option_autoback_checkbutton");
    GtkWidget       *options_sar_status_optionmenu=lookup_widget(
            options_window,"options_sar_status_optionmenu");
    /*  Contactlist tab */
    GtkWidget       *options_showcoltitles_checkbutton=lookup_widget(
            options_window,"options_showcoltitles_checkbutton");
    GtkWidget       *options_sortlist1_optionmenu=lookup_widget(
            options_window,"options_sortlist1_optionmenu");
    GtkWidget       *options_sortlist2_optionmenu=lookup_widget(
            options_window,"options_sortlist2_optionmenu");
    GtkWidget       *options_sortlist3_optionmenu=lookup_widget(
            options_window,"options_sortlist3_optionmenu");
    GtkWidget       *options_showgroupmenu_checkbutton=lookup_widget(
            options_window,"options_showgroupmenu_checkbutton");
    GtkWidget       *options_singleclick_checkbutton=lookup_widget(
            options_window,"options_singleclick_checkbutton");
    GtkWidget       *options_selactiveuser_checkbutton=lookup_widget(
            options_window,"options_selactiveuser_checkbutton");
    /*  Messages tab */
    GtkWidget       *option_file_default_dir_entry = lookup_widget(
            options_window,"option_file_default_dir_entry");
    GtkWidget       *qsearch_spinbutton = lookup_widget(
            options_window,"qsearch_spinbutton");
    GtkWidget       *option_file_autoclose_checkbutton = lookup_widget(
            options_window,"option_file_autoclose_checkbutton");
    GtkWidget       *options_translation_combo=lookup_widget(
            options_window,"options_translation_combo");
    GtkWidget       *options_translation_combo_entry=lookup_widget(
            options_window,"options_translation_combo_entry");
    /*  EVENT_SENDING_PAGE */
    GtkWidget       *options_auto_send_thru_server_checkbutton=lookup_widget(
            options_window,"options_auto_send_thru_server_checkbutton");
    GtkWidget       *options_autopopup_checkbutton=lookup_widget(
            options_window,"options_autopopup_checkbutton");
    GtkWidget       *options_autopopwhenonline_checkbutton=lookup_widget(
            options_window,"options_autopopwhenonline_checkbutton");
    GtkWidget       *options_autoraise_checkbutton=lookup_widget(
            options_window,"options_autoraise_checkbutton");
    GtkWidget       *options_quotewidth_spinbutton=lookup_widget(
            options_window,"options_quotewidth_spinbutton");
    GtkWidget       *spell_frame =lookup_widget(
            options_window,"spell_frame");
    GtkWidget       *options_ignorecolors_checkbutton=lookup_widget(
            options_window,"options_ignorecolors_checkbutton");
#ifdef USE_PSPELL
    GtkWidget       *spell_combo =lookup_widget(
            options_window,"spell_default_combo");
    GtkWidget       *spell1_radio =lookup_widget(
            options_window,"spell1_radio");
    GtkWidget       *spell2_radio =lookup_widget(
            options_window,"spell2_radio");
    GtkWidget       *spell3_radio =lookup_widget(
            options_window,"spell3_radio");
    GtkWidget       *spell4_radio =lookup_widget(
            options_window,"spell4_radio");
    GtkWidget       *spell_default_entry =lookup_widget(
            options_window,"spell_default_entry");
    GtkWidget       *spell_errorfont_entry =lookup_widget(
            options_window,"spell_errorfont_entry");
#endif

    /*  Misc */
    int             i;
    ICQOwner        *owner;
    GList           *children,*translations=NULL;
    gchar           *text[2],dirname[PATH_MAX],*tname;
    GtkCTreeNode    *sibling=NULL,*parent=NULL;
    GtkWidget       *menu, *menuitem, *label;
    DIR             *dir;
    struct dirent   result,*nextres;
    struct stat     statres;

    /*  FOR 0.50 RELEASE!!! */
    GtkWidget       *frame41=lookup_widget(options_window,"frame41");
    gtk_widget_hide(frame41);
    /*  END FOR 0.50 */

    /*  Setup the window and stuff so we get a freaking 
        window->gdkwindow */ 
    gtk_widget_realize(options_window);

    /*  Main */ 
    gtk_clist_set_auto_sort(GTK_CLIST(options_page_ctree),FALSE);
    text[1]=NULL;
    /*  Licq */
    text[0]=_("Licq");
    parent=gtk_ctree_insert_node(GTK_CTREE(options_page_ctree),parent,sibling,
            text,0,NULL,NULL,NULL,NULL,FALSE,TRUE);
    gtk_ctree_node_set_selectable(GTK_CTREE(options_page_ctree),
            GTK_CTREE_NODE(parent),FALSE);
    text[0]=_("Security");
    sibling=gtk_ctree_insert_node(GTK_CTREE(options_page_ctree),parent,sibling,
            text,0,NULL,NULL,NULL,NULL,FALSE,TRUE);
    gtk_ctree_node_set_row_data(GTK_CTREE(options_page_ctree),
            GTK_CTREE_NODE(sibling),GINT_TO_POINTER(LICQ_SECURITY_PAGE));
    text[0]=_("Servers");
    sibling=gtk_ctree_insert_node(GTK_CTREE(options_page_ctree),parent,sibling,
            text,0,NULL,NULL,NULL,NULL,FALSE,TRUE);
    gtk_ctree_node_set_row_data(GTK_CTREE(options_page_ctree),
            GTK_CTREE_NODE(sibling),GINT_TO_POINTER(LICQ_SERVERS_PAGE));
    text[0]=_("Firewall");
    sibling=gtk_ctree_insert_node(GTK_CTREE(options_page_ctree),parent,sibling,
            text,0,NULL,NULL,NULL,NULL,FALSE,TRUE);
    gtk_ctree_node_set_row_data(GTK_CTREE(options_page_ctree),
            GTK_CTREE_NODE(sibling),GINT_TO_POINTER(LICQ_FIREWALL_PAGE));
    /*  Status */
    parent=NULL;
    sibling=NULL;
    text[0]=_("Status");
    parent=gtk_ctree_insert_node(GTK_CTREE(options_page_ctree),parent,sibling,
            text,0,NULL,NULL,NULL,NULL,FALSE,TRUE);
    gtk_ctree_node_set_selectable(GTK_CTREE(options_page_ctree),
            GTK_CTREE_NODE(parent),FALSE);
    text[0]=_("Autostatus");
    sibling=gtk_ctree_insert_node(GTK_CTREE(options_page_ctree),parent,sibling,
            text,0,NULL,NULL,NULL,NULL,FALSE,TRUE);
    gtk_ctree_node_set_row_data(GTK_CTREE(options_page_ctree),
            GTK_CTREE_NODE(sibling),GINT_TO_POINTER(STATUS_AUTO_PAGE));
    text[0]=_("Preset messages");
    sibling=gtk_ctree_insert_node(GTK_CTREE(options_page_ctree),parent,sibling,
            text,0,NULL,NULL,NULL,NULL,FALSE,TRUE);
    gtk_ctree_node_set_row_data(GTK_CTREE(options_page_ctree),
            GTK_CTREE_NODE(sibling),GINT_TO_POINTER(STATUS_PRESET_PAGE));
    /*  Layout */
    parent=NULL;
    sibling=NULL;
    text[0]=_("Layout");
    parent=gtk_ctree_insert_node(GTK_CTREE(options_page_ctree),parent,sibling,
            text,0,NULL,NULL,NULL,NULL,FALSE,TRUE);
    gtk_ctree_node_set_selectable(GTK_CTREE(options_page_ctree),
            GTK_CTREE_NODE(parent),FALSE);
    text[0]=_("Colors");
    sibling=gtk_ctree_insert_node(GTK_CTREE(options_page_ctree),parent,sibling,
            text,0,NULL,NULL,NULL,NULL,FALSE,TRUE);
    gtk_ctree_node_set_row_data(GTK_CTREE(options_page_ctree),
            GTK_CTREE_NODE(sibling),GINT_TO_POINTER(LAYOUT_COLORS_PAGE));
    text[0]=_("Fonts and icons");
    sibling=gtk_ctree_insert_node(GTK_CTREE(options_page_ctree),parent,sibling,
            text,0,NULL,NULL,NULL,NULL,FALSE,TRUE);
    gtk_ctree_node_set_row_data(GTK_CTREE(options_page_ctree),
            GTK_CTREE_NODE(sibling),GINT_TO_POINTER(LAYOUT_FONTSANDICONS_PAGE));
    text[0]=_("Contactlist columns");
    sibling=gtk_ctree_insert_node(GTK_CTREE(options_page_ctree),parent,sibling,
            text,0,NULL,NULL,NULL,NULL,FALSE,TRUE);
    gtk_ctree_node_set_row_data(GTK_CTREE(options_page_ctree),
            GTK_CTREE_NODE(sibling),GINT_TO_POINTER(
                LAYOUT_CONTACTLISTCOLUMNS_PAGE));
    text[0]=_("Mainwindow");
    sibling=gtk_ctree_insert_node(GTK_CTREE(options_page_ctree),parent,sibling,
            text,0,NULL,NULL,NULL,NULL,FALSE,TRUE);
    gtk_ctree_node_set_row_data(GTK_CTREE(options_page_ctree),
            GTK_CTREE_NODE(sibling),GINT_TO_POINTER(LAYOUT_MAINWINDOW_PAGE));
    /*  Events */
    parent=NULL;
    sibling=NULL;
    text[0]=_("Events");
    parent=gtk_ctree_insert_node(GTK_CTREE(options_page_ctree),parent,sibling,
            text,0,NULL,NULL,NULL,NULL,FALSE,TRUE);
    gtk_ctree_node_set_selectable(GTK_CTREE(options_page_ctree),
            GTK_CTREE_NODE(parent),FALSE);
    text[0]=_("OnEvents");
    sibling=gtk_ctree_insert_node(GTK_CTREE(options_page_ctree),parent,sibling,
            text,0,NULL,NULL,NULL,NULL,FALSE,TRUE);
    gtk_ctree_node_set_row_data(GTK_CTREE(options_page_ctree),
            GTK_CTREE_NODE(sibling),GINT_TO_POINTER(EVENT_ONEVENTS_PAGE));
    text[0]=_("Sending");
    sibling=gtk_ctree_insert_node(GTK_CTREE(options_page_ctree),parent,sibling,
            text,0,NULL,NULL,NULL,NULL,FALSE,TRUE);
    gtk_ctree_node_set_row_data(GTK_CTREE(options_page_ctree),
            GTK_CTREE_NODE(sibling),GINT_TO_POINTER(EVENT_SENDING_PAGE));
    text[0]=_("Receiving");
    sibling=gtk_ctree_insert_node(GTK_CTREE(options_page_ctree),parent,sibling,
            text,0,NULL,NULL,NULL,NULL,FALSE,TRUE);
    gtk_ctree_node_set_row_data(GTK_CTREE(options_page_ctree),
            GTK_CTREE_NODE(sibling),GINT_TO_POINTER(EVENT_RECEIVING_PAGE));
    gtk_ctree_select(GTK_CTREE(options_page_ctree),gtk_ctree_node_nth(
                GTK_CTREE(options_page_ctree),1));
    /*  LICQ_FIREWALL_PAGE */
    gtk_toggle_button_set_active(
            GTK_TOGGLE_BUTTON(options_directconn_checkbutton), 
            licq_daemon->TCPEnabled());
    gtk_spin_button_set_value(GTK_SPIN_BUTTON(options_portfrom_spinbutton),
            licq_daemon->TCPPortsLow()); 
    gtk_spin_button_set_value(GTK_SPIN_BUTTON(options_portto_spinbutton),
            licq_daemon->TCPPortsHigh());
    gtk_spin_button_set_value(GTK_SPIN_BUTTON(options_serverport_spinbutton), 
            licq_daemon->getDefaultRemotePort());
    gtk_widget_hide(options_socks5_button);
    on_options_directconn_checkbutton_toggled(
            GTK_TOGGLE_BUTTON(options_directconn_checkbutton), NULL);
    refresh_server_list();

    /*  LICQ_SECURITY_PAGE */
    gtk_toggle_button_set_active(
            GTK_TOGGLE_BUTTON(options_ignorenewusers_checkbutton), 
            licq_daemon->Ignore(IGNORE_NEWUSERS));
    gtk_toggle_button_set_active(
            GTK_TOGGLE_BUTTON(options_ignoremassmessages_checkbutton), 
            licq_daemon->Ignore(IGNORE_MASSMSG));
    gtk_toggle_button_set_active(
            GTK_TOGGLE_BUTTON(options_ignorewebpanel_checkbutton), 
            licq_daemon->Ignore(IGNORE_WEBPANEL));
    gtk_toggle_button_set_active(
            GTK_TOGGLE_BUTTON(options_ignoreemailpager_checkbutton), 
            licq_daemon->Ignore(IGNORE_EMAILPAGER));

    owner=gUserManager.FetchOwner(LOCK_R);
    gtk_toggle_button_set_active(
            GTK_TOGGLE_BUTTON(options_hide_ip_checkbutton),
            owner->HideIp());
    gtk_toggle_button_set_active(
            GTK_TOGGLE_BUTTON(options_webpresence_checkbutton),
            owner->WebAware());
    gtk_toggle_button_set_active(
            GTK_TOGGLE_BUTTON(options_authorization_required_checkbutton),
            owner->GetAuthorization());
    gUserManager.DropUser(owner);

    gtk_toggle_button_set_active(
            GTK_TOGGLE_BUTTON(options_autsecure_checkbutton),
            configuration.auto_autosecure);

    /*  LAYOUT_MAINWINDOW_PAGE */
#ifndef USE_PANEL
    gtk_widget_hide(options_gnome_panel_checkbutton);
    gtk_widget_hide(options_starthidden_checkbutton);
#else
    gtk_toggle_button_set_active(
            GTK_TOGGLE_BUTTON(options_gnome_panel_checkbutton),
            configuration.launchpanel);
    gtk_toggle_button_set_active(
            GTK_TOGGLE_BUTTON(options_starthidden_checkbutton),
            configuration.starthidden);
#endif
    gtk_toggle_button_set_active(
            GTK_TOGGLE_BUTTON(options_wm_checkbutton),
            configuration.wm_placement);
#ifdef USE_GNOME
    gtk_widget_set_sensitive(options_url_viewer_entry,!configuration.use_gnomeurlviewer);
    if (configuration.use_gnomeurlviewer) {
        gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(use_gnome_url_radio),
                TRUE);
    } else {
        gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(use_own_url_radio),
                TRUE);
    }
    gbug("GET use gnome: %s",configuration.use_gnomeurlviewer?"TRUE":"FALSE");
#else
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(use_own_url_radio),TRUE);
    gtk_widget_hide(use_gnome_url_radio);
    gtk_widget_hide(use_own_url_radio);
#endif
    gtk_entry_set_text(GTK_ENTRY(options_url_viewer_entry),
            licq_daemon->getUrlViewer());
    gtk_entry_set_text(GTK_ENTRY(options_terminal_entry),
            licq_daemon->Terminal());
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(options_blink_checkbutton),
            configuration.blinkicons);
    gtk_spin_button_set_value(GTK_SPIN_BUTTON(options_networklines_spinbutton),
            configuration.historylines);
    gtk_toggle_button_set_active(
            GTK_TOGGLE_BUTTON(options_statustimer_checkbutton),
            configuration.showstatustimer);

    /*  OnEvent Tab */
    opt=licq_daemon->OnEventManager();
    gtk_toggle_button_set_active(
            GTK_TOGGLE_BUTTON(options_onevent_checkbutton),
            configuration.use_onevents); 
    gtk_toggle_button_set_active(
            GTK_TOGGLE_BUTTON(options_beep_checkbutton),
            configuration.beep_onevent); 

    opt->Lock();
    gtk_entry_set_text(
            GTK_ENTRY(options_onevent_command_entry),
            opt->Command());
    gtk_entry_set_text(
            GTK_ENTRY(options_onevent_message_entry),
            opt->Parameter(ON_EVENT_MSG));
    gtk_entry_set_text(
            GTK_ENTRY(options_onevent_url_entry),
            opt->Parameter(ON_EVENT_URL));
    gtk_entry_set_text(
            GTK_ENTRY(options_onevent_chat_entry),
            opt->Parameter(ON_EVENT_CHAT));
    gtk_entry_set_text(
            GTK_ENTRY(options_onevent_file_entry),
            opt->Parameter(ON_EVENT_FILE));
    gtk_entry_set_text(
            GTK_ENTRY(options_onevent_notify_entry),
            opt->Parameter(ON_EVENT_NOTIFY));
    gtk_entry_set_text(
            GTK_ENTRY(options_onevent_system_entry),
            opt->Parameter(ON_EVENT_SYSMSG));
    opt->Unlock();
    owner=gUserManager.FetchOwner(LOCK_R);
    gtk_toggle_button_set_active(
            GTK_TOGGLE_BUTTON(options_onevent_away_checkbutton),
            owner->AcceptInAway());
    gtk_toggle_button_set_active(
            GTK_TOGGLE_BUTTON(options_onevent_na_checkbutton),
            owner->AcceptInNA());
    gtk_toggle_button_set_active(
            GTK_TOGGLE_BUTTON(options_onevent_occupied_checkbutton),
            owner->AcceptInOccupied());
    gtk_toggle_button_set_active(
            GTK_TOGGLE_BUTTON(options_onevent_dnd_checkbutton),
            owner->AcceptInDND());
    gUserManager.DropOwner();
    gtk_toggle_button_set_active(
            GTK_TOGGLE_BUTTON(options_online_onlogin_checkbutton),
            licq_daemon->AlwaysOnlineNotify());

    /*  LAYOUT_FONTSANDICONS_PAGE */ 
    gtk_entry_set_text(GTK_ENTRY(options_user_icondir_entry),
            configuration.usericondir);
    refresh_iconlist();
    gtk_entry_set_text(GTK_ENTRY(options_contactlistfont_entry),
            configuration.contactfont);
    gtk_entry_set_text(GTK_ENTRY(options_editforfont_entry),
            configuration.editorfont); 

    /*  LAYOUT_COLORS_PAGE */
    /* DO NOT TRANSLATE, internal data */ 
    color_select_display_row_set_data("online",&configuration.color_online,0);
    color_select_display_row_set_data("offline",&configuration.color_offline,1);
    color_select_display_row_set_data("other",&configuration.color_other,2);
    color_select_display_row_set_data("new",&configuration.color_new,3);
    color_select_display_row_set_data("sent",&configuration.color_sent,4);
    color_select_display_row_set_data("rcvd",&configuration.color_rcvd,5);


    /*  EVENT_SENDING_PAGE */
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(options_autopopup_checkbutton),
            configuration.autopopupmessages);
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(
                options_autopopwhenonline_checkbutton), 
            configuration.onlyautopopupwhenonline);
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(options_autoraise_checkbutton),
            configuration.autoraise);
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(
                options_auto_send_thru_server_checkbutton),
            configuration.autosendthroughserver);
    gtk_spin_button_set_value(GTK_SPIN_BUTTON(options_quotewidth_spinbutton),
            configuration.quotewidth);
#ifndef USE_PSPELL
    gtk_widget_hide(spell_frame);
#else
    gtk_combo_set_popdown_strings (GTK_COMBO(spell_combo),dicts);
    switch (configuration.spelling_mode) {
        default:
        case USE_USER_LANG_AND_DEFAULT:
            gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(spell1_radio),TRUE);
            break;
        case USE_USER_LANG_AND_NONE:
            gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(spell2_radio),TRUE);
            break;
        case USE_DEFAULT_LANG:
            gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(spell3_radio),TRUE);
            break;
        case DISABLE_SPELL:
            gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(spell4_radio),TRUE);
            break;
    }
    gtk_entry_set_text(GTK_ENTRY(spell_errorfont_entry),
            configuration.spell_errorfont);
    gtk_entry_set_text(GTK_ENTRY(spell_default_entry),configuration.defaut_dict);
    label=gtk_container_get_label(GTK_CONTAINER(spell1_radio));
    gtk_label_set_line_wrap(GTK_LABEL(label),TRUE);
    label=gtk_container_get_label(GTK_CONTAINER(spell2_radio));
    gtk_label_set_line_wrap(GTK_LABEL(label),TRUE);
    label=gtk_container_get_label(GTK_CONTAINER(spell3_radio));
    gtk_label_set_line_wrap(GTK_LABEL(label),TRUE);
    label=gtk_container_get_label(GTK_CONTAINER(spell4_radio));
    gtk_label_set_line_wrap(GTK_LABEL(label),TRUE);
#endif
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(
                options_ignorecolors_checkbutton),configuration.ignoremsgcolors);

    /*  Contactlist tab */
    for(i=0;i<4;i++) {
        options_set_column_row_data(FALSE,i,NULL);
    } 
    on_options_columns_checkbutton_toggled(NULL, NULL); 
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(
                options_showcoltitles_checkbutton),configuration.showcoltitles);
    gtk_option_menu_set_history(GTK_OPTION_MENU(options_sortlist1_optionmenu),
            configuration.sortlist[0]);
    gtk_option_menu_set_history(GTK_OPTION_MENU(options_sortlist2_optionmenu),
            configuration.sortlist[1]);
    gtk_option_menu_set_history(GTK_OPTION_MENU(options_sortlist3_optionmenu),
            configuration.sortlist[2]);
    gtk_toggle_button_set_active(
            GTK_TOGGLE_BUTTON(options_showgroupmenu_checkbutton),
            configuration.showgroupmenu);
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(options_singleclick_checkbutton),
            configuration.singleclick);
    children=gtk_container_children(GTK_CONTAINER(
                gtk_option_menu_get_menu(GTK_OPTION_MENU(
                        options_sortlist1_optionmenu))));
    while(children) {
        gtk_signal_connect(GTK_OBJECT(children->data),"activate",
                GTK_SIGNAL_FUNC(on_options_sortlist_optionmenu_clicked),
                NULL);
        children=g_list_next(children);
    }
    children=gtk_container_children(GTK_CONTAINER(
                gtk_option_menu_get_menu(GTK_OPTION_MENU(
                        options_sortlist2_optionmenu))));
    while(children) {
        gtk_signal_connect(GTK_OBJECT(children->data),"activate",
                GTK_SIGNAL_FUNC(on_options_sortlist2_optionmenu_clicked),
                NULL);
        children=g_list_next(children);
    }
    on_options_sortlist_optionmenu_clicked(NULL,NULL);
    gtk_toggle_button_set_active(
            GTK_TOGGLE_BUTTON(options_selactiveuser_checkbutton),
            configuration.showactiveuser);

    gtk_spin_button_set_value (GTK_SPIN_BUTTON(qsearch_spinbutton),
            (configuration.quicksearchcol <= nuber_of_cols)?configuration.quicksearchcol:nuber_of_cols);


    /*  Status tab */
    gtk_option_menu_set_history(GTK_OPTION_MENU(options_autologon_optionmenu),
            configuration.autologon);
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(option_invisible_checkbutton),
            configuration.invisible);
    gtk_spin_button_set_value(GTK_SPIN_BUTTON(options_autoaway_spinbutton),
            configuration.autoaway);
    gtk_spin_button_set_value(GTK_SPIN_BUTTON(options_autona_spinbutton),
            configuration.autona);
    gtk_spin_button_set_value(GTK_SPIN_BUTTON(options_autooffline_spinbutton),
            configuration.autooffline);
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(option_autoback_checkbutton),
            configuration.autoback);

    menu=gtk_menu_new();
    gtk_widget_ref(menu);
    menuitem=gtk_menu_item_new_with_label(_("Away"));
    gtk_signal_connect(GTK_OBJECT(menuitem),"activate",
            GTK_SIGNAL_FUNC(options_sar_status_clicked),
            GINT_TO_POINTER(SAR_AWAY));
    gtk_menu_append(GTK_MENU(menu),menuitem);
    menuitem=gtk_menu_item_new_with_label(_("Not Available"));
    gtk_signal_connect(GTK_OBJECT(menuitem),"activate",
            GTK_SIGNAL_FUNC(options_sar_status_clicked),
            GINT_TO_POINTER(SAR_NA));
    gtk_menu_append(GTK_MENU(menu),menuitem);
    menuitem=gtk_menu_item_new_with_label(_("Occupied"));
    gtk_signal_connect(GTK_OBJECT(menuitem),"activate",
            GTK_SIGNAL_FUNC(options_sar_status_clicked),
            GINT_TO_POINTER(SAR_OCCUPIED));
    gtk_menu_append(GTK_MENU(menu),menuitem);
    menuitem=gtk_menu_item_new_with_label(_("Do Not Disturb"));
    gtk_signal_connect(GTK_OBJECT(menuitem),"activate",
            GTK_SIGNAL_FUNC(options_sar_status_clicked),
            GINT_TO_POINTER(SAR_DND));
    gtk_menu_append(GTK_MENU(menu),menuitem);
    menuitem=gtk_menu_item_new_with_label(_("Free For Chat"));
    gtk_signal_connect(GTK_OBJECT(menuitem),"activate",
            GTK_SIGNAL_FUNC(options_sar_status_clicked),
            GINT_TO_POINTER(SAR_FFC));
    gtk_menu_append(GTK_MENU(menu),menuitem);
    gtk_widget_show_all(menu);
    gtk_option_menu_set_menu(GTK_OPTION_MENU(options_sar_status_optionmenu),
            menu);
    gtk_option_menu_set_history(GTK_OPTION_MENU(options_sar_status_optionmenu),
            0);
    options_sar_status_clicked(GTK_MENU_ITEM(menuitem),
            GINT_TO_POINTER(SAR_AWAY));

    /*  Messages tab */
    gtk_entry_set_text(GTK_ENTRY(option_file_default_dir_entry),
            configuration.file_dir);
    gtk_toggle_button_set_active(
            GTK_TOGGLE_BUTTON(option_file_autoclose_checkbutton),
            configuration.auto_close_file_win);
    snprintf(dirname,PATH_MAX,"%s%s",SHARE_DIR,TRANSLATION_DIR);
        /*  Note, NOT translateable due to licq stupid internal represenations */
    if(dirname) {
        if((dir=opendir(dirname))) {
            while(!readdir_r(dir,&result,&nextres)&&nextres) {
                snprintf(dirname,PATH_MAX,"%s%s/%s",SHARE_DIR,TRANSLATION_DIR,
                        result.d_name);
                if(!stat(dirname,&statres)&&S_ISREG(statres.st_mode)) {
                    tname=g_strdup(result.d_name);
                    translations=g_list_prepend(translations,tname);
                }
            }
        }else {
            showokdialog(_("Could not read translations"),
                    _("Unable to read the translations"));
        }
    }
    translations=g_list_sort(translations,(GCompareFunc)strcmp);
    tname=g_strdup("none");
    translations=g_list_prepend(translations,tname);
    gtk_combo_set_popdown_strings(GTK_COMBO(options_translation_combo),
            translations);
    g_list_free(translations);
    gtk_entry_set_text(GTK_ENTRY(options_translation_combo_entry),
            gTranslator.getMapName());
}



void
on_options_window_destroy              (GtkObject       *object,
                                    gpointer         user_data)
{
    /* WANT TO FREE THE STRINGS *mumble* 
    GtkWidget       *options_translation_combo=lookup_widget(options_window,
            "options_translation_combo");
    GtkWidget       *spell_default_combo=lookup_widget(options_window,
            "spell_default_combo"); */

    options_window=NULL;
}

void
options_on_popdown_alias_insert(GtkMenuItem *menuitem,
    GtkWidget *entry)
{
    int     pos;
    gchar   *text;
    pos=gtk_editable_get_position(GTK_EDITABLE(entry));

    gtk_label_get(GTK_LABEL(gtk_container_children(
                    GTK_CONTAINER(menuitem))->data), &text);

    gtk_editable_insert_text(GTK_EDITABLE(entry),
            text,2,&pos);
}

void
options_on_format_popdown_clicked      (GtkButton       *button,
                                    gpointer         user_data)
{
    GtkWidget       *new_menu, *item_new;
    int             i;
    gchar           *items[]={                                  
        _("%a - user alias"),
        _("%i - user IP"),
        _("%p - user port"),
        _("%e - email"),
        _("%n - full name"),
        _("%f - first name"),
        _("%l - last name"),
        _("%u - uin"),
        _("%w - webpage"),
        _("%h - phone number"),
        _("%s - full status"),
        _("%S - abbreviated status"),
        _("%o - last seen online"),
        NULL};


        new_menu=gtk_menu_new();
        /*    gtk_signal_connect(GTK_OBJECT(new_menu),
              "hide",
              GTK_SIGNAL_FUNC(gtk_widget_destroy),NULL); */
        for(i=0;items[i];i++) {
            item_new=gtk_menu_item_new_with_label(items[i]);
            gtk_signal_connect(GTK_OBJECT(item_new),
                    "activate",
                    GTK_SIGNAL_FUNC(options_on_popdown_alias_insert),
                    button);
            /*        gtk_signal_connect(GTK_OBJECT(item_new),
                      "hide",
                      GTK_SIGNAL_FUNC(gtk_widget_destroy), NULL);*/
            gtk_menu_append(GTK_MENU(new_menu),item_new);
        }
        gtk_widget_show_all(new_menu);

        gtk_menu_popup(GTK_MENU(new_menu), NULL,NULL,NULL,0,0,0);
}

void
on_options_ok_button_clicked           (GtkButton       *button,
                                    gpointer         user_data)
{
    on_options_apply_button_clicked(NULL,NULL);
    save_configuration();
    licq_daemon->SaveConf();
    gtk_widget_destroy(options_window);
}


void
on_options_apply_button_clicked        (GtkButton       *button,
                                    gpointer         user_data)
{
    int reload_pixmaps = 0;

    /*  LICQ_SECURITY_PAGE */
    GtkWidget       *options_ignorenewusers_checkbutton=lookup_widget(
            options_window,"options_ignorenewusers_checkbutton");
    GtkWidget       *options_ignoremassmessages_checkbutton=lookup_widget(
            options_window,"options_ignoremassmessages_checkbutton");
    GtkWidget       *options_ignorewebpanel_checkbutton=lookup_widget(
            options_window,"options_ignorewebpanel_checkbutton");
    GtkWidget       *options_ignoreemailpager_checkbutton=lookup_widget(
            options_window,"options_ignoreemailpager_checkbutton");
    GtkWidget       *options_authorization_required_checkbutton=lookup_widget(
            options_window,"options_authorization_required_checkbutton");
    GtkWidget       *options_webpresence_checkbutton=lookup_widget(
            options_window,"options_webpresence_checkbutton");
    GtkWidget       *options_hide_ip_checkbutton=lookup_widget(
            options_window,"options_hide_ip_checkbutton");
    GtkWidget       *options_autsecure_checkbutton=lookup_widget(
            options_window,"options_autsecure_checkbutton");
    /*  Connection tab */ 
    GtkWidget       *options_directconn_checkbutton=lookup_widget(
            options_window,"options_directconn_checkbutton");
    GtkWidget       *options_portfrom_spinbutton=lookup_widget(
            options_window,"options_portfrom_spinbutton");
    GtkWidget       *options_portto_spinbutton=lookup_widget(
            options_window,"options_portto_spinbutton");
    GtkWidget       *options_serverport_spinbutton=lookup_widget(
            options_window,"options_serverport_spinbutton");
    int             i, selection=0;
    /*  LAYOUT_MAINWINDOW_PAGE */
#ifdef USE_PANEL
    GtkWidget       *options_gnome_panel_checkbutton=lookup_widget(
            options_window,"options_gnome_panel_checkbutton");
    GtkWidget       *options_starthidden_checkbutton=lookup_widget(
            options_window,"options_starthidden_checkbutton");
#endif
    GtkWidget       *options_wm_checkbutton=lookup_widget(
            options_window,"options_wm_checkbutton");
    GtkWidget       *use_gnome_url_radio=lookup_widget(
            options_window,"use_gnome_url_radio");
    GtkWidget       *use_own_url_radio=lookup_widget(
            options_window,"use_own_url_radio");
    GtkWidget       *options_url_viewer_entry=lookup_widget(
            options_window,"options_url_viewer_entry");
    GtkWidget       *options_terminal_entry=lookup_widget(
            options_window,"options_terminal_entry");
    GtkWidget       *options_blink_checkbutton=lookup_widget(
            options_window,"options_blink_checkbutton");
    GtkWidget       *options_statustimer_checkbutton=lookup_widget(
            options_window,"options_statustimer_checkbutton");
    /*  OnEvent tab */
    COnEventManager *opt;
    gchar           *oemparams[MAX_ON_EVENT],*command;
    GtkWidget       *options_onevent_checkbutton=lookup_widget(
            options_window,"options_onevent_checkbutton");
    GtkWidget       *options_beep_checkbutton=lookup_widget(
            options_window,"options_beep_checkbutton");
    GtkWidget       *options_onevent_command_entry=lookup_widget(
            options_window,"options_onevent_command_entry");
    GtkWidget       *options_onevent_message_entry=lookup_widget(
            options_window,"options_onevent_message_entry");
    GtkWidget       *options_onevent_url_entry=lookup_widget(
            options_window,"options_onevent_url_entry");
    GtkWidget       *options_onevent_chat_entry=lookup_widget(
            options_window,"options_onevent_chat_entry");
    GtkWidget       *options_onevent_file_entry=lookup_widget(
            options_window,"options_onevent_file_entry");
    GtkWidget       *options_onevent_notify_entry=lookup_widget(
            options_window,"options_onevent_notify_entry");
    GtkWidget       *options_onevent_system_entry=lookup_widget(
            options_window,"options_onevent_system_entry");
    GtkWidget       *options_onevent_away_checkbutton=lookup_widget(
            options_window,"options_onevent_away_checkbutton");
    GtkWidget       *options_onevent_na_checkbutton=lookup_widget(
            options_window,"options_onevent_na_checkbutton");
    GtkWidget       *options_onevent_occupied_checkbutton=lookup_widget(
            options_window,"options_onevent_occupied_checkbutton");
    GtkWidget       *options_onevent_dnd_checkbutton=lookup_widget(
            options_window,"options_onevent_dnd_checkbutton");
    GtkWidget       *options_online_onlogin_checkbutton=lookup_widget(
            options_window,"options_online_onlogin_checkbutton");
    /*  LAYOUT_FONTSANDICONS_PAGE */
    GtkWidget       *options_iconset_optionmenu=lookup_widget(
            options_window,"options_iconset_optionmenu");
    GtkWidget       *options_contactlistfont_entry=lookup_widget(
            options_window,"options_contactlistfont_entry");
    GtkWidget       *options_editforfont_entry=lookup_widget(
            options_window,"options_editforfont_entry");
    GtkWidget       *options_user_icondir_entry=lookup_widget(
            options_window,"options_user_icondir_entry");

    GtkWidget       *options_networklines_spinbutton=lookup_widget(
            options_window,"options_networklines_spinbutton");
    /*  Status tab */
    GtkWidget       *options_autologon_optionmenu=lookup_widget(
            options_window,"options_autologon_optionmenu");
    GtkWidget       *option_invisible_checkbutton=lookup_widget(
            options_window,"option_invisible_checkbutton");
    GtkWidget       *options_autoaway_spinbutton=lookup_widget(
            options_window,"options_autoaway_spinbutton");
    GtkWidget       *options_autona_spinbutton=lookup_widget(
            options_window,"options_autona_spinbutton");
    GtkWidget       *options_autooffline_spinbutton=lookup_widget(
            options_window,"options_autooffline_spinbutton");
    GtkWidget       *option_autoback_checkbutton=lookup_widget(
            options_window,"option_autoback_checkbutton");
    /*  Contactlist tab */
    GtkWidget       *options_showcoltitles_checkbutton=lookup_widget(
            options_window,"options_showcoltitles_checkbutton");
    GtkWidget       *options_sortlist1_optionmenu=lookup_widget(
            options_window,"options_sortlist1_optionmenu");
    GtkWidget       *options_sortlist2_optionmenu=lookup_widget(
            options_window,"options_sortlist2_optionmenu");
    GtkWidget       *options_sortlist3_optionmenu=lookup_widget(
            options_window,"options_sortlist3_optionmenu");
    GtkWidget       *options_showgroupmenu_checkbutton=lookup_widget(
            options_window,"options_showgroupmenu_checkbutton");
    GtkWidget       *options_singleclick_checkbutton=lookup_widget(
            options_window,"options_singleclick_checkbutton");
    GtkWidget       *options_selactiveuser_checkbutton=lookup_widget(
            options_window,"options_selactiveuser_checkbutton");
    /*  Messages tab */
    GtkWidget       *option_file_default_dir_entry = lookup_widget(
            options_window,"option_file_default_dir_entry");
    GtkWidget       *qsearch_spinbutton = lookup_widget(
            options_window,"qsearch_spinbutton");
    GtkWidget       *option_file_autoclose_checkbutton = lookup_widget(
            options_window,"option_file_autoclose_checkbutton");
    GtkWidget       *options_translation_combo_entry=lookup_widget(
            options_window,"options_translation_combo_entry");
    /*  EVENT_SENDING_PAGE */
    GtkWidget       *options_auto_send_thru_server_checkbutton=lookup_widget(
            options_window,"options_auto_send_thru_server_checkbutton");
    GtkWidget       *options_autopopup_checkbutton=lookup_widget(
            options_window,"options_autopopup_checkbutton");
    GtkWidget       *options_autopopwhenonline_checkbutton=lookup_widget(
            options_window,"options_autopopwhenonline_checkbutton");
    GtkWidget       *options_autoraise_checkbutton=lookup_widget(
            options_window,"options_autoraise_checkbutton");
    GtkWidget       *options_quotewidth_spinbutton=lookup_widget(
            options_window,"options_quotewidth_spinbutton");
    GtkWidget       *spell1_radio =lookup_widget(
            options_window,"spell1_radio");
    GtkWidget       *spell2_radio =lookup_widget(
            options_window,"spell2_radio");
    GtkWidget       *spell3_radio =lookup_widget(
            options_window,"spell3_radio");
    GtkWidget       *spell4_radio =lookup_widget(
            options_window,"spell4_radio");
    GtkWidget       *spell_default_entry =lookup_widget(
            options_window,"spell_default_entry");
    GtkWidget       *spell_errorfont_entry =lookup_widget(
            options_window,"spell_errorfont_entry");
    GtkWidget       *options_ignorecolors_checkbutton=lookup_widget(
            options_window,"options_ignorecolors_checkbutton");

    /*  Misc */
    gchar           *temp,tname[PATH_MAX];
    ICQOwner        *owner;
    gboolean        newwidth=FALSE,authreq,webpres,hideip;
    gint            mainwidth,mainheight,clistwidth,clistheight;

    for(i = 0; i < MAX_ON_EVENT; i++) {
        oemparams[i] = NULL;
    }

    licq_daemon->SetTCPEnabled(
            gtk_toggle_button_get_active(
                GTK_TOGGLE_BUTTON(options_directconn_checkbutton)));
    if(gtk_spin_button_get_value_as_int(
                GTK_SPIN_BUTTON(options_portto_spinbutton))>=
            gtk_spin_button_get_value_as_int(                        
                GTK_SPIN_BUTTON(options_portfrom_spinbutton))) {
        licq_daemon->SetTCPPorts(
                gtk_spin_button_get_value_as_int(
                    GTK_SPIN_BUTTON(options_portfrom_spinbutton)),
                gtk_spin_button_get_value_as_int(
                    GTK_SPIN_BUTTON(options_portto_spinbutton)));
    }
    licq_daemon->setDefaultRemotePort(
            gtk_spin_button_get_value_as_int(
                GTK_SPIN_BUTTON(options_serverport_spinbutton)));

    /*  LICQ_SECURITY_PAGE */
    licq_daemon->SetIgnore(IGNORE_NEWUSERS,gtk_toggle_button_get_active(
                GTK_TOGGLE_BUTTON(options_ignorenewusers_checkbutton)));
    licq_daemon->SetIgnore(IGNORE_MASSMSG,gtk_toggle_button_get_active(
                GTK_TOGGLE_BUTTON(options_ignoremassmessages_checkbutton)));
    licq_daemon->SetIgnore(IGNORE_WEBPANEL,gtk_toggle_button_get_active(
                GTK_TOGGLE_BUTTON(options_ignorewebpanel_checkbutton)));
    licq_daemon->SetIgnore(IGNORE_EMAILPAGER,gtk_toggle_button_get_active(
                GTK_TOGGLE_BUTTON(options_ignoreemailpager_checkbutton)));
    authreq=gtk_toggle_button_get_active(
            GTK_TOGGLE_BUTTON(options_authorization_required_checkbutton));
    webpres=gtk_toggle_button_get_active(
            GTK_TOGGLE_BUTTON(options_webpresence_checkbutton));
    hideip=gtk_toggle_button_get_active(
            GTK_TOGGLE_BUTTON(options_hide_ip_checkbutton));
    owner=gUserManager.FetchOwner(LOCK_R);
    if(authreq!=owner->GetAuthorization()||
            webpres!=owner->WebAware()||
            hideip!=owner->HideIp()) {
        gUserManager.DropUser(owner);
        licq_daemon->icqSetSecurityInfo(authreq,hideip,webpres);
    }else {
        gUserManager.DropUser(owner);
    }

    configuration.auto_autosecure=gtk_toggle_button_get_active(
            GTK_TOGGLE_BUTTON(options_autsecure_checkbutton));

    /*  LAYOUT_MAINWINDOW_PAGE */
#ifdef USE_PANEL
    configuration.launchpanel=gtk_toggle_button_get_active(
            GTK_TOGGLE_BUTTON(options_gnome_panel_checkbutton));
    configuration.starthidden=gtk_toggle_button_get_active(
            GTK_TOGGLE_BUTTON(options_starthidden_checkbutton));
#endif
    configuration.wm_placement = gtk_toggle_button_get_active(
            GTK_TOGGLE_BUTTON(options_wm_checkbutton));
#ifdef USE_GNOME
    configuration.use_gnomeurlviewer = gtk_toggle_button_get_active(
            GTK_TOGGLE_BUTTON(use_gnome_url_radio));
    gbug("Set use gnome: %s\n",configuration.use_gnomeurlviewer?"TRUE":"FALSE");
#endif
    temp=gtk_editable_get_chars(GTK_EDITABLE(options_url_viewer_entry),0,-1);
    licq_daemon->setUrlViewer(temp);
    g_free(temp);
    temp=gtk_editable_get_chars(GTK_EDITABLE(options_terminal_entry),0,-1);
    licq_daemon->SetTerminal(temp);
    g_free(temp);
    configuration.blinkicons=gtk_toggle_button_get_active(
            GTK_TOGGLE_BUTTON(options_blink_checkbutton));
    configuration.showstatustimer=gtk_toggle_button_get_active(
            GTK_TOGGLE_BUTTON(options_statustimer_checkbutton));

    /*  LAYOUT_FONTSANDICONS_PAGE */
    if(GTK_WIDGET_SENSITIVE(options_iconset_optionmenu)) {
        temp=(gchar*)gtk_object_get_data(GTK_OBJECT(
                    GTK_OPTION_MENU(options_iconset_optionmenu)->menu_item),
                "filename");
        reload_pixmaps=strcmp(configuration.iconset,temp);
        strcpy(configuration.iconset,temp);
    }
    temp=gtk_editable_get_chars(GTK_EDITABLE(options_user_icondir_entry),
            0,-1);
    strcpy(configuration.usericondir,temp);
    temp=gtk_editable_get_chars(GTK_EDITABLE(options_contactlistfont_entry),
            0,-1);
    strcpy(configuration.contactfont,temp);
    g_free(temp);
    temp=gtk_editable_get_chars(GTK_EDITABLE(options_editforfont_entry),0,-1);
    global_editor_font = gdk_font_load(temp);
    strcpy(configuration.editorfont,temp);

    g_free(temp);
    configuration.historylines=gtk_spin_button_get_value_as_int(
            GTK_SPIN_BUTTON(options_networklines_spinbutton));
    /* DO NOT TRANSLATE, internal data */ 
    color_select_display_row_get_data("online",&configuration.color_online);
    color_select_display_row_get_data("offline",&configuration.color_offline);
    color_select_display_row_get_data("other",&configuration.color_other);
    color_select_display_row_get_data("new",&configuration.color_new);
    color_select_display_row_get_data("sent",&configuration.color_sent);
    color_select_display_row_get_data("rcvd",&configuration.color_rcvd);

    /*  EVENT_SENDING_PAGE */
    configuration.autoraise = GTK_TOGGLE_BUTTON(
            options_autoraise_checkbutton)->active;
    configuration.autopopupmessages=GTK_TOGGLE_BUTTON(
            options_autopopup_checkbutton)->active;
    configuration.onlyautopopupwhenonline=GTK_TOGGLE_BUTTON(
            options_autopopwhenonline_checkbutton)->active;
    configuration.quotewidth=gtk_spin_button_get_value_as_int(
            GTK_SPIN_BUTTON(options_quotewidth_spinbutton));
    configuration.autosendthroughserver=GTK_TOGGLE_BUTTON(
            options_auto_send_thru_server_checkbutton)->active;
#ifdef USE_PSPELL
    temp=gtk_editable_get_chars(GTK_EDITABLE(spell_default_entry),0,-1);
    strcpy(configuration.defaut_dict,temp);
    g_free(temp);

    temp=gtk_editable_get_chars(GTK_EDITABLE(spell_errorfont_entry),0,-1);
    strcpy(configuration.spell_errorfont,temp);
    g_free(temp);
    load_spell_font();

    if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(spell1_radio))) {
        configuration.spelling_mode = USE_USER_LANG_AND_DEFAULT;
    } else if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(spell2_radio))) {
        configuration.spelling_mode = USE_USER_LANG_AND_NONE;
    } else if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(spell3_radio))) {
        configuration.spelling_mode = USE_DEFAULT_LANG;
    } else if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(spell4_radio))) {
        configuration.spelling_mode = DISABLE_SPELL;
    } else {
        configuration.spelling_mode = USE_USER_LANG_AND_DEFAULT;
    }
#endif
    configuration.ignoremsgcolors=gtk_toggle_button_get_active(
            GTK_TOGGLE_BUTTON(options_ignorecolors_checkbutton));
    /*  Contactlist tab */
    for(i=0;i<4;i++) {
        options_set_column_row_data(TRUE,i,&newwidth);
    } 
    configuration.showcoltitles=gtk_toggle_button_get_active(
            GTK_TOGGLE_BUTTON(options_showcoltitles_checkbutton));
    configuration.sortlist[0]=gtk_option_menu_get_history(
            GTK_OPTION_MENU(options_sortlist1_optionmenu));
    configuration.sortlist[1]=gtk_option_menu_get_history(
            GTK_OPTION_MENU(options_sortlist2_optionmenu));
    configuration.sortlist[2]=gtk_option_menu_get_history(
            GTK_OPTION_MENU(options_sortlist3_optionmenu));
    configuration.showgroupmenu=GTK_TOGGLE_BUTTON(
            options_showgroupmenu_checkbutton)->active;
    configuration.singleclick=GTK_TOGGLE_BUTTON(
            options_singleclick_checkbutton)->active;
    configuration.showactiveuser=gtk_toggle_button_get_active(
            GTK_TOGGLE_BUTTON(options_selactiveuser_checkbutton));
    configuration.quicksearchcol = (gushort) 
        gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(qsearch_spinbutton));

    /*  Status tab */
    configuration.autologon=gtk_option_menu_get_history(
            GTK_OPTION_MENU(options_autologon_optionmenu));
    configuration.invisible=gtk_toggle_button_get_active(
            GTK_TOGGLE_BUTTON(option_invisible_checkbutton));
    configuration.autoaway=gtk_spin_button_get_value_as_int(
            GTK_SPIN_BUTTON(options_autoaway_spinbutton));
    configuration.autona=gtk_spin_button_get_value_as_int(
            GTK_SPIN_BUTTON(options_autona_spinbutton));
    configuration.autooffline=gtk_spin_button_get_value_as_int(
            GTK_SPIN_BUTTON(options_autooffline_spinbutton));
    configuration.autoback=GTK_TOGGLE_BUTTON(
            option_autoback_checkbutton)->active;   

    /*  OnEvent Tab */
    opt=licq_daemon->OnEventManager();
    oemparams[0]=gtk_editable_get_chars(
            GTK_EDITABLE(options_onevent_message_entry),0,-1);
    oemparams[1]=gtk_editable_get_chars(
            GTK_EDITABLE(options_onevent_url_entry),0,-1);
    oemparams[2]=gtk_editable_get_chars(
            GTK_EDITABLE(options_onevent_chat_entry),0,-1);
    oemparams[3]=gtk_editable_get_chars(
            GTK_EDITABLE(options_onevent_file_entry),0,-1);
    oemparams[4]=gtk_editable_get_chars(
            GTK_EDITABLE(options_onevent_notify_entry),0,-1);
    oemparams[5]=gtk_editable_get_chars(
            GTK_EDITABLE(options_onevent_system_entry),0,-1);
    command=gtk_editable_get_chars(
            GTK_EDITABLE(options_onevent_command_entry),0,-1);
    opt->SetParameters((const char*)command,(const char**)oemparams);
    g_free(command);
    for(i=0;i < MAX_ON_EVENT;i++) {
        g_free(oemparams[i]);
    }
    if (GTK_TOGGLE_BUTTON(options_onevent_checkbutton)->active && 
            GTK_TOGGLE_BUTTON(options_beep_checkbutton)->active) {
        opt->SetCommandType(ON_EVENT_BY_PLUGIN);
    } else if (GTK_TOGGLE_BUTTON(options_onevent_checkbutton)->active &&
            !GTK_TOGGLE_BUTTON(options_beep_checkbutton)->active) {
        opt->SetCommandType(ON_EVENT_RUN);

    } else {
        opt->SetCommandType(ON_EVENT_IGNORE);
    }

    owner=gUserManager.FetchOwner(LOCK_W);
    owner->SetEnableSave(FALSE);
    owner->SetAcceptInAway( 
            GTK_TOGGLE_BUTTON(options_onevent_away_checkbutton)->active);
    owner->SetAcceptInNA(
            GTK_TOGGLE_BUTTON(options_onevent_na_checkbutton)->active);
    owner->SetAcceptInOccupied(
            GTK_TOGGLE_BUTTON(options_onevent_occupied_checkbutton)->active);
    owner->SetAcceptInDND(
            GTK_TOGGLE_BUTTON(options_onevent_dnd_checkbutton)->active);
    owner->SetEnableSave(TRUE);
    owner->SaveLicqInfo();
    gUserManager.DropOwner();
    licq_daemon->SetAlwaysOnlineNotify(gtk_toggle_button_get_active(
                GTK_TOGGLE_BUTTON(options_online_onlogin_checkbutton)));

    configuration.use_onevents=GTK_TOGGLE_BUTTON(options_onevent_checkbutton)->active;
    configuration.beep_onevent=GTK_TOGGLE_BUTTON(options_beep_checkbutton)->active;


    /*  Messages tab */
    temp=gtk_editable_get_chars(GTK_EDITABLE(option_file_default_dir_entry),
            0,-1);
    strncpy(configuration.file_dir,temp,MAX_CONFIG_STRLEN);
    g_free(temp);
    configuration.auto_close_file_win = gtk_toggle_button_get_active(
            GTK_TOGGLE_BUTTON(option_file_autoclose_checkbutton)); 
    temp=gtk_editable_get_chars(GTK_EDITABLE(options_translation_combo_entry),
            0,-1);
    if(temp&&strcmp(temp,"none")) {
        snprintf(tname,PATH_MAX,"%s%s/%s",SHARE_DIR,TRANSLATION_DIR,temp);
        gTranslator.setTranslationMap(tname);
    }else {
        gTranslator.setDefaultTranslationMap();
    }
    if(temp) {
        g_free(temp);
    }

    if(newwidth) {
        gdk_window_get_size(main_window->window,&mainwidth,&mainheight);
        gbug("org: %d\n",mainwidth);
        GtkWidget       *alias_clist=lookup_widget(main_window,"alias_clist");
        gdk_window_get_size(alias_clist->window,&clistwidth,&clistheight);
        gbug("clist: %d\n",clistwidth);
        mainwidth-=clistwidth;
        mainwidth+=FIRST_COLUMN_WIDTH;
        for(i=0;i<4;i++) {
            if(!i||configuration.columns[i].active) {
                mainwidth+=configuration.columns[i].width;
            }
        }
        gbug("new: %d\n",mainwidth);
        gdk_window_resize(main_window->window,mainwidth,mainheight);
    }
    apply_options(reload_pixmaps);
}


void
on_options_cancel_button_clicked       (GtkButton       *button,
                                        gpointer         user_data)
{
    gtk_widget_destroy(options_window);
}


void
on_options_socks5_button_clicked       (GtkButton       *button,
                                        gpointer         user_data)
{
    char    *socksenv, *message;

    if (licq_daemon->SocksEnabled())
    {
        socksenv=(char*)licq_daemon->SocksServer();
        if (!socksenv) {
            showokdialog(_("SOCK5"),
                    _("SOCKS5 support is built in but disabled.\n"
                    "To enable it, set the SOCKS5_SERVER\n"
                    "environment variable to <server>:<port>."));
        }else {
            message=g_strdup_printf(
                    _("SOCKS5 support is built in and enabled at\n"
                    "\"%s\""), socksenv);
            showokdialog(_("SOCKS5"),message);
            g_free(message);
        }
    }
    else
    {
        showokdialog(_("SOCKS5"),
                _("To enable socks proxy support, install NEC Socks or Dante\n"
                "then configure the Licq daemon with \"--enable-socks5\"."));
    }
}


void
on_options_directconn_checkbutton_toggled
                                        (GtkToggleButton *togglebutton,
                                        gpointer         user_data)
{
    GtkWidget   *options_portfrom_spinbutton=lookup_widget(options_window,
            "options_portfrom_spinbutton");
    GtkWidget   *options_portto_spinbutton=lookup_widget(options_window,
            "options_portto_spinbutton");

    gtk_widget_set_sensitive(options_portfrom_spinbutton,
            gtk_toggle_button_get_active(togglebutton));
    gtk_widget_set_sensitive(options_portto_spinbutton,
            gtk_toggle_button_get_active(togglebutton));
}


void
on_options_onevent_checkbutton_toggled (GtkToggleButton *togglebutton,
                                        gpointer         user_data)
{
}


void
on_options_server_clist_select_row     (GtkCList        *clist,
                                        gint             row,
                                        gint             column,
                                        GdkEvent        *event,
                                        gpointer         user_data)
{
    GtkWidget       *options_server_name_entry=lookup_widget(
            options_window,"options_server_name_entry");
    GtkWidget       *options_server_port_spinbutton=lookup_widget(
            options_window,"options_server_port_spinbutton");
    GtkWidget       *options_server_remove_button=lookup_widget(
            options_window,"options_server_remove_button");
    GtkWidget       *options_server_update_button=lookup_widget(
            options_window,"options_server_update_button");

    gchar           *text;
    gint            ndx;
    gboolean        active;

    ndx=GPOINTER_TO_INT(gtk_clist_get_row_data(clist,row));
    gtk_clist_get_text(clist,row,0,&text);
    if(text) {
        gtk_entry_set_text(GTK_ENTRY(options_server_name_entry),text);
    }
    gtk_clist_get_text(clist,row,1,&text);
    if(text) {
        gtk_spin_button_set_value(
                GTK_SPIN_BUTTON(options_server_port_spinbutton),
                atol(text));
    }
    active=!(licq_daemon->icqServers.currentServerNum==ndx);
    gtk_widget_set_sensitive(options_server_remove_button,active);
    gtk_widget_set_sensitive(options_server_update_button,active);
}


void
on_options_server_add_button_clicked   (GtkButton       *button,
                                        gpointer         user_data)
{
    GtkWidget       *options_server_name_entry=lookup_widget(
            options_window,"options_server_name_entry");
    GtkWidget       *options_server_port_spinbutton=lookup_widget(
            options_window,"options_server_port_spinbutton");
    gchar           *name;
    gint            port;
   
    name=gtk_editable_get_chars(GTK_EDITABLE(options_server_name_entry),0,-1);
    port=gtk_spin_button_get_value_as_int(
            GTK_SPIN_BUTTON(options_server_port_spinbutton)); 
    licq_daemon->icqServers.addServer(name,port); 
    g_free(name);
    refresh_server_list();    
}


void
on_options_server_remove_button_clicked
                                        (GtkButton       *button,
                                        gpointer         user_data)
{
    GtkWidget       *options_server_clist=lookup_widget(
            options_window,"options_server_clist");
    gint            row,ndx;

    if(!GTK_CLIST(options_server_clist)->selection) {
        return;
    }
    row=GPOINTER_TO_INT(GTK_CLIST(options_server_clist)->selection->data);
    ndx=GPOINTER_TO_INT(gtk_clist_get_row_data(
                GTK_CLIST(options_server_clist),row));
    if(licq_daemon->icqServers.currentServerNum>ndx) {
        licq_daemon->icqServers.currentServerNum--;
    }
    delete licq_daemon->icqServers.servers[ndx];
    licq_daemon->icqServers.servers.erase(
            licq_daemon->icqServers.servers.begin()+ndx);

    refresh_server_list();    
}


void
on_options_server_update_button_clicked
                                        (GtkButton       *button,
                                        gpointer         user_data)
{
    GtkWidget       *options_server_name_entry=lookup_widget(
            options_window,"options_server_name_entry");
    GtkWidget       *options_server_port_spinbutton=lookup_widget(
            options_window,"options_server_port_spinbutton");
    GtkWidget       *options_server_clist=lookup_widget(
            options_window,"options_server_clist");
    gchar           *location;
    gint            row,ndx;
    unsigned short  port;

    if(!GTK_CLIST(options_server_clist)->selection) {
        return;
    }
    row=GPOINTER_TO_INT(GTK_CLIST(options_server_clist)->selection->data);
    ndx=GPOINTER_TO_INT(gtk_clist_get_row_data(
                GTK_CLIST(options_server_clist),row));

    location=gtk_editable_get_chars(
            GTK_EDITABLE(options_server_name_entry),0,-1);
    port=gtk_spin_button_get_value_as_int(
            GTK_SPIN_BUTTON(options_server_port_spinbutton));
    delete licq_daemon->icqServers.servers[ndx];
    licq_daemon->icqServers.servers[ndx]=new RemoteServer(location,port);
    g_free(location);
    refresh_server_list();
}

void
options_set_columns_row_sensitive(int row, bool sensitive)
{
    GtkWidget       *options_col_checkbutton;
    GtkWidget       *options_col_title_entry;
    GtkWidget       *options_col_format_entry;
    GtkWidget       *options_col_width_spinbutton;
    GtkWidget       *options_col_align_optionmenu;
    GtkWidget       *options_col_macro_button;
    GtkWidget       *options_sortlist1_optionmenu=lookup_widget(
            options_window,"options_sortlist1_optionmenu");
    GtkWidget       *options_sortlist2_optionmenu=lookup_widget(
            options_window,"options_sortlist2_optionmenu");
    GtkWidget       *options_sortlist3_optionmenu=lookup_widget(
            options_window,"options_sortlist3_optionmenu");
    GList           *children;
    gint            i;
    gchar           name[40];
    
    sprintf(name,"options_col%d_checkbutton",row);
    options_col_checkbutton=lookup_widget(options_window,name);
    sprintf(name,"options_col%d_title_entry",row);
    options_col_title_entry=lookup_widget(options_window,name);
    sprintf(name,"options_col%d_format_entry",row);
    options_col_format_entry=lookup_widget(options_window,name);
    sprintf(name,"options_col%d_width_spinbutton",row);
    options_col_width_spinbutton=lookup_widget(options_window,name);
    sprintf(name,"options_col%d_align_optionmenu",row);
    options_col_align_optionmenu=lookup_widget(options_window,name);
    sprintf(name,"options_col%d_macro_button",row);
    options_col_macro_button=lookup_widget(options_window,name);

    gtk_widget_set_sensitive(options_col_checkbutton,sensitive);
    gtk_widget_set_sensitive(options_col_title_entry,sensitive);
    gtk_widget_set_sensitive(options_col_format_entry,sensitive);
    gtk_widget_set_sensitive(options_col_width_spinbutton,sensitive);
    gtk_widget_set_sensitive(options_col_align_optionmenu,sensitive);
    gtk_widget_set_sensitive(options_col_macro_button,sensitive);

    children=gtk_container_children(
            GTK_CONTAINER(gtk_option_menu_get_menu(
                    GTK_OPTION_MENU(options_sortlist1_optionmenu))));
    for(i=0;i<row+3;i++) {
        children=g_list_next(children);
    }
    gtk_widget_set_sensitive(GTK_WIDGET(children->data),sensitive);
    children=gtk_container_children(
            GTK_CONTAINER(gtk_option_menu_get_menu(
                    GTK_OPTION_MENU(options_sortlist2_optionmenu))));
    for(i=0;i<row+3;i++) {
        children=g_list_next(children);
    }
    gtk_widget_set_sensitive(GTK_WIDGET(children->data),sensitive);
    children=gtk_container_children(
            GTK_CONTAINER(gtk_option_menu_get_menu(
                    GTK_OPTION_MENU(options_sortlist3_optionmenu))));
    for(i=0;i<row+3;i++) {
        children=g_list_next(children);
    }
    gtk_widget_set_sensitive(GTK_WIDGET(children->data),sensitive);
}


void
on_options_columns_checkbutton_toggled (GtkToggleButton *togglebutton,
                                        gpointer         user_data)
{
    GtkWidget       *options_col1_checkbutton=lookup_widget(
            options_window,"options_col1_checkbutton");
    GtkWidget       *options_col2_checkbutton=lookup_widget(
            options_window,"options_col2_checkbutton");
    GtkWidget       *options_col3_checkbutton=lookup_widget(
            options_window,"options_col3_checkbutton");
    GtkWidget       *options_col2_title_entry=lookup_widget(
            options_window,"options_col2_title_entry");
    GtkWidget       *options_col3_title_entry=lookup_widget(
            options_window,"options_col3_title_entry");
    GtkWidget       *qsearch_spinbutton=lookup_widget(
            options_window,"qsearch_spinbutton");
    GtkObject   *adj;
    int val;

    options_set_columns_row_sensitive(1, gtk_toggle_button_get_active(
                GTK_TOGGLE_BUTTON(options_col1_checkbutton)));
    gtk_widget_set_sensitive(options_col1_checkbutton,TRUE);

    options_set_columns_row_sensitive(2, 
            gtk_toggle_button_get_active(
                GTK_TOGGLE_BUTTON(options_col2_checkbutton))&&
            gtk_toggle_button_get_active(
                GTK_TOGGLE_BUTTON(options_col1_checkbutton)));
    gtk_widget_set_sensitive(options_col2_checkbutton,
            gtk_toggle_button_get_active(
                GTK_TOGGLE_BUTTON(options_col1_checkbutton)));

    options_set_columns_row_sensitive(3, 
            gtk_toggle_button_get_active(
                GTK_TOGGLE_BUTTON(options_col3_checkbutton))&&
            gtk_toggle_button_get_active(
                GTK_TOGGLE_BUTTON(options_col2_checkbutton)));
    
    gtk_widget_set_sensitive(options_col3_checkbutton,
            gtk_toggle_button_get_active(
                GTK_TOGGLE_BUTTON(options_col2_checkbutton)));

    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(options_col3_checkbutton),
            GTK_WIDGET_SENSITIVE(options_col3_title_entry));
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(options_col2_checkbutton),
            GTK_WIDGET_SENSITIVE(options_col2_title_entry));
    
    
    /* Find out the numbers of cols */
       nuber_of_cols = 1; 
    if (GTK_WIDGET_SENSITIVE(options_col2_checkbutton)) {
       nuber_of_cols = 2; 
    }
    
    if (GTK_WIDGET_SENSITIVE(options_col2_title_entry)) {
       nuber_of_cols = 3; 
    }
    
    if (GTK_WIDGET_SENSITIVE(options_col3_title_entry)) {
       nuber_of_cols = 4; 
    }
    
    val = gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(qsearch_spinbutton));
    adj = gtk_adjustment_new ((val > nuber_of_cols)?nuber_of_cols:val, 
            1, nuber_of_cols, 1, 10, 10);
    gtk_spin_button_set_adjustment(GTK_SPIN_BUTTON(qsearch_spinbutton),
            GTK_ADJUSTMENT(adj));
    if (val > nuber_of_cols) {
         gtk_spin_button_set_value (GTK_SPIN_BUTTON(qsearch_spinbutton),nuber_of_cols);
    }
}

void
on_options_font_browse_ok_clicked  (GtkButton       *button,
                                    gpointer         user_data)
{
    GtkWidget       *entry; 

    entry=GTK_WIDGET(gtk_object_get_user_data(GTK_OBJECT(user_data)));
    gtk_entry_set_text(GTK_ENTRY(entry),
            gtk_font_selection_dialog_get_font_name(
                GTK_FONT_SELECTION_DIALOG(user_data)));
    if(GTK_WIDGET_VISIBLE(GTK_WIDGET(user_data))) {
        gtk_widget_hide(GTK_WIDGET(user_data));
    }
    gtk_widget_destroy(GTK_WIDGET(user_data));
}


void
on_options_font_browse_button_clicked  (GtkButton       *button,
                                        gpointer         user_data)
{
    GtkWidget       *fontdialog;
    gchar           *currentry;

    fontdialog=gtk_font_selection_dialog_new("Select font");
    currentry=gtk_editable_get_chars(
            GTK_EDITABLE(button),0,-1);

    gtk_font_selection_dialog_set_font_name(
            GTK_FONT_SELECTION_DIALOG(fontdialog),currentry);

    gtk_window_set_position(GTK_WINDOW(fontdialog),GTK_WIN_POS_MOUSE);

    gtk_signal_connect(GTK_OBJECT(
                GTK_FONT_SELECTION_DIALOG(fontdialog)->ok_button),
            "clicked", GTK_SIGNAL_FUNC(on_options_font_browse_ok_clicked),
            GTK_FONT_SELECTION_DIALOG(fontdialog));
    gtk_signal_connect_object(GTK_OBJECT(
                GTK_FONT_SELECTION_DIALOG(fontdialog)->cancel_button),
            "clicked", GTK_SIGNAL_FUNC(gtk_widget_destroy),
            GTK_OBJECT(fontdialog));

    gtk_object_set_user_data(GTK_OBJECT(fontdialog),(gpointer)button);

    gtk_widget_show(fontdialog);

    g_free(currentry);
}

void
on_options_sar_update_button_clicked   (GtkButton       *button,
                                        gpointer         user_data)
{
    GtkWidget       *options_sar_title_entry=lookup_widget(options_window,
        "options_sar_title_entry");
    GtkWidget       *options_sar_text=lookup_widget(options_window,
        "options_sar_text");
    GtkWidget       *options_sar_preset_optionmenu=lookup_widget(
            options_window,"options_sar_preset_optionmenu");
    GtkWidget       *options_sar_status_optionmenu=lookup_widget(
            options_window,"options_sar_status_optionmenu");
    SARList&        sarlist=gSARManager.Fetch(gtk_option_menu_get_history(
                GTK_OPTION_MENU(options_sar_status_optionmenu)));
    SARListIter     sariter;
    gchar           *name,*contents;
    gint            ndx;
    GtkWidget       *active;

    name=gtk_editable_get_chars(GTK_EDITABLE(options_sar_title_entry),0,-1);
    contents=gtk_editable_get_chars(GTK_EDITABLE(options_sar_text),0,-1);
    gbug("on_options_sar_update_button_clicked: %s, %s\n",name,contents);
    ndx=gtk_option_menu_get_history(
                        GTK_OPTION_MENU(options_sar_preset_optionmenu));
    delete sarlist[ndx];
    sarlist[ndx]=
        new CSavedAutoResponse(name,contents);

    gSARManager.Drop();
    gSARManager.Save();
    g_free(name);
    g_free(contents);
    
    active=gtk_menu_get_active(GTK_MENU(gtk_option_menu_get_menu(
                    GTK_OPTION_MENU(options_sar_status_optionmenu))));
    gtk_menu_item_activate(GTK_MENU_ITEM(active));
}


void
color_select_display_row_set_data(  gchar           *desc,
                                    colordef_t      *cols,
                                    int             ndx)
{
    static GdkColor     colors[6];
    GtkSpinButton       *r;
    GtkSpinButton       *g;
    GtkSpinButton       *b;
    GtkDrawingArea      *area;
    gchar               *widg;


    widg=g_strdup_printf("options_color_%s_r_spinbutton",desc);
    r=GTK_SPIN_BUTTON(lookup_widget(options_window,widg));
    g_free(widg);
    widg=g_strdup_printf("options_color_%s_g_spinbutton",desc);
    g=GTK_SPIN_BUTTON(lookup_widget(options_window,widg));
    g_free(widg);
    widg=g_strdup_printf("options_color_%s_b_spinbutton",desc);
    b=GTK_SPIN_BUTTON(lookup_widget(options_window,widg));
    g_free(widg);
    widg=g_strdup_printf("options_color_%s_drawingarea",desc);
    area=GTK_DRAWING_AREA(lookup_widget(options_window,widg));
    g_free(widg);

    gtk_spin_button_set_value(r,cols->r);
    gtk_spin_button_set_value(g,cols->g);
    gtk_spin_button_set_value(b,cols->b);

    colors[ndx].red=(gushort)(65525*cols->r);
    colors[ndx].green=(gushort)(65525*cols->g);
    colors[ndx].blue=(gushort)(65525*cols->b);
    colors[ndx].pixel=0;
    gtk_object_set_user_data(GTK_OBJECT(&area->widget),&colors[ndx]);
    gtk_widget_queue_draw(&area->widget);
}


void
color_select_apply_data(    GtkWidget   *widget,
                            GtkWidget   *selector)
{
    colorwidgetset_t    *data;
    double              colors[4];
    colordef_t          cols;

    if(!(data=(colorwidgetset_t*)
                gtk_object_get_user_data(GTK_OBJECT(selector)))) {
        gtk_widget_destroy(GTK_WIDGET(selector));
    }
    gtk_color_selection_get_color(
            GTK_COLOR_SELECTION(GTK_COLOR_SELECTION_DIALOG(selector)->colorsel),
            colors);
    cols.r=colors[0];
    cols.g=colors[1];
    cols.b=colors[2];
    color_select_display_row_set_data(
            data->desc,
            &cols,data->ndx);
}

void
color_select_dialog_destroy_custom_data(    GtkWidget  *widget)
{
    colorwidgetset_t    *data;

    if((data=(colorwidgetset_t*)gtk_object_get_user_data(GTK_OBJECT(widget)))) {
        if(data->desc) {
            g_free(data->desc);
        }
        free(data);
    }
    gtk_widget_destroy(widget);
}

void
select_color(   gchar           *desc,
                int             ndx)
{
    GtkWidget           *selector;
    colorwidgetset_t    *set;
    colordef_t          cols;
    gdouble             setcols[4];

    if(!(set=(colorwidgetset_t*)malloc(sizeof(colorwidgetset_t)))) {
        return ;
    }

    color_select_display_row_get_data(desc,&cols);
    setcols[0]=cols.r;
    setcols[1]=cols.g;
    setcols[2]=cols.b;
    set->desc=g_strdup(desc);
    set->ndx=ndx;

    selector=gtk_color_selection_dialog_new(_("Select color"));
    gtk_object_set_user_data(GTK_OBJECT(selector),set);
    gtk_color_selection_set_opacity(GTK_COLOR_SELECTION(
                GTK_COLOR_SELECTION_DIALOG(selector)->colorsel),
            FALSE);
    gtk_color_selection_set_color(GTK_COLOR_SELECTION(
                GTK_COLOR_SELECTION_DIALOG(selector)->colorsel),
            setcols);

    gtk_signal_connect(GTK_OBJECT(
                GTK_COLOR_SELECTION_DIALOG(selector)->ok_button),
            "clicked", GTK_SIGNAL_FUNC(color_select_apply_data), 
            (gpointer)selector);

    gtk_signal_connect_object(GTK_OBJECT(
                GTK_COLOR_SELECTION_DIALOG(selector)->ok_button),
            "clicked", 
            GTK_SIGNAL_FUNC (color_select_dialog_destroy_custom_data),
            GTK_OBJECT(selector));

    gtk_signal_connect_object(GTK_OBJECT(
                GTK_COLOR_SELECTION_DIALOG(selector)->cancel_button),
            "clicked", 
            GTK_SIGNAL_FUNC (color_select_dialog_destroy_custom_data),
            GTK_OBJECT(selector));

    gtk_widget_show (selector);
}

void
color_select_display_row_get_data(  gchar           *desc,
                                    colordef_t      *cols)
{
    GtkSpinButton       *r;
    GtkSpinButton       *g;
    GtkSpinButton       *b;
    gchar               *widg;


    widg=g_strdup_printf("options_color_%s_r_spinbutton",desc);
    r=GTK_SPIN_BUTTON(lookup_widget(options_window,widg));
    g_free(widg);
    widg=g_strdup_printf("options_color_%s_g_spinbutton",desc);
    g=GTK_SPIN_BUTTON(lookup_widget(options_window,widg));
    g_free(widg);
    widg=g_strdup_printf("options_color_%s_b_spinbutton",desc);
    b=GTK_SPIN_BUTTON(lookup_widget(options_window,widg));
    g_free(widg);

    cols->r=gtk_spin_button_get_value_as_float(r);
    cols->g=gtk_spin_button_get_value_as_float(g);
    cols->b=gtk_spin_button_get_value_as_float(b);
}
void
on_options_color_online_browse_button_clicked
                                        (GtkButton       *button,
                                        gpointer         user_data)
{
    select_color("online",0);
}


void
on_options_color_offline_browse_button_clicked
                                        (GtkButton       *button,
                                        gpointer         user_data)
{
    select_color("offline",1);
}


void
on_options_color_other_browse_button_clicked
                                        (GtkButton       *button,
                                        gpointer         user_data)
{
    select_color("other",2);
}


void
on_options_color_new_browse_button_clicked
                                        (GtkButton       *button,
                                        gpointer         user_data)
{
    select_color("new",3);
}


void
on_options_color_sent_browse_button_clicked
                                        (GtkButton       *button,
                                        gpointer         user_data)
{
    select_color("sent",4);
}


void
on_options_color_rcvd_browse_button_clicked
                                        (GtkButton       *button,
                                        gpointer         user_data)
{
    select_color("rcvd",5);
}

gboolean
on_options_color_drawingarea_expose_event
                                        (GtkWidget       *widget,
                                        GdkEventExpose  *event,
                                        gpointer         user_data)
{
    GdkGC       *newgc;
    GdkColor    *color;
    if(!(color=(GdkColor*)gtk_object_get_user_data(GTK_OBJECT(widget)))) {
        return FALSE;
    }
    newgc=gdk_gc_new(widget->window);
    gdk_gc_ref(newgc);
    gdk_gc_copy(newgc,widget->style->fg_gc[GTK_STATE_NORMAL]);
    gdk_color_alloc(gtk_widget_get_colormap(widget),color);
    gdk_gc_set_foreground(newgc,color);

    gdk_draw_rectangle(widget->window,
            newgc,
            TRUE,
            0, 0, widget->allocation.width, 
            widget->allocation.height);
    gdk_gc_unref(newgc);
    return FALSE;
}

gboolean
on_options_window_delete_event         (GtkWidget       *widget,
                                        GdkEvent        *event,
                                        gpointer         user_data)
{
    gtk_widget_destroy(options_window);
    return FALSE;
}


void
on_options_sortlist_optionmenu_clicked (GtkMenuItem       *item,
                                        gpointer         user_data)
{
    GtkWidget       *options_sortlist1_optionmenu=lookup_widget(
            options_window,"options_sortlist1_optionmenu");
    GtkWidget       *options_sortlist2_optionmenu=lookup_widget(
            options_window,"options_sortlist2_optionmenu");
    GtkWidget       *options_sortlist2_label=lookup_widget(
            options_window,"options_sortlist2_label");
    gint            index;

    index=gtk_option_menu_get_history(
            GTK_OPTION_MENU(options_sortlist1_optionmenu));

    gtk_widget_set_sensitive(options_sortlist2_label,index?TRUE:FALSE);
    gtk_widget_set_sensitive(options_sortlist2_optionmenu,index?TRUE:FALSE);
    on_options_sortlist2_optionmenu_clicked(NULL,NULL);
}


void
on_options_sortlist2_optionmenu_clicked
                                        (GtkButton       *button,
                                        gpointer         user_data)
{
    GtkWidget       *options_sortlist2_optionmenu=lookup_widget(
            options_window,"options_sortlist2_optionmenu");
    GtkWidget       *options_sortlist3_optionmenu=lookup_widget(
            options_window,"options_sortlist3_optionmenu");
    GtkWidget       *options_sortlist3_label=lookup_widget(
            options_window,"options_sortlist3_label");
    gint            index;

    index=gtk_option_menu_get_history(
            GTK_OPTION_MENU(options_sortlist2_optionmenu));

    gtk_widget_set_sensitive(options_sortlist3_label,
            index&&GTK_WIDGET_SENSITIVE(options_sortlist2_optionmenu)?TRUE:FALSE);
    gtk_widget_set_sensitive(options_sortlist3_optionmenu,
            index&&GTK_WIDGET_SENSITIVE(options_sortlist2_optionmenu)?TRUE:FALSE);
}

void
on_options_port_spinbutton_changed     (GtkEditable     *editable,
                                        gpointer         user_data)
{
    GtkWidget   *options_portfrom_spinbutton = lookup_widget(
            options_window,"options_portfrom_spinbutton");
    GtkWidget   *options_portto_spinbutton = lookup_widget(
            options_window,"options_portto_spinbutton");

    if(gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(
                    options_portfrom_spinbutton))>
            gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(
                    options_portto_spinbutton))) {
        if(GTK_WIDGET(editable)==options_portfrom_spinbutton) {
            gtk_spin_button_set_value(GTK_SPIN_BUTTON(options_portto_spinbutton),
                    gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(
                            options_portfrom_spinbutton)));
        }else {
            gtk_spin_button_set_value(GTK_SPIN_BUTTON(
                        options_portfrom_spinbutton),
                    gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(
                            options_portto_spinbutton)));
        }
    }
}

void
on_options_gnome_panel_checkbutton_toggled
                                        (GtkToggleButton *togglebutton,
                                        gpointer         user_data)
{
    GtkWidget   *options_starthidden_checkbutton=lookup_widget(
            options_window,"options_starthidden_checkbutton");

    gtk_widget_set_sensitive(options_starthidden_checkbutton,
            gtk_toggle_button_get_active(togglebutton));
}


void
on_options_autopopup_checkbutton_toggled
                                        (GtkToggleButton *togglebutton,
                                        gpointer         user_data)
{
    GtkWidget       *options_autopopwhenonline_checkbutton=lookup_widget(
            options_window,"options_autopopwhenonline_checkbutton");

    gtk_widget_set_sensitive(options_autopopwhenonline_checkbutton,
            gtk_toggle_button_get_active(togglebutton));
}

void
on_options_page_ctree_tree_select_row  (GtkCTree        *ctree,
                                        GList           *node,
                                        gint             column,
                                        gpointer         user_data)
{
    GtkWidget       *notebook_optionpages=lookup_widget(options_window,
            "notebook_optionpages");
    gint    row;

    row=GPOINTER_TO_INT(gtk_ctree_node_get_row_data(ctree,GTK_CTREE_NODE(node)));
    gtk_notebook_set_page(GTK_NOTEBOOK(notebook_optionpages),row);
}

void
on_options_user_icondir_refresh_button_clicked
                                        (GtkButton       *button,
                                        gpointer         user_data)
{
    refresh_iconlist();
}

