#include "gtk-gui.h"

#include <sys/time.h>
#include <stdio.h>

#include "interface.h"
#include "contactlist.h"
#include "functions.h"

    /*  Globals */
GtkWidget       *passwd_dialog;

bool
password_event_callback(ICQEvent *event,gpointer data)
{
    unsigned long   *tag=(unsigned long *)data;
    GtkWidget       *passwd_update_button;
    gchar           *message;

    if(event->Equals(*tag)) {
        passwd_update_button = lookup_widget(passwd_dialog, 
                "passwd_update_button");
        switch(event->Result()) {
            case EVENT_SUCCESS:
                if(GTK_WIDGET_VISIBLE(passwd_dialog)) {
                    gtk_widget_hide(passwd_dialog);
                }
                gtk_widget_destroy(passwd_dialog);
                break;
            case EVENT_ACKED:
            case EVENT_FAILED:
            case EVENT_TIMEDOUT:
            case EVENT_ERROR:
            case EVENT_CANCELLED:
                message=g_strdup_printf(_("Password request failed '%s'"),
                        geticqeventerrorstring(event->Result()));
                showokdialog("Failure",message);
                break;
            default:
                break;
            
        }
        if(event->Result()!=EVENT_SUCCESS) {
            gtk_widget_set_sensitive(passwd_update_button,TRUE);
        }
        return TRUE;
    }
    return FALSE;
}

void
on_passwd_update_button_clicked        (GtkButton       *button,
                                        gpointer         user_data)
{
    GtkWidget       *passwd_entry = lookup_widget(GTK_WIDGET(button),
            "passwd_entry");
    GtkWidget       *verify_entry = lookup_widget(GTK_WIDGET(button),
            "verify_entry");
    unsigned long   *tag;
    char            *verify;
    char            *passwd;

    verify = gtk_entry_get_text(GTK_ENTRY(verify_entry));
    passwd = gtk_entry_get_text(GTK_ENTRY(passwd_entry));
    if(strlen(passwd)<8) {
        showokdialog(_("Bad password"), 
                _("The password must be at least 8 chars"));
        return;
    }
    if (!strcmp(verify,passwd)){
        tag=(unsigned long*)malloc(sizeof(unsigned long));
        *tag=licq_daemon->icqSetPassword(passwd);
        gtk_widget_set_sensitive(GTK_WIDGET(button),FALSE);
        register_eventcallback(password_event_callback, (gpointer)tag);
    }else {
        showokdialog(_("Bad password"), _("The passwords don't match"));
    }
}

void
passwd_on_passwd_dialog_destroy_event  (GtkObject       *widget,
                                        gpointer         user_data)
{
    passwd_dialog=NULL;
}

gboolean
on_passwd_dialog_delete_event          (GtkWidget       *widget,
                                        GdkEvent        *event,
                                        gpointer         user_data)
{
    gtk_widget_destroy(widget);
    return FALSE;
}



