#include "gtk-gui.h"

#include <sys/time.h>
#include <stdio.h>
#include <sys/types.h>
#include <dirent.h>
#include <dlfcn.h>
#include <unistd.h>

#include "interface.h"
#include "contactlist.h"

    /*  Globals */
GtkWidget   *plugin_dialog = NULL;

void
refresh_plugindialog()
{
    GtkWidget       *plugin_loaded_clist=lookup_widget(plugin_dialog,
            "plugin_loaded_clist");
    GtkWidget       *plugin_available_clist=lookup_widget(plugin_dialog,
            "plugin_available_clist");
    PluginsList     l;
    PluginsListIter it;
    gchar           *addrow[6];
    struct dirent   *dirbuffer, *dirbuffer_result;
    DIR             *dirhandle;
    gchar           *ldir;
    int             i;
    void            *symhandle;
    char            *(*lpname)(), *(*lpdescription)();
   
    licq_daemon->PluginList(l);
    gtk_clist_freeze(GTK_CLIST(plugin_loaded_clist));
    gtk_clist_clear(GTK_CLIST(plugin_loaded_clist));
    addrow[5]=NULL;
    for (it=l.begin();it!=l.end();it++) {
        addrow[0]=g_strdup_printf("%d",(*it)->Id());
        addrow[1]=(gchar*)(*it)->Name();
        addrow[2]=(gchar*)(*it)->Version();
        addrow[3]=(gchar*)(*it)->Status();
        addrow[4]=(gchar*)(*it)->Description();
        if(addrow[0]&&addrow[1]&&addrow[2]&&addrow[3]&&addrow[4]) {
            gtk_clist_append(GTK_CLIST(plugin_loaded_clist),addrow);
        }
        if(addrow[0]) {
            g_free(addrow[0]);
        }
    } 
    gtk_clist_thaw(GTK_CLIST(plugin_loaded_clist));
    gtk_clist_freeze(GTK_CLIST(plugin_available_clist));
    gtk_clist_clear(GTK_CLIST(plugin_available_clist));

    if((dirhandle=opendir(LIB_DIR))&&(dirbuffer=(struct dirent*)malloc(
                    sizeof(struct dirent)+pathconf(LIB_DIR,_PC_NAME_MAX)+1))) {
        while(!(i=readdir_r(dirhandle,dirbuffer,&dirbuffer_result))&&
                dirbuffer_result) {
            if(strstr(dirbuffer->d_name,"licq_")==dirbuffer->d_name&&
                    strstr(dirbuffer->d_name+strlen(dirbuffer->d_name)-3,".so")) {
                addrow[0]=dirbuffer->d_name;
                addrow[3]=NULL;

                ldir=g_strdup_printf("%s/%s",LIB_DIR,dirbuffer->d_name);
                if((symhandle=dlopen(ldir,RTLD_NOW))) {
                    (void*)lpname=dlsym(symhandle,"LP_Name");
                    (void*)lpdescription=dlsym(symhandle,"LP_Description");
                    addrow[1]=strdup(lpname?lpname():"");
                    addrow[2]=strdup(lpdescription?lpdescription():"");
                    dlclose(symhandle);
                }else {

                    addrow[1]=strdup("n/a");
                    addrow[2]=strdup("n/a");
                }
                gtk_clist_append(GTK_CLIST(plugin_available_clist),addrow);
                free(addrow[1]);
                free(addrow[2]); 
            }
        }
        closedir(dirhandle);
        free(dirbuffer);
    } 
    gtk_clist_thaw(GTK_CLIST(plugin_available_clist));
}

void
on_plugin_refresh_button_clicked       (GtkButton       *button,
                                        gpointer         user_data)
{
    refresh_plugindialog();
}


void
on_plugin_load_button_clicked          (GtkButton       *button,
                                        gpointer         user_data)
{
    GtkWidget       *plugin_available_clist=lookup_widget(plugin_dialog,
            "plugin_available_clist");
    char            *sz[] = { "licq", NULL };
    gchar           *filename, *fullname;

    if(!GTK_CLIST(plugin_available_clist)->selection) {
        return;
    }
    gtk_clist_get_text(GTK_CLIST(plugin_available_clist), 
            GPOINTER_TO_INT(GTK_CLIST(plugin_available_clist)->selection->data),
            0,&filename);
    fullname=g_strdup_printf("%s/%s",LIB_DIR,filename);
    if(!licq_daemon->PluginLoad(fullname,1,sz)) {
        showokdialog(_("Plug failure"), _("Failed to load the plugin"));
    }
    g_free(fullname);
    refresh_plugindialog();
}


void
on_plugin_enable_button_clicked        (GtkButton       *button,
                                        gpointer         user_data)
{
    gchar           *str_id;
    GtkWidget       *plugin_loaded_clist=lookup_widget(plugin_dialog,
            "plugin_loaded_clist");
    int             id;

    if(!GTK_CLIST(plugin_loaded_clist)->selection) {
        return;
    }
    gtk_clist_get_text(GTK_CLIST(plugin_loaded_clist), 
                GPOINTER_TO_INT(GTK_CLIST(
                        plugin_loaded_clist)->selection->data), 0,&str_id);
    sscanf(str_id,"%d",&id);
    licq_daemon->PluginEnable(id);
    refresh_plugindialog();
}


void
on_plugin_disable_button_clicked       (GtkButton       *button,
                                        gpointer         user_data)
{
    gchar           *str_id;
    GtkWidget       *plugin_loaded_clist=lookup_widget(plugin_dialog,
            "plugin_loaded_clist");
    int             id;

    if(!GTK_CLIST(plugin_loaded_clist)->selection) {
        return;
    }
    gtk_clist_get_text(GTK_CLIST(plugin_loaded_clist), 
                GPOINTER_TO_INT(GTK_CLIST(
                        plugin_loaded_clist)->selection->data), 0,&str_id);
    sscanf(str_id,"%d",&id);
    licq_daemon->PluginDisable(id);
    refresh_plugindialog();
}


void
on_plugin_unload_button_clicked        (GtkButton       *button,
                                        gpointer         user_data)
{
    gchar           *str_id;
    GtkWidget       *plugin_loaded_clist=lookup_widget(plugin_dialog,
            "plugin_loaded_clist");
    int             id;

    if(!GTK_CLIST(plugin_loaded_clist)->selection) {
        return;
    }
    gtk_clist_get_text(GTK_CLIST(plugin_loaded_clist), 
                GPOINTER_TO_INT(GTK_CLIST(
                        plugin_loaded_clist)->selection->data), 0,&str_id);
    sscanf(str_id,"%d",&id);
    licq_daemon->PluginShutdown(id);
    refresh_plugindialog();
}


void
on_plugin_details_button_clicked       (GtkButton       *button,
                                        gpointer         user_data)
{
    gchar           *message;
    GtkWidget       *plugin_loaded_clist=lookup_widget(plugin_dialog,
            "plugin_loaded_clist");
    int             id;
    PluginsList     l;
    PluginsListIter it;

    if(!GTK_CLIST(plugin_loaded_clist)->selection) {
        return;
    }
    gtk_clist_get_text(GTK_CLIST(plugin_loaded_clist), 
                GPOINTER_TO_INT(GTK_CLIST(plugin_loaded_clist)->selection->data),
                0,&message);
    sscanf(message,"%d",&id);

    licq_daemon->PluginList(l);
    for (it=l.begin();it!=l.end();it++)
    {
        if ((*it)->Id()==id)
            break;
    }
    if(it==l.end()) {
        return;
    }
    
    message=g_strdup_printf(_("Licq plugin %s \n %s"),(*it)->Version(), 
            (*it)->Description());

    showokdialog(_("Plugin details"),message);
    g_free(message);
}

void
plugin_on_plugin_dialog_destroy_event  (GtkObject       *widget,
                                        gpointer         user_data)
{
    plugin_dialog=NULL;
}


void
plugin_on_plugin_dialog_show           (GtkWidget       *widget,
                                        gpointer         user_data)
{
    refresh_plugindialog();
}


gboolean
on_plugin_dialog_delete_event          (GtkWidget       *widget,
                                        GdkEvent        *event,
                                        gpointer         user_data)
{
    gtk_widget_destroy(widget);
    return FALSE;
}


