#include "gtk-gui.h"

#include <sys/time.h>
#include <stdio.h>

#include "interface.h"
#include "contactlist.h"
#include "functions.h"

    /*  Globals */
GtkWidget       *random_chat_dialog=NULL;
unsigned long   randchat_tag=0;

void
on_randomchat_dialog_destroy           (GtkObject       *object,
                                        gpointer         user_data)
{
    random_chat_dialog=NULL;
    if(randchat_tag) {
        randchat_tag=0; 
    }
}


bool
randomchat_search_event_handler(ICQEvent *e,gpointer data)
{
    GtkWidget       *randomchat_search_button;
    unsigned long   uin=0;

    if(!e->Equals(randchat_tag)) {
        return FALSE;
    }

    randomchat_search_button=lookup_widget(
            random_chat_dialog,"randomchat_search_button");
    gtk_widget_set_sensitive(randomchat_search_button,TRUE);
    randchat_tag=0;

    if(gtk_object_get_user_data(GTK_OBJECT(randomchat_search_button))) {
        switch (e->Result())
        {
            case EVENT_FAILED:
                showokdialog(_("Chatgroup request"),
                        _("The request failed"));
                break;
            case EVENT_TIMEDOUT:
                showokdialog(_("Chatgroup request"),
                        _("The request timed out"));
                break;
            case EVENT_ERROR:
                showokdialog(_("Chatgroup request"),
                        _("The request went error"));
                break;
            default:
                gtk_widget_destroy(random_chat_dialog);
                break;
        }
    }else {
        switch (e->Result())
        {
            case EVENT_FAILED:
                showokdialog(_("Random chat"),
                        _("No random chat user found in that group."));
                break;
            case EVENT_TIMEDOUT:
                showokdialog(_("Random chat"),
                        _("Random chat search timed out."));
                break;
            case EVENT_ERROR:
                showokdialog(_("Random chat"),
                        _("Random chat search had an error."));
                break;
            default:
                uin = e->SearchAck()->Uin();
                popup_user_event_window(uin,MODE_SEND,SEND_CHAT);
                gtk_widget_destroy(random_chat_dialog);
        }
    }
    
    return TRUE;
}

void
on_randomchat_search_button_clicked    (GtkButton       *button,
                                        gpointer         user_data)
{
    GtkWidget       *randomchat_search_button=lookup_widget(
            random_chat_dialog,"randomchat_search_button");
    GtkWidget       *topics_clist=lookup_widget(random_chat_dialog,
            "topics_clist");
    unsigned long   nGroup=ICQ_RANDOMxCHATxGROUP_NONE;
    gint            selection,chatmode;

    if(!GTK_CLIST(topics_clist)->selection) {
        return;
    }
    chatmode=(gboolean)gtk_object_get_user_data(GTK_OBJECT(button))?FALSE:TRUE;

    gtk_widget_set_sensitive(randomchat_search_button,FALSE);

    selection=GPOINTER_TO_INT(GTK_CLIST(topics_clist)->selection->data); 
    if(!chatmode) {
        selection--;
    }
    switch(selection) {
        case -1:
            nGroup=ICQ_RANDOMxCHATxGROUP_NONE;
            break;
        case 0: 
            nGroup=ICQ_RANDOMxCHATxGROUP_GENERAL; 
            break;
        case 1: 
            nGroup=ICQ_RANDOMxCHATxGROUP_ROMANCE; 
            break;
        case 2: 
            nGroup=ICQ_RANDOMxCHATxGROUP_GAMES; 
            break;
        case 3: 
            nGroup=ICQ_RANDOMxCHATxGROUP_STUDENTS; 
            break;
        case 4: 
            nGroup=ICQ_RANDOMxCHATxGROUP_20SOME; 
            break;
        case 5: 
            nGroup=ICQ_RANDOMxCHATxGROUP_30SOME; 
            break;
        case 6: 
            nGroup=ICQ_RANDOMxCHATxGROUP_40SOME; 
            break;
        case 7: 
            nGroup=ICQ_RANDOMxCHATxGROUP_50PLUS; 
            break;
        case 8: 
            nGroup=ICQ_RANDOMxCHATxGROUP_MxSEEKxF; 
            break;
        case 9: 
            nGroup=ICQ_RANDOMxCHATxGROUP_FxSEEKxM; 
            break;
    }
    register_eventcallback(randomchat_search_event_handler,
            NULL);
    if(chatmode) {
        gbug("on_randomchat_search_button_clicked: getting partner\n");
        randchat_tag = licq_daemon->icqRandomChatSearch(nGroup);
        gtk_window_set_title(GTK_WINDOW(random_chat_dialog),
                _("Searching for Random Chat Partner..."));
    }else {
        gbug("on_randomchat_search_button_clicked: setting new %ld\n",nGroup);
        randchat_tag = licq_daemon->icqSetRandomChatGroup(nGroup);
        gtk_window_set_title(GTK_WINDOW(random_chat_dialog),
                _("Setting Random Chat Group..."));
    }
}


void
on_randomchat_cancel_button_clicked    (GtkButton       *button,
                                        gpointer         user_data)
{
    gtk_widget_destroy(random_chat_dialog);
}

void
show_random_chat_dialog(bool selectmode) 
{
    GtkWidget       *randomchat_search_button;
    GtkWidget       *topics_clist; 
    gchar           *topics[]={
        _("General"),
        _("Romance"),
        _("Games"),
        _("Students"),
        _("20 Something"),
        _("30 Something"),
        _("40 Something"),
        _("50 Plus"),
        _("Men Seeking Women"),
        _("Women Seeking Men"), 
        NULL};
    gchar       *newrow[2];
    gint        i;
    ICQOwner        *o;

    if(random_chat_dialog) {
        gtk_widget_grab_focus(random_chat_dialog);
        return;
    }
    random_chat_dialog=create_randomchat_dialog();
    gtk_window_set_default_size(GTK_WINDOW(random_chat_dialog),290,260);
    if(selectmode) {
        randomchat_search_button=lookup_widget(random_chat_dialog,
                "randomchat_search_button");
        gtk_licq_button_set(GTK_BUTTON(randomchat_search_button),
                GTK_LICQ_BUTTON_OK);
        gtk_object_set_user_data(GTK_OBJECT(randomchat_search_button),
                (gpointer)selectmode);
    }

    topics_clist=lookup_widget(random_chat_dialog,"topics_clist");
    newrow[1]=NULL;
    if(selectmode) {
        newrow[0]=_("(none)");
        gtk_clist_append(GTK_CLIST(topics_clist),newrow);
    }
    for(i=0;topics[i];i++) {
        newrow[0]=topics[i];
        gtk_clist_append(GTK_CLIST(topics_clist),newrow);
    }

    o=gUserManager.FetchOwner(LOCK_R);
    gbug("show_random_chat_dialog: group %ld\n",o->RandomChatGroup());
    switch(o->RandomChatGroup())
    {
        case ICQ_RANDOMxCHATxGROUP_GENERAL: 
            i=1;
            break;
        case ICQ_RANDOMxCHATxGROUP_ROMANCE: 
            i=2; 
            break;
        case ICQ_RANDOMxCHATxGROUP_GAMES: 
            i=3; 
            break;
        case ICQ_RANDOMxCHATxGROUP_STUDENTS: 
            i=4; 
            break;
        case ICQ_RANDOMxCHATxGROUP_20SOME: 
            i=5; 
            break;
        case ICQ_RANDOMxCHATxGROUP_30SOME: 
            i=6; 
            break;
        case ICQ_RANDOMxCHATxGROUP_40SOME: 
            i=7; 
            break;
        case ICQ_RANDOMxCHATxGROUP_50PLUS: 
            i=8; 
            break;
        case ICQ_RANDOMxCHATxGROUP_MxSEEKxF: 
            i=9; 
            break;
        case ICQ_RANDOMxCHATxGROUP_FxSEEKxM: 
            i=10; 
            break;
        case ICQ_RANDOMxCHATxGROUP_NONE:
        default:
            i=0; 
            break;
    }
    gUserManager.DropOwner();
    if(!selectmode&&i) {
        i--;
    }
    gtk_clist_select_row(GTK_CLIST(topics_clist),i,0);

    gtk_widget_show(random_chat_dialog);
}

gboolean
on_randomchat_dialog_delete_event      (GtkWidget       *widget,
                                        GdkEvent        *event,
                                        gpointer         user_data)
{
    gtk_widget_destroy(widget);
    return FALSE;
}

