#ifndef REGISTRATIONWIZARD_H_INCLUDED
#define REGISTRATIONWIZARD_H_INCLUDED

#include "gtk-gui.h"

#define REGISTER_RESULT_REGISTERED  0x01
#define REGISTER_RESULT_SHOWSEARCH  0x02
#define REGISTER_RESULT_SHOWINFO    0x04

#define REGISTRATION_PAGE_INTRO         0
#define REGISTRATION_PAGE_REGTYPE       1
#define REGISTRATION_PAGE_BASIC         2
#define REGISTRATION_PAGE_MORE          3
#define REGISTRATION_PAGE_ACCNTNFO      4
#define REGISTRATION_PAGE_REGISTERING   5
#define REGISTRATION_PAGE_DONE          6


int
register_new_user();

bool
registration_event_callback            (ICQEvent   *event,
                                        gpointer   data);
int
register_save_general                  (GtkWidget       *dialog);

int
register_save_more                     (GtkWidget     *dialog);

int
register_save_security                 (GtkWidget       *dialog);

#ifdef USE_GNOME
gboolean
on_registration_regnew_druidpagestandard_next
                                        (GnomeDruidPage  *gnomedruidpage,
                                        gpointer         arg1,
                                        gpointer         user_data);

gboolean
on_registration_basic_druidpagestandard_next
                                        (GnomeDruidPage  *gnomedruidpage,
                                        gpointer         arg1,
                                        gpointer         user_data);

gboolean
on_registration_personal_druidpagestandard_next
                                        (GnomeDruidPage  *gnomedruidpage,
                                        gpointer         arg1,
                                        gpointer         user_data);

gboolean
on_registration_accntnfo_druidpagestandard_next
                                        (GnomeDruidPage  *gnomedruidpage,
                                        gpointer         arg1,
                                        gpointer         user_data);

void
on_registration_registering_druidpagestandard_prepare
                                        (GnomeDruidPage  *gnomedruidpage,
                                        gpointer         arg1,
                                        gpointer         user_data);

gboolean
on_registration_registering_druidpagestandard_cancel
                                        (GnomeDruidPage  *gnomedruidpage,
                                        gpointer         arg1,
                                        gpointer         user_data);

gboolean
on_registration_druid_general_cancel   (GnomeDruidPage  *gnomedruidpage,
                                        gpointer         arg1,
                                        gpointer         user_data);

gboolean
on_registration_accntnfo_druidpagestandard_back
                                        (GnomeDruidPage  *gnomedruidpage,
                                        gpointer         arg1,
                                        gpointer         user_data);

gboolean
on_registration_registering_druidpagestandard_back
                                        (GnomeDruidPage  *gnomedruidpage,
                                        gpointer         arg1,
                                        gpointer         user_data);

void
on_registration_cancel                 (GnomeDruid      *gnomedruid,
                                        gpointer         user_data);

void
on_registration_final_druidpagestandard_prepare
                                        (GnomeDruidPage  *gnomedruidpage,
                                        gpointer         arg1,
                                        gpointer         user_data);

void
on_registration_final_druidpagestandard_finish
                                        (GnomeDruidPage  *gnomedruidpage,
                                        gpointer         arg1,
                                        gpointer         user_data);

gboolean
on_registration_accntnfo_druidpagestandard_back
                                        (GnomeDruidPage  *gnomedruidpage,
                                        gpointer         arg1,
                                        gpointer         user_data);
#else   /*  USE_GNOME */

void
on_registration_back_button_clicked    (GtkButton       *button,
                                        gpointer         user_data);

void
on_registration_next_button_clicked    (GtkButton       *button,
                                        gpointer         user_data);

void
on_registration_cancel_button_clicked  (GtkButton       *button,
                                        gpointer         user_data);

#endif  /*  USE_GNOME */
                                        
gboolean
on_registration_wizard_window_delete_event
                                        (GtkWidget       *widget,
                                        GdkEvent        *event,
                                        gpointer         user_data);

void
on_registration_wizard_window_destroy  (GtkObject       *object,
                                        gpointer         user_data);

void
on_registration_registering_reg_retry_button_clicked
                                        (GtkButton       *button,
                                        gpointer         user_data);

void
on_registration_registering_info_retry_button_clicked
                                        (GtkButton       *button,
                                        gpointer         user_data);

void
on_registration_wizard_notebook_switch_page
                                        (GtkNotebook     *notebook,
                                        GtkNotebookPage *page,
                                        gint             page_num,
                                        gpointer         user_data);
int
check_registration_password            (GtkWidget       *toplevel);

int
check_registration_uin                 (GtkWidget       *toplevel);

int
do_registration                        (GtkWidget       *toplevel);

int
process_final_page                     (GtkWidget       *toplevel);

int
prepare_final_page                     (GtkWidget       *toplevel);

#endif  /*  REGISTRATIONWIZARD_H_INCLUDED */
