#include "gtk-gui.h"

#include <sys/time.h>
#include <stdio.h>
#ifdef HAVE_ERRNO_H
#include <errno.h>
#endif
#include <signal.h>

#include "interface.h"
#include "contactlist.h"
#include "functions.h"
#include "run_internal_dialog.h"

#define RUN_READ_BUF_SIZE 512

void
run_internal_read_notify(gpointer data,
        gint source,
        GdkInputCondition condition) 
{
    gchar       buf[RUN_READ_BUF_SIZE];
    gint        r_bytes,pos;

    switch(condition) {
        case GDK_INPUT_READ:
            if((r_bytes=read(source,buf,RUN_READ_BUF_SIZE))>0) {
                buf[r_bytes]=0;
                pos=gtk_text_get_length(GTK_TEXT(data));
                gtk_editable_insert_text(
                        GTK_EDITABLE(data),buf,
                        r_bytes,&pos);
            }
            break;
        case GDK_INPUT_EXCEPTION:   
            gtk_widget_destroy(gtk_widget_get_toplevel(
                        GTK_WIDGET(data)));
            break;
        default:
            break;
    } 
}

void
on_run_internal_dialog_destroy_event   (GtkWidget       *widget,
                                        gpointer         user_data)
{
    gint                id;
    runinternal_data    *chdata;
   
    gbug("on_run_internal_dialog_destroy_event\n"); 
    id=GPOINTER_TO_INT(gtk_object_get_data(GTK_OBJECT(widget),"handle"));
    chdata=(runinternal_data*)gtk_object_get_data(GTK_OBJECT(widget),"pipe");

    if(id) {
        gtk_input_remove(id);
    }
    if(chdata) {
        close(chdata->pipe[0]);
        kill(chdata->child,SIGTERM);
    }
    gtk_object_set_data(GTK_OBJECT(widget),"pipe",
            NULL);
    gtk_object_set_data(GTK_OBJECT(widget),"handle",
            NULL);
}


void
on_run_close_button_clicked            (GtkButton       *button,
                                        gpointer         user_data)
{
    gtk_widget_destroy(gtk_widget_get_toplevel(GTK_WIDGET(button)));
}


void
on_run_kill_button_clicked             (GtkButton       *button,
                                        gpointer         user_data)
{
    GtkWidget           *run_internal_dialog;

    run_internal_dialog=gtk_widget_get_toplevel(GTK_WIDGET(button));
    on_run_internal_dialog_destroy_event(run_internal_dialog,NULL);

    gtk_widget_set_sensitive(GTK_WIDGET(button),FALSE);
}

void
run_internal_command    (gchar *command) 
{
    GtkWidget           *run_internal_dialog;
    GtkWidget           *run_text;
    GtkWidget           *run_close_button;
    runinternal_data    *chdata;
    char                *errmsg=NULL;
    gint                id;
    gchar               *argv[4];

    run_internal_dialog=create_run_internal_dialog();
    gtk_window_set_title(GTK_WINDOW(run_internal_dialog),command);
    run_text=lookup_widget(run_internal_dialog,"run_text");
    run_close_button=lookup_widget(run_internal_dialog,"run_close_button");
    chdata=(runinternal_data*)malloc(sizeof(runinternal_data));
    if(pipe(chdata->pipe)) {
        errmsg=strerror(errno);
    }else {
        if(!(chdata->child=fork())) {
            close(chdata->pipe[0]);
            dup2(chdata->pipe[1],STDOUT_FILENO);
            dup2(chdata->pipe[1],STDERR_FILENO);
            close(chdata->pipe[1]);
            argv[0]=g_strdup("/bin/sh");
            argv[1]=g_strdup("-c");
            argv[2]=command;
            argv[3]=NULL;
            execv(argv[0],argv);
            return ;
        }if(chdata->child!=-1) {
            close(chdata->pipe[1]);
        }else {
            errmsg=strerror(errno);
        }
    }
    gtk_object_set_data(GTK_OBJECT(run_internal_dialog),"pipe",(gpointer)chdata);

    if(errmsg) {
        showokdialog("Cannot run command",errmsg);
    } else { 
        id=gdk_input_add(chdata->pipe[0],GDK_INPUT_READ,
                run_internal_read_notify,run_text);
        gtk_object_set_data(GTK_OBJECT(run_internal_dialog),"handle",
                GINT_TO_POINTER(id));
        gtk_widget_show(run_internal_dialog);
    }
        
        /*
    pajp=popen(command,"r");
    id=gdk_input_add(fileno(pajp),GDK_INPUT_READ,
            run_internal_read_notify,run_text);
    gtk_object_set_data(GTK_OBJECT(run_internal_dialog),"handle",
            GINT_TO_POINTER(id));
    gtk_object_set_data(GTK_OBJECT(run_internal_dialog),"data",
            (gpointer)chdata);

    gtk_widget_show(run_internal_dialog);*/
}

gboolean
on_run_internal_dialog_delete_event    (GtkWidget       *widget,
                                        GdkEvent        *event,
                                        gpointer         user_data)
{
    gtk_widget_destroy(widget); 
    return FALSE;
}

