#include "gtk-gui.h"
#include "search_dialog.h"
#include "support.h"
#include "functions.h"

#include "licq_countrycodes.h"
#include "licq_languagecodes.h"

    /*  Globals */
GtkWidget   *search_dialog;

#ifdef USE_GNOME

/*  Note, mind the pixmap locations and licq-adduser button when 
    cutting and pasting!!! */ 
/*
    :,$s/gtk_button_new_with_label (_("licq-adduser"))/gtk_licq_button(GTK_LICQ_BUTTON_ADDUSER)/
    :,$s/gtk_button_new_with_label (_("licq-searchl"))/gtk_licq_button(GTK_LICQ_BUTTON_SEARCHL)/
    :,$s/gtk_button_new_with_label (_("licq-clearl"))/gtk_licq_button(GTK_LICQ_BUTTON_CLEARL)/
    :,$s/gtk_button_new_with_label (_("licq-cancell"))/gtk_licq_button(GTK_LICQ_BUTTON_CANCELL)/
    :,$s/gtk_button_new_with_label (_("licq-done"))/gtk_licq_button(GTK_LICQ_BUTTON_DONE)/
    :,$s/"project1\/search.xpm/GTKGUI_DIR"\/pixmaps\/search.xpm/g
 */


GtkWidget*
create_search_dialog (void)
{
  GtkWidget *search_dialog;
  GtkWidget *search_druid;
  GtkWidget *druidpagestandard_select_method;
  GdkColor druidpagestandard_select_method_bg_color = { 0, 0, 0, 26214 };
  GdkColor druidpagestandard_select_method_logo_bg_color = { 0, 65535, 65535, 65535 };
  GdkColor druidpagestandard_select_method_title_color = { 0, 65535, 65535, 65535 };
  GtkWidget *druid_vbox1;
  GtkWidget *search_choice_vbox;
  GtkWidget *table4;
  GSList *search_group_group = NULL;
  GtkWidget *search_email_radiobutton;
  GtkWidget *search_email_entry;
  GtkWidget *table5;
  GtkWidget *search_uin_radiobutton;
  GtkWidget *search_uin_entry;
  GtkWidget *search_white_radiobutton;
  GtkWidget *druidpagestandard_white;
  GdkColor druidpagestandard_white_bg_color = { 0, 0, 0, 26214 };
  GdkColor druidpagestandard_white_logo_bg_color = { 0, 65535, 65535, 65535 };
  GdkColor druidpagestandard_white_title_color = { 0, 65535, 65535, 65535 };
  GtkWidget *druid_vbox2;
  GtkWidget *vbox9;
  GtkWidget *frame1;
  GtkWidget *table1;
  GtkWidget *label5;
  GtkWidget *label6;
  GtkWidget *label8;
  GtkWidget *label9;
  GtkWidget *label18;
  GtkWidget *label19;
  GtkWidget *search_alias_entry;
  GtkWidget *search_gender_combo;
  GtkWidget *search_gender_combo_entry;
  GtkWidget *search_lastname_entry;
  GtkWidget *search_firstname_entry;
  GtkObject *search_age_to_spinbutton_adj;
  GtkWidget *search_age_to_spinbutton;
  GtkObject *search_age_from_spinbutton_adj;
  GtkWidget *search_age_from_spinbutton;
  GtkWidget *frame2;
  GtkWidget *table2;
  GtkWidget *label11;
  GtkWidget *label12;
  GtkWidget *label13;
  GtkWidget *label14;
  GtkWidget *search_language_combo;
  GtkWidget *search_language_combo_entry;
  GtkWidget *search_country_combo;
  GtkWidget *search_country_combo_entry;
  GtkWidget *search_state_entry;
  GtkWidget *search_city_entry;
  GtkWidget *frame3;
  GtkWidget *table3;
  GtkWidget *label15;
  GtkWidget *label16;
  GtkWidget *label17;
  GtkWidget *search_company_name_entry;
  GtkWidget *search_company_position_entry;
  GtkWidget *search_company_department_entry;
  GtkWidget *druidpagestandard_results;
  GdkColor druidpagestandard_results_bg_color = { 0, 0, 0, 26214 };
  GdkColor druidpagestandard_results_logo_bg_color = { 0, 65535, 65535, 65535 };
  GdkColor druidpagestandard_results_title_color = { 0, 65535, 65535, 65535 };
  GtkWidget *druid_vbox3;
  GtkWidget *vbox6;
  GtkWidget *scrolledwindow1;
  GtkWidget *search_results_clist;
  GtkWidget *label1;
  GtkWidget *label2;
  GtkWidget *label3;
  GtkWidget *label4;
  GtkWidget *frame21;
  GtkWidget *search_result_label;
  GtkWidget *hbox18;
  GtkWidget *search_notify_checkbutton;
  GtkWidget *hbuttonbox1;

  search_dialog = gtk_window_new (GTK_WINDOW_DIALOG);
  gtk_object_set_data (GTK_OBJECT (search_dialog), "search_dialog", search_dialog);
  gtk_window_set_title (GTK_WINDOW (search_dialog), _("Search users"));
  gtk_window_set_wmclass (GTK_WINDOW (search_dialog), "SearchUser", "GtkLicq");

  search_druid = gnome_druid_new ();
  gtk_widget_ref (search_druid);
  gtk_object_set_data_full (GTK_OBJECT (search_dialog), "search_druid", search_druid,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (search_druid);
  gtk_container_add (GTK_CONTAINER (search_dialog), search_druid);

  druidpagestandard_select_method = gnome_druid_page_standard_new_with_vals ("", NULL);
  gtk_widget_ref (druidpagestandard_select_method);
  gtk_object_set_data_full (GTK_OBJECT (search_dialog), "druidpagestandard_select_method", druidpagestandard_select_method,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show_all (druidpagestandard_select_method);
  gnome_druid_append_page (GNOME_DRUID (search_druid), GNOME_DRUID_PAGE (druidpagestandard_select_method));
  gnome_druid_set_page (GNOME_DRUID (search_druid), GNOME_DRUID_PAGE (druidpagestandard_select_method));
  gnome_druid_page_standard_set_bg_color (GNOME_DRUID_PAGE_STANDARD (druidpagestandard_select_method), &druidpagestandard_select_method_bg_color);
  gnome_druid_page_standard_set_logo_bg_color (GNOME_DRUID_PAGE_STANDARD (druidpagestandard_select_method), &druidpagestandard_select_method_logo_bg_color);
  gnome_druid_page_standard_set_title_color (GNOME_DRUID_PAGE_STANDARD (druidpagestandard_select_method), &druidpagestandard_select_method_title_color);
  gnome_druid_page_standard_set_title (GNOME_DRUID_PAGE_STANDARD (druidpagestandard_select_method), _("Search user by ... ?"));
  gnome_druid_page_standard_set_logo (GNOME_DRUID_PAGE_STANDARD (druidpagestandard_select_method),
                                      create_image (GTKGUI_DIR"/pixmaps/search.xpm"));

  druid_vbox1 = GNOME_DRUID_PAGE_STANDARD (druidpagestandard_select_method)->vbox;
  gtk_widget_ref (druid_vbox1);
  gtk_object_set_data_full (GTK_OBJECT (search_dialog), "druid_vbox1", druid_vbox1,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (druid_vbox1);

  search_choice_vbox = gtk_vbox_new (FALSE, 10);
  gtk_widget_ref (search_choice_vbox);
  gtk_object_set_data_full (GTK_OBJECT (search_dialog), "search_choice_vbox", search_choice_vbox,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (search_choice_vbox);
  gtk_box_pack_start (GTK_BOX (druid_vbox1), search_choice_vbox, TRUE, TRUE, 0);
  gtk_container_set_border_width (GTK_CONTAINER (search_choice_vbox), 3);

  table4 = gtk_table_new (2, 2, TRUE);
  gtk_widget_ref (table4);
  gtk_object_set_data_full (GTK_OBJECT (search_dialog), "table4", table4,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (table4);
  gtk_box_pack_start (GTK_BOX (search_choice_vbox), table4, FALSE, TRUE, 0);
  gtk_table_set_row_spacings (GTK_TABLE (table4), 3);

  search_email_radiobutton = gtk_radio_button_new_with_label (search_group_group, _("Email"));
  search_group_group = gtk_radio_button_group (GTK_RADIO_BUTTON (search_email_radiobutton));
  gtk_widget_ref (search_email_radiobutton);
  gtk_object_set_data_full (GTK_OBJECT (search_dialog), "search_email_radiobutton", search_email_radiobutton,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (search_email_radiobutton);
  gtk_table_attach (GTK_TABLE (table4), search_email_radiobutton, 0, 2, 0, 1,
                    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (search_email_radiobutton), TRUE);

  search_email_entry = gtk_entry_new ();
  gtk_widget_ref (search_email_entry);
  gtk_object_set_data_full (GTK_OBJECT (search_dialog), "search_email_entry", search_email_entry,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (search_email_entry);
  gtk_table_attach (GTK_TABLE (table4), search_email_entry, 0, 1, 1, 2,
                    (GtkAttachOptions) (GTK_EXPAND | GTK_SHRINK | GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);

  table5 = gtk_table_new (2, 2, TRUE);
  gtk_widget_ref (table5);
  gtk_object_set_data_full (GTK_OBJECT (search_dialog), "table5", table5,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (table5);
  gtk_box_pack_start (GTK_BOX (search_choice_vbox), table5, FALSE, TRUE, 0);

  search_uin_radiobutton = gtk_radio_button_new_with_label (search_group_group, _("UIN"));
  search_group_group = gtk_radio_button_group (GTK_RADIO_BUTTON (search_uin_radiobutton));
  gtk_widget_ref (search_uin_radiobutton);
  gtk_object_set_data_full (GTK_OBJECT (search_dialog), "search_uin_radiobutton", search_uin_radiobutton,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (search_uin_radiobutton);
  gtk_table_attach (GTK_TABLE (table5), search_uin_radiobutton, 0, 2, 0, 1,
                    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);

  search_uin_entry = gtk_entry_new ();
  gtk_widget_ref (search_uin_entry);
  gtk_object_set_data_full (GTK_OBJECT (search_dialog), "search_uin_entry", search_uin_entry,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (search_uin_entry);
  gtk_table_attach (GTK_TABLE (table5), search_uin_entry, 0, 1, 1, 2,
                    (GtkAttachOptions) (GTK_EXPAND | GTK_SHRINK | GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);

  search_white_radiobutton = gtk_radio_button_new_with_label (search_group_group, _("Whitepages search\nusing other information, such as name, alias, company etc."));
  search_group_group = gtk_radio_button_group (GTK_RADIO_BUTTON (search_white_radiobutton));
  gtk_widget_ref (search_white_radiobutton);
  gtk_object_set_data_full (GTK_OBJECT (search_dialog), "search_white_radiobutton", search_white_radiobutton,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (search_white_radiobutton);
  gtk_box_pack_start (GTK_BOX (search_choice_vbox), search_white_radiobutton, FALSE, TRUE, 0);

  druidpagestandard_white = gnome_druid_page_standard_new_with_vals ("", NULL);
  gtk_widget_ref (druidpagestandard_white);
  gtk_object_set_data_full (GTK_OBJECT (search_dialog), "druidpagestandard_white", druidpagestandard_white,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show_all (druidpagestandard_white);
  gnome_druid_append_page (GNOME_DRUID (search_druid), GNOME_DRUID_PAGE (druidpagestandard_white));
  gnome_druid_page_standard_set_bg_color (GNOME_DRUID_PAGE_STANDARD (druidpagestandard_white), &druidpagestandard_white_bg_color);
  gnome_druid_page_standard_set_logo_bg_color (GNOME_DRUID_PAGE_STANDARD (druidpagestandard_white), &druidpagestandard_white_logo_bg_color);
  gnome_druid_page_standard_set_title_color (GNOME_DRUID_PAGE_STANDARD (druidpagestandard_white), &druidpagestandard_white_title_color);
  gnome_druid_page_standard_set_title (GNOME_DRUID_PAGE_STANDARD (druidpagestandard_white), _("Enter search information"));
  gnome_druid_page_standard_set_logo (GNOME_DRUID_PAGE_STANDARD (druidpagestandard_white),
                                      create_image (GTKGUI_DIR"/pixmaps/search.xpm"));

  druid_vbox2 = GNOME_DRUID_PAGE_STANDARD (druidpagestandard_white)->vbox;
  gtk_widget_ref (druid_vbox2);
  gtk_object_set_data_full (GTK_OBJECT (search_dialog), "druid_vbox2", druid_vbox2,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (druid_vbox2);

  vbox9 = gtk_vbox_new (FALSE, 0);
  gtk_widget_ref (vbox9);
  gtk_object_set_data_full (GTK_OBJECT (search_dialog), "vbox9", vbox9,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (vbox9);
  gtk_box_pack_start (GTK_BOX (druid_vbox2), vbox9, TRUE, TRUE, 0);

  frame1 = gtk_frame_new (_("Personal"));
  gtk_widget_ref (frame1);
  gtk_object_set_data_full (GTK_OBJECT (search_dialog), "frame1", frame1,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (frame1);
  gtk_box_pack_start (GTK_BOX (vbox9), frame1, TRUE, TRUE, 0);
  gtk_container_set_border_width (GTK_CONTAINER (frame1), 3);

  table1 = gtk_table_new (3, 4, FALSE);
  gtk_widget_ref (table1);
  gtk_object_set_data_full (GTK_OBJECT (search_dialog), "table1", table1,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (table1);
  gtk_container_add (GTK_CONTAINER (frame1), table1);
  gtk_container_set_border_width (GTK_CONTAINER (table1), 3);
  gtk_table_set_row_spacings (GTK_TABLE (table1), 3);
  gtk_table_set_col_spacings (GTK_TABLE (table1), 3);

  label5 = gtk_label_new (_("Alias:"));
  gtk_widget_ref (label5);
  gtk_object_set_data_full (GTK_OBJECT (search_dialog), "label5", label5,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (label5);
  gtk_table_attach (GTK_TABLE (table1), label5, 0, 1, 0, 1,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_misc_set_alignment (GTK_MISC (label5), 1, 0.5);

  label6 = gtk_label_new (_("First name:"));
  gtk_widget_ref (label6);
  gtk_object_set_data_full (GTK_OBJECT (search_dialog), "label6", label6,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (label6);
  gtk_table_attach (GTK_TABLE (table1), label6, 0, 1, 1, 2,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_misc_set_alignment (GTK_MISC (label6), 1, 0.5);

  label8 = gtk_label_new (_("Gender:"));
  gtk_widget_ref (label8);
  gtk_object_set_data_full (GTK_OBJECT (search_dialog), "label8", label8,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (label8);
  gtk_table_attach (GTK_TABLE (table1), label8, 2, 3, 0, 1,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_misc_set_alignment (GTK_MISC (label8), 1, 0.5);

  label9 = gtk_label_new (_("Last name:"));
  gtk_widget_ref (label9);
  gtk_object_set_data_full (GTK_OBJECT (search_dialog), "label9", label9,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (label9);
  gtk_table_attach (GTK_TABLE (table1), label9, 2, 3, 1, 2,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_misc_set_alignment (GTK_MISC (label9), 1, 0.5);

  label18 = gtk_label_new (_("Age, from:"));
  gtk_widget_ref (label18);
  gtk_object_set_data_full (GTK_OBJECT (search_dialog), "label18", label18,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (label18);
  gtk_table_attach (GTK_TABLE (table1), label18, 0, 1, 2, 3,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_misc_set_alignment (GTK_MISC (label18), 1, 0.5);

  label19 = gtk_label_new (_("to:"));
  gtk_widget_ref (label19);
  gtk_object_set_data_full (GTK_OBJECT (search_dialog), "label19", label19,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (label19);
  gtk_table_attach (GTK_TABLE (table1), label19, 2, 3, 2, 3,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);

  search_alias_entry = gtk_entry_new ();
  gtk_widget_ref (search_alias_entry);
  gtk_object_set_data_full (GTK_OBJECT (search_dialog), "search_alias_entry", search_alias_entry,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (search_alias_entry);
  gtk_table_attach (GTK_TABLE (table1), search_alias_entry, 1, 2, 0, 1,
                    (GtkAttachOptions) (GTK_EXPAND | GTK_SHRINK | GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);

  search_gender_combo = gtk_combo_new ();
  gtk_widget_ref (search_gender_combo);
  gtk_object_set_data_full (GTK_OBJECT (search_dialog), "search_gender_combo", search_gender_combo,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (search_gender_combo);
  gtk_table_attach (GTK_TABLE (table1), search_gender_combo, 3, 4, 0, 1,
                    (GtkAttachOptions) (GTK_EXPAND | GTK_SHRINK | GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_combo_set_value_in_list (GTK_COMBO (search_gender_combo), TRUE, FALSE);

  search_gender_combo_entry = GTK_COMBO (search_gender_combo)->entry;
  gtk_widget_ref (search_gender_combo_entry);
  gtk_object_set_data_full (GTK_OBJECT (search_dialog), "search_gender_combo_entry", search_gender_combo_entry,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (search_gender_combo_entry);
  gtk_entry_set_editable (GTK_ENTRY (search_gender_combo_entry), FALSE);

  search_lastname_entry = gtk_entry_new ();
  gtk_widget_ref (search_lastname_entry);
  gtk_object_set_data_full (GTK_OBJECT (search_dialog), "search_lastname_entry", search_lastname_entry,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (search_lastname_entry);
  gtk_table_attach (GTK_TABLE (table1), search_lastname_entry, 3, 4, 1, 2,
                    (GtkAttachOptions) (GTK_EXPAND | GTK_SHRINK | GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);

  search_firstname_entry = gtk_entry_new ();
  gtk_widget_ref (search_firstname_entry);
  gtk_object_set_data_full (GTK_OBJECT (search_dialog), "search_firstname_entry", search_firstname_entry,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (search_firstname_entry);
  gtk_table_attach (GTK_TABLE (table1), search_firstname_entry, 1, 2, 1, 2,
                    (GtkAttachOptions) (GTK_EXPAND | GTK_SHRINK | GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);

  search_age_to_spinbutton_adj = gtk_adjustment_new (0, 0, 150, 1, 10, 10);
  search_age_to_spinbutton = gtk_spin_button_new (GTK_ADJUSTMENT (search_age_to_spinbutton_adj), 1, 0);
  gtk_widget_ref (search_age_to_spinbutton);
  gtk_object_set_data_full (GTK_OBJECT (search_dialog), "search_age_to_spinbutton", search_age_to_spinbutton,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (search_age_to_spinbutton);
  gtk_table_attach (GTK_TABLE (table1), search_age_to_spinbutton, 3, 4, 2, 3,
                    (GtkAttachOptions) (GTK_EXPAND | GTK_SHRINK | GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_spin_button_set_numeric (GTK_SPIN_BUTTON (search_age_to_spinbutton), TRUE);

  search_age_from_spinbutton_adj = gtk_adjustment_new (0, 0, 150, 1, 10, 10);
  search_age_from_spinbutton = gtk_spin_button_new (GTK_ADJUSTMENT (search_age_from_spinbutton_adj), 1, 0);
  gtk_widget_ref (search_age_from_spinbutton);
  gtk_object_set_data_full (GTK_OBJECT (search_dialog), "search_age_from_spinbutton", search_age_from_spinbutton,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (search_age_from_spinbutton);
  gtk_table_attach (GTK_TABLE (table1), search_age_from_spinbutton, 1, 2, 2, 3,
                    (GtkAttachOptions) (GTK_EXPAND | GTK_SHRINK | GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_spin_button_set_numeric (GTK_SPIN_BUTTON (search_age_from_spinbutton), TRUE);

  frame2 = gtk_frame_new (_("Geography"));
  gtk_widget_ref (frame2);
  gtk_object_set_data_full (GTK_OBJECT (search_dialog), "frame2", frame2,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (frame2);
  gtk_box_pack_start (GTK_BOX (vbox9), frame2, TRUE, TRUE, 0);
  gtk_container_set_border_width (GTK_CONTAINER (frame2), 3);

  table2 = gtk_table_new (2, 4, FALSE);
  gtk_widget_ref (table2);
  gtk_object_set_data_full (GTK_OBJECT (search_dialog), "table2", table2,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (table2);
  gtk_container_add (GTK_CONTAINER (frame2), table2);
  gtk_container_set_border_width (GTK_CONTAINER (table2), 3);
  gtk_table_set_row_spacings (GTK_TABLE (table2), 3);
  gtk_table_set_col_spacings (GTK_TABLE (table2), 3);

  label11 = gtk_label_new (_("Language:"));
  gtk_widget_ref (label11);
  gtk_object_set_data_full (GTK_OBJECT (search_dialog), "label11", label11,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (label11);
  gtk_table_attach (GTK_TABLE (table2), label11, 0, 1, 0, 1,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_misc_set_alignment (GTK_MISC (label11), 1, 0.5);

  label12 = gtk_label_new (_("City:"));
  gtk_widget_ref (label12);
  gtk_object_set_data_full (GTK_OBJECT (search_dialog), "label12", label12,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (label12);
  gtk_table_attach (GTK_TABLE (table2), label12, 0, 1, 1, 2,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_misc_set_alignment (GTK_MISC (label12), 1, 0.5);

  label13 = gtk_label_new (_("Country:"));
  gtk_widget_ref (label13);
  gtk_object_set_data_full (GTK_OBJECT (search_dialog), "label13", label13,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (label13);
  gtk_table_attach (GTK_TABLE (table2), label13, 2, 3, 0, 1,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_misc_set_alignment (GTK_MISC (label13), 1, 0.5);

  label14 = gtk_label_new (_("State:"));
  gtk_widget_ref (label14);
  gtk_object_set_data_full (GTK_OBJECT (search_dialog), "label14", label14,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (label14);
  gtk_table_attach (GTK_TABLE (table2), label14, 2, 3, 1, 2,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_misc_set_alignment (GTK_MISC (label14), 1, 0.5);

  search_language_combo = gtk_combo_new ();
  gtk_widget_ref (search_language_combo);
  gtk_object_set_data_full (GTK_OBJECT (search_dialog), "search_language_combo", search_language_combo,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (search_language_combo);
  gtk_table_attach (GTK_TABLE (table2), search_language_combo, 1, 2, 0, 1,
                    (GtkAttachOptions) (GTK_EXPAND | GTK_SHRINK | GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_combo_set_value_in_list (GTK_COMBO (search_language_combo), TRUE, FALSE);

  search_language_combo_entry = GTK_COMBO (search_language_combo)->entry;
  gtk_widget_ref (search_language_combo_entry);
  gtk_object_set_data_full (GTK_OBJECT (search_dialog), "search_language_combo_entry", search_language_combo_entry,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (search_language_combo_entry);
  gtk_entry_set_editable (GTK_ENTRY (search_language_combo_entry), FALSE);

  search_country_combo = gtk_combo_new ();
  gtk_widget_ref (search_country_combo);
  gtk_object_set_data_full (GTK_OBJECT (search_dialog), "search_country_combo", search_country_combo,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (search_country_combo);
  gtk_table_attach (GTK_TABLE (table2), search_country_combo, 3, 4, 0, 1,
                    (GtkAttachOptions) (GTK_EXPAND | GTK_SHRINK | GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_combo_set_value_in_list (GTK_COMBO (search_country_combo), TRUE, FALSE);

  search_country_combo_entry = GTK_COMBO (search_country_combo)->entry;
  gtk_widget_ref (search_country_combo_entry);
  gtk_object_set_data_full (GTK_OBJECT (search_dialog), "search_country_combo_entry", search_country_combo_entry,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (search_country_combo_entry);

  search_state_entry = gtk_entry_new ();
  gtk_widget_ref (search_state_entry);
  gtk_object_set_data_full (GTK_OBJECT (search_dialog), "search_state_entry", search_state_entry,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (search_state_entry);
  gtk_table_attach (GTK_TABLE (table2), search_state_entry, 3, 4, 1, 2,
                    (GtkAttachOptions) (GTK_EXPAND | GTK_SHRINK | GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);

  search_city_entry = gtk_entry_new ();
  gtk_widget_ref (search_city_entry);
  gtk_object_set_data_full (GTK_OBJECT (search_dialog), "search_city_entry", search_city_entry,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (search_city_entry);
  gtk_table_attach (GTK_TABLE (table2), search_city_entry, 1, 2, 1, 2,
                    (GtkAttachOptions) (GTK_EXPAND | GTK_SHRINK | GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);

  frame3 = gtk_frame_new (_("Company"));
  gtk_widget_ref (frame3);
  gtk_object_set_data_full (GTK_OBJECT (search_dialog), "frame3", frame3,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (frame3);
  gtk_box_pack_start (GTK_BOX (vbox9), frame3, TRUE, TRUE, 0);
  gtk_container_set_border_width (GTK_CONTAINER (frame3), 3);

  table3 = gtk_table_new (2, 4, FALSE);
  gtk_widget_ref (table3);
  gtk_object_set_data_full (GTK_OBJECT (search_dialog), "table3", table3,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (table3);
  gtk_container_add (GTK_CONTAINER (frame3), table3);
  gtk_container_set_border_width (GTK_CONTAINER (table3), 3);
  gtk_table_set_row_spacings (GTK_TABLE (table3), 3);
  gtk_table_set_col_spacings (GTK_TABLE (table3), 3);

  label15 = gtk_label_new (_("Name:"));
  gtk_widget_ref (label15);
  gtk_object_set_data_full (GTK_OBJECT (search_dialog), "label15", label15,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (label15);
  gtk_table_attach (GTK_TABLE (table3), label15, 0, 1, 0, 1,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_misc_set_alignment (GTK_MISC (label15), 1, 0.5);

  label16 = gtk_label_new (_("Department:"));
  gtk_widget_ref (label16);
  gtk_object_set_data_full (GTK_OBJECT (search_dialog), "label16", label16,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (label16);
  gtk_table_attach (GTK_TABLE (table3), label16, 0, 1, 1, 2,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_misc_set_alignment (GTK_MISC (label16), 1, 0.5);

  label17 = gtk_label_new (_("Position:"));
  gtk_widget_ref (label17);
  gtk_object_set_data_full (GTK_OBJECT (search_dialog), "label17", label17,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (label17);
  gtk_table_attach (GTK_TABLE (table3), label17, 2, 3, 0, 1,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_misc_set_alignment (GTK_MISC (label17), 1, 0.5);

  search_company_name_entry = gtk_entry_new ();
  gtk_widget_ref (search_company_name_entry);
  gtk_object_set_data_full (GTK_OBJECT (search_dialog), "search_company_name_entry", search_company_name_entry,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (search_company_name_entry);
  gtk_table_attach (GTK_TABLE (table3), search_company_name_entry, 1, 2, 0, 1,
                    (GtkAttachOptions) (GTK_EXPAND | GTK_SHRINK | GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);

  search_company_position_entry = gtk_entry_new ();
  gtk_widget_ref (search_company_position_entry);
  gtk_object_set_data_full (GTK_OBJECT (search_dialog), "search_company_position_entry", search_company_position_entry,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (search_company_position_entry);
  gtk_table_attach (GTK_TABLE (table3), search_company_position_entry, 3, 4, 0, 1,
                    (GtkAttachOptions) (GTK_EXPAND | GTK_SHRINK | GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);

  search_company_department_entry = gtk_entry_new ();
  gtk_widget_ref (search_company_department_entry);
  gtk_object_set_data_full (GTK_OBJECT (search_dialog), "search_company_department_entry", search_company_department_entry,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (search_company_department_entry);
  gtk_table_attach (GTK_TABLE (table3), search_company_department_entry, 1, 2, 1, 2,
                    (GtkAttachOptions) (GTK_EXPAND | GTK_SHRINK | GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);

  druidpagestandard_results = gnome_druid_page_standard_new_with_vals ("", NULL);
  gtk_widget_ref (druidpagestandard_results);
  gtk_object_set_data_full (GTK_OBJECT (search_dialog), "druidpagestandard_results", druidpagestandard_results,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show_all (druidpagestandard_results);
  gnome_druid_append_page (GNOME_DRUID (search_druid), GNOME_DRUID_PAGE (druidpagestandard_results));
  gnome_druid_page_standard_set_bg_color (GNOME_DRUID_PAGE_STANDARD (druidpagestandard_results), &druidpagestandard_results_bg_color);
  gnome_druid_page_standard_set_logo_bg_color (GNOME_DRUID_PAGE_STANDARD (druidpagestandard_results), &druidpagestandard_results_logo_bg_color);
  gnome_druid_page_standard_set_title_color (GNOME_DRUID_PAGE_STANDARD (druidpagestandard_results), &druidpagestandard_results_title_color);
  gnome_druid_page_standard_set_title (GNOME_DRUID_PAGE_STANDARD (druidpagestandard_results), _("Search results"));
  gnome_druid_page_standard_set_logo (GNOME_DRUID_PAGE_STANDARD (druidpagestandard_results),
                                      create_image (GTKGUI_DIR"/pixmaps/search.xpm"));

  druid_vbox3 = GNOME_DRUID_PAGE_STANDARD (druidpagestandard_results)->vbox;
  gtk_widget_ref (druid_vbox3);
  gtk_object_set_data_full (GTK_OBJECT (search_dialog), "druid_vbox3", druid_vbox3,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (druid_vbox3);

  vbox6 = gtk_vbox_new (FALSE, 0);
  gtk_widget_ref (vbox6);
  gtk_object_set_data_full (GTK_OBJECT (search_dialog), "vbox6", vbox6,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (vbox6);
  gtk_box_pack_start (GTK_BOX (druid_vbox3), vbox6, TRUE, TRUE, 0);
  gtk_container_set_border_width (GTK_CONTAINER (vbox6), 3);

  scrolledwindow1 = gtk_scrolled_window_new (NULL, NULL);
  gtk_widget_ref (scrolledwindow1);
  gtk_object_set_data_full (GTK_OBJECT (search_dialog), "scrolledwindow1", scrolledwindow1,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (scrolledwindow1);
  gtk_box_pack_start (GTK_BOX (vbox6), scrolledwindow1, TRUE, TRUE, 0);
  gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (scrolledwindow1), GTK_POLICY_AUTOMATIC, GTK_POLICY_AUTOMATIC);

  search_results_clist = gtk_clist_new (4);
  gtk_widget_ref (search_results_clist);
  gtk_object_set_data_full (GTK_OBJECT (search_dialog), "search_results_clist", search_results_clist,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (search_results_clist);
  gtk_container_add (GTK_CONTAINER (scrolledwindow1), search_results_clist);
  gtk_clist_set_column_width (GTK_CLIST (search_results_clist), 0, 80);
  gtk_clist_set_column_width (GTK_CLIST (search_results_clist), 1, 80);
  gtk_clist_set_column_width (GTK_CLIST (search_results_clist), 2, 80);
  gtk_clist_set_column_width (GTK_CLIST (search_results_clist), 3, 80);
  gtk_clist_set_selection_mode (GTK_CLIST (search_results_clist), GTK_SELECTION_EXTENDED);
  gtk_clist_column_titles_show (GTK_CLIST (search_results_clist));

  label1 = gtk_label_new (_("Alias"));
  gtk_widget_ref (label1);
  gtk_object_set_data_full (GTK_OBJECT (search_dialog), "label1", label1,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (label1);
  gtk_clist_set_column_widget (GTK_CLIST (search_results_clist), 0, label1);

  label2 = gtk_label_new (_("UIN"));
  gtk_widget_ref (label2);
  gtk_object_set_data_full (GTK_OBJECT (search_dialog), "label2", label2,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (label2);
  gtk_clist_set_column_widget (GTK_CLIST (search_results_clist), 1, label2);

  label3 = gtk_label_new (_("Name"));
  gtk_widget_ref (label3);
  gtk_object_set_data_full (GTK_OBJECT (search_dialog), "label3", label3,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (label3);
  gtk_clist_set_column_widget (GTK_CLIST (search_results_clist), 2, label3);

  label4 = gtk_label_new (_("Email"));
  gtk_widget_ref (label4);
  gtk_object_set_data_full (GTK_OBJECT (search_dialog), "label4", label4,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (label4);
  gtk_clist_set_column_widget (GTK_CLIST (search_results_clist), 3, label4);

  frame21 = gtk_frame_new (NULL);
  gtk_widget_ref (frame21);
  gtk_object_set_data_full (GTK_OBJECT (search_dialog), "frame21", frame21,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (frame21);
  gtk_box_pack_start (GTK_BOX (vbox6), frame21, FALSE, FALSE, 0);
  gtk_frame_set_shadow_type (GTK_FRAME (frame21), GTK_SHADOW_IN);

  search_result_label = gtk_label_new ("");
  gtk_widget_ref (search_result_label);
  gtk_object_set_data_full (GTK_OBJECT (search_dialog), "search_result_label", search_result_label,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (search_result_label);
  gtk_container_add (GTK_CONTAINER (frame21), search_result_label);
  gtk_misc_set_alignment (GTK_MISC (search_result_label), 0, 0.5);
  gtk_misc_set_padding (GTK_MISC (search_result_label), 3, 0);

  hbox18 = gtk_hbox_new (FALSE, 0);
  gtk_widget_ref (hbox18);
  gtk_object_set_data_full (GTK_OBJECT (search_dialog), "hbox18", hbox18,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (hbox18);
  gtk_box_pack_start (GTK_BOX (vbox6), hbox18, FALSE, TRUE, 0);

  search_notify_checkbutton = gtk_check_button_new_with_label (_("Notify user when adding to list"));
  gtk_widget_ref (search_notify_checkbutton);
  gtk_object_set_data_full (GTK_OBJECT (search_dialog), "search_notify_checkbutton", search_notify_checkbutton,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (search_notify_checkbutton);
  gtk_box_pack_start (GTK_BOX (hbox18), search_notify_checkbutton, FALSE, TRUE, 0);

  hbuttonbox1 = gtk_hbutton_box_new ();
  gtk_widget_ref (hbuttonbox1);
  gtk_object_set_data_full (GTK_OBJECT (search_dialog), "hbuttonbox1", hbuttonbox1,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (hbuttonbox1);
  gtk_box_pack_start (GTK_BOX (hbox18), hbuttonbox1, TRUE, TRUE, 0);
  gtk_button_box_set_layout (GTK_BUTTON_BOX (hbuttonbox1), GTK_BUTTONBOX_END);

  gtk_signal_connect (GTK_OBJECT (search_dialog), "delete_event",
                      GTK_SIGNAL_FUNC (on_search_dialog_delete_event),
                      NULL);
  gtk_signal_connect (GTK_OBJECT (search_dialog), "show",
                      GTK_SIGNAL_FUNC (on_search_dialog_show),
                      NULL);
  gtk_signal_connect (GTK_OBJECT (search_dialog), "destroy",
                      GTK_SIGNAL_FUNC (on_search_dialog_destroy_event),
                      NULL);
  gtk_signal_connect (GTK_OBJECT (search_dialog), "show",
                      GTK_SIGNAL_FUNC (on_window_show_set_posdata),
                      &configuration.pos_search_dialog);
  gtk_signal_connect (GTK_OBJECT (search_dialog), "destroy",
                      GTK_SIGNAL_FUNC (on_window_destroy_get_posdata),
                      &configuration.pos_search_dialog);
  gtk_signal_connect (GTK_OBJECT (search_druid), "cancel",
                      GTK_SIGNAL_FUNC (on_search_druid_cancel),
                      NULL);
  gtk_signal_connect (GTK_OBJECT (druidpagestandard_select_method), "next",
                      GTK_SIGNAL_FUNC (on_druidpagestandard_select_method_next),
                      NULL);
  gtk_signal_connect (GTK_OBJECT (druidpagestandard_select_method), "prepare",
                      GTK_SIGNAL_FUNC (on_druidpagestandard_select_method_prepare),
                      NULL);
  gtk_signal_connect (GTK_OBJECT (search_email_radiobutton), "toggled",
                      GTK_SIGNAL_FUNC (on_search_email_radiobutton_toggled),
                      NULL);
  gtk_signal_connect (GTK_OBJECT (search_uin_radiobutton), "toggled",
                      GTK_SIGNAL_FUNC (on_search_uin_radiobutton_toggled),
                      NULL);
  gtk_signal_connect (GTK_OBJECT (search_white_radiobutton), "toggled",
                      GTK_SIGNAL_FUNC (on_search_white_radiobutton_toggled),
                      NULL);
  gtk_signal_connect (GTK_OBJECT (druidpagestandard_white), "next",
                      GTK_SIGNAL_FUNC (on_druidpagestandard_white_next),
                      NULL);
  gtk_signal_connect (GTK_OBJECT (druidpagestandard_white), "prepare",
                      GTK_SIGNAL_FUNC (on_druidpagestandard_white_prepare),
                      NULL);
  gtk_signal_connect (GTK_OBJECT (search_age_to_spinbutton), "changed",
                      GTK_SIGNAL_FUNC (on_search_age_to_spinbutton_changed),
                      NULL);
  gtk_signal_connect (GTK_OBJECT (search_age_from_spinbutton), "changed",
                      GTK_SIGNAL_FUNC (on_search_age_from_spinbutton_changed),
                      NULL);
  gtk_signal_connect (GTK_OBJECT (druidpagestandard_results), "back",
                      GTK_SIGNAL_FUNC (on_druidpagestandard_results_back),
                      NULL);
  gtk_signal_connect (GTK_OBJECT (druidpagestandard_results), "prepare",
                      GTK_SIGNAL_FUNC (on_druidpagestandard_results_prepare),
                      NULL);
  gtk_signal_connect (GTK_OBJECT (druidpagestandard_results), "finish",
                      GTK_SIGNAL_FUNC (on_druidpagestandard_results_finish),
                      NULL);
  gtk_signal_connect (GTK_OBJECT (search_results_clist), "click_column",
                      GTK_SIGNAL_FUNC (on_search_results_clist_click_column),
                      NULL);
  gtk_signal_connect (GTK_OBJECT (search_results_clist), "select_row",
                      GTK_SIGNAL_FUNC (on_search_results_clist_select_row),
                      NULL);

  return search_dialog;
}

gboolean
on_druidpagestandard_select_method_next
                                        (GnomeDruidPage  *gnomedruidpage,
                                        gpointer         arg1,
                                        gpointer         user_data)
{
    GtkWidget       *search_email_radiobutton=lookup_widget(
            GTK_WIDGET(gnomedruidpage),"search_email_radiobutton");
    GtkWidget       *search_uin_radiobutton=lookup_widget(
            GTK_WIDGET(gnomedruidpage),"search_uin_radiobutton");
    GtkWidget       *druidpagestandard_results=lookup_widget(
            GTK_WIDGET(gnomedruidpage),"druidpagestandard_results");
    GtkWidget       *search_druid=lookup_widget(
            GTK_WIDGET(gnomedruidpage),"search_druid");

    if(gtk_toggle_button_get_active(
                GTK_TOGGLE_BUTTON(search_uin_radiobutton))) {
        execute_search(SEARCH_BY_UIN);
        gnome_druid_set_page(GNOME_DRUID(search_druid),
                GNOME_DRUID_PAGE(druidpagestandard_results));
        return TRUE;
    }else if(gtk_toggle_button_get_active(
                GTK_TOGGLE_BUTTON(search_email_radiobutton))) {
        execute_search(SEARCH_BY_EMAIL);
        gnome_druid_set_page(GNOME_DRUID(search_druid),
                GNOME_DRUID_PAGE(druidpagestandard_results));
        return TRUE;
    }else {
        return FALSE;
    }

}

void
on_druidpagestandard_results_finish    (GnomeDruidPage  *gnomedruidpage,
                                        gpointer         arg1,
                                        gpointer         user_data)
{
    GtkWidget	*search_results_clist = lookup_widget(search_dialog,
            "search_results_clist");
    GtkWidget   *search_notify_checkbutton=lookup_widget(search_dialog,
            "search_notify_checkbutton");
    GList       *selection;
    char        *uin;
    int         row;
    unsigned long numerical_uin;
    
    if((selection=GTK_CLIST(search_results_clist)->selection)) {
        while(selection) {
            row=GPOINTER_TO_INT(selection->data);
            gtk_clist_get_text(GTK_CLIST(search_results_clist),row,1,&uin);
            sscanf(uin,"%ld",&numerical_uin);
            if(!gUserManager.FetchUser(numerical_uin,LOCK_N)) {
                licq_daemon->AddUserToList(numerical_uin);
                if(gtk_toggle_button_get_active(
                            GTK_TOGGLE_BUTTON(search_notify_checkbutton))) {
                    licq_daemon->icqAlertUser(numerical_uin);
                }
            }
            selection=g_list_next(selection);
        }
    }else {
        if(gtk_clist_get_length(GTK_CLIST(search_results_clist))) {
            gtk_clist_get_text(GTK_CLIST(search_results_clist),0,1,&uin);
            sscanf(uin,"%ld",&numerical_uin);
            if(!gUserManager.FetchUser(numerical_uin,LOCK_N)) {
                licq_daemon->AddUserToList(numerical_uin);
                if(gtk_toggle_button_get_active(
                            GTK_TOGGLE_BUTTON(search_notify_checkbutton))) {
                    licq_daemon->icqAlertUser(numerical_uin);
                }
            }
        }
    }

    gtk_widget_destroy(search_dialog);
}


void
on_druidpagestandard_select_method_prepare
                                        (GnomeDruidPage  *gnomedruidpage,
                                        gpointer         arg1,
                                        gpointer         user_data)
{
    GtkWidget       *search_druid=lookup_widget(
            GTK_WIDGET(gnomedruidpage),"search_druid");

    gnome_druid_set_buttons_sensitive(GNOME_DRUID(search_druid),
            FALSE,TRUE,TRUE);
    gnome_druid_set_show_finish(GNOME_DRUID(search_druid),FALSE);
}

gboolean
on_druidpagestandard_white_next        (GnomeDruidPage  *gnomedruidpage,
                                        gpointer         arg1,
                                        gpointer         user_data)
{
    GtkWidget       *druidpagestandard_results=lookup_widget(
            GTK_WIDGET(gnomedruidpage),"druidpagestandard_results");
    GtkWidget       *search_druid=lookup_widget(
            GTK_WIDGET(gnomedruidpage),"search_druid");

    execute_search(SEARCH_BY_WHITEPAGES);
    gnome_druid_set_page(GNOME_DRUID(search_druid),
            GNOME_DRUID_PAGE(druidpagestandard_results));
    return TRUE;
}


gboolean
on_druidpagestandard_results_back      (GnomeDruidPage  *gnomedruidpage,
                                        gpointer         arg1,
                                        gpointer         user_data)
{
    GtkWidget       *search_white_radiobutton=lookup_widget(
            GTK_WIDGET(gnomedruidpage),"search_white_radiobutton");
    GtkWidget       *druidpagestandard_select_method=lookup_widget(
            GTK_WIDGET(gnomedruidpage),"druidpagestandard_select_method");
    GtkWidget       *search_druid=lookup_widget(
            GTK_WIDGET(gnomedruidpage),"search_druid");

    if(gtk_toggle_button_get_active(
                GTK_TOGGLE_BUTTON(search_white_radiobutton))) {
        return FALSE;
    }else {
        gnome_druid_set_page(GNOME_DRUID(search_druid),
                GNOME_DRUID_PAGE(druidpagestandard_select_method));
        return TRUE;
    }
    gnome_druid_set_buttons_sensitive(GNOME_DRUID(search_druid),TRUE,
            TRUE,TRUE);    
}

void
on_search_druid_cancel                 (GnomeDruid      *gnomedruid,
                                        gpointer         user_data)
{
    gtk_widget_destroy(search_dialog);
}

void
on_druidpagestandard_white_prepare     (GnomeDruidPage  *gnomedruidpage,
                                        gpointer         arg1,
                                        gpointer         user_data)
{
    GtkWidget       *search_druid=lookup_widget(GTK_WIDGET(gnomedruidpage),
        "search_druid");

    gnome_druid_set_show_finish(GNOME_DRUID(search_druid),FALSE);    
}

void
on_druidpagestandard_results_prepare   (GnomeDruidPage  *gnomedruidpage,
                                        gpointer         arg1,
                                        gpointer         user_data)
{
    GtkWidget       *search_druid=lookup_widget(GTK_WIDGET(gnomedruidpage),
            "search_druid");

    gnome_druid_set_show_finish(GNOME_DRUID(search_druid),TRUE);    
    gnome_druid_set_buttons_sensitive(GNOME_DRUID(search_druid),TRUE,
            TRUE,TRUE);    
}

void
on_search_finish_button_clicked        (GtkButton       *button,
                                        gpointer         user_data)
{
    GtkWidget       *druidpagestandard_results=lookup_widget(GTK_WIDGET(button),
            "druidpagestandard_results");
    GtkWidget       *search_druid=lookup_widget(GTK_WIDGET(button),
            "search_druid");

    gnome_druid_set_page(GNOME_DRUID(search_druid),
            GNOME_DRUID_PAGE(druidpagestandard_results));
}

void
on_search_email_radiobutton_toggled    (GtkToggleButton *togglebutton,
                                        gpointer         user_data)
{
    GtkWidget   *search_email_entry=lookup_widget(GTK_WIDGET(togglebutton),
            "search_email_entry");
    gtk_widget_set_sensitive(search_email_entry,
            gtk_toggle_button_get_active(togglebutton));
}


void
on_search_uin_radiobutton_toggled      (GtkToggleButton *togglebutton,
                                        gpointer         user_data)
{
    GtkWidget   *search_uin_entry=lookup_widget(GTK_WIDGET(togglebutton),
            "search_uin_entry");
    gtk_widget_set_sensitive(search_uin_entry,
            gtk_toggle_button_get_active(togglebutton));
}


void
on_search_white_radiobutton_toggled    (GtkToggleButton *togglebutton,
                                        gpointer         user_data)
{
}

#else   /*  USE_GNOME */

GtkWidget*
create_search_dialog (void)
{
  GtkWidget *search_dialog;
  GtkWidget *vbox10;
  GtkWidget *hbox19;
  GtkWidget *search_notebook;
  GtkWidget *vbox9;
  GtkWidget *frame1;
  GtkWidget *table1;
  GtkWidget *label5;
  GtkWidget *label6;
  GtkWidget *label8;
  GtkWidget *label9;
  GtkWidget *label18;
  GtkWidget *label19;
  GtkWidget *search_alias_entry;
  GtkWidget *search_gender_combo;
  GtkWidget *search_gender_combo_entry;
  GtkWidget *search_firstname_entry;
  GtkWidget *search_lastname_entry;
  GtkObject *search_age_to_spinbutton_adj;
  GtkWidget *search_age_to_spinbutton;
  GtkObject *search_age_from_spinbutton_adj;
  GtkWidget *search_age_from_spinbutton;
  GtkWidget *frame2;
  GtkWidget *table2;
  GtkWidget *label11;
  GtkWidget *label12;
  GtkWidget *label13;
  GtkWidget *label14;
  GtkWidget *search_language_combo;
  GtkWidget *search_language_combo_entry;
  GtkWidget *search_country_combo;
  GtkWidget *search_country_combo_entry;
  GtkWidget *search_state_entry;
  GtkWidget *search_city_entry;
  GtkWidget *frame3;
  GtkWidget *table3;
  GtkWidget *label15;
  GtkWidget *label16;
  GtkWidget *label17;
  GtkWidget *search_company_name_entry;
  GtkWidget *search_company_position_entry;
  GtkWidget *search_company_department_entry;
  GtkWidget *label46;
  GtkWidget *table6;
  GtkWidget *search_email_entry;
  GtkWidget *label53;
  GtkWidget *label47;
  GtkWidget *table7;
  GtkWidget *search_uin_entry;
  GtkWidget *label52;
  GtkWidget *label48;
  GtkWidget *vbuttonbox2;
  GtkWidget *search_button;
  GtkWidget *search_clear_button;
  GtkWidget *search_cancel_button;
  GtkWidget *scrolledwindow_search_clist;
  GtkWidget *search_results_clist;
  GtkWidget *label54;
  GtkWidget *label55;
  GtkWidget *label56;
  GtkWidget *label57;
  GtkWidget *hbox20;
  GtkWidget *search_notify_checkbutton;
  GtkWidget *hbuttonbox2;
  GtkWidget *search_add_user_button;
  GtkWidget *done_button;
  GtkWidget *frame22;
  GtkWidget *search_result_label;

  search_dialog = gtk_window_new (GTK_WINDOW_DIALOG);
  gtk_object_set_data (GTK_OBJECT (search_dialog), "search_dialog", search_dialog);
  gtk_window_set_title (GTK_WINDOW (search_dialog), _("Search for user"));
  gtk_window_set_position (GTK_WINDOW (search_dialog), GTK_WIN_POS_CENTER);
  gtk_window_set_policy (GTK_WINDOW (search_dialog), TRUE, TRUE, FALSE);
  gtk_window_set_wmclass (GTK_WINDOW (search_dialog), "SearchUser", "GtkLicq");

  vbox10 = gtk_vbox_new (FALSE, 0);
  gtk_widget_ref (vbox10);
  gtk_object_set_data_full (GTK_OBJECT (search_dialog), "vbox10", vbox10,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (vbox10);
  gtk_container_add (GTK_CONTAINER (search_dialog), vbox10);
  gtk_container_set_border_width (GTK_CONTAINER (vbox10), 3);

  hbox19 = gtk_hbox_new (FALSE, 0);
  gtk_widget_ref (hbox19);
  gtk_object_set_data_full (GTK_OBJECT (search_dialog), "hbox19", hbox19,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (hbox19);
  gtk_box_pack_start (GTK_BOX (vbox10), hbox19, FALSE, TRUE, 0);

  search_notebook = gtk_notebook_new ();
  gtk_widget_ref (search_notebook);
  gtk_object_set_data_full (GTK_OBJECT (search_dialog), "search_notebook", search_notebook,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (search_notebook);
  gtk_box_pack_start (GTK_BOX (hbox19), search_notebook, TRUE, TRUE, 0);

  vbox9 = gtk_vbox_new (FALSE, 0);
  gtk_widget_ref (vbox9);
  gtk_object_set_data_full (GTK_OBJECT (search_dialog), "vbox9", vbox9,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (vbox9);
  gtk_container_add (GTK_CONTAINER (search_notebook), vbox9);

  frame1 = gtk_frame_new (_("Personal"));
  gtk_widget_ref (frame1);
  gtk_object_set_data_full (GTK_OBJECT (search_dialog), "frame1", frame1,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (frame1);
  gtk_box_pack_start (GTK_BOX (vbox9), frame1, TRUE, TRUE, 0);
  gtk_container_set_border_width (GTK_CONTAINER (frame1), 3);

  table1 = gtk_table_new (3, 4, FALSE);
  gtk_widget_ref (table1);
  gtk_object_set_data_full (GTK_OBJECT (search_dialog), "table1", table1,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (table1);
  gtk_container_add (GTK_CONTAINER (frame1), table1);
  gtk_container_set_border_width (GTK_CONTAINER (table1), 3);
  gtk_table_set_row_spacings (GTK_TABLE (table1), 3);
  gtk_table_set_col_spacings (GTK_TABLE (table1), 3);

  label5 = gtk_label_new (_("Alias:"));
  gtk_widget_ref (label5);
  gtk_object_set_data_full (GTK_OBJECT (search_dialog), "label5", label5,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (label5);
  gtk_table_attach (GTK_TABLE (table1), label5, 0, 1, 0, 1,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_misc_set_alignment (GTK_MISC (label5), 1, 0.5);

  label6 = gtk_label_new (_("First name:"));
  gtk_widget_ref (label6);
  gtk_object_set_data_full (GTK_OBJECT (search_dialog), "label6", label6,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (label6);
  gtk_table_attach (GTK_TABLE (table1), label6, 0, 1, 1, 2,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_misc_set_alignment (GTK_MISC (label6), 1, 0.5);

  label8 = gtk_label_new (_("Gender:"));
  gtk_widget_ref (label8);
  gtk_object_set_data_full (GTK_OBJECT (search_dialog), "label8", label8,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (label8);
  gtk_table_attach (GTK_TABLE (table1), label8, 2, 3, 0, 1,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_misc_set_alignment (GTK_MISC (label8), 1, 0.5);

  label9 = gtk_label_new (_("Last name:"));
  gtk_widget_ref (label9);
  gtk_object_set_data_full (GTK_OBJECT (search_dialog), "label9", label9,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (label9);
  gtk_table_attach (GTK_TABLE (table1), label9, 2, 3, 1, 2,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_misc_set_alignment (GTK_MISC (label9), 1, 0.5);

  label18 = gtk_label_new (_("Age, from:"));
  gtk_widget_ref (label18);
  gtk_object_set_data_full (GTK_OBJECT (search_dialog), "label18", label18,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (label18);
  gtk_table_attach (GTK_TABLE (table1), label18, 0, 1, 2, 3,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_misc_set_alignment (GTK_MISC (label18), 1, 0.5);

  label19 = gtk_label_new (_("to:"));
  gtk_widget_ref (label19);
  gtk_object_set_data_full (GTK_OBJECT (search_dialog), "label19", label19,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (label19);
  gtk_table_attach (GTK_TABLE (table1), label19, 2, 3, 2, 3,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_misc_set_alignment (GTK_MISC (label19), 1, 0.5);

  search_alias_entry = gtk_entry_new ();
  gtk_widget_ref (search_alias_entry);
  gtk_object_set_data_full (GTK_OBJECT (search_dialog), "search_alias_entry", search_alias_entry,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (search_alias_entry);
  gtk_table_attach (GTK_TABLE (table1), search_alias_entry, 1, 2, 0, 1,
                    (GtkAttachOptions) (GTK_EXPAND | GTK_SHRINK | GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);

  search_gender_combo = gtk_combo_new ();
  gtk_widget_ref (search_gender_combo);
  gtk_object_set_data_full (GTK_OBJECT (search_dialog), "search_gender_combo", search_gender_combo,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (search_gender_combo);
  gtk_table_attach (GTK_TABLE (table1), search_gender_combo, 3, 4, 0, 1,
                    (GtkAttachOptions) (GTK_EXPAND | GTK_SHRINK | GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_combo_set_value_in_list (GTK_COMBO (search_gender_combo), TRUE, FALSE);

  search_gender_combo_entry = GTK_COMBO (search_gender_combo)->entry;
  gtk_widget_ref (search_gender_combo_entry);
  gtk_object_set_data_full (GTK_OBJECT (search_dialog), "search_gender_combo_entry", search_gender_combo_entry,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (search_gender_combo_entry);
  gtk_entry_set_editable (GTK_ENTRY (search_gender_combo_entry), FALSE);

  search_firstname_entry = gtk_entry_new ();
  gtk_widget_ref (search_firstname_entry);
  gtk_object_set_data_full (GTK_OBJECT (search_dialog), "search_firstname_entry", search_firstname_entry,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (search_firstname_entry);
  gtk_table_attach (GTK_TABLE (table1), search_firstname_entry, 1, 2, 1, 2,
                    (GtkAttachOptions) (GTK_EXPAND | GTK_SHRINK | GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);

  search_lastname_entry = gtk_entry_new ();
  gtk_widget_ref (search_lastname_entry);
  gtk_object_set_data_full (GTK_OBJECT (search_dialog), "search_lastname_entry", search_lastname_entry,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (search_lastname_entry);
  gtk_table_attach (GTK_TABLE (table1), search_lastname_entry, 3, 4, 1, 2,
                    (GtkAttachOptions) (GTK_EXPAND | GTK_SHRINK | GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);

  search_age_to_spinbutton_adj = gtk_adjustment_new (0, 0, 150, 1, 10, 10);
  search_age_to_spinbutton = gtk_spin_button_new (GTK_ADJUSTMENT (search_age_to_spinbutton_adj), 1, 0);
  gtk_widget_ref (search_age_to_spinbutton);
  gtk_object_set_data_full (GTK_OBJECT (search_dialog), "search_age_to_spinbutton", search_age_to_spinbutton,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (search_age_to_spinbutton);
  gtk_table_attach (GTK_TABLE (table1), search_age_to_spinbutton, 3, 4, 2, 3,
                    (GtkAttachOptions) (GTK_EXPAND | GTK_SHRINK | GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_spin_button_set_numeric (GTK_SPIN_BUTTON (search_age_to_spinbutton), TRUE);

  search_age_from_spinbutton_adj = gtk_adjustment_new (0, 0, 150, 1, 10, 10);
  search_age_from_spinbutton = gtk_spin_button_new (GTK_ADJUSTMENT (search_age_from_spinbutton_adj), 1, 0);
  gtk_widget_ref (search_age_from_spinbutton);
  gtk_object_set_data_full (GTK_OBJECT (search_dialog), "search_age_from_spinbutton", search_age_from_spinbutton,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (search_age_from_spinbutton);
  gtk_table_attach (GTK_TABLE (table1), search_age_from_spinbutton, 1, 2, 2, 3,
                    (GtkAttachOptions) (GTK_EXPAND | GTK_SHRINK | GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_spin_button_set_numeric (GTK_SPIN_BUTTON (search_age_from_spinbutton), TRUE);

  frame2 = gtk_frame_new (_("Geography"));
  gtk_widget_ref (frame2);
  gtk_object_set_data_full (GTK_OBJECT (search_dialog), "frame2", frame2,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (frame2);
  gtk_box_pack_start (GTK_BOX (vbox9), frame2, TRUE, TRUE, 0);
  gtk_container_set_border_width (GTK_CONTAINER (frame2), 3);

  table2 = gtk_table_new (2, 4, FALSE);
  gtk_widget_ref (table2);
  gtk_object_set_data_full (GTK_OBJECT (search_dialog), "table2", table2,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (table2);
  gtk_container_add (GTK_CONTAINER (frame2), table2);
  gtk_container_set_border_width (GTK_CONTAINER (table2), 3);
  gtk_table_set_row_spacings (GTK_TABLE (table2), 3);
  gtk_table_set_col_spacings (GTK_TABLE (table2), 3);

  label11 = gtk_label_new (_("Language:"));
  gtk_widget_ref (label11);
  gtk_object_set_data_full (GTK_OBJECT (search_dialog), "label11", label11,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (label11);
  gtk_table_attach (GTK_TABLE (table2), label11, 0, 1, 0, 1,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_misc_set_alignment (GTK_MISC (label11), 1, 0.5);

  label12 = gtk_label_new (_("City:"));
  gtk_widget_ref (label12);
  gtk_object_set_data_full (GTK_OBJECT (search_dialog), "label12", label12,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (label12);
  gtk_table_attach (GTK_TABLE (table2), label12, 0, 1, 1, 2,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_misc_set_alignment (GTK_MISC (label12), 1, 0.5);

  label13 = gtk_label_new (_("Country:"));
  gtk_widget_ref (label13);
  gtk_object_set_data_full (GTK_OBJECT (search_dialog), "label13", label13,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (label13);
  gtk_table_attach (GTK_TABLE (table2), label13, 2, 3, 0, 1,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_misc_set_alignment (GTK_MISC (label13), 1, 0.5);

  label14 = gtk_label_new (_("State:"));
  gtk_widget_ref (label14);
  gtk_object_set_data_full (GTK_OBJECT (search_dialog), "label14", label14,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (label14);
  gtk_table_attach (GTK_TABLE (table2), label14, 2, 3, 1, 2,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_misc_set_alignment (GTK_MISC (label14), 1, 0.5);

  search_language_combo = gtk_combo_new ();
  gtk_widget_ref (search_language_combo);
  gtk_object_set_data_full (GTK_OBJECT (search_dialog), "search_language_combo", search_language_combo,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (search_language_combo);
  gtk_table_attach (GTK_TABLE (table2), search_language_combo, 1, 2, 0, 1,
                    (GtkAttachOptions) (GTK_EXPAND | GTK_SHRINK | GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_combo_set_value_in_list (GTK_COMBO (search_language_combo), TRUE, FALSE);

  search_language_combo_entry = GTK_COMBO (search_language_combo)->entry;
  gtk_widget_ref (search_language_combo_entry);
  gtk_object_set_data_full (GTK_OBJECT (search_dialog), "search_language_combo_entry", search_language_combo_entry,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (search_language_combo_entry);
  gtk_entry_set_editable (GTK_ENTRY (search_language_combo_entry), FALSE);

  search_country_combo = gtk_combo_new ();
  gtk_widget_ref (search_country_combo);
  gtk_object_set_data_full (GTK_OBJECT (search_dialog), "search_country_combo", search_country_combo,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (search_country_combo);
  gtk_table_attach (GTK_TABLE (table2), search_country_combo, 3, 4, 0, 1,
                    (GtkAttachOptions) (GTK_EXPAND | GTK_SHRINK | GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_combo_set_value_in_list (GTK_COMBO (search_country_combo), TRUE, FALSE);

  search_country_combo_entry = GTK_COMBO (search_country_combo)->entry;
  gtk_widget_ref (search_country_combo_entry);
  gtk_object_set_data_full (GTK_OBJECT (search_dialog), "search_country_combo_entry", search_country_combo_entry,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (search_country_combo_entry);

  search_state_entry = gtk_entry_new ();
  gtk_widget_ref (search_state_entry);
  gtk_object_set_data_full (GTK_OBJECT (search_dialog), "search_state_entry", search_state_entry,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (search_state_entry);
  gtk_table_attach (GTK_TABLE (table2), search_state_entry, 3, 4, 1, 2,
                    (GtkAttachOptions) (GTK_EXPAND | GTK_SHRINK | GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);

  search_city_entry = gtk_entry_new ();
  gtk_widget_ref (search_city_entry);
  gtk_object_set_data_full (GTK_OBJECT (search_dialog), "search_city_entry", search_city_entry,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (search_city_entry);
  gtk_table_attach (GTK_TABLE (table2), search_city_entry, 1, 2, 1, 2,
                    (GtkAttachOptions) (GTK_EXPAND | GTK_SHRINK | GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);

  frame3 = gtk_frame_new (_("Company"));
  gtk_widget_ref (frame3);
  gtk_object_set_data_full (GTK_OBJECT (search_dialog), "frame3", frame3,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (frame3);
  gtk_box_pack_start (GTK_BOX (vbox9), frame3, TRUE, TRUE, 0);
  gtk_container_set_border_width (GTK_CONTAINER (frame3), 3);

  table3 = gtk_table_new (2, 4, FALSE);
  gtk_widget_ref (table3);
  gtk_object_set_data_full (GTK_OBJECT (search_dialog), "table3", table3,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (table3);
  gtk_container_add (GTK_CONTAINER (frame3), table3);
  gtk_container_set_border_width (GTK_CONTAINER (table3), 3);
  gtk_table_set_row_spacings (GTK_TABLE (table3), 3);
  gtk_table_set_col_spacings (GTK_TABLE (table3), 3);

  label15 = gtk_label_new (_("Name:"));
  gtk_widget_ref (label15);
  gtk_object_set_data_full (GTK_OBJECT (search_dialog), "label15", label15,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (label15);
  gtk_table_attach (GTK_TABLE (table3), label15, 0, 1, 0, 1,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_misc_set_alignment (GTK_MISC (label15), 1, 0.5);

  label16 = gtk_label_new (_("Department:"));
  gtk_widget_ref (label16);
  gtk_object_set_data_full (GTK_OBJECT (search_dialog), "label16", label16,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (label16);
  gtk_table_attach (GTK_TABLE (table3), label16, 0, 1, 1, 2,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_misc_set_alignment (GTK_MISC (label16), 1, 0.5);

  label17 = gtk_label_new (_("Position:"));
  gtk_widget_ref (label17);
  gtk_object_set_data_full (GTK_OBJECT (search_dialog), "label17", label17,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (label17);
  gtk_table_attach (GTK_TABLE (table3), label17, 2, 3, 0, 1,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_misc_set_alignment (GTK_MISC (label17), 1, 0.5);

  search_company_name_entry = gtk_entry_new ();
  gtk_widget_ref (search_company_name_entry);
  gtk_object_set_data_full (GTK_OBJECT (search_dialog), "search_company_name_entry", search_company_name_entry,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (search_company_name_entry);
  gtk_table_attach (GTK_TABLE (table3), search_company_name_entry, 1, 2, 0, 1,
                    (GtkAttachOptions) (GTK_EXPAND | GTK_SHRINK | GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);

  search_company_position_entry = gtk_entry_new ();
  gtk_widget_ref (search_company_position_entry);
  gtk_object_set_data_full (GTK_OBJECT (search_dialog), "search_company_position_entry", search_company_position_entry,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (search_company_position_entry);
  gtk_table_attach (GTK_TABLE (table3), search_company_position_entry, 3, 4, 0, 1,
                    (GtkAttachOptions) (GTK_EXPAND | GTK_SHRINK | GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);

  search_company_department_entry = gtk_entry_new ();
  gtk_widget_ref (search_company_department_entry);
  gtk_object_set_data_full (GTK_OBJECT (search_dialog), "search_company_department_entry", search_company_department_entry,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (search_company_department_entry);
  gtk_table_attach (GTK_TABLE (table3), search_company_department_entry, 1, 2, 1, 2,
                    (GtkAttachOptions) (GTK_EXPAND | GTK_SHRINK | GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);

  label46 = gtk_label_new (_("Name"));
  gtk_widget_ref (label46);
  gtk_object_set_data_full (GTK_OBJECT (search_dialog), "label46", label46,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (label46);
  gtk_notebook_set_tab_label (GTK_NOTEBOOK (search_notebook), gtk_notebook_get_nth_page (GTK_NOTEBOOK (search_notebook), 0), label46);

  table6 = gtk_table_new (2, 2, FALSE);
  gtk_widget_ref (table6);
  gtk_object_set_data_full (GTK_OBJECT (search_dialog), "table6", table6,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (table6);
  gtk_container_add (GTK_CONTAINER (search_notebook), table6);
  gtk_container_set_border_width (GTK_CONTAINER (table6), 3);
  gtk_table_set_row_spacings (GTK_TABLE (table6), 3);
  gtk_table_set_col_spacings (GTK_TABLE (table6), 3);

  search_email_entry = gtk_entry_new ();
  gtk_widget_ref (search_email_entry);
  gtk_object_set_data_full (GTK_OBJECT (search_dialog), "search_email_entry", search_email_entry,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (search_email_entry);
  gtk_table_attach (GTK_TABLE (table6), search_email_entry, 1, 2, 0, 1,
                    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);

  label53 = gtk_label_new (_("Email Address:"));
  gtk_widget_ref (label53);
  gtk_object_set_data_full (GTK_OBJECT (search_dialog), "label53", label53,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (label53);
  gtk_table_attach (GTK_TABLE (table6), label53, 0, 1, 0, 1,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_misc_set_alignment (GTK_MISC (label53), 1, 0.5);

  label47 = gtk_label_new (_("Email"));
  gtk_widget_ref (label47);
  gtk_object_set_data_full (GTK_OBJECT (search_dialog), "label47", label47,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (label47);
  gtk_notebook_set_tab_label (GTK_NOTEBOOK (search_notebook), gtk_notebook_get_nth_page (GTK_NOTEBOOK (search_notebook), 1), label47);

  table7 = gtk_table_new (2, 2, FALSE);
  gtk_widget_ref (table7);
  gtk_object_set_data_full (GTK_OBJECT (search_dialog), "table7", table7,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (table7);
  gtk_container_add (GTK_CONTAINER (search_notebook), table7);
  gtk_container_set_border_width (GTK_CONTAINER (table7), 3);
  gtk_table_set_row_spacings (GTK_TABLE (table7), 3);
  gtk_table_set_col_spacings (GTK_TABLE (table7), 3);

  search_uin_entry = gtk_entry_new ();
  gtk_widget_ref (search_uin_entry);
  gtk_object_set_data_full (GTK_OBJECT (search_dialog), "search_uin_entry", search_uin_entry,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (search_uin_entry);
  gtk_table_attach (GTK_TABLE (table7), search_uin_entry, 1, 2, 0, 1,
                    (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);

  label52 = gtk_label_new (_("UIN #:"));
  gtk_widget_ref (label52);
  gtk_object_set_data_full (GTK_OBJECT (search_dialog), "label52", label52,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (label52);
  gtk_table_attach (GTK_TABLE (table7), label52, 0, 1, 0, 1,
                    (GtkAttachOptions) (GTK_FILL),
                    (GtkAttachOptions) (0), 0, 0);
  gtk_misc_set_alignment (GTK_MISC (label52), 1, 0.5);

  label48 = gtk_label_new (_("UIN #"));
  gtk_widget_ref (label48);
  gtk_object_set_data_full (GTK_OBJECT (search_dialog), "label48", label48,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (label48);
  gtk_notebook_set_tab_label (GTK_NOTEBOOK (search_notebook), gtk_notebook_get_nth_page (GTK_NOTEBOOK (search_notebook), 2), label48);

  vbuttonbox2 = gtk_vbutton_box_new ();
  gtk_widget_ref (vbuttonbox2);
  gtk_object_set_data_full (GTK_OBJECT (search_dialog), "vbuttonbox2", vbuttonbox2,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (vbuttonbox2);
  gtk_box_pack_start (GTK_BOX (hbox19), vbuttonbox2, FALSE, TRUE, 0);
  gtk_button_box_set_layout (GTK_BUTTON_BOX (vbuttonbox2), GTK_BUTTONBOX_START);

  search_button = gtk_licq_button(GTK_LICQ_BUTTON_SEARCHL);
  gtk_widget_ref (search_button);
  gtk_object_set_data_full (GTK_OBJECT (search_dialog), "search_button", search_button,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (search_button);
  gtk_container_add (GTK_CONTAINER (vbuttonbox2), search_button);
  GTK_WIDGET_SET_FLAGS (search_button, GTK_CAN_DEFAULT);

  search_clear_button = gtk_licq_button(GTK_LICQ_BUTTON_CLEARL);
  gtk_widget_ref (search_clear_button);
  gtk_object_set_data_full (GTK_OBJECT (search_dialog), "search_clear_button", search_clear_button,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (search_clear_button);
  gtk_container_add (GTK_CONTAINER (vbuttonbox2), search_clear_button);
  GTK_WIDGET_SET_FLAGS (search_clear_button, GTK_CAN_DEFAULT);

  search_cancel_button = gtk_licq_button(GTK_LICQ_BUTTON_CANCELL);
  gtk_widget_ref (search_cancel_button);
  gtk_object_set_data_full (GTK_OBJECT (search_dialog), "search_cancel_button", search_cancel_button,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (search_cancel_button);
  gtk_container_add (GTK_CONTAINER (vbuttonbox2), search_cancel_button);
  GTK_WIDGET_SET_FLAGS (search_cancel_button, GTK_CAN_DEFAULT);

  scrolledwindow_search_clist = gtk_scrolled_window_new (NULL, NULL);
  gtk_widget_ref (scrolledwindow_search_clist);
  gtk_object_set_data_full (GTK_OBJECT (search_dialog), "scrolledwindow_search_clist", scrolledwindow_search_clist,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (scrolledwindow_search_clist);
  gtk_box_pack_start (GTK_BOX (vbox10), scrolledwindow_search_clist, TRUE, TRUE, 0);
  gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (scrolledwindow_search_clist), GTK_POLICY_NEVER, GTK_POLICY_AUTOMATIC);

  search_results_clist = gtk_clist_new (4);
  gtk_widget_ref (search_results_clist);
  gtk_object_set_data_full (GTK_OBJECT (search_dialog), "search_results_clist", search_results_clist,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (search_results_clist);
  gtk_container_add (GTK_CONTAINER (scrolledwindow_search_clist), search_results_clist);
  gtk_clist_set_column_width (GTK_CLIST (search_results_clist), 0, 80);
  gtk_clist_set_column_width (GTK_CLIST (search_results_clist), 1, 80);
  gtk_clist_set_column_width (GTK_CLIST (search_results_clist), 2, 80);
  gtk_clist_set_column_width (GTK_CLIST (search_results_clist), 3, 80);
  gtk_clist_set_selection_mode (GTK_CLIST (search_results_clist), GTK_SELECTION_EXTENDED);
  gtk_clist_column_titles_show (GTK_CLIST (search_results_clist));

  label54 = gtk_label_new (_("Alias"));
  gtk_widget_ref (label54);
  gtk_object_set_data_full (GTK_OBJECT (search_dialog), "label54", label54,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (label54);
  gtk_clist_set_column_widget (GTK_CLIST (search_results_clist), 0, label54);

  label55 = gtk_label_new (_("UIN"));
  gtk_widget_ref (label55);
  gtk_object_set_data_full (GTK_OBJECT (search_dialog), "label55", label55,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (label55);
  gtk_clist_set_column_widget (GTK_CLIST (search_results_clist), 1, label55);

  label56 = gtk_label_new (_("Name"));
  gtk_widget_ref (label56);
  gtk_object_set_data_full (GTK_OBJECT (search_dialog), "label56", label56,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (label56);
  gtk_clist_set_column_widget (GTK_CLIST (search_results_clist), 2, label56);

  label57 = gtk_label_new (_("Email"));
  gtk_widget_ref (label57);
  gtk_object_set_data_full (GTK_OBJECT (search_dialog), "label57", label57,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (label57);
  gtk_clist_set_column_widget (GTK_CLIST (search_results_clist), 3, label57);

  hbox20 = gtk_hbox_new (FALSE, 0);
  gtk_widget_ref (hbox20);
  gtk_object_set_data_full (GTK_OBJECT (search_dialog), "hbox20", hbox20,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (hbox20);
  gtk_box_pack_start (GTK_BOX (vbox10), hbox20, FALSE, TRUE, 0);

  search_notify_checkbutton = gtk_check_button_new_with_label (_("Notify user when adding to list"));
  gtk_widget_ref (search_notify_checkbutton);
  gtk_object_set_data_full (GTK_OBJECT (search_dialog), "search_notify_checkbutton", search_notify_checkbutton,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (search_notify_checkbutton);
  gtk_box_pack_start (GTK_BOX (hbox20), search_notify_checkbutton, TRUE, TRUE, 0);

  hbuttonbox2 = gtk_hbutton_box_new ();
  gtk_widget_ref (hbuttonbox2);
  gtk_object_set_data_full (GTK_OBJECT (search_dialog), "hbuttonbox2", hbuttonbox2,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (hbuttonbox2);
  gtk_box_pack_start (GTK_BOX (hbox20), hbuttonbox2, FALSE, TRUE, 0);
  gtk_button_box_set_layout (GTK_BUTTON_BOX (hbuttonbox2), GTK_BUTTONBOX_END);
  gtk_button_box_set_spacing (GTK_BUTTON_BOX (hbuttonbox2), 0);

  search_add_user_button = gtk_licq_button(GTK_LICQ_BUTTON_ADDUSER);
  gtk_widget_ref (search_add_user_button);
  gtk_object_set_data_full (GTK_OBJECT (search_dialog), "search_add_user_button", search_add_user_button,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (search_add_user_button);
  gtk_container_add (GTK_CONTAINER (hbuttonbox2), search_add_user_button);
  gtk_widget_set_sensitive (search_add_user_button, FALSE);
  GTK_WIDGET_SET_FLAGS (search_add_user_button, GTK_CAN_DEFAULT);

  done_button = gtk_licq_button(GTK_LICQ_BUTTON_DONE);
  gtk_widget_ref (done_button);
  gtk_object_set_data_full (GTK_OBJECT (search_dialog), "done_button", done_button,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (done_button);
  gtk_container_add (GTK_CONTAINER (hbuttonbox2), done_button);
  GTK_WIDGET_SET_FLAGS (done_button, GTK_CAN_DEFAULT);

  frame22 = gtk_frame_new (NULL);
  gtk_widget_ref (frame22);
  gtk_object_set_data_full (GTK_OBJECT (search_dialog), "frame22", frame22,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (frame22);
  gtk_box_pack_start (GTK_BOX (vbox10), frame22, FALSE, TRUE, 0);
  gtk_frame_set_shadow_type (GTK_FRAME (frame22), GTK_SHADOW_IN);

  search_result_label = gtk_label_new ("");
  gtk_widget_ref (search_result_label);
  gtk_object_set_data_full (GTK_OBJECT (search_dialog), "search_result_label", search_result_label,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (search_result_label);
  gtk_container_add (GTK_CONTAINER (frame22), search_result_label);
  gtk_misc_set_alignment (GTK_MISC (search_result_label), 0, 0.5);
  gtk_misc_set_padding (GTK_MISC (search_result_label), 3, 0);

  gtk_signal_connect (GTK_OBJECT (search_dialog), "destroy",
                      GTK_SIGNAL_FUNC (on_search_dialog_destroy_event),
                      NULL);
  gtk_signal_connect (GTK_OBJECT (search_dialog), "show",
                      GTK_SIGNAL_FUNC (on_search_dialog_show),
                      NULL);
  gtk_signal_connect (GTK_OBJECT (search_dialog), "delete_event",
                      GTK_SIGNAL_FUNC (on_search_dialog_delete_event),
                      NULL);
  gtk_signal_connect (GTK_OBJECT (search_dialog), "destroy",
                      GTK_SIGNAL_FUNC (on_window_destroy_get_posdata),
                      &configuration.pos_search_dialog);
  gtk_signal_connect (GTK_OBJECT (search_dialog), "show",
                      GTK_SIGNAL_FUNC (on_window_show_set_posdata),
                      &configuration.pos_search_dialog);
  gtk_signal_connect (GTK_OBJECT (search_age_to_spinbutton), "changed",
                      GTK_SIGNAL_FUNC (on_search_age_to_spinbutton_changed),
                      NULL);
  gtk_signal_connect (GTK_OBJECT (search_age_from_spinbutton), "changed",
                      GTK_SIGNAL_FUNC (on_search_age_from_spinbutton_changed),
                      NULL);
  gtk_signal_connect (GTK_OBJECT (search_button), "clicked",
                      GTK_SIGNAL_FUNC (on_search_button_clicked),
                      NULL);
  gtk_signal_connect (GTK_OBJECT (search_clear_button), "clicked",
                      GTK_SIGNAL_FUNC (on_search_clear_button_clicked),
                      NULL);
  gtk_signal_connect (GTK_OBJECT (search_cancel_button), "clicked",
                      GTK_SIGNAL_FUNC (on_search_cancel_button_clicked),
                      NULL);
  gtk_signal_connect (GTK_OBJECT (search_results_clist), "click_column",
                      GTK_SIGNAL_FUNC (on_search_results_clist_click_column),
                      NULL);
  gtk_signal_connect (GTK_OBJECT (search_results_clist), "select_row",
                      GTK_SIGNAL_FUNC (on_search_results_clist_select_row),
                      NULL);
  gtk_signal_connect (GTK_OBJECT (search_add_user_button), "clicked",
                      GTK_SIGNAL_FUNC (on_search_add_user_button_clicked),
                      NULL);
  gtk_signal_connect_object (GTK_OBJECT (done_button), "clicked",
                             GTK_SIGNAL_FUNC (gtk_widget_destroy),
                             GTK_OBJECT (search_dialog));

  return search_dialog;
}

void
on_search_button_clicked               (GtkButton       *button,
                                        gpointer         user_data)
{
    GtkWidget       *search_notebook=lookup_widget(GTK_WIDGET(button),
            "search_notebook");

    switch(gtk_notebook_get_current_page(GTK_NOTEBOOK(search_notebook))) {
        case 0:
            execute_search(SEARCH_BY_WHITEPAGES);
            break;
        case 1:
            execute_search(SEARCH_BY_EMAIL);
            break;
        case 2:
            execute_search(SEARCH_BY_UIN);
            break;
    }
}


void
on_search_clear_button_clicked         (GtkButton       *button,
                                        gpointer         user_data)
{
    GtkWidget       *search_results_clist=lookup_widget(GTK_WIDGET(button),
            "search_results_clist");
    GtkWidget       *search_alias_entry=lookup_widget(GTK_WIDGET(button),
            "search_alias_entry");
    GtkWidget       *search_firstname_entry=lookup_widget(GTK_WIDGET(button),
            "search_firstname_entry");
    GtkWidget       *search_gender_combo_entry=lookup_widget(GTK_WIDGET(button),
            "search_gender_combo_entry");
    GtkWidget       *search_lastname_entry=lookup_widget(GTK_WIDGET(button),
            "search_lastname_entry");
    GtkWidget       *search_age_from_spinbutton=lookup_widget(GTK_WIDGET(button),
            "search_age_from_spinbutton");
    GtkWidget       *search_age_to_spinbutton=lookup_widget(GTK_WIDGET(button),
            "search_age_to_spinbutton");
    GtkWidget       *search_language_combo_entry=lookup_widget(GTK_WIDGET(button),
            "search_language_combo_entry");
    GtkWidget       *search_country_combo_entry=lookup_widget(GTK_WIDGET(button),
            "search_country_combo_entry");
    GtkWidget       *search_city_entry=lookup_widget(GTK_WIDGET(button),
            "search_city_entry");
    GtkWidget       *search_state_entry=lookup_widget(GTK_WIDGET(button),
            "search_state_entry");
    GtkWidget       *search_company_name_entry=lookup_widget(GTK_WIDGET(button),
            "search_company_name_entry");
    GtkWidget       *search_company_position_entry=lookup_widget(GTK_WIDGET(button),
            "search_company_position_entry");
    GtkWidget       *search_company_department_entry=lookup_widget(GTK_WIDGET(button),
            "search_company_department_entry");
    GtkWidget       *search_email_entry=lookup_widget(GTK_WIDGET(button),
            "search_email_entry");
    GtkWidget       *search_uin_entry=lookup_widget(GTK_WIDGET(button),
            "search_uin_entry");

    gtk_editable_delete_text(GTK_EDITABLE(search_alias_entry),0,-1);
    gtk_editable_delete_text(GTK_EDITABLE(search_firstname_entry),0,-1);
    gtk_editable_delete_text(GTK_EDITABLE(search_lastname_entry),0,-1);
    gtk_editable_delete_text(GTK_EDITABLE(search_city_entry),0,-1);
    gtk_editable_delete_text(GTK_EDITABLE(search_state_entry),0,-1);
    gtk_editable_delete_text(GTK_EDITABLE(search_company_name_entry),0,-1);
    gtk_editable_delete_text(GTK_EDITABLE(search_company_position_entry),0,-1);
    gtk_editable_delete_text(GTK_EDITABLE(search_company_department_entry),0,-1);
    gtk_editable_delete_text(GTK_EDITABLE(search_email_entry),0,-1);
    gtk_editable_delete_text(GTK_EDITABLE(search_uin_entry),0,-1);

    gtk_spin_button_set_value(GTK_SPIN_BUTTON(search_age_from_spinbutton),0);
    gtk_spin_button_set_value(GTK_SPIN_BUTTON(search_age_to_spinbutton),0);

    gtk_entry_set_text(GTK_ENTRY(search_gender_combo_entry),_("Unspecified"));
    gtk_entry_set_text(GTK_ENTRY(search_country_combo_entry),
            gCountries[0].szName);
    gtk_entry_set_text(GTK_ENTRY(search_language_combo_entry),
            gLanguages[0].szName);
   
    gtk_clist_clear(GTK_CLIST(search_results_clist));
}


void
on_search_cancel_button_clicked        (GtkButton       *button,
                                        gpointer         user_data)
{
    gtk_widget_destroy(search_dialog);
}

#endif  /*  USE_GNOME */

bool
search_eventhandler_callback(ICQEvent *event, gpointer data)
{
    gchar           *result[5];
    GtkWidget       *search_results_clist;
    GtkWidget       *search_result_label,*search_button;
    unsigned long   *search_tag;

    if(!search_dialog||!(search_tag=(unsigned long*)gtk_object_get_data(
                    GTK_OBJECT(search_dialog), "search_tag"))) {
        return FALSE;
    }
    gbug("search_dialog %p search_tag=%p \n",search_dialog,search_tag);
    if(search_dialog&&event&&event->Equals(*search_tag)) {
        search_results_clist=lookup_widget(search_dialog, 
                "search_results_clist");
        
        /* Add the results the same way as in the QT gui, no matter what
         * the event->Result() is */
        if (event->SearchAck()&&event->SearchAck()->Uin() != 0) {
            gbug("Adding search result\n");
            result[0]=(char*)event->SearchAck()->Alias();
            result[1]=g_strdup_printf("%ld",event->SearchAck()->Uin());
            result[2]=g_strdup_printf("%s %s",
                    event->SearchAck()->FirstName(),
                    event->SearchAck()->LastName());
            result[3]=(char*)event->SearchAck()->Email();
            result[4]=NULL;

            gtk_clist_append(GTK_CLIST(search_results_clist),result);
            g_free(result[1]);
            g_free(result[2]);
        }
        switch(event->Result()) {
            case EVENT_SUCCESS:
                search_result_label=lookup_widget(search_dialog, 
                        "search_result_label");
                if(event->SearchAck()&&event->SearchAck()->More()) {
                    gtk_label_set(GTK_LABEL(search_result_label),
                            _("Search Complete (Too many matches, narrow search)"));
                }else {
                    gtk_label_set(GTK_LABEL(search_result_label),
                            _("Search Complete"));
                }
                gtk_object_set_data(GTK_OBJECT(search_dialog),"search_tag",NULL);
                free(search_tag);
#ifndef USE_GNOME
                search_button=lookup_widget(search_dialog,"search_button");
                gtk_widget_set_sensitive(search_button,TRUE);
#endif
                break;
            case EVENT_ACKED:
                break;
            default:
                search_result_label=lookup_widget(search_dialog, 
                        "search_result_label");
                gtk_label_set(GTK_LABEL(search_result_label),
                        _("Search Failed"));
                gtk_object_set_data(GTK_OBJECT(search_dialog),"search_tag",NULL);
                free(search_tag);
#ifndef USE_GNOME
                search_button=lookup_widget(search_dialog,"search_button");
                gtk_widget_set_sensitive(search_button,TRUE);
#endif
                break;
        }
    }
    return FALSE;
}


void
on_search_age_from_spinbutton_changed  (GtkEditable     *editable,
                                        gpointer         user_data)
{
    GtkWidget       *search_age_to_spinbutton=lookup_widget(
            GTK_WIDGET(editable),"search_age_to_spinbutton");

    if(gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(editable))>
            gtk_spin_button_get_value_as_int(
                GTK_SPIN_BUTTON(search_age_to_spinbutton))) {
        gtk_spin_button_set_value(GTK_SPIN_BUTTON(search_age_to_spinbutton),
                gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(editable)));
    }
}


void
on_search_age_to_spinbutton_changed    (GtkEditable     *editable,
                                        gpointer         user_data)
{
    GtkWidget       *search_age_from_spinbutton=lookup_widget(
            GTK_WIDGET(editable),"search_age_from_spinbutton");

    if(gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(editable))<
            gtk_spin_button_get_value_as_int(
                GTK_SPIN_BUTTON(search_age_from_spinbutton))) {
        gtk_spin_button_set_value(GTK_SPIN_BUTTON(search_age_from_spinbutton),
                gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(editable)));
    }
}


void
on_search_results_clist_click_column   (GtkCList        *clist,
                                        gint             column,
                                        gpointer         user_data)
{
    if(clist->sort_column==column) {
        if(clist->sort_type==GTK_SORT_ASCENDING) {
            gtk_clist_set_sort_type(clist,GTK_SORT_DESCENDING);
        }else {
            gtk_clist_set_sort_type(clist,GTK_SORT_ASCENDING);
        }
    }else {
        gtk_clist_set_sort_column(clist,column);
    }
    gtk_clist_sort(clist);
}


gboolean
on_search_dialog_delete_event          (GtkWidget       *widget,
                                        GdkEvent        *event,
                                        gpointer         user_data)
{
    gtk_widget_destroy(search_dialog);
    return FALSE;
}


void
on_search_dialog_show                  (GtkWidget       *widget,
                                        gpointer         user_data)
{
    GtkWidget       *search_results_clist=lookup_widget(search_dialog,
            "search_results_clist");
    GtkWidget       *search_country_combo=lookup_widget(search_dialog,
            "search_country_combo");
    GtkWidget       *search_language_combo=lookup_widget(search_dialog,
            "search_language_combo");
    GtkWidget       *search_gender_combo=lookup_widget(search_dialog,
            "search_gender_combo");
    GtkWidget       *search_gender_combo_entry=lookup_widget(search_dialog,
            "search_gender_combo_entry");
#ifdef USE_GNOME
    GtkWidget       *search_uin_entry=lookup_widget(search_dialog,
            "search_uin_entry");
    GtkWidget       *search_white_radiobutton=lookup_widget(search_dialog,
            "search_white_radiobutton");
    GtkWidget       *search_druid=lookup_widget(search_dialog,
            "search_druid");
#endif  /*  USE_GNOME */
    GList           *countries=NULL,*languages=NULL,*genders=NULL;

    int             i;


    gtk_clist_set_auto_sort(GTK_CLIST(search_results_clist),TRUE);
    register_eventcallback((eventhandler_callback)search_eventhandler_callback,
            NULL);
#ifdef USE_GNOME
    gtk_widget_set_sensitive(search_uin_entry,FALSE);
    gtk_signal_connect(GTK_OBJECT(GTK_BUTTON(GNOME_DRUID(search_druid)->finish)),
            "clicked", GTK_SIGNAL_FUNC (on_search_finish_button_clicked), NULL);
    gnome_druid_set_show_finish(GNOME_DRUID(search_druid),FALSE);
    gnome_druid_set_buttons_sensitive(GNOME_DRUID(search_druid),
            FALSE,TRUE,TRUE);
#endif  /*  USE_GNOME */

    for(i=0;i<NUM_COUNTRIES;i++) {
        countries=g_list_append(countries,gCountries[i].szName);
    }
    gtk_combo_set_popdown_strings(GTK_COMBO(search_country_combo),countries);
    for(i=0;i<NUM_LANGUAGES;i++) {
        languages=g_list_append(languages,gLanguages[i].szName);
    }
    gtk_combo_set_popdown_strings(GTK_COMBO(search_language_combo),languages);

    genders=g_list_append(genders,(gpointer) _("Male"));
    genders=g_list_append(genders,(gpointer) _("Female"));
    genders=g_list_append(genders,(gpointer) _("Unspecified"));
    gtk_combo_set_popdown_strings(GTK_COMBO(search_gender_combo),genders);
    gtk_entry_set_text(GTK_ENTRY(search_gender_combo_entry),_("Unspecified"));
#ifdef USE_GNOME
    gtk_label_set_justify(GTK_LABEL(GTK_BIN(search_white_radiobutton)->child),
            GTK_JUSTIFY_LEFT);
#endif  /*  USE_GNOME */
}


void
on_search_dialog_destroy_event         (GtkObject       *object,
                                        gpointer         user_data)
{
    unregister_eventcallback(search_eventhandler_callback,NULL);
    search_dialog=NULL;
}

void
on_search_add_user_button_clicked      (GtkButton       *button,
                                        gpointer         user_data)
{
    GtkWidget	*search_results_clist = lookup_widget(search_dialog,
            "search_results_clist");
    GtkWidget   *search_notify_checkbutton=lookup_widget(search_dialog,
            "search_notify_checkbutton");
    GList       *selection;
    char        *uin;
    int         row;
    unsigned long numerical_uin;
    
    selection=GTK_CLIST(search_results_clist)->selection;
    while(selection) {
        row=GPOINTER_TO_INT(selection->data);
        gtk_clist_get_text(GTK_CLIST(search_results_clist),row,1,&uin);
        sscanf(uin,"%ld",&numerical_uin);
        if(!gUserManager.FetchUser(numerical_uin,LOCK_N)) {
            licq_daemon->AddUserToList(numerical_uin);
            if(gtk_toggle_button_get_active(
                        GTK_TOGGLE_BUTTON(search_notify_checkbutton))) {
                licq_daemon->icqAlertUser(numerical_uin);
            }
        }
        selection=g_list_next(selection);
    }
}

void
on_search_results_clist_select_row     (GtkCList        *clist,
                                        gint             row,
                                        gint             column,
                                        GdkEvent        *event,
                                        gpointer         user_data)
{
#ifndef USE_GNOME
    char            *uin;
    unsigned long   numerical_uin;
    GtkWidget       *search_add_user_button=lookup_widget(
            GTK_WIDGET(clist),"search_add_user_button");
    
    gtk_clist_get_text(GTK_CLIST(clist),row,1,&uin);
    sscanf(uin,"%ld",&numerical_uin);
    if(!gUserManager.FetchUser(numerical_uin,LOCK_N)) {
        gtk_widget_set_sensitive(search_add_user_button,TRUE);
    }else {
        gtk_widget_set_sensitive(search_add_user_button,FALSE);
    }
#endif  /*  USE_GNOME */
}

void
execute_search                         (gint            search_by)
{
    GtkWidget       *search_alias_entry=lookup_widget(search_dialog,
            "search_alias_entry");
    GtkWidget       *search_firstname_entry=lookup_widget(search_dialog,
            "search_firstname_entry");
    GtkWidget       *search_lastname_entry=lookup_widget(search_dialog,
            "search_lastname_entry");
    GtkWidget       *search_age_from_spinbutton=lookup_widget(search_dialog,
            "search_age_from_spinbutton");
    GtkWidget       *search_age_to_spinbutton=lookup_widget(search_dialog,
            "search_age_to_spinbutton");
    GtkWidget       *search_city_entry=lookup_widget(search_dialog,
            "search_city_entry");
    GtkWidget       *search_state_entry=lookup_widget(search_dialog,
            "search_state_entry");
    GtkWidget       *search_company_name_entry=lookup_widget(search_dialog,
            "search_company_name_entry");
    GtkWidget       *search_company_position_entry=lookup_widget(search_dialog,
            "search_company_position_entry");
    GtkWidget       *search_company_department_entry=lookup_widget(search_dialog,
            "search_company_department_entry");
    GtkWidget       *search_gender_combo_entry=lookup_widget(search_dialog,
            "search_gender_combo_entry");
    GtkWidget       *search_language_combo_entry=lookup_widget(search_dialog,
            "search_language_combo_entry");
    GtkWidget       *search_country_combo_entry=lookup_widget(search_dialog,
            "search_country_combo_entry");
    GtkWidget       *search_result_label=lookup_widget(search_dialog,
            "search_result_label");
    GtkWidget       *search_results_clist=lookup_widget(search_dialog,
            "search_results_clist");
    GtkWidget       *search_email_entry=lookup_widget(search_dialog,
            "search_email_entry");
    GtkWidget       *search_uin_entry=lookup_widget(search_dialog,
            "search_uin_entry");
#ifndef USE_GNOME
    GtkWidget       *search_button=lookup_widget(search_dialog,
            "search_button");
#endif
    char            language=LANGUAGE_UNSPECIFIED, gender;
    unsigned short  countrycode=COUNTRY_UNSPECIFIED,minage,maxage;
    char            *alias,*firstname,*lastname,*city,*state,*company_name,
                    *company_position,*company_department,*tmp;
    unsigned long   uin;
    SLanguage       *lstruct;
    SCountry        *cstruct;    
    unsigned long   *tag=NULL;

    gtk_clist_clear(GTK_CLIST(search_results_clist));
    tag=(unsigned long*)malloc(sizeof(unsigned long));
    switch(search_by) {
        case SEARCH_BY_WHITEPAGES:
            alias=gtk_editable_get_chars(GTK_EDITABLE(search_alias_entry),0,-1);
            firstname=gtk_editable_get_chars(
                    GTK_EDITABLE(search_firstname_entry),0,-1);
            lastname=gtk_editable_get_chars(
                    GTK_EDITABLE(search_lastname_entry),0,-1);
            city=gtk_editable_get_chars(GTK_EDITABLE(search_city_entry),0,-1);
            state=gtk_editable_get_chars(GTK_EDITABLE(search_state_entry),0,-1);
            company_name=gtk_editable_get_chars(
                    GTK_EDITABLE(search_company_name_entry),0,-1);
            company_position=gtk_editable_get_chars(
                    GTK_EDITABLE(search_company_position_entry),0,-1);
            company_department=gtk_editable_get_chars(
                    GTK_EDITABLE(search_company_department_entry),0,-1);

            tmp=gtk_editable_get_chars(
                    GTK_EDITABLE(search_gender_combo_entry),0,-1);
            if(!strcmp(tmp,_("Male"))) {
                gender=GENDER_MALE;
            } if(!strcmp(tmp,_("Female"))) {
                gender=GENDER_FEMALE;
            }else {
                gender=GENDER_UNSPECIFIED;
            }
            g_free(tmp);

            tmp=gtk_editable_get_chars(
                    GTK_EDITABLE(search_language_combo_entry),0,-1);
            if((lstruct=(SLanguage*)GetLanguageByName(tmp))) {
                language=lstruct->nCode;
            }
            g_free(tmp);

            tmp=gtk_editable_get_chars(
                    GTK_EDITABLE(search_country_combo_entry),0,-1);
            if((cstruct=(SCountry*)GetCountryByName(tmp))) {
                countrycode=cstruct->nCode;
            }
            g_free(tmp);

            minage=gtk_spin_button_get_value_as_int(
                    GTK_SPIN_BUTTON(search_age_from_spinbutton));
            maxage=gtk_spin_button_get_value_as_int(
                    GTK_SPIN_BUTTON(search_age_to_spinbutton));
            *tag=licq_daemon->icqSearchWhitePages(firstname,lastname,alias,
                    "" /*email*/,
                    minage,maxage,gender,language,city,state,countrycode,
                    company_name,company_department,company_position,FALSE);
            g_free(alias);
            g_free(firstname);
            g_free(lastname);
            g_free(city);
            g_free(state);
            g_free(company_name);
            g_free(company_position);
            g_free(company_department);
            break;
        case SEARCH_BY_UIN:
            tmp=gtk_entry_get_text(GTK_ENTRY(search_uin_entry));
            if (tmp&&sscanf(tmp,"%ld",&uin)==1&&uin>0) {
                *tag=licq_daemon->icqSearchByUin(uin);
            }
            break;
        case SEARCH_BY_EMAIL:
            tmp=gtk_entry_get_text(GTK_ENTRY(search_email_entry));
            *tag=licq_daemon->icqSearchByInfo("","","",tmp);
            break;
    }
    if(*tag) {
        gtk_label_set(GTK_LABEL(search_result_label),
                _("Searching ..."));
#ifndef USE_GNOME
        gtk_widget_set_sensitive(search_button,FALSE);
#endif
    }else {
        gtk_label_set(GTK_LABEL(search_result_label),
                _("Search failed"));
    }
    gtk_object_set_data(GTK_OBJECT(search_dialog),"search_tag",(gpointer)tag);
}

void
show_search_dialog()
{
    if(!search_dialog) {
        search_dialog = create_search_dialog();
        gtk_widget_show(search_dialog);
    }else {
        gdk_window_raise(search_dialog->window);
    }
}
