#ifndef SEARCH_DIALOG_H_INCLUDED
#define SEARCH_DIALOG_H_INCLUDED

#include "gtk-gui.h"

#define SEARCH_BY_WHITEPAGES    0
#define SEARCH_BY_UIN           1
#define SEARCH_BY_EMAIL         2

void
show_search_dialog();

void
execute_search                         (gint            search_by);

void
on_search_age_from_spinbutton_changed  (GtkEditable     *editable,
                                        gpointer         user_data);

void
on_search_age_to_spinbutton_changed    (GtkEditable     *editable,
                                        gpointer         user_data);

void
on_search_results_clist_click_column   (GtkCList        *clist,
                                        gint             column,
                                        gpointer         user_data);

void
on_search_email_radiobutton_toggled    (GtkToggleButton *togglebutton,
                                        gpointer         user_data);

void
on_search_uin_radiobutton_toggled      (GtkToggleButton *togglebutton,
                                        gpointer         user_data);

void
on_search_white_radiobutton_toggled    (GtkToggleButton *togglebutton,
                                        gpointer         user_data);

gboolean
on_search_dialog_delete_event          (GtkWidget       *widget,
                                        GdkEvent        *event,
                                        gpointer         user_data);

void
on_search_dialog_show                  (GtkWidget       *widget,
                                        gpointer         user_data);


GtkWidget*
create_search_dialog                   (void);

void
on_search_finish_button_clicked        (GtkButton       *button,
                                        gpointer         user_data);

void
on_search_dialog_destroy_event         (GtkObject       *object,
                                        gpointer         user_data);

void
on_search_add_user_button_clicked      (GtkButton       *button,
                                        gpointer         user_data);

void
on_search_results_clist_select_row     (GtkCList        *clist,
                                        gint             row,
                                        gint             column,
                                        GdkEvent        *event,
                                        gpointer         user_data);
#ifdef USE_GNOME
void
on_search_druid_cancel                 (GnomeDruid      *gnomedruid,
                                        gpointer         user_data);

gboolean
on_druidpagestandard_select_method_next
                                        (GnomeDruidPage  *gnomedruidpage,
                                        gpointer         arg1,
                                        gpointer         user_data);

gboolean
on_druidpagestandard_white_next        (GnomeDruidPage  *gnomedruidpage,
                                        gpointer         arg1,
                                        gpointer         user_data);

gboolean
on_druidpagestandard_results_back      (GnomeDruidPage  *gnomedruidpage,
                                        gpointer         arg1,
                                        gpointer         user_data);

void
on_druidpagestandard_white_prepare     (GnomeDruidPage  *gnomedruidpage,
                                        gpointer         arg1,
                                        gpointer         user_data);

void
on_druidpagestandard_results_prepare   (GnomeDruidPage  *gnomedruidpage,
                                        gpointer         arg1,
                                        gpointer         user_data);

void
on_druidpagestandard_select_method_prepare
                                        (GnomeDruidPage  *gnomedruidpage,
                                        gpointer         arg1,
                                        gpointer         user_data);

void
on_druidpagestandard_results_finish    (GnomeDruidPage  *gnomedruidpage,
                                        gpointer         arg1,
                                        gpointer         user_data);
#else   /*  USE_GNOME */

void
on_search_button_clicked               (GtkButton       *button,
                                        gpointer         user_data);

void
on_search_clear_button_clicked         (GtkButton       *button,
                                        gpointer         user_data);
void
on_search_cancel_button_clicked        (GtkButton       *button,
                                        gpointer         user_data);

#endif  /*  USE_GNOME */
#endif  /*  SEARCH_DIALOG_H_INCLUDED */
