#include "gtk-gui.h"

#include <ctype.h>
#include <sys/stat.h>
#include <unistd.h>
#include <gdk/gdkkeysyms.h>

#include "interface.h"
#include "send_event_window.h"
#include "view_event_window.h"
#include "transfer_dialog.h"
#include "multiuser_chat.h"
#include "functions.h"
#include "contactlist.h"
#include "multiuser_chat.h"
#include "spell.h"

bool send_through_server_stick = true;

void
on_multimess_checkbutton_toggled       (GtkToggleButton *togglebutton,
                                        gpointer         user_data)
{
    GtkWidget       *multimess_scrolledwindow=lookup_widget(
            GTK_WIDGET(togglebutton),"multimess_scrolledwindow");
    GtkWidget       *alias_clist, *send_event_window;
    unsigned long   uin=gtk_widget_get_active_uin(GTK_WIDGET(togglebutton));
    gint            row;
    static gint     size_before_toggle=0;


    send_event_window=gtk_widget_get_toplevel(GTK_WIDGET(togglebutton));
    if(gtk_toggle_button_get_active(togglebutton)) {
        alias_clist=create_contactlist(multimess_scrolledwindow,FALSE);
        size_before_toggle=send_event_window->allocation.width;
        gtk_widget_set_usize(multimess_scrolledwindow,
                main_window->allocation.width,
                multimess_scrolledwindow->allocation.height);
        gtk_widget_show_all(multimess_scrolledwindow);
        real_refresh_contactlist(0,alias_clist,FALSE,NULL);
        find_user_data(uin,&row);
        if(row>=0) {
            gtk_clist_select_row(GTK_CLIST(alias_clist),row,-1);
        }
        gdk_window_resize(send_event_window->window,
                send_event_window->allocation.width+main_window->allocation.width,
                send_event_window->allocation.height);
    }else {
        alias_clist=lookup_widget(GTK_WIDGET(multimess_scrolledwindow),
                "alias_clist");
        gtk_widget_destroy(alias_clist);
        gtk_widget_hide(multimess_scrolledwindow);
        
        gdk_window_resize(send_event_window->window,size_before_toggle,
                send_event_window->allocation.height);
    }
}


void
on_send_through_server_checkbutton_toggled
                                        (GtkToggleButton *togglebutton,
                                        gpointer         user_data)
{
    GtkWidget       *pixmap; 
    GtkWidget       *toplevel;
    ICQUser         *user;
    bool            secure = false;
    unsigned long   uin;
    
            
    uin=gtk_widget_get_active_uin(GTK_WIDGET(togglebutton));
        
    user = (uin > 0)?gUserManager.FetchUser(uin,LOCK_R):
        gUserManager.FetchOwner(LOCK_R);
    if (user != NULL) {
        secure = user->Secure();
        
        if (send_through_server_stick) {
            user->SetSendServer(gtk_toggle_button_get_active(togglebutton));
        }
        gUserManager.DropUser(user);
    }
        
    toplevel=gtk_widget_get_toplevel(GTK_WIDGET(togglebutton));
    if((pixmap=lookup_widget(toplevel,"security_pixmap"))) {
        if (secure && (gtk_toggle_button_get_active(togglebutton))) {
            gtk_pixmap_set(GTK_PIXMAP(pixmap),
                    not_secure_on_pixmap.pix,not_secure_on_pixmap.mask);
        }else if (secure && (!gtk_toggle_button_get_active(togglebutton))){
            gtk_pixmap_set(GTK_PIXMAP(pixmap),
                    secure_on_pixmap.pix,secure_on_pixmap.mask);
        }else {
            gtk_pixmap_set(GTK_PIXMAP(pixmap),
                    secure_off_pixmap.pix,secure_off_pixmap.mask);
        }
    }
}


void
on_send_send_cancel_button_clicked     (GtkButton       *button,
                                        gpointer         user_data)
{
    GtkWidget   *toplevel=gtk_widget_get_toplevel(GTK_WIDGET(button));
    cancel_all_window_pending_events(toplevel);
}


void
on_send_send_button_clicked            (GtkButton       *button,
                                        gpointer         user_data)
{
    GtkWidget           *send_text = lookup_widget(GTK_WIDGET(button),
            "send_text");
    GtkWidget           *file_text = lookup_widget(GTK_WIDGET(button),
            "file_text");
    GtkWidget           *filename_entry = lookup_widget(GTK_WIDGET(button),
            "filename_entry");
    GtkWidget           *send_event_window = gtk_widget_get_toplevel(
            GTK_WIDGET(button));
    GtkWidget           *send_through_server_checkbutton = lookup_widget(
            GTK_WIDGET(button), "send_through_server_checkbutton");
    GtkWidget           *urgent_checkbutton = lookup_widget(GTK_WIDGET(button),
            "urgent_checkbutton");
    GtkWidget           *multimess_checkbutton=lookup_widget(GTK_WIDGET(button),
            "multimess_checkbutton");
    GtkWidget           *alias_clist=NULL;

    unsigned long       uin=gtk_widget_get_active_uin(GTK_WIDGET(button));
    gboolean            send_server=FALSE, urgent=FALSE, send_contactlist=FALSE;
    GList               *selection;
    userdata_t          *udata;
    gint                send_type,ret=0;
    gboolean            split=FALSE;
    ssize_t             slen=0;
    gchar               *umsg,*buttons[4];
    
    send_server=gtk_toggle_button_get_active(
            GTK_TOGGLE_BUTTON(send_through_server_checkbutton));
    if(GPOINTER_TO_INT(user_data)) {
        switch(GPOINTER_TO_INT(user_data)) {
            case SEND_OVERRIDE_URGENT:
                urgent=TRUE;
                break;
            case SEND_OVERRIDE_LIST:
                send_contactlist=TRUE; 
                break;
        }
    }else {
        urgent=gtk_toggle_button_get_active(
                GTK_TOGGLE_BUTTON(urgent_checkbutton));
    }

    send_type=GPOINTER_TO_INT(gtk_object_get_data(GTK_OBJECT(send_event_window),
                "current_send_type"));

    if(send_type==-1) {
        gbug("on_send_send_button_clicked: 'current_send_type' unset\n");
        return;
    }

    if((gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(multimess_checkbutton))||
            gtk_toggle_button_get_active(
                GTK_TOGGLE_BUTTON(send_through_server_checkbutton)))&&
            (send_type==SEND_MESSAGE||send_type==SEND_URL||send_type==SEND_CONTACTS)) {
        switch(send_type) {
            case SEND_MESSAGE:
                slen=get_message_expanded_length(GTK_TEXT(send_text));
                break;
            case SEND_URL:
                slen=get_message_expanded_length(GTK_TEXT(file_text));
                break;
            case SEND_CONTACTS:
                slen=0;
                break;
            default:
                gbug("on_send_send_button_clicked: multimess with bad type?!\n");
                return;
        }
        if(slen>MAX_MESSAGE_SIZE) {
            umsg=g_strdup_printf(_("The message is %d chars, this is %d longer\n"
                    "then can be transmitted via the icq server.\n\n"
                    "Do you wish to cancel sending, truncate the message or\n"
                    "split it into several small enough parts?\n"),
                    slen,slen-MAX_MESSAGE_SIZE);
            buttons[0]=_("Cancel");
            buttons[1]=_("Truncate");
            buttons[2]=_("Split");
            buttons[3]=NULL;
            switch(showtextdialogcustom(_("Message to long"),
                    umsg,buttons)) {
                case 0:
                    g_free(umsg);
                    return ;
                    break;
                case 1:
                    split=FALSE;
                    break;
                case 2:
                    split=TRUE;
                    break;
            }
            g_free(umsg);
        }
    }
    if(gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(multimess_checkbutton))) {
        alias_clist=lookup_widget(send_event_window,"alias_clist");
        gtk_widget_set_sensitive(alias_clist,FALSE);
        selection=GTK_CLIST(alias_clist)->selection;
        if(selection) {
            while(selection) {
                udata=(userdata_t*)gtk_clist_get_row_data(GTK_CLIST(alias_clist),
                        GPOINTER_TO_INT(selection->data)); 
                ret+=dispatch_send(send_event_window,send_type,udata->uin,
                            TRUE,urgent,split,send_contactlist,TRUE);
                selection=g_list_next(selection);
            }
        }else {
            gtk_widget_set_sensitive(alias_clist,TRUE);
            return ;
        }
    }else {
        ret=dispatch_send(send_event_window,send_type,uin,send_server,
                urgent,split, send_contactlist,FALSE);
    }

    if (ret>0) {
        register_eventcallback(send_result_handler,send_event_window);
        setup_widgets_for_send(FALSE,send_event_window);
    } else {
        gbug("on_send_send_button_clicked: send failed\n");
    }
}


void
on_send_close_button_clicked           (GtkButton       *button,
                                        gpointer         user_data)
{
    GtkWidget *send_event_window=gtk_widget_get_toplevel(GTK_WIDGET(button));

    shutdown_send_event_window(send_event_window,FALSE);
}

void
on_contacts_to_select_clist_drag_data_get
                               (GtkWidget *contacts_to_select_clist,
                                GdkDragContext *drag_context,
                                GtkSelectionData *data,
                                guint info,
                                guint time,
                                gpointer user_data)
{
    gchar           *tosend=NULL;
    GList           *selection;
    unsigned long   uin;
    gchar           temp[13];

    gbug("on_contacts_to_select_clist_drag_data_get: enter\n");
    selection=GTK_CLIST(contacts_to_select_clist)->selection;
    if(selection) {
            /*  12 is maxlength of 32-bit value+1 for the comma */ 
        if(!(tosend=(gchar*)malloc(12*g_list_length(selection)+1))) {
            return;
        }
        *tosend=0;
        while(selection) {
            uin=*(unsigned long*)gtk_clist_get_row_data(
                        GTK_CLIST(contacts_to_select_clist),
                        GPOINTER_TO_INT(selection->data));

            selection=g_list_next(selection);
            if(selection) {
                sprintf(temp,"%ld,",uin);
            }else {
                sprintf(temp,"%ld",uin);
            }
            strcat(tosend,temp);
        }
        gbug("on_contacts_to_select_clist_drag_data_get: sent '%s'\n",tosend);
        gtk_selection_data_set(data, data->target, 8, (guchar*)tosend, 
                strlen(tosend));
        free(tosend);
    }
}

void
on_contacts_to_send_clist_drag_data_received
                               (GtkWidget *contacts_to_send_clist,
                                GdkDragContext *drag_context,
                                gint x,             
                                gint y,
                                GtkSelectionData *data,
                                guint info,                  
                                guint time,         
                                gpointer user_data)
{
    gboolean        added=FALSE,exists;
    gchar           *parse,*text[2];
    unsigned long   uin,*thisuin;
    ICQUser         *user;
    gint            row;
    GList           *sel,*check;
    GtkWidget       *contacts_to_select_clist=lookup_widget(
            contacts_to_send_clist,"contacts_to_select_clist");

    gbug("on_contacts_to_send_clist_drag_data_received: enter\n");
    if ((data->length >= 0) && (data->format == 8) && (data->data) )
    {
        gtk_clist_freeze(GTK_CLIST(contacts_to_send_clist));
        gtk_clist_freeze(GTK_CLIST(contacts_to_select_clist));
        text[1]=NULL;
        parse=(gchar *)data->data;
        while(parse&&*parse) {
            while(*parse&&isspace(*parse)||*parse==',') {
                parse++;
            }
            if(*parse) {
                if(sscanf(parse,"%ld",&uin)) {
                    if((user=gUserManager.FetchUser(uin,LOCK_R))) {
                        sel=GTK_CLIST(contacts_to_send_clist)->row_list;
                        exists=FALSE;
                        while(sel) {
                            if(sel->data&&((GtkCListRow*)(sel->data))->data&&
                                    *((unsigned long*)((GtkCListRow*)(sel->data))->data)==uin)
                            {
                                exists=TRUE;
                                break;
                            }
                            sel=g_list_next(sel);
                        }
                        if(!exists) {
                            added=TRUE;
                            text[0]=user->GetAlias();
                            thisuin=(unsigned long*)malloc(sizeof(unsigned long));
                            *thisuin=uin;
                            check=GTK_CLIST(contacts_to_select_clist)->row_list;
                            for(row=0;check;row++,check=g_list_next(check)) {
                                if(check->data
                                        &&((GtkCListRow*)(check->data))->data
                                        &&*((unsigned long*)((GtkCListRow*)(check->data))->data)==uin) 
                                {
                                    gtk_clist_remove(GTK_CLIST(contacts_to_select_clist),row);
                                    break;
                                }
                            }
                            row=gtk_clist_append(
                                    GTK_CLIST(contacts_to_send_clist),
                                    text);
                            gtk_clist_set_row_data_full(
                                    GTK_CLIST(contacts_to_send_clist),row,
                                    (gpointer)thisuin,destroy_notify_free);
                        }
                        gUserManager.DropUser(user);
                    }
                }
                parse=strchr(parse,',');
            }
        }
        gtk_clist_thaw(GTK_CLIST(contacts_to_send_clist));
        gtk_clist_thaw(GTK_CLIST(contacts_to_select_clist));
        gtk_clist_sort(GTK_CLIST(contacts_to_send_clist));
        gtk_drag_finish (drag_context, added, added, time);
        return;
    }
}

void
on_send_event_window_show              (GtkWidget       *widget,
                                        gpointer         user_data)
{
    GtkWidget       *send_send_cancel_button=lookup_widget(widget, 
            "send_send_cancel_button");
    GtkWidget       *alias_clist=lookup_widget(main_window,"alias_clist");
    GtkWidget       *contacts_to_send_clist=lookup_widget(widget,
            "contacts_to_send_clist");
    GtkWidget       *contacts_to_select_clist=lookup_widget(widget,
            "contacts_to_select_clist");
    GtkWidget       *send_send_button=lookup_widget(widget,
            "send_send_button");
    GtkWidget       *send_through_server_checkbutton=lookup_widget(widget,
            "send_through_server_checkbutton");
    GtkWidget       *urgent_checkbutton = lookup_widget(widget,
            "urgent_checkbutton");
    GtkWidget       *multimess_checkbutton = lookup_widget(widget,
            "multimess_checkbutton");
    GtkWidget       *send_text=lookup_widget(widget,"send_text");
    GtkWidget       *chat_text=lookup_widget(widget,"chat_text");
    GtkWidget       *file_text=lookup_widget(widget,"file_text");
    GtkWidget       *send_select_font_background_button=lookup_widget(widget,
            "send_select_font_background_button");
    GtkWidget       *send_select_font_foreground_button=lookup_widget(widget,
            "send_select_font_foreground_button");
    GtkWidget       *status_close_button=lookup_widget(widget,
            "status_close_button");
    GtkWidget       *pmap;
    GtkTooltips     *tips;
           
    ICQUser         *user;
     
    GtkStyle        *style=NULL;
    GdkFont         *font;
    unsigned long   uin;

    uin=gtk_widget_get_active_uin(widget);
    user = (uin > 0)?gUserManager.FetchUser(uin,LOCK_R):
        gUserManager.FetchOwner(LOCK_R);

    gbug("%s\n",(user->Secure())?"Secure channel used!":"No secure channel to user");
    gUserManager.DropUser(user);

    gtk_widget_set_sensitive(send_send_cancel_button,FALSE);

    if (global_editor_font) {
        gtk_widget_ensure_style(send_text);
        style = gtk_style_copy(gtk_widget_get_style(send_text));
        gdk_font_unref(style->font);
        style->font = global_editor_font;
        gtk_widget_set_style(send_text,style);

        gtk_widget_ensure_style(chat_text);
        style = gtk_style_copy(gtk_widget_get_style(chat_text));
        gdk_font_unref(style->font);
        style->font = global_editor_font;
        gtk_widget_set_style(chat_text,style);

        gtk_widget_ensure_style(file_text);
        style = gtk_style_copy(gtk_widget_get_style(file_text));
        gdk_font_unref(style->font);
        style->font = global_editor_font;
        gtk_widget_set_style(file_text,style);
    }

    if(*configuration.contactfont&&
            (style=gtk_widget_get_style(alias_clist))) {
        gtk_style_ref(style);
        gtk_widget_ensure_style(contacts_to_send_clist);
        gtk_widget_ensure_style(contacts_to_select_clist);
        gtk_widget_set_style(contacts_to_send_clist,style);
        gtk_widget_set_style(contacts_to_select_clist,style);
    }

    gtk_clist_set_compare_func(GTK_CLIST(contacts_to_send_clist),
            (GtkCListCompareFunc)gtk_clist_compare_string);
    gtk_clist_set_compare_func(GTK_CLIST(contacts_to_select_clist),
            (GtkCListCompareFunc)gtk_clist_compare_string);
    gtk_clist_set_sort_column(GTK_CLIST(contacts_to_send_clist),0);
    gtk_clist_set_sort_column(GTK_CLIST(contacts_to_select_clist),0);
    
    gtk_drag_source_set(contacts_to_select_clist,
            GDK_BUTTON1_MASK,target_table,1,
            (GdkDragAction)(GDK_ACTION_COPY | GDK_ACTION_MOVE));
    gtk_drag_source_set_icon(contacts_to_select_clist,
           gtk_widget_get_colormap(main_window),status_pixmap_contacts.pix,
                           status_pixmap_contacts.mask);
    gtk_drag_dest_set(contacts_to_send_clist,
            GTK_DEST_DEFAULT_ALL,target_table,1,
            (GdkDragAction)(GDK_ACTION_COPY | GDK_ACTION_MOVE));
    gtk_signal_connect(GTK_OBJECT(contacts_to_select_clist),
            "drag_data_get",
            GTK_SIGNAL_FUNC(on_contacts_to_select_clist_drag_data_get),NULL);
    gtk_signal_connect(GTK_OBJECT(contacts_to_send_clist),
            "drag_data_received",
            GTK_SIGNAL_FUNC(on_contacts_to_send_clist_drag_data_received),NULL);

    GtkAccelGroup *acc = gtk_accel_group_new();
    gtk_accel_group_add(acc,GDK_Return,
            (GdkModifierType)(GDK_CONTROL_MASK|GDK_LOCK_MASK),
            GTK_ACCEL_VISIBLE, GTK_OBJECT(send_send_button),
            "clicked");
    gtk_accel_group_add(acc,GDK_Return,GDK_CONTROL_MASK,GTK_ACCEL_VISIBLE,
            GTK_OBJECT(send_send_button),
            "clicked");
    gtk_accel_group_add(acc,GDK_s,GDK_CONTROL_MASK,GTK_ACCEL_VISIBLE,
            GTK_OBJECT(send_through_server_checkbutton),
            "clicked");
    gtk_accel_group_add(acc,GDK_s,
            (GdkModifierType)(GDK_CONTROL_MASK|GDK_LOCK_MASK),
            GTK_ACCEL_VISIBLE, GTK_OBJECT(send_through_server_checkbutton),
            "clicked");

    gtk_accel_group_add(acc,GDK_q,GDK_CONTROL_MASK,GTK_ACCEL_VISIBLE,
            GTK_OBJECT(status_close_button),
            "clicked");
    gtk_accel_group_add(acc,GDK_q,
            (GdkModifierType)(GDK_CONTROL_MASK|GDK_LOCK_MASK),
            GTK_ACCEL_VISIBLE, GTK_OBJECT(status_close_button),
            "clicked");
    //Suboptimal
    gtk_accel_group_add(acc,GDK_i,
            (GdkModifierType)(GDK_CONTROL_MASK|GDK_LOCK_MASK),
            GTK_ACCEL_VISIBLE, GTK_OBJECT(urgent_checkbutton),
            "clicked");
    gtk_accel_group_add(acc,GDK_i,GDK_CONTROL_MASK,GTK_ACCEL_VISIBLE,
            GTK_OBJECT(urgent_checkbutton),
            "clicked");
    //Suboptimal
    gtk_accel_group_add(acc,GDK_g,
            (GdkModifierType)(GDK_CONTROL_MASK|GDK_LOCK_MASK),
            GTK_ACCEL_VISIBLE, GTK_OBJECT(multimess_checkbutton),
            "clicked");
    gtk_accel_group_add(acc,GDK_g,GDK_CONTROL_MASK,GTK_ACCEL_VISIBLE,
            GTK_OBJECT(multimess_checkbutton),
            "clicked");
    
    gtk_window_add_accel_group(GTK_WINDOW(widget),acc);
    
    gtk_text_set_word_wrap(GTK_TEXT(send_text),TRUE); 
    gtk_text_set_word_wrap(GTK_TEXT(file_text),TRUE); 
    gtk_text_set_word_wrap(GTK_TEXT(chat_text),TRUE); 

    pmap=gtk_pixmap_new(select_foreground_pixmap.pix,
            select_foreground_pixmap.mask);
    gtk_widget_ref(pmap);
    gtk_widget_show(pmap);
    gtk_container_add(GTK_CONTAINER(send_select_font_foreground_button),pmap);
    gtk_object_set_data_full(GTK_OBJECT(widget),"foreground_pix",pmap,
            (GtkDestroyNotify) gtk_widget_unref);

    pmap=gtk_pixmap_new(select_background_pixmap.pix,
            select_background_pixmap.mask);
    gtk_widget_ref(pmap);
    gtk_widget_show(pmap);
    gtk_container_add(GTK_CONTAINER(send_select_font_background_button),pmap);
    gtk_object_set_data_full(GTK_OBJECT(widget),"background_pix",pmap,
            (GtkDestroyNotify) gtk_widget_unref);

    tips=gtk_tooltips_new();
    gtk_tooltips_set_tip(GTK_TOOLTIPS(tips),send_select_font_foreground_button,
            _("Select message foreground color"),NULL);
    gtk_tooltips_set_tip(GTK_TOOLTIPS(tips),send_select_font_background_button,
            _("Select message background color"),NULL);
}


gboolean
on_send_event_window_delete_event      (GtkWidget       *widget,
                                        GdkEvent        *event,
                                        gpointer         user_data)
{
    gbug("on_send_event_window_delete_event: DELETE\n");
    shutdown_send_event_window(widget,FALSE);
    return FALSE;
}

int 
shutdown_send_event_window             (GtkWidget   *event_window,
                                        gboolean    closeview)
{
    userdata_t      *userdata;
    unsigned long   uin=gtk_widget_get_active_uin(event_window);
    ICQUser         *user;
    GtkWidget       *status_autoclose_checkbutton;
    
    unregister_eventcallback(send_result_handler,event_window);
    cancel_all_window_pending_events(event_window);
    shutdown_statusbar(event_window);

    userdata=find_user_data(uin,NULL);            

    if (userdata != NULL) {
        gbug("shutdown_send_event_window: found %ld and removing window\n",
                uin);
        userdata->send_event_window=NULL;
        if(closeview) {
            if(gtk_object_get_data(GTK_OBJECT(event_window),
                            "from_view_window")&&
                    (user=gUserManager.FetchUser(uin,LOCK_R))) {
                if(!user->NewMessages()&&userdata->view_event_window) {
                    gUserManager.DropUser(user);
                    status_autoclose_checkbutton=lookup_widget(
                            userdata->view_event_window,
                            "status_autoclose_checkbutton");
                    if(gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(
                                    status_autoclose_checkbutton))) {
                        shutdown_view_event_window(userdata->view_event_window); 
                    }
                }else {
                    gUserManager.DropUser(user);
                }
            }
        }
    }
#ifdef USE_PSPELL
    shutdown_spelling(event_window);
#endif
    gtk_widget_destroy(event_window);

    return 0;
}

gboolean
unregister_event        (ICQEvent    *event,
                         GtkWidget   *toplevel,
                         gint        *refcnt) 
{
    GList           *rows=NULL,*ufloat,*rfloat,*mfloat;
    GtkWidget       *contactlist=lookup_widget(main_window,"alias_clist");
    GtkWidget       *multimess_checkbutton=lookup_widget(toplevel,
            "multimess_checkbutton");
    GtkWidget       *alias_clist = NULL;
    GtkWidget       *main_alias_clist = NULL;
    userdata_t      *userdata;
    gint            doexit=0,dounmark;
    gint            row=0;
    unsigned long   event_uin;
                                

    *refcnt=0;
    rows=GTK_CLIST(contactlist)->row_list;
    while(rows) {
        if(rows->data&&((GtkCListRow*)(rows->data))->data) {
            userdata=(userdata_t*)((GtkCListRow*)(rows->data))->data;
            rfloat=userdata->send_events;
            while(rfloat) {
                ufloat=rfloat;
                rfloat=g_list_next(rfloat);
                if(((send_eventdata_t*)ufloat->data)->toplevel_sender==toplevel) {
                    doexit++;
                    if(event->Equals(((send_eventdata_t*)ufloat->data)->tag)) {
                        (*refcnt)++;
                        gbug("unregister_event: unregister %ld\n",event->Uin());
                        userdata->send_events=g_list_remove(
                                userdata->send_events,
                                ufloat->data);
                        free(ufloat->data); 
                        if(gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(
                                        multimess_checkbutton))&&
                                (event->Result()==EVENT_SUCCESS||
                                 event->Result()==EVENT_ACKED)) {
                            dounmark=0;
                            mfloat=userdata->send_events;
                            while(mfloat) {
                                if(((send_eventdata_t*)mfloat->data)->toplevel_sender==toplevel) {

                                    dounmark++;
                                    break;
                                }
                                mfloat=g_list_next(mfloat);
                            }
                            if(!dounmark) {
                                gbug("unregister_event: unselected %d\n",row);
                                alias_clist=lookup_widget(toplevel, 
                                        "alias_clist");
                                gtk_clist_unselect_row(
                                        GTK_CLIST(alias_clist),
                                        row,-1);
                            }

                        }
                        doexit--;
                    }
                }
            }
        }
        row++;
        rows=g_list_next(rows);
    }
    
    main_alias_clist=lookup_widget(main_window, "alias_clist");
    rows=(GList*)gtk_object_get_data(GTK_OBJECT(main_alias_clist),"invisible_users");;
    while(rows) {
        if(rows->data) {
            userdata=(userdata_t*)(rows->data);
            rfloat=userdata->send_events;
            while(rfloat) {
                ufloat=rfloat;
                rfloat=g_list_next(rfloat);
                if(((send_eventdata_t*)ufloat->data)->toplevel_sender==toplevel) {
                    doexit++;
                    if(event->Equals(((send_eventdata_t*)ufloat->data)->tag)) {
                        (*refcnt)++;
                        gbug("unregister_event: unregister %ld\n",event->Uin());
                        userdata->send_events=g_list_remove(
                                userdata->send_events,
                                ufloat->data);
                        free(ufloat->data); 
                        doexit--;
                    }
                }
            }
        }
        row++;
        rows=g_list_next(rows);
    }
    gbug("unregister_event: got %d more\n",doexit);
    return (doexit?FALSE:TRUE);
}

bool  
send_result_handler(ICQEvent *event, gpointer data)
{
    GtkWidget   *status_autoclose_checkbutton = lookup_widget(GTK_WIDGET(data),
            "status_autoclose_checkbutton");
    GtkWidget   *send_through_server_checkbutton = lookup_widget(GTK_WIDGET(data),
            "send_through_server_checkbutton");

    GtkWidget   *transfer_dialog, *chat_dialog, *event_autoresponse_dialog;
    GtkWidget   *auto_away_text, *alias_clist;
    GtkWidget   *multimess_checkbutton=lookup_widget(GTK_WIDGET(data),
            "multimess_checkbutton");
    GtkWidget   *send_send_button=lookup_widget(GTK_WIDGET(data),
            "send_send_button");
    gboolean    doclose=TRUE;
    gchar       *msg,*buttons[4];
    ICQUser     *user = NULL;
    ICQOwner    *owner = NULL;
    gint        refcnt,isok=0,aredone=0;
    unsigned long   uin;
    userdata_t  *uinfo;
    if (event == NULL) {
        gbug("Sending Error, event==NULL!\n");
        return FALSE;
    }
   
    doclose=unregister_event(event,gtk_widget_get_toplevel(GTK_WIDGET(data)),
            &refcnt);

    if(!refcnt) {
        gbug("send_result_handler: NOT my event\n");
        return FALSE;
    }
    gbug("send_result_handler: enter\n");

    uin=gtk_widget_get_active_uin(GTK_WIDGET(data));
    uinfo=find_user_data(uin,NULL);

    switch(event->Result()) {
        case EVENT_ACKED:
        case EVENT_SUCCESS:
            gbug("send_result_handler: EVENT_SUCCESS/ACKED: event->Result()==%d, isok==%d\n", 
                    event->Result(),isok);
            isok++;
            break;
        case EVENT_ERROR:
            gbug("send_result_handler: EVENT_ERROR\n");
            break;
        case EVENT_FAILED:
            gbug("send_result_handler: EVENT_FAILED\n");
            break;
        case EVENT_TIMEDOUT:
            gbug("send_result_handler: EVENT_TIMEDOUT\n");
            break;
        case EVENT_CANCELLED:
            gbug("send_result_handler: EVENT_CANCELLED\n");
            doclose=FALSE;
            break;
        default:
            gbug("Unknown event occured with result %d\n",event->Result());
            break;
    }

    if(gtk_toggle_button_get_active(
                GTK_TOGGLE_BUTTON(multimess_checkbutton))) {
        if(doclose) {
            alias_clist=lookup_widget(GTK_WIDGET(data),"alias_clist");
            if(GTK_CLIST(alias_clist)->selection||
                    !gtk_toggle_button_get_active(
                        GTK_TOGGLE_BUTTON(status_autoclose_checkbutton))) {
                aredone++;
                gtk_widget_set_sensitive(alias_clist,TRUE);
            }else {
                shutdown_send_event_window(GTK_WIDGET(data),TRUE);
                return TRUE;
            }
        }
    }else {
        refcnt=doclose;
        if(!isok) {
            if (    event->Result() != EVENT_CANCELLED && 
                    event->Command() == ICQ_CMDxTCP_START && 
                    (event->SubCommand() == ICQ_CMDxSUB_MSG ||
                     event->SubCommand() == ICQ_CMDxSUB_URL)){
                if (!gtk_toggle_button_get_active(
                            GTK_TOGGLE_BUTTON(send_through_server_checkbutton))){
                    if (configuration.autosendthroughserver||
                            showtextdialog(_("Send trough server?"),
                                _("Send direct failed!\nSend through server?"),
                                DLGBUTTON_YES|DLGBUTTON_NO) == DLGBUTTON_YES){
                        send_through_server_stick = false;
                        gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(
                                    send_through_server_checkbutton),TRUE);
                        on_send_send_button_clicked(
                                GTK_BUTTON(send_send_button),
                                NULL);
                        send_through_server_stick = true;
                        return TRUE;
                    }else {
                        doclose=FALSE;
                        aredone++;
                    }
                }else {
                    aredone++;
                }
            }else {
                aredone++;
            }
        } else { 
            if (event->Command() == ICQ_CMDxTCP_START) {
                CUserEvent *ue = event->UserEvent();

                if(event->SubResult() == ICQ_TCPxACK_RETURN) {
                    //inform user to use Urgent!
                    user =  gUserManager.FetchUser(event->Uin(), LOCK_R);
                    msg=g_strdup_printf(_("%s is in %s mode:\n%s\n"),
                            user->GetAlias(),
                            status_string(user->Status(),false), 
                            user->AutoResponse());
                    gUserManager.DropUser(user);
                    buttons[0]=_("Cancel");
                    buttons[1]=_("Send urgent");
                    buttons[2]=_("Send to contactlist");
                    buttons[3]=NULL;
                    cancel_all_window_pending_events(GTK_WIDGET(data));
                    switch(showtextdialogcustom(_("Unable to send message"),
                                msg,buttons)) {
                        case 0:
                            break;
                        case 1:
                            on_send_send_button_clicked(
                                    GTK_BUTTON(send_send_button),
                                    GINT_TO_POINTER(SEND_OVERRIDE_URGENT));
                            break;
                        case 2:
                            on_send_send_button_clicked(
                                    GTK_BUTTON(send_send_button),
                                    GINT_TO_POINTER(SEND_OVERRIDE_LIST));
                            break;
                    }
                    g_free(msg);
                    doclose = FALSE;
                    refcnt=TRUE;
                } else if (event->SubResult() ==ICQ_TCPxACK_REFUSE) {
                    user =  gUserManager.FetchUser(event->Uin(), LOCK_R);
                    msg=g_strdup_printf(_("%s refused %s, send through server"),
                            user->GetAlias(),EventDescription(ue));
                    gUserManager.DropUser(user);
                    showokdialog(_("Refused"), msg);
                    g_free(msg);
                    doclose = FALSE;
                } else if (event->SubCommand() == ICQ_CMDxSUB_CHAT || 
                        event->SubCommand() == ICQ_CMDxSUB_FILE) {
                    //Send file...
                    struct CExtendedAck *ea = event->ExtendedAck();
                    if (ea == NULL || ue == NULL) {
                        //Internal error
                        return FALSE;
                    }
                    if (!ea->Accepted()) {
                        //Refused chat or file...
                        user =  gUserManager.FetchUser(event->Uin(), LOCK_R);
                        msg=g_strdup_printf(_("%s with %s refused:\n%s"),
                                EventDescription(ue),
                                user->GetAlias(),ea->Response());
                        gUserManager.DropUser(user);
                        showokdialog(_("Refused"), msg);
                        g_free(msg);
                    } else {
                        switch (event->SubCommand()) {
                            case ICQ_CMDxSUB_CHAT: 
                                {
                                    CEventChat *ce = (CEventChat *)ue;

                                    // If we requested a join, no need to do anything
                                    if (ce->Port() == 0)  {
                                        //Begin chat!
                                        chat_dialog = create_multichat_window();
                                        gtk_widget_show(chat_dialog);
                                        owner = gUserManager.FetchOwner(LOCK_R);
                                        chat_StartAsClient(ea->Port(), 
                                                event->Uin(),owner->GetAlias(),
                                                chat_dialog);
                                        gUserManager.DropOwner();
                                    }
                                }
                                break;
                            case ICQ_CMDxSUB_FILE:
                                CEventFile *f = (CEventFile *)ue;
                                transfer_dialog = create_transfer_dialog();
                                gtk_widget_show(transfer_dialog);
                                file_send(event->Uin(), f->Filename(), ea->Port(),transfer_dialog);
                                break;
                        }
                    }
                } else { //not file or chat...
                    user =  gUserManager.FetchUser(event->Uin(), LOCK_R);
                    if (user && user->Away() && user->ShowAwayMsg() && user->AutoResponse() ) {
                        if(!uinfo || !(uinfo->last_away_mess) || strcmp(uinfo->last_away_mess, user->AutoResponse())) {
                            event_autoresponse_dialog = 
                                create_event_autoresponse_dialog();
                            gtk_widget_set_active_uin(event_autoresponse_dialog,
                                    event->Uin());
                            auto_away_text = lookup_widget(
                                    GTK_WIDGET(event_autoresponse_dialog),
                                    "auto_away_text");
                            gtk_text_insert(GTK_TEXT(auto_away_text),
                                    NULL,NULL,NULL,
                                    user->AutoResponse(),
                                    strlen(user->AutoResponse()));
                            gtk_widget_set_active_uin(event_autoresponse_dialog,
                                    uin);
                            gtk_widget_show(event_autoresponse_dialog);
                            if(uinfo&&uinfo->last_away_mess) {
                                g_free(uinfo->last_away_mess);
                                uinfo->last_away_mess=NULL;
                            }
                        }
                    }
                    gUserManager.DropUser(user);
                }
            } else if (event->Command() == ICQ_CMDxSND_THRUxSERVER) {
                gbug("ICQ_CMDxSND_THRUxSERVER: Done\n");
            }
            gbug("refcnt==%d\n",refcnt);
            if(refcnt) {
                aredone++;
            }else {
                return FALSE;
            }
        }
    }
    if(aredone) {
        if ((gtk_toggle_button_get_active(
                        GTK_TOGGLE_BUTTON(status_autoclose_checkbutton)))
                &&doclose){
            shutdown_send_event_window(GTK_WIDGET(data),TRUE);
        } else {
            setup_widgets_for_send(TRUE,GTK_WIDGET(data));
        }
        return TRUE;
    }
    return FALSE;
}

void
setup_widgets_for_send          (gboolean   after,
                                 GtkWidget  *toplevel)
{
    GtkWidget       *file_text=lookup_widget(toplevel,"file_text"); 
    GtkWidget       *chat_text=lookup_widget(toplevel,"chat_text"); 
    GtkWidget       *send_text=lookup_widget(toplevel,"send_text"); 
    GtkWidget       *contacts_to_select_clist=lookup_widget(toplevel,
            "contacts_to_select_clist"); 
    GtkWidget       *contacts_to_send_clist=lookup_widget(toplevel,
            "contacts_to_send_clist");
    GtkWidget       *add_all_contacts_button=lookup_widget(toplevel,
            "add_all_contacts_button"); 
    GtkWidget       *add_one_contact_button=lookup_widget(toplevel,
            "add_one_contact_button");
    GtkWidget       *remove_all_contacts_button=lookup_widget(toplevel,
            "remove_all_contacts_button"); 
    GtkWidget       *remove_one_contact_button=lookup_widget(toplevel,
            "remove_one_contact_button");
    GtkWidget       *chatsession_optionmenu=lookup_widget(toplevel,
            "chatsession_optionmenu"); 
    GtkWidget       *filename_browse_button=lookup_widget(toplevel,
            "filename_browse_button"); 
    GtkWidget       *filename_entry=lookup_widget(toplevel,"filename_entry");
    GtkWidget       *multimess_checkbutton=lookup_widget(toplevel,
            "multimess_checkbutton"); 
    GtkWidget       *send_through_server_checkbutton=lookup_widget(toplevel,
            "send_through_server_checkbutton");
    GtkWidget       *urgent_checkbutton=lookup_widget(toplevel,
            "urgent_checkbutton"); 
    GtkWidget       *send_send_cancel_button=lookup_widget(toplevel,
            "send_send_cancel_button"); 
    GtkWidget       *send_send_button=lookup_widget(toplevel,"send_send_button");
    GtkWidget       *status_chat_button=lookup_widget(toplevel,
            "status_chat_button"); 
    GtkWidget       *status_contacts_button=lookup_widget(toplevel,
            "status_contacts_button");
    GtkWidget       *status_file_button=lookup_widget(toplevel,
            "status_file_button");
    GtkWidget       *status_message_button=lookup_widget(toplevel,
            "status_message_button"); 
    GtkWidget       *status_secure_button=lookup_widget(toplevel,
            "status_secure_button"); 
    GtkWidget       *status_url_button=lookup_widget(toplevel,
            "status_url_button");

    gboolean    notafter=after?FALSE:TRUE;

    gtk_widget_set_sensitive(file_text,after);
    gtk_widget_set_sensitive(chat_text,after);
    gtk_widget_set_sensitive(send_text,after);

    gtk_widget_set_sensitive(contacts_to_select_clist,after);
    gtk_widget_set_sensitive(contacts_to_send_clist,after);
    gtk_widget_set_sensitive(add_all_contacts_button,after);
    gtk_widget_set_sensitive(add_one_contact_button,after);
    gtk_widget_set_sensitive(remove_all_contacts_button,after);
    gtk_widget_set_sensitive(remove_one_contact_button,after);

    gtk_widget_set_sensitive(chatsession_optionmenu,after);
    gtk_widget_set_sensitive(filename_browse_button,after);
    gtk_widget_set_sensitive(filename_entry,after);

    gtk_widget_set_sensitive(multimess_checkbutton,after);
    gtk_widget_set_sensitive(send_through_server_checkbutton,after);
    gtk_widget_set_sensitive(urgent_checkbutton,after);

    gtk_widget_set_sensitive(send_send_cancel_button,notafter);
    gtk_widget_set_sensitive(send_send_button,after);

    gtk_widget_set_sensitive(status_chat_button,after);
    gtk_widget_set_sensitive(status_contacts_button,after);
    gtk_widget_set_sensitive(status_file_button,after);
    gtk_widget_set_sensitive(status_message_button,after);
    gtk_widget_set_sensitive(status_secure_button,after);
    gtk_widget_set_sensitive(status_url_button,after);
}

GtkWidget *
show_send_event_window_for_user        (unsigned long   uin,
                                        gint            send_type)
{
    ICQUser     *user = NULL;
    GtkWidget   *send_through_server_checkbutton, *send_event_window;
    gchar       *title;
    userdata_t  *udata;
    GtkWidget   *multimess_scrolledwindow;
    GdkColor    *color;
    CICQColor   ic;

    udata=find_user_data(uin,NULL);
    if(!udata->send_event_window) {
        send_event_window=create_send_event_window();
        udata->send_event_window=send_event_window;
        gtk_widget_set_active_uin(send_event_window,uin);
        send_through_server_checkbutton=lookup_widget(send_event_window,
                "send_through_server_checkbutton");
        multimess_scrolledwindow=lookup_widget(send_event_window,
                "multimess_scrolledwindow");
        gtk_object_set_data(GTK_OBJECT(send_event_window), "current_send_type",
                GINT_TO_POINTER(-1));

        user = (uin>0)?gUserManager.FetchUser(uin,LOCK_R):
            gUserManager.FetchOwner(LOCK_R);
        if (user) {
            gbug("Config: status: %s  away? %s showawaymsg: %s\n",
                    user->StatusStr(),user->Away()?"YES":"NO",
                    user->ShowAwayMsg()?"YES":"NO");
            title = g_strdup_printf(_("Send event - %s"),user->GetAlias());
            gtk_window_set_title(GTK_WINDOW(send_event_window),title);
            g_free(title);
            
            send_through_server_stick = false;
            if (user->Status() == ICQ_STATUS_OFFLINE) {
                gUserManager.DropUser(user);
                gtk_toggle_button_set_active(
                        GTK_TOGGLE_BUTTON(send_through_server_checkbutton),
                        TRUE);
            } else {
                gtk_toggle_button_set_active(
                        GTK_TOGGLE_BUTTON(send_through_server_checkbutton),
                        user->SendServer());
                gUserManager.DropUser(user);
            }
            send_through_server_stick = true;
        }

        gtk_widget_hide(multimess_scrolledwindow);

        /* Remove marked as new user */
        user = (uin>0)?gUserManager.FetchUser(uin,LOCK_W):NULL;
        if (user) {
            if (user->NewUser())  {
                user->SetNewUser(FALSE);  
                gUserManager.DropUser(user);
                refresh_contactlist_single_user(uin);
            } else {
                gUserManager.DropUser(user);
            }
        }
#ifdef USE_PSPELL
        if (setup_speller_per_user(uin)) {
            GtkWidget           *send_text = lookup_widget(GTK_WIDGET(send_event_window),
                    "send_text");
            GtkWidget           *file_text = lookup_widget(GTK_WIDGET(send_event_window),
                    "file_text");
            GtkWidget           *chat_text = lookup_widget(GTK_WIDGET(send_event_window),
                    "chat_text");
            connect_spell_checker_to_gtktext(GTK_TEXT(send_text),udata);
            connect_spell_checker_to_gtktext(GTK_TEXT(file_text),udata);
            connect_spell_checker_to_gtktext(GTK_TEXT(chat_text),udata);
        }
#endif
        setup_statusbar(send_event_window);
        ic.SetToDefault();
        if((color=(GdkColor*)malloc(sizeof(GdkColor)))) {
            ICQBACK_TO_GDK_COLOR(&ic,*color);
            set_outgoing_message_background(send_event_window,color);
        }
        if((color=(GdkColor*)malloc(sizeof(GdkColor)))) {
            ICQFORE_TO_GDK_COLOR(&ic,*color);
            set_outgoing_message_foreground(send_event_window,color);
        }

    }else {
        send_event_window=udata->send_event_window;
        gdk_window_raise(send_event_window->window);
    }
    configure_send(send_type,send_event_window);
    gtk_widget_show(send_event_window);

    return send_event_window;
}

int 
configure_chat_session_optionmenu (GtkOptionMenu *option_menu)
{
    GtkWidget   *menu = gtk_menu_new();
    GtkWidget   *menuitem;
    int         len,i;
    GList       *tmp_list;
   
    gtk_option_menu_remove_menu(option_menu);
    gtk_option_menu_set_menu(option_menu,menu);
    menuitem = gtk_menu_item_new_with_label(_("New Chat Session"));
    gtk_menu_append(GTK_MENU(menu),menuitem);
    
    len = g_list_length(chat_sessions);
    tmp_list = g_list_first(chat_sessions);
    for(i=0; i < len; i++) {
        menuitem = gtk_menu_item_new_with_label(
                ((chat_content *) tmp_list->data)->chatman->ClientsStr());
        gtk_menu_append(GTK_MENU(menu),menuitem);
        gtk_object_set_user_data(GTK_OBJECT(menuitem), 
                ((chat_content *) tmp_list->data)->chatman);
        tmp_list = g_list_next(tmp_list);
    }
    gtk_option_menu_set_history(option_menu,0);
    gtk_widget_show_all(menu);
    gtk_widget_set_sensitive(GTK_WIDGET(option_menu),len?TRUE:FALSE);

    return 0;
}

int 
configure_send              (gint       send_type,
                             GtkWidget  *send_event_window)
{
    GtkWidget   *type_notebook = lookup_widget(send_event_window,
            "type_notebook");
    GtkWidget   *filename_label = lookup_widget(send_event_window,
            "filename_label");
    GtkWidget   *filename_browse_button = lookup_widget(send_event_window,
            "filename_browse_button");
    GtkWidget   *send_through_server_checkbutton = lookup_widget(
            send_event_window, "send_through_server_checkbutton");
    GtkWidget   *multimess_checkbutton=lookup_widget(send_event_window,
            "multimess_checkbutton");
    GtkWidget   *chatsession_optionmenu = lookup_widget(send_event_window,
            "chatsession_optionmenu");
    GtkWidget   *send_text=lookup_widget(send_event_window, "send_text");
    GtkWidget   *file_text=lookup_widget(send_event_window, "file_text");
    GtkWidget   *chat_text=lookup_widget(send_event_window, "chat_text");
    GtkWidget   *contacts_to_send_clist=lookup_widget(send_event_window,
            "contacts_to_send_clist");
    GtkWidget   *contacts_to_select_clist=lookup_widget(send_event_window,
            "contacts_to_select_clist");

    int         current_mode;
    gchar       *tmp_text, *newln[2];
    gint        pos=0, row,cpos=0;
    unsigned long   *thisuin;
    
    current_mode=GPOINTER_TO_INT(gtk_object_get_data(
                GTK_OBJECT(send_event_window), "current_send_type"));

    switch (current_mode) {
        case SEND_MESSAGE:
            tmp_text = gtk_editable_get_chars(GTK_EDITABLE(send_text),0,-1); 
            cpos=gtk_editable_get_position(GTK_EDITABLE(send_text));
            break;
        case SEND_URL:
        case SEND_FILE:
            tmp_text = gtk_editable_get_chars(GTK_EDITABLE(file_text),0,-1); 
            cpos=gtk_editable_get_position(GTK_EDITABLE(file_text));
            break;
        case SEND_CHAT:
            tmp_text = gtk_editable_get_chars(GTK_EDITABLE(chat_text),0,-1); 
            cpos=gtk_editable_get_position(GTK_EDITABLE(chat_text));
            break;
        default:
            tmp_text = NULL;
            break;
    }
//gbug("tmp_tex==%s\n",tmp_text?tmp_text:"NULL");    

    send_through_server_stick = false;
    gtk_object_set_data(GTK_OBJECT(send_event_window), "current_send_type",
            GINT_TO_POINTER(send_type));
    switch(send_type) {
        case SEND_MESSAGE:
            if ((tmp_text != NULL) && (current_mode != SEND_MESSAGE)) {
                gtk_editable_delete_text(GTK_EDITABLE(send_text),0,-1);
                gtk_editable_insert_text(GTK_EDITABLE(send_text),tmp_text,
                        strlen(tmp_text), &pos);
                gtk_editable_set_position(GTK_EDITABLE(send_text),cpos);
#ifdef USE_PSPELL
                spellcheck_from_to(GTK_TEXT(send_text),0,strlen(tmp_text));
#endif
            }
            gtk_notebook_set_page(GTK_NOTEBOOK(type_notebook),0);
            gtk_widget_set_sensitive(GTK_WIDGET(send_through_server_checkbutton),
                    TRUE);
            gtk_widget_set_sensitive(multimess_checkbutton,TRUE);
            gtk_widget_grab_focus(send_text);
            break;
        case SEND_URL:
            if (tmp_text != NULL && current_mode!=SEND_URL) {
                gtk_editable_delete_text(GTK_EDITABLE(file_text),0,-1);
                gtk_editable_insert_text(GTK_EDITABLE(file_text),tmp_text,
                        strlen(tmp_text), &pos);
                gtk_editable_set_position(GTK_EDITABLE(file_text),cpos);
#ifdef USE_PSPELL
                spellcheck_from_to(GTK_TEXT(file_text),0,strlen(tmp_text));
#endif
            }
            gtk_widget_set_sensitive(GTK_WIDGET(send_through_server_checkbutton),
                    TRUE);
            gtk_notebook_set_page(GTK_NOTEBOOK(type_notebook),1);
            gtk_widget_hide(filename_browse_button);
            gtk_label_set_text(GTK_LABEL(filename_label),_("URL:"));
            gtk_widget_set_sensitive(multimess_checkbutton,TRUE);
            gtk_widget_grab_focus(file_text);
            break;
        case SEND_CHAT:
            if (tmp_text != NULL && current_mode!=SEND_CHAT) {
                gtk_editable_delete_text(GTK_EDITABLE(chat_text),0,-1);
                gtk_editable_insert_text(GTK_EDITABLE(chat_text),tmp_text,
                        strlen(tmp_text), &pos);
                gtk_editable_set_position(GTK_EDITABLE(chat_text),cpos);
#ifdef USE_PSPELL
                spellcheck_from_to(GTK_TEXT(chat_text),0,strlen(tmp_text));
#endif
            }
            gtk_notebook_set_page(GTK_NOTEBOOK(type_notebook),2);
            gtk_widget_set_sensitive(GTK_WIDGET(send_through_server_checkbutton),
                    FALSE);
            gtk_toggle_button_set_active(
                    GTK_TOGGLE_BUTTON(send_through_server_checkbutton), FALSE);
            if(gtk_toggle_button_get_active(
                        GTK_TOGGLE_BUTTON(multimess_checkbutton))) {
                gtk_toggle_button_set_active(
                        GTK_TOGGLE_BUTTON(multimess_checkbutton),
                        FALSE);
            }
            configure_chat_session_optionmenu(
                    GTK_OPTION_MENU(chatsession_optionmenu));
            gtk_widget_set_sensitive(multimess_checkbutton,FALSE);
            gtk_widget_grab_focus(chat_text);
            break;  
        case SEND_FILE:
            if (tmp_text != NULL && current_mode!=SEND_FILE) {
                gtk_editable_delete_text(GTK_EDITABLE(file_text),0,-1);
                gtk_editable_insert_text(GTK_EDITABLE(file_text),tmp_text,
                        strlen(tmp_text), &pos);
                gtk_editable_set_position(GTK_EDITABLE(file_text),cpos);
#ifdef USE_PSPELL
                spellcheck_from_to(GTK_TEXT(file_text),0,strlen(tmp_text));
#endif
            }
            gtk_toggle_button_set_active(
                    GTK_TOGGLE_BUTTON(send_through_server_checkbutton), FALSE);
            gtk_widget_set_sensitive(GTK_WIDGET(send_through_server_checkbutton),
                    FALSE);
            gtk_notebook_set_page(GTK_NOTEBOOK(type_notebook),1);
            gtk_widget_show(filename_browse_button);
            gtk_label_set_text(GTK_LABEL(filename_label),_("Filename:"));
            if(gtk_toggle_button_get_active(
                        GTK_TOGGLE_BUTTON(multimess_checkbutton))) {
                gtk_toggle_button_set_active(
                        GTK_TOGGLE_BUTTON(multimess_checkbutton),
                        FALSE);
            }
            gtk_widget_set_sensitive(multimess_checkbutton,FALSE);
            gtk_widget_grab_focus(file_text);
            break;
        case SEND_CONTACTS:
            gtk_widget_set_sensitive(GTK_WIDGET(send_through_server_checkbutton),
                    TRUE);
            gtk_notebook_set_page(GTK_NOTEBOOK(type_notebook),3);
            gtk_widget_set_sensitive(multimess_checkbutton,TRUE);
            if(!gtk_clist_get_length(GTK_CLIST(contacts_to_select_clist))&&
                    !gtk_clist_get_length(GTK_CLIST(contacts_to_send_clist))) {
                gtk_clist_freeze(GTK_CLIST(contacts_to_select_clist));
                newln[1]=NULL;
                FOR_EACH_USER_START(LOCK_R);
                    newln[0]=pUser->GetAlias();
                    row=gtk_clist_append(GTK_CLIST(contacts_to_select_clist),
                            newln);
                    thisuin=(unsigned long*)malloc(sizeof(unsigned long));
                    *thisuin=pUser->Uin();
                    gtk_clist_set_row_data_full(
                            GTK_CLIST(contacts_to_select_clist),row,
                            (gpointer)thisuin, destroy_notify_free);
                FOR_EACH_USER_END;
                gtk_clist_sort(GTK_CLIST(contacts_to_select_clist));
                gtk_clist_thaw(GTK_CLIST(contacts_to_select_clist));
            }
            break;
    }
    send_through_server_stick = true;
    if (tmp_text != NULL){
        g_free(tmp_text);
    }
    return 0;
}

void
insert_quoted_text_into_send_message   (GtkWidget   *toplevel,
                                        gchar       *text)
{
    GtkWidget       *send_text=lookup_widget(toplevel, "send_text");
    GtkWidget       *type_notebook=lookup_widget(toplevel, "type_notebook");
    gchar           *newtext=NULL;
    size_t          pos=0,newpos=0,alen,txtlen;
    gint            lastspace,tmppos;
    gint            rpos=0;
    gint            len;
    
#ifdef USE_PSPELL
    unsigned long   uin;
    userdata_t  *udata = NULL;
    uin=gtk_widget_get_active_uin(GTK_WIDGET(toplevel));
    udata=find_user_data(uin,NULL);    
#endif
    len = gtk_text_get_length(GTK_TEXT(send_text));
    if (len > 0) {
        return;
    }
    
    gtk_text_freeze(GTK_TEXT(send_text));
    gtk_editable_delete_text(GTK_EDITABLE(send_text),0,-1);
    if(text) {
        txtlen = strlen(text);
        alen=txtlen*2+2;
        if ((newtext=(gchar*)g_malloc(alen)) == NULL) {
            gtk_text_thaw(GTK_TEXT(send_text));
            gtk_notebook_set_page(GTK_NOTEBOOK(type_notebook),0);
            gtk_widget_grab_focus(send_text);
            
            return;
        }
        tmppos = -1;
        lastspace = -1;
        newtext[newpos++] = '>';
        rpos=1;
        for(pos=0; pos < txtlen ;pos++) {
            newtext[newpos++]=text[pos];
            if(newpos>=alen) {
                alen+=alen;
                newtext=(gchar*)g_realloc(newtext,alen);
            }
            if (text[pos] == ' '){
                lastspace = newpos;
                tmppos = pos;
            }
            rpos++;
            if(text[pos] == '\n'|| (configuration.quotewidth &&
                        configuration.quotewidth < (unsigned)rpos) || 
                    (pos == (txtlen-1))) {
                if(text[pos] != '\n') {
                    if ((lastspace > 0) && (pos != (txtlen-1))){
                        newtext[lastspace]='\n';
                        newpos = lastspace + 1;
                        if (tmppos > 0) {
                            pos = tmppos;
                        }
                    } else {
                        newtext[newpos++] = '\n';
                        if(newpos>=alen) {
                            alen+=alen;
                            newtext=(gchar*)g_realloc(newtext,alen);
                        }
                    }
                }
                if(newpos>=alen) {
                    alen+=alen;
                    newtext=(gchar*)g_realloc(newtext,alen);
                }
                newtext[newpos] = '\0';
                gtk_text_insert(GTK_TEXT(send_text),NULL,NULL,NULL,newtext,
                        strlen(newtext));
                lastspace = -1;
                tmppos = -1;
                newpos = 0;
                newtext[newpos++] = '>';
                rpos = 1;
            }
        }
        g_free(newtext);
        gtk_text_insert(GTK_TEXT(send_text),NULL,NULL,NULL,"\n",2);
    }
    gtk_text_thaw(GTK_TEXT(send_text));

    gtk_notebook_set_page(GTK_NOTEBOOK(type_notebook),0);
    gtk_widget_grab_focus(send_text);
    if (text) {
        gtk_editable_set_position(GTK_EDITABLE(send_text),
                gtk_text_get_length(GTK_TEXT(send_text))-1); 
#ifdef USE_PSPELL
        if(udata != NULL) {
            udata->spell_start_position = gtk_text_get_length(GTK_TEXT(send_text));
        }
#endif 
    }
}

int
attatch_user_event  (GtkWidget      *toplevel,
                     unsigned long  tag,
                     userdata_t     *userdata)
{
    send_eventdata_t    *data;
    
    if(!tag) {
        return -1;
    }
    
    data=(send_eventdata_t*)malloc(sizeof(send_eventdata_t));
    if(!data) {
        return -1;
    }
    data->toplevel_sender=toplevel;
    data->tag=tag;
    userdata->send_events=g_list_append(userdata->send_events,
            (gpointer)data);
    return 0;
}

int
send_long_textmessage   (GtkWidget      *toplevel,
                         unsigned long  uin,
                         gboolean       send_server,
                         gboolean       urgent,
                         gboolean       allowsplit,
                         gboolean       send_contactlist,
                         gchar          *message,
                         userdata_t     *userdata,
                         gboolean       multimess,
                         CICQColor      *color)
{
    gint            ret=0;
    unsigned long   tag=0;
    gchar           r_char=0;

    if(!message) {
        return 0;
    }

    if(send_server) {
        r_char=get_message_expanded_text_max_length(message,r_char);
    }

    while(*message) {
        if(!send_contactlist) {
            tag=licq_daemon->icqSendMessage(uin,message,
                    !send_server, 
                    urgent?ICQ_TCPxMSG_URGENT:ICQ_TCPxMSG_NORMAL,
                    multimess,color);
        }else {
            tag=licq_daemon->icqSendMessage(uin,message,
                    !send_server, 
                    ICQ_TCPxMSG_LIST,multimess,color);
        }
        if(attatch_user_event(toplevel,tag,userdata)) {
            gbug("send_long_textmessage: !attatch_user_event \n");
            break;
        }
        gbug("send_long_textmessage: ret++\n");
        ret++;
        if(!allowsplit) {
            break;
        }
        message+=strlen(message); 
        if(send_server) {
            r_char=get_message_expanded_text_max_length(message,r_char);
        }
    }
    return ret;
}

int
dispatch_send   (GtkWidget      *toplevel,
                 gint           send_type,
                 unsigned long  uin, 
                 gboolean       send_server,
                 gboolean       urgent,
                 gboolean       allowsplit,
                 gboolean       send_contactlist,
                 gboolean       multimess)
                 
{
    GtkWidget           *filename_entry = lookup_widget(toplevel,
            "filename_entry");
    GtkWidget           *send_text = lookup_widget(toplevel,
            "send_text");
    GtkWidget           *file_text = lookup_widget(toplevel,
            "file_text");
    GtkWidget           *chat_text = lookup_widget(toplevel,
            "chat_text");
    GtkWidget           *chatsession_optionmenu = lookup_widget(toplevel,
            "chatsession_optionmenu");
    GtkWidget           *contacts_to_send_clist = lookup_widget(toplevel,
            "contacts_to_send_clist");
    userdata_t          *userdata;
    CChatManager        *chatman;
    int                 chat_session;
    gchar               *message=NULL, *filename=NULL, *s_message, r_char=0;
    gboolean            more_to_send=FALSE;
    unsigned long       tag;    
    gint                ret=0,contact_count,i;
    struct stat         st;
    UinList             uins;
    unsigned long       thisuin;
    GdkColor            *bgcolor=NULL,*fgcolor=NULL;
    CICQColor           color;

    userdata=find_user_data(uin,NULL);
    if(!userdata) {
        gbug("dispatch_send: found NO userdata\n");
        return -1;
    }
    bgcolor=(GdkColor*)gtk_object_get_data(GTK_OBJECT(toplevel),
            "send_bg_color");
    fgcolor=(GdkColor*)gtk_object_get_data(GTK_OBJECT(toplevel),
            "send_fg_color");
    if(bgcolor) {
        color.SetBackground(bgcolor->red>>8,bgcolor->green>>8,bgcolor->blue>>8);
    }
    if(fgcolor) {
        color.SetForeground(fgcolor->red>>8,fgcolor->green>>8,fgcolor->blue>>8);
    }
    switch(send_type) {
        case SEND_MESSAGE:
            message=gtk_editable_get_chars(GTK_EDITABLE(send_text),0,-1);
            ret=send_long_textmessage(toplevel,uin,
                    send_server,urgent,allowsplit,send_contactlist,
                    message,userdata,multimess,&color);
            break;
        case SEND_URL:
            message=gtk_editable_get_chars(GTK_EDITABLE(file_text),0,-1);
            filename=gtk_editable_get_chars(GTK_EDITABLE(filename_entry),0,-1);
            r_char=get_message_expanded_text_max_length(message,r_char);
            if(r_char&&allowsplit) {
                more_to_send=TRUE;
            }
            tag=licq_daemon->icqSendUrl(uin,filename,message,
                    !send_server,urgent,multimess,&color); 
            ret=(tag&&!attatch_user_event(toplevel,tag,userdata));
            if(ret>0&&tag&&more_to_send) {
                s_message=message+strlen(message);
                *s_message=r_char;
                ret+=send_long_textmessage(toplevel,uin,
                        send_server,urgent,allowsplit,send_contactlist,
                        s_message,userdata,multimess,&color);
            }
            break;
        case SEND_FILE:
            message=gtk_editable_get_chars(GTK_EDITABLE(file_text),0,-1);
            filename=gtk_editable_get_chars(GTK_EDITABLE(filename_entry),0,-1);
            if(strlen(filename) == 0) {
                showokdialog(_("Error"), _("No file is specified!"));
            } else if (stat(filename,&st) == -1 || !S_ISREG(st.st_mode)){
                showokdialog(_("Error"),_("The specified file isn't a regular file!"));
            } else {
                tag=licq_daemon->icqFileTransfer(uin,filename,message,urgent);
                ret=(tag&&!attatch_user_event(toplevel,tag,userdata));
            }
            break;
        case SEND_CHAT:
            message=gtk_editable_get_chars(GTK_EDITABLE(chat_text),0,-1);
            chat_session = gtk_option_menu_get_history(
                    GTK_OPTION_MENU(chatsession_optionmenu));
            if (chat_session != 0) {
                chatman = (CChatManager *) gtk_object_get_user_data(
                        GTK_OBJECT(GTK_OPTION_MENU(
                                chatsession_optionmenu)->menu_item));
                if (chatman != NULL) {
                    tag=licq_daemon->icqMultiPartyChatRequest(uin,message,
                            chatman->ClientsStr(),chatman->LocalPort(), urgent);
                    ret=(tag&&!attatch_user_event(toplevel,tag,userdata));
                }
            } else {
                tag=licq_daemon->icqChatRequest(uin,message,urgent);
                ret=(tag&&!attatch_user_event(toplevel,tag,userdata));
            }
            break;
        case SEND_CONTACTS:
            contact_count=gtk_clist_get_length(GTK_CLIST(contacts_to_send_clist));
            if(contact_count) {
                for(i=0;i<contact_count;i++) {
                    thisuin=*(unsigned long*)gtk_clist_get_row_data(
                            GTK_CLIST(contacts_to_send_clist),i);
                    uins.push_back(thisuin);
                }
                tag=licq_daemon->icqSendContactList(uin,uins,!send_server,
                        urgent?ICQ_TCPxMSG_URGENT:ICQ_TCPxMSG_NORMAL,multimess,
                        &color);
                ret=(tag&&!attatch_user_event(toplevel,tag,userdata));
            }
            break;
    }
    if(message) {
        g_free(message);
    }
    if(filename) {
        g_free(filename);
    }
    return ret;
}

void
move_user_between_lists (GtkCList    *from,
                         GtkCList    *to)
{
    GList           *sel;
    gchar           *text[2];
    gint            row;
    unsigned long   *thisuin;
    
    sel=from->selection;
    gtk_clist_freeze(from);
    gtk_clist_freeze(to);
    text[1]=NULL;
    while(sel) {
        thisuin=(unsigned long*)malloc(sizeof(unsigned long));
        *thisuin=*(unsigned long*)gtk_clist_get_row_data(
                from, GPOINTER_TO_INT(sel->data));
        gtk_clist_get_text(from, GPOINTER_TO_INT(sel->data),0,&text[0]);
        row=gtk_clist_append(to,text);
        gtk_clist_set_row_data_full(to,row, (gpointer)thisuin,
                destroy_notify_free);
        sel=g_list_next(sel);
    }
    while(from->selection) {
        gtk_clist_remove(from, GPOINTER_TO_INT(from->selection->data));
    }
    gtk_clist_sort(to);
    gtk_clist_thaw(from);
    gtk_clist_thaw(to);
}

void
on_add_one_contact_button_clicked      (GtkButton       *button,
                                        gpointer         user_data)
{
    GtkWidget       *contacts_to_select_clist=lookup_widget(GTK_WIDGET(button),
            "contacts_to_select_clist");
    GtkWidget       *contacts_to_send_clist=lookup_widget(GTK_WIDGET(button),
            "contacts_to_send_clist");

    move_user_between_lists(GTK_CLIST(contacts_to_select_clist),
            GTK_CLIST(contacts_to_send_clist));
}


void
on_remove_one_contact_button_clicked   (GtkButton       *button,
                                        gpointer         user_data)
{
    GtkWidget       *contacts_to_select_clist=lookup_widget(GTK_WIDGET(button),
            "contacts_to_select_clist");
    GtkWidget       *contacts_to_send_clist=lookup_widget(GTK_WIDGET(button),
            "contacts_to_send_clist");

    move_user_between_lists(GTK_CLIST(contacts_to_send_clist),
            GTK_CLIST(contacts_to_select_clist));
}

GtkMenu *
build_contact_all_op_menu(GtkSignalFunc callback)
{
    GtkWidget   *group_new_menu;
    GroupList   *groups;
    guint       i;

    group_new_menu=GTK_WIDGET(gtk_menu_new());
    gtk_widget_ref(group_new_menu);
    gtk_signal_connect(GTK_OBJECT(group_new_menu),"deactivate",
            GTK_SIGNAL_FUNC(gtk_widget_unref),NULL);
    add_group_to_grouplist(group_new_menu,
            callback, _("All users"), 0);
    add_group_to_grouplist(group_new_menu, NULL, NULL, 0);
    add_group_to_grouplist(group_new_menu,
            callback, _("Online notify"),
            gUserManager.NumGroups()+GROUP_ONLINE_NOTIFY);
    add_group_to_grouplist(group_new_menu,
            callback, _("Visible list"),
            gUserManager.NumGroups()+GROUP_VISIBLE_LIST);
    add_group_to_grouplist(group_new_menu,
            callback, _("Invisible list"),
            gUserManager.NumGroups()+GROUP_INVISIBLE_LIST);
    add_group_to_grouplist(group_new_menu,
            callback, _("Ignore list"),
            gUserManager.NumGroups()+GROUP_IGNORE_LIST);
    add_group_to_grouplist(group_new_menu, 
            callback, _("New users"),
            gUserManager.NumGroups()+GROUP_NEW_USERS);
    add_group_to_grouplist(group_new_menu, NULL, NULL, 0);
    groups=gUserManager.LockGroupList(LOCK_R);
    if(groups) {
        for (i=0;i<groups->size();i++)
        {
            add_group_to_grouplist(group_new_menu,
                    callback, (*groups)[i],i+1);
        }
    }
    gUserManager.UnlockGroupList();

    return GTK_MENU(group_new_menu);
}

void
on_add_all_contacts_button_clicked     (GtkButton       *button,
                                        gpointer         user_data)
{
    GtkWidget       *menu;

    menu=GTK_WIDGET(build_contact_all_op_menu(
                GTK_SIGNAL_FUNC(on_button_addall_menu_clicked)));
    gtk_menu_attach_to_widget(GTK_MENU(menu),GTK_WIDGET(button),
            (GtkMenuDetachFunc)gtk_menu_detach_func_unref);
    
    gtk_menu_popup(GTK_MENU(menu),NULL,NULL,NULL,0,0,0); 
}


void
on_remove_all_contacts_button_clicked  (GtkButton       *button,
                                        gpointer         user_data)
{
    GtkWidget       *menu;

    menu=GTK_WIDGET(build_contact_all_op_menu(
                GTK_SIGNAL_FUNC(on_button_removeall_menu_clicked)));
    gtk_menu_attach_to_widget(GTK_MENU(menu),GTK_WIDGET(button),
            (GtkMenuDetachFunc)gtk_menu_detach_func_unref);
    
    gtk_menu_popup(GTK_MENU(menu),NULL,NULL,NULL,0,0,0); 
}


void
on_filename_browse_button_clicked      (GtkButton       *button,
                                        gpointer         user_data)
{
    GtkWidget *file_dialog = create_file_dialog();
    GtkWidget *filename_entry=lookup_widget(GTK_WIDGET(button),"filename_entry");

    gtk_object_set_data(GTK_OBJECT(file_dialog), "f_entry", filename_entry);
    gtk_widget_show(file_dialog);
}

gboolean
on_send_event_window_key_press_event   (GtkWidget       *widget,
                                        GdkEventKey     *event,
                                        gpointer         user_data)
{

    GtkWidget   *send_send_button = lookup_widget(GTK_WIDGET(widget),
            "send_send_button");
    if (event->state & GDK_CONTROL_MASK) {
        GtkWidget       *send_through_server_checkbutton=lookup_widget(widget,
                "send_through_server_checkbutton");
        GtkWidget       *urgent_checkbutton = lookup_widget(widget,
                "urgent_checkbutton");
        GtkWidget       *multimess_checkbutton = lookup_widget(widget,
                "multimess_checkbutton");
        GtkWidget       *status_message_button=lookup_widget(widget,
                "status_message_button");
        GtkWidget       *status_url_button=lookup_widget(widget,
                "status_url_button");
        GtkWidget       *status_file_button=lookup_widget(widget,
                "status_file_button");
        GtkWidget       *status_chat_button=lookup_widget(widget,
                "status_chat_button");
        GtkWidget       *status_contacts_button=lookup_widget(widget,
                "status_contacts_button");
        GtkWidget       *status_secure_button=lookup_widget(widget,
                "status_secure_button");
        GtkWidget       *status_usermenu_button=lookup_widget(widget,
                "status_usermenu_button");
        GtkWidget       *status_close_button=lookup_widget(widget,
                "status_close_button");

        switch(event->keyval) {
            case GDK_Return:
                gtk_signal_emit_by_name(GTK_OBJECT(send_send_button),"clicked");
                break;
            case GDK_m:
                gtk_signal_emit_by_name(GTK_OBJECT(status_message_button),
                        "clicked");
                break;
            case GDK_q:
                gtk_signal_emit_by_name(GTK_OBJECT(status_close_button),
                        "clicked");
                break;
            case GDK_l:
                gtk_signal_emit_by_name(GTK_OBJECT(status_url_button),
                        "clicked");
                break;
            case GDK_t:
                gtk_signal_emit_by_name(GTK_OBJECT(status_chat_button),
                        "clicked");
                break;
            case GDK_f:
                gtk_signal_emit_by_name(GTK_OBJECT(status_file_button),
                        "clicked");
                break;
            case GDK_p:
                gtk_signal_emit_by_name(GTK_OBJECT(status_contacts_button),
                        "clicked");
                break;
            case GDK_r:
                gtk_signal_emit_by_name(GTK_OBJECT(status_secure_button),
                        "clicked");
                break;
            case GDK_d:
                gtk_signal_emit_by_name(GTK_OBJECT(status_usermenu_button),
                        "clicked");
                break;
            case GDK_s:
                gtk_signal_emit_by_name(
                        GTK_OBJECT(send_through_server_checkbutton),
                        "toggled");
                break;
            case GDK_i:
                gtk_signal_emit_by_name(
                        GTK_OBJECT(urgent_checkbutton), "toggled");
                break;
            case GDK_g:
                gtk_signal_emit_by_name(GTK_OBJECT(multimess_checkbutton),
                        "toggled");
                break;
            default:
                break;
        }
    }
    if (((event->state == 0) || (event->state == 0x80)) && (event->keyval == GDK_Tab)) {
        gtk_widget_grab_focus(send_send_button);
        gtk_signal_emit_stop_by_name(GTK_OBJECT(widget), "key_press_event");
        return TRUE;
    }
    return FALSE;
}

void
on_event_alias_clist_row_select         (GtkCList *clist,
                                         gint row,
                                         gint column,
                                         GdkEventButton *event,
                                         gpointer user_data)
{
    GtkWidget       *send_send_button=lookup_widget(GTK_WIDGET(clist),
            "send_send_button");

    gtk_widget_set_sensitive(GTK_WIDGET(send_send_button),
            clist->selection?TRUE:FALSE);
}

void
cancel_all_window_pending_events        (GtkWidget  *toplevel)
{
    GList       *rows=NULL,*ufloat;
    GtkWidget   *contactlist=lookup_widget(main_window,"alias_clist");
    userdata_t  *userdata;

    rows=GTK_CLIST(contactlist)->row_list;
    while(rows) {
        if(rows->data&&((GtkCListRow*)(rows->data))->data) {
            userdata=(userdata_t*)((GtkCListRow*)(rows->data))->data;
            ufloat=userdata->send_events;
            while(ufloat) {
                if(((send_eventdata_t*)ufloat->data)->toplevel_sender==toplevel) {
                    licq_daemon->CancelEvent(
                            ((send_eventdata_t*)ufloat->data)->tag);
                }
                ufloat=g_list_next(ufloat);
            }
        }
        rows=g_list_next(rows);
    }
}


void
move_group_between_lists    (GtkCList   *from,
                             GtkCList   *to,
                             gint       group)
{
    gint            i=0,gnum=0,row;
    GroupType       gtype;
    ICQUser         *u;
    gchar           *text[2];
    unsigned long   thisuin,*newuin;
  
    gbug("move_group_between_lists: enter\n"); 
    if(group>gUserManager.NumGroups()) {
        gnum-=gUserManager.NumGroups();
        gtype=GROUPS_SYSTEM;
    }else {
        gnum=group;
        gtype=GROUPS_USER;
    }
    gtk_clist_freeze(from);
    gtk_clist_freeze(to);
    text[1]=NULL;
    while(i<gtk_clist_get_length(from)) {
        if(!gtk_clist_get_row_data(from,i)) {
            gbug("move_group_between_lists: NO ROW DATA!\n");
        }
        thisuin=*(unsigned long*)gtk_clist_get_row_data(from,i);
        u=gUserManager.FetchUser(thisuin,LOCK_R);
        if(u->GetInGroup(gtype,gnum)) {
            newuin=(unsigned long*)malloc(sizeof(unsigned long));
            if(!newuin) {
                gbug("move_group_between_lists: Malloc failed\n");
            }
            *newuin=thisuin;
            gtk_clist_get_text(from, i,0,&(text[0]));
            row=gtk_clist_append(to,text);
            gtk_clist_set_row_data_full(to,row, 
                    (gpointer)newuin,destroy_notify_free);
            gtk_clist_remove(from,i);
        }else {
            i++;
        }
        gUserManager.DropUser(u);
    }
    gtk_clist_sort(to);
    gtk_clist_thaw(from);
    gtk_clist_thaw(to);
}

void
on_button_addall_menu_clicked          (GtkMenuItem *menuitem,
                                        gpointer user_data)
{
    GtkWidget       *contacts_to_select_clist=lookup_widget(GTK_WIDGET(menuitem),
            "contacts_to_select_clist");
    GtkWidget       *contacts_to_send_clist=lookup_widget(GTK_WIDGET(menuitem),
            "contacts_to_send_clist");
    
    move_group_between_lists(GTK_CLIST(contacts_to_select_clist),
            GTK_CLIST(contacts_to_send_clist),GPOINTER_TO_INT(user_data));
}

void
on_button_removeall_menu_clicked       (GtkMenuItem *menuitem,
                                        gpointer user_data)
{
    GtkWidget       *contacts_to_select_clist=lookup_widget(GTK_WIDGET(menuitem),
            "contacts_to_select_clist");
    GtkWidget       *contacts_to_send_clist=lookup_widget(GTK_WIDGET(menuitem),
            "contacts_to_send_clist");

    move_group_between_lists(GTK_CLIST(contacts_to_send_clist),
            GTK_CLIST(contacts_to_select_clist),GPOINTER_TO_INT(user_data));
}


GdkColor    *
get_color_from_selection_dialog        (GtkWidget       *colorseld)
{
    double              colors[4];
    GdkColor            *color;

    gtk_color_selection_get_color(
            GTK_COLOR_SELECTION(GTK_COLOR_SELECTION_DIALOG(colorseld)->colorsel),
            colors);
    if((color=(GdkColor*)malloc(sizeof(GdkColor)))) {
        color->red=(gushort)(colors[0]*65535);
        color->green=(gushort)(colors[1]*65535);
        color->blue=(gushort)(colors[2]*65535);
    }

    return color;
}

void
on_send_event_window_foreground_color_selected
                                       (GtkWidget       *okbutton,
                                        GtkWidget       *send_event_window)
{
    GtkWidget           *colorseld;
    GdkColor            *color;

    colorseld=gtk_widget_get_toplevel(GTK_WIDGET(okbutton));
    color=get_color_from_selection_dialog(colorseld);
    set_outgoing_message_foreground(send_event_window,color);
    gtk_widget_destroy(colorseld);
}

void
on_send_event_window_background_color_selected
                                       (GtkWidget       *okbutton,
                                        GtkWidget       *send_event_window)
{
    GtkWidget           *colorseld;
    GdkColor            *color;

    colorseld=gtk_widget_get_toplevel(GTK_WIDGET(okbutton));
    color=get_color_from_selection_dialog(colorseld);
    set_outgoing_message_background(send_event_window,color);
    gtk_widget_destroy(colorseld);
}

void
on_send_select_font_foreground_button_clicked
                                        (GtkButton       *button,
                                        gpointer         user_data)
{
    GtkWidget       *colordialog;
    GdkColor        *color;
    double          colors[4];


    colordialog=gtk_color_selection_dialog_new(_("Select foreground color"));
    gtk_widget_hide(GTK_COLOR_SELECTION_DIALOG(colordialog)->help_button);
    gtk_signal_connect(
            GTK_OBJECT(GTK_COLOR_SELECTION_DIALOG(colordialog)->ok_button),
            "clicked", 
            GTK_SIGNAL_FUNC(on_send_event_window_foreground_color_selected),
            gtk_widget_get_toplevel(GTK_WIDGET(button)));
    gtk_signal_connect_object(
            GTK_OBJECT(GTK_COLOR_SELECTION_DIALOG(colordialog)->cancel_button),
            "clicked", GTK_SIGNAL_FUNC(gtk_widget_destroy),
            GTK_OBJECT(colordialog));
    gtk_widget_set_active_uin(colordialog,
            gtk_widget_get_active_uin(GTK_WIDGET(button)));
    color=(GdkColor*)gtk_object_get_data(
            GTK_OBJECT(gtk_widget_get_toplevel(GTK_WIDGET(button))),
            "send_fg_color");
    if(color) {
        colors[0]=(double)color->red/65535.0;
        colors[1]=(double)color->green/65535.0;
        colors[2]=(double)color->blue/65535.0;
        colors[3]=0;
        gtk_color_selection_set_color(
                GTK_COLOR_SELECTION(GTK_COLOR_SELECTION_DIALOG(
                        colordialog)->colorsel),colors);
    }
    
    gtk_widget_show(colordialog);
}


void
on_send_select_font_background_button_clicked
                                        (GtkButton       *button,
                                        gpointer         user_data)
{
    GtkWidget       *colordialog;
    GdkColor        *color;
    double          colors[4];

    colordialog=gtk_color_selection_dialog_new(_("Select background color"));
    gtk_widget_hide(GTK_COLOR_SELECTION_DIALOG(colordialog)->help_button);
    gtk_signal_connect(
            GTK_OBJECT(GTK_COLOR_SELECTION_DIALOG(colordialog)->ok_button),
            "clicked", 
            GTK_SIGNAL_FUNC(on_send_event_window_background_color_selected),
            gtk_widget_get_toplevel(GTK_WIDGET(button)));
    gtk_signal_connect_object(
            GTK_OBJECT(GTK_COLOR_SELECTION_DIALOG(colordialog)->cancel_button),
            "clicked", GTK_SIGNAL_FUNC(gtk_widget_destroy),
            GTK_OBJECT(colordialog));
    gtk_widget_set_active_uin(colordialog,
            gtk_widget_get_active_uin(GTK_WIDGET(button)));
    color=(GdkColor*)gtk_object_get_data(
            GTK_OBJECT(gtk_widget_get_toplevel(GTK_WIDGET(button))),
            "send_bg_color");
    if(color) {
        colors[0]=(double)color->red/65535.0;
        colors[1]=(double)color->green/65535.0;
        colors[2]=(double)color->blue/65535.0;
        colors[3]=0;
        gtk_color_selection_set_color(
                GTK_COLOR_SELECTION(GTK_COLOR_SELECTION_DIALOG(
                        colordialog)->colorsel),colors);
    }
    gtk_widget_show(colordialog);
}

void
set_outgoing_message_foreground        (GtkWidget       *toplevel,
                                        GdkColor        *color)
{
    GtkWidget           *send_text=lookup_widget(toplevel,"send_text");
    GtkWidget           *file_text=lookup_widget(toplevel,"file_text");

    gtk_object_set_data_full(GTK_OBJECT(toplevel),"send_fg_color",
            color,destroy_notify_free);
    if(color) {
        gtk_widget_set_color(send_text,FALSE,TRUE,0,0,0,color->red,color->green,
                color->blue);
        gtk_widget_set_color(file_text,FALSE,TRUE,0,0,0,color->red,color->green,
                color->blue);
    }
}

void
set_outgoing_message_background        (GtkWidget       *toplevel,
                                        GdkColor        *color)
{
    GtkWidget           *send_text=lookup_widget(toplevel,"send_text");
    GtkWidget           *file_text=lookup_widget(toplevel,"file_text");

    gtk_object_set_data_full(GTK_OBJECT(toplevel),"send_bg_color",
            color,destroy_notify_free);
    if(color) {
        gtk_widget_set_color(send_text,TRUE,FALSE,color->red,color->green,
                color->blue,0,0,0);
        gtk_widget_set_color(file_text,TRUE,FALSE,color->red,color->green,
                color->blue,0,0,0);
    }
}
