#ifndef SEND_EVENT_WINDOW_H_INCLUDED
#define SEND_EVENT_WINDOW_H_INCLUDED

#include "gtk-gui.h"

int 
shutdown_send_event_window             (GtkWidget   *event_window,
                                        gboolean    closeview);

GtkWidget *
show_send_event_window_for_user        (unsigned long   uin,
                                        gint            send_type);

int 
configure_chat_session_optionmenu       (GtkOptionMenu *option_menu);

void
insert_quoted_text_into_send_message    (GtkWidget   *toplevel,
                                         gchar       *text);

void
on_event_alias_clist_row_select         (GtkCList *clist,
                                         gint row,
                                         gint column,
                                         GdkEventButton *event,
                                         gpointer user_data);

void
cancel_all_window_pending_events        (GtkWidget  *toplevel);

void                                    
on_contacts_to_select_clist_drag_data_get
                                        (GtkWidget *contacts_to_select_clist,
                                         GdkDragContext *drag_context,
                                         GtkSelectionData *data, 
                                         guint info,
                                         guint time, 
                                         gpointer user_data);

void
on_contacts_to_send_clist_drag_data_received
                                        (GtkWidget *contacts_to_send_clist,
                                         GdkDragContext *drag_context, 
                                         gint x,
                                         gint y,
                                         GtkSelectionData *data,
                                         guint info, 
                                         guint time, 
                                         gpointer user_data);
                                       
int
dispatch_send   (GtkWidget      *toplevel,
                 gint           send_type,
                 unsigned long  uin, 
                 gboolean       send_server,
                 gboolean       urgent,
                 gboolean       allowsplit,
                 gboolean       send_contactlist,
                 gboolean       multimess);

void
setup_widgets_for_send          (gboolean   after,
                                 GtkWidget  *toplevel);

void
set_outgoing_message_background        (GtkWidget       *toplevel,
                                        GdkColor        *color);

void
set_outgoing_message_foreground        (GtkWidget       *toplevel,
                                        GdkColor        *color);
#endif /* SEND_EVENT_WINDOW_H_INCLUDED */ 
