#include "gtk-gui.h"

#include <unistd.h>

#include "signalhandler.h"


#define G_SLIST_INSERT_NODUPE(list,data)        \
    {                                           \
        if(!g_slist_find(list,data)) {          \
                list=g_slist_append(list,data); \
        }                                       \
    }


    /*  Globals */
GSList      *registered_event_callbacks,*event_callbacks_to_be_deleted;
GSList      *registered_signal_callbacks,*signal_callbacks_to_be_deleted;
int         processing_events, processing_signals;
gint        signalhandler_id=0;

void
signal_read_notify(gpointer data,
        gint source,
        GdkInputCondition condition)
{
    char        event;
    CICQSignal  *n_signal;
    ICQEvent    *n_event;

    gbug("signal_read_notify: enter\n");
    if(condition==GDK_INPUT_READ) {
        if(read(source,&event,1)) {
            gbug("signal_read_notify: read type '%d'(%c)\n",event,event);
            switch(event) {
                case PLUGIN_SIGNAL:
                    n_signal=licq_daemon->PopPluginSignal();
                    signal_dispatchsignal(n_signal);
                    break;
                case PLUGIN_EVENT:
                    n_event=licq_daemon->PopPluginEvent();
                    signal_dispatchevent(n_event);
                    break;
                case PLUGIN_SHUTDOWN:
                    gtk_plugin_terminate();
                    break;
                default:
                    gbug("signal_read_notify: unknown type '%d'(%c)\n", event,
                            event);
                    break;
            }
        }
    }
}

void
signal_dispatchsignal(CICQSignal *signal) 
{
    GSList                      *e_float=NULL,*thissignal;
    static GSList               *signals=NULL;
    signalhandler_callbacks_t   *temp;
  
  	if(!signal) {
		return ;
	}
    signals=g_slist_append(signals,(gpointer)signal);
    if(processing_signals) {
        gbug("signal_dispatchsignal: caught recursion\n");
        return ;
    }
    processing_signals++;
        /*  It is important that theese instructions can be considered atomary 
            since no gtk calls are made no more signal can occur in theese next
            steps */
    while((thissignal=signals)) {
        signal=(CICQSignal*)thissignal->data;
        signals=g_slist_next(signals);
        g_slist_remove_link(signals,thissignal);
        g_slist_free_1(thissignal);
            /*  End of atoms */
        gbug("signal_dispatchsignal: signal %ld,%ld uin %ld\n",
                signal->Signal(), signal->SubSignal(), signal->Uin()); 
        while((e_float=getnextdispatchable_signal(e_float))) {
            gbug("signal_dispatchsignal: loop (%d entries)\n",g_slist_length(e_float));
            temp=(signalhandler_callbacks_t*)e_float->data;
            if(temp->func(signal, temp->data)) {
                G_SLIST_INSERT_NODUPE(signal_callbacks_to_be_deleted,
                        (gpointer)temp);
            }
        }
        if(signal) {
            delete signal;
        }
        if(signal_callbacks_to_be_deleted) {
            e_float=signal_callbacks_to_be_deleted;
            while(e_float) {
                gbug("signal_dispatchsignal: removed one\n");
                registered_signal_callbacks=g_slist_remove(
                        registered_signal_callbacks, e_float->data);
                free(e_float->data);
                e_float=g_slist_next(e_float);
            }
            g_slist_free(signal_callbacks_to_be_deleted);
            signal_callbacks_to_be_deleted=NULL;
        }
    }
    processing_signals--;
}

void
signal_dispatchevent(ICQEvent *event)
{
    GSList                      *e_float=NULL,*thisevent;
    eventhandler_callbacks_t    *temp;
    static GSList               *events=NULL;
  
  	if(!event) {
		return ;
	}
    events=g_slist_append(events,(gpointer*)event);
    if(processing_events) {
        gbug("signal_dispatchevent: caught recursion\n");
        return ;
    }
    processing_events++;
        /*  It is important that theese instructions can be considered atomary 
            since no gtk calls are made no more signal can occur in theese next
            steps */
    while((thisevent=events)) {
        event=(ICQEvent*)thisevent->data;
        events=g_slist_next(events);
        g_slist_remove_link(events,thisevent);
        g_slist_free_1(thisevent);
            /*  End of atoms */
        gbug("signal_dispatchevent: rslt=%d, cmd==%d, subcmd==%d\n",
                event->Result(),event->Command(),event->SubCommand());
        while((e_float=getnextdispatchable_event(e_float))) {
            temp=(eventhandler_callbacks_t*)e_float->data;
            if(temp->func(event, temp->data)) {
                G_SLIST_INSERT_NODUPE(event_callbacks_to_be_deleted,
                        (gpointer)temp); 
            }
        }
        if(event) {
            delete event;
        }
        if(event_callbacks_to_be_deleted) {
            e_float=event_callbacks_to_be_deleted;
            while(e_float) {
                gbug("signal_dispatchevent: remove one\n");
                registered_event_callbacks=g_slist_remove(registered_event_callbacks,
                        e_float->data);
                free(e_float->data);
                e_float=g_slist_next(e_float);
            }
            g_slist_free(event_callbacks_to_be_deleted);
            event_callbacks_to_be_deleted=NULL;
        }
    }
    processing_events--;
}

int
setup_signals(int licq_pipe)
{
    gbug("setup_signals: enter\n");
    registered_event_callbacks=NULL;
    registered_signal_callbacks=NULL;
    signal_callbacks_to_be_deleted=NULL;
    event_callbacks_to_be_deleted=NULL;
    processing_signals=0;
    processing_events=0;
    if(!(signalhandler_id=gtk_input_add_full(licq_pipe, GDK_INPUT_READ, 
                    signal_read_notify, NULL, NULL, NULL))) {
        gbug("setup_signals: gtk_input_add_full() failed\n");
    }
    return 0;
}

int
register_signalcallback(signalhandler_callback  func,
        gpointer                data)
{
    signalhandler_callbacks_t   *news;

    if(!func) {
        gbug("register_signalcallback: func==NULL\n");
        return 1;
    }
    if(!(news=(signalhandler_callbacks_t*)malloc(
                    sizeof(signalhandler_callbacks_t)))) {
        gbug("register_signalcallback: malloc() failed\n");
        return 1;
    }
    (gpointer)news->func=func;
    news->data=data;
    registered_signal_callbacks=g_slist_append(registered_signal_callbacks,news);
    
    return 0;
}

int
unregister_signalcallback(signalhandler_callback  func,
        gpointer                data)
{
    GSList                      *e_float;
    signalhandler_callbacks_t   *temp;

    for(e_float=registered_signal_callbacks;e_float;
            e_float=g_slist_next(e_float)) {
        temp=(signalhandler_callbacks_t*)e_float->data;
        if(func==temp->func && data==temp->data) {
            if(!processing_signals) {
                registered_signal_callbacks=g_slist_remove(
                        registered_signal_callbacks,(gpointer)temp);
                free(temp);
                gbug("unregister_signalcallback: NORMAL DELETE\n");
            }else {
                G_SLIST_INSERT_NODUPE(signal_callbacks_to_be_deleted,
                        (gpointer)temp);
                gbug("unregister_signalcallback: DELETE ON STACK\n");
            }
            return 0;
        }
    }
    gbug("unregister_signalcallback: NO DELETE\n");
    return 1;
}

int
register_eventcallback(eventhandler_callback  func,
        gpointer                data)
{
    eventhandler_callbacks_t    *news;

    if(!func) {
        gbug("register_eventcallback: func==NULL\n");
        return 1;
    }
    if(!(news=(eventhandler_callbacks_t*)malloc(
                    sizeof(eventhandler_callbacks_t)))) {
        gbug("register_eventcallback: malloc() failed\n");
        return 1;
    }
    (gpointer)news->func=func;
    news->data=data;
    registered_event_callbacks=g_slist_append(registered_event_callbacks,news);
    
    return 0;
}

int
unregister_eventcallback(eventhandler_callback  func,
        gpointer                data)
{
    GSList                      *e_float;
    eventhandler_callbacks_t    *temp;
    
    for(e_float=registered_event_callbacks;e_float;
            e_float=g_slist_next(e_float)) {
        temp=(eventhandler_callbacks_t*)e_float->data;
        if(func==temp->func && data==temp->data) {
            if(!processing_events) {
                registered_event_callbacks=g_slist_remove(
                        registered_event_callbacks, (gpointer)temp);
                gbug("unregister_eventcallback: NORMAL DELETE\n");
                free(temp);
            }else {
                G_SLIST_INSERT_NODUPE(event_callbacks_to_be_deleted,
                        (gpointer)temp);
                gbug("unregister_eventcallback: DELETE ON STACK\n");
            }
            return 0;
        }
    }
    gbug("unregister_eventcallback: NO DELETE\n");

    return 1;
}

GSList *
getnextdispatchable_signal(GSList *prev)
{
    if(!registered_signal_callbacks) {
        return NULL;
    }

    if(prev==NULL) {
        prev=registered_signal_callbacks;
    }else {
        prev=g_slist_next(prev);
    }

    while(prev) {
        if(!g_slist_find(signal_callbacks_to_be_deleted,prev->data)) {
            gbug("getnextdispatchable_signal: function had no delete\n");
            break;
        }else {
            gbug("getnextdispatchable_signal: function had delete\n");
            prev=g_slist_next(prev);
        }
    }
    
    return prev;
}

GSList *
getnextdispatchable_event(GSList *prev)
{
    if(!registered_event_callbacks) {
        return NULL;
    }

    if(prev==NULL) {
        prev=registered_event_callbacks;
    }else {
        prev=g_slist_next(prev);
    }

    while(prev) {
        if(!g_slist_find(event_callbacks_to_be_deleted,prev->data)) {
            gbug("getnextdispatchable_event: function had no delete\n");
            break;
        }else {
            gbug("getnextdispatchable_event: function had delete\n");
            prev=g_slist_next(prev);
        }
    }
    
    return prev;
}

void
remove_all_handlers()
{
    gtk_input_remove(signalhandler_id);

    g_slist_free(registered_event_callbacks);
    g_slist_free(registered_signal_callbacks);
    g_slist_free(event_callbacks_to_be_deleted);
    g_slist_free(signal_callbacks_to_be_deleted);

    registered_event_callbacks=NULL;
    registered_signal_callbacks=NULL;
    event_callbacks_to_be_deleted=NULL;
    signal_callbacks_to_be_deleted=NULL;

}
