#ifndef SIGNAL_H_INCLUDED
#define SIGNAL_H_INCLUDED

#include "licq_events.h"

    /*  Signalcallback for events, register desire to get event first
        and when events occur a callback is made.. return true if the
        handler is to be unregistered */

typedef bool (*signalhandler_callback)(CICQSignal *, gpointer);
typedef bool (*eventhandler_callback)(ICQEvent *,gpointer);

typedef struct {
    signalhandler_callback  func;
    gpointer                data;
} signalhandler_callbacks_t;

typedef struct {
    eventhandler_callback   func;
    gpointer                data;
} eventhandler_callbacks_t;

    /*  Init signalhandling */
int
setup_signals(int licq_pipe);

    /*  Register callbacks */
int
register_signalcallback(
        signalhandler_callback  func,
        gpointer                data);
int
unregister_signalcallback(
        signalhandler_callback  func,
        gpointer                data);
int
register_eventcallback(
        eventhandler_callback   func,
        gpointer                data);
int
unregister_eventcallback(
        eventhandler_callback   func,
        gpointer                data);


    /*  Internal use only */
void
signal_dispatchsignal(CICQSignal *signal);

void
signal_dispatchevent(ICQEvent *event);

GSList *
getnextdispatchable_signal(GSList *prev);

GSList *
getnextdispatchable_event(GSList *prev);

void
remove_all_handlers();

#endif /* SIGNAL_H_INCLUDED */
