#include <config.h>
#include "spell.h"
#ifdef USE_PSPELL
#include "gtk-gui.h"
#include "functions.h"
#include "spell_languagecodes.h"

#include <glib.h>
#include <gdk/gdkkeysyms.h>

#define USE_ORIGINAL_MANAGER_FUNCS
#include <pspell/pspell.h>

#include <sys/types.h>
#include <dirent.h>

#define IS_SEPARATOR(x) (((x) == ' ') || \
                         ((x) == '\n') || \
                         ((x) == '.') || \
                         ((x) == ',') || \
                         ((x) == '!') || \
                         ((x) == '?') || \
                         ((x) == '(') || \
                         ((x) == ')'))

GdkFont *errorfont = NULL;
GList *dicts = NULL;

void 
shutdown_spelling                      (GtkWidget *widget) 
{
    userdata_t  *udata = NULL;
    unsigned long   uin; 

    uin=gtk_widget_get_active_uin(GTK_WIDGET(widget));
    udata=find_user_data(uin,NULL);
    if (udata == NULL ){
        return;
    }   
    if (udata->spellmanager != NULL) {
        delete_pspell_manager(udata->spellmanager);
        udata->spellmanager = NULL;
    }
}

PspellCanHaveError *
new_pspell_manager_from_dictstr        (char *dict)
{
    char **tmpsplit = NULL;
    PspellConfig * config = NULL;
    PspellCanHaveError * ret = NULL;
    int cnt;
    
    if (dict == NULL) {
        return(NULL);
    }

    tmpsplit = g_strsplit(dict,"-",0);

    if (tmpsplit == NULL) {
        return(NULL);
    }
    
    for(cnt = 0; tmpsplit[cnt] != NULL; cnt++);                
    if(cnt == 0) {
        return(NULL);
    }

    config = new_pspell_config();
    if (cnt > 1) {
        config->replace("language-tag", tmpsplit[0]);
    }
    if (cnt > 2) {
        config->replace("spelling", tmpsplit[1]);
    }
    if (cnt > 3) {
        config->replace("jargon", tmpsplit[2]);
    }
    config->replace("module", tmpsplit[cnt-1]);

    g_strfreev(tmpsplit);
                    
    ret = new_pspell_manager(config);
    delete_pspell_config(config);
    return(ret);
}

int 
setup_speller_per_user                 (unsigned long uin)
{
    struct spell_language *spell_language = NULL;
    PspellConfig * config = new_pspell_config();
    userdata_t  *udata;
    ICQUser         *user;
    char *language = NULL;
    PspellCanHaveError *ret = NULL;

    user = (uin>0)?gUserManager.FetchUser(uin,LOCK_R):
        gUserManager.FetchOwner(LOCK_R);
    udata=find_user_data(uin,NULL); 
    if (udata == NULL) {
        return(0);
    }
    if (udata->spellmanager != NULL) {
        delete_pspell_manager(udata->spellmanager);
        udata->spellmanager = NULL;
    }
    
    udata->spell_start_position = 0;
    if (user != NULL) {
        /* User the first language that matches */
        if (user->GetLanguage1() != 0) {
            spell_language = get_spell_language_by_code(user->GetLanguage1());
            if (spell_language != NULL)
                language = spell_language->pspell_code;
        } else  if (user->GetLanguage2() != 0) {
            spell_language = get_spell_language_by_code(user->GetLanguage2());
            if (spell_language != NULL)
                language = spell_language->pspell_code;

        } else if (user->GetLanguage3() != 0) {
            spell_language = get_spell_language_by_code(user->GetLanguage3());
            if (spell_language != NULL)
                language = spell_language->pspell_code;
        }
        gUserManager.DropUser(user);
    }
    switch (configuration.spelling_mode) {
        default:
        case USE_USER_LANG_AND_DEFAULT:
            ret = NULL;
            if ((language != NULL) && (strcmp(language,""))) {
                config->replace("language-tag", language);
                gbug("Using language '%s' for the spellchecker\n",spell_language->language);
                ret = new_pspell_manager(config);
            }
            if ((ret == NULL) || (ret->error_number() != 0)) {
                if (ret != NULL) {
                    gbug("%s\n",ret->error_message());
                    delete_pspell_can_have_error(ret);
                }
                gbug("Trying default dict '%s' for the spellchecker\n",configuration.defaut_dict);
                ret = new_pspell_manager_from_dictstr(configuration.defaut_dict);
                if ((ret == NULL) || (ret->error_number() != 0)) {
                    if (ret != NULL)  {
                        gbug("%s\n",ret->error_message());
                        delete_pspell_can_have_error(ret);
                    }
                    udata->spellmanager = NULL;
                    return(0);
                }
            } 
            udata->spellmanager = (PspellManager *) ret;
            udata->spell_enabled = 1;
            return(1);
            break;
        case USE_USER_LANG_AND_NONE:
            if ((language != NULL) && (strcmp(language,""))) {
                config->replace("language-tag", language);
                gbug("Using language '%s' for the spellchecker\n",spell_language->language);
                ret = new_pspell_manager(config);
                if (ret->error_number() != 0) {
                    gbug("%s\n",ret->error_message());
                    delete_pspell_can_have_error(ret);
                    udata->spellmanager = NULL;
                    udata->spell_enabled = 0;
                    return(0);
                } else {
                    udata->spellmanager = (PspellManager *) ret;
                    udata->spell_enabled = 1;
                    return(1);
                }
            }
            break;
        case USE_DEFAULT_LANG:
            gbug("Using default dict '%s' for the spellchecker\n",configuration.defaut_dict);
            ret = new_pspell_manager_from_dictstr(configuration.defaut_dict);
            if ((ret == NULL) || (ret->error_number() != 0)) {
                if (ret != NULL) {
                    gbug("%s\n",ret->error_message());
                    delete_pspell_can_have_error(ret);
                }
                udata->spellmanager = NULL;
                udata->spell_enabled = 0;
                return(0);
            }
            udata->spellmanager = (PspellManager *) ret;
            udata->spell_enabled = 1;
            return(1);
        case DISABLE_SPELL:
            udata->spellmanager = NULL;
            udata->spell_enabled = 0;
            return(0);
    }
    return(0); 
}

void 
init_dicts() 
{
    DIR *dir;
    struct dirent *entry;
    char *tmpname;
    char **tmpsplit;
    int cnt;
    PspellConfig * config = NULL;
    PspellCanHaveError * ret = NULL;
    
    if (strcmp(PSPELL_PKGDATADIR,"")) {
        if ((dir = opendir(PSPELL_PKGDATADIR)) != NULL){
            while((entry = readdir(dir)) != NULL) {
                if (!strncmp(&entry->d_name[strlen(entry->d_name)-5],".pwli",5)) {
                    gbug("Found dict %s\n",entry->d_name);
                    tmpname = g_strndup(entry->d_name,strlen(entry->d_name)-5);

                    dicts = g_list_append(dicts,tmpname);
#if 0                    
                    tmpsplit = g_strsplit(tmpname,"-",0);
                    
                    
                    for(cnt = 0; tmpsplit[cnt] != NULL; cnt++);                
                    
                    config = new_pspell_config();
                    if (cnt > 1) {
                        config->replace("language-tag", tmpsplit[0]);
                        gbug("init_dicts - language-tag: %s\n",tmpsplit[0]);
                    }
                    if (cnt > 2) {
                        //config->replace("spelling", tmpsplit[1]);
                        config->replace("spelling", "british");
                        gbug("init_dicts - spelling: %s\n",tmpsplit[1]);
                    }
                    if (cnt > 3) {
                        //config->replace("jargon", tmpsplit[2]);
                        gbug("init_dicts - jargon: %s\n",tmpsplit[2]);
                    }
                    //config->replace("module", tmpsplit[cnt-1]);
                    gbug("init_dicts - module: %s\n",tmpsplit[cnt-1]);
                    
                    
                    ret = new_pspell_manager(config);
                    delete_pspell_config(config); 
                    gbug("ret->error_number() = %d\n",ret->error_number());
                    if (ret->error_number() == 0) {
                        dicts = g_list_append(dicts,tmpname);
                        gbug("Insert %s in the dict list\n",tmpname);
                     //   delete_pspell_manager((PspellManager *) ret);
                        delete_pspell_can_have_error(ret);
                    } else {
                        gbug("init_dicts - new_pspell_manager: %s\n",ret->error_message());
                        delete_pspell_can_have_error(ret);
                    }
                    sleep(1);
                    config = NULL;
                    ret = NULL;
                    g_strfreev(tmpsplit);
#endif
                    //g_free(tmpname);
                }
            }
            closedir(dir);
        }
    }
    gbug("We have inserted %d dicts\n",g_list_length(dicts));
}

void 
load_spell_font() 
{
    if (errorfont != NULL) {
        gdk_font_unref(errorfont);
    }
    if (strcmp(configuration.spell_errorfont,"")) {
        errorfont = gdk_font_load(configuration.spell_errorfont);
    }
    if (errorfont == NULL) {
        errorfont = gdk_font_load("-*-*-bold-r-*-*-*-*-*-*-*-*-*-*");
    }
    gdk_font_ref(errorfont);    
}

void 
init_spellchecker () 
{
    load_spell_font();
    init_dicts();
}

int 
spellcheck_from_to                     (GtkText     *text,
                                        int         start, 
                                        int         stop) 
{
    int pos, endpos, tmppos,buflen, iscorrect;
    char *tmpword = NULL, *word = NULL, *buf = NULL;
    userdata_t  *udata = NULL;
    unsigned long   uin;
    int i,j;       
    GtkStyle  *style; 
    char *tmpchar;
     
    uin=gtk_widget_get_active_uin(GTK_WIDGET(text));
    udata=find_user_data(uin,NULL);
    if ((udata == NULL ) || (!udata->spell_enabled)) {
        return 0;
    }

    /* Save the current cursor position */
    tmppos = gtk_editable_get_position(GTK_EDITABLE(text));
    endpos = stop;
    if (buf == NULL) { /* Get the text if we don't have it */
        buf = gtk_editable_get_chars(GTK_EDITABLE(text),0,-1);
    }
    if (buf == NULL) {
        gbug("\nbuf == NULL!!!!!!\n\n");
        return 0;
    }
    buflen = strlen(buf);
   // gbug("start = %d stop = %d buflen = %d\n",start,stop,buflen);
    /* Set start position */
    pos = start; 
    if (!IS_SEPARATOR(buf[pos])){
        for(; (pos >= 0) && !IS_SEPARATOR(buf[pos]); pos--);
    } 
    pos++;

        
    /* Set end position */
    if (!IS_SEPARATOR(buf[endpos])) {
        for(; (endpos < buflen) && !IS_SEPARATOR(buf[endpos]); endpos++);
    }
   // gbug("pos = %d endpos = %d \n",pos,endpos);
    gtk_text_freeze(GTK_TEXT(text));
    for(j = i = pos; i <= endpos && buf[i]; i++) {
        if ((i != j) && (IS_SEPARATOR(buf[i]) || (i==endpos))) {
            /* To avoid a bug in pspell put a ' ' infront of the word */
            word = g_strndup(&buf[j],i-j);
            tmpword = g_strdup_printf("%s",word);
            
            if ((tmpword != NULL) && (word != NULL)){
                iscorrect = udata->spellmanager->check(tmpword);
            } else {
                iscorrect = -1;
            }

            if(iscorrect == 1) { //Correct
//                gbug("Word '%s' is correct actually tested is '%s'\n",word,tmpword);
//                gbug("Unmark %d to %d\n",j,i);
                gtk_editable_delete_text (GTK_EDITABLE(text),j,i);
                gtk_text_set_point (GTK_TEXT(text), j);
                gtk_text_insert(GTK_TEXT(text),global_editor_font,NULL,NULL, word,i-j);
            } else if (iscorrect == 0) { //Not Correct
//                gbug("Word '%s' is spelled wrong actually tested is '%s'\n",word,tmpword);
//                gbug("Put a mark %d to %d\n",j,i);
                gtk_editable_delete_text (GTK_EDITABLE(text),j,i);
                gtk_text_set_point (GTK_TEXT(text), j);

                gtk_text_insert(GTK_TEXT(text),errorfont,NULL,NULL, word,i-j);
            
            } else { //Error
                gbug("An error occured when spell checking '%s'\n",word);
            }
            g_free(tmpword);
            g_free(word);
    
            /* Workaround for the problem when you use backspace that font 
             * gets stuck. Replace the last space with a correct style space */
            if ((i==endpos) && (i < buflen) && 
                    IS_SEPARATOR(buf[i])) {
                gtk_text_thaw(GTK_TEXT(text));
                gtk_text_freeze(GTK_TEXT(text));
                tmpchar = g_strdup_printf("%c",buf[i]);
                if (tmpchar != NULL) {
                    gtk_text_set_point (GTK_TEXT(text), i);
                    gtk_editable_delete_text (GTK_EDITABLE(text),i,i+1);
                    gtk_text_insert(GTK_TEXT(text),global_editor_font,NULL,NULL, tmpchar,strlen(tmpchar));
                    //gtk_text_set_point (GTK_TEXT(text), i+2);
                    g_free(tmpchar);
                }
            }


            j = i+1;
        }
    }
    if (buf != NULL) {
        g_free(buf);
    }
    gtk_text_thaw(GTK_TEXT(text));
    gtk_editable_set_position (GTK_EDITABLE(text), tmppos);
    return(endpos+1);
}

gboolean        
spell_check_text                       (GtkWidget   *editable,
                                        GdkEventKey *event,
                                        gpointer    user_data)
{
    char *buf = NULL;
    int buflen = 0;
    userdata_t  *udata = NULL;
    unsigned long   uin;
    int pos;
     
    /* Adjust the startposition if nessecary */
    pos = gtk_editable_get_position(GTK_EDITABLE(editable));
    uin=gtk_widget_get_active_uin(GTK_WIDGET(editable));
    udata=find_user_data(uin,NULL);
    if ((udata == NULL) || (udata->spellmanager == NULL) || (event == NULL)){
       return TRUE;   
    }
    
    if (event->state == GDK_CONTROL_MASK) {
       return TRUE;   
    }
    
    if (pos < udata->spell_start_position) {
        udata->spell_start_position = pos;
    }

    /* Detect if we are going to spellcheck word */
    /* How are we going to handle up and down arrow? */
    buf = gtk_editable_get_chars(GTK_EDITABLE(editable),0,-1);
    
    if (buf == NULL) {
        return TRUE;
    }
    
    //gbug("buf[pos] = '%c' buf[pos-1] = '%c' buf[pos-2] = '%c'\n",buf[pos],(pos > 0)?buf[pos-1]:0,(pos > 1)?buf[pos-2]:0);
    switch (event->keyval) {
        case GDK_Left:
            {
                if (event->state == GDK_SHIFT_MASK) {
                    return TRUE;
                }
                buflen = strlen(buf);
                if (IS_SEPARATOR(buf[pos])) {
                    if (((pos) < buflen) && 
                            (pos == udata->spell_start_position)) {
                        udata->spell_start_position = 
                            spellcheck_from_to(GTK_TEXT(editable),
                                    pos+1,pos+1);
                    } else if ((pos) < buflen) {
                        udata->spell_start_position = 
                            spellcheck_from_to(GTK_TEXT(editable),
                                    udata->spell_start_position,pos+1);
                    }
                }
            }
            break;
        case GDK_Right:
            {
                if (event->state == GDK_SHIFT_MASK) {
                    return TRUE;
                }
                if (((pos - 2) >= 0) && IS_SEPARATOR(buf[pos-1])) {
                    if ((pos - 2) < udata->spell_start_position) {
                        udata->spell_start_position = pos - 2;
                    }
                    udata->spell_start_position = 
                        spellcheck_from_to(GTK_TEXT(editable),
                                udata->spell_start_position,pos-2);
                }
            }
            break;
        case GDK_Up:
            {    
                if (event->state == GDK_SHIFT_MASK) {
                    return TRUE;
                }
            }
            break;
        case GDK_Down:
            {
                if (event->state == GDK_SHIFT_MASK) {
                    return TRUE;
                }
                udata->spell_start_position = 
                    spellcheck_from_to(GTK_TEXT(editable),
                            udata->spell_start_position,pos);
            }
            break;
        case GDK_space:
        case GDK_Return:
        case GDK_period:
        case GDK_comma:
        case GDK_exclam:
        case GDK_question:
        case GDK_parenleft:
        case GDK_parenright:
            if ((pos - 2) >= 0) {
                if ((pos - 2) < udata->spell_start_position) {
                    udata->spell_start_position = pos - 2;
                }
                udata->spell_start_position = 
                    spellcheck_from_to(GTK_TEXT(editable),
                            udata->spell_start_position,pos-2);
            }
            break;
    }
    if (buf != NULL) {
        g_free(buf);
    }
    return TRUE;
}

void 
add_to_dictionary                      (GtkMenuItem     *menuitem,
                                        gpointer        user_data)
{
    GtkWidget *text = GTK_WIDGET(user_data);
    char *word = strdup((const char *) gtk_object_get_user_data(GTK_OBJECT(menuitem)));
    unsigned long   uin;
    int buflen;
    userdata_t  *udata = NULL;
        
    uin=gtk_widget_get_active_uin(GTK_WIDGET(text));
    udata=find_user_data(uin,NULL);
    
    if (udata != NULL) {
        udata->spellmanager->add_to_personal(word);
        udata->spellmanager->save_all_word_lists();
        gbug("Insert '%s' in personal dictionary\n",word);
        buflen = gtk_text_get_length(GTK_TEXT(text));
        udata->spell_start_position =
            spellcheck_from_to(GTK_TEXT(text),0,buflen-1);
    }
    g_free(word);
}

void
accept_this_session                    (GtkMenuItem     *menuitem,
                                        gpointer        user_data)
{
    GtkWidget *text = GTK_WIDGET(user_data);
    char *word = strdup((const char *) gtk_object_get_user_data(GTK_OBJECT(menuitem)));
    unsigned long   uin;
    int buflen;
    userdata_t  *udata = NULL;
    
    uin=gtk_widget_get_active_uin(GTK_WIDGET(text));
    udata=find_user_data(uin,NULL);
    if (udata != NULL) {
        udata->spellmanager->add_to_session(word);
        gbug("Accept '%s' this session\n",word);
        buflen = gtk_text_get_length(GTK_TEXT(text));
        udata->spell_start_position =
            spellcheck_from_to(GTK_TEXT(text),0,buflen-1);
    }
    g_free(word);
}


void
replace_word                           (GtkMenuItem     *menuitem,
                                        gpointer        user_data)
{
    GtkWidget *text = GTK_WIDGET(user_data);
    char *word = strdup((const char *) gtk_object_get_user_data(GTK_OBJECT(menuitem)));
    unsigned long   uin;
    int pos,endpos,buflen;
    userdata_t  *udata = NULL;
    char *buf;
    char *wrongword;
    
    pos = gtk_editable_get_position(GTK_EDITABLE(text));
    uin=gtk_widget_get_active_uin(GTK_WIDGET(text));
    udata=find_user_data(uin,NULL);
    
    buf = gtk_editable_get_chars(GTK_EDITABLE(text),0,-1);
    if (buf == NULL) {
        return;
    }
    buflen = strlen(buf); 
    endpos = pos;
    /* Set start position */
    if (!IS_SEPARATOR(buf[pos])){
        for(; (pos >= 0) && !IS_SEPARATOR(buf[pos]); pos--);
    } 
    pos++;

    /* Set end position */
    if (!IS_SEPARATOR(buf[endpos])) {
        for(; (endpos < buflen) && !IS_SEPARATOR(buf[endpos]) ; endpos++);
    }
   
    wrongword = g_strndup(&buf[pos],endpos-pos);
    if (udata != NULL) {
       udata->spellmanager->store_replacement(wrongword, word);
    }
    
    gtk_text_freeze(GTK_TEXT(text));
    gtk_editable_delete_text (GTK_EDITABLE(text),pos,endpos);
    gtk_text_set_point (GTK_TEXT(text), pos);
    gtk_text_insert(GTK_TEXT(text),global_editor_font,NULL,NULL, word,strlen(word));
    gtk_text_thaw(GTK_TEXT(text));
    gbug("gtk_editable_set_position : %d %d\n",pos, strlen(word));
    gtk_editable_set_position (GTK_EDITABLE(text), pos+strlen(word));
        
    g_free(word);
    g_free(buf);
    g_free(wrongword);
}

void
disable_spellchecking                  (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
    unsigned long   uin;
    userdata_t  *udata = NULL;
    char *buf;

    if (user_data == NULL)  {
        return;
    }

    buf = gtk_editable_get_chars(GTK_EDITABLE(user_data),0,-1);
    gtk_editable_delete_text (GTK_EDITABLE(user_data),0,-1);
    gtk_text_insert(GTK_TEXT(user_data),global_editor_font,NULL,NULL, buf,strlen(buf));
    
    uin=gtk_widget_get_active_uin(GTK_WIDGET(user_data));
    udata=find_user_data(uin,NULL);
    if (udata != NULL) {
        udata->spell_enabled = 0;
    }
    if (buf != NULL) {
        g_free(buf);
    }
}

void
enable_spellchecking                   (GtkMenuItem     *menuitem,
                                        gpointer        user_data)
{
    unsigned long   uin;
    int pos = 0;
    userdata_t  *udata = NULL;

    if (user_data == NULL)  {
        return;
    }
    uin=gtk_widget_get_active_uin(GTK_WIDGET(user_data));
    udata=find_user_data(uin,NULL);
    if (udata != NULL) {
        udata->spell_enabled = 1;
        pos = gtk_editable_get_position(GTK_EDITABLE(user_data));
        udata->spell_start_position =
            spellcheck_from_to(GTK_TEXT(user_data),0,pos);
    }
}

void 
popup_spell_menu                       (GtkText     *text,
                                        int         pos) 
{
    char *buf;
    char *word;
    char *tmpword;
    int endpos,buflen;
    userdata_t  *udata = NULL;
    unsigned long   uin;
         
    GtkWidget *menu;
    GtkWidget *menuitem;
    
    const PspellWordList *wl;
    PspellStringEmulation * els;
     
    uin=gtk_widget_get_active_uin(GTK_WIDGET(text));
    udata=find_user_data(uin,NULL);
   
    if ((udata == NULL) || (udata->spellmanager == NULL)){
        return;
    }
    
    buf = gtk_editable_get_chars(GTK_EDITABLE(text),0,-1);
    buflen = strlen(buf);
    endpos = pos;
    gbug("popup_spell_menu - pos : %d '%c'\n",pos,buf[pos]);

    /* if we are at the end of a word, go back to the word */
    if (IS_SEPARATOR(buf[pos])) { //end
        pos--;
    }
    
    /* Set start position */
    for(; (pos >= 0) && !IS_SEPARATOR(buf[pos]); pos--);
    pos++;

    /* Set end position */
    if (!IS_SEPARATOR(buf[endpos])) {
        for(; (endpos < buflen) && !IS_SEPARATOR(buf[endpos]) ; endpos++);
    }

    word = g_strndup(&buf[pos],endpos-pos);
    tmpword = g_strdup_printf("%s",word);
    /* if the word is incorrect create a menu! */
    if ((word != NULL) && (tmpword != NULL) &&
            (udata->spell_enabled) && (!udata->spellmanager->check(tmpword))) {
        
        wl = udata->spellmanager->suggest(tmpword);
        els = wl->elements();

        menu = gtk_menu_new();
        menuitem = gtk_menu_item_new_with_label(word);
        gtk_widget_show (menuitem);
        gtk_container_add (GTK_CONTAINER (menu), menuitem);
        
        menuitem = gtk_menu_item_new();
        gtk_widget_show (menuitem);
        gtk_container_add (GTK_CONTAINER (menu), menuitem);
        gtk_widget_set_sensitive (menuitem,FALSE);

        menuitem = gtk_menu_item_new_with_label(_("Add to dictionary"));
        gtk_widget_show (menuitem);
        gtk_container_add (GTK_CONTAINER (menu), menuitem);
        gtk_object_set_user_data(GTK_OBJECT(menuitem),strdup(word));
        gtk_signal_connect(GTK_OBJECT(menuitem),"destroy",
                GTK_SIGNAL_FUNC(destroy_notify_free_userdata),NULL);
        gtk_signal_connect(GTK_OBJECT(menuitem), "activate",
                GTK_SIGNAL_FUNC(add_to_dictionary), GTK_OBJECT (text));
            
        menuitem = gtk_menu_item_new_with_label(_("Accept this session"));
        gtk_widget_show (menuitem);
        gtk_container_add (GTK_CONTAINER (menu), menuitem);
        gtk_object_set_user_data(GTK_OBJECT(menuitem),strdup(word));
        gtk_signal_connect(GTK_OBJECT(menuitem),"destroy",
                GTK_SIGNAL_FUNC(destroy_notify_free_userdata),NULL);
        gtk_signal_connect(GTK_OBJECT(menuitem), "activate",
                GTK_SIGNAL_FUNC(accept_this_session), GTK_OBJECT (text));
        
        menuitem = gtk_menu_item_new_with_label(_("Disable spell checking"));
        gtk_widget_show (menuitem);
        gtk_container_add (GTK_CONTAINER (menu), menuitem);
        gtk_signal_connect(GTK_OBJECT(menuitem), "activate",
                GTK_SIGNAL_FUNC(disable_spellchecking), GTK_OBJECT (text));


        g_free(word);

        menuitem = gtk_menu_item_new();
        gtk_widget_show (menuitem);
        gtk_container_add (GTK_CONTAINER (menu), menuitem);
        gtk_widget_set_sensitive (menuitem,FALSE);

        while ( (word = (char *) els->next()) != NULL) {
            gbug("suggestions %s\n",word);
            menuitem = gtk_menu_item_new_with_label(word);
            gtk_widget_show (menuitem);
            gtk_container_add (GTK_CONTAINER (menu), menuitem);
            gtk_object_set_user_data(GTK_OBJECT(menuitem),strdup(word));
            gtk_signal_connect(GTK_OBJECT(menuitem),"destroy",
                    GTK_SIGNAL_FUNC(destroy_notify_free_userdata),NULL);
            gtk_signal_connect(GTK_OBJECT(menuitem), "activate",
                    GTK_SIGNAL_FUNC(replace_word), GTK_OBJECT (text));
        }

        gtk_widget_show(menu);
        gtk_menu_popup(GTK_MENU(menu),NULL,NULL,NULL,0,0,0);
    } else {
        g_free(word);
        menu = gtk_menu_new();
        
        if (udata->spell_enabled) {
            menuitem = gtk_menu_item_new_with_label(_("Disable spell checking"));
            gtk_widget_show (menuitem);
            gtk_container_add (GTK_CONTAINER (menu), menuitem);
            gtk_signal_connect(GTK_OBJECT(menuitem), "activate",
                    GTK_SIGNAL_FUNC(disable_spellchecking), GTK_OBJECT (text));

        } else {

            menuitem = gtk_menu_item_new_with_label(_("Enable spell checking"));
            gtk_widget_show (menuitem);
            gtk_container_add (GTK_CONTAINER (menu), menuitem);
            gtk_signal_connect(GTK_OBJECT(menuitem), "activate",
                    GTK_SIGNAL_FUNC(enable_spellchecking), GTK_OBJECT (text));
        }
        
        gtk_widget_show(menu);
        gtk_menu_popup(GTK_MENU(menu),NULL,NULL,NULL,0,0,0);

    }
    g_free(tmpword);
    g_free(buf);            
}

gboolean 
on_spell_button_release                (GtkWidget *widget,
                                        GdkEventButton *event,
                                        gpointer user_data)
{
    int pos;
    userdata_t  *udata = NULL;
    unsigned long   uin;
    pos = gtk_editable_get_position(GTK_EDITABLE(widget));
    
    switch (event->button) {
        case 1:
            uin=gtk_widget_get_active_uin(GTK_WIDGET(widget));
            udata=find_user_data(uin,NULL);
            if (udata != NULL) {
                if (pos > udata->spell_start_position) {
                    udata->spell_start_position = 
                        spellcheck_from_to(GTK_TEXT(widget),
                            udata->spell_start_position,pos);
                }
            }
            break;
        case 2:
            if (udata!= NULL) {
                udata->spell_start_position =
                    spellcheck_from_to(GTK_TEXT(widget),0,pos);
            }
            break;
        case 3:
            popup_spell_menu(GTK_TEXT(widget),pos);
            break;
    }
    return TRUE;
}
  
int 
connect_spell_checker_to_gtktext       (GtkText     *text,
                                        userdata_t  *udata)
{
    if(udata->spell_enabled) {
        gtk_signal_connect_after(GTK_OBJECT(text),"key-press-event",
                GTK_SIGNAL_FUNC(spell_check_text),NULL);
        gtk_signal_connect_after(GTK_OBJECT(text),"button-release-event",
                GTK_SIGNAL_FUNC(on_spell_button_release),NULL);
        gbug("Spellling callback added!\n");
    }

    return(0);
}


#endif
