#ifdef HAVE_CONFIG_H
#include "config.h"
#endif
#include <string.h>

#include "spell_languagecodes.h"

#ifdef USE_PSPELL

#include "spell_languagecodes.h"

const struct spell_language spell_language_codes[NUM_SPELL_LANGUAGES] =
{
  { "Afrikaans", 55, "af" },
  { "Albanian", 58, "sq" },
  { "Arabic", 1, "ar" },
  { "Armenian", 59, "hy" }, 
  { "Bhojpuri", 2, "" }, //FIXME
  { "Bulgarian", 3, "bg" },
  { "Burmese", 4, "mv" },
  { "Cantonese", 5, "" }, //FIXME
  { "Catalan", 6, "ca" },
  { "Chinese", 7, "zh" },
  { "Croatian", 8, "hr" },
  { "Czech", 9, "cs" },
  { "Danish", 10, "da" },
  { "Dutch", 11, "nl" },
  { "English", 12, "en" },
  { "Esperanto", 13, "eo" },
  { "Estonian", 14, "et" },
  { "Farsi", 15, "" }, //FIXME
  { "Finnish", 16, "fi" },
  { "French", 17, "fr" },
  { "Gaelic", 18, "" }, //FIXME
  { "German", 19, "de" },
  { "Greek", 20, "el" },
  { "Hebrew", 21, "he" },
  { "Hindi", 22, "hi" },
  { "Hungarian", 23, "hu" },
  { "Icelandic", 24, "is" },
  { "Indonesian", 25, "id" },
  { "Italian", 26, "it" },
  { "Japanese", 27, "ja" },
  { "Khmer", 28, "km" },
  { "Korean", 29, "ko" },
  { "Lao", 30, "lo" },
  { "Latvian", 31, "lv" },
  { "Lithuanian", 32, "lt" },
  { "Malay", 33, "ms" },
  { "Norwegian", 34, "no" },
  { "Persian", 57, "fa" },
  { "Polish", 35, "pl" },
  { "Portuguese", 36, "pt" },
  { "Romanian", 37, "ro" },
  { "Russian", 38, "ru" },
  { "Serbian", 39, "sr" },
  { "Slovak", 40, "sk" },
  { "Slovenian", 41, "sl" },
  { "Somali", 42, "so" },
  { "Spanish", 43, "es" },
  { "Swahili", 44, "sw" },
  { "Swedish", 45, "sv" },
  { "Tagalog", 46, "tl" },
  { "Tatar", 47, "tt" },
  { "Thai", 48, "th" },
  { "Turkish", 49, "tr" },
  { "Ukrainian", 50, "uk" },
  { "Urdu", 51, "ur" },
  { "Vietnamese", 52, "vi" },
  { "Yiddish", 53, "yi" },
  { "Yoruba", 54, "yo" },
};

struct spell_language *get_spell_language_by_code(int code)
{
    int i;
    for(i = 0; (i < NUM_SPELL_LANGUAGES) && 
            (spell_language_codes[i].licq_code != code); i++);
    
    if (spell_language_codes[i].licq_code == code) {
        return  (spell_language*)&spell_language_codes[i];
    } else {
        return NULL;
    } 
}

#endif
