#include "licq_filetransfer.h"
#include "licq_icqd.h"

#include "gtk-gui.h"
#include "transfer_dialog.h"

GList *filetransfers = NULL;

ft_content *ft_find(GtkWidget *dialog) {
    int i,len;
    GList *tmp_list = NULL;
    ft_content *c;

    len = g_list_length(filetransfers);

    tmp_list = g_list_first(filetransfers);
    for(i=0; (i < len) && (dialog != ((ft_content *) tmp_list->data)->dialog); i++) {
        tmp_list = g_list_next(tmp_list);
    }

    if (tmp_list == NULL) {
        //chat_msg(dialog,_("Cant find the current chatsession"));
        return NULL;
    }

    return((ft_content *) tmp_list->data);
}

int
trans_info(GtkWidget *dialog, const char *text)
{
    if (dialog != NULL) {
        GtkWidget *send_info_label = lookup_widget(dialog,"send_info_label");
        if (send_info_label != NULL) {
            gtk_label_set_text(GTK_LABEL(send_info_label),text);
        }
        return(0);
    } else {
        return(-1);
    }
}


int
set_finfo(GtkWidget *dialog)
{
    GtkWidget *file_transfer_label = lookup_widget(dialog,
            "file_transfer_label");
    GtkWidget *batch_transfer_label = lookup_widget(dialog,
            "batch_transfer_label");
    GtkWidget *fileno_label = lookup_widget(dialog,
            "fileno_label");
    GtkWidget *transfer_speed_label = lookup_widget(dialog,
            "transfer_speed_label");

    char *text;
    int i = 0,hour,min,sec;
    unsigned long speed,avgspeed,tot,usec_since_start,usec_since_last;
    //unsigned long wspeed;
    char *filename;
    int filesize = 0;
    struct timeval tv_now;
    int bytes_trans, bytes_left;
    
    ft_content *f;
    f = ft_find(dialog);

    if (f == NULL) {
        return(-1);
    }

    filename = strdup(f->ftman->FileName());

    for (i = strlen(filename)-1; ((i > 0) && (filename[i] != '/')); i--);
    if(filename[i] == '/') {
        i++;
    }
    
    filesize = f->ftman->FileSize();
    bytes_trans = f->size_of_transfered_files + f->ftman->BytesTransfered();
    bytes_left = f->ftman->BatchSize() - bytes_trans;
    gettimeofday(&tv_now,NULL);
    usec_since_start = (tv_now.tv_sec - f->start_time) * 1000000 + 
        (tv_now.tv_usec - f->start_utime);
    usec_since_last = (tv_now.tv_sec - f->last_time) * 1000000 +
                (tv_now.tv_usec - f->last_utime);
    
    text = g_strdup_printf(_("%s: %ld / %d KB"),
            &filename[i],f->ftman->BytesTransfered()>>10,filesize>>10);
    gtk_label_set_text(GTK_LABEL(file_transfer_label),text);
    g_free(text);
    
    text = g_strdup_printf(_("Total: %d / %ld KB"), bytes_trans >>10, f->ftman->BatchSize()>>10);
    gtk_label_set_text(GTK_LABEL(batch_transfer_label),text);
    g_free(text);
    
    text  = g_strdup_printf(_("%d/%d"), f->currfile,f->files);
    gtk_label_set_text(GTK_LABEL(fileno_label),text);
    g_free(text);
    
    if (usec_since_last > 0) {
        speed = (unsigned long) ((f->ftman->BytesTransfered() - 
                    f->bytes_last_time)/ (usec_since_last/1000000.0));
        f->speed = speed;
    } else {
        speed = f->speed;
    }
    
    if (usec_since_start > 0) {
        avgspeed = (unsigned long) (bytes_trans / (usec_since_start/1000000.0));
    } else {
        avgspeed = speed;
    }
    
    // wspeed = (unsigned long) (avgspeed * (float) ((bytes_left)/ (float) f->ftman->BatchSize()) +  speed * (float) ((bytes_trans) / (float) f->ftman->BatchSize())); 
    if (avgspeed > 0) {
        tot = bytes_left/avgspeed ;
        sec = tot % 60;
        min = (tot/60) % 60;
        hour = tot/3600;
    } else {
        sec = 0;
        min = 0;
        hour = 0;
    }
    
//    gbug("\nbytes_trans %d bytes_left %d\navgspeed %d speed %d wspeed %d\ntime_from_start  %d last_time %d\n",bytes_trans,bytes_left,avgspeed,speed,wspeed,(tv_now.tv_sec - f->start_time),(tv_now.tv_sec - f->last_time));
    text = g_strdup_printf(_("Speed: %ld KB/s   ETA: %d:%02d:%02d"), speed >> 10,hour,min,sec);
    
    gtk_label_set_text(GTK_LABEL(transfer_speed_label),text);
    g_free(text);
    free(filename);
    return(0);
}


int
set_progress(GtkWidget *dialog,float percentage)
{
    GtkWidget *file_progressbar = lookup_widget(dialog,"file_progressbar");

    gtk_progress_bar_update (GTK_PROGRESS_BAR(file_progressbar),percentage);
    return(0);
}

int
set_batchprogress(GtkWidget *dialog,float percentage)
{
    GtkWidget *file_progressbar = lookup_widget(dialog,"batch_progressbar");

    gtk_progress_bar_update (GTK_PROGRESS_BAR(file_progressbar),percentage);
    return(0);
}

void close_transfer(GtkWidget *dialog) {
    ft_content *f;
    int len,j;
    GList *tmp_list;
    GtkWidget *speed_scale = lookup_widget(dialog,"transfer_speed_hscale");
    GtkAdjustment *adjustment = gtk_range_get_adjustment(GTK_RANGE(speed_scale));
    
    gtk_signal_disconnect_by_func   (GTK_OBJECT(adjustment),
             GTK_SIGNAL_FUNC (on_speed_scale_value_changed),
             dialog);
    
    f = ft_find(dialog);
    
    if (f != NULL) {
        gtk_input_remove(f->ft_handler);
        f->ftman->CloseFileTransfer();
        delete f->ftman;
        f->ftman = NULL;
    }
    
    len = g_list_length(filetransfers);
    tmp_list = g_list_first(filetransfers);
    for(j=0; j < len; j++) {
        if (dialog == ((ft_content *) tmp_list->data)->dialog )  {
            free(tmp_list->data);
            filetransfers = g_list_remove_link(filetransfers,tmp_list);
            break;
        }
        tmp_list = g_list_next(tmp_list);
    }
}

void extract_files(const char *filename,  ConstFileList *filelist) {
    int i,len,tpos;
    char *tmp;
    
    len =  strlen(filename);
    if ((tmp = (char *) malloc(len)) == NULL) {
        gbug("Not enough memory to extract filenames\n");
        return;
    }
    memset(tmp,0,len);
    
    for (i = 0; i < len; i++) {
        if (filename[i] != ' ') {
            tpos = 0;
            for (; (i < len) && 
                    ((i != 0) && (filename[i] != ',') && 
                     (filename[i-1] != '\\')); i++) {
                if ((filename[i] != '\\') || (filename[i-1] != '\\')) {
                    tmp[tpos++] = filename[i];                
                }
            }
            tmp[tpos++] = '\0';
            //filelist.push_back(tmp);
            gbug("filename: %s\n",tmp);
        }
    }
    free(tmp);
    return;
}

int 
file_send(unsigned long uin, const char *filename, int port, GtkWidget *dialog) 
{
    ft_content *f;
    ConstFileList filelist;
    
    //extract_files(filename, &filelist);
    
    filelist.push_back(filename);
    
    if(!GTK_WIDGET_VISIBLE(dialog)){
        gtk_widget_show(dialog);
    }

    f = ft_find(dialog);
    if (f == NULL) {
        showokdialog(_("Error"),_("Cant find the current file transfer session\nFile transfer canceled"));
        return 0;
    }     

    f->ftman = new CFileTransferManager(licq_daemon, uin);

    f->ftman->SetUpdatesEnabled(1);
    f->ftman->SendFiles(filelist,port);

    if((f->ft_handler = gtk_input_add_full(f->ftman->Pipe(),GDK_INPUT_READ,slot_ft,NULL,dialog,NULL)) == 0) {
        showokdialog(_("Error"),_("Signal file_handler error\nFile transfer canceled"));
        return (-1);
    }
    trans_info(dialog,_("Sending file(s)."));

    return(0);
}

int file_recive(unsigned long uin, char *dir, GtkWidget *dialog)
{
    ft_content *f;

    if(!GTK_WIDGET_VISIBLE(dialog)){
        gtk_widget_show(dialog);
    }
    f = ft_find(dialog);
    if (f == NULL) {
        showokdialog(_("Error"),_("Cant find the current file transfer session\nFile transfer canceled"));
        return -1;
    }     

    f->ftman = new CFileTransferManager(licq_daemon, uin);

    f->ftman->SetUpdatesEnabled(1);
    if (!f->ftman->ReceiveFiles(dir)){
        return -1;
    }

    if((f->ft_handler = gtk_input_add_full(f->ftman->Pipe(),GDK_INPUT_READ,slot_ft,NULL,dialog,NULL)) == 0) {
        showokdialog(_("Error"),_("Signal file_handler error\nFile transfer canceled"));
        return (-1);
    }
    trans_info(dialog,_("Receiving file(s)."));

    return(f->ftman->LocalPort());
}

void slot_ft(void *v, int iii, GdkInputCondition g)
{
    GtkWidget *dialog = (GtkWidget *) v;
    char buf[32];
    char *msg;
    ft_content *f;
    struct timeval tv;
    
    f = ft_find(dialog);
    if (f == NULL) {
        return;
    }
    
    read(f->ftman->Pipe(), buf, 32);
    
    gettimeofday(&tv,NULL);
    CFileTransferEvent *e = NULL;
    while ( (e = f->ftman->PopFileTransferEvent()) != NULL)
    {
        switch(e->Command())
        {

            case FT_STARTxBATCH:
                {
                    set_batchprogress(dialog,0.0);
                    f->size_of_transfered_files = 0;
                    f->files = f->ftman->BatchFiles();
                    f->currfile = 0;
                    f->bytes_last_time = 0;
                    f->last_time = tv.tv_sec; 
                    f->last_utime = tv.tv_usec; 
                    f->start_time = tv.tv_sec; 
                    f->start_utime = tv.tv_usec; 
                    f->speed = 0;
                    break;
                }

            case FT_STARTxFILE:
                {
                    f->currfile++;
                    set_finfo(dialog);
                    set_progress(dialog,0.0);
                    f->bytes_last_time = 0;
                    f->last_time = tv.tv_sec; 
                    f->last_utime = tv.tv_usec; 
                    break;
                }

            case FT_UPDATE:
                {
                    set_finfo(dialog);
                    f->last_time =  tv.tv_sec;
                    f->last_utime = tv.tv_usec; 
                    f->bytes_last_time = f->ftman->BytesTransfered();
                    set_progress(dialog,((float )(f->ftman->FilePos())/f->ftman->FileSize()));
                    set_batchprogress(dialog,
                            ((float )((f->size_of_transfered_files) + 
                                      f->ftman->FilePos()) /
                             f->ftman->BatchSize()));
                    break;
                }

            case FT_DONExFILE:
                {
                    set_finfo(dialog);
                    set_progress(dialog,1.0);
                    f->size_of_transfered_files += f->ftman->BytesTransfered();
                    set_batchprogress(dialog,(((float) f->size_of_transfered_files)/f->ftman->BatchSize()));
                    break;
                }
            case FT_DONExBATCH:
                {
                    GtkWidget *file_autoclose_checkbutton = lookup_widget(
                            GTK_WIDGET(dialog),"file_autoclose_checkbutton");
                    GtkWidget *send_cancel_button = lookup_widget(
                            GTK_WIDGET(dialog),"send_cancel_button");
                    bool close_dialog = gtk_toggle_button_get_active(
                            GTK_TOGGLE_BUTTON(file_autoclose_checkbutton));
                    set_batchprogress(dialog,1.0);
                    trans_info(dialog,_("File transfer done."));
                    close_transfer(dialog);
                    
                    if (close_dialog){
                        gtk_widget_destroy(dialog);
                    } else {
                        gtk_licq_button_set(GTK_BUTTON(send_cancel_button),
                                GTK_LICQ_BUTTON_DONE);
                    }


                    delete e;
                    return;
                }

            case FT_ERRORxCLOSED:
                {
                    trans_info(dialog,_("Error!\nRemote end disconnected."));
                    break;
                }

            case FT_ERRORxFILE:
                {
                    trans_info(dialog,_("File error,\n see log for details."));
                    break;
                }

            case FT_ERRORxHANDSHAKE:
                {
                    trans_info(dialog,_("Handshake error."));
                    break;
                }
        }
        delete e;
    }
}

void
on_transfer_dialog_show                (GtkWidget       *widget,
                                        gpointer         user_data)
{
    GtkWidget *speed_scale = lookup_widget(widget,"transfer_speed_hscale");
    GtkAdjustment *adjustment = gtk_range_get_adjustment(GTK_RANGE(speed_scale));
    GtkWidget *file_autoclose_checkbutton = lookup_widget(
            GTK_WIDGET(widget),"file_autoclose_checkbutton");

    ft_content *f;

    f = ft_find(widget);
    if (f != NULL) {
        return;
    }
    
    if (( f = (ft_content *) malloc(sizeof(ft_content))) == NULL){
        gbug("malloc error when creating file transfer content.\n");
        return;
    }
    
    f->ftman = NULL;
    f->dialog = widget;
    f->size_of_transfered_files = 0;
    f->files = 0;
    f->currfile = 0;
    f->bytes_last_time = 0;
    f->last_time = 0;
    f->last_utime = 0;
    f->start_time = 0;
    f->start_utime = 0;
    f->speed = 0;
    filetransfers = g_list_append(filetransfers,f);

    gtk_toggle_button_set_active(
            GTK_TOGGLE_BUTTON(file_autoclose_checkbutton),
            configuration.auto_close_file_win);
    
    //FIXME: 
    /* Remove this line when the speed is implemented in the deamon */
    gtk_widget_hide(speed_scale);
    gtk_signal_connect (GTK_OBJECT (adjustment), "value-changed",
            GTK_SIGNAL_FUNC (on_speed_scale_value_changed),
            widget);
}


gboolean
on_transfer_dialog_destroy_event       (GtkWidget       *widget,
                                        GdkEvent        *event,
                                        gpointer         user_data)
{
    close_transfer(widget);
    return FALSE;
}

void
on_send_cancel_button_clicked          (GtkButton       *button,
        gpointer         user_data)
{
    GtkWidget *transfer_dialog = lookup_widget(
            GTK_WIDGET(button),"transfer_dialog");
    close_transfer(transfer_dialog);
    gtk_widget_destroy(transfer_dialog);
}

void
on_speed_scale_value_changed    (GtkWidget       *widget,
        gpointer         user_data)
{
    GtkWidget *dialog = GTK_WIDGET(user_data);
    ft_content *f;
    char *msg;

    f = ft_find(dialog);
    if (f == NULL) {
        return;
    }
    f->ftman->ChangeSpeed((unsigned short) GTK_ADJUSTMENT(widget)->value);

    msg = g_strdup_printf("Speed: %d%%",(unsigned short) GTK_ADJUSTMENT(widget)->value);
    trans_info(dialog,msg);
    g_free(msg);
}

void
on_file_autoclose_checkbutton_toggled  (GtkToggleButton *togglebutton,
                                        gpointer         user_data)
{

    bool close_dialog = gtk_toggle_button_get_active(
            GTK_TOGGLE_BUTTON(togglebutton));

    configuration.auto_close_file_win = close_dialog;

}


