#include <glib.h>
#include "gtk-gui.h"
#include "user_info_dialog.h"
#include "functions.h"
#include "interface.h"
#include "autoresponse.h"
#include "licq_countrycodes.h"
#include "licq_languagecodes.h"
#include "contactlist.h"

void
info_set_status_to_user     (GtkMenuItem     *menuitem,
                             gpointer         user_data)
{
    int uin;
    uin = gtk_widget_get_active_uin(GTK_WIDGET(menuitem));
    
    ICQUser *u = gUserManager.FetchUser(uin, LOCK_W);
    if (u != NULL) {
        u->SetStatusToUser(GPOINTER_TO_INT(user_data));
    }
    gUserManager.DropUser(u);

}

/****************************************************************************
                        Functions to fill in and save the info
 ****************************************************************************/

int 
fill_in_general_info        (GtkWidget      *window,
                             unsigned long  uin)
{
    ICQUser     *user = NULL;
    char        buf[32];
    const struct SCountry *country;
    GtkWidget   *alias_entry = lookup_widget(window,
            "general_alias_entry");
    GtkWidget   *firstname_entry = lookup_widget(window,
            "general_firstname_entry");
    GtkWidget   *lastname_entry = lookup_widget(window,
            "general_lastname_entry");
    GtkWidget   *primaryemail_entry = lookup_widget(window,
            "general_primaryemail_entry");
    GtkWidget   *secondaryemail_entry = lookup_widget(window,
            "general_secondary_entry");
    GtkWidget   *oldemail_entry = lookup_widget(window,
            "general_oldemail_entry");
    GtkWidget   *phone_entry = lookup_widget(window,
            "general_phone_entry");
    GtkWidget   *cellular_entry = lookup_widget(window,
            "general_cellular_entry");
    GtkWidget   *fax_entry = lookup_widget(window,
            "general_fax_entry");
    GtkWidget   *address_text = lookup_widget(window,
            "general_adress_text");
    GtkWidget   *state_entry = lookup_widget(window,
            "general_state_entry");
    GtkWidget   *city_entry = lookup_widget(window,
            "general_city_entry");
    GtkWidget   *country_entry= lookup_widget(window,
            "general_country_entry");
    GtkWidget   *zip_entry = lookup_widget(window,
            "general_zipcode_entry");
    GtkWidget   *timezone_entry = lookup_widget(window,
            "general_timezone_entry");
    GtkWidget *country_combo = lookup_widget(window,
            "general_country_combo");
    GtkWidget *general_hide_email_checkbutton = lookup_widget(window,
            "general_hide_email_checkbutton");
    char *timezone;
    int i;
 
    gbug("fill_in_general_info\n");
    if ((uin == 0) || uin == gUserManager.OwnerUin()){
        gtk_widget_show(general_hide_email_checkbutton);
    } else {
        gtk_widget_hide(general_hide_email_checkbutton);
    }
    
    user = (uin > 0)?gUserManager.FetchUser(uin,LOCK_R):gUserManager.FetchOwner(LOCK_R);
    if (user != NULL) {
        if (user->GetAlias() != NULL)
            gtk_entry_set_text(GTK_ENTRY(alias_entry),user->GetAlias());
        if (user->GetFirstName() != NULL)
            gtk_entry_set_text(GTK_ENTRY(firstname_entry),user->GetFirstName());
        if (user->GetLastName() != NULL)
            gtk_entry_set_text(GTK_ENTRY(lastname_entry),user->GetLastName());
        if (user->GetEmailPrimary() != NULL)
            gtk_entry_set_text(GTK_ENTRY(primaryemail_entry),user->GetEmailPrimary());
        if (user->GetEmailSecondary() != NULL)
            gtk_entry_set_text(GTK_ENTRY(secondaryemail_entry),
                    user->GetEmailSecondary());
        if (user->GetEmailOld() != NULL)
            gtk_entry_set_text(GTK_ENTRY(oldemail_entry),user->GetEmailOld());
        if (user->GetState() != NULL)
            gtk_entry_set_text(GTK_ENTRY(state_entry),user->GetState());
        if (user->GetCity() != NULL)
            gtk_entry_set_text(GTK_ENTRY(city_entry),user->GetCity());
        if (user->GetAddress() != NULL) {
            gtk_editable_delete_text (GTK_EDITABLE(address_text),0,-1);
            gtk_text_insert(GTK_TEXT(address_text),NULL,NULL,NULL,
                    user->GetAddress(),strlen(user->GetAddress()));
        } 

        if (user->GetPhoneNumber() != NULL)
            gtk_entry_set_text(GTK_ENTRY(phone_entry),user->GetPhoneNumber());
        if (user->GetCellularNumber() != NULL)
            gtk_entry_set_text(GTK_ENTRY(cellular_entry),user->GetCellularNumber());
        if (user->GetFaxNumber() != NULL)
            gtk_entry_set_text(GTK_ENTRY(fax_entry),user->GetFaxNumber());
        if (user->GetZipCode()) {
            gtk_entry_set_text(GTK_ENTRY(zip_entry),user->GetZipCode());
        } else {
            gtk_entry_set_text(GTK_ENTRY(zip_entry),"");
        }
        timezone= g_strdup_printf("%d",user->GetTimezone());
        gtk_entry_set_text(GTK_ENTRY(timezone_entry),timezone);
        g_free(timezone);
        
        stuff_combo_with_countries(GTK_COMBO(country_combo));
        
        country=GetCountryByCode(user->GetCountryCode());
        gtk_entry_set_text(GTK_ENTRY(country_entry),
                (country!=NULL)?country->szName:_("Unspecified"));

        gtk_toggle_button_set_active(
                GTK_TOGGLE_BUTTON(general_hide_email_checkbutton),
                user->GetHideEmail());
        gUserManager.DropUser(user);
    }

    return 0;
}

int 
fill_in_more_info           (GtkWidget      *window,
                             unsigned long  uin)
{
    ICQUser *user = NULL;
    char *age; 
    char *birthday;
    GtkWidget *age_spinbutton = lookup_widget(window,"more_age_spinbutton");
    GtkWidget *gender_entry = lookup_widget(window,
            "more_gender_entry");
    GtkWidget *gender_combo = lookup_widget(window,
            "more_gender_combo");
    GtkWidget *homepage_entry = lookup_widget(window,"more_homepage_entry");
    GtkWidget *l1_entry = lookup_widget(window,"more_language_1_entry");
    GtkWidget *l2_entry = lookup_widget(window,"more_language_2_entry");
    GtkWidget *l3_entry = lookup_widget(window,"more_language_3_entry");
    GtkWidget *birthday_year_spinbutto = lookup_widget(window,
            "more_birthday_year_spinbutton");
    GtkWidget *birthday_month_spinbutto = lookup_widget(window,
            "more_birthday_month_spinbutton");
    GtkWidget *birthday_day_spinbutto = lookup_widget(window,
            "more_birthday_day_spinbutton");
    GtkWidget *language_1_combo = lookup_widget(window,
            "more_language_1_combo");
    GtkWidget *language_2_combo = lookup_widget(window,
            "more_language_2_combo");
    GtkWidget *language_3_combo = lookup_widget(window,
            "more_language_3_combo");
    int i;
    const struct SLanguage *language1;
    const struct SLanguage *language2;
    const struct SLanguage *language3;
    GList *genders=NULL;
    int userage;
    
    gbug("fill_in_more_info\n");
    user = (uin > 0)?gUserManager.FetchUser(uin,LOCK_R):gUserManager.FetchOwner(LOCK_R);
    if (user != NULL) {
        userage = user->GetAge();
        
        gbug("Age: %d\n", userage);
        if (userage <= 150) {
            gtk_spin_button_set_value (GTK_SPIN_BUTTON(age_spinbutton),userage);
        } else {
            gtk_spin_button_set_value (GTK_SPIN_BUTTON(age_spinbutton),0);

        }
        genders = g_list_append(genders,(void*)_("Male"));
        genders = g_list_append(genders,(void*)_("Female"));
        genders = g_list_append(genders,(void*)_("Unspecified"));
        gtk_combo_set_popdown_strings(GTK_COMBO(gender_combo),genders);
        
        if (user->GetGender() == GENDER_MALE) {
            gtk_entry_set_text(GTK_ENTRY(gender_entry),_("Male"));
        } else if (user->GetGender() == GENDER_FEMALE) {
            gtk_entry_set_text(GTK_ENTRY(gender_entry),_("Female"));
        } else {
            gtk_entry_set_text(GTK_ENTRY(gender_entry),_("Unspecified"));
        }
        
        if (user->GetHomepage() != NULL)
            gtk_entry_set_text(GTK_ENTRY(homepage_entry),user->GetHomepage());
        gtk_spin_button_set_value (GTK_SPIN_BUTTON(birthday_year_spinbutto),user->GetBirthYear());
        gtk_spin_button_set_value (GTK_SPIN_BUTTON(birthday_month_spinbutto),user->GetBirthMonth());
        gtk_spin_button_set_value (GTK_SPIN_BUTTON(birthday_day_spinbutto),user->GetBirthDay());
        
        stuff_combo_with_languages(GTK_COMBO(language_1_combo)); 
        stuff_combo_with_languages(GTK_COMBO(language_2_combo)); 
        stuff_combo_with_languages(GTK_COMBO(language_3_combo)); 
        
        language1=GetLanguageByCode(user->GetLanguage1());
        gtk_entry_set_text(GTK_ENTRY(l1_entry),
                (language1!=NULL)?language1->szName:_("Unspecified"));

        language2=GetLanguageByCode(user->GetLanguage2());
        gtk_entry_set_text(GTK_ENTRY(l2_entry),
                (language1!=NULL)?language2->szName:_("Unspecified"));

        language3=GetLanguageByCode(user->GetLanguage3());
        gtk_entry_set_text(GTK_ENTRY(l3_entry),
                (language1!=NULL)?language3->szName:_("Unspecified"));

        gUserManager.DropUser(user);
    }
    return 0;
}

int 
fill_in_work_info           (GtkWidget      *window,
                             unsigned long  uin)
{
    ICQUser *user = NULL;

    GtkWidget *w_name_entry = lookup_widget(window,
            "work_name_entry");
    GtkWidget *w_department_entry = lookup_widget(window,
            "work_department_entry");
    GtkWidget *w_position_entry = lookup_widget(window,
            "work_position_entry");
    GtkWidget *w_city_entry = lookup_widget(window,
            "work_city_entry");
    GtkWidget *w_state_entry = lookup_widget(window,
            "work_state_entry");
    GtkWidget *w_address_text = lookup_widget(window,
            "work_adress_text");
    GtkWidget *w_homepage_entry = lookup_widget(window,
            "work_homepage_entry");

    gbug("fill_in_more_info\n");
    user=(uin>0)?gUserManager.FetchUser(uin,LOCK_R):
        gUserManager.FetchOwner(LOCK_R);

    if (user != NULL) {
        if (user->GetCompanyName() != NULL)
            gtk_entry_set_text(GTK_ENTRY(w_name_entry),
                    user->GetCompanyName());
        if (user->GetCompanyDepartment() != NULL)
            gtk_entry_set_text(GTK_ENTRY(w_department_entry),
                    user->GetCompanyDepartment());
        if (user->GetCompanyPosition() != NULL)
            gtk_entry_set_text(GTK_ENTRY(w_position_entry),
                    user->GetCompanyPosition());
        if (user->GetCompanyCity() != NULL)
            gtk_entry_set_text(GTK_ENTRY(w_city_entry),
                    user->GetCompanyCity());
        if (user->GetCompanyState() != NULL)
            gtk_entry_set_text(GTK_ENTRY(w_state_entry),
                    user->GetCompanyState());
        if (user->GetCompanyAddress() != NULL) {
            gtk_editable_delete_text (GTK_EDITABLE(w_address_text),0,-1);
            gtk_text_insert(GTK_TEXT(w_address_text),NULL,NULL,NULL,
                    user->GetCompanyAddress(),
                    strlen(user->GetCompanyAddress())); 
        }
        if (user->GetCompanyHomepage() != NULL)
            gtk_entry_set_text(GTK_ENTRY(w_homepage_entry),
                    user->GetCompanyHomepage());
        gUserManager.DropUser(user);
    }

    return 0;
}

int 
fill_in_about_info      (GtkWidget      *window,
                             unsigned long  uin)
{
    ICQUser     *user = NULL;
    gchar       *about;
    gint        pos=0;

    GtkWidget *about_text = lookup_widget(window,"about_text");

    gbug("fill_in_about_info\n");
    user = (uin > 0)?gUserManager.FetchUser(uin,LOCK_R):
        gUserManager.FetchOwner(LOCK_R);

    if (user != NULL) {
        about=user->GetAbout();
        gtk_editable_delete_text (GTK_EDITABLE(about_text),0,-1);
        gtk_editable_insert_text(GTK_EDITABLE(about_text),about,strlen(about),
                &pos);
        gUserManager.DropUser(user);
    }

    return 0;
}

int 
fill_in_last_info       (GtkWidget      *window,
                             unsigned long  uin)
{
    ICQUser     *user = NULL;
    time_t tmptime;
    GtkWidget   *last_online_entry = lookup_widget(window, 
        "last_online_entry");
    GtkWidget   *last_checked_autoresponse_entry = lookup_widget(window, 
        "last_checked_autoresponse_entry");
    GtkWidget   *last_recevied_event_entry = lookup_widget(window, 
        "last_recevied_event_entry");
    GtkWidget   *last_sent_event_entry = lookup_widget(window, 
        "last_sent_event_entry");

    user = (uin > 0)?gUserManager.FetchUser(uin,LOCK_R):
                gUserManager.FetchOwner(LOCK_R);

    if (user != NULL) {
        tmptime = user->LastOnline();
        gtk_entry_set_text(GTK_ENTRY(last_online_entry),
                tmptime?ctime(&tmptime):_("n/a"));
        tmptime = user->LastCheckedAutoResponse();
        gtk_entry_set_text(GTK_ENTRY(last_checked_autoresponse_entry),
                tmptime?ctime(&tmptime):_("n/a"));
        tmptime = user->LastReceivedEvent();
        gtk_entry_set_text(GTK_ENTRY(last_recevied_event_entry),
                tmptime?ctime(&tmptime):_("n/a"));
        tmptime = user->LastSentEvent();
        gtk_entry_set_text(GTK_ENTRY(last_sent_event_entry),
                tmptime?ctime(&tmptime):_("n/a"));
        gUserManager.DropUser(user);
    }
    return(0);
}


int 
fill_in_licq_info       (GtkWidget      *window,
                             unsigned long  uin)
{
    ICQUser     *user = NULL;
    GtkWidget   *send_real_ip_checkbutton = lookup_widget(window,
            "licq_send_real_ip_checkbutton");
    GtkWidget   *send_through_server_checkbutton = lookup_widget(window,
            "licq_send_through_server_checkbutton");
    GtkWidget   *auto_accept_chat_checkbutton = lookup_widget(window,
            "licq_auto_accept_chat_checkbutton");
    GtkWidget   *auto_accept_files_checkbutton = lookup_widget(window,
            "licq_auto_accept_files_checkbutton");
    GtkWidget   *auto_secure_checkbutton = lookup_widget(window,
            "licq_auto_secure_checkbutton");
    GtkWidget   *show_autoresponse_checkbutton = lookup_widget(window,
            "licq_show_autoresponse_checkbutton");
    GtkWidget   *accept_in_away_checkbutton = lookup_widget(window,
            "licq_accept_in_away_checkbutton");
    GtkWidget   *accept_in_na_checkbutton = lookup_widget(window,
            "licq_accept_in_na_checkbutton");
    GtkWidget   *accept_in_occupied_checkbutton = lookup_widget(window,
            "licq_accept_in_occupied_checkbutton");
    GtkWidget   *accept_in_dnd_checkbutton = lookup_widget(window,
            "licq_accept_in_dnd_checkbutton");
        
    GtkWidget   *uin_entry = lookup_widget(window,
            "licq_uin_entry");
    GtkWidget   *ip_entry = lookup_widget(window,
            "licq_ip_entry");
    GtkWidget   *version_entry = lookup_widget(window,
            "licq_version_entry");
    GtkWidget   *secure_channel_entry = lookup_widget(window,
            "licq_secure_channel_entry");
    GtkWidget   *licq_version_entry = lookup_widget(GTK_WIDGET(window),
            "licq_licq_version_entry");
    GtkWidget   *connection_version_entry = lookup_widget(GTK_WIDGET(window),
            "licq_connection_version_entry");
    GtkWidget   *status_entry = lookup_widget(GTK_WIDGET(window),
            "licq_status_entry");
    GtkWidget   *status_to_user_optionmenu = lookup_widget(GTK_WIDGET(window),
            "licq_status_to_user_optionmenu");
    GtkWidget *menu;
    GtkWidget *online2;
    GtkWidget *actualstatus;
    char *tmp_string;
    char buf[32];
    unsigned short index = 0;

    gtk_entry_set_editable(GTK_ENTRY(uin_entry),FALSE);
    gtk_entry_set_editable(GTK_ENTRY(ip_entry),FALSE);
    gtk_entry_set_editable(GTK_ENTRY(version_entry),FALSE);
    gtk_entry_set_editable(GTK_ENTRY(secure_channel_entry),FALSE);
    gtk_entry_set_editable(GTK_ENTRY(licq_version_entry),FALSE);
    gtk_entry_set_editable(GTK_ENTRY(connection_version_entry),FALSE);
    gtk_entry_set_editable(GTK_ENTRY(status_entry),FALSE);
    
    user = (uin > 0)?gUserManager.FetchUser(uin,LOCK_R):
        gUserManager.FetchOwner(LOCK_R);

    if (user != NULL) {
        gtk_toggle_button_set_active(
                GTK_TOGGLE_BUTTON(send_real_ip_checkbutton),user->SendRealIp());
        gtk_toggle_button_set_active(
                GTK_TOGGLE_BUTTON(send_through_server_checkbutton),
                user->SendServer());
        gtk_toggle_button_set_active(
                GTK_TOGGLE_BUTTON(auto_accept_chat_checkbutton),
                user->AutoChatAccept());
        gtk_toggle_button_set_active(
                GTK_TOGGLE_BUTTON(auto_accept_files_checkbutton),
                user->AutoFileAccept());
        gtk_toggle_button_set_active(
                GTK_TOGGLE_BUTTON(auto_secure_checkbutton),
                user->AutoSecure());
        gtk_toggle_button_set_active(
                GTK_TOGGLE_BUTTON(show_autoresponse_checkbutton),
                user->ShowAwayMsg());
        gtk_toggle_button_set_active(
                GTK_TOGGLE_BUTTON(accept_in_away_checkbutton),
                user->AcceptInAway());
        gtk_toggle_button_set_active(
                GTK_TOGGLE_BUTTON(accept_in_na_checkbutton),
                user->AcceptInNA());
        gtk_toggle_button_set_active(
                GTK_TOGGLE_BUTTON(accept_in_occupied_checkbutton),
                user->AcceptInOccupied());
        gtk_toggle_button_set_active(
                GTK_TOGGLE_BUTTON(accept_in_dnd_checkbutton),
                user->AcceptInDND());
        
        tmp_string = g_strdup_printf("%ld",user->Uin());
        gtk_entry_set_text(GTK_ENTRY(uin_entry),tmp_string);
        g_free(tmp_string);
        
        gtk_entry_set_text(GTK_ENTRY(ip_entry),user->IpPortStr(buf));

        tmp_string = g_strdup_printf("%ld",user->Version());
        gtk_entry_set_text(GTK_ENTRY(version_entry),tmp_string);
        g_free(tmp_string);
        
        if (user->SecureChannelSupport() == SECURE_CHANNEL_SUPPORTED) {
            gtk_entry_set_text(GTK_ENTRY(secure_channel_entry),_("Yes"));
        } else {
            gtk_entry_set_text(GTK_ENTRY(secure_channel_entry),_("No"));
        }
        if(user->LicqVersion()) {
            gtk_entry_set_text(GTK_ENTRY(licq_version_entry),
                    CUserEvent::LicqVersionToString(user->LicqVersion()));
        }else {
            gtk_entry_set_text(GTK_ENTRY(licq_version_entry),_("n/a"));
        }

        tmp_string = g_strdup_printf("%d",user->ConnectionVersion());
        gtk_entry_set_text(GTK_ENTRY(connection_version_entry),tmp_string);
        g_free(tmp_string);
        
        gtk_entry_set_text(GTK_ENTRY(status_entry),status_string(user->Status(),false));

        /* Create status to user menu */
        menu = create_status_menu(GTK_SIGNAL_FUNC(info_set_status_to_user),
                GTK_SIGNAL_FUNC(info_set_status_to_user),
                FALSE,FALSE,FALSE);
        
        online2 = gtk_menu_item_new_with_label_color_and_pixmap (_("Online"),
                &statuscolor_online,&status_pixmap_online);
        gtk_widget_ref (online2);
        gtk_object_set_data_full (GTK_OBJECT (menu), "online2", online2,
                (GtkDestroyNotify) gtk_widget_unref);
        gtk_widget_show (online2);
        gtk_menu_prepend  (GTK_MENU (menu), online2);

        actualstatus = gtk_menu_item_new_with_label(_("Actual Status"));
        gtk_widget_ref (actualstatus);
        gtk_object_set_data_full (GTK_OBJECT (menu), "actualstatus", 
                actualstatus,
                (GtkDestroyNotify) gtk_widget_unref);
        gtk_widget_show (actualstatus);
        gtk_menu_prepend (GTK_MENU (menu),actualstatus);
        
        gtk_signal_connect (GTK_OBJECT (online2), "activate",
                GTK_SIGNAL_FUNC (info_set_status_to_user),
                GINT_TO_POINTER(ICQ_STATUS_ONLINE));
        gtk_signal_connect (GTK_OBJECT (actualstatus), "activate",
                GTK_SIGNAL_FUNC (info_set_status_to_user),
                GINT_TO_POINTER(ICQ_STATUS_OFFLINE));
        
        gtk_option_menu_set_menu(GTK_OPTION_MENU(status_to_user_optionmenu)
                ,menu); 
        
        switch(user->StatusToUser()) {
            case ICQ_STATUS_OFFLINE:
                index = 0;
                break;
            case ICQ_STATUS_ONLINE:
                index = 1;
                break;
            case ICQ_STATUS_AWAY:
                index = 2;
                break;
            case ICQ_STATUS_DND:
                index = 4;
                break;
            case ICQ_STATUS_NA:
                index = 3;
                break;
            case ICQ_STATUS_OCCUPIED:
                index = 5;
                break;
            case ICQ_STATUS_FREEFORCHAT:
                index = 6;
                break;
        }
        gtk_option_menu_set_history (
                GTK_OPTION_MENU(status_to_user_optionmenu),index);
        
        /* Create status to user menu end */

        gUserManager.DropUser(user);
    }
    return(0);
}

int 
fill_in_info        (GtkWidget      *window,
                         unsigned long  uin)
{
    fill_in_general_info(window,uin);
    fill_in_more_info(window,uin);
    fill_in_work_info(window,uin);
    fill_in_about_info(window,uin);
    fill_in_last_info(window,uin);
    fill_in_licq_info(window,uin);
    /*update_message_box(event_window,uin);*/

    return 0;
}

int 
save_general_info       (GtkWidget      *window,
                         unsigned long  uin)
{
    ICQUser     *user = NULL;
    GtkWidget   *alias_entry = lookup_widget(window,
            "general_alias_entry");
    GtkWidget   *firstname_entry = lookup_widget(window,
            "general_firstname_entry");
    GtkWidget   *lastname_entry = lookup_widget(window,
            "general_lastname_entry");
    GtkWidget   *primaryemail_entry = lookup_widget(window,
            "general_primaryemail_entry");
    GtkWidget   *secondaryemail_entry = lookup_widget(window,
            "general_secondary_entry");
    GtkWidget   *oldemail_entry = lookup_widget(window,
            "general_oldemail_entry");
    GtkWidget   *phone_entry = lookup_widget(window,
            "general_phone_entry");
    GtkWidget   *cellular_entry = lookup_widget(window,
            "general_cellular_entry");
    GtkWidget   *fax_entry = lookup_widget(window,
            "general_fax_entry");
    GtkWidget   *address_text = lookup_widget(window,
            "general_adress_text");
    GtkWidget   *state_entry = lookup_widget(window,
            "general_state_entry");
    GtkWidget   *city_entry = lookup_widget(window,
            "general_city_entry");
    GtkWidget   *country_entry= lookup_widget(window,
            "general_country_entry");
    GtkWidget   *zip_entry = lookup_widget(window,
            "general_zipcode_entry");
    GtkWidget   *timezone_entry = lookup_widget(window,
            "general_timezone_entry");
    
    gchar       *tmp;
    const struct SCountry *country;
    int timezone;

    user = (uin > 0)?gUserManager.FetchUser(uin,LOCK_W):gUserManager.FetchOwner(LOCK_W);

    if (user != NULL) {

        user->SetEnableSave(false);
        user->SetAlias((tmp = gtk_editable_get_chars(GTK_EDITABLE(alias_entry),0,-1)));
        g_free(tmp);
        user->SetFirstName((tmp=gtk_editable_get_chars(GTK_EDITABLE(firstname_entry),0,-1)));
        g_free(tmp);
        user->SetLastName((tmp=gtk_editable_get_chars(GTK_EDITABLE(lastname_entry),0,-1)));
        g_free(tmp);
        user->SetEmailPrimary((tmp=gtk_editable_get_chars(GTK_EDITABLE(primaryemail_entry),0,-1)));
        g_free(tmp);
        user->SetEmailSecondary((tmp=gtk_editable_get_chars(GTK_EDITABLE(secondaryemail_entry),0,-1)));
        g_free(tmp);
        user->SetEmailOld((tmp=gtk_editable_get_chars(GTK_EDITABLE(oldemail_entry),0,-1)));
        g_free(tmp);
        user->SetPhoneNumber((tmp=gtk_editable_get_chars(GTK_EDITABLE(phone_entry),0,-1)));
        g_free(tmp);
        user->SetCellularNumber((tmp=gtk_editable_get_chars(GTK_EDITABLE(cellular_entry),0,-1)));
        g_free(tmp);
        user->SetFaxNumber((tmp=gtk_editable_get_chars(GTK_EDITABLE(fax_entry),0,-1)));
        g_free(tmp);
        user->SetAddress((tmp=gtk_editable_get_chars(GTK_EDITABLE(address_text),0,-1)));
        g_free(tmp);
        user->SetState((tmp=gtk_editable_get_chars(GTK_EDITABLE(state_entry),0,-1)));
        g_free(tmp);
        user->SetCity((tmp=gtk_editable_get_chars(GTK_EDITABLE(city_entry),0,-1)));
        g_free(tmp);
        
        tmp=gtk_editable_get_chars(GTK_EDITABLE(country_entry),0,-1);
        if ((tmp)&&(country=GetCountryByName(tmp))) {
            user->SetCountryCode(country->nCode);
        }
        if(tmp) {
            g_free(tmp);
        }
        
        user->SetZipCode((tmp=gtk_editable_get_chars(
                        GTK_EDITABLE(zip_entry),0,-1)));
        if(tmp) {
            g_free(tmp);
        }
        
        tmp=gtk_editable_get_chars(GTK_EDITABLE(timezone_entry),0,-1);
        if ((tmp != NULL) && (sscanf(tmp,"%d",&timezone) == 1)) {
            user->SetTimezone(timezone);
        }
        if(tmp) {
            g_free(tmp);
        }
        user->SetEnableSave(true);
        user->SaveGeneralInfo();
    }

    gUserManager.DropUser(user);
    return 0;
}

int 
save_more_info          (GtkWidget      *window,
                         unsigned long  uin)
{
    ICQUser *user = NULL;
    GtkWidget *age_spinbutton = lookup_widget(window,"more_age_spinbutton");
    GtkWidget *gender_entry = lookup_widget(window,
            "more_gender_entry");
    GtkWidget *homepage_entry = lookup_widget(window,"more_homepage_entry");
    GtkWidget *l1_entry = lookup_widget(window,"more_language_1_entry");
    GtkWidget *l2_entry = lookup_widget(window,"more_language_2_entry");
    GtkWidget *l3_entry = lookup_widget(window,"more_language_3_entry");
    GtkWidget *birthday_year_spinbutton = lookup_widget(window,
            "more_birthday_year_spinbutton");
    GtkWidget *birthday_month_spinbutton = lookup_widget(window,
            "more_birthday_month_spinbutton");
    GtkWidget *birthday_day_spinbutton = lookup_widget(window,
            "more_birthday_day_spinbutton");
    const struct SLanguage *language1;
    const struct SLanguage *language2;
    const struct SLanguage *language3;

    gchar       *tmp = NULL;
    char        tmp_char;
    
    user = (uin > 0)?gUserManager.FetchUser(uin,LOCK_W):gUserManager.FetchOwner(LOCK_W);
    
    if (user != NULL) {
        user->SetEnableSave(false);
        user->SetAge(gtk_spin_button_get_value_as_int(
                    GTK_SPIN_BUTTON(age_spinbutton)));
        
        tmp=gtk_editable_get_chars(GTK_EDITABLE(gender_entry),0,-1);
        if (!strcmp(tmp,_("Female"))) {
            tmp_char = GENDER_FEMALE;
        } else if (!strcmp(tmp,_("Male"))) {
            tmp_char = GENDER_MALE;
        } else {
            tmp_char = GENDER_UNSPECIFIED;
        }
        user->SetGender(tmp_char);
        g_free(tmp);
         
        user->SetHomepage((tmp=gtk_editable_get_chars(GTK_EDITABLE(homepage_entry),0,-1)));
        g_free(tmp);
    
        user->SetBirthYear(gtk_spin_button_get_value_as_int(
                    GTK_SPIN_BUTTON(birthday_year_spinbutton)));
        user->SetBirthMonth(gtk_spin_button_get_value_as_int(
                    GTK_SPIN_BUTTON(birthday_month_spinbutton)));
        user->SetBirthDay(gtk_spin_button_get_value_as_int(
                    GTK_SPIN_BUTTON(birthday_day_spinbutton)));

        tmp=gtk_editable_get_chars(GTK_EDITABLE(l1_entry),0,-1);
        if ((tmp != NULL) && ((language1 = GetLanguageByName(tmp)) != NULL)) {
            user->SetLanguage1(language1->nCode);
        }
        if(tmp) {
            g_free(tmp);
        }

        tmp=gtk_editable_get_chars(GTK_EDITABLE(l2_entry),0,-1);
        if ((tmp != NULL) && ((language2 = GetLanguageByName(tmp)) != NULL)) {
            user->SetLanguage2(language2->nCode);
        }
        if(tmp) {
            g_free(tmp);
        }
        
        tmp=gtk_editable_get_chars(GTK_EDITABLE(l3_entry),0,-1);
        if ((tmp != NULL) && ((language3 = GetLanguageByName(tmp)) != NULL)) {
            user->SetLanguage3(language3->nCode);
        }
        if(tmp) {
            g_free(tmp);
        }
        
        user->SetEnableSave(true);
        user->SaveMoreInfo();
        gUserManager.DropUser(user);
    }
    return 0;
} 

int 
save_work_info              (GtkWidget      *window,
                             unsigned long  uin)
{
    ICQUser *user = NULL;
    GtkWidget *w_name_entry = lookup_widget(window,
            "work_name_entry");
    GtkWidget *w_department_entry = lookup_widget(window,
            "work_department_entry");
    GtkWidget *w_position_entry = lookup_widget(window,
            "work_position_entry");
    GtkWidget *w_city_entry = lookup_widget(window,
            "work_city_entry");
    GtkWidget *w_state_entry = lookup_widget(window,
            "work_state_entry");
    GtkWidget *w_address_text = lookup_widget(window,
            "work_adress_text");
    GtkWidget *w_homepage_entry = lookup_widget(window,
            "work_homepage_entry");
    GtkWidget *w_phone_entry = lookup_widget(window,
            "work_phone_entry");
    GtkWidget *w_fax_entry = lookup_widget(window,
            "work_fax_entry");
        
    char *tmp;

    user=(uin>0)?gUserManager.FetchUser(uin,LOCK_W):
        gUserManager.FetchOwner(LOCK_W);

    if (user != NULL) {

        user->SetEnableSave(false);

        user->SetCompanyName((tmp=gtk_editable_get_chars(GTK_EDITABLE(w_name_entry),0,-1)));
        g_free(tmp);
        
        user->SetCompanyDepartment((tmp=gtk_editable_get_chars(GTK_EDITABLE(w_department_entry),0,-1)));
        g_free(tmp);
        
        user->SetCompanyPosition((tmp=gtk_editable_get_chars(GTK_EDITABLE(w_position_entry),0,-1)));
        g_free(tmp);
        
        user->SetCompanyCity((tmp=gtk_editable_get_chars(GTK_EDITABLE(w_city_entry),0,-1)));
        g_free(tmp);
        
        user->SetCompanyState((tmp=gtk_editable_get_chars(GTK_EDITABLE(w_state_entry),0,-1)));
        g_free(tmp);
        
        user->SetCompanyAddress((tmp=gtk_editable_get_chars(GTK_EDITABLE(w_address_text),0,-1)));
        g_free(tmp);
        
        user->SetCompanyHomepage((tmp=gtk_editable_get_chars(GTK_EDITABLE(w_homepage_entry),0,-1)));
        g_free(tmp);
        user->SetCompanyPhoneNumber((tmp=gtk_editable_get_chars(GTK_EDITABLE(w_phone_entry),0,-1)));
        g_free(tmp);
        user->SetCompanyFaxNumber((tmp=gtk_editable_get_chars(GTK_EDITABLE(w_fax_entry),0,-1)));
        g_free(tmp);

 
        user->SetEnableSave(true);
        user->SaveWorkInfo(); 
        gUserManager.DropUser(user);
    }
    return 0;
}

int save_about_info         (GtkWidget      *window,
                             unsigned long  uin)
{
    ICQUser     *user = NULL;
    GtkWidget *about_text = lookup_widget(window,"about_text");
    char *tmp;

    user = (uin > 0)?gUserManager.FetchUser(uin,LOCK_W):
        gUserManager.FetchOwner(LOCK_W);

    if (user != NULL) {
        user->SetEnableSave(false);
        user->SetAbout((tmp=gtk_editable_get_chars(GTK_EDITABLE(about_text),0,-1)));
        user->SetEnableSave(true);
        user->SaveAboutInfo();
        gUserManager.DropUser(user);
        g_free(tmp);
    }
    return(0);
}

int save_licq_info          (GtkWidget      *window,
                             unsigned long  uin)
{

    ICQUser     *user = NULL;
    GtkWidget   *send_real_ip_checkbutton = lookup_widget(window,
            "licq_send_real_ip_checkbutton");
    GtkWidget   *send_through_server_checkbutton = lookup_widget(window,
            "licq_send_through_server_checkbutton");
    GtkWidget   *auto_accept_chat_checkbutton = lookup_widget(window,
            "licq_auto_accept_chat_checkbutton");
    GtkWidget   *auto_accept_files_checkbutton = lookup_widget(window,
            "licq_auto_accept_files_checkbutton");
    GtkWidget   *auto_secure_checkbutton = lookup_widget(window,
            "licq_auto_secure_checkbutton");
    GtkWidget   *show_autoresponse_checkbutton = lookup_widget(window,
            "licq_show_autoresponse_checkbutton");
    GtkWidget   *accept_in_away_checkbutton = lookup_widget(window,
            "licq_accept_in_away_checkbutton");
    GtkWidget   *accept_in_na_checkbutton = lookup_widget(window,
            "licq_accept_in_na_checkbutton");
    GtkWidget   *accept_in_occupied_checkbutton = lookup_widget(window,
            "licq_accept_in_occupied_checkbutton");
    GtkWidget   *accept_in_dnd_checkbutton = lookup_widget(window,
            "licq_accept_in_dnd_checkbutton");
        
    user = (uin > 0)?gUserManager.FetchUser(uin,LOCK_W):
        gUserManager.FetchOwner(LOCK_W);

    if (user != NULL) {
        
         user->SetSendRealIp(gtk_toggle_button_get_active(
                 GTK_TOGGLE_BUTTON(send_real_ip_checkbutton)));
        
         user->SetSendServer(gtk_toggle_button_get_active(
                 GTK_TOGGLE_BUTTON(send_through_server_checkbutton)));
        
         user->SetAutoChatAccept(gtk_toggle_button_get_active(
                 GTK_TOGGLE_BUTTON(auto_accept_chat_checkbutton)));
        
         user->SetAutoFileAccept(gtk_toggle_button_get_active(
                 GTK_TOGGLE_BUTTON(auto_accept_files_checkbutton)));
        
         user->SetAutoSecure(gtk_toggle_button_get_active(
                 GTK_TOGGLE_BUTTON(auto_secure_checkbutton)));
        
         user->SetShowAwayMsg(gtk_toggle_button_get_active(
                 GTK_TOGGLE_BUTTON(show_autoresponse_checkbutton)));
        
         user->SetAcceptInAway(gtk_toggle_button_get_active(
                 GTK_TOGGLE_BUTTON(accept_in_away_checkbutton)));
        
         user->SetAcceptInOccupied(gtk_toggle_button_get_active(
                 GTK_TOGGLE_BUTTON(accept_in_occupied_checkbutton)));
        
         user->SetAcceptInNA(gtk_toggle_button_get_active(
                     GTK_TOGGLE_BUTTON(accept_in_na_checkbutton)));
             
         user->SetAcceptInDND(gtk_toggle_button_get_active(
                 GTK_TOGGLE_BUTTON(accept_in_dnd_checkbutton)));
        
        gUserManager.DropUser(user);
    }
    return(0);
}

int
save_general_info_on_server (GtkWidget      *window,
                             unsigned long  uin)
{
    ICQUser     *user = NULL;
    GtkWidget   *alias_entry = lookup_widget(window,
            "general_alias_entry");
    GtkWidget   *firstname_entry = lookup_widget(window,
            "general_firstname_entry");
    GtkWidget   *lastname_entry = lookup_widget(window,
            "general_lastname_entry");
    GtkWidget   *primaryemail_entry = lookup_widget(window,
            "general_primaryemail_entry");
    GtkWidget   *secondaryemail_entry = lookup_widget(window,
            "general_secondary_entry");
    GtkWidget   *oldemail_entry = lookup_widget(window,
            "general_oldemail_entry");
    GtkWidget   *phone_entry = lookup_widget(window,
            "general_phone_entry");
    GtkWidget   *cellular_entry = lookup_widget(window,
            "general_cellular_entry");
    GtkWidget   *fax_entry = lookup_widget(window,
            "general_fax_entry");
    GtkWidget   *address_text = lookup_widget(window,
            "general_adress_text");
    GtkWidget   *state_entry = lookup_widget(window,
            "general_state_entry");
    GtkWidget   *city_entry = lookup_widget(window,
            "general_city_entry");
    GtkWidget   *country_entry= lookup_widget(window,
            "general_country_entry");
    GtkWidget   *zip_entry = lookup_widget(window,
            "general_zipcode_entry");
    GtkWidget *general_hide_email_checkbutton = lookup_widget(window,
            "general_hide_email_checkbutton");
    
    gchar       *tmp;
    gchar       *alias;
    gchar       *firstname;
    gchar       *lastname;
    gchar       *primemail;
    gchar       *secemail;
    gchar       *oldemail;
    gchar       *state;
    gchar       *phone;
    gchar       *fax;
    gchar       *address;
    gchar       *cellular;
    gchar       *zip;
    gchar       *city;
    unsigned short countrycode = 0;

    const struct SCountry *country;

    user = (uin > 0)?gUserManager.FetchUser(uin,LOCK_W):
        gUserManager.FetchOwner(LOCK_W);

    if (user != NULL) {

        user->SetEnableSave(false);
        alias = gtk_editable_get_chars(GTK_EDITABLE(alias_entry),0,-1);
        firstname=gtk_editable_get_chars(GTK_EDITABLE(firstname_entry),0,-1);
        lastname=gtk_editable_get_chars(GTK_EDITABLE(lastname_entry),0,-1);
        primemail=gtk_editable_get_chars(GTK_EDITABLE(primaryemail_entry),0,-1);
        secemail=gtk_editable_get_chars(GTK_EDITABLE(secondaryemail_entry),0,-1);
        oldemail=gtk_editable_get_chars(GTK_EDITABLE(oldemail_entry),0,-1);
        phone=gtk_editable_get_chars(GTK_EDITABLE(phone_entry),0,-1);
        cellular=gtk_editable_get_chars(GTK_EDITABLE(cellular_entry),0,-1);
        fax=gtk_editable_get_chars(GTK_EDITABLE(fax_entry),0,-1);
        address=gtk_editable_get_chars(GTK_EDITABLE(address_text),0,-1);
        state=gtk_editable_get_chars(GTK_EDITABLE(state_entry),0,-1);
        city=gtk_editable_get_chars(GTK_EDITABLE(city_entry),0,-1);
        zip=gtk_editable_get_chars(GTK_EDITABLE(zip_entry),0,-1);
        
        tmp=gtk_editable_get_chars(GTK_EDITABLE(country_entry),0,-1);
        country = GetCountryByName(tmp);
        if (country != NULL) {
            countrycode= country->nCode;
        }
        g_free(tmp);
        
        user->SetEnableSave(true);
        licq_daemon->icqSetGeneralInfo((const char *) alias,
               (const char *) firstname,
               (const char *)  lastname,
               (const char *) primemail,
               (const char *) secemail,
               (const char *) oldemail,
               (const char *) city,
               (const char *) state,
               (const char *) phone,
               (const char *) fax,
               (const char *) address,
               (const char *) cellular,
               (const char *) zip,
               countrycode,
               gtk_toggle_button_get_active(
                   GTK_TOGGLE_BUTTON(general_hide_email_checkbutton)));
        g_free(alias);
        g_free(firstname);
        g_free(lastname);
        g_free(primemail);
        g_free(secemail);
        g_free(oldemail);
        g_free(state);
        g_free(phone);
        g_free(fax);
        g_free(address);
        g_free(cellular);
        g_free(zip);
        g_free(city);

    }

    gUserManager.DropUser(user);
    return 0;
}

int 
save_more_info_on_server    (GtkWidget      *window,
                             unsigned long  uin)
{
    ICQUser *user = NULL;
    GtkWidget *age_spinbutton = lookup_widget(window,"more_age_spinbutton");
    GtkWidget *gender_entry = lookup_widget(window,
            "more_gender_entry");
    GtkWidget *homepage_entry = lookup_widget(window,"more_homepage_entry");
    GtkWidget *l1_entry = lookup_widget(window,"more_language_1_entry");
    GtkWidget *l2_entry = lookup_widget(window,"more_language_2_entry");
    GtkWidget *l3_entry = lookup_widget(window,"more_language_3_entry");
    GtkWidget *birthday_year_spinbutton = lookup_widget(window,
            "more_birthday_year_spinbutton");
    GtkWidget *birthday_month_spinbutton = lookup_widget(window,
            "more_birthday_month_spinbutton");
    GtkWidget *birthday_day_spinbutton = lookup_widget(window,
            "more_birthday_day_spinbutton");
    const struct SLanguage *language1;
    const struct SLanguage *language2;
    const struct SLanguage *language3;

    gchar       *tmp = NULL;
    gchar       *homepage = NULL;
    unsigned short age = 0;
    unsigned short year = 0;
    unsigned short month = 0;
    unsigned short day = 0;
    char        gender = 0;
    
    char        lang1 = 0;
    char        lang2 = 0;
    char        lang3 = 0;
    
    user = (uin > 0)?gUserManager.FetchUser(uin,LOCK_W):gUserManager.FetchOwner(LOCK_W);
    
    if (user != NULL) {
        user->SetEnableSave(false);
        age = gtk_spin_button_get_value_as_int(
                    GTK_SPIN_BUTTON(age_spinbutton));
        
        tmp=gtk_editable_get_chars(GTK_EDITABLE(gender_entry),0,-1);
        if (!strcmp(tmp,_("Female"))) {
            gender = GENDER_FEMALE;
        } else if (!strcmp(tmp,_("Male"))) {
            gender = GENDER_MALE;
        } else {
            gender = GENDER_UNSPECIFIED;
        }
        g_free(tmp);
         
        homepage=gtk_editable_get_chars(GTK_EDITABLE(homepage_entry),0,-1);
    
        year = gtk_spin_button_get_value_as_int(
                    GTK_SPIN_BUTTON(birthday_year_spinbutton));
        month = gtk_spin_button_get_value_as_int(
                    GTK_SPIN_BUTTON(birthday_month_spinbutton));
        day = gtk_spin_button_get_value_as_int(
                    GTK_SPIN_BUTTON(birthday_day_spinbutton));

        tmp=gtk_editable_get_chars(GTK_EDITABLE(l1_entry),0,-1);
        if ((tmp != NULL) && ((language1 = GetLanguageByName(tmp)) != NULL)) {
            lang1 = language1->nCode;
        }
        g_free(tmp);
        
        tmp=gtk_editable_get_chars(GTK_EDITABLE(l2_entry),0,-1);
        if ((tmp != NULL) && ((language2 = GetLanguageByName(tmp)) != NULL)) {
            lang2 = language2->nCode;
        }
        g_free(tmp);
        
        tmp=gtk_editable_get_chars(GTK_EDITABLE(l3_entry),0,-1);
        if ((tmp != NULL) && ((language3 = GetLanguageByName(tmp)) != NULL)) {
            lang3 = language3->nCode;
        }
        g_free(tmp);
        
        user->SetEnableSave(true);
        licq_daemon->icqSetMoreInfo(age,gender,homepage,year,month,day,lang1,lang2,lang3);
        g_free(homepage);
        gUserManager.DropUser(user);
    }
    return 0;
} 

int 
save_work_info_on_server    (GtkWidget      *window,
                             unsigned long  uin)
{
    ICQUser *user = NULL;
    GtkWidget *w_name_entry = lookup_widget(window,
            "work_name_entry");
    GtkWidget *w_department_entry = lookup_widget(window,
            "work_department_entry");
    GtkWidget *w_position_entry = lookup_widget(window,
            "work_position_entry");
    GtkWidget *w_city_entry = lookup_widget(window,
            "work_city_entry");
    GtkWidget *w_state_entry = lookup_widget(window,
            "work_state_entry");
    GtkWidget *w_address_text = lookup_widget(window,
            "work_adress_text");
    GtkWidget *w_homepage_entry = lookup_widget(window,
            "work_homepage_entry");
    GtkWidget *w_phone_entry = lookup_widget(window,
            "work_phone_entry");
    GtkWidget *w_fax_entry = lookup_widget(window,
            "work_fax_entry");
    char *tmp;
    gchar       *name;
    gchar       *city;
    gchar       *state;
    gchar       *phone;
    gchar       *fax;
    gchar       *address;
    gchar       *position;
    gchar       *department;
    gchar       *homepage;

    user=(uin>0)?gUserManager.FetchUser(uin,LOCK_R):
        gUserManager.FetchOwner(LOCK_R);

    if (user != NULL) {

        user->SetEnableSave(false);

        name=gtk_editable_get_chars(GTK_EDITABLE(w_name_entry),0,-1);

        department=gtk_editable_get_chars(GTK_EDITABLE(w_department_entry),0,-1);

        position=gtk_editable_get_chars(GTK_EDITABLE(w_position_entry),0,-1);

        city=gtk_editable_get_chars(GTK_EDITABLE(w_city_entry),0,-1);

        state=gtk_editable_get_chars(GTK_EDITABLE(w_state_entry),0,-1);

        address=gtk_editable_get_chars(GTK_EDITABLE(w_address_text),0,-1);

        homepage=gtk_editable_get_chars(GTK_EDITABLE(w_homepage_entry),0,-1);
        
        phone=gtk_editable_get_chars(GTK_EDITABLE(w_phone_entry),0,-1);
        
        fax=gtk_editable_get_chars(GTK_EDITABLE(w_fax_entry),0,-1);
 
        user->SetEnableSave(true);
        licq_daemon->icqSetWorkInfo(city,state,phone,fax,address,name,department,position,homepage); 
        gUserManager.DropUser(user);
        g_free(name);
        g_free(city);
        g_free(state);
        g_free(phone);
        g_free(fax);
        g_free(address);
        g_free(position);
        g_free(department);
        g_free(homepage);
    }
    return 0;
}

int 
save_about_info_on_server   (GtkWidget      *window,
                             unsigned long  uin)
{
    ICQUser     *user = NULL;
    GtkWidget *about_text = lookup_widget(window,"about_text");
    char *tmp;

    user = (uin > 0)?gUserManager.FetchUser(uin,LOCK_R):
        gUserManager.FetchOwner(LOCK_R);

    if (user != NULL) {
        user->SetEnableSave(false);
        licq_daemon->icqSetAbout((tmp=gtk_editable_get_chars(GTK_EDITABLE(about_text),0,-1)));
        user->SetEnableSave(true);
        gUserManager.DropUser(user);
        g_free(tmp);
    }
    return(0);
}

/****************************************************************************
                        Signal handlers
 ****************************************************************************/

bool 
update_info_signal_handler  (CICQSignal     *signal, 
                             gpointer       data)
{
    if (!data) return FALSE;

    if (signal->Signal() == SIGNAL_UPDATExUSER &&
            signal->Uin() == gtk_widget_get_active_uin(GTK_WIDGET(data)) ) {
        switch(signal->SubSignal()) {
            case USER_GENERAL:
                fill_in_general_info(GTK_WIDGET(data),signal->Uin());
                break;
            case USER_MORE:
                fill_in_more_info(GTK_WIDGET(data),signal->Uin());
                break;
            case USER_WORK:
                fill_in_work_info(GTK_WIDGET(data),signal->Uin());
                break;
            case USER_ABOUT:
                fill_in_about_info(GTK_WIDGET(data),signal->Uin());
                break;
        }
    }
    return FALSE;
}

bool 
update_info_event_handler   (ICQEvent       *event, 
                             gpointer       data) 
{
    /*  FIXME: Verify event destination */
    return(FALSE);
    if ((event->Command() == ICQ_CMDxSND_META) &&
            (event->SubCommand() == ICQ_CMDxMETA_REQUESTxALLxINFOx31)){
        unregister_signalcallback(update_info_signal_handler,GTK_WIDGET(data));
        return TRUE;
    }
    return FALSE;
}




/************************************************************************
                 Callbacks from the GUI!
 ************************************************************************/

void
on_info_save_button_clicked            (GtkButton       *button,
                                        gpointer         user_data)
{
    GtkWidget *info_notebook = lookup_widget(GTK_WIDGET(button),
            "info_notebook");
    GtkWidget *info_dialog;
    int current_page;
    userdata_t      *udata;
    unsigned long   uin;
    gchar           *buttons[4]={_("Yes"),_("No"),_("Cancel"),NULL};
    
    uin=gtk_widget_get_active_uin(GTK_WIDGET(button));
    if ((uin == 0) || (uin == gUserManager.OwnerUin())) {
        udata=find_user_data(uin,NULL);
        uin = gUserManager.OwnerUin();
        if(udata) {
            switch(showtextdialogcustom(_("Update server info?"),
                        _("Do you wish to save the information on the server?"),
                        buttons)) {
                case 0:
                    info_dialog = udata->info_dialog;
                    save_general_info_on_server(info_dialog,uin);
                    save_more_info_on_server(info_dialog,uin);
                    save_work_info_on_server(info_dialog,uin);
                    save_about_info_on_server(info_dialog,uin);
                case 1:
                    info_dialog = udata->info_dialog;

                    save_general_info(info_dialog,uin);
                    save_more_info(info_dialog,uin);
                    save_work_info(info_dialog,uin);
                    save_about_info(info_dialog,uin);
                    save_licq_info(info_dialog,uin);
                    refresh_contactlist_single_user(uin);
                    break;
                default:
                    break;
            }
        }
    } else {
        udata=find_user_data(uin,NULL);
        if(udata) {
            info_dialog = udata->info_dialog;

            save_general_info(info_dialog,uin);
            save_more_info(info_dialog,uin);
            save_work_info(info_dialog,uin);
            save_about_info(info_dialog,uin);
            save_licq_info(info_dialog,uin);
            refresh_contactlist_single_user(uin);
        }
    }
}

void
on_more_homepage_view_button_clicked   (GtkButton       *button,
                                        gpointer         user_data)
{
    GtkWidget *homepage_entry = lookup_widget(GTK_WIDGET(button),
            "more_homepage_entry");
    gchar *url = NULL;
    
    url = gtk_editable_get_chars(GTK_EDITABLE(homepage_entry),0,-1);
    view_url(url);
    g_free(url);

}


void
on_work_view_homepage_button_clicked   (GtkButton       *button,
                                        gpointer         user_data)
{
    GtkWidget *w_homepage_entry = lookup_widget(GTK_WIDGET(button),
            "work_homepage_entry");
    gchar *url = NULL;
    
    url = gtk_editable_get_chars(GTK_EDITABLE(w_homepage_entry),0,-1);
    view_url(url);
    g_free(url);
}


void
on_licq_set_custom_autoresponse_button_clicked
                                        (GtkButton       *button,
                                        gpointer         user_data)
{
    unsigned long uin;
    uin = gtk_widget_get_active_uin(GTK_WIDGET(button));
    
    set_status_with_message(-1,uin);
}


void
on_info_update_button_clicked          (GtkButton       *button,
                                        gpointer         user_data)
{
    unsigned long   uin;

    uin=gtk_widget_get_active_uin(GTK_WIDGET(button));
    licq_daemon->icqRequestMetaInfo(uin); 
}


void
on_info_close_button_clicked           (GtkButton       *button,
                                        gpointer         user_data)
{
    shutdown_user_info_dialog(gtk_widget_get_toplevel(GTK_WIDGET(button)));
}

void
shutdown_user_info_dialog              (GtkWidget       *toplevel)
{
    userdata_t      *udata;
    unsigned long   uin;

    uin=gtk_widget_get_active_uin(toplevel);
    udata=find_user_data(uin,NULL);
    if (udata) {
        unregister_signalcallback(update_info_signal_handler, udata->info_dialog);
        //  unregister_eventcallback(update_info_event_handler, udata->info_dialog);
        udata->info_dialog=NULL;
    }
    gtk_widget_destroy(toplevel);
}

GtkWidget *
show_info_dialog_for_user              (unsigned long   uin,int page)
{
    userdata_t      *udata;
    GtkWidget       *user_info_dialog;
    GtkWidget       *notebook;
    
    if ((uin == 0) || (uin==gUserManager.OwnerUin())) {
        udata = (userdata_t *) gtk_object_get_data(GTK_OBJECT(main_window),
                "owner_userdata");
    } else {
        udata=find_user_data(uin,NULL);
    }
    if (udata==NULL) {
        return(NULL);
    }
    if(!udata->info_dialog){
        user_info_dialog=create_user_info_dialog();
        udata->info_dialog=user_info_dialog;
        gtk_widget_set_active_uin(user_info_dialog,uin);
        fill_in_info(user_info_dialog,uin);
        notebook = lookup_widget(user_info_dialog,"info_notebook");
        gtk_notebook_set_page(GTK_NOTEBOOK(notebook),page);
        register_signalcallback(update_info_signal_handler,user_info_dialog);
        gtk_widget_show(user_info_dialog);
    }else {
        user_info_dialog=udata->info_dialog;
        notebook = lookup_widget(user_info_dialog,"info_notebook");
        gtk_notebook_set_page(GTK_NOTEBOOK(notebook),page);
        gdk_window_raise(user_info_dialog->window);
    }
    return user_info_dialog;
}


gboolean
on_user_info_dialog_delete_event       (GtkWidget       *widget,
                                        GdkEvent        *event,
                                        gpointer         user_data)
{
    shutdown_user_info_dialog(widget);
    return FALSE;
}

