#include "gtk-gui.h"

#include <sys/time.h>
#include <stdio.h>

#include "interface.h"
#include "contactlist.h"
#include "utility_dialog.h"
#include "authorize_user_dialog.h"
#include "functions.h"
#include "autoresponse.h"
#include "user_info_dialog.h"
#include "history_dialog.h"


int do_nothing = 0;


/* Popup menu events */
void
on_view_event2_activate                (GtkMenuItem *menuitem,
                                        gpointer    user_data)
{
    popup_user_event_window(gtk_widget_get_active_uin(
                GTK_WIDGET(menuitem)),MODE_VIEW,0);
}

void
on_request_secure_channel1_activate    (GtkMenuItem *menuitem,
                                        gpointer    user_data)
{
    licq_daemon->icqOpenSecureChannel(gtk_widget_get_active_uin(
                GTK_WIDGET(menuitem)));
    register_eventcallback(secure_result_callback,NULL);
}

void
on_auto_secure1_activate               (GtkMenuItem *menuitem,
                                        gpointer    user_data)
{
    if (!do_nothing) {
        ICQUser *u = gUserManager.FetchUser(gtk_widget_get_active_uin(
                    GTK_WIDGET(menuitem)), 
                LOCK_W);
        if (u != NULL) {
            u->SetAutoSecure(GTK_CHECK_MENU_ITEM(menuitem)->active);
            gUserManager.DropUser(u);
        }
    }
}

void
on_send_message1_activate              (GtkMenuItem *menuitem,
                                        gpointer    user_data)
{
    popup_user_event_window(gtk_widget_get_active_uin(GTK_WIDGET(menuitem)),
            MODE_SEND,SEND_MESSAGE);
}


void
on_send_url1_activate                  (GtkMenuItem *menuitem,
                                        gpointer    user_data)
{
    popup_user_event_window(gtk_widget_get_active_uin(GTK_WIDGET(menuitem)),
            MODE_SEND,SEND_URL);
}


void
on_send_chat_request1_activate         (GtkMenuItem *menuitem,
                                        gpointer    user_data)
{
    popup_user_event_window(gtk_widget_get_active_uin(GTK_WIDGET(menuitem)),
            MODE_SEND,SEND_CHAT);
}


void
on_send_file_transfer1_activate        (GtkMenuItem *menuitem,
                                        gpointer    user_data)
{
    popup_user_event_window(gtk_widget_get_active_uin(GTK_WIDGET(menuitem)),
            MODE_SEND,SEND_FILE);
}


void
on_send_contacts1_activate             (GtkMenuItem *menuitem,
                                        gpointer    user_data)
{
    popup_user_event_window(gtk_widget_get_active_uin(GTK_WIDGET(menuitem)),
            MODE_SEND,SEND_CONTACTS);
}


void
on_send_autorization1_activate         (GtkMenuItem *menuitem,
                                        gpointer    user_data)
{
    show_authorize_dialog(TRUE,gtk_widget_get_active_uin(GTK_WIDGET(menuitem)));
}

bool
autoresponse_event_callback            (ICQEvent    *e,
                                        unsigned long 
                                                    *tag)
{
    ICQUser         *user;
    GtkWidget       *event_autoresponse_dialog;
    GtkWidget       *auto_away_text;
    GtkWidget       *show_again_optionmenu;
    gchar           *msg;

    if(!e->Equals(*tag)) {
        return FALSE;
    }

    user=gUserManager.FetchUser(e->Uin(), LOCK_R);
    if(e->Result()!=EVENT_SUCCESS&&e->Result()!=EVENT_ACKED) {
        msg=g_strdup_printf(_("Failed to get autoresonse for %s"),
                user->GetAlias());
        showokdialog(_("Check autoresponse"), msg);
        g_free(msg);
    }else {
        if(user&&user->Away()) {
            event_autoresponse_dialog=create_event_autoresponse_dialog();
            gtk_widget_set_active_uin(event_autoresponse_dialog,
                    e->Uin());

            auto_away_text=lookup_widget(event_autoresponse_dialog,
                    "auto_away_text");
            show_again_optionmenu=lookup_widget(event_autoresponse_dialog,
                    "show_again_optionmenu");
            gtk_text_insert(GTK_TEXT(auto_away_text),NULL,NULL,NULL,
                    user->AutoResponse(),strlen(user->AutoResponse()));
            gtk_widget_hide(show_again_optionmenu);
            gtk_widget_set_active_uin(event_autoresponse_dialog,e->Uin());
            gtk_widget_show(event_autoresponse_dialog);
        }
    }
    if(user) {
        gUserManager.DropUser(user);
    }
    free(tag);

    return TRUE;
}

void
on_check_auto_response1_activate       (GtkMenuItem *menuitem,
                                        gpointer    user_data)
{
    unsigned long   *tag;

    tag=(unsigned long*)malloc(sizeof(unsigned long));
    *tag=licq_daemon->icqFetchAutoResponse(gtk_widget_get_active_uin(GTK_WIDGET(menuitem)));

    register_eventcallback((eventhandler_callback)autoresponse_event_callback,
            (gpointer)tag);
}


void
on_accept_in_away1_activate            (GtkMenuItem *menuitem,
                                        gpointer    user_data)
{
    if (!do_nothing) {
        ICQUser *u = gUserManager.FetchUser(gtk_widget_get_active_uin(
                    GTK_WIDGET(menuitem)), 
                LOCK_W);
        if (u != NULL) {
            u->SetAcceptInAway(GTK_CHECK_MENU_ITEM(menuitem)->active);
            gUserManager.DropUser(u);
        }
    }
}


void
on_accept_in_not_available1_activate   (GtkMenuItem *menuitem,
                                        gpointer    user_data)
{
    if (!do_nothing) {
        ICQUser *u = gUserManager.FetchUser(gtk_widget_get_active_uin(
                    GTK_WIDGET(menuitem)),LOCK_W);
        if (u != NULL) {
            u->SetAcceptInNA(GTK_CHECK_MENU_ITEM(menuitem)->active);
            gUserManager.DropUser(u);
        }
    }
}


void
on_accept_in_occupied1_activate        (GtkMenuItem *menuitem,
                                        gpointer    user_data)
{
    if (!do_nothing) {
        ICQUser *u = gUserManager.FetchUser(gtk_widget_get_active_uin(
                    GTK_WIDGET(menuitem)),LOCK_W);
        if (u != NULL) {
            u->SetAcceptInOccupied(GTK_CHECK_MENU_ITEM(menuitem)->active);
            gUserManager.DropUser(u);
        }
    }
}


void
on_accept_in_do_not_disturb1_activate  (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
    if (!do_nothing) {
        ICQUser *u = gUserManager.FetchUser(gtk_widget_get_active_uin(
                    GTK_WIDGET(menuitem)),LOCK_W);
        if (u != NULL) {
            u->SetAcceptInDND(GTK_CHECK_MENU_ITEM(menuitem)->active);
            gUserManager.DropUser(u);
        }
    }
}


void
on_online_to_user1_activate            (GtkMenuItem     *menuitem,
        gpointer         user_data)
{    
    if (!do_nothing) {
        ICQUser *u = gUserManager.FetchUser(gtk_widget_get_active_uin(GTK_WIDGET(menuitem)), 
                LOCK_W);
        if (u != NULL) {
            if (u->StatusToUser() == ICQ_STATUS_ONLINE) {
                u->SetStatusToUser(ICQ_STATUS_OFFLINE);
            } else {
                u->SetStatusToUser(ICQ_STATUS_ONLINE);
            }
        }
        gUserManager.DropUser(u);
    }
}


void
on_away_to_user1_activate              (GtkMenuItem     *menuitem,
        gpointer         user_data)
{
    if (!do_nothing) {
         ICQUser *u = gUserManager.FetchUser(
                 gtk_widget_get_active_uin(GTK_WIDGET(menuitem)),
                 LOCK_R);
         if (u->StatusToUser() == ICQ_STATUS_AWAY) {
             u->SetStatusToUser(ICQ_STATUS_OFFLINE);
             gUserManager.DropUser(u);
         } else {
             gUserManager.DropUser(u);
             set_status_with_message(ICQ_STATUS_AWAY,
                     gtk_widget_get_active_uin(GTK_WIDGET(menuitem)));
         }
          
    }

}


void
on_not_available_to_user1_activate     (GtkMenuItem     *menuitem,
        gpointer         user_data)
{
    if (!do_nothing) {
         ICQUser *u = gUserManager.FetchUser(
                 gtk_widget_get_active_uin(GTK_WIDGET(menuitem)),
                 LOCK_R);
         if (u->StatusToUser() == ICQ_STATUS_NA) {
             u->SetStatusToUser(ICQ_STATUS_OFFLINE);
             gUserManager.DropUser(u);
         } else {
             gUserManager.DropUser(u);
             set_status_with_message(ICQ_STATUS_NA,
                     gtk_widget_get_active_uin(GTK_WIDGET(menuitem)));
         }
    }
}


void
on_occupied_to_user1_activate          (GtkMenuItem     *menuitem,
        gpointer         user_data)
{
    if (!do_nothing) {
         ICQUser *u = gUserManager.FetchUser(
                 gtk_widget_get_active_uin(GTK_WIDGET(menuitem)),
                 LOCK_R);
         if (u->StatusToUser() == ICQ_STATUS_OCCUPIED) {
             u->SetStatusToUser(ICQ_STATUS_OFFLINE);
             gUserManager.DropUser(u);
         } else {
             gUserManager.DropUser(u);
             set_status_with_message(ICQ_STATUS_OCCUPIED,
                     gtk_widget_get_active_uin(GTK_WIDGET(menuitem)));
         }
    }
}


void
on_do_not_disturb_to_user1_activate    (GtkMenuItem     *menuitem,
        gpointer         user_data)
{
    if (!do_nothing) {
         ICQUser *u = gUserManager.FetchUser(
                 gtk_widget_get_active_uin(GTK_WIDGET(menuitem)),
                 LOCK_R);
         if (u->StatusToUser() == ICQ_STATUS_DND) {
             u->SetStatusToUser(ICQ_STATUS_OFFLINE);
             gUserManager.DropUser(u);
         } else {
             gUserManager.DropUser(u);
             set_status_with_message(ICQ_STATUS_DND,
                     gtk_widget_get_active_uin(GTK_WIDGET(menuitem)));
         }
    }
}


void
on_utilities1_activate                 (GtkMenuItem     *menuitem,
        gpointer         user_data)
{

}

void
on_online_notify1_activate             (GtkMenuItem     *menuitem,
        gpointer         user_data)
{
    ICQUser *u;

    if(do_nothing) {
        return;
    }
    u=gUserManager.FetchUser(gtk_widget_get_active_uin(GTK_WIDGET(menuitem)), LOCK_W);
    if (!u) {
        return ;
    }
    u->SetOnlineNotify((GTK_CHECK_MENU_ITEM(menuitem)->active?TRUE:FALSE));
    gUserManager.DropUser(u);
    refresh_contactlist_single_user(gtk_widget_get_active_uin(GTK_WIDGET(menuitem)));
}


void
on_invisible_list1_activate            (GtkMenuItem     *menuitem,
        gpointer         user_data)
{
    ICQUser *u;

    if(do_nothing) {
        return;
    }
    u=gUserManager.FetchUser(gtk_widget_get_active_uin(GTK_WIDGET(menuitem)), LOCK_W);
    if (!u) {
        return ;
    }
    u->SetInvisibleList((GTK_CHECK_MENU_ITEM(menuitem)->active?TRUE:FALSE));
    gUserManager.DropUser(u);
    refresh_contactlist_single_user(gtk_widget_get_active_uin(GTK_WIDGET(menuitem)));
}


void
on_visible_list1_activate              (GtkMenuItem     *menuitem,
        gpointer         user_data)
{
    ICQUser *u;

    if(do_nothing) {
        return;
    }
    u=gUserManager.FetchUser(gtk_widget_get_active_uin(GTK_WIDGET(menuitem)), LOCK_W);
    if (!u) {
        return ;
    }
    u->SetVisibleList((GTK_CHECK_MENU_ITEM(menuitem)->active?TRUE:FALSE));
    gUserManager.DropUser(u);
    refresh_contactlist_single_user(gtk_widget_get_active_uin(GTK_WIDGET(menuitem)));
}


void
on_ignore_list1_activate               (GtkMenuItem     *menuitem,
        gpointer         user_data)
{
    ICQUser *u;

    if(do_nothing) {
        return;
    }
    u=gUserManager.FetchUser(gtk_widget_get_active_uin(GTK_WIDGET(menuitem)), LOCK_W);
    if (!u) {
        return ;
    }
    u->SetIgnoreList((GTK_CHECK_MENU_ITEM(menuitem)->active?TRUE:FALSE));
    gUserManager.DropUser(u);
    refresh_contactlist_single_user(gtk_widget_get_active_uin(GTK_WIDGET(menuitem)));
}


void
on_show_autoresponse1_activate         (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
    ICQUser *u;

    if(do_nothing) {
        return;
    }
    if(!(u=gUserManager.FetchUser(gtk_widget_get_active_uin(GTK_WIDGET(menuitem)), LOCK_W))) {
        return ;
    }
    u->SetShowAwayMsg((GTK_CHECK_MENU_ITEM(menuitem)->active?TRUE:FALSE));
    gUserManager.DropUser(u);
}

void
on_from_current_group1_activate        (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
    GtkWidget           *contactlist=lookup_widget(main_window,"alias_clist");
    int                 row;
    ICQUser             *u;
    GroupList           *g;
    gchar               *message;

    gbug("Group: %d\n",contactlist_current_group);
    if(contactlist_current_group) {
        u=gUserManager.FetchUser(gtk_widget_get_active_uin(GTK_WIDGET(menuitem)),LOCK_W);
        if(!u) {
            return; 
        }
        if(contactlist_current_group<=gUserManager.NumGroups()) {
            g=gUserManager.LockGroupList(LOCK_R);
            message=g_strdup_printf(_("Are you sure you want to remove %s\n"
                    "from the group %s"),u->GetAlias(),
                    (*g)[contactlist_current_group-1]);
            if(showtextdialog(_("Remove from group"),
                        message,DLGBUTTON_YES|DLGBUTTON_NO)==DLGBUTTON_YES) {
                gUserManager.UnlockGroupList();
                gUserManager.DropUser(u);
                gUserManager.RemoveUserFromGroup(
                        gtk_widget_get_active_uin(GTK_WIDGET(menuitem)), 
                        contactlist_current_group);
                refresh_contactlist_single_user(gtk_widget_get_active_uin(
                            GTK_WIDGET(menuitem)));
            }else {
                gUserManager.UnlockGroupList();
                gUserManager.DropUser(u);
            }
            g_free(message);
            
        }else {
            u->RemoveFromGroup(GROUPS_SYSTEM,contactlist_current_group-
                    gUserManager.NumGroups());
            gUserManager.DropUser(u);
            refresh_contactlist_single_user(gtk_widget_get_active_uin(
                        GTK_WIDGET(menuitem)));
        } 
    }else {
        on_from_contact_list1_activate(menuitem,NULL);
    }
}

void
on_from_contact_list1_activate         (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
    GtkWidget           *contactlist=lookup_widget(main_window,"alias_clist");
    ICQUser             *u;
    int                 row;
    gchar               *message;

    u=gUserManager.FetchUser(gtk_widget_get_active_uin(GTK_WIDGET(menuitem)),LOCK_R);
    if(!u) {
        return;
    }
    message=g_strdup_printf(
            _("Are you sure you wish to remove %s from the contact list"),
            u->GetAlias());
    if(showtextdialog(_("Remove user"),message,DLGBUTTON_YES|DLGBUTTON_NO)==
            DLGBUTTON_YES) {
        
        gUserManager.DropUser(u);
        licq_daemon->RemoveUserFromList(gtk_widget_get_active_uin(GTK_WIDGET(menuitem)));
        //refresh_contactlist(contactlist_current_group);
    }else {
        gUserManager.DropUser(u);
    }
    g_free(message);
}


void
on_add_to_group1_activate              (GtkMenuItem     *menuitem,
        gpointer         user_data)
{

}


void
on_add_to_group_clicked(GtkMenuItem    *menuitem,
        gpointer         user_data)
{
    GtkWidget           *contactlist=lookup_widget(main_window,"alias_clist");
    int                 row, group;

    gbug("on_add_to_group_clicked\n");
    group=GPOINTER_TO_INT(user_data);
    gUserManager.AddUserToGroup(gtk_widget_get_active_uin(GTK_WIDGET(menuitem)),group);
    refresh_contactlist_single_user(gtk_widget_get_active_uin(GTK_WIDGET(menuitem)));
}


void
on_general_info2_activate              (GtkMenuItem     *menuitem,
        gpointer         user_data)
{
    show_info_dialog_for_user(gtk_widget_get_active_uin(GTK_WIDGET(menuitem)),
            GENERAL_INFO_PAGE);
}


void
on_work_info2_activate                 (GtkMenuItem     *menuitem,
        gpointer         user_data)
{
    show_info_dialog_for_user(gtk_widget_get_active_uin(GTK_WIDGET(menuitem)),
            WORK_INFO_PAGE);
}


void
on_more_info2_activate                 (GtkMenuItem     *menuitem,
        gpointer         user_data)
{
    show_info_dialog_for_user(gtk_widget_get_active_uin(GTK_WIDGET(menuitem)),
            MORE_INFO_PAGE);
}


void
on_about3_activate                     (GtkMenuItem     *menuitem,
        gpointer         user_data)
{
    show_info_dialog_for_user(gtk_widget_get_active_uin(GTK_WIDGET(menuitem)),
            ABOUT_INFO_PAGE);
}

void
on_last_seen1_activate                 (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
    show_info_dialog_for_user(gtk_widget_get_active_uin(GTK_WIDGET(menuitem)),
            LAST_INFO_PAGE);

}


void
on_licq_info1_activate                 (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
    show_info_dialog_for_user(gtk_widget_get_active_uin(GTK_WIDGET(menuitem)),
            LICQ_INFO_PAGE);

}


void
on_view_history2_activate              (GtkMenuItem     *menuitem,
        gpointer         user_data)
{
    show_history_dialog_for_user(gtk_widget_get_active_uin(GTK_WIDGET(menuitem)));
}


void
on_user_popup_show                     (GtkWidget       *widget,
        gpointer         user_data)
{
    GtkWidget   *accept_in_away1 = lookup_widget(GTK_WIDGET(widget),
            "accept_in_away1");
    GtkWidget   *accept_in_not_available1 = lookup_widget(GTK_WIDGET(widget),
            "accept_in_not_available1");
    GtkWidget   *accept_in_occupied1 = lookup_widget(GTK_WIDGET(widget),
            "accept_in_occupied1");
    GtkWidget   *accept_in_do_not_disturb1 = lookup_widget(GTK_WIDGET(widget),
            "accept_in_do_not_disturb1");
    GtkWidget   *online_to_user1 = lookup_widget(GTK_WIDGET(widget),
            "online_to_user1");
    GtkWidget   *away_to_user1 = lookup_widget(GTK_WIDGET(widget),
            "away_to_user1");
    GtkWidget   *not_available_to_user1 = lookup_widget(GTK_WIDGET(widget),
            "not_available_to_user1");
    GtkWidget   *occupied_to_user1 = lookup_widget(GTK_WIDGET(widget),
            "occupied_to_user1");
    GtkWidget   *do_not_disturb_to_user1 = lookup_widget(GTK_WIDGET(widget),
            "do_not_disturb_to_user1");
    GtkWidget   *check_auto_response1 = lookup_widget(GTK_WIDGET(widget),
            "check_auto_response1");
    GtkWidget   *auto_secure1 = lookup_widget(GTK_WIDGET(widget),
            "auto_secure1");
    
    ICQUser     *u = NULL;
    int         status = -1;
    int         aaway, ana, ao, adnd;
    int         autosecure;
    
    do_nothing = 1;

    u =  gUserManager.FetchUser(gtk_widget_get_active_uin(GTK_WIDGET(widget)), 
            LOCK_R);

    if (u == NULL) {
        return;
    }
    status =  u->StatusToUser();
    aaway = u->AcceptInAway();
    ana = u->AcceptInNA();
    ao = u->AcceptInOccupied();
    adnd = u->AcceptInDND();
    autosecure = u->AutoSecure();

    if(u->Status()==ICQ_STATUS_OFFLINE||u->Status()==ICQ_STATUS_ONLINE) {
        gtk_widget_set_sensitive(check_auto_response1,FALSE);
    }
    gUserManager.DropUser(u);


    if (accept_in_away1 != NULL)
        gtk_check_menu_item_set_active(GTK_CHECK_MENU_ITEM(accept_in_away1),
                aaway);

    if (accept_in_not_available1 != NULL)
        gtk_check_menu_item_set_active(
                GTK_CHECK_MENU_ITEM(accept_in_not_available1),ana);

    if (accept_in_occupied1 != NULL)
        gtk_check_menu_item_set_active(GTK_CHECK_MENU_ITEM(accept_in_occupied1),
                ao);

    if (accept_in_do_not_disturb1 != NULL)
        gtk_check_menu_item_set_active(
                GTK_CHECK_MENU_ITEM(accept_in_do_not_disturb1),adnd);

    if (auto_secure1 != NULL)
        gtk_check_menu_item_set_active(
                GTK_CHECK_MENU_ITEM(auto_secure1),autosecure);


    switch(status) {
        case ICQ_STATUS_ONLINE:
            gtk_check_menu_item_set_active(GTK_CHECK_MENU_ITEM(online_to_user1),
                    true);
            break;
        case ICQ_STATUS_AWAY:
            gtk_check_menu_item_set_active(GTK_CHECK_MENU_ITEM(away_to_user1),
                    true);
            break;
        case ICQ_STATUS_NA:
            gtk_check_menu_item_set_active(
                    GTK_CHECK_MENU_ITEM(not_available_to_user1), true);
            break;
        case ICQ_STATUS_OCCUPIED:
            gtk_check_menu_item_set_active(
                    GTK_CHECK_MENU_ITEM(occupied_to_user1), true);
            break;
        case ICQ_STATUS_DND:
            gtk_check_menu_item_set_active(
                    GTK_CHECK_MENU_ITEM(do_not_disturb_to_user1), true);
            break;
    }
    do_nothing = 0;

}

void 
utilty_activate                        (GtkWidget *menuitem,
                                        gpointer data)
{
    show_utility_dialog(gtk_widget_get_active_uin(GTK_WIDGET(menuitem)),
            GPOINTER_TO_INT(data));
}


void
on_popup_all_messages1_activate        (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
    ICQUser         *pUser;                                      
    unsigned long   uin;
    UserList        *_ul_ = gUserManager.LockUserList(LOCK_R);

    for (UserList::iterator _i_ = _ul_->begin(); _i_ != _ul_->end(); _i_++)
    {
        pUser = *_i_;
        pUser->Lock(LOCK_R);
        if(pUser->NewMessages()) {
            uin=pUser->Uin();
            pUser->Unlock();
            popup_user_event_window(uin,MODE_VIEW,0);
        }else {
            pUser->Unlock();
        }
    }
    gUserManager.UnlockUserList();
}

void
on_set_custom_auto_response1_activate  (GtkMenuItem *menuitem,
                                        gpointer user_data)
{
    set_status_with_message(-1,gtk_widget_get_active_uin(GTK_WIDGET(menuitem)));
}

void
on_clear_custom_auto_response1_activate(GtkMenuItem *menuitem,
                                        gpointer user_data)
{
    ICQUser             *u;

    u=gUserManager.FetchUser(gtk_widget_get_active_uin(GTK_WIDGET(menuitem)),
            LOCK_W);
    u->ClearCustomAutoResponse();
    gUserManager.DropUser(u);
}

GtkWidget   *
create_user_popup_menu          (unsigned long  uin,
                                 GtkWidget      *attatch)
{
    GtkWidget       *user_popup, *group_new_menu,*groupmenu,*send1,
                    *online_notify1, *invisible_list1, *visible_list1,
                    *ignore_list1, *utilities1, *accept_in_away1,
                    *accept_in_not_available1, *accept_in_occupied1, 
                    *accept_in_do_not_disturb1, *show_autoresponse1,
                    *clear_custom_auto_response1,*autosecure1, *floating1;
    GroupList       *groups;
    unsigned int    i;
    ICQUser         *user;
    userdata_t      *userinfo=find_user_data(uin,NULL);

    if(!(user=gUserManager.FetchUser(uin,LOCK_R))) {
        return NULL;
    }
    user_popup = create_user_popup();
   
    gtk_widget_set_active_uin(user_popup,uin);
    groupmenu=lookup_widget(user_popup, "add_to_group1");
    send1=lookup_widget(user_popup,"send1");
    online_notify1=lookup_widget(user_popup,"online_notify1");
    invisible_list1=lookup_widget(user_popup,"invisible_list1");
    visible_list1=lookup_widget(user_popup,"visible_list1");
    ignore_list1=lookup_widget(user_popup,"ignore_list1");
    utilities1=lookup_widget(user_popup,"utilities1");
    accept_in_away1=lookup_widget(user_popup,"accept_in_away1");
    autosecure1=lookup_widget(user_popup,"auto_secure1");
    floating1=lookup_widget(user_popup,"floating1");
    accept_in_not_available1=lookup_widget(user_popup,
            "accept_in_not_available1"); 
    accept_in_occupied1=lookup_widget(user_popup,
            "accept_in_occupied1"); 
    accept_in_do_not_disturb1=lookup_widget(user_popup,
            "accept_in_do_not_disturb1"); 
    show_autoresponse1=lookup_widget(user_popup,
            "show_autoresponse1");
    clear_custom_auto_response1=lookup_widget(user_popup,
            "clear_custom_auto_response1");
        /* create a menu and swap e'm l8er */
    group_new_menu=GTK_WIDGET(gtk_menu_new());
    groups=gUserManager.LockGroupList(LOCK_R);
    if(groups) {
        for (i=0;i<groups->size();i++)
        {
            add_group_to_grouplist(group_new_menu,
                    GTK_SIGNAL_FUNC(on_add_to_group_clicked),
                    (*groups)[i],i+1);
        }
    }
    gUserManager.UnlockGroupList();
    gtk_menu_item_set_submenu(GTK_MENU_ITEM(groupmenu),group_new_menu);
    gtk_menu_item_set_submenu(GTK_MENU_ITEM(send1),
            create_send_menu(user_popup,user));
    gtk_menu_item_set_submenu(GTK_MENU_ITEM(utilities1),
            create_utilities_menu(user_popup));
    gtk_check_menu_item_set_show_toggle(
            GTK_CHECK_MENU_ITEM(online_notify1), TRUE);
    gtk_check_menu_item_set_show_toggle(
            GTK_CHECK_MENU_ITEM(invisible_list1), TRUE);
    gtk_check_menu_item_set_show_toggle(
            GTK_CHECK_MENU_ITEM(visible_list1), TRUE);
    gtk_check_menu_item_set_show_toggle(
            GTK_CHECK_MENU_ITEM(ignore_list1), TRUE);
    gtk_check_menu_item_set_show_toggle(
            GTK_CHECK_MENU_ITEM(accept_in_away1), TRUE);
    gtk_check_menu_item_set_show_toggle(
            GTK_CHECK_MENU_ITEM(accept_in_not_available1), TRUE);
    gtk_check_menu_item_set_show_toggle(
            GTK_CHECK_MENU_ITEM(accept_in_occupied1), TRUE);
    gtk_check_menu_item_set_show_toggle(
            GTK_CHECK_MENU_ITEM(accept_in_do_not_disturb1), TRUE);
    gtk_check_menu_item_set_show_toggle(
            GTK_CHECK_MENU_ITEM(show_autoresponse1), TRUE);
    gtk_check_menu_item_set_show_toggle(
            GTK_CHECK_MENU_ITEM(autosecure1), TRUE);
    gtk_check_menu_item_set_show_toggle(
            GTK_CHECK_MENU_ITEM(floating1), TRUE);

    do_nothing=1;
    gtk_check_menu_item_set_active(
            GTK_CHECK_MENU_ITEM(online_notify1),user->OnlineNotify());
    gtk_check_menu_item_set_active(
            GTK_CHECK_MENU_ITEM(invisible_list1),user->InvisibleList());
    gtk_check_menu_item_set_active(
            GTK_CHECK_MENU_ITEM(visible_list1),user->VisibleList());
    gtk_check_menu_item_set_active(
            GTK_CHECK_MENU_ITEM(ignore_list1),user->IgnoreList());
    gtk_check_menu_item_set_active(
            GTK_CHECK_MENU_ITEM(show_autoresponse1),user->ShowAwayMsg());
    gtk_check_menu_item_set_active(
            GTK_CHECK_MENU_ITEM(floating1),userinfo->floating_window?TRUE:FALSE);
    do_nothing=0;
    gtk_widget_set_sensitive(clear_custom_auto_response1,
            user->CustomAutoResponse()&&*user->CustomAutoResponse());
    gUserManager.DropUser(user);
    if (attatch != NULL) {
        gtk_widget_show(user_popup);
        gtk_menu_attach_to_widget(GTK_MENU(user_popup),attatch,
                (GtkMenuDetachFunc)gtk_menu_detach_func_unref);
    }

    return user_popup;
}


void
on_floating1_activate                  (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
    unsigned long       uin;
    userdata_t          *udata;
    GtkWidget           *win;
    
    if(do_nothing) {
        return ;
    }
    uin=gtk_widget_get_active_uin(GTK_WIDGET(menuitem));
    if(!(udata=find_user_data(uin,NULL))) {
        return ;
    }

    if(udata->floating_window) {
        gtk_widget_destroy(udata->floating_window);
        udata->floating_window=NULL;
    }else {
        udata->floating_window=create_user_floating_window(uin);
        refresh_floating_windows();
    }
}
