#include "gtk-gui.h"

#include <sys/time.h>
#include <stdio.h>

#include "interface.h"
#include "contactlist.h"
#include "functions.h"
#include "run_internal_dialog.h"


void
on_utilities_dialog_destroy_event      (GtkWidget       *widget,
                                        gpointer         user_data)
{
    
}


void
on_utility_run_button_clicked          (GtkButton       *button,
                                        gpointer         user_data)
{
   GtkWidget        *utility_dialog;
   GtkWidget        *utility_command_entry;
   GtkWidget        *utility_editfinal_checkbutton; 
   GtkWidget        *entry;
   CUtility         *util;
   CUtilityUserField *utilfield;
   gint             i=0,result=0;
   gchar            title[20],*command,*fullcommand;

   utility_dialog=gtk_widget_get_toplevel(GTK_WIDGET(button));
   util=(CUtility*)gtk_object_get_data(GTK_OBJECT(utility_dialog),"utility");
   utility_command_entry=lookup_widget(utility_dialog,"utility_command_entry");
   utility_editfinal_checkbutton=lookup_widget(utility_dialog,
           "utility_editfinal_checkbutton");
  
   if(GTK_WIDGET_SENSITIVE(utility_editfinal_checkbutton)) {
       vector<const char *> fields(util->NumUserFields());

       for (i=0;i<util->NumUserFields();i++) {
           sprintf(title,"entry_%d",i);
           entry=lookup_widget(utility_dialog,title);
           fields[i]=gtk_editable_get_chars(
                   GTK_EDITABLE(entry),0,-1);
       }
       util->SetUserFields(fields);
       gtk_entry_set_text(GTK_ENTRY(utility_command_entry),
               util->FullCommand());

       for(i=0;i<util->NumUserFields();i++) {
           g_free((gpointer)fields[i]);
       }
   }
   if(GTK_WIDGET_SENSITIVE(utility_editfinal_checkbutton)&&
           gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(
                   utility_editfinal_checkbutton))) {
       
       gtk_widget_set_sensitive(utility_editfinal_checkbutton,FALSE); 
       gtk_editable_set_editable(GTK_EDITABLE(utility_command_entry),TRUE);
       gtk_widget_set_sensitive(utility_command_entry,TRUE);
   }else {
       command=gtk_editable_get_chars(GTK_EDITABLE(utility_command_entry),0,-1);
       switch(util->WinType()) {
           case UtilityWinGui:
               util->SetBackgroundTask();
               result=system(command);
               break;
           case UtilityWinTerm:
               fullcommand=g_strdup_printf("%s %s",licq_daemon->Terminal(),
                      command); 
               result=system(fullcommand);
               g_free(fullcommand);
               break;
           case UtilityWinLicq:
               run_internal_command(command);
               result=0;
               break;
       }
       if(result) {
           fullcommand=g_strdup_printf(
                   _("The command\n\n'%s'\n\nFailed"),
                   command);
           showokdialog(_("Command Failed"),
                   fullcommand);
           g_free(fullcommand);
       }
       g_free(command);
       gtk_widget_destroy(utility_dialog);
   }
}


void
on_utility_cancel_button_clicked       (GtkButton       *button,
                                        gpointer         user_data)
{
    gtk_widget_destroy(gtk_widget_get_toplevel(GTK_WIDGET(button)));
}

void
show_utility_dialog(unsigned long uin,int utilnum)
{
   GtkWidget        *utility_command_entry;
   GtkWidget        *utility_window_entry;
   GtkWidget        *utility_description_entry;
   GtkWidget        *utility_dialog;
   GtkWidget        *utilities_user_hseparator;
   GtkWidget        *utilities_main_table;
   GtkWidget        *label,*entry;
   CUtility         *util;
   CUtilityUserField *utilfield;
   unsigned long    *user;
   gint             i;
   gchar            title[20];

   util=gUtilityManager.Utility(utilnum);
   
   utility_dialog=create_utilities_dialog();
   gtk_widget_set_active_uin(utility_dialog,uin);
   utility_command_entry=lookup_widget(utility_dialog,
           "utility_command_entry");
   utility_window_entry=lookup_widget(utility_dialog,
           "utility_window_entry");
   utility_description_entry=lookup_widget(utility_dialog,
           "utility_description_entry");
   utilities_user_hseparator=lookup_widget(utility_dialog,
           "utilities_user_hseparator");
   utilities_main_table=lookup_widget(utility_dialog,
           "utilities_main_table");

   gtk_object_set_data(GTK_OBJECT(utility_dialog),
           "utility",(gpointer)util);

   util->SetFields(uin);
   gtk_entry_set_text(GTK_ENTRY(utility_command_entry),
           util->FullCommand());
   gtk_entry_set_text(GTK_ENTRY(utility_window_entry),
           get_window_type_text(util->WinType()));
   gtk_entry_set_text(GTK_ENTRY(utility_description_entry),
           util->Description());
   gtk_widget_set_sensitive(utility_command_entry,FALSE);
   gtk_widget_set_sensitive(utility_window_entry,FALSE);
   gtk_widget_set_sensitive(utility_description_entry,FALSE);

   if(util->NumUserFields()) {
        gtk_table_resize(GTK_TABLE(utilities_main_table),2,
               util->NumUserFields()+5); 
        for(i=0;i<util->NumUserFields();i++) {
            utilfield=util->UserField(i);
            label=gtk_label_new(utilfield->Title());
            entry=gtk_entry_new();
            gtk_widget_ref(label);
            gtk_widget_ref(entry);
            sprintf(title,"label_%d",i);
            gtk_object_set_data_full(GTK_OBJECT(utility_dialog),
                    title,label,(GtkDestroyNotify)gtk_widget_unref);
            sprintf(title,"entry_%d",i);
            gtk_object_set_data_full(GTK_OBJECT(utility_dialog),
                    title,entry,(GtkDestroyNotify)gtk_widget_unref);

            if(utilfield->FullDefault()) {
                gtk_entry_set_text(GTK_ENTRY(entry),utilfield->FullDefault());
            }
            gtk_table_attach(GTK_TABLE(utilities_main_table),label,
                    0,1,i+5,i+6,(GtkAttachOptions)(GTK_FILL),
                    (GtkAttachOptions)(0),0,0);
            gtk_table_attach(GTK_TABLE(utilities_main_table),entry,
                    1,2,i+5,i+6,(GtkAttachOptions)(GTK_EXPAND|GTK_FILL),
                    (GtkAttachOptions)(0),0,0);
            gtk_widget_show(entry);
            gtk_widget_show(label);
        }
   }else {
       gtk_widget_hide(utilities_user_hseparator);
   }

   gtk_widget_show(utility_dialog);
}

gboolean
on_utilities_dialog_delete_event       (GtkWidget       *widget,
                                        GdkEvent        *event,
                                        gpointer         user_data)
{
    gtk_widget_destroy(widget);
    return FALSE;
}

