#include "gtk-gui.h"

#include <sys/stat.h>
#include <unistd.h>
#include <gdk/gdkkeysyms.h>

#include "view_event_window.h"
#include "send_event_window.h"
#include "interface.h"
#include "functions.h"
#include "contactlist.h"
#include "authorize_user_dialog.h"
#include "transfer_dialog.h"
#include "user_info_dialog.h"
#include "history_dialog.h"
#include "user_popup.h"


typedef struct {
    gint    button1_handler;
    gint    button2_handler;
    gint    button3_handler;
    gint    button4_handler;
    gint    viewurl_handler;
} vieweventwindowdata_t;

void
delete_event_copy                      (gpointer    data)
{
    if(data) {
        delete (CUserEvent*)data;
    }
}

void
append_event_to_eventlist               (CUserEvent *event,
                                         GtkWidget  *view_event_window)
{
    char            tmp[20],flags[6];
    gchar           *summary=NULL, *sumend, *field[4];
    GtkWidget       *message_clist=lookup_widget(view_event_window,
            "message_clist");
    CUserEvent      *copy;
    GdkPixMask_t    *pix;
    time_t          timep;
    int             row;
    GList           *rows;

    rows=GTK_CLIST(message_clist)->row_list;
    while(rows) {
        if(rows->data&&
                ((GtkCListRow*)(rows->data))->data&&
                event->Id()==((CUserEvent*)((((GtkCListRow*)(rows->data))->data)))->Id()) {
            return ;
        }
        rows=g_list_next(rows);
    }


    switch(event->SubCommand())
    {
        case ICQ_CMDxSUB_MSG:
            summary=g_strdup(event->Text());
            break;
        case ICQ_CMDxSUB_URL:
            summary=g_strdup(((CEventUrl *)event)->Url());
            break;
        case ICQ_CMDxSUB_CHAT:
            summary=g_strdup(((CEventChat *)event)->Reason());
            break;
        case ICQ_CMDxSUB_FILE:
            summary=g_strdup(((CEventFile *)event)->Filename());
            break;
        case ICQ_CMDxSUB_AUTHxREQUEST:
            summary=g_strdup(_("Authorization request"));
            break;
        case ICQ_CMDxSUB_AUTHxREFUSED:
            summary=g_strdup(_("Authorization refused"));
            break;
        case ICQ_CMDxSUB_AUTHxGRANTED:
            summary=g_strdup(_("Authorization granted"));
            break;
        case ICQ_CMDxSUB_ADDEDxTOxLIST:
            summary=g_strdup(_("Added to contact list"));
            break;
        case ICQ_CMDxSUB_WEBxPANEL:
            summary=g_strdup(_("Web panel"));
            break;
        case ICQ_CMDxSUB_EMAILxPAGER:
            summary=g_strdup(_("Email pager"));
            break;
        case ICQ_CMDxSUB_CONTACTxLIST:
            summary=g_strdup(_("Contacts"));
            break;
        default:
            break;
    }
    if(summary) {
        for(sumend=summary;*sumend&&*sumend!='\n';sumend++) {
        }
        *sumend=0;
    }

    memset(tmp,0,20);
    flags[0]=(event->IsDirect())?'D':'-';
    flags[1]=(event->IsUrgent())?'U':'-';
    flags[2]=(event->IsMultiRec())?'M':'-';
    flags[3]=(event->IsEncrypted())?'E':'-';
    flags[4]=(event->IsLicq())?'L':'-';
    flags[5]='\0';
    timep = event->Time();
    strftime(tmp,20,"%Y-%m-%d %H:%M:%S",localtime(&timep));
    field[0]="";
    field[1]=tmp;
    field[2]=flags;
    field[3]=summary?summary:(gchar*)"";

    pix=geticonforevent(event->SubCommand());
    row = gtk_clist_append(GTK_CLIST(message_clist),field);
    copy=event->Copy();
    gtk_clist_set_row_data_full(GTK_CLIST(message_clist),row,
            (gpointer)copy,delete_event_copy);
    gtk_clist_set_pixmap(GTK_CLIST(message_clist),row,0,pix->pix,pix->mask);
    if(summary) {
        g_free(summary);
    }
}

void
on_url_button_clicked                  (GtkButton       *button,
                                        gpointer         user_data)
{
    CUserEvent      *e = (CUserEvent *) user_data; 

    view_url(((CEventUrl *)e)->Url());
}


void
on_view_close_button_clicked           (GtkButton       *button,
                                        gpointer         user_data)
{
    GtkWidget       *view_event_window=gtk_widget_get_toplevel(
            GTK_WIDGET(button));

    shutdown_view_event_window(view_event_window);
}


void
on_status_usermenu_button_clicked      (GtkButton       *button,
                                        gpointer         user_data)
{
    GtkWidget       *user_popup, *view_event2;;
    unsigned long   uin=gtk_widget_get_active_uin(GTK_WIDGET(button));

    if((user_popup=create_user_popup_menu(uin,NULL))) {
        view_event2=lookup_widget(user_popup, "view_event2");
        gtk_widget_set_sensitive(view_event2,FALSE);
        gtk_menu_popup (GTK_MENU (user_popup), NULL, NULL, NULL, NULL, 0, 0);
    }
}


void
on_status_message_button_clicked       (GtkButton       *button,
                                        gpointer         user_data)
{
    unsigned long       uin=gtk_widget_get_active_uin(GTK_WIDGET(button));
    GtkWidget           *uwindow;

    if((uwindow=show_send_event_window_for_user(uin,SEND_MESSAGE))) {
        gtk_object_set_data(GTK_OBJECT(uwindow),"from_view_window",
                GINT_TO_POINTER(TRUE));
    }
}


void
on_status_url_button_clicked           (GtkButton       *button,
                                        gpointer         user_data)
{
    unsigned long       uin=gtk_widget_get_active_uin(GTK_WIDGET(button));
    GtkWidget           *uwindow;

    if((uwindow=show_send_event_window_for_user(uin,SEND_URL))) {
        gtk_object_set_data(GTK_OBJECT(uwindow),"from_view_window",
                GINT_TO_POINTER(TRUE));
    }
}


void
on_status_file_button_clicked          (GtkButton       *button,
                                        gpointer         user_data)
{
    unsigned long       uin=gtk_widget_get_active_uin(GTK_WIDGET(button));
    GtkWidget           *uwindow;

    if((uwindow=show_send_event_window_for_user(uin,SEND_FILE))) {
        gtk_object_set_data(GTK_OBJECT(uwindow),"from_view_window",
                GINT_TO_POINTER(TRUE));
    }
}


void
on_status_chat_button_clicked          (GtkButton       *button,
                                        gpointer         user_data)
{
    unsigned long       uin=gtk_widget_get_active_uin(GTK_WIDGET(button));
    GtkWidget           *uwindow;

    if((uwindow=show_send_event_window_for_user(uin,SEND_CHAT))) {
        gtk_object_set_data(GTK_OBJECT(uwindow),"from_view_window",
                GINT_TO_POINTER(TRUE));
    }
}


void
on_status_contacts_button_clicked      (GtkButton       *button,
                                        gpointer         user_data)
{
    unsigned long       uin=gtk_widget_get_active_uin(GTK_WIDGET(button));
    GtkWidget           *uwindow;

    if((uwindow=show_send_event_window_for_user(uin,SEND_CONTACTS))) {
        gtk_object_set_data(GTK_OBJECT(uwindow),"from_view_window",
                GINT_TO_POINTER(TRUE));
    }
}


void
on_status_secure_button_clicked        (GtkButton       *button,
                                        gpointer         user_data)
{
    unsigned long   uin;
    ICQUser         *user = NULL;
    bool            secure = false;

    gbug("on_status_secure_button_clicked\n");
    uin=gtk_widget_get_active_uin(GTK_WIDGET(button));
    if (uin && ((user = gUserManager.FetchUser(uin,LOCK_R)) != NULL)) {
        secure = user->Secure();
        gUserManager.DropUser(user);
    }
    
    if (secure) {
        licq_daemon->icqCloseSecureChannel(uin);
    } else {
        licq_daemon->icqOpenSecureChannel(uin);
    }
    register_eventcallback(secure_result_callback, NULL);
}

gboolean
on_view_event_window_delete_event      (GtkWidget       *widget,
                                        GdkEvent        *event,
                                        gpointer         user_data)
{
    shutdown_view_event_window(widget);
    return FALSE;
}

void 
on_quote_button_clicked                (GtkButton   *button, 
                                        gpointer    user_data)
{
    GtkWidget       *type_notebook=lookup_widget(GTK_WIDGET(button),
            "type_notebook");
    GtkWidget       *message_textbox=lookup_widget(GTK_WIDGET(button),
            "message_textbox");
    GtkWidget       *description_textbox=lookup_widget(GTK_WIDGET(button),
            "description_textbox");
    GtkWidget       *send_event_window;
    gchar           *text=NULL;
    unsigned long   uin=gtk_widget_get_active_uin(GTK_WIDGET(button));

    if(GPOINTER_TO_INT(user_data)) {
        switch(gtk_notebook_get_current_page(GTK_NOTEBOOK(type_notebook))) {
            case 0:
                text=gtk_editable_get_chars(GTK_EDITABLE(message_textbox),0,-1);
                break;
            case 1:
                text=gtk_editable_get_chars(GTK_EDITABLE(description_textbox),
                        0,-1);
                break;
            default:
                gbug("on_quote_button_clicked: CANNOT HANDLE page %d\n",
                        gtk_notebook_get_current_page(
                            GTK_NOTEBOOK(type_notebook)));
        }
    }
    send_event_window=show_send_event_window_for_user(uin,SEND_MESSAGE);
    gtk_object_set_data(GTK_OBJECT(send_event_window),"from_view_window",
            GINT_TO_POINTER(TRUE));
    insert_quoted_text_into_send_message(send_event_window,text);
    gtk_widget_grab_focus(send_event_window);
    if(text) {
        g_free(text);
    }
}

void 
on_authorize_button_clicked            (GtkButton   *button, 
                                        gpointer    user_data)
{
    GtkWidget       *message_textbox=lookup_widget(GTK_WIDGET(button),
            "message_textbox");
    gchar           *text;
    unsigned long   uin=0;
    GtkWidget       *authdialog;
        /* FIXME: on_adduser_button_clicked has the correct code for this */
    if((text=gtk_editable_get_chars(GTK_EDITABLE(message_textbox),0,-1))) {
        uin=get_user_uin_from_sysmsg(text);
        g_free(text);
    }
    authdialog=show_authorize_dialog(GPOINTER_TO_INT(user_data),uin);
    gtk_object_set_data(GTK_OBJECT(authdialog),"view_triggered",
            GINT_TO_POINTER(TRUE));
}

void 
on_adduser_button_clicked (GtkButton *button, gpointer user_data)
{
    GtkWidget       *message_textbox=lookup_widget(GTK_WIDGET(button),
            "message_textbox");
    GtkWidget       *message_clist=lookup_widget(GTK_WIDGET(button),
            "message_clist");
    GtkWidget       *add_user_entry;
    GtkWidget       *add_user_dialog;
    CUserEvent      *e;

    gchar           struin[20]="";
    unsigned long   uin=0;


    if(!GTK_CLIST(message_clist)->selection||
            !(e=(CUserEvent*)gtk_clist_get_row_data(GTK_CLIST(message_clist),
                    GPOINTER_TO_INT(GTK_CLIST(message_clist)->selection->data)))) {
        return ;
    }
    switch(e->SubCommand())
    {
        case ICQ_CMDxSUB_ADDEDxTOxLIST:
            uin=((CEventAdded*)e)->Uin();
            break;
        case ICQ_CMDxSUB_AUTHxREQUEST:
            uin=((CEventAuthRequest*)e)->Uin();
            break;
    }
    if(uin) {
        sprintf(struin,"%ld",uin);
    }
    add_user_dialog=create_add_user_dialog();
    if(uin) {
        add_user_entry=lookup_widget(add_user_dialog,"add_user_entry");
        gtk_entry_set_text(GTK_ENTRY(add_user_entry),struin);
    }
    gtk_object_set_data(GTK_OBJECT(add_user_dialog),"view_triggered",
            GINT_TO_POINTER(TRUE));
    gtk_widget_show(add_user_dialog);
}

void 
on_contactadduser_button_clicked (GtkButton *button, gpointer user_data)
{
    GtkWidget       *contacts_clist=lookup_widget(GTK_WIDGET(button),
            "contacts_clist");
    GtkWidget       *add_user_entry;
    GtkWidget       *add_user_dialog;

    gchar           *text;
    gint            row;

    if(!GTK_CLIST(contacts_clist)->selection) {
        return;
    }
    row=GPOINTER_TO_INT(GTK_CLIST(contacts_clist)->selection->data); 
    gtk_clist_get_text(GTK_CLIST(contacts_clist),row,0,&text);
    add_user_dialog = create_add_user_dialog();
    add_user_entry=lookup_widget(add_user_dialog,"add_user_entry");
    gtk_entry_set_text(GTK_ENTRY(add_user_entry),text);
    gtk_widget_show(add_user_dialog);
}

void 
on_chat_accept_button_clicked(GtkButton *button, gpointer user_data)
{
    int         port;
    CEventChat  *e = (CEventChat *) user_data;
     GtkWidget       *status_autoclose_checkbutton=lookup_widget(
             GTK_WIDGET(button), "status_autoclose_checkbutton");
    GtkWidget   *view_event_window=gtk_widget_get_toplevel(
            GTK_WIDGET(button));
    GtkWidget   *chat_dialog;
    unsigned long uin=gtk_widget_get_active_uin(GTK_WIDGET(button));
    ICQUser     *user = NULL;
    ICQOwner    *owner = NULL;
    char        *local_file;

    chat_dialog = create_multichat_window();
    gtk_widget_show(chat_dialog);

    if (e->Port() != 0) // Joining a multiparty chat (we connect to them)
    {
        owner=gUserManager.FetchOwner(LOCK_R);
        if ((port = chat_StartAsClient(e->Port(),uin,owner->GetAlias(),
                        chat_dialog)) > 0) {
            licq_daemon->icqChatRequestAccept(uin,port,e->Sequence());
        }
        gUserManager.DropOwner();
    } else { // single party (other side connects to us)
        if ((port = chat_StartAsServer(chat_dialog)) > 0){
            licq_daemon->icqChatRequestAccept(uin,port,e->Sequence());
        }
    }

    if(gtk_toggle_button_get_active(
                GTK_TOGGLE_BUTTON(status_autoclose_checkbutton))) {
        shutdown_view_event_window(view_event_window);
    }
}

void 
on_chat_refuse_button_clicked(GtkButton *button, gpointer user_data)
{
    CUserEvent      *e = (CUserEvent *) user_data;
    GtkWidget       *refuse_dialog;
    GtkWidget       *status_autoclose_checkbutton=lookup_widget(
            GTK_WIDGET(button), "status_autoclose_checkbutton");
    unsigned long   uin=gtk_widget_get_active_uin(GTK_WIDGET(button));

    refuse_dialog = create_refuse_dialog();

    gtk_object_set_data (GTK_OBJECT (refuse_dialog), "event", e);
    gtk_widget_set_active_uin(refuse_dialog,uin);
    gtk_widget_show(refuse_dialog);
    gbug ("sub cmd CHAT? : %x\n",e->SubCommand());
    
    if(gtk_toggle_button_get_active(
                GTK_TOGGLE_BUTTON(status_autoclose_checkbutton))) {
        shutdown_view_event_window(
                gtk_widget_get_toplevel(status_autoclose_checkbutton));
    }
}

void
on_dir_selected           (GtkButton       *button,
        gpointer         user_data)
{
    GtkWidget       *view_event_window = GTK_WIDGET(user_data);
    GtkWidget       *dir_browser = lookup_widget(GTK_WIDGET(button),
            "dir_browser");
    GtkWidget       *url_entry = lookup_widget(GTK_WIDGET(view_event_window),
            "url_entry");
    char            *dirname;
    struct stat     stat_buf;
    
    dirname = gtk_file_selection_get_filename(GTK_FILE_SELECTION(dir_browser));
    if ((dirname != NULL ) && (strlen(dirname) > 0)) {
        if ((stat(dirname,&stat_buf) >= 0) && (S_ISDIR(stat_buf.st_mode))) {
            gtk_entry_set_text(GTK_ENTRY(url_entry),dirname);
            gtk_widget_destroy(dir_browser);
        }
    }
}

void
on_browse_clicked           (GtkButton       *button,
                             gpointer         user_data)
{
    GtkWidget       *view_event_window = gtk_widget_get_toplevel(
            GTK_WIDGET(button));
    GtkWidget       *file_dialog, *file_ok_button, *cancel_button1;

    file_dialog = gtk_file_selection_new (_("Select File"));
    gtk_object_set_data (GTK_OBJECT (file_dialog), "dir_browser", file_dialog);
    gtk_container_set_border_width (GTK_CONTAINER (file_dialog), 10);
    gtk_window_set_position (GTK_WINDOW (file_dialog), GTK_WIN_POS_CENTER);

    file_ok_button = GTK_FILE_SELECTION (file_dialog)->ok_button;
    gtk_widget_show (file_ok_button);
    GTK_WIDGET_SET_FLAGS (file_ok_button, GTK_CAN_DEFAULT);

    cancel_button1 = GTK_FILE_SELECTION (file_dialog)->cancel_button;
    gtk_widget_show (cancel_button1);
    GTK_WIDGET_SET_FLAGS (cancel_button1, GTK_CAN_DEFAULT);

    gtk_signal_connect (GTK_OBJECT (file_ok_button), "clicked",
            GTK_SIGNAL_FUNC (on_dir_selected),
            view_event_window);

    gtk_signal_connect_object (GTK_OBJECT (cancel_button1), "clicked",
            GTK_SIGNAL_FUNC (gtk_widget_destroy),
            GTK_OBJECT (file_dialog));
    gtk_widget_set_sensitive(GTK_FILE_SELECTION (file_dialog)->file_list,false);
    gtk_widget_show(file_dialog);
}

void
on_file_button_clicked      (GtkButton       *button,
                             gpointer         user_data)
{
    int             port;
    CUserEvent      *e = (CUserEvent *) user_data;
    GtkWidget       *view_event_window = gtk_widget_get_toplevel(
            GTK_WIDGET(button));
    GtkWidget       *status_autoclose_checkbutton=lookup_widget(
            GTK_WIDGET(button), "status_autoclose_checkbutton");
    GtkWidget       *url_entry=lookup_widget(GTK_WIDGET(button),"url_entry");
    GtkWidget       *transfer_dialog;
    unsigned long   uin=gtk_widget_get_active_uin(GTK_WIDGET(button));
    ICQUser         *user = NULL;
    char            *local_dir;
    struct stat     st;

    local_dir = gtk_editable_get_chars(GTK_EDITABLE(url_entry),0,-1);
    
    if ((stat(local_dir,&st) == -1) || !S_ISDIR(st.st_mode)) {
        showokdialog(_("Error"), _("The directory you have specified doesn't\nseem to be a valid directory"));
        return;
    }
    transfer_dialog = create_transfer_dialog();
    gtk_widget_show(transfer_dialog);
    if ((port = file_recive(uin,local_dir,transfer_dialog)) >= 0) {
        licq_daemon->icqFileTransferAccept(uin,port,e->Sequence());
    
        if(gtk_toggle_button_get_active(
                    GTK_TOGGLE_BUTTON(status_autoclose_checkbutton))){
            shutdown_view_event_window(view_event_window); 
        }
    }
    g_free(local_dir);
}

void
on_refuse_file_button_clicked   (GtkButton       *button,
                                 gpointer         user_data)
{
    CUserEvent      *e = (CUserEvent *) user_data;
    GtkWidget       *refuse_dialog;
    GtkWidget       *status_autoclose_checkbutton=lookup_widget(
            GTK_WIDGET(button), "status_autoclose_checkbutton");
    unsigned long   uin=gtk_widget_get_active_uin(GTK_WIDGET(button));

    refuse_dialog = create_refuse_dialog();
    
    gtk_object_set_data (GTK_OBJECT (refuse_dialog), "event", e);
    gbug("event: %p\n",e);
    gtk_widget_set_active_uin(refuse_dialog,uin);

    gtk_widget_show(refuse_dialog);

    if(gtk_toggle_button_get_active(
                GTK_TOGGLE_BUTTON(status_autoclose_checkbutton))) {
        shutdown_view_event_window(
                gtk_widget_get_toplevel(status_autoclose_checkbutton));
    }
}

void
on_forward_user_select              (GtkMenuItem      *item,
                                     GtkWidget        *button)
{
    GtkWidget       *message_clist=lookup_widget(button, "message_clist");
    GtkWidget       *send_event_dialog, *send_text, *file_text, *filename_entry,
                    *contacts_to_send_clist, *contacts_to_select_clist,
                    *contacts_clist;
    CUserEvent      *e;

    gchar           *text[1];
    unsigned long   *uin,*suin;
    gint            i,j,row;
    GdkColor        *color;


    if(!GTK_CLIST(message_clist)->selection||
            !(e=(CUserEvent*)gtk_clist_get_row_data(GTK_CLIST(message_clist),
                    GPOINTER_TO_INT(GTK_CLIST(message_clist)->selection->data)))) {
        return ;
    }
    if(!(uin=(unsigned long*)gtk_object_get_data(GTK_OBJECT(item),"user_uin"))) {
        return ;
    }

    switch(e->SubCommand())
    {
        case ICQ_CMDxSUB_MSG:
            if((send_event_dialog=show_send_event_window_for_user(*uin,
                            SEND_MESSAGE))) {
                send_text=lookup_widget(send_event_dialog,"send_text"); 
                gtk_text_insert(GTK_TEXT(send_text),NULL,NULL,NULL,
                        e->Text(), -1);
                if(e->Color()) {
                    color=(GdkColor*)malloc(sizeof(GdkColor));
                    if(color) {
                        ICQBACK_TO_GDK_COLOR(e->Color(),*color);
                        set_outgoing_message_background(send_event_dialog,color);
                    }
                    color=(GdkColor*)malloc(sizeof(GdkColor));
                    if(color) {
                        ICQFORE_TO_GDK_COLOR(e->Color(),*color);
                        set_outgoing_message_foreground(send_event_dialog,color);
                    }
                }
            }
            break;
        case ICQ_CMDxSUB_URL:
            if((send_event_dialog=show_send_event_window_for_user(*uin,
                            SEND_URL))) {
                file_text=lookup_widget(send_event_dialog,"file_text"); 
                filename_entry=lookup_widget(send_event_dialog,"filename_entry"); 
                gtk_text_insert(GTK_TEXT(file_text),NULL,NULL,NULL,
                        ((CEventUrl *)e)->Description(), 
                        -1);
                gtk_entry_set_text(GTK_ENTRY(filename_entry),
                        ((CEventUrl *)e)->Url());

                if(e->Color()) {
                    color=(GdkColor*)malloc(sizeof(GdkColor));
                    if(color) {
                        ICQBACK_TO_GDK_COLOR(e->Color(),*color);
                        set_outgoing_message_background(send_event_dialog,color);
                    }
                    color=(GdkColor*)malloc(sizeof(GdkColor));
                    if(color) {
                        ICQFORE_TO_GDK_COLOR(e->Color(),*color);
                        set_outgoing_message_foreground(send_event_dialog,color);
                    }
                }
            }
            break;
        case ICQ_CMDxSUB_CONTACTxLIST:
            if((send_event_dialog=show_send_event_window_for_user(*uin,
                            SEND_CONTACTS))) {
                contacts_clist=lookup_widget(button,"contacts_clist");
                contacts_to_select_clist=lookup_widget(send_event_dialog,
                        "contacts_to_select_clist"); 
                contacts_to_send_clist=lookup_widget(send_event_dialog,
                        "contacts_to_send_clist"); 
                for(i=gtk_clist_get_length(GTK_CLIST(contacts_clist))-1;i>=0;i--) {

                    gtk_clist_get_text(GTK_CLIST(contacts_clist),i,0,&text[0]);
                    sscanf(text[0],"%ld",uin);
                    for(j=gtk_clist_get_length(GTK_CLIST(contacts_to_select_clist))-1;j>=0;j--) {
                        suin=(unsigned long*)gtk_clist_get_row_data(
                                GTK_CLIST(contacts_to_select_clist),j);
                        if(*suin==*uin) {
                            gtk_clist_remove(GTK_CLIST(contacts_to_select_clist),
                                    j);
                            break;
                        }
                    }
                    suin=(unsigned long*)malloc(sizeof(unsigned long));
                    *suin=*uin;
                    gtk_clist_get_text(GTK_CLIST(contacts_clist),i,1,&text[0]);
                    row=gtk_clist_append(GTK_CLIST(contacts_to_send_clist),text);
                    gtk_clist_set_row_data_full(GTK_CLIST(contacts_to_send_clist),
                        row,(gpointer)suin,destroy_notify_free);
                }
            }
            break;
    }
}


void
on_forward_button_clicked           (GtkButton       *button,
                                     gpointer         user_data)
{
    GtkWidget       *menu, *item;
    GdkPixMask_t    *pix;
    unsigned long   *uinptr;

    menu=gtk_menu_new();
    FOR_EACH_USER_START(LOCK_R); 
        pix=getuserstatusicon(pUser,FALSE);
        item=gtk_menu_item_new_with_label_color_and_pixmap(
                pUser->GetAlias(),
                NULL,pix);
        gtk_signal_connect(GTK_OBJECT(item),"activate",
                GTK_SIGNAL_FUNC(on_forward_user_select),(gpointer)button);
        if((uinptr=(unsigned long*)malloc(sizeof(unsigned long)))) {
            *uinptr=pUser->Uin();
            gtk_object_set_data_full(GTK_OBJECT(item),"user_uin",
                    (gpointer)uinptr,(GtkDestroyNotify)destroy_notify_free);
        }
        gtk_menu_append(GTK_MENU(menu),item);
    FOR_EACH_USER_END;
    gtk_menu_popup(GTK_MENU(menu),NULL,NULL,NULL,0,0,0);
}

void
on_message_clist_select_row            (GtkCList        *clist,
                                        gint             row,
                                        gint             column,
                                        GdkEvent        *event,
                                        gpointer         user_data)
{
    GtkWidget       *event_1_button=lookup_widget(GTK_WIDGET(clist),
            "event_1_button");
    GtkWidget       *event_2_button=lookup_widget(GTK_WIDGET(clist),
            "event_2_button");
    GtkWidget       *event_3_button=lookup_widget(GTK_WIDGET(clist),
            "event_3_button");
    GtkWidget       *event_4_button=lookup_widget(GTK_WIDGET(clist),
            "event_4_button");
    GtkWidget       *url_button=lookup_widget(GTK_WIDGET(clist),
            "url_button");
    GtkWidget       *url_entry=lookup_widget(GTK_WIDGET(clist),
            "url_entry");
    GtkWidget       *url_label=lookup_widget(GTK_WIDGET(clist),
            "url_label");
    GtkWidget       *description_textbox=lookup_widget(GTK_WIDGET(clist),
            "description_textbox");
    GtkWidget       *message_textbox=lookup_widget(GTK_WIDGET(clist),
            "message_textbox");
    GtkWidget       *type_notebook=lookup_widget(GTK_WIDGET(clist),
            "type_notebook");
    GtkWidget       *contacts_clist=lookup_widget(GTK_WIDGET(clist),
            "contacts_clist");
    GtkWidget       *eventbuttons_hbuttonbox=lookup_widget(GTK_WIDGET(clist),
            "eventbuttons_hbuttonbox");

    vieweventwindowdata_t   *windowdata;
    CUserEvent      *e=(CUserEvent *)gtk_clist_get_row_data(clist,row), *tmpevent;
    ICQUser         *user=NULL;
    gint            last_message_type;
    gchar           *textcpy,*nextln,*thisln,*addptr[3];
    unsigned long   uin;
    gint            i,cindex;

    gbug("on_message_clist_select_row %p %p\n",(void*)e->Command(), 
            (void*)e->SubCommand());
    uin=gtk_widget_get_active_uin(GTK_WIDGET(clist));
    windowdata=(vieweventwindowdata_t*)gtk_object_get_data(
            GTK_OBJECT(gtk_widget_get_toplevel(event_1_button)),"windowdata");
    if(!windowdata) {
        gbug("no windowdata\n");
        return ;
    }
    last_message_type = 
        GPOINTER_TO_INT(gtk_object_get_data(
                    GTK_OBJECT(gtk_widget_get_toplevel(event_1_button)),
                    "last_message_type"));
    if(e->Id()!=-1) {
        gbug("should clear\n");
        user=(uin>0)?gUserManager.FetchUser(uin,LOCK_W):
            gUserManager.FetchOwner(LOCK_W);
        user->EventClearId(e->Id());
        gUserManager.DropUser(user);
    }

    if ((e->Command() == ICQ_CMDxTCP_START) || 
            (e->Command() == ICQ_CMDxRCV_SYSxMSGxONLINE) ||
            (e->Command() == ICQ_CMDxSND_THRUxSERVER)) {
        if (e->SubCommand()!=last_message_type) {
            gtk_widget_set_sensitive(event_1_button,TRUE);
            gtk_widget_set_sensitive(event_2_button,TRUE);
            gtk_widget_set_sensitive(event_3_button,TRUE);
            gtk_widget_set_sensitive(event_4_button,TRUE);
            gtk_widget_show_all(eventbuttons_hbuttonbox);
        }
        if(windowdata->button1_handler>0) {
            gtk_signal_disconnect(GTK_OBJECT(event_1_button), 
                    windowdata->button1_handler);
            windowdata->button1_handler=0;
        }
        if(windowdata->button2_handler>0) {
            gtk_signal_disconnect(GTK_OBJECT(event_2_button), 
                    windowdata->button2_handler);
            windowdata->button2_handler=0;
        }
        if(windowdata->button3_handler>0) {
            gtk_signal_disconnect(GTK_OBJECT(event_3_button), 
                    windowdata->button3_handler);
            windowdata->button3_handler=0;
        }
        if(windowdata->button4_handler>0) {
            gtk_signal_disconnect(GTK_OBJECT(event_4_button), 
                    windowdata->button4_handler);
            windowdata->button4_handler=0;
        }
        if(windowdata->viewurl_handler>0) {
            gtk_signal_disconnect(GTK_OBJECT(url_button), 
                    windowdata->viewurl_handler);
            windowdata->viewurl_handler=0;
        }
        switch (e->SubCommand()) {
            case ICQ_CMDxSUB_MSG:
                if (last_message_type!=ICQ_CMDxSUB_MSG) {
                    gtk_licq_button_set(GTK_BUTTON(event_1_button),
                            GTK_LICQ_BUTTON_REPLY);
                    gtk_licq_button_set(GTK_BUTTON(event_2_button),
                            GTK_LICQ_BUTTON_QUOTEREPLY);
                    gtk_licq_button_set(GTK_BUTTON(event_3_button),
                            GTK_LICQ_BUTTON_FORWARD);
                    gtk_widget_hide(event_4_button);
                    gtk_notebook_set_page(GTK_NOTEBOOK(type_notebook),0);
                }
                windowdata->button1_handler=gtk_signal_connect_after(
                        GTK_OBJECT(event_1_button), 
                        "clicked", 
                        GTK_SIGNAL_FUNC(on_quote_button_clicked),
                        GINT_TO_POINTER(FALSE));
                windowdata->button2_handler = gtk_signal_connect_after(
                        GTK_OBJECT(event_2_button), 
                        "clicked", 
                        GTK_SIGNAL_FUNC(on_quote_button_clicked),
                        GINT_TO_POINTER(TRUE));
                windowdata->button3_handler = gtk_signal_connect_after(
                        GTK_OBJECT(event_3_button), 
                        "clicked", 
                        GTK_SIGNAL_FUNC(on_forward_button_clicked),
                        NULL);
                gtk_text_freeze(GTK_TEXT(message_textbox));
                gtk_editable_delete_text(GTK_EDITABLE(message_textbox),0,-1);
                gtk_text_insert(GTK_TEXT(message_textbox),NULL,NULL,NULL,
                        e->Text(), -1);
                gtk_text_set_point(GTK_TEXT(message_textbox),0);
                gtk_text_thaw(GTK_TEXT(message_textbox));
                apply_message_colors(gtk_widget_get_toplevel(GTK_WIDGET(clist)),
                            e);
                break;
            case ICQ_CMDxSUB_AUTHxREQUEST:
                if (last_message_type!=ICQ_CMDxSUB_AUTHxREQUEST) {
                    gtk_licq_button_set(GTK_BUTTON(event_1_button),
                            GTK_LICQ_BUTTON_REFUSE);
                    gtk_licq_button_set(GTK_BUTTON(event_2_button),
                            _("Authorize"));
                    gtk_licq_button_set(GTK_BUTTON(event_3_button),
                            GTK_LICQ_BUTTON_ADDUSER);
                    gtk_widget_hide(event_4_button);
                    gtk_notebook_set_page(GTK_NOTEBOOK(type_notebook),0);
                }
                uin=((CEventAuthRequest*)e)->Uin();
                if(!uin||gUserManager.FetchUser(uin,LOCK_N)) {
                    gtk_widget_set_sensitive(event_3_button,FALSE);
                }
                windowdata->button1_handler = gtk_signal_connect(
                        GTK_OBJECT(event_1_button), 
                        "clicked", 
                        GTK_SIGNAL_FUNC(on_authorize_button_clicked),
                        GINT_TO_POINTER(FALSE));
                windowdata->button2_handler = gtk_signal_connect(
                        GTK_OBJECT(event_2_button), 
                        "clicked", 
                        GTK_SIGNAL_FUNC(on_authorize_button_clicked),
                        GINT_TO_POINTER(TRUE));
                windowdata->button3_handler = gtk_signal_connect(
                        GTK_OBJECT(event_3_button), 
                        "clicked", 
                        GTK_SIGNAL_FUNC(on_adduser_button_clicked),
                        NULL);
                gtk_text_freeze(GTK_TEXT(message_textbox));
                gtk_editable_delete_text(GTK_EDITABLE(message_textbox),0,-1);
                gtk_text_insert(GTK_TEXT(message_textbox),NULL,NULL,NULL,
                        e->Text(),strlen(e->Text()));
                gtk_text_set_point(GTK_TEXT(message_textbox),0);
                gtk_text_thaw(GTK_TEXT(message_textbox));
                break;
            case ICQ_CMDxSUB_ADDEDxTOxLIST:
                if (last_message_type!=ICQ_CMDxSUB_ADDEDxTOxLIST) {
                    gtk_licq_button_set(GTK_BUTTON(event_1_button),
                            GTK_LICQ_BUTTON_ADDUSER);
                    gtk_widget_hide(event_2_button);
                    gtk_widget_hide(event_3_button);
                    gtk_widget_hide(event_4_button);
                    gtk_notebook_set_page(GTK_NOTEBOOK(type_notebook),0);
                }
                uin=((CEventAdded*)e)->Uin();
                if(!uin||gUserManager.FetchUser(uin,LOCK_N)) {
                    gtk_widget_set_sensitive(event_1_button,FALSE);
                }
                windowdata->button1_handler = gtk_signal_connect(
                        GTK_OBJECT(event_1_button), 
                        "clicked", 
                        GTK_SIGNAL_FUNC(on_adduser_button_clicked),
                        NULL);
                gtk_text_freeze(GTK_TEXT(message_textbox));
                gtk_editable_delete_text(GTK_EDITABLE(message_textbox),0,-1);
                gtk_text_insert(GTK_TEXT(message_textbox),NULL,NULL,NULL,
                        e->Text(), strlen(e->Text()));
                gtk_text_set_point(GTK_TEXT(message_textbox),0);
                gtk_text_thaw(GTK_TEXT(message_textbox));
                break;
            case ICQ_CMDxSUB_CONTACTxLIST:
                if (last_message_type!=ICQ_CMDxSUB_CONTACTxLIST) {
                    gtk_licq_button_set(GTK_BUTTON(event_1_button),
                            GTK_LICQ_BUTTON_REPLY);
                    gtk_licq_button_set(GTK_BUTTON(event_2_button),
                            GTK_LICQ_BUTTON_ADDUSER);
                    gtk_licq_button_set(GTK_BUTTON(event_3_button),
                            GTK_LICQ_BUTTON_FORWARD);
//                    gtk_widget_hide(event_3_button);
                    gtk_widget_hide(event_4_button);
                    gtk_widget_set_sensitive(event_2_button,FALSE);
                    gtk_notebook_set_page(GTK_NOTEBOOK(type_notebook),2);
                }
                windowdata->button1_handler = gtk_signal_connect_after(
                        GTK_OBJECT(event_1_button), 
                        "clicked", 
                        GTK_SIGNAL_FUNC(on_quote_button_clicked),
                        GINT_TO_POINTER(FALSE));
                windowdata->button2_handler = gtk_signal_connect(
                        GTK_OBJECT(event_2_button), 
                        "clicked", 
                        GTK_SIGNAL_FUNC(on_contactadduser_button_clicked),
                        NULL);
                windowdata->button3_handler = gtk_signal_connect_after(
                        GTK_OBJECT(event_3_button), 
                        "clicked", 
                        GTK_SIGNAL_FUNC(on_forward_button_clicked),
                        NULL);
                gtk_clist_freeze(GTK_CLIST(contacts_clist));
                gtk_clist_clear(GTK_CLIST(contacts_clist));
                textcpy=g_strdup_printf("%s\n",e->Text());
                thisln=textcpy;
                addptr[2]=NULL;
                while((nextln=strchr(thisln,'\n'))) {
                    *nextln='\0';
                    if((*(nextln-1)==')')&&(addptr[0]=strrchr(thisln,'('))) {
                        *(addptr[0]-1)='\0';
                        addptr[0]+=1;
                        *(nextln-1)='\0';
                        addptr[1]=thisln;
                        gtk_clist_append(GTK_CLIST(contacts_clist),addptr);
                    }
                    thisln=nextln+1;
                }
                gtk_clist_thaw(GTK_CLIST(contacts_clist));
                g_free(textcpy);
                break;
            case ICQ_CMDxSUB_URL:
                if (last_message_type!=ICQ_CMDxSUB_URL) {
                    gtk_licq_button_set(GTK_BUTTON(event_1_button),
                            GTK_LICQ_BUTTON_REPLY);
                    gtk_licq_button_set(GTK_BUTTON(event_2_button),
                            GTK_LICQ_BUTTON_QUOTEREPLY);
                    gtk_licq_button_set(GTK_BUTTON(event_3_button),
                            GTK_LICQ_BUTTON_FORWARD);
                    gtk_widget_hide(event_4_button);
                    gtk_notebook_set_page(GTK_NOTEBOOK(type_notebook),1);
                    gtk_licq_button_set(GTK_BUTTON(url_button),
                            GTK_LICQ_BUTTON_HOMEPAGE);
                }
                windowdata->button1_handler=gtk_signal_connect_after(
                        GTK_OBJECT(event_1_button), 
                        "clicked", 
                        GTK_SIGNAL_FUNC(on_quote_button_clicked),
                        GINT_TO_POINTER(FALSE));
                windowdata->button2_handler = gtk_signal_connect_after(
                        GTK_OBJECT(event_2_button), 
                        "clicked", 
                        GTK_SIGNAL_FUNC(on_quote_button_clicked),
                        GINT_TO_POINTER(TRUE));
                windowdata->button3_handler = gtk_signal_connect_after(
                        GTK_OBJECT(event_3_button), 
                        "clicked", 
                        GTK_SIGNAL_FUNC(on_forward_button_clicked),
                        NULL);
                windowdata->viewurl_handler=gtk_signal_connect(
                        GTK_OBJECT (url_button), "clicked",
                        GTK_SIGNAL_FUNC (on_url_button_clicked),
                        e);
                gtk_text_freeze(GTK_TEXT(description_textbox));
                gtk_editable_delete_text(GTK_EDITABLE(description_textbox),0,-1);
                gtk_text_insert(GTK_TEXT(description_textbox),NULL,NULL,NULL,
                        ((CEventUrl *)e)->Description(),
                        strlen(((CEventUrl *)e)->Description()));
                gtk_text_set_point(GTK_TEXT(description_textbox),0);
                gtk_text_thaw(GTK_TEXT(description_textbox));

                gtk_entry_set_text(GTK_ENTRY(url_entry),((CEventUrl *)e)->Url());
                apply_message_colors(gtk_widget_get_toplevel(GTK_WIDGET(clist)),
                            e);
                break;
            case ICQ_CMDxSUB_CHAT:
                if (last_message_type!=ICQ_CMDxSUB_CHAT) {
                    gtk_licq_button_set(GTK_BUTTON(event_1_button),
                            GTK_LICQ_BUTTON_ACCEPT);
                    gtk_licq_button_set(GTK_BUTTON(event_2_button),
                            GTK_LICQ_BUTTON_REFUSE);
                    gtk_widget_hide(event_3_button);
                    gtk_widget_hide(event_4_button);
                    gtk_notebook_set_page(GTK_NOTEBOOK(type_notebook),0);
                }
                windowdata->button1_handler=gtk_signal_connect(
                        GTK_OBJECT (event_1_button),
                        "clicked", 
                        GTK_SIGNAL_FUNC (on_chat_accept_button_clicked), e);
                windowdata->button2_handler = gtk_signal_connect(
                        GTK_OBJECT(event_2_button), 
                        "clicked", 
                        GTK_SIGNAL_FUNC (on_chat_refuse_button_clicked), 
                        e->Copy());

                gtk_text_freeze(GTK_TEXT(message_textbox));
                gtk_editable_delete_text(GTK_EDITABLE(message_textbox),0,-1);
                gtk_text_insert(GTK_TEXT(message_textbox),NULL,NULL,NULL,
                        e->Text(), strlen(e->Text()));
                gtk_text_set_point(GTK_TEXT(message_textbox),0);
                gtk_text_thaw(GTK_TEXT(message_textbox));
                break;
            case ICQ_CMDxSUB_FILE:
                if (last_message_type!=ICQ_CMDxSUB_FILE) {
                    gtk_label_set_text(GTK_LABEL(url_label),_("File dir: "));
                    gtk_licq_button_set(GTK_BUTTON(event_1_button),
                            GTK_LICQ_BUTTON_ACCEPT);
                    gtk_licq_button_set(GTK_BUTTON(event_2_button),
                            GTK_LICQ_BUTTON_REFUSE);
                    gtk_widget_hide(event_3_button);
                    gtk_widget_hide(event_4_button);
                    gtk_licq_button_set(GTK_BUTTON(url_button),
                            GTK_LICQ_BUTTON_BROWSE);
                    gtk_notebook_set_page(GTK_NOTEBOOK(type_notebook),1);
                }
                windowdata->viewurl_handler=gtk_signal_connect(
                        GTK_OBJECT (url_button), "clicked",
                        GTK_SIGNAL_FUNC (on_browse_clicked), NULL);
                windowdata->button1_handler=gtk_signal_connect(
                        GTK_OBJECT (event_1_button), "clicked",
                        GTK_SIGNAL_FUNC (on_file_button_clicked),
                        e);
                windowdata->button2_handler = gtk_signal_connect(
                        GTK_OBJECT(event_2_button), 
                        "clicked", 
                        GTK_SIGNAL_FUNC (on_refuse_file_button_clicked), 
                        e->Copy());
                    

                gtk_text_freeze(GTK_TEXT(description_textbox));
                gtk_editable_delete_text(GTK_EDITABLE(description_textbox),0,-1);
                gtk_text_insert(GTK_TEXT(description_textbox),NULL,NULL,NULL,
                        e->Text(), strlen(e->Text()));
                gtk_text_set_point(GTK_TEXT(description_textbox),0);
                gtk_text_thaw(GTK_TEXT(description_textbox));
                gtk_entry_set_editable(GTK_ENTRY(url_entry),TRUE);
                gtk_entry_set_text(GTK_ENTRY(url_entry),
                        configuration.file_dir);
                break;
            default:
                gtk_widget_hide(event_1_button);
                gtk_widget_hide(event_2_button);
                gtk_widget_hide(event_3_button);
                gtk_widget_hide(event_4_button);
                gtk_text_freeze(GTK_TEXT(message_textbox));
                gtk_editable_delete_text(GTK_EDITABLE(message_textbox),0,-1);
                gtk_text_insert(GTK_TEXT(message_textbox),NULL,NULL,NULL,
                        e->Text(), strlen(e->Text()));
                gtk_text_set_point(GTK_TEXT(message_textbox),0);
                gtk_text_thaw(GTK_TEXT(message_textbox));
                gtk_notebook_set_page(GTK_NOTEBOOK(type_notebook),0);
                break;
        }
        gtk_object_set_data (GTK_OBJECT(gtk_widget_get_toplevel(event_1_button)), "last_message_type", GINT_TO_POINTER(e->SubCommand()));
    }
}

GtkWidget *
show_view_event_window_for_user        (unsigned long   uin)
{
    GtkWidget       *view_event_window, *message_clist;
    GtkWidget       *event_1_button;
    GtkWidget       *event_2_button;
    GtkWidget       *event_3_button;
    GtkWidget       *event_4_button;
    
    gchar           *title;
    ICQUser         *user=NULL;
    userdata_t      *udata;
    CUserEvent      *event;
    int             i;
    vieweventwindowdata_t   *windowdata;

    udata=find_user_data(uin,NULL);
    if (udata == NULL) {
        gbug("No user data\n");
        return(NULL);
    }
    
    if(!udata->view_event_window) {
        view_event_window=create_view_event_window();
        message_clist=lookup_widget(view_event_window,"message_clist");
        udata->view_event_window=view_event_window;
        gtk_widget_set_active_uin(view_event_window,uin);
        windowdata=(vieweventwindowdata_t*)malloc(sizeof(vieweventwindowdata_t));
        if(!windowdata) {
            gtk_widget_destroy(view_event_window);
            showokdialog(_("View event window"),
                    _("Cannot show view event window, probably out of memory"));
            return NULL;
        }
        memset(windowdata,0,sizeof(vieweventwindowdata_t));
        gtk_object_set_data_full(GTK_OBJECT(view_event_window),"windowdata",
                (gpointer)windowdata,destroy_notify_free);

        if(uin==gUserManager.OwnerUin()||!uin) {
            user=gUserManager.FetchOwner(LOCK_W);
            gtk_window_set_title(GTK_WINDOW(view_event_window),_("System events")); 
        }else {
            user=gUserManager.FetchUser(uin,LOCK_W);
            title=g_strdup_printf(_("Events for %s"),user->GetAlias());
            gtk_window_set_title(GTK_WINDOW(view_event_window),title);
            g_free(title);
        }
        if (user->NewUser())  {
            user->SetNewUser(FALSE);  
        } 

        if (user->NewMessages()>0) {
            for(i=0;i<user->NewMessages();i++) {
                event=user->EventPeek(i);
                append_event_to_eventlist(event,view_event_window);
            }
        } else {
                event_1_button=lookup_widget(GTK_WIDGET(view_event_window), 
                        "event_1_button");
                event_2_button=lookup_widget(GTK_WIDGET(view_event_window), 
                        "event_2_button");
                event_3_button=lookup_widget(GTK_WIDGET(view_event_window), 
                        "event_3_button");
                event_4_button=lookup_widget(GTK_WIDGET(view_event_window), 
                        "event_4_button");
                gtk_widget_hide(event_1_button);
                gtk_widget_hide(event_2_button);
                gtk_widget_hide(event_3_button);
                gtk_widget_hide(event_4_button);
        }

        gUserManager.DropUser(user);
        if (GTK_CLIST(message_clist)->rows) {
            if(!GTK_CLIST(message_clist)->selection) {
                gtk_clist_select_row(GTK_CLIST(message_clist),0,-1);
            }
            gtk_signal_emit_by_name(GTK_OBJECT(message_clist),
                    "select_row",
                    GPOINTER_TO_INT(
                        GTK_CLIST(message_clist)->selection->data),
                    -1, NULL);
        }
        setup_statusbar(view_event_window);
    }else {
        view_event_window=udata->view_event_window;
        gdk_window_raise(view_event_window->window);
    }

    gtk_widget_show(view_event_window);

    return view_event_window;
}


bool 
view_event_window_signal_handler       (CICQSignal  *signal, 
                                        gpointer    view_event_window)
{
    ICQUser         *user = NULL;
    GtkWidget       *message_clist = lookup_widget(GTK_WIDGET(view_event_window),
            "message_clist");
    GtkWidget       *status_pixmap=lookup_widget(GTK_WIDGET(view_event_window),
            "status_pixmap");
    GdkPixMask_t    *usericon;
    unsigned long   uin=gtk_widget_get_active_uin(GTK_WIDGET(view_event_window));
    CUserEvent      *msg,*e;
    gint            row;
    GList           *rows;

    gbug("view_event_window_signal_handler: enter\n");
    if(signal&&signal->Uin()==uin&&signal->Signal()==SIGNAL_UPDATExUSER) { 
        switch(signal->SubSignal()) {
            case USER_EVENTS:
                if(signal->Argument()>0) {
                    user = (uin>0)?gUserManager.FetchUser(uin,LOCK_R):
                        gUserManager.FetchOwner(LOCK_R);
                    if (user->NewMessages()){
                        msg = user->EventPeek(user->NewMessages()-1);
                        append_event_to_eventlist(msg, 
                                GTK_WIDGET(view_event_window));
                    } 
                    gUserManager.DropUser(user);
                }else if (signal->Argument()<0) {
                    rows=GTK_CLIST(message_clist)->row_list;
                    while(rows) {
                        if(rows->data&&(e=(CUserEvent*)((GtkCListRow*)(rows->data))->data)) {
                            if(e->Pending()&&e->Id()==-signal->Argument()) {
                                gbug("view_event_window_signal_handler: Removed pending event\n");
                                e->SetPending(FALSE);
                                break;
                            } 
                        }
                        rows=g_list_next(rows);
                    }
                }
                break;
            case USER_STATUS:
                user = (uin>0)?gUserManager.FetchUser(uin,LOCK_R):
                    gUserManager.FetchOwner(LOCK_R);
                usericon=getuserstatusicon(user,FALSE);
                gUserManager.DropUser(user);
                gtk_pixmap_set(GTK_PIXMAP(status_pixmap),usericon->pix,
                        usericon->mask);
                break;
        }
    }
    return FALSE;
}


void
shutdown_view_event_window             (GtkWidget       *event_window)
{
    unsigned long   uin=gtk_widget_get_active_uin(event_window);
    userdata_t      *userdata;
    ICQUser         *user;
    
    
    userdata=find_user_data(uin,NULL);

    if (userdata) {
        gbug("shutdown_view_event_window: found %ld and removing window\n", uin);
        userdata->view_event_window=NULL;
    }
    shutdown_statusbar(event_window);
    unregister_signalcallback(view_event_window_signal_handler,event_window);
    gtk_widget_destroy(event_window);

    if(configuration.autopopupmessages) {
        user=(!uin?gUserManager.FetchOwner(LOCK_R):gUserManager.FetchUser(uin,
                    LOCK_R));
        if(user) {
            if(user->NewMessages()) {
                gUserManager.DropUser(user);
                show_view_event_window_for_user(uin);
            } else {
                gUserManager.DropUser(user);
            }
        }
    }
}

void
on_view_event_window_show              (GtkWidget       *widget,
                                        gpointer         user_data)
{
    GtkWidget       *message_clist=lookup_widget(widget,
            "message_clist");
    GtkWidget       *message_textbox=lookup_widget(widget,
            "message_textbox");
    GtkWidget       *description_textbox=lookup_widget(widget,
            "description_textbox");
    GtkWidget       *contacts_clist=lookup_widget(widget,
            "contacts_clist");
    GtkStyle        *style;
    GdkFont         *font;
    ICQUser         *user;


    gtk_clist_set_column_width(GTK_CLIST(message_clist),0,FIRST_COLUMN_WIDTH);
    gtk_clist_set_column_auto_resize(GTK_CLIST(message_clist),1,TRUE);
    gtk_clist_set_column_auto_resize(GTK_CLIST(message_clist),2,TRUE);
    gtk_clist_set_column_auto_resize(GTK_CLIST(message_clist),3,TRUE);
    gtk_clist_set_column_justification(GTK_CLIST(message_clist),1,
            GTK_JUSTIFY_LEFT);
    gtk_clist_set_column_justification(GTK_CLIST(message_clist),2,
            GTK_JUSTIFY_LEFT);
    gtk_clist_set_column_justification(GTK_CLIST(message_clist),3,
            GTK_JUSTIFY_LEFT);


    gtk_widget_ensure_style(message_textbox);
    if (global_editor_font) {
        gtk_widget_ensure_style(message_textbox);
        style = gtk_style_copy(gtk_widget_get_style(message_textbox));
        gdk_font_unref(style->font);
        style->font = global_editor_font;
        gtk_widget_set_style(GTK_WIDGET(message_textbox),style);
        
        gtk_widget_ensure_style(description_textbox);
        style = gtk_style_copy(gtk_widget_get_style(
                    GTK_WIDGET(description_textbox)));
        gdk_font_unref(style->font);
        style->font = global_editor_font;
        gtk_widget_set_style(GTK_WIDGET(description_textbox),style);
    }
    if(*configuration.contactfont) {
        if((font=gdk_font_load(configuration.contactfont))) {
            gtk_widget_ensure_style(contacts_clist);
            style = gtk_style_copy(gtk_widget_get_style(
                        GTK_WIDGET(contacts_clist)));
            gdk_font_unref(style->font);
            style->font=font;
            gdk_font_ref(style->font);
            gtk_widget_set_style(contacts_clist,style);
        }
    }

    style=gtk_widget_get_style(GTK_WIDGET(message_textbox));
    /*gtk_object_set_data_full(GTK_OBJECT(widget),"initial_foreground_color",
            &style->base[GTK_STATE_NORMAL],(GtkDestroyNotify)gtk_style_unref);
    gtk_object_set_data_full(GTK_OBJECT(widget),"initial_background_color",
            &style->base[GTK_STATE_NORMAL],(GtkDestroyNotify)gtk_style_unref);*/
        
    gtk_object_set_data(GTK_OBJECT(widget),"initial_foreground_color",
            &style->text[GTK_STATE_NORMAL]);
    gtk_object_set_data(GTK_OBJECT(widget),"initial_background_color",
            &style->base[GTK_STATE_NORMAL]);
        
    register_signalcallback(view_event_window_signal_handler,widget);
}

bool 
event_window_statusbar_signal_handler   (CICQSignal *signal, 
                                         gpointer view_event_window)
{
    ICQUser         *user = NULL;
    GtkWidget       *status_pixmap=lookup_widget(GTK_WIDGET(view_event_window),
            "status_pixmap");
    GdkPixMask_t    *usericon;
    unsigned long   uin=gtk_widget_get_active_uin(GTK_WIDGET(view_event_window));

    gbug("*_event_window_signal_handler: enter\n");
    if(signal&&signal->Uin()==uin&&signal->Signal()==SIGNAL_UPDATExUSER) { 
        switch(signal->SubSignal()) {
            case USER_STATUS:
                user = (uin>0)?gUserManager.FetchUser(uin,LOCK_R):
                    gUserManager.FetchOwner(LOCK_R);
                usericon=getuserstatusicon(user,FALSE);
                gUserManager.DropUser(user);
                gtk_pixmap_set(GTK_PIXMAP(status_pixmap),usericon->pix,
                        usericon->mask);
                break;
        }
    }
    return FALSE;
}

void
setup_statusbar     (GtkWidget  *toplevel)
{
    GtkWidget       *status_usermenu_button=lookup_widget(toplevel,
            "status_usermenu_button");
    GtkWidget       *status_message_button=lookup_widget(toplevel,
            "status_message_button");
    GtkWidget       *status_url_button=lookup_widget(toplevel,
            "status_url_button");
    GtkWidget       *status_file_button=lookup_widget(toplevel,
            "status_file_button");
    GtkWidget       *status_chat_button=lookup_widget(toplevel,
            "status_chat_button");
    GtkWidget       *status_contacts_button=lookup_widget(toplevel,
            "status_contacts_button");
    GtkWidget       *status_secure_button=lookup_widget(toplevel,
            "status_secure_button");
    GtkWidget       *status_username_label=lookup_widget(toplevel,
            "status_username_label");
    GtkWidget       *status_autoclose_checkbutton=lookup_widget(toplevel,
            "status_autoclose_checkbutton");
    GtkWidget       *status_info_button=lookup_widget(toplevel,
            "status_info_button");
    GtkWidget       *status_history_button=lookup_widget(toplevel,
            "status_history_button");
    GtkWidget       *status_close_button=lookup_widget(toplevel,
            "status_close_button");
    GtkWidget       *container, *pixmap;
    GtkStyle        *style;
    GdkPixMask_t    *usericon;
    ICQUser         *user;
    GtkTooltips     *tips;
    unsigned long   uin;

    uin=gtk_widget_get_active_uin(toplevel);
    user=gUserManager.FetchUser(uin,LOCK_R);

    container=gtk_hbox_new(FALSE,0);
    gtk_widget_ref(container);
    pixmap=gtk_pixmap_new(arrow_pixmap.pix,arrow_pixmap.mask);
    gtk_widget_ref(pixmap);
    gtk_object_set_data_full (GTK_OBJECT (toplevel), "arrow_pixmap", pixmap,
            (GtkDestroyNotify) gtk_widget_unref);
    gtk_box_pack_end(GTK_BOX(container),pixmap,FALSE,TRUE,0);
    usericon=getuserstatusicon(user,FALSE);
    pixmap=gtk_pixmap_new(usericon->pix,usericon->mask);
    gtk_widget_ref(pixmap);
    gtk_object_set_data_full (GTK_OBJECT (toplevel), "status_pixmap", pixmap,
            (GtkDestroyNotify) gtk_widget_unref);
    gtk_box_pack_start(GTK_BOX(container),pixmap,FALSE,TRUE,0);
    gtk_widget_show_all(container);
    gtk_container_add(GTK_CONTAINER(status_usermenu_button),container);

    pixmap=gtk_pixmap_new(status_pixmap_chat.pix,status_pixmap_chat.mask);
    gtk_widget_ref(pixmap);
    gtk_container_add(GTK_CONTAINER(status_chat_button),pixmap);
    gtk_widget_show(pixmap);
    gtk_object_set_data_full (GTK_OBJECT (toplevel), "chat_pixmap", pixmap,
            (GtkDestroyNotify) gtk_widget_unref);
    pixmap=gtk_pixmap_new(status_pixmap_message.pix,status_pixmap_message.mask);
    gtk_widget_ref(pixmap);
    gtk_container_add(GTK_CONTAINER(status_message_button),pixmap);
    gtk_widget_show(pixmap);
    gtk_object_set_data_full (GTK_OBJECT (toplevel), "message_pixmap", pixmap,
            (GtkDestroyNotify) gtk_widget_unref);
    pixmap=gtk_pixmap_new(status_pixmap_url.pix,status_pixmap_url.mask);
    gtk_widget_ref(pixmap);
    gtk_container_add(GTK_CONTAINER(status_url_button),pixmap);
    gtk_widget_show(pixmap);
    gtk_object_set_data_full (GTK_OBJECT (toplevel), "url_pixmap", pixmap,
            (GtkDestroyNotify) gtk_widget_unref);
    pixmap=gtk_pixmap_new(status_pixmap_contacts.pix,status_pixmap_contacts.mask);
    gtk_widget_ref(pixmap);
    gtk_container_add(GTK_CONTAINER(status_contacts_button),pixmap);
    gtk_widget_show(pixmap);
    gtk_object_set_data_full (GTK_OBJECT (toplevel), "contacts_pixmap", pixmap,
            (GtkDestroyNotify) gtk_widget_unref);
    pixmap=gtk_pixmap_new(status_pixmap_file.pix,status_pixmap_file.mask);
    gtk_widget_ref(pixmap);
    gtk_container_add(GTK_CONTAINER(status_file_button),pixmap);
    gtk_widget_show(pixmap);
    gtk_object_set_data_full (GTK_OBJECT (toplevel), "file_pixmap", pixmap,
            (GtkDestroyNotify) gtk_widget_unref);

    if(user->Secure() && user->SendServer()) {
        pixmap=gtk_pixmap_new(not_secure_on_pixmap.pix,
                not_secure_on_pixmap.mask);
    } else if(user->Secure() && !user->SendServer()) {
        pixmap=gtk_pixmap_new(secure_on_pixmap.pix,secure_on_pixmap.mask);
    }else {
        pixmap=gtk_pixmap_new(secure_off_pixmap.pix,secure_off_pixmap.mask);
    }
    gtk_widget_ref(pixmap);
    if (GTK_BIN(status_secure_button)->child != NULL) {
        gtk_container_remove(GTK_CONTAINER(status_secure_button),
                GTK_BIN(status_secure_button)->child);
    }
    gtk_container_add(GTK_CONTAINER(status_secure_button),pixmap);
    gtk_widget_show(pixmap);
    
    if(user->SecureChannelSupport()==SECURE_CHANNEL_SUPPORTED ) {
        gtk_widget_set_sensitive(status_secure_button,TRUE);
    } else {
        gtk_widget_set_sensitive(status_secure_button,FALSE);
    }
    
    gtk_object_set_data_full (GTK_OBJECT (toplevel), "security_pixmap", pixmap,
            (GtkDestroyNotify) gtk_widget_unref);
    
    register_signalcallback(secure_signal_callback,
            (gpointer) status_secure_button);

    pixmap=gtk_pixmap_new(close_pixmap.pix,close_pixmap.mask);
    gtk_widget_ref(pixmap);
    gtk_container_add(GTK_CONTAINER(status_close_button),pixmap);
    gtk_widget_show(pixmap);
    gtk_object_set_data_full (GTK_OBJECT (toplevel), "close_pixmap", pixmap,
            (GtkDestroyNotify) gtk_widget_unref);
    pixmap=gtk_pixmap_new(info_pixmap.pix,info_pixmap.mask);
    gtk_widget_ref(pixmap);
    gtk_container_add(GTK_CONTAINER(status_info_button),pixmap);
    gtk_widget_show(pixmap);
    gtk_object_set_data_full (GTK_OBJECT (toplevel), "info_pixmap", pixmap,
            (GtkDestroyNotify) gtk_widget_unref);
    pixmap=gtk_pixmap_new(history_pixmap.pix,history_pixmap.mask);
    gtk_widget_ref(pixmap);
    gtk_container_add(GTK_CONTAINER(status_history_button),pixmap);
    gtk_widget_show(pixmap);
    gtk_object_set_data_full (GTK_OBJECT (toplevel), "history_pixmap", pixmap,
            (GtkDestroyNotify) gtk_widget_unref);

    gtk_label_set_text(GTK_LABEL(status_username_label),user->GetAlias());
    
    /* Autosecure */
    if ((!user->Secure()) && (user->AutoSecure()) &&
            (user->SecureChannelSupport() == SECURE_CHANNEL_SUPPORTED)) {
        gUserManager.DropUser(user);
        licq_daemon->icqOpenSecureChannel(uin);
    } else {
        gUserManager.DropUser(user);
    }

    register_signalcallback(event_window_statusbar_signal_handler,toplevel);

    GtkAccelGroup *acc = gtk_accel_group_new();
    gtk_accel_group_add(acc,GDK_m,GDK_CONTROL_MASK,GTK_ACCEL_VISIBLE,
            GTK_OBJECT(status_message_button),
            "clicked");
    gtk_accel_group_add(acc,GDK_u,GDK_CONTROL_MASK,GTK_ACCEL_VISIBLE,
            GTK_OBJECT(status_url_button),
            "clicked");
    //Suboptimal
    gtk_accel_group_add(acc,GDK_t,GDK_CONTROL_MASK,GTK_ACCEL_VISIBLE,
            GTK_OBJECT(status_chat_button),
            "clicked");
    gtk_accel_group_add(acc,GDK_f,GDK_CONTROL_MASK,GTK_ACCEL_VISIBLE,
            GTK_OBJECT(status_file_button),
            "clicked");
    //Suboptimal
    gtk_accel_group_add(acc,GDK_p,GDK_CONTROL_MASK,GTK_ACCEL_VISIBLE,
            GTK_OBJECT(status_contacts_button),
            "clicked");
    gtk_accel_group_add(acc,GDK_a,GDK_CONTROL_MASK,GTK_ACCEL_VISIBLE,
            GTK_OBJECT(status_autoclose_checkbutton),
            "clicked");
    gtk_accel_group_add(acc,GDK_r,GDK_CONTROL_MASK,GTK_ACCEL_VISIBLE,
            GTK_OBJECT(status_secure_button),
            "clicked");
    gtk_accel_group_add(acc,GDK_d,GDK_CONTROL_MASK,GTK_ACCEL_VISIBLE,
            GTK_OBJECT(status_usermenu_button),
            "clicked");
    gtk_window_add_accel_group(GTK_WINDOW(toplevel),acc); 

    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(status_autoclose_checkbutton),
            TRUE);

    tips=gtk_tooltips_new();
    gtk_tooltips_set_tip(GTK_TOOLTIPS(tips),status_usermenu_button,
            _("Popup usermenu"),NULL);
    gtk_tooltips_set_tip(GTK_TOOLTIPS(tips),status_message_button,
            _("Send message"),NULL);
    gtk_tooltips_set_tip(GTK_TOOLTIPS(tips),status_url_button,
            _("Send URL"),NULL);
    gtk_tooltips_set_tip(GTK_TOOLTIPS(tips),status_file_button,
            _("Send File"),NULL);
    gtk_tooltips_set_tip(GTK_TOOLTIPS(tips),status_chat_button,
            _("Send chat request"),NULL);
    gtk_tooltips_set_tip(GTK_TOOLTIPS(tips),status_contacts_button,
            _("Send contacts"),NULL);
    gtk_tooltips_set_tip(GTK_TOOLTIPS(tips),status_secure_button,
            _("Toggle secure connection"),NULL);
    gtk_tooltips_set_tip(GTK_TOOLTIPS(tips),status_info_button,
            _("View user info"),NULL);
    gtk_tooltips_set_tip(GTK_TOOLTIPS(tips),status_history_button,
            _("View user history"),NULL);
    gtk_tooltips_set_tip(GTK_TOOLTIPS(tips),status_close_button,
            _("Close"),NULL);
   // gtk_object_set_data_full(GTK_OBJECT(toplevel),"statusbar_tips",tips,
   //         (GtkDestroyNotify) gtk_widget_unref);
}


void
shutdown_statusbar  (GtkWidget  *toplevel)
{   
    GtkWidget   *status_secure_button = lookup_widget(toplevel,
            "status_secure_button");
    unregister_signalcallback(event_window_statusbar_signal_handler,toplevel);
    unregister_signalcallback(secure_signal_callback,
            (gpointer) status_secure_button);
}


void
on_status_info_button_clicked          (GtkButton       *button,
                                        gpointer         user_data)
{
    unsigned long uin=gtk_widget_get_active_uin(GTK_WIDGET(button));

    show_info_dialog_for_user(uin,GENERAL_INFO_PAGE);
}


void
on_status_history_button_clicked       (GtkButton       *button,
                                        gpointer         user_data)
{
    unsigned long uin=gtk_widget_get_active_uin(GTK_WIDGET(button));

    show_history_dialog_for_user(uin);
}

void
apply_message_colors                   (GtkWidget           *toplevel,
                                        CUserEvent          *e)
{

    GdkColor        bcol,fcol,*tcol;
    CICQColor       *ec;
    GtkWidget       *textbox=NULL;

    if(configuration.ignoremsgcolors) {
        return ;
    }
        
    if(!e||(e->SubCommand()!=ICQ_CMDxSUB_MSG&&e->SubCommand()!=ICQ_CMDxSUB_URL)) {
        return ;
    }
    
    switch(e->SubCommand()) {
        case ICQ_CMDxSUB_MSG:
            textbox=lookup_widget(toplevel,"message_textbox");
            break;
        case ICQ_CMDxSUB_URL:
            textbox=lookup_widget(toplevel,"description_textbox");
            break;
    }
    
    if(!(ec=e->Color())) {
        memset(&bcol,0,sizeof(GdkColor));
        memset(&fcol,0,sizeof(GdkColor));
        if((tcol=(GdkColor*)gtk_object_get_data(GTK_OBJECT(toplevel),
                "initial_background_color"))) {
            bcol=*tcol;
        }
        if((tcol=(GdkColor*)gtk_object_get_data(GTK_OBJECT(toplevel),
                "initial_foreground_color"))) {
            fcol=*tcol;
        }
    }else {
        gbug("ORG: (%ld, %ld, %ld)\n",ec->BackRed(),ec->BackGreen(),ec->BackBlue());
        ICQBACK_TO_GDK_COLOR(ec,bcol);
        ICQFORE_TO_GDK_COLOR(ec,fcol);
    }

    gtk_widget_set_color(textbox,TRUE,TRUE,bcol.red,bcol.green,bcol.blue,
            fcol.red,fcol.green,fcol.blue);
}

void
check_for_autoclose_after_sysevent     (GtkWidget   *toplevel)
{
    unsigned long       uin;
    userdata_t          *udata;
    GtkWidget           *status_autoclose_checkbutton;
    ICQOwner            *o;

    if(gtk_object_get_data(GTK_OBJECT(toplevel),"view_triggered")) {
        uin=gtk_widget_get_active_uin(toplevel);
        if((udata=find_user_data(uin,NULL))&&udata->view_event_window) {
            status_autoclose_checkbutton=lookup_widget(udata->view_event_window,
                    "status_autoclose_checkbutton");
            o=gUserManager.FetchOwner(LOCK_R);
            if(gtk_toggle_button_get_active(
                        GTK_TOGGLE_BUTTON(status_autoclose_checkbutton))) {
                gUserManager.DropOwner();
                shutdown_view_event_window(udata->view_event_window);
            }else {
                gUserManager.DropOwner();
            }
        }
    }
}
