mkdir h4toh5testdir

echo off
echo    h4toh5 converter tool testing command on windows 
echo    should include two parameters and  
echo    should be input as the following format:
echo    	h4toh5testrun para1 para2 
echo 		********** WARNINGS: **********
echo If parameters for testing are input incorrectly,
echo    testing results will not reflect the status of 
echo    the tool.
echo    Parameter 1 is the version of h4toh5test(Debug or Release)
echo 		the current version is 
echo                   %1
echo    parameter 2 is either dll or empty 
echo 	  non-dll version will not print anything on the next line
echo on
echo %2
echo off

echo    I. For h4toh5 test option I(non-hdf5 file name)
echo    using %1 version
cd h4toh5%2\%1
echo  	--------------STEP ONE----------------
echo 	copy original test files into the current directory
echo on
copy ..\..\testfiles\*.hdf . 
echo off 
echo --------------STEP TWO-------------------

echo 	doing h4toh5 conversion(h5 file will be created) 
echo on
echo
h4toh5%2 vg_all_test.hdf 
h4toh5%2 vg_hl_test.hdf
h4toh5%2 vg_loop_test.hdf
h4toh5%2 vgnameclash_test.hdf
h4toh5%2 vdnameclash_test.hdf
h4toh5%2 vdata_test.hdf
h4toh5%2 sdsnameclash_test.hdf
h4toh5%2 sds_typ_test.hdf
h4toh5%2 sds_dim_test.hdf
h4toh5%2 sds_attr_test.hdf
h4toh5%2 ras_8_test.hdf
h4toh5%2 ras_24_test.hdf
h4toh5%2 image_attr_test.hdf
h4toh5%2 grnameclash_test.hdf
h4toh5%2 gr_typ_test.hdf
h4toh5%2 anno_test.hdf

echo off
echo   copying converted hdf5 files into the directory where "h5dump" is located
echo on
echo
copy *.h5 ..\..\h5dump\Release

echo off
echo   Deleting the converted hdf5 file under the current directory 
echo on
del *.h5

echo off
echo   go to the path where h5dump is located:
cd ..\..\h5dump\Release

echo ------------STEP THREE-------------
echo   now using h5dump to dump the converted h5 files

echo on
echo
h5dump  vg_all_test.h5 >..\..\h4toh5testdir\vg_all_test.results
h5dump  vg_hl_test.h5 >..\..\h4toh5testdir\vg_hl_test.results
h5dump  vg_loop_test.h5 >..\..\h4toh5testdir\vg_loop_test.results
h5dump  vgnameclash_test.h5 >..\..\h4toh5testdir\vgnameclash_test.results
h5dump  anno_test.h5 >..\..\h4toh5testdir\anno_test.results
h5dump  gr_typ_test.h5 >..\..\h4toh5testdir\gr_typ_test.results
h5dump  grnameclash_test.h5 >..\..\h4toh5testdir\grnameclash_test.results
h5dump  image_attr_test.h5 >..\..\h4toh5testdir\image_attr_test.results
h5dump  ras_24_test.h5 >..\..\h4toh5testdir\ras_24_test.results
h5dump  ras_8_test.h5 >..\..\h4toh5testdir\ras_8_test.results
h5dump  sds_attr_test.h5 >..\..\h4toh5testdir\sds_attr_test.results
h5dump  sds_dim_test.h5 >..\..\h4toh5testdir\sds_dim_test.results
h5dump  sds_typ_test.h5 >..\..\h4toh5testdir\sds_typ_test.results
h5dump  sdsnameclash_test.h5 >..\..\h4toh5testdir\sdsnameclash_test.results
h5dump  vdata_test.h5 >..\..\h4toh5testdir\vdata_test.results
h5dump  vdnameclash_test.h5 >..\..\h4toh5testdir\vdnameclash_test.results

echo off
echo    now deleting the converted h5 files under h5dump directory 
del *.h5
echo ------------STEP FOUR-------------------
echo copying the expected hdf5 file into the directory where dumper is located.

echo on
copy ..\..\testfiles\Expected\*.h5 .

echo off
echo ----------STEP FIVE-----------------
echo using h5dump to generate output from expected hdf5 files
echo on

h5dump  vg_all_test.h5 >..\..\h4toh5testdir\vg_all_test.expected
h5dump  vg_hl_test.h5 >..\..\h4toh5testdir\vg_hl_test.expected
h5dump  vg_loop_test.h5 >..\..\h4toh5testdir\vg_loop_test.expected
h5dump  vgnameclash_test.h5 >..\..\h4toh5testdir\vgnameclash_test.expected
h5dump  anno_test.h5 >..\..\h4toh5testdir\anno_test.expected
h5dump  gr_typ_test.h5 >..\..\h4toh5testdir\gr_typ_test.expected
h5dump  grnameclash_test.h5 >..\..\h4toh5testdir\grnameclash_test.expected
h5dump  image_attr_test.h5 >..\..\h4toh5testdir\image_attr_test.expected
h5dump  ras_24_test.h5 >..\..\h4toh5testdir\ras_24_test.expected
h5dump  ras_8_test.h5 >..\..\h4toh5testdir\ras_8_test.expected
h5dump  sds_attr_test.h5 >..\..\h4toh5testdir\sds_attr_test.expected
h5dump  sds_dim_test.h5 >..\..\h4toh5testdir\sds_dim_test.expected
h5dump  sds_typ_test.h5 >..\..\h4toh5testdir\sds_typ_test.expected
h5dump  sdsnameclash_test.h5 >..\..\h4toh5testdir\sdsnameclash_test.expected
h5dump  vdata_test.h5 >..\..\h4toh5testdir\vdata_test.expected
h5dump  vdnameclash_test.h5 >..\..\h4toh5testdir\vdnameclash_test.expected

echo off
echo   now deleting EXPECTED h5 files 

del *.h5

echo ------------STEP SIX------------------
echo file comparision for the first option

cd ..\..\h4toh5testdir
fc  vg_all_test.expected vg_all_test.results
fc  vg_hl_test.expected vg_hl_test.results
fc  vg_loop_test.expected vg_loop_test.results
fc  vgnameclash_test.expected vgnameclash_test.results
fc  anno_test.expected anno_test.results
fc  gr_typ_test.expected gr_typ_test.results
fc  grnameclash_test.expected grnameclash_test.results
fc  image_attr_test.expected image_attr_test.results
fc  ras_24_test.expected ras_24_test.results
fc  ras_8_test.expected ras_8_test.results
fc  sds_attr_test.expected sds_attr_test.results
fc  sds_dim_test.expected sds_dim_test.results
fc  sds_typ_test.expected sds_typ_test.results
fc  sdsnameclash_test.expected sdsnameclash_test.results
fc  vdata_test.expected vdata_test.results
fc  vdnameclash_test.expected vdnameclash_test.results


del *.results
del *.expected


cd ..

echo off
echo    II. For h4toh5 test option II(hdf file name specified)    
echo 	using %1 version
echo on
echo 
cd h4toh5%2\%1
echo off
echo    skip STEP ONE since we have already copied original hdf files
echo on
echo
echo off
echo --------------STEP TWO-------------------
echo 	doing h4toh5 conversion(hdf file is set default) 

h4toh5%2 vg_all_test.hdf vg_all_test.h5 
h4toh5%2 vg_hl_test.hdf vg_hl_test.h5
h4toh5%2 vg_loop_test.hdf vg_loop_test.h5
h4toh5%2 vgnameclash_test.hdf vgnameclash_test.h5
h4toh5%2 vdnameclash_test.hdf vdnameclash_test.h5
h4toh5%2 vdata_test.hdf vdata_test.h5
h4toh5%2 sdsnameclash_test.hdf sdsnameclash_test.h5
h4toh5%2 sds_typ_test.hdf sds_typ_test.h5
h4toh5%2 sds_dim_test.hdf sds_dim_test.h5
h4toh5%2 sds_attr_test.hdf sds_attr_test.h5
h4toh5%2 ras_8_test.hdf ras_8_test.h5
h4toh5%2 ras_24_test.hdf ras_24_test.h5
h4toh5%2 image_attr_test.hdf image_attr_test.h5
h4toh5%2 grnameclash_test.hdf grnameclash_test.h5
h4toh5%2 gr_typ_test.hdf gr_typ_test.h5
h4toh5%2 anno_test.hdf anno_test.h5

echo now deleting the original hdf file.
del *.hdf

echo copying converted hdf5 files into the directory where "h5dump" is located
echo on
echo   
copy *.h5 ..\..\h5dump\Release
echo off
echo   Deleting the converted hdf file under %1
del *.h5

echo go to the path where h5dump is located:
cd ..\..\h5dump\Release
echo on
echo 
echo off
echo ------------STEP THREE-------------
echo   now using h5dump to dump the converted h5 files
echo on
echo 

h5dump  vg_all_test.h5 >..\..\h4toh5testdir\vg_all_test.results
h5dump  vg_hl_test.h5 >..\..\h4toh5testdir\vg_hl_test.results
h5dump  vg_loop_test.h5 >..\..\h4toh5testdir\vg_loop_test.results
h5dump  vgnameclash_test.h5 >..\..\h4toh5testdir\vgnameclash_test.results
h5dump  anno_test.h5 >..\..\h4toh5testdir\anno_test.results
h5dump  gr_typ_test.h5 >..\..\h4toh5testdir\gr_typ_test.results
h5dump  grnameclash_test.h5 >..\..\h4toh5testdir\grnameclash_test.results
h5dump  image_attr_test.h5 >..\..\h4toh5testdir\image_attr_test.results
h5dump  ras_24_test.h5 >..\..\h4toh5testdir\ras_24_test.results
h5dump  ras_8_test.h5 >..\..\h4toh5testdir\ras_8_test.results
h5dump  sds_attr_test.h5 >..\..\h4toh5testdir\sds_attr_test.results
h5dump  sds_dim_test.h5 >..\..\h4toh5testdir\sds_dim_test.results
h5dump  sds_typ_test.h5 >..\..\h4toh5testdir\sds_typ_test.results
h5dump  sdsnameclash_test.h5 >..\..\h4toh5testdir\sdsnameclash_test.results
h5dump  vdata_test.h5 >..\..\h4toh5testdir\vdata_test.results
h5dump  vdnameclash_test.h5 >..\..\h4toh5testdir\vdnameclash_test.results

echo off
echo    now deleting converted h5 files
del *.h5
echo 

echo ------------STEP FOUR-------------------
echo copying the expected hdf5 file into the directory where dumper is located.
echo on
echo 
copy ..\..\testfiles\Expected\*.h5 .


echo off
echo ----------STEP FIVE-----------------

echo on
echo 
h5dump  vg_all_test.h5 >..\..\h4toh5testdir\vg_all_test.expected
h5dump  vg_hl_test.h5 >..\..\h4toh5testdir\vg_hl_test.expected
h5dump  vg_loop_test.h5 >..\..\h4toh5testdir\vg_loop_test.expected
h5dump  vgnameclash_test.h5 >..\..\h4toh5testdir\vgnameclash_test.expected
h5dump  anno_test.h5 >..\..\h4toh5testdir\anno_test.expected
h5dump  gr_typ_test.h5 >..\..\h4toh5testdir\gr_typ_test.expected
h5dump  grnameclash_test.h5 >..\..\h4toh5testdir\grnameclash_test.expected
h5dump  image_attr_test.h5 >..\..\h4toh5testdir\image_attr_test.expected
h5dump  ras_24_test.h5 >..\..\h4toh5testdir\ras_24_test.expected
h5dump  ras_8_test.h5 >..\..\h4toh5testdir\ras_8_test.expected
h5dump  sds_attr_test.h5 >..\..\h4toh5testdir\sds_attr_test.expected
h5dump  sds_dim_test.h5 >..\..\h4toh5testdir\sds_dim_test.expected
h5dump  sds_typ_test.h5 >..\..\h4toh5testdir\sds_typ_test.expected
h5dump  sdsnameclash_test.h5 >..\..\h4toh5testdir\sdsnameclash_test.expected
h5dump  vdata_test.h5 >..\..\h4toh5testdir\vdata_test.expected
h5dump  vdnameclash_test.h5 >..\..\h4toh5testdir\vdnameclash_test.expected

echo   now deleting EXPECTED h5 files

del *.h5

echo off
echo ------------STEP SIX------------------

cd ..\..\h4toh5testdir
echo file comparisons for the second option

fc  vg_all_test.expected vg_all_test.results
fc  vg_hl_test.expected vg_hl_test.results
fc  vg_loop_test.expected vg_loop_test.results
fc  vgnameclash_test.expected vgnameclash_test.results
fc  anno_test.expected anno_test.results
fc  gr_typ_test.expected gr_typ_test.results
fc  grnameclash_test.expected grnameclash_test.results
fc  image_attr_test.expected image_attr_test.results
fc  ras_24_test.expected ras_24_test.results
fc  ras_8_test.expected ras_8_test.results
fc  sds_attr_test.expected sds_attr_test.results
fc  sds_dim_test.expected sds_dim_test.results
fc  sds_typ_test.expected sds_typ_test.results
fc  sdsnameclash_test.expected sdsnameclash_test.results
fc  vdata_test.expected vdata_test.results
fc  vdnameclash_test.expected vdnameclash_test.results


echo on
echo

del *.results
del *.expected

cd ..
cd h4toh5%2\%1
del *.

cd ..\..
rmdir h4toh5testdir