# A simple module for accessing an imap server through imtest (rather
# than the seriously broken perl library included with cyrus).
package ImtestImap;
use strict;
use FileHandle;
use IPC::Open2;

# Create a new imap connection.
# ($ref) = new ImtestImap($host)
#    $host : the host to connect to.
sub new {
    my $class = shift;
    my $self = { number => 10 };
    bless $self, $class;
    
    my ($host) = @_;
    $self->{pid} = open2(*Reader, *Writer, "imtest $host") ||
	die "Failed to open imap connection: $!\n";
    return $self;
}

# Run a command through the imap connection
# ($result) = $ref->cmd($command, $save)
#     $command is the command to run (without the sequence id)
#     reply lines are stored in @$save, if defined
sub cmd {
    my ($self, $cmd, $save) = @_;
    ++$self->{number};
    print Writer "$self->{number} $cmd\n"
	|| die "Failed to send command: $!\n";
    while(<Reader>) {
	last if /^$self->{number} /;
	push @$save, $_ if(defined $save);
	#print;
    }
    if(/^$self->{number} OK/) {	
#	print "==> $_";
	return;
	
    } else {
	die "Imap command $cmd failed: $_\n";
    }
}

1;
