Summary: Powerful image loading and rendering library
Name: imlib2
Version: 1.0.4
Release: 1
Copyright: BSD
Group: System Environment/Libraries
Source: ftp://ftp.enlightenment.org/pub/enlightenment/e17/libs/%{name}-%{version}.tar.gz
BuildRoot: %{_tmppath}/%{name}-root
Packager: Lyle Kempler <term@kempler.net>, Joakim Bodin <bodin@dreamhosted.com>
URL: http://www.rasterman.com/raster/imlib.html
Requires: freetype
Requires: XFree86
BuildRequires: libjpeg-devel
BuildRequires: libpng-devel
BuildRequires: XFree86-devel
BuildRequires: freetype-devel

%description
Imlib2 is an advanced replacement library for libraries like libXpm that
provides many more features with much greater flexibility and speed than
standard libraries, including font rasterization, rotation, RGBA space
rendering and blending, dynamic binary filters, scripting, and more.

%package devel
Summary: Imlib2 headers, static libraries and documentation
Group: System/Libraries
Requires: %{name} = %{PACKAGE_VERSION}
%description devel
Headers, static libraries and documentation for Imlib2.

%package filters
Summary: Imlib2 basic plugin filters set
Group: System/Libraries
Requires: %{name} = %{PACKAGE_VERSION}
%description filters
Basic set of plugin filters that come with Imlib2

%package loader_jpeg
Summary: Imlib2 JPEG loader
Group: System/Libraries
Requires: libjpeg
BuildRequires: libjpeg-devel
%description loader_jpeg
JPEG image loader/saver for Imlib2

%package loader_png
Summary: Imlib2 PNG loader
Group: System/Libraries
Requires: libpng
Requires: zlib
BuildRequires: libpng-devel
BuildRequires: zlib-devel
%description loader_png
PNG image loader/saver for Imlib2

%package loader_argb
Summary: Imlib2 ARGB loader
Group: System/Libraries
%description loader_argb
ARGB image loader/saver for Imlib2

%package loader_bmp
Summary: Imlib2 BMP loader
Group: System/Libraries
%description loader_bmp
BMP image loader/saver for Imlib2

%package loader_gif
Summary: Imlib2 GIF loader
Group: System/Libraries
Requires: libungif
BuildRequires: libungif-devel
%description loader_gif
GIF image loader/saver for Imlib2

%package loader_pnm
Summary: Imlib2 PNM loader
Group: System/Libraries
%description loader_pnm
PNM image loader/saver for Imlib2

%package loader_tga
Summary: Imlib2 TGA loader
Group: System/Libraries
%description loader_tga
TGA image loader/saver for Imlib2

%package loader_tiff
Summary: Imlib2 TIFF loader
Group: System/Libraries
Requires: libtiff
BuildRequires: libtiff-devel
%description loader_tiff
TIFF image loader/saver for Imlib2

%package loader_xpm
Summary: Imlib2 XPM loader
Group: System/Libraries
%description loader_xpm
XPM image loader/saver for Imlib2

%prep
rm -rf $RPM_BUILD_ROOT

%setup -q

%build

if [ -f configure ]
then
  %configure --prefix=%{_prefix} --bindir=%{_bindir} --libdir=%{_libdir} --includedir=%{_includedir}
else
  # can't build as root? gah. ;)
  sed <autogen.sh 's@$USER@ANNOYING@' >autogen.sh1
  mv -f autogen.sh1 autogen.sh
  chmod 0700 autogen.sh
  ./autogen.sh --prefix=%{_prefix} --bindir=%{_bindir} --libdir=%{_libdir} --includedir=%{_includedir}
fi

if [ "$SMP" != "" ]; then
  (make "MAKE=make -k -j $SMP"; exit 0)
  make
else
  make
fi

%install
rm -rf $RPM_BUILD_ROOT
%makeinstall

%clean
rm -rf $RPM_BUILD_ROOT

%post -p /sbin/ldconfig

%postun -p /sbin/ldconfig

%files
%defattr(-,root,root,0755)
%doc AUTHORS README COPYING ChangeLog doc/index.html doc/imlib2.gif doc/blank.gif
%{_libdir}/lib*.so.*
%{_bindir}/*

%files devel
%defattr(-,root,root,0755)
%{_libdir}/libImlib2.so
%{_libdir}/*.a
%{_includedir}/*

%files filters
%attr(755,root,root) %{_libdir}/loaders/filter/*

%files loader_jpeg
%attr(755,root,root) %{_libdir}/loaders/image/jpeg.*

%files loader_png
%attr(755,root,root) %{_libdir}/loaders/image/png.*

%files loader_argb
%attr(755,root,root) %{_libdir}/loaders/image/argb.*

%files loader_bmp
%attr(755,root,root) %{_libdir}/loaders/image/bmp.*

%files loader_gif
%attr(755,root,root) %{_libdir}/loaders/image/gif.*

%files loader_pnm
%attr(755,root,root) %{_libdir}/loaders/image/pnm.*

%files loader_tga
%attr(755,root,root) %{_libdir}/loaders/image/tga.*

%files loader_tiff
%attr(755,root,root) %{_libdir}/loaders/image/tiff.*

%files loader_xpm
%attr(755,root,root) %{_libdir}/loaders/image/xpm.*

%changelog
* Tue Aug 28 2001 Alvaro Herrera <alvherre@dcc.uchile.cl>
- Remove loader_db since it's included in a different package.

* Mon Jan 8 2001 The Rasterman <raster@rasterman.com>
- Fix Requires & BuildRequires for freetype.

* Sat Sep 30 2000 Lyle Kempler <term@kempler.net>
- Bring back building imlib2 as root via autogen.sh for the lazy (me)
- Some minor changes

* Sat Sep 30 2000 Joakim Bodin <bodin@dreamhosted.com>
- Linux-Mandrake:ise the spec file

* Tue Sep 12 2000 The Rasterman <raster@rasterman.com>
- Redo spec file

* Wed Aug 30 2000 Lyle Kempler <kempler@utdallas.edu>
- Include imlib2-config

* Sat May 20 2000 Lyle Kempler <kempler@utdallas.edu>
- Fixed problems with requiring imlib2_view
- Went back to imlib2_view (not imlib2-view)

* Tue Nov 2 1999 Lyle Kempler <kempler@utdallas.edu>
- Mangled imlib 1.9.8 imlib spec file into imlib2 spec file
