/*
 * ion/focus.c
 *
 * Copyright (c) Tuomo Valkonen 1999-2001. 
 * See the included file LICENSE for details.
 */

#include "common.h"
#include "focus.h"
#include "thingp.h"
#include "global.h"
#include "wedln.h"


static WThing *current_client_or_frame()
{
	WWindow *cw=wglobal.current_wswindow;
	
	if(cw!=NULL && WTHING_IS(cw, WFrame) &&
	   ((WFrame*)cw)->current_client!=NULL){
		return (WThing*)((WFrame*)cw)->current_client;
	}
	return (WThing*)cw;
}


static WThing *get_next_previous(WThing *next)
{
	WThing *current=current_client_or_frame();
	
	if(current==next || current==NULL)
		return NULL;
	
	if((WThing*)FIND_PARENT(current, WWindow)==next)
		return NULL;
	
	return current;
}


static void set_previous(WThing *previous)
{
	if(previous!=NULL)
		wglobal.previous=previous;
}


void do_set_focus(WThing *thing)
{
	if(thing==NULL){
		thing=(WThing*)wglobal.current_screen;
		if(thing==NULL)
			return;
	}else if(!on_visible_workspace(thing)){
		return;
	}
	
	if(WTHING_IS(thing, WFrame))
		focus_frame((WFrame*)thing);
	else if(WTHING_IS(thing, WWindow))
		focus_window((WWindow*)thing);
	else if(WTHING_IS(thing, WClient))
		focus_client((WClient*)thing);
	else if(WTHING_IS(thing, WClientWin))
		focus_clientwin((WClientWin*)thing);
	else{
		if(wglobal.current_screen!=NULL){
			XSetInputFocus(wglobal.dpy, wglobal.current_screen->root.win,
						   RevertToNone, CurrentTime);
		}
	}
}


void do_set_focus_save(WThing *thing)
{
	set_previous(get_next_previous(thing));
	do_set_focus(thing);
}


void set_focus(WThing *thing)
{
	wglobal.focus_next=thing;
}


void set_focus_save(WThing *thing)
{
	set_previous(get_next_previous(thing));
	set_focus(thing);
}


void warp(WWindow *wwin)
{
#ifdef CF_WARP
	XWarpPointer(wglobal.dpy, None, wwin->win, 0, 0, 0, 0,
				 5, 5);
#endif
	set_focus((WThing*)wwin);
}


void warp_save(WWindow *wwin)
{
	set_previous(get_next_previous((WThing*)wwin));
	warp(wwin);
}


