/*
 * Decompiled with CFR 0.152.
 */
package com.dstc.security.pki;

import com.dstc.security.asn1.Asn1;
import com.dstc.security.asn1.Asn1Exception;
import com.dstc.security.asn1.BitString;
import com.dstc.security.asn1.IA5String;
import com.dstc.security.common.AlgorithmId;
import com.dstc.security.common.OID;
import com.dstc.security.common.SubjectPublicKeyInfo;
import com.dstc.security.pki.CertificationRequest;
import com.dstc.security.pki.PKIException;
import java.security.KeyFactory;
import java.security.PublicKey;
import java.security.Signature;
import java.security.spec.X509EncodedKeySpec;
import java.util.Iterator;

public class NetscapeCertificationRequest
implements CertificationRequest {
    private Asn1 asn1 = null;
    private Asn1 pkc = null;
    private SubjectPublicKeyInfo spki;
    private String challenge;
    private AlgorithmId algo;
    private byte[] sig;

    public NetscapeCertificationRequest(byte[] byArray) throws PKIException {
        try {
            this.init(Asn1.getAsn1(byArray));
        }
        catch (Asn1Exception asn1Exception) {
            throw new PKIException("bad encoding");
        }
    }

    public byte[] getEncoded() {
        try {
            return this.asn1.getEncoded();
        }
        catch (Asn1Exception asn1Exception) {
            throw new RuntimeException();
        }
    }

    public byte[] getEncodedPublicKey() {
        return this.spki.getEncoded();
    }

    public String getKeyAlgName() {
        return OID.getAlgName(this.spki.getAlgorithmId().getOid());
    }

    public PublicKey getPublicKey() {
        return null;
    }

    public String getSigAlgName() {
        return OID.getAlgName(this.algo.getOid());
    }

    public byte[] getSignature() {
        return this.sig;
    }

    public String getSubjectName() {
        return null;
    }

    private void init(Asn1 asn1) throws Asn1Exception {
        this.asn1 = asn1;
        Iterator iterator = asn1.components();
        this.pkc = (Asn1)iterator.next();
        Iterator iterator2 = this.pkc.components();
        this.spki = new SubjectPublicKeyInfo((Asn1)iterator2.next());
        this.challenge = ((IA5String)iterator2.next()).getString();
        this.algo = new AlgorithmId((Asn1)iterator.next());
        this.sig = ((BitString)iterator.next()).getBytes();
    }

    public boolean verifySignature() {
        try {
            Signature signature = Signature.getInstance(this.getSigAlgName());
            KeyFactory keyFactory = KeyFactory.getInstance(this.getKeyAlgName());
            PublicKey publicKey = keyFactory.generatePublic(new X509EncodedKeySpec(this.spki.getAsn1().getEncoded()));
            signature.initVerify(publicKey);
            signature.update(this.pkc.getEncoded());
            return signature.verify(this.sig);
        }
        catch (Exception exception) {
            return false;
        }
    }
}

