/*
 * Decompiled with CFR 0.152.
 */
package com.dstc.security.x509gen;

import com.dstc.security.asn1.Asn1;
import com.dstc.security.asn1.Asn1Exception;
import com.dstc.security.asn1.Explicit;
import com.dstc.security.asn1.Integer;
import com.dstc.security.asn1.Sequence;
import com.dstc.security.common.AlgorithmId;
import com.dstc.security.common.SubjectPublicKeyInfo;
import com.dstc.security.common.X500Name;
import com.dstc.security.x509.Extension;
import com.dstc.security.x509.Extensions;
import com.dstc.security.x509.Validity;
import java.math.BigInteger;
import java.security.PublicKey;
import java.util.AbstractList;
import java.util.Date;
import java.util.Iterator;
import java.util.Vector;

public class TBSCertificate
extends com.dstc.security.x509.TBSCertificate {
    TBSCertificate(int n, AlgorithmId algorithmId, X500Name x500Name) {
        this.version = n;
        this.algo = algorithmId;
        this.issuer = x500Name;
    }

    public void addExtension(Extension extension) {
        if (this.extns == null) {
            this.extns = new Extensions();
        }
        this.extns.addExtension(extension);
    }

    void encode() {
        Asn1 asn1;
        this.asn1 = new Sequence();
        Vector vector = null;
        if (this.extns != null) {
            vector = this.extns.getExtensions();
        }
        if (this.version != 0) {
            asn1 = new Explicit(128, 0);
            asn1.add(new Integer(this.version));
            this.asn1.add(asn1);
        }
        this.asn1.add(new Integer(this.serialNumber));
        this.asn1.add(this.algo.getAsn1());
        this.asn1.add(this.issuer.getAsn1());
        this.asn1.add(this.validity.getAsn1());
        if (this.subject == null) {
            this.asn1.add(new Sequence());
        } else {
            this.asn1.add(this.subject.getAsn1());
        }
        this.asn1.add(this.spki.getAsn1());
        if (vector != null) {
            asn1 = new Sequence();
            Iterator iterator = ((AbstractList)vector).iterator();
            while (iterator.hasNext()) {
                asn1.add(((Extension)iterator.next()).getAsn1());
            }
            Explicit explicit = new Explicit(128, 3);
            explicit.add(asn1);
            this.asn1.add(explicit);
        }
    }

    void setExtensions(Vector vector) {
        this.extns = new Extensions(vector);
    }

    void setPublicKey(PublicKey publicKey) throws Asn1Exception {
        this.spki = new SubjectPublicKeyInfo(publicKey.getEncoded());
    }

    void setSerialNumber(BigInteger bigInteger) {
        this.serialNumber = bigInteger;
    }

    void setSubjectDN(X500Name x500Name) {
        this.subject = x500Name;
    }

    void setValidity(Date date, Date date2) {
        this.validity = new Validity(date, date2);
    }

    void setValidityPeriodInDays(int n) {
        this.validity = new Validity(n);
    }
}

