/*
 * Decompiled with CFR 0.152.
 */
package com.dstc.security.x509gen;

import com.dstc.security.asn1.Asn1;
import com.dstc.security.asn1.Asn1Exception;
import com.dstc.security.asn1.Integer;
import com.dstc.security.asn1.Sequence;
import com.dstc.security.asn1.UTCTime;
import com.dstc.security.x509.Extensions;
import java.io.IOException;
import java.math.BigInteger;
import java.util.Iterator;

public class X509CRLEntry
extends com.dstc.security.x509.X509CRLEntry {
    public X509CRLEntry(Asn1 asn1) throws IOException, Asn1Exception {
        this.asn1 = asn1;
        Iterator iterator = asn1.components();
        Asn1 asn12 = (Asn1)iterator.next();
        this.userCertificate = ((Integer)asn12).getBigInteger();
        this.revocationDate = (UTCTime)iterator.next();
        if (!iterator.hasNext()) {
            return;
        }
    }

    public X509CRLEntry(BigInteger bigInteger, UTCTime uTCTime, Extensions extensions) {
        this.asn1 = new Sequence();
        this.userCertificate = bigInteger;
        this.asn1.add(new Integer(bigInteger));
        this.revocationDate = uTCTime;
        this.asn1.add(uTCTime);
        if (extensions == null) {
            return;
        }
        this.crlExtns = extensions;
        this.asn1.add(extensions.getAsn1());
    }
}

