/*
 * Decompiled with CFR 0.152.
 */
package com.dstc.security.provider;

import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.BadPaddingException;
import javax.crypto.CipherSpi;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.ShortBufferException;
import javax.crypto.spec.IvParameterSpec;

abstract class BlockCipher
extends CipherSpi {
    private static final int MODE_ECB = 0;
    private static final int MODE_CBC = 1;
    private static final int MODE_CFB = 2;
    protected int blockSize;
    protected byte[] IV = null;
    protected byte[] inputBuffer;
    protected byte[] chainBlock;
    protected AlgorithmParameters algParams = null;
    protected int inputBufferOffset;
    protected int inputBufferLen;
    private int state;
    private int mode = 1;
    private SecureRandom rand;
    private Padding pad = new PKCS5Padding();
    private int paddingType = 0;
    private boolean needIV = false;
    private byte[] tempBlock;

    BlockCipher() {
    }

    protected abstract void decryptBlock(byte[] var1, byte[] var2);

    protected abstract void encryptBlock(byte[] var1, byte[] var2);

    protected byte[] engineDoFinal(byte[] byArray, int n, int n2) throws IllegalBlockSizeException, BadPaddingException {
        try {
            byte[] byArray2 = new byte[this.engineGetOutputSize(n2)];
            int n3 = this.engineDoFinal(byArray, n, n2, byArray2, 0);
            byte[] byArray3 = new byte[n3];
            System.arraycopy(byArray2, 0, byArray3, 0, n3);
            return byArray3;
        }
        catch (ShortBufferException shortBufferException) {
            throw new RuntimeException("Internal error: " + shortBufferException.getMessage());
        }
    }

    protected int engineDoFinal(byte[] byArray, int n, int n2, byte[] byArray2, int n3) throws ShortBufferException, IllegalBlockSizeException, BadPaddingException {
        int n4 = this.engineUpdate(byArray, n, n2, byArray2, n3);
        if (this.state == 1) {
            if (!this.pad.doPadding()) {
                this.reset();
                return n4;
            }
            if (this.mode == 1) {
                int n5 = 0;
                while (n5 < this.blockSize) {
                    int n6 = n5;
                    this.inputBuffer[n6] = (byte)(this.inputBuffer[n6] ^ this.chainBlock[n5]);
                    ++n5;
                }
            }
            this.encryptBlock(this.inputBuffer, this.chainBlock);
            System.arraycopy(this.chainBlock, 0, byArray2, n4 + n3, this.blockSize);
            this.reset();
            return n4 + this.blockSize;
        }
        if (this.state == 2) {
            int n7;
            if (this.inputBufferOffset == 0) {
                this.reset();
                return n4;
            }
            if (this.inputBufferOffset != this.blockSize) {
                throw new IllegalBlockSizeException("CipherText length not a multiple of blockSize");
            }
            this.decryptBlock(this.inputBuffer, this.tempBlock);
            if (this.mode == 1) {
                n7 = 0;
                while (n7 < this.blockSize) {
                    int n8 = n7;
                    this.tempBlock[n8] = (byte)(this.tempBlock[n8] ^ this.chainBlock[n7]);
                    ++n7;
                }
            }
            n7 = this.pad.doUnPadding(this.tempBlock);
            System.arraycopy(this.tempBlock, 0, byArray2, n3 + n4, n7);
            this.reset();
            return n4 + n7;
        }
        throw new RuntimeException("Unknown cipher state " + this.state);
    }

    protected int engineGetBlockSize() {
        return this.blockSize;
    }

    protected byte[] engineGetIV() {
        return this.IV;
    }

    protected int engineGetOutputSize(int n) {
        int n2 = n + this.inputBufferOffset;
        if (this.state == 1) {
            n2 += this.blockSize - n2 % this.blockSize;
        }
        return n2;
    }

    protected AlgorithmParameters engineGetParameters() {
        return this.algParams;
    }

    protected void engineInit(int n, Key key, AlgorithmParameters algorithmParameters, SecureRandom secureRandom) throws InvalidKeyException, InvalidAlgorithmParameterException {
        this.state = n;
        this.rand = secureRandom;
        this.initialize(key, null);
        this.reset();
    }

    protected void engineInit(int n, Key key, SecureRandom secureRandom) throws InvalidKeyException {
        this.state = n;
        this.rand = secureRandom;
        if (this.needIV) {
            this.IV = new byte[this.blockSize];
            this.rand.nextBytes(this.IV);
        }
        this.initialize(key, null);
        this.reset();
    }

    protected void engineInit(int n, Key key, AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidKeyException, InvalidAlgorithmParameterException {
        this.state = n;
        this.rand = secureRandom;
        if (algorithmParameterSpec instanceof IvParameterSpec) {
            this.IV = ((IvParameterSpec)algorithmParameterSpec).getIV();
            this.initialize(key, null);
            this.reset();
            return;
        }
        this.initialize(key, algorithmParameterSpec);
        this.reset();
    }

    protected void engineSetMode(String string) throws NoSuchAlgorithmException {
        if (string.equals("CBC")) {
            this.mode = 1;
            this.needIV = true;
        } else if (string.equals("ECB")) {
            this.mode = 0;
        } else if (string.equals("CFB")) {
            this.mode = 2;
            this.needIV = true;
        } else {
            throw new NoSuchAlgorithmException(String.valueOf(string) + " Not supported");
        }
    }

    protected void engineSetPadding(String string) throws NoSuchPaddingException {
        if (string.equals("PKCS5Padding")) {
            this.pad = new PKCS5Padding();
            this.paddingType = 1;
        } else if (string.equals("NoPadding")) {
            this.pad = new Padding();
        } else if (string.equals("Zeroes")) {
            this.pad = new Zeroes();
            this.paddingType = 1;
        } else {
            throw new NoSuchPaddingException(String.valueOf(string) + " Not supported");
        }
    }

    protected byte[] engineUpdate(byte[] byArray, int n, int n2) {
        try {
            byte[] byArray2 = new byte[this.engineGetOutputSize(n2)];
            int n3 = this.engineUpdate(byArray, n, n2, byArray2, 0);
            byte[] byArray3 = new byte[n3];
            System.arraycopy(byArray2, 0, byArray3, 0, n3);
            return byArray3;
        }
        catch (ShortBufferException shortBufferException) {
            throw new RuntimeException("Internal error: " + shortBufferException.getMessage());
        }
    }

    protected int engineUpdate(byte[] byArray, int n, int n2, byte[] byArray2, int n3) throws ShortBufferException {
        if (byArray == null) {
            return 0;
        }
        int n4 = 0;
        int n5 = 0;
        if (this.state == 1) {
            int n6;
            int n7;
            while ((n7 = this.blockSize - this.inputBufferOffset) <= (n6 = n2 - n4)) {
                int n8;
                System.arraycopy(byArray, n4 + n, this.inputBuffer, this.inputBufferOffset, n7);
                if (this.mode == 1) {
                    n8 = 0;
                    while (n8 < this.blockSize) {
                        int n9 = n8;
                        this.inputBuffer[n9] = (byte)(this.inputBuffer[n9] ^ this.chainBlock[n8]);
                        ++n8;
                    }
                    this.encryptBlock(this.inputBuffer, this.chainBlock);
                    System.arraycopy(this.chainBlock, 0, byArray2, n5 + n3, this.blockSize);
                } else if (this.mode == 0) {
                    this.encryptBlock(this.inputBuffer, this.chainBlock);
                    System.arraycopy(this.chainBlock, 0, byArray2, n5 + n3, this.blockSize);
                } else if (this.mode == 2) {
                    this.encryptBlock(this.chainBlock, this.tempBlock);
                    n8 = 0;
                    while (n8 < this.blockSize) {
                        this.chainBlock[n8] = (byte)(this.inputBuffer[n8] ^ this.tempBlock[n8]);
                        ++n8;
                    }
                    System.arraycopy(this.chainBlock, 0, byArray2, n5 + n3, this.blockSize);
                }
                this.inputBufferOffset = 0;
                n4 += n7;
                n5 += this.blockSize;
            }
            System.arraycopy(byArray, n4 + n, this.inputBuffer, this.inputBufferOffset, n6);
            this.inputBufferOffset += n6;
            return n5;
        }
        if (this.state == 2) {
            int n10;
            int n11;
            while ((n11 = n2 - n4) - (n10 = this.blockSize - this.inputBufferOffset) >= this.paddingType) {
                int n12;
                System.arraycopy(byArray, n4 + n, this.inputBuffer, this.inputBufferOffset, n10);
                if (this.mode == 1) {
                    this.decryptBlock(this.inputBuffer, this.tempBlock);
                    n12 = 0;
                    while (n12 < this.blockSize) {
                        byArray2[n12 + n5 + n3] = (byte)(this.chainBlock[n12] ^ this.tempBlock[n12]);
                        ++n12;
                    }
                    System.arraycopy(this.inputBuffer, 0, this.chainBlock, 0, this.blockSize);
                } else if (this.mode == 0) {
                    this.decryptBlock(this.inputBuffer, this.tempBlock);
                    System.arraycopy(this.tempBlock, 0, byArray2, n5 + n3, this.blockSize);
                } else if (this.mode == 2) {
                    this.encryptBlock(this.chainBlock, this.tempBlock);
                    n12 = 0;
                    while (n12 < this.blockSize) {
                        byArray2[n12 + n5 + n3] = (byte)(this.inputBuffer[n12] ^ this.tempBlock[n12]);
                        ++n12;
                    }
                    System.arraycopy(this.inputBuffer, 0, this.chainBlock, 0, this.blockSize);
                }
                this.inputBufferOffset = 0;
                n4 += n10;
                n5 += this.blockSize;
            }
            System.arraycopy(byArray, n4 + n, this.inputBuffer, this.inputBufferOffset, n11);
            this.inputBufferOffset += n11;
            return n5;
        }
        return 0;
    }

    protected abstract void initialize(Key var1, AlgorithmParameterSpec var2) throws IllegalStateException, InvalidKeyException;

    private void reset() {
        this.tempBlock = new byte[this.blockSize];
        this.inputBuffer = new byte[this.blockSize];
        this.inputBufferOffset = 0;
        this.inputBufferLen = 0;
        this.chainBlock = this.needIV ? (byte[])this.IV.clone() : new byte[this.blockSize];
    }

    protected class PKCS5Padding
    extends Padding {
        protected PKCS5Padding() {
        }

        protected boolean doPadding() {
            int n = BlockCipher.this.inputBufferOffset != 0 ? BlockCipher.this.blockSize - BlockCipher.this.inputBufferOffset : BlockCipher.this.blockSize;
            int n2 = 0;
            while (n2 < n) {
                BlockCipher.this.inputBuffer[BlockCipher.this.inputBufferOffset + n2] = (byte)n;
                ++n2;
            }
            return true;
        }

        protected int doUnPadding(byte[] byArray) throws BadPaddingException {
            byte by = byArray[byArray.length - 1];
            if (by < 1 || by > BlockCipher.this.blockSize) {
                throw new BadPaddingException("Expected PKCS5 but not encountered");
            }
            return BlockCipher.this.blockSize - by;
        }
    }

    protected class Zeroes
    extends Padding {
        protected Zeroes() {
        }

        protected boolean doPadding() throws IllegalBlockSizeException {
            if (BlockCipher.this.inputBufferOffset == 0) {
                return false;
            }
            int n = BlockCipher.this.inputBufferOffset != 0 ? BlockCipher.this.blockSize - BlockCipher.this.inputBufferOffset : 0;
            int n2 = 0;
            while (n2 < n) {
                BlockCipher.this.inputBuffer[BlockCipher.this.inputBufferOffset + n2] = 0;
                ++n2;
            }
            return true;
        }
    }

    protected class Padding {
        protected Padding() {
        }

        protected boolean doPadding() throws IllegalBlockSizeException {
            if (BlockCipher.this.inputBufferOffset != 0) {
                throw new IllegalBlockSizeException("Needs padding");
            }
            return false;
        }

        protected int doUnPadding(byte[] byArray) throws BadPaddingException {
            return BlockCipher.this.blockSize;
        }
    }
}

