/*
 * Decompiled with CFR 0.152.
 */
package com.dstc.security.provider;

import com.dstc.security.provider.SymmKeyGenerator;
import com.dstc.security.provider.SymmetricKey;
import java.security.InvalidParameterException;
import java.security.SecureRandom;
import javax.crypto.SecretKey;

public class DESKeyGenerator
extends SymmKeyGenerator {
    public DESKeyGenerator() {
        this.keyLength = 64;
        this.alg = "DES";
    }

    protected SecretKey engineGenerateKey() {
        byte[] byArray = new byte[this.keyLength / 8];
        if (this.random == null) {
            this.random = new SecureRandom();
        }
        this.random.nextBytes(byArray);
        DESKeyGenerator.forceOddParity(byArray);
        return new SymmetricKey(this.alg, byArray);
    }

    protected void engineInit(int n, SecureRandom secureRandom) {
        if (n != 56) {
            throw new InvalidParameterException("Only 56-bit DES keys supported");
        }
        this.random = secureRandom;
    }

    private static void forceOddParity(byte[] byArray) {
        int n = 0;
        while (n < byArray.length) {
            int n2 = 0;
            int n3 = 7;
            while (n3 >= 0) {
                n2 += byArray[n] >>> n3 & 1;
                --n3;
            }
            if (n2 % 2 == 0) {
                int n4 = n;
                byArray[n4] = (byte)(byArray[n4] ^ 1);
            }
            ++n;
        }
    }
}

