/*
 * Decompiled with CFR 0.152.
 */
package com.dstc.security.provider;

import com.dstc.security.asn1.Asn1;
import com.dstc.security.asn1.Asn1Exception;
import com.dstc.security.common.AlgorithmId;
import com.dstc.security.common.SubjectPublicKeyInfo;
import java.io.IOException;
import java.math.BigInteger;
import java.security.AlgorithmParameters;
import java.security.Key;
import java.util.Arrays;
import javax.crypto.spec.DHParameterSpec;

public class DHPublicKey
implements javax.crypto.interfaces.DHPublicKey {
    private Asn1 asn1 = null;
    private BigInteger y;
    private DHParameterSpec params;

    protected DHPublicKey(BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3) {
        this.y = bigInteger;
        this.asn1 = new com.dstc.security.asn1.Integer(bigInteger);
        this.params = new DHParameterSpec(bigInteger2, bigInteger3);
    }

    protected DHPublicKey(byte[] byArray, DHParameterSpec dHParameterSpec) throws Asn1Exception, IOException {
        this.decode(Asn1.getAsn1(byArray));
        this.params = dHParameterSpec;
    }

    private void decode(Asn1 asn1) throws IOException {
        this.asn1 = asn1;
        this.y = ((com.dstc.security.asn1.Integer)asn1).getBigInteger();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof Key) {
            return Arrays.equals(this.getEncoded(), ((Key)object).getEncoded());
        }
        return false;
    }

    public String getAlgorithm() {
        return "DH";
    }

    public byte[] getEncoded() {
        try {
            AlgorithmParameters algorithmParameters = AlgorithmParameters.getInstance("DH");
            algorithmParameters.init(this.params);
            return new SubjectPublicKeyInfo(new AlgorithmId("1.2.840.113549.1.3.1", algorithmParameters), this.asn1.getEncoded()).getAsn1().getEncoded();
        }
        catch (Exception exception) {
            throw new RuntimeException(exception.getMessage());
        }
    }

    public String getFormat() {
        return "X.509";
    }

    public DHParameterSpec getParams() {
        return this.params;
    }

    public BigInteger getY() {
        return this.y;
    }

    public String toString() {
        byte[] byArray = null;
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < 3) {
            if (n == 0) {
                stringBuffer.append("DH Modulus P: \n            ");
                byArray = this.params.getP().toByteArray();
            } else if (n == 1) {
                stringBuffer.append("\nDH base G: \n            ");
                byArray = this.params.getG().toByteArray();
            } else {
                stringBuffer.append("\nPublic Y: \n            ");
                byArray = this.getY().toByteArray();
            }
            int n2 = 0;
            while (n2 < byArray.length) {
                if (n2 > 0 && n2 % 20 == 0) {
                    stringBuffer.append("\n            ");
                }
                if (byArray[n2] < 16 && byArray[n2] >= 0) {
                    stringBuffer.append("0" + Integer.toHexString(byArray[n2] & 0xFF) + " ");
                } else {
                    stringBuffer.append(String.valueOf(Integer.toHexString(byArray[n2] & 0xFF)) + " ");
                }
                ++n2;
            }
            ++n;
        }
        return stringBuffer.toString();
    }
}

