/*
 * Decompiled with CFR 0.152.
 */
package com.dstc.security.provider;

import com.dstc.security.common.AlgorithmId;
import com.dstc.security.common.PrivateKeyInfo;
import com.dstc.security.common.SubjectPublicKeyInfo;
import com.dstc.security.provider.DSAPrivateKey;
import com.dstc.security.provider.DSAPublicKey;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyFactorySpi;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.interfaces.DSAParams;
import java.security.spec.DSAParameterSpec;
import java.security.spec.DSAPrivateKeySpec;
import java.security.spec.DSAPublicKeySpec;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;

public class DSAKeyFactory
extends KeyFactorySpi {
    static /* synthetic */ Class class$java$security$spec$DSAParameterSpec;
    static /* synthetic */ Class class$java$security$spec$X509EncodedKeySpec;
    static /* synthetic */ Class class$java$security$spec$DSAPublicKeySpec;
    static /* synthetic */ Class class$java$security$spec$PKCS8EncodedKeySpec;
    static /* synthetic */ Class class$java$security$spec$DSAPrivateKeySpec;

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    protected PrivateKey engineGeneratePrivate(KeySpec keySpec) throws InvalidKeySpecException {
        if (keySpec instanceof DSAPrivateKeySpec) {
            DSAPrivateKeySpec dSAPrivateKeySpec = (DSAPrivateKeySpec)keySpec;
            return new DSAPrivateKey(dSAPrivateKeySpec.getX(), (DSAParams)new DSAParameterSpec(dSAPrivateKeySpec.getP(), dSAPrivateKeySpec.getQ(), dSAPrivateKeySpec.getG()));
        }
        if (keySpec instanceof PKCS8EncodedKeySpec) {
            try {
                PrivateKeyInfo privateKeyInfo = new PrivateKeyInfo(((PKCS8EncodedKeySpec)keySpec).getEncoded());
                AlgorithmId algorithmId = privateKeyInfo.getAlgorithmId();
                DSAParameterSpec dSAParameterSpec = null;
                if (algorithmId.getParams() != null) {
                    dSAParameterSpec = (DSAParameterSpec)algorithmId.getParams().getParameterSpec(class$java$security$spec$DSAParameterSpec != null ? class$java$security$spec$DSAParameterSpec : (class$java$security$spec$DSAParameterSpec = DSAKeyFactory.class$("java.security.spec.DSAParameterSpec")));
                }
                return new DSAPrivateKey(privateKeyInfo.getEncodedKey(), dSAParameterSpec);
            }
            catch (Exception exception) {
                throw new InvalidKeySpecException("Bad key spec: " + exception.getMessage());
            }
        }
        throw new InvalidKeySpecException("Not a DSA private key spec");
    }

    protected PublicKey engineGeneratePublic(KeySpec keySpec) throws InvalidKeySpecException {
        if (keySpec instanceof DSAPublicKeySpec) {
            DSAPublicKeySpec dSAPublicKeySpec = (DSAPublicKeySpec)keySpec;
            return new DSAPublicKey(dSAPublicKeySpec.getY(), (DSAParams)new DSAParameterSpec(dSAPublicKeySpec.getP(), dSAPublicKeySpec.getQ(), dSAPublicKeySpec.getG()));
        }
        if (keySpec instanceof X509EncodedKeySpec) {
            try {
                SubjectPublicKeyInfo subjectPublicKeyInfo = new SubjectPublicKeyInfo(((X509EncodedKeySpec)keySpec).getEncoded());
                AlgorithmId algorithmId = subjectPublicKeyInfo.getAlgorithmId();
                DSAParameterSpec dSAParameterSpec = null;
                if (algorithmId.getParams() != null) {
                    dSAParameterSpec = (DSAParameterSpec)algorithmId.getParams().getParameterSpec(class$java$security$spec$DSAParameterSpec != null ? class$java$security$spec$DSAParameterSpec : (class$java$security$spec$DSAParameterSpec = DSAKeyFactory.class$("java.security.spec.DSAParameterSpec")));
                }
                return new DSAPublicKey(subjectPublicKeyInfo.getEncodedKey(), dSAParameterSpec);
            }
            catch (Exception exception) {
                throw new InvalidKeySpecException("Bad key spec: " + exception.getMessage());
            }
        }
        throw new InvalidKeySpecException("Not a DSA public key spec");
    }

    protected KeySpec engineGetKeySpec(Key key, Class clazz) throws InvalidKeySpecException {
        if (!key.getAlgorithm().equals("DSA")) {
            throw new InvalidKeySpecException("Not a DSA key");
        }
        if (key instanceof PublicKey) {
            if (clazz.equals(class$java$security$spec$X509EncodedKeySpec != null ? class$java$security$spec$X509EncodedKeySpec : (class$java$security$spec$X509EncodedKeySpec = DSAKeyFactory.class$("java.security.spec.X509EncodedKeySpec")))) {
                return new X509EncodedKeySpec(key.getEncoded());
            }
            if (clazz.equals(class$java$security$spec$DSAPublicKeySpec != null ? class$java$security$spec$DSAPublicKeySpec : (class$java$security$spec$DSAPublicKeySpec = DSAKeyFactory.class$("java.security.spec.DSAPublicKeySpec")))) {
                java.security.interfaces.DSAPublicKey dSAPublicKey = (java.security.interfaces.DSAPublicKey)key;
                return new DSAPublicKeySpec(dSAPublicKey.getY(), dSAPublicKey.getParams().getP(), dSAPublicKey.getParams().getQ(), dSAPublicKey.getParams().getG());
            }
            throw new InvalidKeySpecException("key and keyspec mismatch");
        }
        if (clazz.equals(class$java$security$spec$PKCS8EncodedKeySpec != null ? class$java$security$spec$PKCS8EncodedKeySpec : (class$java$security$spec$PKCS8EncodedKeySpec = DSAKeyFactory.class$("java.security.spec.PKCS8EncodedKeySpec")))) {
            return new PKCS8EncodedKeySpec(key.getEncoded());
        }
        if (clazz.equals(class$java$security$spec$DSAPrivateKeySpec != null ? class$java$security$spec$DSAPrivateKeySpec : (class$java$security$spec$DSAPrivateKeySpec = DSAKeyFactory.class$("java.security.spec.DSAPrivateKeySpec")))) {
            java.security.interfaces.DSAPrivateKey dSAPrivateKey = (java.security.interfaces.DSAPrivateKey)key;
            return new DSAPrivateKeySpec(dSAPrivateKey.getX(), dSAPrivateKey.getParams().getP(), dSAPrivateKey.getParams().getQ(), dSAPrivateKey.getParams().getG());
        }
        throw new InvalidKeySpecException("key and keyspec mismatch");
    }

    protected Key engineTranslateKey(Key key) throws InvalidKeyException {
        if (key == null) {
            return null;
        }
        if (!key.getAlgorithm().equals("DSA")) {
            throw new InvalidKeyException("Not a DSA key");
        }
        if (key instanceof java.security.interfaces.DSAPublicKey) {
            java.security.interfaces.DSAPublicKey dSAPublicKey = (java.security.interfaces.DSAPublicKey)key;
            return new DSAPublicKey(dSAPublicKey.getY(), dSAPublicKey.getParams());
        }
        if (key instanceof java.security.interfaces.DSAPrivateKey) {
            java.security.interfaces.DSAPrivateKey dSAPrivateKey = (java.security.interfaces.DSAPrivateKey)key;
            return new DSAPrivateKey(dSAPrivateKey.getX(), dSAPrivateKey.getParams());
        }
        throw new InvalidKeyException("Cannot translate key");
    }
}

