/*
 * Decompiled with CFR 0.152.
 */
package com.dstc.security.provider;

import java.math.BigInteger;
import java.security.AlgorithmParameterGeneratorSpi;
import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.ProviderException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.DSAParameterSpec;
import java.security.spec.InvalidParameterSpecException;

public final class DSAParameterGenerator
extends AlgorithmParameterGeneratorSpi {
    private SecureRandom random;
    private int keyLength;
    private static BigInteger one = BigInteger.valueOf(1L);
    private static int probab = 80;

    private static BigInteger SHA(MessageDigest messageDigest, BigInteger bigInteger) {
        byte[] byArray = bigInteger.toByteArray();
        int n = 0;
        if (byArray[0] == 0) {
            ++n;
        }
        messageDigest.reset();
        messageDigest.update(byArray, n, byArray.length - n);
        return new BigInteger(1, messageDigest.digest());
    }

    protected AlgorithmParameters engineGenerateParameters() {
        try {
            BigInteger bigInteger;
            BigInteger bigInteger2;
            BigInteger bigInteger3;
            BigInteger bigInteger4;
            BigInteger bigInteger5;
            BigInteger bigInteger6;
            MessageDigest messageDigest = MessageDigest.getInstance("SHA-1");
            int n = (this.keyLength - 1) / 160;
            int n2 = this.keyLength - 1 - 160 * n;
            do {
                bigInteger5 = new BigInteger(160, this.random);
                int n3 = bigInteger5.bitLength();
                bigInteger4 = one.shiftLeft(n3);
                bigInteger6 = DSAParameterGenerator.SHA(messageDigest, bigInteger5).xor(DSAParameterGenerator.SHA(messageDigest, bigInteger5.add(one).mod(bigInteger4)));
            } while (!(bigInteger6 = bigInteger6.setBit(0).setBit(159)).isProbablePrime(probab));
            int n4 = 2;
            int n5 = 0;
            int n6 = this.keyLength - 1;
            while (true) {
                BigInteger bigInteger7 = DSAParameterGenerator.SHA(messageDigest, bigInteger5.add(BigInteger.valueOf(n4)).mod(bigInteger4));
                int n7 = 1;
                while (n7 < n) {
                    bigInteger7 = bigInteger7.add(DSAParameterGenerator.SHA(messageDigest, bigInteger5.add(BigInteger.valueOf(n4 + n7)).mod(bigInteger4)).shiftLeft(n7 * 160));
                    ++n7;
                }
                bigInteger7 = bigInteger7.add(DSAParameterGenerator.SHA(messageDigest, bigInteger5.add(BigInteger.valueOf(n4 + n)).mod(bigInteger4)).mod(one.shiftLeft(n2)).shiftLeft(n * 160));
                bigInteger3 = (bigInteger7 = bigInteger7.setBit(n6)).subtract(bigInteger7.mod(bigInteger6.multiply(one.shiftLeft(1)))).add(one);
                if (bigInteger3.testBit(n6) && bigInteger3.isProbablePrime(probab)) break;
                ++n5;
                n4 += n + 1;
            }
            while ((bigInteger2 = (bigInteger = new BigInteger(bigInteger3.bitLength() - 1, this.random)).modPow(bigInteger3.subtract(one).divide(bigInteger6), bigInteger3)).compareTo(one) != 1) {
            }
            DSAParameterSpec dSAParameterSpec = new DSAParameterSpec(bigInteger3, bigInteger6, bigInteger2);
            AlgorithmParameters algorithmParameters = AlgorithmParameters.getInstance("DSA");
            algorithmParameters.init(dSAParameterSpec);
            return algorithmParameters;
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new ProviderException(noSuchAlgorithmException.getMessage());
        }
        catch (InvalidParameterSpecException invalidParameterSpecException) {
            throw new RuntimeException("Internal error: " + invalidParameterSpecException.getMessage());
        }
    }

    protected void engineInit(int n, SecureRandom secureRandom) {
        this.keyLength = n;
        this.random = secureRandom;
    }

    protected void engineInit(AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidAlgorithmParameterException {
        if (algorithmParameterSpec != null) {
            throw new InvalidAlgorithmParameterException("Unsupported parameter spec");
        }
    }

    public void verifyDSAParams(DSAParameterSpec dSAParameterSpec, BigInteger bigInteger) {
        try {
            System.out.println("Verifying DSA parameters...");
            MessageDigest messageDigest = MessageDigest.getInstance("SHA-1");
            int n = dSAParameterSpec.getP().bitLength();
            int n2 = (n - 1) / 160;
            int n3 = n - 1 - 160 * n2;
            int n4 = bigInteger.bitLength();
            BigInteger bigInteger2 = one.shiftLeft(n4);
            BigInteger bigInteger3 = DSAParameterGenerator.SHA(messageDigest, bigInteger).xor(DSAParameterGenerator.SHA(messageDigest, bigInteger.add(one).mod(bigInteger2)));
            bigInteger3 = bigInteger3.setBit(0).setBit(159);
            if (!bigInteger3.equals(dSAParameterSpec.getQ())) {
                System.out.println("Verification failed for parameter q");
                return;
            }
            int n5 = 2;
            int n6 = 0;
            int n7 = n - 1;
            while (true) {
                BigInteger bigInteger4 = DSAParameterGenerator.SHA(messageDigest, bigInteger.add(BigInteger.valueOf(n5)).mod(bigInteger2));
                int n8 = 1;
                while (n8 < n2) {
                    bigInteger4 = bigInteger4.add(DSAParameterGenerator.SHA(messageDigest, bigInteger.add(BigInteger.valueOf(n5 + n8)).mod(bigInteger2)).shiftLeft(n8 * 160));
                    ++n8;
                }
                bigInteger4 = bigInteger4.add(DSAParameterGenerator.SHA(messageDigest, bigInteger.add(BigInteger.valueOf(n5 + n2)).mod(bigInteger2)).mod(one.shiftLeft(n3)).shiftLeft(n2 * 160));
                bigInteger4 = bigInteger4.setBit(n7);
                if ((bigInteger4 = bigInteger4.subtract(bigInteger4.mod(bigInteger3.multiply(one.shiftLeft(1)))).add(one)).testBit(n7) && bigInteger4.isProbablePrime(probab)) {
                    if (!bigInteger4.equals(dSAParameterSpec.getP())) {
                        System.out.println("Verification failed for parameter p");
                        System.out.println("C, N = " + n6 + " " + n5);
                    } else {
                        System.out.println("Verification succeded. Counter = " + n6);
                    }
                    return;
                }
                ++n6;
                n5 += n2 + 1;
            }
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new ProviderException(noSuchAlgorithmException.getMessage());
        }
    }
}

