/*
 * Decompiled with CFR 0.152.
 */
package com.dstc.security.provider;

import com.dstc.security.asn1.Asn1;
import com.dstc.security.asn1.Asn1Exception;
import com.dstc.security.asn1.Integer;
import com.dstc.security.asn1.Sequence;
import java.io.IOException;
import java.math.BigInteger;
import java.security.AlgorithmParametersSpi;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.DSAParameterSpec;
import java.security.spec.InvalidParameterSpecException;
import java.util.Iterator;

public final class DSAParameters
extends AlgorithmParametersSpi {
    private static final String ASN1 = "ASN.1";
    private Asn1 asn1 = null;
    private BigInteger g;
    private BigInteger p;
    private BigInteger q;
    static /* synthetic */ Class class$java$security$spec$DSAParameterSpec;

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private void decode(Asn1 asn1) throws IOException {
        this.asn1 = asn1;
        Iterator iterator = asn1.components();
        this.p = ((Integer)iterator.next()).getBigInteger();
        this.q = ((Integer)iterator.next()).getBigInteger();
        this.g = ((Integer)iterator.next()).getBigInteger();
    }

    private void encode() {
        this.asn1 = new Sequence();
        this.asn1.add(new Integer(this.p));
        this.asn1.add(new Integer(this.q));
        this.asn1.add(new Integer(this.g));
    }

    protected byte[] engineGetEncoded() throws IOException {
        try {
            return this.asn1.getEncoded();
        }
        catch (Asn1Exception asn1Exception) {
            throw new IOException(asn1Exception.getMessage());
        }
    }

    protected byte[] engineGetEncoded(String string) throws IOException {
        if (string == null) {
            return this.engineGetEncoded();
        }
        if (string.equals(ASN1)) {
            return this.engineGetEncoded();
        }
        throw new RuntimeException("Unrecognized format " + string);
    }

    protected AlgorithmParameterSpec engineGetParameterSpec(Class clazz) throws InvalidParameterSpecException {
        if (!clazz.equals(class$java$security$spec$DSAParameterSpec != null ? class$java$security$spec$DSAParameterSpec : (class$java$security$spec$DSAParameterSpec = DSAParameters.class$("java.security.spec.DSAParameterSpec")))) {
            throw new InvalidParameterSpecException("Bad parameter specification " + clazz.getName());
        }
        return new DSAParameterSpec(this.p, this.q, this.g);
    }

    protected void engineInit(AlgorithmParameterSpec algorithmParameterSpec) throws InvalidParameterSpecException {
        if (!(algorithmParameterSpec instanceof DSAParameterSpec)) {
            throw new InvalidParameterSpecException("Not a DSA param spec");
        }
        this.p = ((DSAParameterSpec)algorithmParameterSpec).getP();
        this.q = ((DSAParameterSpec)algorithmParameterSpec).getQ();
        this.g = ((DSAParameterSpec)algorithmParameterSpec).getG();
        this.encode();
    }

    protected void engineInit(byte[] byArray) throws IOException {
        try {
            this.decode(Asn1.getAsn1(byArray));
        }
        catch (Asn1Exception asn1Exception) {
            throw new IOException(asn1Exception.getMessage());
        }
    }

    protected void engineInit(byte[] byArray, String string) throws IOException {
        if (string != null && !string.equals(ASN1)) {
            throw new RuntimeException("Unsupported format " + string);
        }
        this.engineInit(byArray);
    }

    protected String engineToString() {
        StringBuffer stringBuffer = new StringBuffer("DSA Parameters: \n");
        stringBuffer.append("  p: ").append(this.p.toString(16)).append("\n");
        stringBuffer.append("  q: ").append(this.q.toString(16)).append("\n");
        stringBuffer.append("  g: ").append(this.g.toString(16));
        return stringBuffer.toString();
    }
}

