/*
 * Decompiled with CFR 0.152.
 */
package com.dstc.security.provider;

import com.dstc.security.asn1.Asn1;
import com.dstc.security.asn1.Asn1Exception;
import com.dstc.security.common.AlgorithmId;
import com.dstc.security.common.SubjectPublicKeyInfo;
import java.io.IOException;
import java.math.BigInteger;
import java.security.AlgorithmParameters;
import java.security.Key;
import java.security.PublicKey;
import java.security.interfaces.DSAParams;
import java.security.spec.DSAParameterSpec;
import java.util.Arrays;

public class DSAPublicKey
implements PublicKey,
java.security.interfaces.DSAPublicKey {
    private Asn1 asn1 = null;
    private BigInteger y;
    private DSAParameterSpec dsaParamsSpec;

    protected DSAPublicKey(BigInteger bigInteger, DSAParams dSAParams) {
        this.y = bigInteger;
        this.asn1 = new com.dstc.security.asn1.Integer(bigInteger);
        this.dsaParamsSpec = new DSAParameterSpec(dSAParams.getP(), dSAParams.getQ(), dSAParams.getG());
    }

    protected DSAPublicKey(byte[] byArray, DSAParameterSpec dSAParameterSpec) throws Asn1Exception, IOException {
        this.decode(Asn1.getAsn1(byArray));
        this.dsaParamsSpec = dSAParameterSpec;
    }

    private void decode(Asn1 asn1) throws IOException {
        this.asn1 = asn1;
        this.y = ((com.dstc.security.asn1.Integer)asn1).getBigInteger();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof Key) {
            return Arrays.equals(this.getEncoded(), ((Key)object).getEncoded());
        }
        return false;
    }

    public String getAlgorithm() {
        return "DSA";
    }

    public byte[] getEncoded() {
        try {
            AlgorithmParameters algorithmParameters = AlgorithmParameters.getInstance("DSA");
            algorithmParameters.init(this.dsaParamsSpec);
            return new SubjectPublicKeyInfo(new AlgorithmId("1.2.840.10040.4.1", algorithmParameters), this.asn1.getEncoded()).getAsn1().getEncoded();
        }
        catch (Exception exception) {
            throw new RuntimeException(exception.getMessage());
        }
    }

    public String getFormat() {
        return "X.509";
    }

    public DSAParams getParams() {
        return this.dsaParamsSpec;
    }

    public BigInteger getY() {
        return this.y;
    }

    public String toString() {
        byte[] byArray = null;
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < 4) {
            if (n == 0) {
                stringBuffer.append("DSA Param P: \n            ");
                byArray = this.dsaParamsSpec.getP().toByteArray();
            } else if (n == 1) {
                stringBuffer.append("\nDSA Param Q: \n            ");
                byArray = this.dsaParamsSpec.getQ().toByteArray();
            } else if (n == 2) {
                stringBuffer.append("\nDSA Param G: \n            ");
                byArray = this.dsaParamsSpec.getG().toByteArray();
            } else {
                stringBuffer.append("\nPublic Y: \n            ");
                byArray = this.getY().toByteArray();
            }
            int n2 = 0;
            while (n2 < byArray.length) {
                if (n2 > 0 && n2 % 20 == 0) {
                    stringBuffer.append("\n            ");
                }
                if (byArray[n2] < 16 && byArray[n2] >= 0) {
                    stringBuffer.append("0" + Integer.toHexString(byArray[n2] & 0xFF) + " ");
                } else {
                    stringBuffer.append(String.valueOf(Integer.toHexString(byArray[n2] & 0xFF)) + " ");
                }
                ++n2;
            }
            ++n;
        }
        return stringBuffer.toString();
    }
}

