/*
 * Decompiled with CFR 0.152.
 */
package com.dstc.security.provider;

import com.dstc.security.provider.BlockCipher;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.spec.AlgorithmParameterSpec;

public final class IDEA
extends BlockCipher {
    private int[] encKeys;
    private int[] decKeys;

    public IDEA() {
        this.blockSize = 8;
    }

    protected void decryptBlock(byte[] byArray, byte[] byArray2) {
        this.idea(byArray, 0, byArray2, 0, this.decKeys);
    }

    protected void encryptBlock(byte[] byArray, byte[] byArray2) {
        this.idea(byArray, 0, byArray2, 0, this.encKeys);
    }

    private int[] generateDecKeys() {
        int[] nArray = new int[52];
        int n = 4;
        int n2 = 51;
        nArray[n2--] = IDEA.mulInv(this.encKeys[3]);
        nArray[n2--] = -this.encKeys[2];
        nArray[n2--] = -this.encKeys[1];
        nArray[n2--] = IDEA.mulInv(this.encKeys[0]);
        int n3 = 1;
        while (n3 < 8) {
            nArray[n2--] = this.encKeys[n + 1];
            nArray[n2--] = this.encKeys[n];
            nArray[n2--] = IDEA.mulInv(this.encKeys[n + 5]);
            nArray[n2--] = -this.encKeys[n + 3];
            nArray[n2--] = -this.encKeys[n + 4];
            nArray[n2--] = IDEA.mulInv(this.encKeys[n + 2]);
            ++n3;
            n += 6;
        }
        nArray[n2--] = this.encKeys[n + 1];
        nArray[n2--] = this.encKeys[n];
        nArray[n2--] = IDEA.mulInv(this.encKeys[n + 5]);
        nArray[n2--] = -this.encKeys[n + 4];
        nArray[n2--] = -this.encKeys[n + 3];
        nArray[n2--] = IDEA.mulInv(this.encKeys[n + 2]);
        return nArray;
    }

    private int[] generateEncKeys(byte[] byArray) {
        int[] nArray = new int[52];
        nArray[0] = (byArray[0] & 0xFF) << 8 | byArray[1] & 0xFF;
        nArray[1] = (byArray[2] & 0xFF) << 8 | byArray[3] & 0xFF;
        nArray[2] = (byArray[4] & 0xFF) << 8 | byArray[5] & 0xFF;
        nArray[3] = (byArray[6] & 0xFF) << 8 | byArray[7] & 0xFF;
        nArray[4] = (byArray[8] & 0xFF) << 8 | byArray[9] & 0xFF;
        nArray[5] = (byArray[10] & 0xFF) << 8 | byArray[11] & 0xFF;
        nArray[6] = (byArray[12] & 0xFF) << 8 | byArray[13] & 0xFF;
        nArray[7] = (byArray[14] & 0xFF) << 8 | byArray[15] & 0xFF;
        int n = 0;
        int n2 = 0;
        int n3 = 8;
        while (n3 < 52) {
            nArray[++n + 7 + n2] = nArray[(n & 7) + n2] << 9 | nArray[(n + 1 & 7) + n2] >>> 7 & 0x1FF;
            n2 += n & 8;
            n &= 7;
            ++n3;
        }
        return nArray;
    }

    private void idea(byte[] byArray, int n, byte[] byArray2, int n2, int[] nArray) {
        int n3;
        int n4 = (byArray[n++] & 0xFF) << 8 | byArray[n++] & 0xFF;
        int n5 = (byArray[n++] & 0xFF) << 8 | byArray[n++] & 0xFF;
        int n6 = (byArray[n++] & 0xFF) << 8 | byArray[n++] & 0xFF;
        int n7 = (byArray[n++] & 0xFF) << 8 | byArray[n] & 0xFF;
        int n8 = 0;
        int n9 = 8;
        while (n9-- > 0) {
            n4 = IDEA.mulmod(n4, nArray[n8++]);
            n5 += nArray[n8++];
            int n10 = n8++;
            n7 = IDEA.mulmod(n7, nArray[n8++]);
            int n11 = n6 += nArray[n10];
            n6 = IDEA.mulmod(n4 ^ n6, nArray[n8++]);
            n3 = n5;
            n5 = IDEA.mulmod(n6 + (n5 ^ n7), nArray[n8++]);
            n4 ^= n5;
            n7 ^= (n6 += n5);
            n5 ^= n11;
            n6 ^= n3;
        }
        n3 = IDEA.mulmod(n4, nArray[n8++]);
        byArray2[n2++] = (byte)(n3 >>> 8);
        byArray2[n2++] = (byte)n3;
        n3 = n6 + nArray[n8++];
        byArray2[n2++] = (byte)(n3 >>> 8);
        byArray2[n2++] = (byte)n3;
        n3 = n5 + nArray[n8++];
        byArray2[n2++] = (byte)(n3 >>> 8);
        byArray2[n2++] = (byte)n3;
        n3 = IDEA.mulmod(n7, nArray[n8]);
        byArray2[n2++] = (byte)(n3 >>> 8);
        byArray2[n2] = (byte)n3;
    }

    protected void initialize(Key key, AlgorithmParameterSpec algorithmParameterSpec) throws IllegalStateException, InvalidKeyException {
        if (!key.getAlgorithm().equals("IDEA")) {
            throw new InvalidKeyException("Not an IDEA Key");
        }
        this.encKeys = this.generateEncKeys(key.getEncoded());
        this.decKeys = this.generateDecKeys();
    }

    private static int mulInv(int n) {
        int n2 = n & 0xFFFF;
        if (n2 <= 1) {
            return n2;
        }
        int n3 = 65537 / n2;
        int n4 = 65537 % n2;
        if (n4 == 1) {
            return 1 - n3;
        }
        int n5 = 1;
        do {
            int n6 = n2 / n4;
            n5 += n6 * n3;
            if ((n2 %= n4) == 1) {
                return n5;
            }
            n6 = n4 / n2;
            n3 += n6 * n5;
        } while ((n4 %= n2) != 1);
        return 1 - n3;
    }

    private static int mulmod(int n, int n2) {
        n2 &= 0xFFFF;
        if ((n &= 0xFFFF) != 0) {
            if (n2 != 0) {
                int n3 = n * n2;
                return n2 - n + ((n2 = n3 & 0xFFFF) < (n = n3 >>> 16) ? 1 : 0);
            }
            return 1 - n;
        }
        return 1 - n2;
    }
}

