/*
 * Decompiled with CFR 0.152.
 */
package com.dstc.security.provider;

import com.dstc.security.asn1.Asn1;
import com.dstc.security.asn1.Asn1Exception;
import com.dstc.security.asn1.Explicit;
import com.dstc.security.asn1.OctetString;
import com.dstc.security.asn1.Oid;
import com.dstc.security.asn1.Sequence;
import com.dstc.security.common.OID;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.ProviderException;

public class KEKGenerator {
    private Asn1 otherInfo = null;
    private Asn1 keySpecificInfo = null;
    private Asn1 suppPubInfo = null;
    private Asn1 partyAInfo = null;
    private byte[] input = null;
    private String algOid;
    private int counter = 1;
    private int kekLength;
    private MessageDigest md;

    public KEKGenerator(byte[] byArray, String string, int n) {
        this.input = byArray;
        this.algOid = OID.getAlgOid(string);
        this.kekLength = n;
        this.suppPubInfo = new Explicit(128, 2);
        this.suppPubInfo.add(new OctetString(this.intToBytes(n)));
        try {
            this.md = MessageDigest.getInstance("SHA");
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new ProviderException(noSuchAlgorithmException.getMessage());
        }
    }

    public byte[] generateKeyMaterial() throws IOException {
        try {
            int n = (int)Math.ceil((double)this.kekLength / 160.0);
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            int n2 = 0;
            while (n2 < n) {
                this.md.update(this.input);
                this.md.update(this.otherInfoDER());
                this.incrementCount();
                byteArrayOutputStream.write(this.md.digest());
                ++n2;
            }
            return byteArrayOutputStream.toByteArray();
        }
        catch (Asn1Exception asn1Exception) {
            throw new RuntimeException(asn1Exception.getMessage());
        }
    }

    void incrementCount() {
        ++this.counter;
    }

    private byte[] intToBytes(int n) {
        byte[] byArray = new byte[4];
        int n2 = 0;
        while (n2 < 4) {
            byArray[3 - n2] = (byte)(n & 0xFF);
            n >>>= 8;
            ++n2;
        }
        return byArray;
    }

    private byte[] otherInfoDER() throws Asn1Exception, IOException {
        this.keySpecificInfo = new Sequence();
        this.keySpecificInfo.add(new Oid(this.algOid));
        this.keySpecificInfo.add(new OctetString(this.intToBytes(this.counter)));
        this.otherInfo = new Sequence();
        this.otherInfo.add(this.keySpecificInfo);
        if (this.partyAInfo != null) {
            this.otherInfo.add(this.partyAInfo);
        }
        this.otherInfo.add(this.suppPubInfo);
        return this.otherInfo.getEncoded();
    }

    public void setPartyAInfo(byte[] byArray) {
        this.partyAInfo = new Explicit(128, 0);
        this.partyAInfo.add(new OctetString(byArray));
    }
}

