/*
 * Decompiled with CFR 0.152.
 */
package com.dstc.security.provider;

import com.dstc.security.common.PBEKeyDerivation;
import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidParameterSpecException;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.CipherSpi;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.ShortBufferException;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.PBEParameterSpec;
import javax.crypto.spec.SecretKeySpec;

public abstract class PBECipher
extends CipherSpi {
    protected Cipher cipher = null;
    protected MessageDigest md = null;
    protected String pbeAlgo = null;
    protected String algo = null;
    protected int keyLength = 0;
    protected PBEKeyDerivation deriveKey = null;

    protected byte[] engineDoFinal(byte[] byArray, int n, int n2) throws IllegalBlockSizeException, BadPaddingException {
        return this.cipher.doFinal(byArray, n, n2);
    }

    protected int engineDoFinal(byte[] byArray, int n, int n2, byte[] byArray2, int n3) throws ShortBufferException, IllegalBlockSizeException, BadPaddingException {
        return this.cipher.doFinal(byArray, n, n2, byArray2, n3);
    }

    protected int engineGetBlockSize() {
        return this.cipher.getBlockSize();
    }

    protected byte[] engineGetIV() {
        return this.cipher.getIV();
    }

    protected int engineGetOutputSize(int n) {
        return this.cipher.getOutputSize(n);
    }

    protected AlgorithmParameters engineGetParameters() {
        return null;
    }

    protected void engineInit(int n, Key key, AlgorithmParameters algorithmParameters, SecureRandom secureRandom) throws InvalidAlgorithmParameterException, InvalidKeyException {
        try {
            this.engineInit(n, key, (AlgorithmParameterSpec)algorithmParameters.getParameterSpec(Class.forName("javax.crypto.spec.PBEParameterSpec")), secureRandom);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new RuntimeException("JCE not found: " + classNotFoundException.getMessage());
        }
        catch (InvalidParameterSpecException invalidParameterSpecException) {
            throw new InvalidAlgorithmParameterException(invalidParameterSpecException.getMessage());
        }
    }

    protected void engineInit(int n, Key key, SecureRandom secureRandom) throws InvalidKeyException {
        throw new InvalidKeyException("PBECipher needs PBE parameters");
    }

    protected void engineInit(int n, Key key, AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidAlgorithmParameterException, InvalidKeyException {
        if (!(algorithmParameterSpec instanceof PBEParameterSpec)) {
            throw new InvalidKeyException("Not PBE parameters");
        }
        byte[] byArray = this.deriveKey.generateKey(1, this.md, key, algorithmParameterSpec, this.keyLength / 8);
        byte[] byArray2 = this.deriveKey.generateKey(2, this.md, key, algorithmParameterSpec, 8);
        try {
            SecretKeySpec secretKeySpec = new SecretKeySpec(byArray, this.algo);
            IvParameterSpec ivParameterSpec = new IvParameterSpec(byArray2);
            this.cipher.init(n, (Key)secretKeySpec, ivParameterSpec, secureRandom);
        }
        catch (Exception exception) {
            throw new InvalidKeyException(exception.getMessage());
        }
    }

    protected void engineSetMode(String string) throws NoSuchAlgorithmException {
    }

    protected void engineSetPadding(String string) throws NoSuchPaddingException {
    }

    protected byte[] engineUpdate(byte[] byArray, int n, int n2) {
        return this.cipher.update(byArray, n, n2);
    }

    protected int engineUpdate(byte[] byArray, int n, int n2, byte[] byArray2, int n3) throws ShortBufferException {
        return this.cipher.update(byArray, n, n2, byArray2, n3);
    }
}

