/*
 * Decompiled with CFR 0.152.
 */
package com.dstc.security.provider;

import java.security.InvalidKeyException;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactorySpi;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.SecretKeySpec;

abstract class PBEKeyFactory
extends SecretKeyFactorySpi {
    protected static String alg;

    PBEKeyFactory() {
    }

    protected SecretKey engineGenerateSecret(KeySpec keySpec) throws InvalidKeySpecException {
        if (keySpec instanceof PBEKeySpec) {
            return new SecretKeySpec(this.toPasswordBytes(((PBEKeySpec)keySpec).getPassword()), alg);
        }
        throw new InvalidKeySpecException("Not a PBE key spec");
    }

    protected KeySpec engineGetKeySpec(SecretKey secretKey, Class clazz) throws InvalidKeySpecException {
        throw new UnsupportedOperationException("Not implemented");
    }

    protected SecretKey engineTranslateKey(SecretKey secretKey) throws InvalidKeyException {
        if (secretKey.getAlgorithm().equals(alg)) {
            return new SecretKeySpec(secretKey.getEncoded(), alg);
        }
        throw new InvalidKeyException("Cannot translate this key");
    }

    protected abstract byte[] toPasswordBytes(char[] var1);
}

