/*
 * Decompiled with CFR 0.152.
 */
package com.dstc.security.provider;

import com.dstc.security.asn1.Asn1;
import com.dstc.security.asn1.Asn1Exception;
import com.dstc.security.asn1.Integer;
import com.dstc.security.asn1.OctetString;
import com.dstc.security.asn1.Sequence;
import java.io.IOException;
import java.security.AlgorithmParametersSpi;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidParameterSpecException;
import java.util.Iterator;
import javax.crypto.spec.PBEParameterSpec;

public class PBEParameters
extends AlgorithmParametersSpi {
    private static final String ASN1 = "ASN.1";
    private Asn1 asn1 = null;
    private byte[] salt;
    private int ic;
    static /* synthetic */ Class class$javax$crypto$spec$PBEParameterSpec;

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private void decode(Asn1 asn1) throws IOException {
        this.asn1 = asn1;
        Iterator iterator = asn1.components();
        this.salt = ((OctetString)iterator.next()).getBytes();
        this.ic = ((Integer)iterator.next()).getBigInteger().intValue();
    }

    private void encode() {
        this.asn1 = new Sequence();
        this.asn1.add(new OctetString(this.salt));
        this.asn1.add(new Integer(this.ic));
    }

    protected byte[] engineGetEncoded() throws IOException {
        try {
            return this.asn1.getEncoded();
        }
        catch (Asn1Exception asn1Exception) {
            throw new IOException(asn1Exception.getMessage());
        }
    }

    protected byte[] engineGetEncoded(String string) throws IOException {
        if (string == null) {
            return this.engineGetEncoded();
        }
        if (string.equals(ASN1)) {
            return this.engineGetEncoded();
        }
        throw new RuntimeException("Unsupported format " + string);
    }

    protected AlgorithmParameterSpec engineGetParameterSpec(Class clazz) throws InvalidParameterSpecException {
        if (!clazz.equals(class$javax$crypto$spec$PBEParameterSpec != null ? class$javax$crypto$spec$PBEParameterSpec : (class$javax$crypto$spec$PBEParameterSpec = PBEParameters.class$("javax.crypto.spec.PBEParameterSpec")))) {
            throw new InvalidParameterSpecException("Bad parameter specification " + clazz.getName());
        }
        return new PBEParameterSpec(this.salt, this.ic);
    }

    protected void engineInit(AlgorithmParameterSpec algorithmParameterSpec) throws InvalidParameterSpecException {
        if (!(algorithmParameterSpec instanceof PBEParameterSpec)) {
            throw new InvalidParameterSpecException("Not a PBE param spec");
        }
        this.salt = ((PBEParameterSpec)algorithmParameterSpec).getSalt();
        this.ic = ((PBEParameterSpec)algorithmParameterSpec).getIterationCount();
        this.encode();
    }

    protected void engineInit(byte[] byArray) throws IOException {
        try {
            this.decode(Asn1.getAsn1(byArray));
        }
        catch (Asn1Exception asn1Exception) {
            throw new IOException(asn1Exception.toString());
        }
    }

    protected void engineInit(byte[] byArray, String string) throws IOException {
        if (string != null && !string.equals(ASN1)) {
            throw new RuntimeException("Unsupported format " + string);
        }
        this.engineInit(byArray);
    }

    protected String engineToString() {
        StringBuffer stringBuffer = new StringBuffer("PBE Parameters");
        return stringBuffer.toString();
    }
}

