/*
 * Decompiled with CFR 0.152.
 */
package com.dstc.security.provider;

import com.dstc.security.common.PKCS12KeyDerivation;
import com.dstc.security.provider.PBECipher;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.Cipher;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.PBEParameterSpec;
import javax.crypto.spec.RC2ParameterSpec;
import javax.crypto.spec.SecretKeySpec;

public final class PBEwithSHAAnd40BitRC2_CBC
extends PBECipher {
    public PBEwithSHAAnd40BitRC2_CBC() {
        try {
            this.cipher = Cipher.getInstance("RC2/CBC/PKCS5Padding");
            this.md = MessageDigest.getInstance("SHA");
            this.algo = "RC2";
            this.pbeAlgo = "PBEwithSHAand40BitRC2-CBC";
            this.keyLength = 40;
            this.deriveKey = new PKCS12KeyDerivation();
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new RuntimeException("Internal error: " + noSuchAlgorithmException.getMessage());
        }
        catch (NoSuchPaddingException noSuchPaddingException) {
            throw new RuntimeException("Internal error: " + noSuchPaddingException.getMessage());
        }
    }

    protected void engineInit(int n, Key key, AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidAlgorithmParameterException, InvalidKeyException {
        if (!(algorithmParameterSpec instanceof PBEParameterSpec)) {
            throw new InvalidKeyException("Not PBE parameters");
        }
        byte[] byArray = this.deriveKey.generateKey(1, this.md, key, algorithmParameterSpec, this.keyLength / 8);
        byte[] byArray2 = this.deriveKey.generateKey(2, this.md, key, algorithmParameterSpec, 8);
        SecretKeySpec secretKeySpec = new SecretKeySpec(byArray, this.algo);
        RC2ParameterSpec rC2ParameterSpec = new RC2ParameterSpec(this.keyLength, byArray2);
        this.cipher.init(n, (Key)secretKeySpec, rC2ParameterSpec, secureRandom);
    }
}

