/*
 * Decompiled with CFR 0.152.
 */
package com.dstc.security.provider;

import com.dstc.security.common.PrivateKeyInfo;
import com.dstc.security.common.SubjectPublicKeyInfo;
import com.dstc.security.provider.RSAPrivateCrtKey;
import com.dstc.security.provider.RSAPrivateKey;
import com.dstc.security.provider.RSAPublicKey;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyFactorySpi;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.RSAPrivateCrtKeySpec;
import java.security.spec.RSAPrivateKeySpec;
import java.security.spec.RSAPublicKeySpec;
import java.security.spec.X509EncodedKeySpec;

public class RSAKeyFactory
extends KeyFactorySpi {
    static /* synthetic */ Class class$java$security$spec$X509EncodedKeySpec;
    static /* synthetic */ Class class$java$security$spec$RSAPublicKeySpec;
    static /* synthetic */ Class class$java$security$spec$PKCS8EncodedKeySpec;
    static /* synthetic */ Class class$java$security$spec$RSAPrivateKeySpec;
    static /* synthetic */ Class class$java$security$spec$RSAPrivateCrtKeySpec;

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    protected PrivateKey engineGeneratePrivate(KeySpec keySpec) throws InvalidKeySpecException {
        if (keySpec instanceof RSAPrivateCrtKeySpec) {
            RSAPrivateCrtKeySpec rSAPrivateCrtKeySpec = (RSAPrivateCrtKeySpec)keySpec;
            return new RSAPrivateCrtKey(rSAPrivateCrtKeySpec.getModulus(), rSAPrivateCrtKeySpec.getPublicExponent(), rSAPrivateCrtKeySpec.getPrivateExponent(), rSAPrivateCrtKeySpec.getPrimeP(), rSAPrivateCrtKeySpec.getPrimeQ());
        }
        if (keySpec instanceof RSAPrivateKeySpec) {
            RSAPrivateKeySpec rSAPrivateKeySpec = (RSAPrivateKeySpec)keySpec;
            return new RSAPrivateKey(rSAPrivateKeySpec.getModulus(), rSAPrivateKeySpec.getPrivateExponent());
        }
        if (keySpec instanceof PKCS8EncodedKeySpec) {
            try {
                PrivateKeyInfo privateKeyInfo = new PrivateKeyInfo(((PKCS8EncodedKeySpec)keySpec).getEncoded());
                return new RSAPrivateCrtKey(privateKeyInfo.getEncodedKey());
            }
            catch (Exception exception) {
                throw new InvalidKeySpecException("Bad key spec: " + exception.getMessage());
            }
        }
        throw new InvalidKeySpecException("Cannot convert to RSA Private Key");
    }

    protected PublicKey engineGeneratePublic(KeySpec keySpec) throws InvalidKeySpecException {
        if (keySpec instanceof RSAPublicKeySpec) {
            RSAPublicKeySpec rSAPublicKeySpec = (RSAPublicKeySpec)keySpec;
            return new RSAPublicKey(rSAPublicKeySpec.getModulus(), rSAPublicKeySpec.getPublicExponent());
        }
        if (keySpec instanceof X509EncodedKeySpec) {
            try {
                SubjectPublicKeyInfo subjectPublicKeyInfo = new SubjectPublicKeyInfo(((X509EncodedKeySpec)keySpec).getEncoded());
                return new RSAPublicKey(subjectPublicKeyInfo.getEncodedKey());
            }
            catch (Exception exception) {
                throw new InvalidKeySpecException("Bad key spec: " + exception.getMessage());
            }
        }
        throw new InvalidKeySpecException("Cannot convert to RSA Public Key");
    }

    protected KeySpec engineGetKeySpec(Key key, Class clazz) throws InvalidKeySpecException {
        if (!key.getAlgorithm().equals("RSA")) {
            throw new InvalidKeySpecException("Not an RSA Key");
        }
        if (key instanceof PublicKey) {
            if (clazz.equals(class$java$security$spec$X509EncodedKeySpec != null ? class$java$security$spec$X509EncodedKeySpec : (class$java$security$spec$X509EncodedKeySpec = RSAKeyFactory.class$("java.security.spec.X509EncodedKeySpec")))) {
                return new X509EncodedKeySpec(key.getEncoded());
            }
            if (clazz.equals(class$java$security$spec$RSAPublicKeySpec != null ? class$java$security$spec$RSAPublicKeySpec : (class$java$security$spec$RSAPublicKeySpec = RSAKeyFactory.class$("java.security.spec.RSAPublicKeySpec")))) {
                java.security.interfaces.RSAPublicKey rSAPublicKey = (java.security.interfaces.RSAPublicKey)key;
                return new RSAPublicKeySpec(rSAPublicKey.getModulus(), rSAPublicKey.getPublicExponent());
            }
            throw new InvalidKeySpecException("Key and keyspec mismatch");
        }
        if (clazz.equals(class$java$security$spec$PKCS8EncodedKeySpec != null ? class$java$security$spec$PKCS8EncodedKeySpec : (class$java$security$spec$PKCS8EncodedKeySpec = RSAKeyFactory.class$("java.security.spec.PKCS8EncodedKeySpec")))) {
            return new PKCS8EncodedKeySpec(key.getEncoded());
        }
        if (clazz.equals(class$java$security$spec$RSAPrivateKeySpec != null ? class$java$security$spec$RSAPrivateKeySpec : (class$java$security$spec$RSAPrivateKeySpec = RSAKeyFactory.class$("java.security.spec.RSAPrivateKeySpec")))) {
            java.security.interfaces.RSAPrivateKey rSAPrivateKey = (java.security.interfaces.RSAPrivateKey)key;
            return new RSAPrivateKeySpec(rSAPrivateKey.getModulus(), rSAPrivateKey.getPrivateExponent());
        }
        if (clazz.equals(class$java$security$spec$RSAPrivateCrtKeySpec != null ? class$java$security$spec$RSAPrivateCrtKeySpec : (class$java$security$spec$RSAPrivateCrtKeySpec = RSAKeyFactory.class$("java.security.spec.RSAPrivateCrtKeySpec")))) {
            if (!(key instanceof java.security.interfaces.RSAPrivateCrtKey)) {
                throw new InvalidKeySpecException("Key and keyspec mismatch");
            }
            java.security.interfaces.RSAPrivateCrtKey rSAPrivateCrtKey = (java.security.interfaces.RSAPrivateCrtKey)key;
            return new RSAPrivateCrtKeySpec(rSAPrivateCrtKey.getModulus(), rSAPrivateCrtKey.getPublicExponent(), rSAPrivateCrtKey.getPrivateExponent(), rSAPrivateCrtKey.getPrimeP(), rSAPrivateCrtKey.getPrimeQ(), rSAPrivateCrtKey.getPrimeExponentP(), rSAPrivateCrtKey.getPrimeExponentQ(), rSAPrivateCrtKey.getCrtCoefficient());
        }
        throw new InvalidKeySpecException("Key and keyspec mismatch");
    }

    protected Key engineTranslateKey(Key key) throws InvalidKeyException {
        if (key == null) {
            return null;
        }
        if (key instanceof java.security.interfaces.RSAPublicKey) {
            java.security.interfaces.RSAPublicKey rSAPublicKey = (java.security.interfaces.RSAPublicKey)key;
            return new RSAPublicKey(rSAPublicKey.getModulus(), rSAPublicKey.getPublicExponent());
        }
        if (key instanceof java.security.interfaces.RSAPrivateKey) {
            java.security.interfaces.RSAPrivateKey rSAPrivateKey = (java.security.interfaces.RSAPrivateKey)key;
            return new RSAPrivateKey(rSAPrivateKey.getModulus(), rSAPrivateKey.getPrivateExponent());
        }
        if (key instanceof java.security.interfaces.RSAPrivateCrtKey) {
            java.security.interfaces.RSAPrivateCrtKey rSAPrivateCrtKey = (java.security.interfaces.RSAPrivateCrtKey)key;
            return new RSAPrivateCrtKey(rSAPrivateCrtKey.getModulus(), rSAPrivateCrtKey.getPublicExponent(), rSAPrivateCrtKey.getPrivateExponent(), rSAPrivateCrtKey.getPrimeP(), rSAPrivateCrtKey.getPrimeQ(), rSAPrivateCrtKey.getPrimeExponentP(), rSAPrivateCrtKey.getPrimeExponentQ(), rSAPrivateCrtKey.getCrtCoefficient());
        }
        throw new InvalidKeyException("Cannot translate this key");
    }
}

